#ifndef (Quick) #declare Quick=0; #end

#if (Quick=1)
  #declare T_Rock1 = texture { pigment { colour rgb <0.3,0.2,0.1> }}
  #declare T_Rock2 = texture { pigment { colour rgb <0.45,0.35,0.25> }}
#else
  #declare P_Rock1 = pigment { bozo colour_map { [0.0 rgb <0.4,0.3,0.2>][1.0 rgb <0.2,0.1,0.0>] } scale <20,1,20> warp { turbulence 1.0 }}
  #declare P_Rock2 = pigment { granite colour_map { [0.0 rgb <0.2,0.2,0.2>][1.0 rgb <0.05,0.05,0.05>] } scale 0.5 }
  #declare P_Rock3 = pigment { bozo pigment_map { [0.0 P_Rock2][0.7 P_Rock1 scale 4] } warp { turbulence 0.75 omega 1.0 } scale 0.25 }
  #declare T_Rock1 = texture { pigment { P_Rock3 } finish { ambient 0 }}
  #declare T_Rock2 = texture { pigment { bozo colour_map { [0.0 rgb <0.5,0.4,0.3>][1.0 rgb <0.4,0.3,0.2>]} scale 0.25 }}
#end


#declare Rock1 = height_field { gif "rock1.gif" water_level 1/255
  translate <-0.5,-1/255,-0.5>
  scale <50,15,50>
  rotate y*25
}

#declare Rock2 = height_field { gif "rock2.gif" water_level 1/255
  rotate x*-90
  translate <-0.5,-1/255,-0.5>
  scale <105,120,25>
  rotate y*25
}

#declare Rock3 = height_field { gif "rock3.gif" water_level 1/255
  translate <-1,-1/255,-0.5>
  scale <333,30,133>
  rotate y*15
  texture { T_Rock2 }
//  pigment { colour rgb <0.5,0.5,0.5> }
}

#declare Boulders1 = union {
  object { Rock2 translate <10,0,285> }
  object { Rock1 translate <62,0,245> }
  box { <-45,0,284>, <-100,100,290> }
  texture { T_Rock1 rotate z*15 }
  translate <-10,0,20>
}

#declare Boulders2 = union {
  height_field { gif "rock1.gif" water_level 1/255 smooth
    translate <-0.5,-1/255,-0.5>
    scale <100,50,100>
    rotate <0,115,30>
    translate <100,0,100>
    texture { T_Rock1 rotate <40,15,0> }
  }
  height_field { gif "rock1.gif" water_level 1/255
    translate <-0.5,-1/255,-0.5>
    scale <85,25,75>
    rotate y*180
    translate <110,0,140>
    texture { T_Rock1 }
  }
  height_field { gif "rock1.gif" water_level 1/255
    translate <-0.5,-1/255,-0.5>
    scale <90,50,90>
    rotate <0,270,0>
    translate <120,0,60>
    texture { T_Rock1 }
  }
}

#declare Boulders = union {
  object { Boulders1 }
  object { Boulders2 }
  object { Rock3 translate <400,0,225> }
}

#ifndef (FullScene)
  object { Boulders }
  plane { y, 0 pigment { colour rgb <0.8,0.7,0.6> }}
  camera { location <0.001,75,-0.001> look_at <0,125,1000> rotate y*25 }
  light_source { <-5000,10000, 10000> colour rgb 0.75 }
  light_source { <-1000,1,-10000> colour rgb 0.66 }
  light_source { <-10000,10000,-10000> colour rgb 0.66 }
  light_source { <-10000,10000,0> colour rgb 0.75 }
  background { colour rgb <0.7,0.7,0.7> }
#end
