#ifndef (Quick) #declare Quick=0; #end

#if (Quick=1)
  #declare P_TankRing         = pigment { colour rgb <0.55,0.1,0.0> }
  #declare T_TankBody         = texture { pigment { colour rgb <0.6,0.7,0.7> }}
  #declare T_TankPipe         = texture { pigment { colour rgb <0.9,1,0.9> }}
  #declare T_Silo_BrightMetal = texture { pigment { colour rgb <0.55,0.57,0.55> }}
  #declare T_Silo_Rusty       = texture { pigment { colour rgb <0.5,0.4,0.3> }}
  #declare T_Silo_Rusty2      = texture { pigment { colour rgb <0.3,0.2,0.1> }}
  #declare T_Silo_RustyBright = texture { T_Silo_BrightMetal }
  #declare T_Silo_AquaMetal   = texture { pigment { colour rgb <0.2,0.4,0.35> }}
  #declare T_Silo_RustyAqua   = texture { T_Silo_AquaMetal }
  #declare T_Silo_BlackMetal  = texture { pigment { colour rgb <0,0,0> }}
  #declare T_Silo_DullMetal   = texture { pigment { colour rgb <0.415,0.415,0.415> }}
  #declare T_Silo_RustyDull   = texture { T_Silo_DullMetal }
  #declare T_Silo_DullCyan    = texture { pigment { colour rgb <0.4,0.5,0.6> }}
  #declare T_Silo_RustyCyan   = texture { pigment { colour rgb <0.4,0.5,0.6> }}
  #declare T_Silo_RustySky    = texture { pigment { colour rgb <0.6,0.7,0.8> }}
  #declare T_Silo_Copper      = texture { pigment { colour rgb <1,0.6,0.1> }}
  #declare T_WhitePipe        = texture { pigment { colour rgb <0.9,0.9,0.9> }}
  #declare T_DirtyWhitePipe   = texture { pigment { colour rgb <0.8,0.8,0.8> }}
  #declare T_Silo_Tan         = texture { pigment { colour rgb <0.7,0.6,0.5> }}
#else
  #declare P_TankBody1 = pigment { bozo colour_map { [0.0 rgb <0.7,0.7,0.8>][1.0 rgb <0.5,0.7,0.6>]} scale 3 }
  #declare P_TankBody2 = pigment { bozo colour_map { [0.0 rgb <0.5,0.4,0.3>][1.0 rgb <0.7,0.6,0.5>]}}
  #declare P_TankRing  = pigment { bozo colour_map { [0.0 rgb <0.7,0.3,0.0>][1.0 rgb <0.4,0.05,0.0>]} scale 0.5 }
  #declare P_TankPipe  = pigment { bozo colour_map { [0.0 rgb <1,1,1>][0.1 rgb <0.8,1,0.8>] } scale 10 }
  #declare P_TankPipe2 = pigment { bozo colour_map { [0.0 rgb <1,1,1>][0.1 rgb <0.7,0.7,0.7>] } scale 10 }
  #declare P_TankPipe3 = pigment { bozo colour_map { [0.0 rgb <1,1,1>][0.1 rgb <0.9,0.9,0.9>] } scale 10 }
  #declare P_Silo_Cyan = pigment { bozo colour_map { [0.0 rgb <0.4,0.5,0.6>][1.0 rgb <0.5,0.6,0.7>] } scale <0.2,3,0.2> }
  #declare P_Silo_Sky  = pigment { bozo colour_map { [0.0 rgb <0.5,0.6,0.7>][1.0 rgb <0.7,0.8,0.9>] } scale <0.2,3,0.2> }

  #declare F_TankBody1 = finish { reflection 0.4 brilliance 6 ambient 0.1 diffuse 0.6 specular 1.0 roughness 0.05 metallic }
  #declare F_TankBody2 = finish { reflection 0.0 }
  #declare F_ShinyMetal  = finish { reflection 0.4 brilliance 6 ambient 0.1 diffuse 0.6 specular 1.0 roughness 0.02 metallic }
  #declare F_ShinyMetal2 = finish { reflection 0.1 brilliance 6 ambient 0.1 diffuse 0.6 specular 1.0 roughness 0.02 metallic }
  #declare F_ShinyMetal3 = finish { reflection 0.2 brilliance 6 ambient 0.1 diffuse 0.6 specular 1.0 roughness 0.005 metallic }

  #declare T_TankBody1        = texture { pigment { P_TankBody1 } finish { F_TankBody1 } normal { bumps 0.1 scale 0.3 }}
  #declare T_TankBody2        = texture { pigment { P_TankBody2 } finish { F_TankBody2 } normal { bumps 0.1 scale 0.3 }}
  #declare T_TankBody         = texture { gradient y texture_map { [0.80 T_TankBody1][1.00 T_TankBody2] } warp { turbulence y*0.5 } scale <0.1,1,0.1> translate y*-0.5 scale 40 }
  #declare T_TankPipe         = texture { pigment { P_TankPipe } finish { ambient 0.4 specular 0.8 roughness 0.05 }}
  #declare T_Silo_BrightMetal = texture { pigment { colour rgb <0.55,0.57,0.55> } finish { F_ShinyMetal } normal { bumps 0.1 scale <10,0.001,10> }}
  #declare T_Silo_Rusty       = texture { pigment { bozo colour_map { [0.0 rgb <0.4,0.3,0.2>][1.0 rgb <0.6,0.5,0.4>]} } normal { bumps 0.4 } scale 0.25 }
  #declare T_Silo_Rusty2      = texture { pigment { bozo colour_map { [0.0 rgb <0.2,0.1,0.0>][1.0 rgb <0.4,0.3,0.2>]} } normal { bumps 0.4 } scale 0.25 }
  #declare T_Silo_RustyBright = texture { gradient y texture_map { [0.75 T_Silo_BrightMetal][0.95 T_Silo_Rusty] } warp { turbulence <0,0.4,0> } scale <0.05,1,0.05> }
  #declare T_Silo_AquaMetal   = texture { pigment { colour rgb <0.2,0.4,0.35> } finish { F_ShinyMetal2 }}
  #declare T_Silo_RustyAqua   = texture { gradient y texture_map { [0.75 T_Silo_AquaMetal][0.95 T_Silo_Rusty2] } warp { turbulence <0,0.4,0> } scale <0.05,1,0.05> }
  #declare T_Silo_BlackMetal  = texture { pigment { colour rgb <0,0,0> } finish { F_ShinyMetal2 }}
  #declare T_Silo_DullMetal   = texture { pigment { bozo colour_map { [0.0 rgb <0.4,0.4,0.4>][1.0 rgb <0.45,0.45,0.45>] } scale <2,10,2> } finish { F_ShinyMetal3 }}
  #declare T_Silo_RustyDull   = texture { gradient y texture_map { [0.75 T_Silo_DullMetal][0.95 T_Silo_Rusty2] } warp { turbulence <0,0.4,0> } scale <0.05,1,0.05> }
  #declare T_Silo_DullCyan    = texture { pigment { P_Silo_Cyan } finish { F_ShinyMetal2 }}
  #declare T_Silo_RustyCyan   = texture { gradient y texture_map { [0.75 T_Silo_DullCyan][0.95 T_Silo_Rusty2] } warp { turbulence <0,0.4,0> } scale <0.05,1,0.05> }
  #declare T_Silo_SkyBlue     = texture { pigment { P_Silo_Sky } finish { F_ShinyMetal3 }}
  #declare T_Silo_RustySky    = texture { gradient y texture_map { [0.75 T_Silo_SkyBlue][0.95 T_Silo_Rusty2] } warp { turbulence <0,0.4,0> } scale <0.05,1,0.05> }
  #declare T_Silo_Copper      = texture { pigment { colour rgb <1,0.6,0.1> } finish { F_ShinyMetal3 }}
  #declare T_WhitePipe        = texture { pigment { P_TankPipe3 }}
  #declare T_DirtyWhitePipe   = texture { pigment { P_TankPipe2 }}
  #declare T_Silo_Tan         = texture { pigment { bozo colour_map { [0.0 rgb <0.8,0.7,0.6>][1.0 rgb <0.6,0.5,0.4>] }}}
#end


#declare Tank_Strut = prism { linear_spline linear_sweep -87, -88, 13,
  <-3,-20>, <-3,34>, <3,34>, <3,-20>, <2,-20>, <2,32>, <0.5,32>, <0.5,-20>,
  <-0.5,-20>, <-0.5,32>, <-2,32>, <-2,-20>, <-3,-20>
  texture { T_Silo_BlackMetal }
  rotate x*-90
}

#declare Tank = union {
  sphere { <0,43,0>, 33 scale <91/33,1,91/33> texture { T_TankBody }}
  cone { <0,42,0>, 91, <0,38,0>, 93 pigment { P_TankRing }}
  #declare foo=0;
  #while (foo < 360)
    object { Tank_Strut rotate y*foo }
    #declare foo=foo+36;
  #end

  cylinder { <-71.5,62,0>, <-71.5,68,0>, 0.4 texture { T_Silo_BlackMetal } rotate y*-15 }
  cylinder { <-71.5,62,0>, <-71.5,68,0>, 0.4 texture { T_Silo_BlackMetal } rotate y*-25 }
  sphere { <-72,63,0>, 1 texture { T_Silo_BlackMetal } rotate y*-47 }
  sphere { <-72,63,0>, 1 texture { T_Silo_BlackMetal } rotate y*-52 }
  cylinder { <-71.5,62,0>, <-71.5,67,0>, 0.6 texture { T_Silo_BlackMetal } rotate y*-57 }
  cylinder { <-71.5,62,0>, <-71.5,67,0>, 0.6 texture { T_Silo_BlackMetal } rotate y*-67 }

  cylinder { <-87.5,-20,0>, <-87.5,37,0>, 0.5 texture { T_TankPipe }}
  translate y*15
  scale 4
}

#declare Silo1 = union {
  cylinder { <0,0,0>, <0,300,0>, 45 texture { T_Silo_RustyBright scale <100,350,100> }}
  cylinder { <0,250,0>, <0,255,0>, 45.001 texture { T_Silo_BlackMetal }}
  torus { 45, 5 texture { T_Silo_AquaMetal } translate y*300 }
  cylinder { <0,300,0>, <0,400,0>, 45 texture { T_Silo_RustyBright scale <100,100,100> rotate y*180 translate y*300 }}
  torus { 45, 5 texture { T_Silo_AquaMetal } translate y*400 }
  cylinder { <0,400,0>, <0,550,0>, 45 texture { T_Silo_RustyBright scale <100,175,100> rotate y*250 translate y*400 }}
  torus { 45, 5 texture { T_Silo_AquaMetal } translate y*550 }
  cylinder { <0,550,0>, <0,600,0>, 45 texture { T_Silo_RustyBright scale <100,50,100> rotate y*78 translate y*550 }}
  torus { 45, 5 texture { T_Silo_AquaMetal } translate y*600 }
  sphere { <0,0,0>, 45 scale <1,0.75,1> translate y*600 texture { T_Silo_AquaMetal }}
  torus { 15, 5 texture { T_Silo_AquaMetal } translate y*625 }
  torus { 15, 5 texture { T_Silo_AquaMetal } translate y*635 }
  torus { 15, 5 texture { T_Silo_AquaMetal } translate y*645 }
  sphere { <0,660,0>, 10 texture { T_Silo_AquaMetal }}
  cylinder { <0,0,-50>, <0,615,-50>, 1.5 texture { T_Silo_BlackMetal }}
  sphere { <0,615,-50>, 1.5 texture { T_Silo_BlackMetal }}
  cylinder { <0,615,-50>, <0,615,0>, 1.5 texture { T_Silo_BlackMetal }}
  scale 1.8
}

#declare Silo2 = union {
  cylinder { <0,0,0>, <0,400,0>, 40 texture { T_Silo_DullMetal }}
  cylinder { <0,400,0>, <0,550,0>, 40 texture { T_Silo_RustyDull scale <100,300,100> translate <200,275,0> }}
  cylinder { <0,350,0>, <0,360,0>, 40.001 texture { T_Silo_RustyBright scale <100,10,100> translate y*350 }}
  cylinder { <0,500,0>, <0,505,0>, 40.001 texture { T_Silo_BlackMetal }}
  scale 1.8
}

#declare Silo3 = union {
  cylinder { <0,-10,0>, <0,600,0>, 20 texture { T_Silo_DullCyan }}
  cylinder { <0,600,0>, <0,770,0>, 20 texture { T_Silo_RustyCyan scale <50,170,50> translate y*600 }}
  cylinder { <0,695,0>, <0,700,0>, 20.001 texture { T_Silo_Copper }}
  cylinder { <0,655,0>, <0,645,0>, 20.001 texture { T_Silo_AquaMetal }}
  cylinder { <0,525,0>, <0,515,0>, 20.001 texture { T_Silo_AquaMetal }}
  cylinder { <0,395,0>, <0,385,0>, 20.001 texture { T_Silo_AquaMetal }}
  cylinder { <0,345,0>, <0,335,0>, 20.001 texture { T_Silo_AquaMetal }}
  torus { 20, 5 translate y*755 texture { T_Silo_AquaMetal }}
  torus { 20, 5 translate y*770 texture { T_Silo_AquaMetal }}
  cylinder { <-10,770,0>, <-10,810,0>, 5 texture { T_Silo_AquaMetal }}
  sphere { <-10,814,0>, 5 texture { T_Silo_RustyBright scale <50,10,50> translate y*809 }}

  cylinder { <20,735,0>, <80,675,0>, 1 texture { T_Silo_AquaMetal }}

  cylinder { <0,675,0>, <620,675,0>, 20 texture { T_Silo_DullCyan }}
  cylinder { <25,675,0>, <35,675,0>, 20.001 texture { T_Silo_BlackMetal }}
  cylinder { <65,675,0>, <75,675,0>, 20.001 texture { T_Silo_BlackMetal }}
  cylinder { <95,675,0>, <105,675,0>, 20.001 texture { T_Silo_BrightMetal }}
  cylinder { <420,675,0>, <410,675,0>, 20.001 texture { T_Silo_Copper }}

  cylinder { <620,-10,0>, <620,600,0>, 20 texture { T_Silo_DullCyan }}
  cylinder { <620,600,0>, <620,730,0>, 20 texture { T_Silo_RustyCyan scale <50,130,50> translate y*600 }}
  cylinder { <620,565,0>, <620,585,0>, 20.001 texture { T_Silo_BrightMetal }}
  cylinder { <620,465,0>, <620,460,0>, 20.001 texture { T_Silo_BlackMetal }}
  cylinder { <620,415,0>, <620,410,0>, 20.001 texture { T_Silo_BlackMetal }}
  cylinder { <620,365,0>, <620,360,0>, 20.001 texture { T_Silo_BlackMetal }}
  torus { 20, 5 translate <620,730,0> texture { T_Silo_AquaMetal }}
  torus { 20, 5 translate <620,740,0> texture { T_Silo_AquaMetal }}
  cylinder { <610,740,0>, <610,770,0>, 5 texture { T_Silo_AquaMetal }}
  sphere { <610,774,0>, 5 texture { T_Silo_RustyBright scale <50,10,50> translate y*771 }}
  translate y*10
  scale 1.8
}

#declare Silo4 = union {
  cylinder { <0,0,0>, <0,350,0>, 30 texture { T_Silo_RustyDull translate z*100 scale <100,350,100> }}
  cylinder { <0,350,0>, <0,450,0>, 30 texture { T_Silo_RustyDull translate z*200 scale 100 translate y*350 }}
  cylinder { <0,450,0>, <0,800,0>, 30 texture { T_Silo_DullMetal }}
  cylinder { <0,800,0>, <0,900,0>, 30 texture { T_Silo_RustyDull translate z*300 scale 200 translate y*775 }}
  cylinder { <0,350,0>, <0,355,0>, 31 texture { T_Silo_BlackMetal }}
  torus { 33, 5 translate y*450 texture { T_Silo_AquaMetal }}
  cylinder { <0,875,0>, <0,890,0>, 30.001 texture { T_Silo_BlackMetal }}
  torus { 30, 5 translate y*905 texture { T_Silo_AquaMetal }}
  sphere { <0,910,0>, 30 texture { T_Silo_AquaMetal }}
  sphere { <0,948,0>, 10 texture { T_Silo_AquaMetal }}
  cone { <0,948,0>, 7.5, <0,1000,0>, 0 texture { T_Silo_AquaMetal }}
  union {
    cylinder { <0,0,0>, <0,0,180.5>, 10 texture { T_Silo_BlackMetal }}
    torus { 14,5 rotate x*-90 translate z*90 texture { T_Silo_AquaMetal }}
    matrix <1,0,0, 0,1,0, 0,-1.1,1, 0,0,0>
    translate y*900
  }
  scale 1.8
}

#declare Silo5 = union {
  cylinder { <620,585,0>, <620,730,0>, 20 texture { T_Silo_RustyDull scale <100,145,100> translate y*585 }}
  cylinder { <620,-10,0>, <620,585,0>, 20 texture { T_Silo_DullMetal }}
  cylinder { <620,565,0>, <620,585,0>, 20.001 texture { T_Silo_BrightMetal }}
  cylinder { <620,465,0>, <620,460,0>, 20.001 texture { T_Silo_BlackMetal }}
  cylinder { <620,415,0>, <620,410,0>, 20.001 texture { T_Silo_BlackMetal }}
  cylinder { <620,365,0>, <620,360,0>, 20.001 texture { T_Silo_BlackMetal }}
  torus { 20, 5 translate <620,730,0> texture { T_Silo_AquaMetal }}
  torus { 20, 5 translate <620,740,0> texture { T_Silo_AquaMetal }}
  cylinder { <610,740,0>, <610,770,0>, 5 texture { T_Silo_AquaMetal }}
  sphere { <610,774,0>, 5 texture { T_Silo_RustyBright scale <50,10,50> translate y*771 }}
  translate y*10
  scale 1.8
}


#declare CornerBend = intersection {
  torus { 20, 7 rotate x*-90 }
  box { <-27.001,0,-7.001>, <0,27.001,7.001> }
  bounded_by { box { <-27,0,-7>, <0,27,7> }}
  translate x*20
}

#declare TopPipeBend1 = union {
  cylinder { <60,665,0>, <60,700,0>, 7 }
  object { CornerBend translate <60,700,0> }
  cylinder { <80,720,0>, <500,720,0>, 7 }
  object { CornerBend rotate y*180 translate <520,700,0> }
  cylinder { <520,665,0>, <520,700,0>, 7 }
  sphere { <100,734,0>, 8 texture { T_Silo_RustyBright scale <50,16,50> translate y*726 }}
  sphere { <125,732,0>, 6 texture { T_Silo_RustyBright scale <50,12,50> rotate y*180 translate y*726 }}
  cylinder { <80,665,0>, <80,720,0>, 3 }
  cylinder { <112,665,0>, <112,720,0>, 5 }
  cylinder { <365,665,0>, <365,750,0>, 2 texture { T_Silo_BlackMetal }}
  cylinder { <350,750,0>, <350,550,0>, 2 texture { T_Silo_BlackMetal }}
  intersection {
    torus { 7.5, 2 rotate x*-90 }
    box { <-7.501,0,-2.001>, <7.501,7.501,2.001> }
    bounded_by { box { <-7.5,0,-2>, <7.5,7.5,2> }}
    texture { T_Silo_BlackMetal }
    translate <357.5,750,0>
  }
  cylinder { <430,665,0>, <430,740,0>, 4 }
  cylinder { <490,665,0>, <490,740,0>, 3 }
  cylinder { <200,550,0>, <490,550,0>, 5 texture { T_WhitePipe }}
  cylinder { <490,535,-50>, <700,535,-50>, 5 texture { T_WhitePipe }}
  texture { T_Silo_DullCyan }
  translate <15,10,0>
  scale 1.8
}

#declare TopPipeBend2 = union {
  cylinder { <0,0,0>, <0,25,0>, 7 }
  object { CornerBend translate <0,25,0> }
  cylinder { <20,45,0>, <400,45,0>, 7 }
  sphere { <20,57,0>, 7 texture { T_Silo_Copper }}
  texture { T_Silo_DullCyan }
  scale 1.8
}

#declare Transformer = union {
  union {
    sphere { <0,590,0>, 10 }
    sphere { <0,580,0>, 5 scale <2,1,2> }
    sphere { <0,575,0>, 5 scale <2,1,2> }
    sphere { <0,570,0>, 5 scale <2,1,2> }
    sphere { <0,565,0>, 5 scale <2,1,2> }
    texture { T_Silo_Copper }
  }
  cylinder { <0,600,0>, <0,300,0>, 3 texture { T_Silo_BlackMetal }}
  cylinder { <0,525,-20>, <0,525,20>, 7.001 texture { T_DirtyWhitePipe }}
  sphere { <0,475,0>, 7 scale <1.3,1,1.3> texture { T_Silo_Copper }}
  cylinder { <0,450,-20>, <0,450,20>, 5.001 texture { T_Silo_DullCyan }}
  translate y*50
}

#declare PipeComb = union {
  cylinder { <0,0,0>, <0,0,-700>, 5 }
  sphere { <0,0,-700>, 5 }
  #declare foo=-200;
  #while (foo >-700)
    cylinder { <0,0,foo>, <100,0,foo>, 5 }
    #declare foo=foo-100;
  #end
  texture { T_Silo_BlackMetal }
}

#declare SiloPipes1 = union { // Pipes (and some of the silos) above the ellipsoidal tanks
  cylinder { <0,1000,0>, <0,1000,1500>, 15 texture { T_WhitePipe }}
  cylinder { <0,1000,150>, <0,1000,250>, 15.001 texture { T_Silo_BrightMetal }}
  #declare foo=300;
  #while (foo < 1500)
    cylinder { <0,1000,foo>, <0,1000,foo+30>, 15.001 texture { T_Silo_DullCyan }}
    cylinder { <0,1000,foo>, <0,850,foo>, 1.5 texture { T_Silo_Copper }}
    #if (foo >= 900)
      cylinder { <0,1000,foo>, <250,1000,foo>, 2 texture { T_Silo_Copper }}
      cylinder { <0,1000,foo>, <-40,1000,foo>, 6 texture { T_Silo_DullMetal }}
      sphere { <-50,1000,foo>, 15 texture { T_Silo_Copper }}
    #end
    #declare foo=foo+(200/3);
  #end
  #declare foo=400;
  #while (foo < 1400)
    object { Transformer translate z*foo }
    #declare foo=foo+125;
  #end
  object { TopPipeBend2 translate <0,1000,500> }
  object { TopPipeBend2 translate <0,1000,700> }
  object { TopPipeBend2 translate <0,1000,900> }
  cylinder { <0,850,0>, <0,850,1500>, 15 texture { T_Silo_RustyBright scale <50,30,50> translate y*835 }}
  cylinder { <0,810,0>, <0,810,1500>,  5 texture { T_Silo_BlackMetal }}
  cylinder { <0,650,0>, <0,650,1500>,  5 texture { T_Silo_BlackMetal }}
  cylinder { <0,575,0>, <0,575,1500>,  7 texture { T_Silo_DullMetal }}
  cylinder { <0,500,0>, <0,500,1500>,  5 texture { T_DirtyWhitePipe }}
  cylinder { <0,430,0>, <0,430,1500>,  3 texture { T_DirtyWhitePipe }}
  cylinder { <800,0,560>, <800,675,560>, 20 texture { T_Silo_DullMetal }}
  cylinder { <200,850,250>, <1250,850,250>,6 texture { T_Silo_DullCyan }}
  cylinder { <200,838,250>, <1250,838,250>,6 texture { T_DirtyWhitePipe }}
  cylinder { <570,838,250>, <585,838,250>, 6.001 texture { T_Silo_DullCyan }}
  cylinder { <630,838,250>, <640,838,250>, 6.001 texture { T_Silo_DullCyan }}
  cylinder { <930,838,250>, <940,838,250>, 6.001 texture { T_Silo_DullCyan }}
  cylinder { <200,675,250>, <1250,675,250>,6 pigment { P_TankRing }}
  cylinder { <200,630,250>, <1250,630,250>,6 texture { T_WhitePipe }}
  cylinder { <605,0,260>, <605,850,260>, 2 texture { T_Silo_DullMetal }}
  cylinder { <1000,0,110>, <1000,700,110>, 5 texture { T_Silo_DullCyan }}
  cylinder { <1400,1000,700>, <1400,1000,-500>, 10 texture { T_Silo_DullCyan }}
  cylinder { <1400,700,700>, <1400,700,-500>, 10 texture { T_DirtyWhitePipe }}
  cylinder { <1400,600,700>, <1400,600,-500>, 10 texture { T_Silo_DullMetal }}
  cylinder { <1420,0,40>, <1420,1400,40>, 8 texture { T_Silo_BlackMetal }}

  cylinder { <300,0,1150>, <300,850,1150>, 40 texture { T_Silo_RustyBright scale <100,750,100> }}
  torus { 35, 10 translate <300,850,1150> texture { T_Silo_AquaMetal }}
  cylinder { <330,850,1150>, <330,1050,1150>, 5 texture { T_Silo_BlackMetal }}
  cylinder { <270,850,1150>, <270,1040,1150>, 5 texture { T_Silo_BlackMetal }}

  cylinder { <300,0,1400>, <300,850,1400>, 40 texture { T_Silo_RustyDull scale <100,750,100> }}
  torus { 35, 10 translate <300,850,1400> texture { T_Silo_AquaMetal }}
  cylinder { <270,850,1400>, <270,1010,1400>, 2.5 texture { T_Silo_BlackMetal }}
  cylinder { <295,850,1400>, <295,1050,1400>, 2.5 texture { T_Silo_BlackMetal }}
  cylinder { <0,0,0>, <0,500,0>, 10 matrix <1,0,0, 0,1,-0.9, 0,0,1, 0,0,0>
    translate <300,850,1400> texture { T_Silo_AquaMetal }
  }

  cylinder { <200,0,1400>, <200,850,1400>, 40 texture { T_Silo_RustyBright scale <100,750,100> }}
  cylinder { <170,850,1400>, <170,950,1400>, 4 texture { T_Silo_BlackMetal }}
  cylinder { <200,850,1400>, <200,960,1400>, 4 texture { T_Silo_BlackMetal }}
  cylinder { <230,850,1400>, <230,980,1400>, 4 texture { T_Silo_BlackMetal }}
  torus { 35, 10 translate <200,850,1400> texture { T_Silo_AquaMetal }}

  cylinder { <0,0,0>, <0,550,0>, 10 matrix <1,0,0, 0,1,-0.9, 0,0,1, 0,0,0>
    translate <50,500,1550> texture { T_Silo_AquaMetal }
  }

  cylinder { <0,0,1675>, <0,1250,1675>, 5 texture { T_Silo_BlackMetal }}
  sphere { <0,1250,1675>, 10 texture { T_Silo_BrightMetal }}

  cylinder { <0,1650,2700>, <0,1600,2700>, 65 texture { T_Silo_AquaMetal }}
  cylinder { <0,1600,2700>, <0,1300,2700>, 65 texture { T_Silo_RustySky scale <100,400,100> translate y*1300 }}
  cylinder { <0,1300,2700>, <0,1200,2700>, 65 texture { T_Silo_AquaMetal }}
  cylinder { <0,1200,2700>, <0, 800,2700>, 65 texture { T_Silo_RustySky scale <100,500,100> translate y*800 }}
  cylinder { <0, 800,2700>, <0, 775,2700>, 65 texture { T_Silo_AquaMetal }}
  cylinder { <0, 775,2700>, <0, 525,2700>, 65 texture { T_Silo_RustySky scale <100,350,100> translate y*500 }}
  cylinder { <0, 525,2700>, <0, 500,2700>, 65 texture { T_Silo_AquaMetal }}
  cylinder { <0, 500,2700>, <0,   0,2700>, 65 texture { T_Silo_RustySky scale <100,500,100> }}
 
  cylinder { <32.5,1675,2700>, <32.5,1685,2700>, 65 texture { T_Silo_AquaMetal }}
  cylinder { <32.5,1685,2700>, <32.5,1695,2700>, 65 texture { T_Silo_BrightMetal }}
  cylinder { <32.5,1695,2700>, <32.5,1705,2700>, 65 texture { T_Silo_AquaMetal }}
  cylinder { <16,1675,2700>, <16,1750,2700>, 10 texture { T_Silo_AquaMetal }}
  sphere { <16,1764,2700>, 15 texture { T_Silo_AquaMetal }}

  cylinder { <90,0,2700>, <90,1705,2700>, 7.5 texture { T_Silo_Copper }}
  cylinder { <90,1480,2700>, <575,1480,2700>, 5 texture { T_Silo_BlackMetal }}
  cylinder { <90,1400,2700>, <575,1400,2700>, 5 texture { T_Silo_BlackMetal }}


  cylinder { <-85,0,2700>, <-85,1600,2700>, 5 texture { T_Silo_Copper }}
  sphere { <-85,1600,2700>, 5 texture { T_Silo_Copper }}
  cylinder { <-85,1600,2700>, <0,1600,2700>, 5 texture { T_Silo_Copper }}

  cylinder { <90,0,2700>, <150,0,2700>, 5 pigment { P_TankRing } scale <1,2,1> translate y*775 }
  cylinder { <90,0,2700>, <250,0,2700>, 4 texture { T_Silo_DullMetal } scale <1,2,1> translate y*600 }

  cylinder { <150,0,2700>, <150,1500,2700>, 5 texture { T_Silo_BlackMetal }}
  cylinder { <200,0,2700>, <200,1500,2700>, 5 texture { T_Silo_BlackMetal }}
  intersection {
    torus { 25, 5 rotate x*-90 }
    box { <-30.001,0,-5.001>, <30.001,30.001,5.001> }
    bounded_by { box { <-30,0,-5>, <30,30,5> }}
    texture { T_Silo_BlackMetal }
    translate <175,1500,2700>
  }
  object { PipeComb translate <150,1200,2700> }

  cylinder { <175,0,2670>, <175,800,2670>, 30 texture { T_Silo_Copper }}
  cylinder { <175,800,2670>, <175,1000,2670>, 30 texture { T_Silo_RustyBright scale <100,250,100> translate y*800 }}
  cylinder { <175,750,2670>, <175,775,2670>, 30.001 pigment { P_TankRing }}
  cone { <175,1000,2670>, 30, <175,1100,2670>, 10 texture { T_Silo_DullMetal }}
  sphere { <175,1120,2670>, 30 texture { T_Silo_Copper }}

  cylinder { <175,700,2670>, <175,700,2300>, 5 texture { T_Silo_BlackMetal }}

  cylinder { <150,900,2600>, <250,900,2600>, 10 texture { T_Silo_BlackMetal }}
  cylinder { <210,900,2600>, <210,975,2600>, 5 texture { T_Silo_BlackMetal }}
  cylinder { <250,0,2600>, <250,1300,2600>, 5 texture { T_Silo_BlackMetal }}

  cylinder { <200,  0,2550>, <200,700,2550>, 17 texture { T_Silo_DullMetal }}
  cylinder { <200,700,2550>, <200,825,2550>, 17 texture { T_Silo_RustyDull scale <100,150,100> translate y*700 }}
  cylinder { <200,825,2550>, <200,850,2550>, 17 texture { T_Silo_RustyBright scale <100,150,100> translate y*700 }}
  cylinder { <175,540,2670>, <200,540,2550>, 10 texture { T_Silo_BlackMetal }}
}

#declare SiloPipes2 = union { // Furthest set of pipes/silos
  cylinder { <800,0,6000>, <800,375,6000>, 45 texture { T_Silo_DullMetal }}  
  cylinder { <800,350,6000>, <800,375,6000>, 45.001 texture { T_Silo_AquaMetal }}
  cylinder { <800,275,6000>, <800,265,6000>, 45.001 texture { T_Silo_BrightMetal }}
  cylinder { <800,200,6000>, <800,180,6000>, 45.001 texture { T_Silo_AquaMetal }}
  cylinder { <800,375,6000>, <800,395,6000>, 20 texture { T_Silo_DullMetal }}
  cone { <800,395,6000>, 20, <800,405,6000>, 45 texture { T_Silo_DullMetal }}
  cone { <800,405,6000>, 45, <800,425,6000>, 20 texture { T_Silo_DullMetal }}
  sphere { <800,445,6000>, 25 texture { T_Silo_BrightMetal }}

  cylinder { <900,0,6000>, <900,350,6000>, 10 texture { T_Silo_BlackMetal }}
  cylinder { <1000,0,6000>, <1000,170,6000>, 15 texture { T_Silo_DullCyan }}
  cylinder { <1000,100,6000>, <1060,100,6000>, 8 texture { T_Silo_BlackMetal }}
  cylinder { <800,150,6000>, <1200,150,6000>, 4 texture { T_Silo_BlackMetal }}
  cylinder { <1100, 0,6000>, <1100,550,6000>, 4 texture { T_Silo_Copper }}

  cylinder { <1075,0,5900>, <1075,100,5900>, 9 texture { T_Silo_BlackMetal }}
  cylinder { <1075,75,5900>, <2000,75,5900>, 9 texture { T_Silo_BlackMetal }}

  cylinder { <1200,0,6000>, <1200,440,6000>, 50 texture { T_Silo_Tan }}
  difference {
    box { <1165,0,6000>, <1235,430,5945> }
    box { <1170,300,5950>, <1230,350,5944.9> }
    texture { T_Silo_Tan }
  }
  box { <1170,375,5945>, <1230,385,5944.9> texture { T_Silo_AquaMetal }}
  box { <1165,275,5945>, <1235,230,5944.9> texture { T_Silo_AquaMetal }}
  difference {
    union {
      cylinder { <1200,170,5945>, <1200,170,5944>, 30 }
      cylinder { <1200,120,5945>, <1200,120,5944>, 30 }
      box { <1170,170,5945>, <1230,120,5944> }
      texture { T_Silo_BlackMetal }
    }
    box { <1175,170,5944.999>, <1225,120,5943.9> texture { T_Silo_Tan }}
  }
  cylinder { <1210,420,5945>, <1210,465,5945>, 12 texture { T_Silo_AquaMetal }}
  sphere { <1210,420,5945>, 12 texture { T_Silo_AquaMetal }}
  sphere { <1210,465,5945>, 12 texture { T_Silo_AquaMetal }}

  cylinder { <1300,0,6000>, <1300,600,6000>, 10 texture { T_Silo_Copper }}
  torus { 10, 4 translate <1300,600,6000> texture { T_Silo_AquaMetal }}
  torus { 10, 4 translate <1300,608,6000> texture { T_Silo_AquaMetal }}
  cylinder { <1300,600,6000>, <1300,615,6000>, 4 texture { T_Silo_AquaMetal }}
  sphere { <1300,615,6000>, 4 texture { T_Silo_BrightMetal }}

  cylinder { <1330,0,6000>, <1330,800,6000>, 4 texture { T_Silo_Copper }}
  intersection {
    torus { 10, 4 rotate x*-90 }
    box { <-14.001,0,-4.001>, <0,14.001,4.001> }
    bounded_by { box { <-14,0,-4>, <0,14,4> }}
    scale <1,5,1>
    texture { T_Silo_Copper }
    translate <1340,800,6000>
  }
  cylinder { <1330,700,6000>, <1500,700,6000>, 4 texture { T_Silo_Copper }}
  cylinder { <1330,692,6000>, <1500,692,6000>, 4 texture { T_Silo_Copper }}
  cylinder { <1330,684,6000>, <1500,684,6000>, 4 texture { T_Silo_Copper }}

  cylinder { <730,325,6000>, <1500,325,6000>, 4 texture { T_Silo_Copper }}
  cylinder { <900,317,6000>, <1500,317,6000>, 4 texture { T_Silo_Copper }}

  cylinder { <800,278,6000>, <1500,278,6000>, 4 texture { T_Silo_Copper }}
  cylinder { <800,258,6000>, <1500,258,6000>, 6 texture { T_Silo_BlackMetal }}

  union {
    cylinder { <0,325,6000>, <1150,325,6000>, 4 texture { T_Silo_BlackMetal }}
    cylinder { <900,275,6000>, <1150,275,6000>, 4 texture { T_Silo_DullMetal }}
    cylinder { <740,325,6000>, <740,0,6000>, 4 texture { T_Silo_DullMetal }}
    cylinder { <650,325,6000>, <650,0,6000>, 4 texture { T_Silo_DullMetal }}
    cylinder { <600,325,6000>, <600,0,6000>, 4 texture { T_Silo_DullMetal }}
    cylinder { <550,325,6000>, <550,0,6000>, 4 texture { T_Silo_DullMetal }}
    cylinder { <500,325,6000>, <500,0,6000>, 4 texture { T_Silo_DullMetal }}
    cylinder { <450,325,6000>, <450,0,6000>, 4 texture { T_Silo_DullMetal }}
    cylinder { <400,325,6000>, <400,0,6000>, 4 texture { T_Silo_DullMetal }}
    cylinder { <350,325,6000>, <350,0,6000>, 4 texture { T_Silo_DullMetal }}
    translate <-1150,-325,0>  matrix <1,0.3,0, 0,1,0, 0,0,1, 0,0,0> translate <1150,325,0>
  }

  cylinder { <420,0,6000>, <420,130,6000>, 10 texture { T_Silo_DullCyan }}
  cylinder { <420,130,6000>, <420,135,6000>, 10 texture { T_Silo_BrightMetal }}
  cylinder { <420,125,6000>, <800,125,6000>, 4 texture { T_Silo_BlackMetal }}

  cylinder { <470,0,6000>, <470,130,6000>, 10 texture { T_Silo_DullCyan }}
  cylinder { <470,130,6000>, <470,135,6000>, 10 texture { T_Silo_BrightMetal }}

  cylinder { <600,0,6000>, <600,125,6000>, 15 texture { T_DirtyWhitePipe }}
  cylinder { <600,125,6000>, <600,135,6000>, 15 texture { T_DirtyWhitePipe }}
  sphere { <600,150,6000>, 15 texture { T_DirtyWhitePipe }}

  cylinder { <670,0,6000>, <670,50,6000>, 20 texture { T_DirtyWhitePipe }}
  sphere { <670,65,6000>, 20 texture { T_Silo_RustyBright scale <100,40,100> translate y*45 }}

  cylinder { <350,0,6000>, <350,100,6000>, 8 texture { T_Silo_BrightMetal }}
  sphere { <350,110,6000>, 10 texture { T_Silo_DullMetal }}

  cylinder { <275,0,6000>, <275,100,6000>, 10 texture { T_Silo_DullCyan }}
  cylinder { <225,0,6000>, <225,100,6000>, 9 texture { T_Silo_AquaMetal }}

  cylinder { <175,0,6000>, <175,90,6000>, 10 texture { T_DirtyWhitePipe }}

  cylinder { <50,0,6000>, <50,100,6000>, 8 texture { T_Silo_BlackMetal }}
  sphere { <50,115,6000>, 16 texture { T_DirtyWhitePipe }}
}  

#declare TankAssembly = union {
  object { Tank translate <1150,0,1500> }
  object { Tank translate <1150,0,2000> }
  object { Tank translate <1150,0,2500> }
  object { Tank translate <1150,0,3000> }
  object { Tank translate <1150,0,3500> }

  object { Silo1 translate <1160,0,1750> }
  object { Silo1 translate <1900,0,1400> }

  object { Silo2 translate <1260,0,2250> }
  object { Silo2 translate <1860,0,2250> }

  object { Silo4 translate <2476,0,2425> }

  object { Silo3 translate <1360,0,2750> }
  object { TopPipeBend1 translate <1360,0,2750> }

  object { Silo5 translate <1550,0,3500> }

  object { Silo2 translate <1265,0,3750> }
  object { SiloPipes1 translate <1260,0,2250> }
  object { SiloPipes2 }
  box { <3000,0,2500>, <3001,300,8000> pigment { colour rgb <0,0,0> }}
}

#ifndef (FullScene)
  object { TankAssembly }
  camera { location <0,75,0> look_at <0,125,1000> rotate y*25 }
  light_source { <-5000,10000,10000> colour rgb 0.75 }
  light_source { <-1000,1,-10000> colour rgb 0.66 }
  light_source { <-10000,10000,-10000> colour rgb 0.66 }
  light_source { <-10000,10000,0> colour rgb 0.75 }
  background { colour rgb <0.25,0.5,1.0> }
#end
