/*----------------------------------------------------------------------------------------------------------------------------------
    Script    : CouteauVivant.pov
    Date      : 24-May-1998
    Auteur    : Fab
    Descript  :                                              
----------------------------------------------------------------------------------------------------------------------------------*/
//#declare Rend_Blur = 1
  #declare Rend_Blur_Medium = 1
  #declare Show_AreaLight = 1
//#declare Show_Smooth = 1
//#declare Show_Fog = 1

  #declare Show_WorldAround = 1
  #declare Show_VraiesDalles = 1

  #declare Show_Epees = 1
  #declare Show_Garde = 1
  #declare Show_Branches = 1
  #declare Show_Ico = 1

  #declare Show_Tronc = 1


// --- Les bois ---
#declare BoisCol1 = color red 0.65 green 0.35 blue 0.20
#declare BoisCol2 = color red 0.90 green 0.60 blue 0.30
#declare MancheBoisTex = texture {
  pigment {
    radial frequency 16 turbulence 1.50 scale <1, 5, 1>
    color_map {
      [0.20 color BoisCol1]
      [0.50 color BoisCol2]
      [0.80 color BoisCol1] }
    }
  normal { radial 0.40 frequency 16 turbulence 1.50 scale <1, 5, 1> }
  finish { ambient 0.40 diffuse 0.80 specular 0.30 roughness 0.08 } }

#declare BranchesBoisTex = texture {
  pigment {
    radial frequency 10 turbulence 1.50 scale <1, 5, 1>
    color_map {
      [0.20 color BoisCol1]
      [0.50 color BoisCol2]
      [0.80 color BoisCol1] }
    }
  normal { radial 0.20 frequency 10 turbulence 1.50 scale <1, 5, 1> }
  finish { ambient 0.40 diffuse 0.80 specular 0.30 roughness 0.08 }
  rotate <0, 0, 90> }

// --- Volume de rvolution de la partie en bois du manche ---
#declare MancheForme = lathe {
  cubic_spline 15,
  <0, 0>,   <10, 0>,  <20, 0>,  <25, 0>,   <25, 5>,  <10, 15>, <15, 35>, <17, 50>,
  <15, 65>, <10, 80>, <15, 95>, <15, 105>, <5, 110>, <5, 115>, <0, 115>
  scale 0.1 }

// --- La partie en bois du manche ---
#declare MancheBois = object { MancheForme texture { MancheBoisTex } }

// --- Le machin icosahdrode ---
#ifdef(Show_Ico)
  //#declare IcoCol = color red 1.00 green 0.80 blue 0.50
  #declare IcoCol = color red 0.80 green 1.00 blue 0.50
  #declare IcoTex = texture {
    pigment { color IcoCol filter 0.70 }
    finish { ambient 0.50 diffuse 1.50 specular 0.80 roughness 0.08 refraction 1 ior 1.4 brilliance 5 reflection 0.30 } }

  #declare Icosahedre = intersection {
    plane { <0, 0, 1> 1 rotate < 52.6625,    0, 0> }
    plane { <0, 0, 1> 1 rotate < 52.6625,  -72, 0> }
    plane { <0, 0, 1> 1 rotate < 52.6625, -144, 0> }
    plane { <0, 0, 1> 1 rotate < 52.6625, -216, 0> }
    plane { <0, 0, 1> 1 rotate < 52.6625, -288, 0> }
                                            
    plane { <0, 0, 1> 1 rotate < 10.8125,    0, 0> }
    plane { <0, 0, 1> 1 rotate < 10.8125,  -72, 0> }
    plane { <0, 0, 1> 1 rotate < 10.8125, -144, 0> }
    plane { <0, 0, 1> 1 rotate < 10.8125, -216, 0> }
    plane { <0, 0, 1> 1 rotate < 10.8125, -288, 0> }
                                            
    plane { <0, 0, 1> 1 rotate <-52.6625,  -36, 0> }
    plane { <0, 0, 1> 1 rotate <-52.6625, -108, 0> }
    plane { <0, 0, 1> 1 rotate <-52.6625, -180, 0> }
    plane { <0, 0, 1> 1 rotate <-52.6625, -252, 0> }
    plane { <0, 0, 1> 1 rotate <-52.6625, -324, 0> }
                                            
    plane { <0, 0, 1> 1 rotate <-10.8125,  -36, 0> }
    plane { <0, 0, 1> 1 rotate <-10.8125, -108, 0> }
    plane { <0, 0, 1> 1 rotate <-10.8125, -180, 0> }
    plane { <0, 0, 1> 1 rotate <-10.8125, -252, 0> }
    plane { <0, 0, 1> 1 rotate <-10.8125, -324, 0> } }

  #declare Ico = object { Icosahedre texture { IcoTex } }
#end

// --- Le mtal dont est faite la garde ---
#declare MetalGardeCol1 = color red 0.40 green 0.30 blue 0.30
#declare MetalGardeCol2 = color red 0.70 green 0.75 blue 0.95
#declare MetalGardeTex = texture {
  pigment {
    radial frequency 12 rotate <0, 0, 90>
    color_map {
      [0.70 color MetalGardeCol1]
      [0.80 color MetalGardeCol2] } }
  finish { ambient 0.20 diffuse 0.60 specular 1.20 roughness 0.020 reflection 0.85 metallic } }

#declare DemieGarde_EllTex = texture { MetalGardeTex }
#declare DemieGarde_CntTex = texture { MetalGardeTex }

// --- La garde qui sera rajoute dans le bois ---
#ifdef(Show_Garde)
  #include "CouteauVivantGarde.cpp"
  #declare Garde = union {
    object { DemieGarde }
    object { DemieGarde scale <-1, 1, 1> }
    scale <1, 1, 2.2> }
#end

// --- Les branches ---
#ifdef(Show_Branches)
  #render "\nParsing Branches:\n"
  #declare Branche_1_1_EllTex = texture { BranchesBoisTex }  #declare Branche_1_1_CntTex = texture { BranchesBoisTex }
  #declare Branche_1_2_EllTex = texture { BranchesBoisTex }  #declare Branche_1_2_CntTex = texture { BranchesBoisTex }
  #declare Branche_1_3_EllTex = texture { BranchesBoisTex }  #declare Branche_1_3_CntTex = texture { BranchesBoisTex }
  #declare Branche_1_4_EllTex = texture { BranchesBoisTex }  #declare Branche_1_4_CntTex = texture { BranchesBoisTex }
  #declare Branche_1_5_EllTex = texture { BranchesBoisTex }  #declare Branche_1_5_CntTex = texture { BranchesBoisTex }
  #include "CouteauVivantBranche1.cpp"
  #declare Branche_2_1_EllTex = texture { BranchesBoisTex }  #declare Branche_2_1_CntTex = texture { BranchesBoisTex }
  #declare Branche_2_2_EllTex = texture { BranchesBoisTex }  #declare Branche_2_2_CntTex = texture { BranchesBoisTex }
  #declare Branche_2_3_EllTex = texture { BranchesBoisTex }  #declare Branche_2_3_CntTex = texture { BranchesBoisTex }
  #declare Branche_2_4_EllTex = texture { BranchesBoisTex }  #declare Branche_2_4_CntTex = texture { BranchesBoisTex }
  #declare Branche_2_5_EllTex = texture { BranchesBoisTex }  #declare Branche_2_5_CntTex = texture { BranchesBoisTex }
  #include "CouteauVivantBranche2.cpp"
  #declare Branche_3_1_EllTex = texture { BranchesBoisTex }  #declare Branche_3_1_CntTex = texture { BranchesBoisTex }
  #declare Branche_3_2_EllTex = texture { BranchesBoisTex }  #declare Branche_3_2_CntTex = texture { BranchesBoisTex }
  #declare Branche_3_3_EllTex = texture { BranchesBoisTex }  #declare Branche_3_3_CntTex = texture { BranchesBoisTex }
  #declare Branche_3_4_EllTex = texture { BranchesBoisTex }  #declare Branche_3_4_CntTex = texture { BranchesBoisTex }
  #declare Branche_3_5_EllTex = texture { BranchesBoisTex }  #declare Branche_3_5_CntTex = texture { BranchesBoisTex }
  #declare Branche_3_6_EllTex = texture { BranchesBoisTex }  #declare Branche_3_6_CntTex = texture { BranchesBoisTex }
  #declare Branche_3_7_EllTex = texture { BranchesBoisTex }  #declare Branche_3_7_CntTex = texture { BranchesBoisTex }
  #declare Branche_3_8_EllTex = texture { BranchesBoisTex }  #declare Branche_3_8_CntTex = texture { BranchesBoisTex }
  #declare Branche_3_9_EllTex = texture { BranchesBoisTex }  #declare Branche_3_9_CntTex = texture { BranchesBoisTex }
  #declare Branche_3_10_EllTex = texture { BranchesBoisTex } #declare Branche_3_10_CntTex = texture { BranchesBoisTex }
  #include "CouteauVivantBranche3.cpp"
  #render "\nParsing Branches, done.\n"
#end

#declare Manche = union {
  object { MancheBois }
  #ifdef(Show_Branches)
    object { CouteauVivantBranche1 scale 0.06 rotate <1, 0, -30> translate <0, 7, 0> rotate <0, 30, 0> } 
    object { CouteauVivantBranche2 scale 0.06 translate <-0.80, 3, 0> } 
    object { CouteauVivantBranche3 scale 0.07 rotate <0, 0, 10> translate <0, 5, -1.2> rotate <0, -20, 0> }
  #end
  #ifdef(Show_Garde)
    object { Garde }
  #end
  #ifdef(Show_Ico)
    // --- La manche fait 11.5 de haut. Le machin ico tient dans une sphre de rayon 1. ---
    object { Ico scale 1.3 rotate <10.8125, 324, 0> translate <0, 13, 0> }
  #end
}

// --- Le mtal de la lame ---
#declare PVMetalLameCol = color red 0.70 green 0.70 blue 0.70
#declare PVMetalLameTex = texture {
  pigment { color PVMetalLameCol }
  normal { bumps 0.10 scale <0.80, 6, 1> }
  finish { ambient 0.30 diffuse 0.60 specular 1.20 roughness 0.02 metallic reflection 0.90 } }

// --- La lame sans la pointe. Une veine la parcourt de haut en bas. ---
#declare LAngEpa = 8
#declare LLarg = 1.4
#declare LEpa = LLarg * tan(radians(LAngEpa))
#declare LHaut = 30
#declare LVeineRayX = LLarg / 4
#declare LVeineRayZ = LEpa / 2
// --- Demie-lame, partie -x, infinie en haut et en bas, symtrie -zOz par construction. ---
#declare DBruteLameInf = intersection {
  plane { <0, 0, 1>, 0 inverse rotate <0, LAngEpa, 0> }
  plane { <0, 0, 1>, 0 rotate <0, -LAngEpa, 0> }
  plane { <1, 0, 0>, 0 translate <LLarg, 0, 0> }
  translate <-LLarg, 0, 0> }
// --- Demie-lame, limite en haut et en bas. ---
#declare DBruteLame = intersection {
  object { DBruteLameInf }
  plane { <0, 1, 0>, 0 inverse }
  plane { <0, 1, 0>, 0 translate <0, LHaut, 0> } }
// --- Veine ---
#declare LVeine = cylinder { <0, -100, 0>, <0, 100, 0>, 1 scale <LVeineRayX, 1, LVeineRayZ> }
// --- Lame avec ses deux symtrie, toujours sans la pointe. ---
#declare BruteLame = difference {
  union {
    object { DBruteLame }
    object { DBruteLame scale <-1, 1, 1> } }
  object { LVeine translate <0, 0, LEpa> }
  object { LVeine translate <0, 0, -LEpa> } }

// --- La pointe de la lame. La veine s'interromp avant le bout de la pointe ---
#declare LAngPoi1 = 25
#declare LAngPoi2 = 5
#declare LDecalPoi1 = LLarg * (1 / cos(radians(LAngPoi1)) - 1)
#declare LDecalPoi2 = LEpa * (1 / cos(radians(LAngPoi2)) - 1)
// --- Aucune symtrie, un quart de pointe seulement. ---
#declare QPointeLame = intersection {
  object { DBruteLameInf rotate <0, 0, LAngPoi1> rotate <LAngPoi2, 0, 0> translate <LDecalPoi1, 0, LDecalPoi2> }
  plane { <1, 0, 0>, 0 }
  plane { <0, 1, 0>, 0 }
  plane { <0, 0, 1>, 0 } }           // - On taille dans le plan z, on perd la symtrie -zOz, il faudra la refaire.
// --- Symtrie -xOx ---
#declare DPointeLame = difference {
  union {
    object { QPointeLame }
    object { QPointeLame scale <-1, 1, 1> } }
  object { LVeine rotate <LAngPoi2, 0, 0> translate <0, 0, -LEpa> } }
// --- Symtrie -zOz qu'on avait perdue ---
#declare PointeLame = union {
  object { DPointeLame }
  object { DPointeLame scale <1, 1, -1> } }

// --- La lame complte pointe comprise ---
#declare Lame = object {
  union {
    object { BruteLame }
    object { PointeLame } }
  texture { PVMetalLameTex } }

// --- Le poignard complet, remis debout sur la pointe ---
#declare Epsilon = 0.0001
#declare Poignard = union {
  object { Manche }
  object { Lame translate <0, -LHaut + Epsilon, 0> }
  translate <0, LHaut, 0> }

//----------------------------------------------------------------------------------------------------------------------------------
#declare Epsilon = 0.001

// --- Un mtal blanc-bleu ---
#declare AcierCol1 = color red 0.70 green 0.72 blue 0.80
#declare Acier = texture {
  pigment { color AcierCol1 }
  finish { ambient 0.30 diffuse 0.60 specular 0.80 roughness 0.01 metallic reflection 0.8 } }

// --- Un mtal jaune-bronze ---
#declare BronzeCol1 = color red 0.90 green 0.67 blue 0.45
#declare BronzeCol2 = color red 1.00 green 0.82 blue 0.45
#declare Bronze = texture {
  pigment {
    bozo turbulence 0.7 scale 0.2
    color_map {
      [0.30 color BronzeCol1]
      [0.70 color BronzeCol2] } }
  normal { bozo 0.05 turbulence 0.7 scale 0.2 }
  finish { ambient 0.20 diffuse 0.50 specular 0.90 roughness 0.03 metallic reflection 0.30 } }

// --- La lame ---
#declare PteDia = 4
#declare PteLar = 2.0
#declare PteHauC = 3.46410 //Sqrt(PteDia^2-(PteDia-PteLar)^2)
#declare PteHauFact = 2.5
#declare LDFEpa = 0.05
#declare LDCHau = 32
#declare LentiLar = 0.31225// Sqrt(1^2-(1-LDFEpa)^2)
#declare LDteScZ = 6
#declare LDteScG = 0.4
#declare LDteHau = LDCHau+PteHauC*PteHauFact
#declare SphEps = 0.1

// --- De quoi faire la pointe ---
#declare Lentille = intersection { 
  sphere { <0, 0, 1-LDFEpa>, 1 } 
  sphere { <0, 0, -(1-LDFEpa)>, 1 } 
  scale <PteDia/LentiLar, PteDia/LentiLar, 1> }
#declare DemiPointe = difference {
  object { Lentille }
  plane { <0, 1, 0>, 0 }
  plane { <1, 0, 0>, -(PteDia-PteLar) inverse }
  translate <PteDia-PteLar, 0, 0> scale <1, PteHauFact, 1> }

// --- De quoi faire le reste de la lame ---
#declare LentiCorps = intersection {
  cylinder { <0, -LDCHau, 1-LDFEpa>, <0, Epsilon, 1-LDFEpa>, 1 }
  cylinder { <0, -LDCHau, -(1-LDFEpa)>, <0, Epsilon, -(1-LDFEpa)>, 1 }
  scale <PteDia/LentiLar, 1, 1> }
#declare DemiCorps = difference {
  object { LentiCorps }
  plane { <1, 0, 0>, -(PteDia-PteLar) inverse }
  translate <PteDia-PteLar, 0, 0> }

// --- De quoi creuser le sillon de la lame ---
#declare CanalEpaX = 0.7
#declare CanalEpaZ = 0.05
#declare Canal = union {
  sphere { <0, 0, 0>, 1 }
  cylinder { <0, -LDCHau*2, 0>, <0, 0, 0>, 1 }
  scale <CanalEpaX, 1, CanalEpaZ> }

// --- La lame proprement dite ---
#declare LameDroite = object {
  difference {
    union {
      object { DemiPointe }
      object { DemiPointe rotate <0, 180, 0> }
      object { DemiCorps }
      object { DemiCorps rotate <0, 180, 0> } }
    // --- Le canal est activ d'un seul cot ---
    //object { Canal translate <0, 0, LDFEpa> }
    object { Canal translate <0, 0, -LDFEpa> } }
  texture { Acier }
  translate <0, LDCHau, 0>
  bounded_by { box { <-PteLar, 0, -LDFEpa>, <PteLar, LDteHau, LDFEpa> } }
  scale <LDteScG, LDteScG, LDteScZ> }

// --- De quoi faire la garde ---
#declare Pyramide = intersection {
  plane { <1, 0, 0>, 0 rotate <0, 0, 45> }
  plane { <1, 0, 0>, 0 inverse rotate <0, 0, -45> }
  plane { <0, 0, 1>, 0 rotate <-45, 0, 0> }
  plane { <0, 0, 1>, 0 inverse rotate <45, 0, 0> } }

#declare GardDiaG = 0.38
#declare GardDiaP = 0.20
#declare GardDEpa = 0.04
#declare GardHTh = GardDiaG-GardDiaP+GardDEpa
#declare GardHau = 2.6
#declare DemiGarde = union {
  difference {
    object { Pyramide }
    plane { <0, 1, 0>, -GardDiaG }
    plane { <0, 1, 0>, -GardDiaP inverse }
    translate <0, GardDiaP, 0> }
  box { <-GardDiaG, -GardHTh, -GardDiaG>, <GardDiaG, -GardHTh+GardDEpa, GardDiaG> }
  bounded_by { box { <-GardDiaG, -GardHTh, -GardDiaG>, <GardDiaG, 0, GardDiaG> } }
  scale <1, GardHau/GardHTh, 1> rotate <0,  0, 90> }
#declare ArreteGarde = union { object { DemiGarde } object { DemiGarde rotate <0, 0, 180> } }

// --- La garde proprement dite ---
#declare Garde = object {
  union {
    object { ArreteGarde }
    object { ArreteGarde rotate <45, 0, 0> }
    sphere { <0, 0, 0>, 1.6 * GardDiaG translate <GardHau + 1.6 * GardDiaG - SphEps, 0, 0> }
    sphere { <0, 0, 0>, 1.6 * GardDiaG translate <-(GardHau + 1.6 * GardDiaG) + SphEps, 0, 0> } }
  texture { Bronze } }

// --- La poigne ---
#declare PoiDiaX = 0.70
#declare PoiDiaZ = 0.45
#declare PoiHTh = 2.7
#declare PoiHau = 2.1
#declare PomDia = 0.60
#declare PomSpheDia = 0.70
#declare Poignee = object {
  union {
    difference {
      sphere { <0, 0, 0>, 1 scale <PoiDiaX, PoiHTh, PoiDiaZ> }
      plane { <0, 1, 0>, PoiHau inverse }
      translate <0, -PoiHau, 0> }
    sphere { <0, -PoiHTh-PoiHau, 0>, PomSpheDia } }
  texture { Bronze } }

// --- La mdaille au bout de la garde ---
#declare MedEpa = 0.15
#declare MedDia = 1.00
#declare MedDecal = 0.1
#declare Medaille = object {
  union {
    cylinder { <0, 0, -MedEpa/2>, <0, 0, MedEpa/2>, MedDia }
    torus { MedDia*2/3, MedEpa rotate <90, 0, 0> }
    torus { MedDia, MedEpa rotate <90, 0, 0> } }
  texture { Bronze }
  bounded_by { box { <-MedDia-MedEpa, -MedDia-MedEpa, -MedEpa>, <MedDia+MedEpa, MedDia+MedEpa, MedEpa> } }
  translate <0, -PoiHTh-PoiHau-PomDia-MedDia+MedDecal, 0> }

// --- L'pe au complet ---
#declare Epee = union { object { LameDroite } object { Garde } object { Poignee } object { Medaille } }

//----------------------------------------------------------------------------------------------------------------------------------
#ifdef(Show_Tronc)
  #render "\nParsing Tronc:\n"
  #declare TroncCol1 = color red 0.45 green 0.30 blue 0.20
  #declare TroncCol2 = color red 0.80 green 0.45 blue 0.20
  #declare TroncBoisTex = texture {
    pigment {
      radial frequency 30 turbulence 1.50 scale <1, 5, 1>
      color_map {
        [0.20 color TroncCol2]
        [0.40 color TroncCol1]
        [0.60 color TroncCol1]
        [0.80 color TroncCol2] }
      }
    normal { radial 1.40 frequency 30 turbulence 1.50 scale <1, 5, 1> }
    finish { ambient 0.30 diffuse 0.80 specular 0.30 roughness 0.08 }
    rotate <0, 0, 90> }

  #declare ElementTronc1_EllTex = texture { TroncBoisTex }
  #declare ElementTronc1_CntTex = texture { TroncBoisTex }
  #declare ElementTronc2_EllTex = texture { TroncBoisTex }
  #declare ElementTronc2_CntTex = texture { TroncBoisTex }
  #declare ElementTronc3_EllTex = texture { TroncBoisTex }
  #declare ElementTronc3_CntTex = texture { TroncBoisTex }
  #declare ElementTronc4_EllTex = texture { TroncBoisTex }
  #declare ElementTronc4_CntTex = texture { TroncBoisTex }
  #declare ElementTronc5_EllTex = texture { TroncBoisTex }
  #declare ElementTronc5_CntTex = texture { TroncBoisTex }
  #include "CouteauVivantTronc.cpp"
  #render "\nParsing Tronc, done.\n"
#end

//----------------------------------------------------------------------------------------------------------------------------------
#ifdef(Show_WorldAround)
  #render "\nParsing WorldAround:\n"
  #declare PseudoWorldAround = object {
    sphere { <0, 0, 0>, 200 inverse }
    texture {
      pigment { image_map { gif "CouteauVivantFond.gif"  map_type 0 } scale 200 }
      finish { ambient 0.60 diffuse 0.10 } } }

  #render "\n  Parsing Dallage:\n"
  // --- Les dalles ---
  #declare DallesCol1 = color red 0.55 green 0.40 blue 0.20
  #declare DallesCol2 = color red 0.70 green 0.52 blue 0.30
  #declare DallesTex = texture {
    pigment {
      granite scale 10
      color_map {
        [0.30 color DallesCol1]
        [0.70 color DallesCol2] } }
    normal { granite 2.40 scale 10 rotate <90, 0, 0> }
    finish { ambient 0.2 diffuse 0.70 specular 0.20 roughness 0.09 } }

  #declare CongeVar = 0.1                        // - Variation des conges variables -
  #declare CongeBase = 0.1                       // - Base des conges variable -
  #declare SizeZ = 2.5                           // - Longueur d'une dalle -
  #declare SizeX = 3                             // - Largeur d'une dalle -
  #declare PEpa = 0.6                            // - Epaisseur d'une dalle -
  #declare YPositDeplBase = 0.3                  // - Base de dplacement alatoire en Y -
  #declare Espace = 0.30                         // - Espace entre deux dalles -
  #declare NRows = 20                            // - Nombre de lignes de dalles (z constant) -
  #declare NCols = 24                            // - nombre de colonnes de dalles (x constant) -
  #declare ScaleBase = 0.99                      // - Base invariante des tailles des pavs -
  #declare TransBase = 1000                      // - Base de calcul des translate des textures -
  #declare RotXBase = 3                          // - Base de calcul des rotations X - 
  #declare RotYBase = 6                          // - Base de calcul des rotations Y -
  #declare RotZBase = 3                          // - Base de calcul des rotations Z -
  #declare RotTexBase = 360                      // - Base de calcul des rotations de textures -
  #declare RandSol = seed(5)                     // - Initialisation de l'alatoire -
  #declare JointEpa = 0.40                       // - Epaisseur du joint -
  #declare PierreAffleur = 0.00                  // - Affleurement de la dalle par rapport au joint -
  #declare SolLong = (SizeZ+Espace)*(2*NRows)
  #declare SolLarg = (SizeX+Espace)*(2*NCols-1)
  #declare JointLarg = (SizeX+Espace)*(2*NCols+1)

  #declare Pierres = union {
    #declare nbPierres = 0
    #declare nbIrreg = 0
    #declare iRow = 1
    #while (iRow <= NRows)
      #declare xStart = (SizeX+Espace)*mod(iRow, 2)
      #declare zPositBase = 2*(SizeZ+Espace)*(iRow-0.5)
      #declare iCol = 1
      /* 
      #render "\n\n  Dallage : R x C  cong1  cong2  xSize-  zSize-  xPosit  yPosit  zPosit  xRotat  yRotat  zRotat\n"
      */
      #while (iCol <= NCols)
        #declare xPositBase = xStart + 2*(SizeX+Espace)*(iCol-1)
        #declare conge1 = CongeBase/2+CongeVar*rand(RandSol)
        #declare conge2 = CongeBase+CongeVar*rand(RandSol)
        #declare objSizX = SizeX*(ScaleBase+(1-ScaleBase)*2*rand(RandSol))
        #declare objSizZ = SizeZ*(ScaleBase+(1-ScaleBase)*2*rand(RandSol))
        #declare objRotX = 0
        #declare objRotY = 0
        #declare objRotZ = 0
        #declare xPosit = xPositBase
        #declare yPosit = 0
        #declare zPosit = zPositBase
        #declare PasElle = 0
        #declare rotLibres = 1

        #if (iRow = 2 & iCol = 11)
          #declare objRotZ = 12
          #declare yPosit = (abs(sin(objRotX/180*pi)) + abs(sin(objRotZ/180*pi))) * SizeZ
          #declare xPosit = xPositBase - 0.5
          #declare rotLibres = 0
        #end
        #if (iRow = 2 & iCol = 12)
          #declare objRotZ = -14
          #declare yPosit = (abs(sin(objRotX/180*pi)) + abs(sin(objRotZ/180*pi))) * SizeZ
          #declare rotLibres = 0
        #end

        #if (iRow = 3 & iCol = 10)
          #declare xPosit = xPositBase - 0.5
        #end
        #if (iRow = 3 & iCol = 10)
          #declare objRotZ = 10
          #declare yPosit = (abs(sin(objRotX/180*pi)) + abs(sin(objRotZ/180*pi))) * SizeZ
          #declare xPosit = xPositBase - 1.0
          #declare rotLibres = 0
        #end
        #if (iRow = 3 & iCol = 11)
          #declare objRotZ = 30
          #declare yPosit = (abs(sin(objRotX/180*pi)) + abs(sin(objRotZ/180*pi))) * SizeZ
          #declare xPosit = xPositBase - 1.5
          #declare rotLibres = 0
        #end
        #if (iRow = 3 & iCol = 12)
          #declare objRotZ = -22
          #declare yPosit = (abs(sin(objRotX/180*pi)) + abs(sin(objRotZ/180*pi))) * SizeZ
          #declare rotLibres = 0
        #end
        #if (iRow = 3 & iCol = 13)
          #declare objRotX = -5
          #declare objRotY = 3
          #declare objRotZ = -10
          #declare yPosit = (abs(sin(objRotX/180*pi)) + abs(sin(objRotZ/180*pi))) * SizeZ
          #declare rotLibres = 0
        #end

        #if (iRow = 4 & iCol = 9)
          #declare objRotX = -10
          #declare objRotZ = 30
          #declare yPosit = abs(sin(objRotZ/180*pi)) * SizeZ
          #declare rotLibres = 0
        #end
        #if (iRow = 4 & iCol = 10)
          #declare objRotX = -35
          #declare objRotZ = -3
          #declare yPosit = abs(sin(objRotX/180*pi)) * SizeZ
          #declare rotLibres = 0
        #end
        #if (iRow = 4 & iCol = 11)
          #declare objRotX = -20
          #declare objRotZ = 3
          #declare yPosit = abs(sin(objRotX/180*pi)) * SizeZ
          #declare rotLibres = 0
        #end
        #if (iRow = 4 & iCol = 12)
          #declare PasElle = 1
        #end
        #if (iRow = 4 & iCol = 13)
          #declare objRotX = 5
          #declare objRotZ = -28
          #declare xPosit = xPositBase - 0.5
          #declare yPosit = abs(sin(objRotZ/180*pi)) * SizeZ
          #declare rotLibres = 0
        #end
        #if (iRow = 4 & iCol = 14)
          #declare objRotX = 10
          #declare xPosit = xPositBase + 0.5
          #declare yPosit = abs(sin(objRotX/180*pi)) * SizeZ
          #declare rotLibres = 0
        #end

        #if (iRow = 5 & iCol = 9)
          #declare objRotX = 5
          #declare objRotZ = 3
          #declare yPosit = abs(sin(objRotX/180*pi)) * SizeZ
          #declare rotLibres = 0
        #end
        #if (iRow = 5 & iCol = 10)
          #declare PasElle = 1
        #end
        #if (iRow = 5 & iCol = 11)
          #declare PasElle = 1
        #end
        #if (iRow = 5 & iCol = 12)
          #declare objRotX = -15
          #declare objRotZ = 10
          #declare yPosit = abs(sin(objRotX/180*pi)) * SizeZ
          #declare rotLibres = 0
        #end
        #if (iRow = 5 & iCol = 13)
          #declare objRotX = 15
          #declare objRotZ = 10
          #declare yPosit = abs(sin(objRotX/180*pi)) * SizeZ
          #declare rotLibres = 0
        #end
        #if (iRow = 5 & iCol = 15)
          #declare objRotX = -35
          #declare objRotZ = 20
          #declare yPosit = abs(sin(objRotX/180*pi)) * SizeZ
          #declare rotLibres = 0
        #end
        #if (iRow = 5 & iCol = 16)
          #declare objRotZ = -30
          #declare yPosit = abs(sin(objRotZ/180*pi)) * SizeZ
          #declare rotLibres = 0
        #end

        #if (rotLibres = 1 )
          #if (rand(RandSol) < 0.45)
            #declare nbIrreg = nbIrreg + 1
            #declare objRotX = RotXBase*(rand(RandSol)-0.5)*2
            #declare objRotY = RotYBase*(rand(RandSol)-0.5)*2
            #declare objRotZ = RotZBase*(rand(RandSol)-0.5)*2
            #declare yPosit = YPositDeplBase*rand(RandSol)*2
          #end
        #else
          #declare nbIrreg = nbIrreg + 1
        #end

        #if (PasElle = 0)
          /*
          #render concat("\n    Dalle : ",str(iRow,2,0),"x",str(iCol,2,0),"  ",str(conge1,6,2),"  ",str(conge2,6,2),"  ",
                         str(objSizX,6,2),"  ", str(objSizZ,6,2), "  ",
                         str(xPosit,6,2),"  ",str(yPosit,6,2),"  ", str(zPosit,6,2),"  ",
                         str(objRotX,6,2),"  ",str(objRotY,6,2),"  ", str(objRotZ,6,2), "  ")
          */
          #declare nbPierres = nbPierres + 1
          object {
            #ifdef (Show_VraiesDalles)
              superellipsoid { <conge1, conge2>
            #else
              box { <-1, -1, -1>, <1, 1, 1>
            #end
              scale <objSizX, PEpa, objSizZ>
              rotate <objRotX, 0, 0> rotate <0, objRotY, 0> rotate <0, 0, objRotZ> translate <xPosit, yPosit, zPosit> }
            texture {
              DallesTex
              translate <TransBase*rand(RandSol), TransBase*rand(RandSol), TransBase*rand(RandSol)>
              rotate <0, RotTexBase*rand(RandSol), 0> } }
        #end

        #declare iCol = iCol + 1
      #end
      #declare iRow = iRow + 1
    #end
  }
  #render concat("\n  Dalles ", str(nbPierres,2,0),"  Irrgulires ", str(nbIrreg,2,0), "\n")

  // --- Le joint entre les dalles ---
  #declare JointCol1 = color red 0.68 green 0.58 blue 0.50
  #declare JointCol2 = color red 0.56 green 0.35 blue 0.22
  #declare JointTex = texture {
    pigment {
      bozo turbulence 2 scale 0.3
      color_map {
        [0.20 color JointCol1]
        [0.70 color JointCol2] } }
    finish { ambient 0.0 diffuse 0.90 } }

  #declare JointPierres = object {
    height_field { gif "CouteauVivantSol4.gif" translate <-0.5, 0, -0.01> scale <JointLarg, JointEpa, SolLong> }
    texture { JointTex }
    translate <0, PEpa-JointEpa-PierreAffleur, 0> }

  #declare Dallage = union {
    object { Pierres translate <-SolLarg/2, 0, 0> }
    object { JointPierres }
    translate <0, -PEpa-Espace, -30> }

  #render "  Parsing Dallage, done.\n"

  #render "\n  Parsing MurDuFond:"

  // --- L'eau sur le mur du fond ---
  #declare EauCol1 = color red 0.70 green 0.83 blue 1.00 filter 0.80
  #declare EauCol2 = color red 0.85 green 0.92 blue 1.00 filter 0.90
  #declare EauTex = texture {
    pigment {
      marble turbulence 1.50 scale 10
      color_map {
        [0.00 color EauCol1]
        [1.00 color EauCol2] } }
    normal { marble 1.90 turbulence 1.50 scale 10 }
    finish { ambient 0.40 diffuse 0.60 specular 1.10 roughness 0.020 refraction 1 ior 1.50 } }

  #declare MurEpa = 30
  #declare MurHaut = 80
  #declare MurDuFond = union {
    object {
      height_field {
        gif "CouteauVivantSol2.gif" translate <-0.5, 0, 0> scale <1, -1, 1>
        #ifdef(Show_Smooth)
          smooth
        #end  
        scale <JointLarg, MurEpa, MurHaut> rotate <-90, 0, 0> }
      texture { JointTex } }
    object {
      cylinder { <0, -100, -180>, <0, 400, -180>, 180 inverse }
      texture { EauTex } }
  }
  #render "\n  Parsing MurDuFond, done.\n"

  #declare WorldAround = union {
    object { Dallage }
    // --- Un autre pour les reflets ---
    object { Dallage scale <1, 1, -1> translate <0, 0, -40> }
    object { MurDuFond translate <0, 0, SolLong - 30 - MurEpa> } }

  #render "\nParsing WorldAround, done.\n"
#end

//----------------------------------------------------------------------------------------------------------------------------------
#render "\nParsing Lights:\n"
#declare LightCol = red 1.00 green 1.00 blue 1.00
#declare LightSoftCol = red 0.60 green 0.60 blue 0.60
#declare Light = light_source {
  <0, 0, 0>
  color LightCol
  #ifdef(Show_AreaLight)
    area_light <18, 0, 0>, <0, 18, 0>, 6, 6 jitter
  #end
}
#declare LightSoft = light_source {
  <0, 0, 0>
  color LightSoftCol
  #ifdef(Show_AreaLight)
    area_light <150, 0, 0>, <0, 150, 0>, 3, 3 jitter
  #end
}
#render "\nParsing Lights, done\n"

//----------------------------------------------------------------------------------------------------------------------------------
#ifdef(Show_Fog)
  #render "\nParsing Fog:\n"
  // background { color red 0.55 green 0.45 blue 0.20 }
  fog {
    fog_type 1 
    turbulence 1.60 octaves 9 turb_depth 0.20
    color red 0.80 green 0.70 blue 0.40 transmit 0.30
    distance 600 }
  #render "\nParsing Fog, done\n"
#end

//----------------------------------------------------------------------------------------------------------------------------------
#declare CameraDet = camera { location <0, 0, -100> direction <0, 0, 7> look_at <0, 7, 0> }

#declare CameraPoi = camera { location <0, 40, -130> direction <0, 0, 8> look_at <-5, 15, 0> }

#declare CameraHau = camera { location <1, 500, -1> direction <0, 0, 6> look_at <0, 0, 0> }

#declare CameraImg = camera {
//  location <2, 23,  -50> direction <0, 0, 1.0> look_at <-6, 11, 0>
  location <2, 23,  -50> direction <0, 0, 1.2> look_at <-4, 13, 0>
  #ifdef(Rend_Blur)
    aperture 2.00 focal_point <-10, 17, -7>
    #ifdef(Rend_Blur_Medium)
      blur_samples 4 confidence 0.90 variance 1/128
    #else
      blur_samples 100 confidence 0.987 variance 1/500
    #end
  #end
}

//----------------------------------------------------------------------------------------------------------------------------------

//object { Light translate <900, 900, -900> }
//object { LightSoft translate <-900, 900, 700> }
object { Light translate <100, 200, -100> }
camera { CameraImg }
#ifdef(Show_WorldAround)
  object { WorldAround }
#end
#ifdef(Show_Tronc)
  object { CouteauVivantTronc scale 0.45 rotate <0, 30, 0> }
#end
#ifdef (Show_Epees)
  object { Poignard scale 0.58 translate <0, 3, 0> rotate <0, -25, 0> rotate <0, 0, 9> translate <-3, 0, -10> }
  object { Epee scale 1.05 rotate <0, 0, 180> rotate <0, -20, 0> rotate <0, 0, 23> translate <-18, 16, -4> }
#end
