global_settings { assumed_gamma 2.2 }
global_settings { max_trace_level 20}
global_settings { ambient_light color rgb <0.411765, 0.411765, 0.411765> }

#include "shapes.inc"
#include "colors.inc"
#include "face2.inc"
#include "shirt4.inc"
#include "vase1.inc"
#include "vines2.inc"
#include "fl_center.inc"
#include "stem.inc"
#include "tines.inc"
#include "petal1.inc"
#include "petal2.inc"
#include "petal3.inc"
#include "petal4.inc"

#declare P_Tex=
  texture {
    pigment {
      marble
      color_map {
        [0.00 rgb<0.98, 0.93, 0.89>]
        [0.40 rgb<0.98, 0.93, 0.89>]
        [0.50 rgb<0.88, 0.83, 0.79>]
        [0.60 rgb<0.98, 0.93, 0.89>]
        [1.00 rgb<0.98, 0.93, 0.89>]
      }
      scale 0.5
    }
    normal {granite 0.4 scale 2}
    finish {specular 0.15 roughness 0.051}
  }
  texture {
    pigment {
      bozo
      color_map {
        [0.0 rgbt<0.4, 0.0, 0.0, 0.0>]
        [1.0 rgbt<0.0, 0.0, 0.0, 1.0>]
      }
    }
    normal {marble 0.73 scale 0.5}
    finish {specular 0.3 roughness 0.051}
  }

#declare MB1=
  texture {
    pigment {
      bozo
      turbulence 0.43
      color_map {
        [0.0 rgb<0.2, 0.3, 0.3>]
        [0.2 rgb<0.1, 0.2, 0.3>]
        [0.4 rgb<0.2, 0.3, 0.3>]
        [0.6 rgb<0.1, 0.3, 0.2>]
        [0.8 rgb<0.2, 0.3, 0.3>]
        [1.0 rgb<0.2, 0.3, 0.3>]
      }
    }
    normal {granite 33 turbulence 0.43}
    finish {specular 0.05 roughness 0.3}
  }
  texture {
    pigment {
      granite
      turbulence 0.43
      color_map {
        [0.0 rgbt<0.3, 0.3, 0.2, 0.5>]
        [0.2 rgbt<0.3, 0.2, 0.1, 0.0>]
        [0.4 rgbt<0.3, 0.3, 0.2, 0.5>]
        [0.6 rgbt<0.2, 0.3, 0.1, 0.0>]
        [0.8 rgbt<0.3, 0.3, 0.2, 0.7>]
        [1.0 rgbt<0.3, 0.3, 0.2, 0.5>]
      }
    }
    finish {specular 0.1 roughness 0.03}
    rotate -45*z
  }

#declare CM1=
  color_map {
    [0.0 rgbt<0.4, 0.35, 0.25, 0.0>]
    [0.15 rgbt<1.0, 1.0, 1.0, 1.0>]
    [0.5 rgbt<1.0, 1.0, 1.0, 1.0>]
    [0.9 rgbt<1.0, 1.0, 1.0, 1.0>]
    [1.0 rgbt<1.0, 1.0, 1.0, 1.0>]
  }

#declare FN1=
  finish {specular 0.15 roughness 0.3}
  
#declare VT0=
  texture {pigment {rgb<0.8, 0.7, 0.5>} finish {FN1}}

#declare VT1=
  texture {pigment {rgb<0.8, 0.7, 0.5>}}
  texture {pigment {crackle color_map {CM1}} normal {crackle 0.2} finish {FN1}}

#declare VT2=
  texture {pigment {rgb<0.8, 0.7, 0.5>}}
  texture {pigment {crackle turbulence 0.2 color_map {CM1}} normal {crackle 0.2 turbulence 0.2} finish {FN1}}

#declare VT3=
  texture {pigment {rgb<0.8, 0.7, 0.5>}}
  texture {pigment {crackle turbulence 0.4 color_map {CM1}} normal {crackle 0.2 turbulence 0.4} finish {FN1}}

#declare VT4=
  texture {pigment {rgb<0.8, 0.7, 0.5>}}
  texture {pigment {crackle turbulence 0.6 color_map {CM1}} normal {crackle 0.2 turbulence 0.6} finish {FN1}}

#declare VT5=
  texture {
    bozo
    rotate 25*z
    rotate -25*x
    texture_map {
      [0.0  VT4 scale 0.1]
      [0.1  VT3 scale 0.1]
      [0.2  VT2 scale 0.1]
      [0.3  VT1 scale 0.1]
      [0.35 VT1 scale 0.1]
      [0.55 VT0]
      [1.0  VT0]
    }
  }

#declare VaseTex1=
  texture {
    pigment {
      granite
      color_map {
        [0.0 rgb<1.00, 0.96, 0.70>]
        [0.4 rgb<1.00, 0.96, 0.70>]
        [0.5 rgb<0.4, 0.3, 0.0>]
        [0.6 rgb<1.00, 0.96, 0.70>]
        [1.0 rgb<1.00, 0.96, 0.70>]
      }
    }  
    finish {ambient 0.27 diffuse 0.41 specular 0.2 roughness 0.03}
    scale 5
  }
  texture {
    pigment {
      agate
      color_map {
        [0.00 rgbt<1, 1, 1, 1>]
        [0.10 rgbt<1, 1, 1, 1>]
        [0.48 rgbt<0.5, 0.025, 0.05, 0.0>]
        [0.50 rgbt<4.5, 0.025, 0.05, 0.0>]
        [0.52 rgbt<0.5, 0.025, 0.05, 0.0>]
        [0.90 rgbt<1, 1, 1, 1>]
        [1.00 rgbt<1, 1, 1, 1>]
      }
    }
    normal {agate 44}  
    finish {ambient 0.07 diffuse 0.1 specular 0.05 roughness 0.1}
    rotate 90*x
  }
  texture {
    pigment {
      gradient x/y
      turbulence 0.3
      color_map {
        [0.0 rgbt<1, 1, 1, 1>]
        [0.1 rgbt<1, 1, 1, 1>]
        [0.480 rgbft<0.00, 0.000, 0.00, 0.125, 0.125>]
        [0.495 rgbft<0.00, 0.000, 0.00, 0.00, 0.00>]
        [0.500 rgbft<0.50, 0.025, 0.30, 0.00, 0.00>]
        [0.505 rgbft<0.00, 0.000, 0.00, 0.00, 0.00>]
        [0.520 rgbft<0.00, 0.000, 0.00, 0.125, 0.125>]
        [0.9 rgbt<1, 1, 1, 1>]
        [1.0 rgbt<1, 1, 1, 1>]
      }
    }
    normal {granite 44}  
    finish {ambient 0.27 diffuse 0.31 specular 0.15 roughness 0.1}
    rotate -35*z
    scale 5
  }

#declare LTex1=
  texture {
    pigment {
      wood
      color_map {
        [0.05 rgb<0.5, 0.7, 0.3>]
        [0.10 rgb<0.4, 0.6, 0.2>]
        [0.30 rgb<0.0, 0.5, 0.0>]
        [0.70 rgb<0.0, 0.1, 0.0>]
        [0.85 rgb<0.4, 0.1, 0.0>]
      }
      scale <6, 48, 6>
      rotate 90*x
    }
    normal {onion 1 scale <1, 1, 0.5> translate <0, 0.7, -6.8>}
    finish {specular 0.3 roughness 0.03}
  }

#declare FaceTex1=
  texture {
    pigment {
      bozo
      turbulence 0.43
      color_map {
        [0.00 rgb<0.48, 0.40, 0.345>]
        [0.25 rgb<0.46, 0.38, 0.325>]
        [0.50 rgb<0.44, 0.36, 0.305>]
        [0.75 rgb<0.46, 0.38, 0.325>]
        [1.00 rgb<0.48, 0.40, 0.345>]
      }
    }
    normal {quilted 13.353 control1 0 control0 0 turbulence 0.43 scale <1, 0.5, 1> scale 0.5}
  }
  texture {
    pigment {
      bozo
      turbulence 0.43
      color_map {
        [0.00 rgbt<0.30, 0.20, 0.20, 0.5275>]
        [0.25 rgbt<0.32, 0.22, 0.22, 0.5275>]
        [0.50 rgbt<0.34, 0.24, 0.24, 0.5275>]
        [0.75 rgbt<0.32, 0.22, 0.22, 0.5275>]
        [1.00 rgbt<0.30, 0.20, 0.20, 0.5275>]
      }
      rotate -45
    }
    normal {quilted 13.353 control1 0 control0 0 turbulence 0.43 rotate <23, 34, 45> scale <1, 0.5, 1> scale 0.5}
    finish {specular 0.01 roughness 0.1}
    scale 0.5
  }
  texture {
    pigment {
      bozo
      turbulence 0.783
      color_map {
        [0.00 rgbt<0.2400, 0.2000, 0.1725, 0.475>]
        [0.25 rgbt<0.2350, 0.1950, 0.1675, 0.475>]
        [0.50 rgbt<0.2300, 0.1900, 0.1625, 0.475>]
        [0.75 rgbt<0.2350, 0.1950, 0.1675, 0.475>]
        [1.00 rgbt<0.2400, 0.2000, 0.1725, 0.475>]
      }
      rotate 45
      scale 0.5
    }
    normal {quilted 13.353 control1 0 control0 0 turbulence 0.43 rotate <23, 34, 45> scale <1, 0.5, 1> scale 0.5}
    finish {specular 0.01 roughness 0.01}
  }


camera {
  location <0, 25, -75>
  direction <0, 0,  1>
  up  <0, 1, 0>
  right <4/3, 0, 0>
  look_at <0, -15, 40>
}

background { color rgb <0, 0, 0> }

light_source { <0, 497, 2000> 
  color rgb <1.5, 1.5, 1.5>
  fade_distance 800
  fade_power 5
}

light_source { <500, 497, 2000> 
  color rgb <1.5, 1.5, 2.1>
  fade_distance 800
  fade_power 5
}

light_source { <-500, 497, 2000> 
  color rgb <1.5, 1.5, 2.1>
  fade_distance 800
  fade_power 5
}

light_source { <129, 97, -103> 
  color rgb <0.5, 0.5, 0.5> 
  fade_distance 258
  fade_power 5
}

light_source { <-69, 126, -253> 
  color rgb <0.5, 0.3, 0.0> 
  fade_distance 506
  fade_power 5
}

light_source { <89, -17, -3> 
  color rgb <0.35, 0.35, 0.5> 
  fade_distance 120
  fade_power 5
}

sphere {0, 100 
  translate 2000*z 
  texture {
    pigment {rgb<0.1, 0.1, 0.2>}
    finish {reflection 1}
  }
}

height_field {tga "moss.tga" 
  smooth 
  translate <-0.5, 0, -0.5>
  scale <220, 5, 220>
  translate <0, -38, 0>
  texture {
    pigment {
      spiral1 2
      turbulence 0.92
      color_map {
        [0.0 color rgb<0.0, 0.0, 0.0>]
        [0.2 color rgb<0.0, 0.2, 0.0>]
        [0.5 color rgb<0.1, 0.2, 0.0>]
        [0.8 color rgb<0.0, 0.2, 0.0>]
        [1.0 color rgb<0.0, 0.0, 0.0>]
      }
      rotate 90*x
      scale 10
      translate <40, -40, 40>
    }
    finish {specular 0.05 roughness 0.51}
  }
}

#declare Steps1=
  union {  
    box {<-200, -40, 100>, <200, -30, 120>}
    box {<-200, -30, 120>, <200, -20, 140>}
    box {<-200, -20, 140>, <200, -10, 300>}
    box {<100, -40, 120>, <120, -30, -160>}
    box {<120, -30, 140>, <140, -20, -160>}
    box {<140, -20, 300>, <200, -10, -160>}
    box {<-100, -40, 120>, <-120, -30, -160>}
    box {<-120, -30, 140>, <-140, -20, -160>}
    box {<-140, -20, 300>, <-200, -10, -160>}
    texture {MB1 scale <20, 15, 5>}
  }

#declare Ccut1=
cylinder {<0, 0, -18>, <0, 0, 18>, 1 scale <10, 88, 1>}

// COLUMN
difference {
  box {<-15, 0, -15>, <15, 150, 15> translate <70, -40, 70>}
  object {Ccut1 translate <50, 35, 70>}
  object {Ccut1 translate <90, 35, 70>}
  object {Ccut1 rotate 90*y translate <70, 35, 50>}
  object {Ccut1 rotate 90*y translate <70, 35, 90>}
  texture {VaseTex1 scale <25, 10, 5> translate 10*y rotate 25*y}
}

#declare L1=
  union {
    sphere {0, 2 
      scale <1, 0.5, 2>
      rotate <0, -14, -24>
      clipped_by {box {<-6, -6, -6>, <6, 0, 6> inverse}}
      clipped_by {box {<-6, 6, -6>, <0.001, -1, 6>}}
    }
    sphere {0, 2 
      scale <1, 0.5, 2>
      rotate <0, 14, 24>
      clipped_by {box {<-6, -6, -6>, <6, 0, 6> inverse}}
      clipped_by {box {<6, 6, -6>, <-0.001, -1, 6>}}
    }
    rotate -20*x
    texture {LTex1}
    translate <0, 0.7, -6.8>
  }

#declare L2=
  union {
    sphere {0, 2 scale <1, 0.5, 2> rotate <0, -14, -24>}
    sphere {0, 2 scale <1, 0.5, 2> rotate <0, 14, 24>}
    rotate -20*x
    translate <0, 0.7, -6.8>
  }

#declare Stem1=
  torus {1.8, 0.2
    rotate 90*z
    scale <1, 1.5, 1>
    rotate -7*x
    clipped_by {box {<-6, -6, 0>, <6, 6, 6>}}
    rotate -38*x
    clipped_by {box {<-6, 0, -6>, <6, 6, 6>}}
    translate -2.1*z
    clipped_by {object {L2 inverse}}
    texture {
      pigment {green 0.5}
      finish {specular 0.3 roughness 0.1}
    }
  }

#declare Leaf1=
  union {
    object {L1}
    object {Stem1}
  }

#declare Leaf2=
union {
//object {Leaf1 rotate <0, 90, 0> translate<-16.00,   0.00,  -1.00>}
//// LEFT
object {Leaf1 rotate <-14, 90, 0> translate<-15.75,   1.50,  -4.50>}
object {Leaf1 rotate <15, 80, 0> translate<-15.75,   4.25,   9.00>}
//// FRONT
object {Leaf1 translate <-14.00,   8.00, -16.00>}
object {Leaf1 rotate <0, -20, 35> translate<  0.00,  12.00, -14.00>}
/////object {Leaf1 rotate <0, -70, 0> translate<  9.00,  17.00, -13.00>}
object {Leaf1 rotate <0, -70, 0> translate<  11.00,  16.00, -12.00>}
//object {Leaf1 rotate <0, -90, 0> translate< 13.00,  21.00,  -9.00>}
//object {Leaf1 rotate <0, -90, 0> translate< 13.00,  26.00,   0.00>}
//object {Leaf1 translate< 12.00,  30.00,   3.00>}
//object {Leaf1 translate<  9.00,  33.00,  12.00>}
//object {Leaf1 translate<  0.00,  37.00,  12.00>}
//// LEFT
object {Leaf1 rotate <0, 90, 0> translate< -9.00,  42.00,  12.00>}
object {Leaf1 rotate <0, 90, 0> translate<-13.00,  47.00,   9.00>}
object {Leaf1 rotate <-30, 90, 0> rotate -20*x translate<-12.00,  50.00,   0.00>}
//// FRONT
object {Leaf1 translate <-13.00,  55.00,  -9.00>}
object {Leaf1 rotate <30, 0, -20> translate< -9.00,  59.00, -12.00>}
object {Leaf1 rotate <-45, 0, 0> translate<  0.00,  62.00, -11.00>}
object {Leaf1 translate<  9.00,  67.00, -11.00>}
//// RIGHT
object {Leaf1 rotate <0, -90, 0> translate< 12.00,  73.00,  -9.00>}
object {Leaf1 rotate <0, -90, 0> translate< 13.00,  76.00,   0.00>}
object {Leaf1 rotate <0, -90, 0> translate< 12.00,  79.00,   9.00>}
//// BACK
object {Leaf1 rotate <0, 180, 0> translate<  9.00,  84.00,  12.00>}
object {Leaf1 rotate <0, 180, 0> translate<  0.00,  89.00,  12.00>}
object {Leaf1 rotate <0, 180, 0> translate< -9.00,  93.00,  12.00>}
//// LEFT
object {Leaf1 rotate <0, 90, 0> translate<-12.00,  96.00,   9.00>}
object {Leaf1 rotate <0, 90, 0> translate<-12.00, 100.00,   0.00>}
object {Leaf1 rotate <0, 90, 0> translate<-13.00, 104.00, -13.00>}
//// FRONT
object {Leaf1 translate< -9.00, 108.00, -12.00>}
object {Leaf1 translate<  0.00, 112.00, -13.00>}
object {Leaf1 translate<  9.00, 114.00, -12.00>}
//// RIGHT
object {Leaf1 rotate <0, -90, 0> translate< 14.00, 122.00,  -9.00>}
object {Leaf1 rotate <0, -90, 0> translate< 14.00, 126.00,   0.00>}
object {Leaf1 rotate <0, -90, 0> translate< 14.00, 130.00,   9.00>}
//// BACK
object {Leaf1 rotate <0, 180, 0> translate<  9.00, 134.00,  14.00>}
object {Leaf1 rotate <0, 180, 0> translate<  0.00, 138.00,  15.00>}
object {Leaf1 rotate <0, 180, 0> translate< -9.00, 140.00,  14.00>}
//// LEFT
object {Leaf1 rotate <0, 90, 0> translate<-17.00, 146.00,  12.00>}
object {Leaf1 rotate <0, 90, 0> translate<-16.00, 148.00,   2.00>}
object {Leaf1 rotate <0, 90, 0> translate<-16.00, 150.00,  -1.00>}
translate <70, -40, 70>
}

object {Leaf2}

object {Face2
  texture {FaceTex1}
  rotate <-15, -60, 0>
  translate <-20, 0, -10>
}

object {Shirt
  texture {
    pigment {rgb<0.0, 0.0, 0.2>}
    normal {quilted 3 control0 1 control1 1 turbulence 0.54}
    finish {specular 0.1 roughness 0.7}
  }
  rotate <-15, -60, 0>
  translate <-20, 0, -10>
}

object {Vine1
  texture {
    pigment {green 0.5}
    finish {specular 0.3 roughness 0.01}
  }
  translate <70, -40, 70>
}

object {Vase1
  texture {VT5 scale <18, 38, 18>}
  translate <40, -40, 40>
}

object {Steps1}

height_field {tga "ht3.tga" 
  smooth 
  translate <-0.5, 0, -0.5>
  rotate -25*y
  scale <13000, 5000, 13000>
  translate <0, -60, 0>
  texture {pigment {rgb<0.3, 0.3, 0.25>}}
}

object {fl_center 
  texture {
    pigment {
      crackle
      color_map {
        [0.0 rgb<0.6, 0.4, 0.0>]
        [1.0 rgb<1.0, 1.0, 0.0>]
      }
    }
    normal {crackle 1}
    finish {specular 0.3 roughness 0.051}
    scale 0.4
  }
  rotate -35*y 
  translate <40, -40, 40>
  translate <0.25, 0, -1.25>
}

object {stem 
  texture {
    pigment {rgb<0.4, 0.77, 0.0>}
    finish {specular 0.1 roughness 0.051}
  }
  rotate -35*y 
  translate <40, -40, 40>
  translate <0.25, 0, -1.25>
}

object {tines 
  texture {
    pigment {rgb<0.5, 0.5, 0.5>}
    finish {specular 0.3 roughness 0.1}
  }
  rotate -35*y 
  translate <40, -40, 40>
  translate <0.25, 0, -1.25>
}

object {petal1
  texture {P_Tex translate 44*y rotate -45*z}
  rotate -35*y 
  translate <40, -40, 40>
  translate <0.25, 0, -1.25>
}

object {petal2 
  texture {P_Tex translate -44*y rotate -135*z}
  rotate -35*y 
  translate <40, -40, 40>
  translate <0.25, 0, -1.25>
}

object {petal3 
  texture {P_Tex translate 144*y rotate 135*z}
  rotate -35*y 
  translate <40, -40, 40>
  translate <0.25, 0, -1.25>
}

object {petal4 
  texture {P_Tex translate -144*y rotate 25*z}
  rotate -35*y 
  translate <40, -40, 40>
  translate <0.25, 0, -1.25>
}
