#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
#include "glass.inc"
#include "metals.inc"

camera
{
  location  <0.0 , 3.0 , -10.0>
  look_at   <0.0 , 0.0 , 10.0>
  aperture 0.5
  blur_samples 16
  focal_point <-3.0, 3.0, 2.0>
}

light_source
{
  <0.0, 11.0, 7.0>
  rgb <5.0, 5.0, 5.0>
  area_light
  <-0.2, 0, -0.2> <0.2, 0, 0.2>
  4, 4
  adaptive 0
  jitter
}

light_source
{
  <0.0, 3.0, -10.0>
  color rgb <0.7, 0.0, 0.0>
  spotlight
  point_at <5.0, 0.0, 5.0>
  radius 30.0
  tightness 50.0
  falloff 40.0
}

fog
{
  distance 150
  colour rgbf <0.3, 0.3, 0.7, 0.7>
  turbulence 0.2
  turb_depth 0.3
}

//background { color red 0.1 green 0.3 blue 0.8 }

// ---------------------------------------------------------------------

#declare Altitude_Surface = 10.0
#declare Largeur_Batiment = 10.0
#declare Hauteur_Batiment = 4.0
#declare Rayon_Sphere_Batiment = 1.6*Hauteur_Batiment
#declare Rayon_Sphere_Dome = 2.0*Hauteur_Batiment
#declare Largeur_Couloir = 1.0
#declare Longueur_Couloir = 20.0
#declare Largeur_Arceau = 0.2
#declare Epaisseur_Arceau = 0.1

// ---------------------------------------------------------------------
#declare Manta_Dessus = bicubic_patch
{
  type 1
  flatness 0.1
  u_steps 3
  v_steps 3
  <-6, 0, 6> <-1, -2, 3> <1, 0, 3> <2.5, 0, 2.5>
  <-3, -2, 1> <-1, 2, 1> <1, 2, 1> <3, 0, 1>
  <-3, 0, -1> <-1, 2, -1> <1, 2, -1> <3, -2, -1>
  <-9, 1, -9> <-1, 0, -3> <1, -2, -3> <6, 0, -6>
}

#declare Manta_Dessous = bicubic_patch
{
  type 1
  flatness 0.1
  u_steps 3
  v_steps 3
  <-6, 0, 6> <-1, -2, 3> <1, 0, 3> <2.5, 0, 2.5>
  <-3, -2, 1> <-1, 0, 1> <1, 0, 1> <3, 0, 1>
  <-3, 0, -1> <-1, 0, -1> <1, 0, -1> <3, -2, -1>
  <-9, 1, -9> <-1, 0, -3> <1, -2, -3> <6, 0, -6>
}

#declare Manta = union
{
  object { Manta_Dessus }
  object { Manta_Dessous }
  rotate -45*y
  //pigment { Red }
  texture { T_Stone17 scale 10 finish { reflection 0.0 } }
}

#declare Arceau = difference
{
  cylinder
  {
    <0.0, 0.0, 0.0>
    <0.0, 0.0, Largeur_Arceau>
    Largeur_Couloir+Epaisseur_Arceau
  }
  cylinder
  {
    <0.0, 0.0, -1.0>
    <0.0, 0.0, 1.0+Largeur_Arceau>
    Largeur_Couloir
  }
  difference
  {
    cylinder
    {
      <0.0, 0.0, 0.0>
      <0.0, 0.0, Largeur_Arceau*0.8>
      Largeur_Couloir+Epaisseur_Arceau+1.0
    }
    cylinder
    {
      <0.0, 0.0, -1.0>
      <0.0, 0.0, 1.0+Largeur_Arceau*0.8>
      Largeur_Couloir+Epaisseur_Arceau*0.5
    }
    translate z*0.1
  }
  texture { T_Silver_1A }
  //pigment { Yellow }
}

#declare Couloir = difference
{
  union
  {
    cylinder
    {
      < 0.0, 0.0, 0.0>
      < 0.0, 0.0, Longueur_Couloir>
      Largeur_Couloir
      pigment { White filter 1.0 }
      finish
      {
        ambient 0.0
        diffuse 0.0
        reflection 0.25
        refraction 1.0
        ior 1.33
        specular 1.0
        roughness 0.001
      }
      //pigment { Red }
    }
    object { Arceau translate <0.0, 0.0, 0.0*(Longueur_Couloir/5)> }
    object { Arceau translate <0.0, 0.0, 1.0*(Longueur_Couloir/5)> }
    object { Arceau translate <0.0, 0.0, 2.0*(Longueur_Couloir/5)> }
    object { Arceau translate <0.0, 0.0, 3.0*(Longueur_Couloir/5)> }
    object { Arceau translate <0.0, 0.0, 4.0*(Longueur_Couloir/5)> }
    rotate 30.0*y
    translate <-5.0, 0.0, -12.0>
  }
  sphere
  {
    <5.0, 0.0, 5.0+Largeur_Batiment/2>
    Rayon_Sphere_Dome
  }
}

#declare Dome = difference
{
  sphere
  {
    <0.0, 0.0, 0.0>
    Rayon_Sphere_Dome
  }
  box
  {
    <-0.1-Rayon_Sphere_Dome, 0.0, -0.1-Rayon_Sphere_Dome>
    <0.1+Rayon_Sphere_Dome, -4*Rayon_Sphere_Dome, 0.1+Rayon_Sphere_Dome>
  }
  pigment { White filter 1.0 }
  finish
  {
    ambient 0.0
    diffuse 0.0
    reflection 0.25
    refraction 1.0
    ior 1.33
    specular 1.0
    roughness 0.001
    fade_distance 5.0
    fade_power 1.0
    caustics 1.0
    irid
    { 0.35 thickness 0.5 turbulence 0.5 }
  }
//  pigment {Yellow}
  translate <0.0, 0.0, Largeur_Batiment/2>
}

#declare Batiment_Structure = merge
{
  difference
  {
    sphere
    {
      <0.0, -Hauteur_Batiment/2, 0.0>
      Rayon_Sphere_Batiment
    }
    box
    {
      <-0.1-Rayon_Sphere_Batiment, 0.0, -0.1-Rayon_Sphere_Batiment>
      <0.1+Rayon_Sphere_Batiment, -4*Rayon_Sphere_Batiment, 0.1+Rayon_Sphere_Batiment>
    }
    translate z*Largeur_Batiment/2
  }
  difference
  {
    box
    {
      <-Largeur_Batiment/2, 0.0, 0.0>
      <Largeur_Batiment/2,  Hauteur_Batiment, Largeur_Batiment>
    }
    merge
    {
      box
      {
        <-3*Largeur_Batiment/8, 0.0, 0.0>
        <3*Largeur_Batiment/8, 2*Hauteur_Batiment, Largeur_Batiment/2>
        translate (-Largeur_Batiment/2)*z
        rotate 35*x
      }
      box
      {
        <-3*Largeur_Batiment/8, 0.0, 0.0>
        <3*Largeur_Batiment/8, 2*Hauteur_Batiment, Largeur_Batiment/2>
        rotate -35*x
        translate Largeur_Batiment*z
      }
    }
  }
  texture
  {
    T_Gold_3C
    //pigment { Red }
  }
}

#declare Immeubles = merge
{
  box { <2.5, 0.0, 2.5> <4.5, 5.0, 4.5> }
  box { <-2.5, 0.0, 2.5> <-3.5, 4.0, 4.5> }
  box { <-2.5, 0.0, 0.0> <-3.5, 3.5, 2.0> }
  box { <3.0, 0.0, -1.0> <4.0, 4.0, 1.0> }
  cylinder { <2.0, 0.0, 3.5> <2.0, 4.5, 3.5> 1.0 }
  cylinder { < -1.0, 0.0, 3.5> <-1.0, 5.5, 3.5> 0.2 }
  cone { <-1.0, 4.0, 3.5> 0.2 < -1.0, 4.3, 3.5> 1.0 }
  texture
  {
    T_Gold_3C
    //pigment { Red }
  }
}

#declare Batiment = union
{
  object { Batiment_Structure scale 0.5}
  object { Immeubles }
  object { Dome }
  rotate 25*y
  translate <5.0, 0.0, 5.0>
}

#declare Fond2 = plane
{
  y,
  0.0
  texture
  {
    pigment
    {
      color <0.15, 0.5, 0.55>
    }
    normal { bumps 1.0 scale 5.0 }
  }
}

#declare Fond = plane
{
  y,
  0.0
  texture
  {
    pigment { color <0.15, 0.5, 0.55> }
    normal { ripples }
    scale 5
    translate 50*x
  }
}

#declare Surface = plane
{
  y, Altitude_Surface
  texture
  {
    T_Glass4
    normal { ripples 0.7 }
    scale 5
    rotate 30*y
  }
  hollow
}

// ---------------------------------------------------------------------

object { Fond2 }
object { Surface }
object { Batiment }
object { Couloir }
object { Manta scale 0.5 rotate -10*x rotate 25*z rotate -45*y translate <-3.0, 3.0, 2.0> }
