// Persistence of Vision Raytracer
// herbs

object{
      height_field{
         tga "terre1.tga"     // the file name to read
         smooth
         clipped_by {cylinder {-10*y, 10*y, 26/30}}
         translate <-.5, 0, -.5>
         rotate 120*y
         //translate <-.5, -.83, -.5>
         translate <-.15, -.50, 0>
         scale <500, 200, 500>*<5, 1, 5>
         }

pigment {Green*.5}
normal {bumps turbulence 1 bump_size 1.0 scale .2}
finish {phong .3 phong_size 10}
}

//Castle

#include "coeur.inc"
#include "pique.inc"

#declare Castle1=object {
   union {
      //box {<-50, 0, -150>, <50, 100, 150>}
      cylinder {-50*x, 50*x, 1 scale <1, 50, 10> translate <0, 50, -150>}
      cylinder {-50*x, 50*x, 1 scale <1, 50, 10> translate <0, 50, 150>}
      difference{
         union{
            cylinder {-150*z, 150*z, 1 scale <10, 50, 1> translate <50, 50, 0>}
            cylinder {-150*z, 150*z, 1 scale <10, 50, 1> translate <-50, 50, 0>}
            }
         object {coeur rotate -90*z rotate -90*x scale <1000, 80, 60> translate <-500, -40, -30>}
         object {coeur rotate -90*z rotate -90*x scale <1000, 20, 20> translate <-500, 50, 50>}
         object {coeur rotate -90*z rotate -90*x scale <1000, 20, 20> translate <-500, 50, -50>}
         object {coeur rotate -90*z rotate -90*x scale <1000, 20, 20> translate <-500, 30, 100>}
         object {coeur rotate -90*z rotate -90*x scale <1000, 20, 20> translate <-500, 30, -100>}
         difference{
            box {<-80, 80, -200>, <80, 150, 200>}
            object {coeur rotate -90*z rotate -90*x scale <1000, 20, 20> translate <-500, 80, 0>}
            object {coeur rotate -90*z rotate -90*x scale <1000, 20, 20> translate <-500, 80, -50>}
            object {coeur rotate -90*z rotate -90*x scale <1000, 20, 20> translate <-500, 80, 50>}
            object {coeur rotate -90*z rotate -90*x scale <1000, 20, 20> translate <-500, 80, -100>}
            object {coeur rotate -90*z rotate -90*x scale <1000, 20, 20> translate <-500, 80, 100>}
            object {pique rotate -90*z rotate -90*x scale <1000, 20, 25> translate <-500, 80, -25>}
            object {pique rotate -90*z rotate -90*x scale <1000, 20, 25> translate <-500, 80, 25>}            object {pique rotate -90*z rotate -90*x scale <1000, 20, 20> translate <-500, 80, -25>}
            object {pique rotate -90*z rotate -90*x scale <1000, 20, 25> translate <-500, 80, -75>}
            object {pique rotate -90*z rotate -90*x scale <1000, 20, 25> translate <-500, 80, 75>}
            object {pique rotate -90*z rotate -90*x scale <1000, 20, 25> translate <-500, 80, -125>}
            object {pique rotate -90*z rotate -90*x scale <1000, 20, 25> translate <-500, 80, 125>}            object {pique rotate -90*z rotate -90*x scale <1000, 20, 20> translate <-500, 80, -25>}
            }
         }
      sphere {0, 1 scale <20, 100, 20> translate <-50, 50, -150>}
      sphere {0, 1 scale <20, 100, 20> translate < 50, 50, -150>}
      sphere {0, 1 scale <20, 100, 20> translate <-50, 50,  150>}
      sphere {0, 1 scale <20, 100, 20> translate < 50, 50,  150>}
      }
   pigment {White}
   finish {ambient 0.4 phong 1 phong_size 30}
   }

#include "coupole.inc"

#declare Castle2=object {
   union {
      object {Coupole scale 80*<1, 1.2, 1> translate <  50, 110,  150>}
      object {Coupole scale 80*<1, 1.2, 1> translate < -50, 110,  150>}
      object {Coupole scale 80*<1, 1.2, 1> translate <  50, 110, -150>}
      object {Coupole scale 80*<1, 1.2, 1> translate < -50, 110, -150>}
      difference{
         cylinder {-150*z, 150*z, 1 scale <8, 48, 1> translate <50, 50, 0>}
         box {<-80, 79, -200>, <80, 150, 200>}
         }
      }
   pigment {Red}                           
   normal {crackle bump_size 10 scale 1.5}
   finish {
      ambient 0.2 
      phong 3 phong_size 35
      reflection 0.2
      }
}

#declare RoseSeed=seed(10);
#macro SmallRose()
   union {
      cylinder {
         0, 10*y, .3
         pigment {Brown}
         }
      blob {
         threshold 0.6
         sphere { 10*y, 5, 1 }
         sphere { 8.5*y+3*<rand(RoseSeed), rand(RoseSeed), rand(RoseSeed)>, 2+2*rand(RoseSeed), 1 }
         sphere { 8.5*y+3*<rand(RoseSeed), rand(RoseSeed), rand(RoseSeed)>, 2+2*rand(RoseSeed), 1 }
         sphere { 8.5*y+3*<rand(RoseSeed), rand(RoseSeed), rand(RoseSeed)>, 2+2*rand(RoseSeed), 1 }
         sphere { 8.5*y+3*<rand(RoseSeed), rand(RoseSeed), rand(RoseSeed)>, 2+2*rand(RoseSeed), 1 }
         sphere { 8.5*y+3*<rand(RoseSeed), rand(RoseSeed), rand(RoseSeed)>, 2+2*rand(RoseSeed), 1 }
         pigment {
            leopard turbulence 0.2 color_map {
               [0.0 LimeGreen *1.2 filter 0.3]
               [0.7 LimeGreen *1.2 filter 0.3]
               [0.7 Red]
               [1.0 Red]
               }
            scale 0.3
            }
         finish {crand 0.4 ambient 0.4}
         translate -1.5*y
         }
      #local i=0;
      #while (i<0)
         sphere {
            3.5*x, .5 
            rotate 360*<0, rand(RoseSeed), rand(RoseSeed)> 
            translate 10*y 
            pigment {Red}
            finish {crand 0.2 ambient 0.4}
            }
         #local i=i+1;
         #end
      }
   #end

#macro RoseBorder()
   object {SmallRose() scale 2 translate <70, -1.4, -30>}
   object {SmallRose() scale 2 translate <70, -1.5, -45>}
   object {SmallRose() scale 2 translate <70, -1.2, -60>}
   object {SmallRose() scale 2 translate <70, -0.8, -75>}
   object {SmallRose() scale 2 translate <70, -0.5, -90>}
   object {SmallRose() scale 2 translate <70, -0.3, -105>}
   object {SmallRose() scale 2 translate <70, -0.0, -120>}

   object {SmallRose() scale 2 translate <70, -1.4, 30>}
   object {SmallRose() scale 2 translate <70, -1.5, 45>}
   object {SmallRose() scale 2 translate <70, -1.2, 60>}
   object {SmallRose() scale 2 translate <70, -0.8, 75>}
   object {SmallRose() scale 2 translate <70, -0.5, 90>}
   object {SmallRose() scale 2 translate <70, -0.3, 105>}
   object {SmallRose() scale 2 translate <70, -0.0, 120>}
   #end

#declare Castle=union {
   object {Castle1}
   object {Castle2}
   RoseBorder()
   scale 2
   }
   
object {Castle translate <-1100, 12, -100>}   