
//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// PTD_Tree.inc - Almost totally random nested loop tree!
//
// Version SEPT-19-96
//
// Created by: Paul T. Dawson
//             ptdawson@voicenet.com
//             http://www.voicenet.com/~ptdawson
//
// This version modified by F. Dispot to include roses and blob trunk.
//             wozzeck@club-internet.fr
//             http://www.geocities.com/Vienna/7709
//
// <=>-<=>-<=>-<=>-<=>-<=>-<=>-<=>-<=>-<=>-<=>-<=>
// <=>-<=>-<=>-<=>                 <=>-<=>-<=>-<=>
// <=>-<=>-<=>-<=>  PUBLIC DOMAIN  <=>-<=>-<=>-<=>
// <=>-<=>-<=>-<=>                 <=>-<=>-<=>-<=>
// <=>-<=>-<=>-<=>-<=>-<=>-<=>-<=>-<=>-<=>-<=>-<=>
//
// Requires POV-Ray 3.0, with the new "rand" function, and loops!
//
// Thank you, POV-Team, for your magnificent program!!!
//
//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Note: This file does NOT display the tree. It just makes an object
//       called "Complete_Tree". Then your scene file can show that!
//
// Note: Your main scene file must have all of the usual include files,
//       including "colors.inc" and "textures.inc". If you use any
//       special textures, like "golds" or "stones", you will need to
//       include those files, too (but you-all knew all that!).
//
// Note: Realistic trees use a *LOT* of memory!!!
//
// Note: All of the tree variables MUST be declared in your scene file!
//
//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Now, start building the tree!
//
// Don't change anything below here (unless you really want to!).
//
//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Don't change these - they are calculated from your variables.

        #declare L_Bmin = Large_Branch_Minimum_Angle;
        #declare L_Bmax = Large_Branch_Maximum_Angle
                          - Large_Branch_Minimum_Angle;
        
        #declare M_Bmin = Medium_Branch_Minimum_Angle;
        #declare M_Bmax = Medium_Branch_Maximum_Angle
                          - Medium_Branch_Minimum_Angle;
        
        #declare S_Bmin = Small_Branch_Minimum_Angle;
        #declare S_Bmax = Small_Branch_Maximum_Angle
                          - Small_Branch_Minimum_Angle;

        #declare Large_Branch_Size_Range =
        Large_Branch_Size_Max - Large_Branch_Size_Min;

        #declare Medium_Branch_Size_Range =
        Medium_Branch_Size_Max - Medium_Branch_Size_Min;

        #declare Small_Branch_Size_Range =
        Small_Branch_Size_Max - Small_Branch_Size_Min;

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Create one of the leaf styles.
//
// Note: To save memory, the leaves do not get a texture until the
//       very end of the Complete_Tree union. That way, all of the leaves
//       can share one texture. This saves a LOT of memory. You can
//       change this around if you want to, and put the textures up
//       here (memory is cheap, I know, I know!).
//
//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Now create the actual REALISTIC (sort-of) leaf.

        #if ( Leaf_Type = 0 )

        #declare One_Leaf =

        union{

                // Leaf part #1
                sphere{ 0, 3 scale < 0.4, 0.1, 1.0 >
                        translate z * 3
                        rotate x * -30
                        rotate y * 0 }

                // Leaf part #2
                sphere{ 0, 3 scale < 0.4, 0.1, 1.0 >
                        translate z * 3
                        rotate x * -30
                        rotate y * 120 }

                // Leaf part #3
                sphere{ 0, 3 scale < 0.4, 0.1, 1.0 >
                        translate z * 3
                        rotate x * -30
                        rotate y * 240 }

                // Scale the entire union. Make the leaf small for
                // testing branch placement, then make it big!

                        scale 0.2
                texture { Leaf_Texture }

        } // End of union.

        #end

// Now create the actual FAST leaf.

        #if ( Leaf_Type = 1 )

                #declare One_Leaf = sphere{ 0, 0.3 }
                        texture { Leaf_Texture }

        #end

// Now create the actual STRANGE leaf. Change this to anything!

        #if ( Leaf_Type = 2 )

        #declare One_Leaf = union {

                sphere { 0, 0.3 }

                difference {

                        box { < -1, -1, -1 > < 1, 1, 1 > }

                        sphere { 0, 1.3 }

		} // End of difference.
                texture { Leaf_Texture }

        } // End of union.

        #end

// Now create the actual TORUS leaf. This one has a texture!!!

        #if ( Leaf_Type = 3 )

        #declare One_Leaf = union {

                torus { 1, 0.25 pigment { checker Red, Yellow scale 10 } }

                cylinder { < -1, 0,  0 > < 1, 0, 0 >, 0.1
                pigment { checker Blue, Cyan scale 0.1 } }

                cylinder { <  0, 0, -1 > < 0, 0, 1 >, 0.1
                pigment { checker Blue, Cyan scale 0.1 } }

        } // End of union.

	#end

// Create the MESH leaf object - with lots of little triangles!!!
        
        #if ( Leaf_Type = 4 )

        #declare One_Leaf = mesh {

        #declare A = 1; #while ( A <= TREE_MESH_SIZE )
        
                // Calculate random location for first point.
                #declare X1 = ( rand(TREE_RAND) * 2 ) - 1;
                #declare Y1 = ( rand(TREE_RAND) * 2 ) - 1;
                #declare Z1 = ( rand(TREE_RAND) * 2 ) - 1;

                // Move a little way from *first* point.
                #declare X2 = X1 + ( rand(TREE_RAND) * 0.6 ) - 0.3;
                #declare Y2 = Y1 + ( rand(TREE_RAND) * 0.6 ) - 0.3;
                #declare Z2 = Z1 + ( rand(TREE_RAND) * 0.6 ) - 0.3;

                // Move a little way from *first* point.
                #declare X3 = X1 + ( rand(TREE_RAND) * 0.6 ) - 0.3;
                #declare Y3 = Y1 + ( rand(TREE_RAND) * 0.6 ) - 0.3;
                #declare Z3 = Z1 + ( rand(TREE_RAND) * 0.6 ) - 0.3;
                
                // Make the triangle.
                triangle { <X1, Y1, Z1>, <X2, Y2, Z2>, <X3, Y3, Z3> }

        #declare A = A + 1; #end
                texture { Leaf_Texture }

        } // End of mesh.

        #end

// Create the ULTRA-MESH leaf object - with lots of little triangles,
// and each "leaf" has a connector "branch" back to <0,0,0>.
        
        #if ( Leaf_Type = 5 )

        #declare One_Leaf = mesh {

        #declare A = 1 #while ( A <= TREE_MESH_SIZE )
        
                // Calculate random location for first point.
                #declare X1 = ( rand(TREE_RAND) * 2 ) - 1;
                #declare Y1 = ( rand(TREE_RAND) * 2 ) - 1;
                #declare Z1 = ( rand(TREE_RAND) * 2 ) - 1;

                // Move a little way from *first* point.
                #declare X2 = X1 + ( rand(TREE_RAND) * 0.6 ) - 0.3;
                #declare Y2 = Y1 + ( rand(TREE_RAND) * 0.6 ) - 0.3;
                #declare Z2 = Z1 + ( rand(TREE_RAND) * 0.6 ) - 0.3;

                // Move a little way from *first* point.
                #declare X3 = X1 + ( rand(TREE_RAND) * 0.6 ) - 0.3;
                #declare Y3 = Y1 + ( rand(TREE_RAND) * 0.6 ) - 0.3;
                #declare Z3 = Z1 + ( rand(TREE_RAND) * 0.6 ) - 0.3;
                
                // Make the "leaf" triangle.
                triangle { <X1, Y1, Z1>, <X2, Y2, Z2>, <X3, Y3, Z3> }
                
                // Make the "branch" triangles.
                triangle { <X1, Y1, Z1>, <0, 0, 0>, <0,   0, 0.1> }
                triangle { <X1, Y1, Z1>, <0, 0, 0>, <0.1, 0, 0  > }

        #declare A = A + 1; #end
                texture { Leaf_Texture }

        } // End of mesh.

        #end
        
#declare PREC = 15;

#declare Z2_1 =julia_fractal {
   <-0.083,0.0,-0.83,-0.025>
   quaternion
   sqr
   max_iteration 8
   precision PREC
   rotate 90*z
   scale <1, .6, 1>
   }

#declare Red_Rose=object {
   Z2_1 scale .7 
   pigment {Red}
   finish {Dull ambient .3}
   }

#declare White_Rose=object {
   Z2_1 scale .7 
   pigment {White}
   finish {Dull ambient .3}
   }

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Now create the tree trunk.

//Original version

        #declare Tree_Trunk_ = union { 
                
                cone { < 0, 0, 0 >, 1.00 < 0, Tree_Trunk_Size, 0 >, 0.80 }
                sphere { < 0, Tree_Trunk_Size, 0 >, 0.80 }

                texture { Bark_Texture }
                
                } // End of union.

//Custom version

        #declare Tree_Trunk = blob {
   // threshold (0.0 < threshold <= StrengthVal) surface falloff threshold #
   #declare StrengthVal = 1.0; // (+ or -) strength of component's radiating density
   #declare RadiusVal   = 0.3; // (0 < RadiusVal) outer sphere of influence on other components
   threshold 0.6
   sphere { < 0.75,   0,    0>, StrengthVal, RadiusVal }
   sphere { <-0.375,  0.65, 0>, StrengthVal, RadiusVal }
   sphere { <-0.375, -0.65, 0>, StrengthVal, RadiusVal }
   #local nblob=0;
   #while (nblob < 50)
      #local XX=RadiusVal*2*(1-2*rand(TREE_RAND));
      #local YY=Tree_Trunk_Size*rand(TREE_RAND);
      #local ZZ=RadiusVal*2*(1-2*rand(TREE_RAND));
      sphere {
         <XX, YY, ZZ>,
         StrengthVal, RadiusVal }
      sphere {
         <-XX, -YY, -ZZ>,
         StrengthVal, RadiusVal }
      #local nblob = nblob+1;
      #end
   cylinder { -Tree_Trunk_Size*y, Tree_Trunk_Size*y, StrengthVal, RadiusVal }
   // [sturm]
   texture { Bark_Texture }
} // End of blob.

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Now we begin the CONFUSING nested loops. They create a big union
// called "Complete_Tree". We start with one trunk, and add some large
// branches to it. Then, for each large branch, we add a few medium
// branches - each one is at a random angle. Then, in the inner loop,
// we add small branches. Each one of the small branches gets one leaf
// object attached to it. Whew!
//
// The loops MUST be nested like this - it's the only way to give each
// and every branch a random tilt (relative to the parent branch).
//
// The loops are NOT indented properly, because that put the inner loop
// way off the screen, making things even more confusing!

        #declare Complete_Tree =

        union {

        object { Tree_Trunk }

        #declare A = 0; #while ( A < Number_Of_Large_Branches )

        union {

// Make one large branch.

        #declare This_Large_Branch_Size =
                ( rand(TREE_RAND) * Large_Branch_Size_Range ) +
                Large_Branch_Size_Min;

        cone {<0,0,0>,0.60 <0,This_Large_Branch_Size,0>,0.40
                texture { Bark_Texture } }
                
        sphere { <0,This_Large_Branch_Size,0>,0.40
                texture { Bark_Texture } }

// Loop to put medium branches on that large branch.

        #declare B = 0; #while ( B < Number_Of_Medium_Branches )

        union {

        #declare This_Medium_Branch_Size =
                ( rand(TREE_RAND) * Medium_Branch_Size_Range ) +
                Medium_Branch_Size_Min;

        cone { <0,0,0>,0.30 <0,This_Medium_Branch_Size,0>,0.20
                texture { Bark_Texture } }
        
        sphere { <0,This_Medium_Branch_Size,0>,0.20
                texture { Bark_Texture } }

// Loop to put small branches on that medium branch.

        #declare C = 0; #while ( C < Number_Of_Small_Branches )

        #declare This_Small_Branch_Size =
                ( rand(TREE_RAND) * Small_Branch_Size_Range ) +
                Small_Branch_Size_Min;

        union {

        cone { <0,0,0>,0.10 <0,This_Small_Branch_Size,0>,0.05
                texture { Bark_Texture } }
        
        // (No sphere at the end of that cone - it's invisible!)

// The leaf at the end of the small branch.
        #switch (rand(TREE_RAND))
           #range (0, 0.80)
              object { One_Leaf translate y * This_Small_Branch_Size }
              #break
           #range (0.80, 0.90)
              object { Red_Rose translate y * This_Small_Branch_Size }
              #break
           #range (0.90, 1.0)
              object { White_Rose translate y * This_Small_Branch_Size }
              #break
        #end

        // First, spin the vertical branch to a random angle.
        // The branch doesn't really change - this actually
        // just spins the leaf around!

                #declare SpinAngle = (rand(TREE_RAND)*360);
                rotate y * SpinAngle

        // Now, tilt it over a little.
                #declare BranchAngle = (rand(TREE_RAND)*S_Bmax)+S_Bmin;
                rotate z * BranchAngle

        // Rotate it into place, with a little random wiggle.
                #declare Wiggle=(rand(TREE_RAND)*20)-10;
                #if ( Wiggle_Flag = off ) #declare Wiggle = 0; #end
                
                #declare C2 = ( 360 / Number_Of_Small_Branches ) * C;
                rotate y * (C2 + Wiggle)

        // Move it up to the top of the Medium_Branch.
        // If flag is "off", then move to the next spot on branch.

                #declare TEMP_HEIGHT = This_Medium_Branch_Size;
                #if ( Branches_On_End_Flag = off )
                        #declare TEMP_HEIGHT = This_Medium_Branch_Size -
                        ((This_Medium_Branch_Size / Number_Of_Small_Branches)*C);
                #end

                translate y * TEMP_HEIGHT

        } // End of object.

        #declare C = C + 1; #end

        #declare BranchAngle = (rand(TREE_RAND)*M_Bmax)+M_Bmin;
        rotate z * BranchAngle

        #declare Wiggle=(rand(TREE_RAND)*20)-10;
        #if ( Wiggle_Flag = off ) #declare Wiggle = 0; #end
        #declare B2 = ( 360 / Number_Of_Medium_Branches ) * B;
        rotate y * ( B2 + Wiggle )

        // Move the Medium_Branch up to the top of the Large_Branch.
        // If flag is "off", then move to the next spot on branch.
                
                #declare TEMP_HEIGHT = This_Large_Branch_Size;
                #if ( Branches_On_End_Flag = off )
                        #declare TEMP_HEIGHT = This_Large_Branch_Size -
                        ((This_Large_Branch_Size / Number_Of_Medium_Branches)*B);
                #end

                translate y * TEMP_HEIGHT
                
        } // End of union.

        #declare B = B + 1; #end

        #declare BranchAngle = (rand(TREE_RAND)*L_Bmax)+L_Bmin;
        rotate z * BranchAngle

        #declare Wiggle=(rand(TREE_RAND)*20)-10;
        #if ( Wiggle_Flag = off ) #declare Wiggle = 0; #end
        #declare A2 = ( 360 / Number_Of_Large_Branches ) * A;
        rotate y * ( A2 + Wiggle )
        
        // Move the Large_Branch up to the top of the Tree_Trunk.
        // If flag is "off", then move to the next spot on trunk.
        // These are spaced differently than the other branches - they
        // start about 3/4 of the way up the trunk.
                
                #declare TEMP_HEIGHT = Tree_Trunk_Size;
                #if ( Branches_On_End_Flag = off )
                        #declare TEMP_HEIGHT = Tree_Trunk_Size -
                        ((Tree_Trunk_Size / Number_Of_Large_Branches)*A/4);
                #end

                translate y * TEMP_HEIGHT

        } // End of union.

        #declare A = A + 1; #end

        // Now, turn all of the leaves green! This doesn't change the
        // branches, because they already have a texture.

                //texture { Leaf_Texture }

    } // end of Complete_Tree union

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Now return to your main file and show "Complete_Tree".
//
//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// End of this file - bye!

