// Persistence of Vision Raytracer
// Rose tree

#local myRand=seed(123);


#declare Splits=1;
#declare Rough=0.6;
#macro Bordure()
   object{
      union{
         #local i=0;
         #while (i<15)
            object{
               #declare Seed=i;
               #include "Rock.inc"
               scale <.2, 1, 1>
               translate 30*x
               rotate (360/15*i+90)*y
               pigment {
                  bozo turbulence 0.5 color_map {
                     [0 Yellow]
                     [0.5 Tan]
                     [1 rgb <1, .9, .8>]
                     }
                  scale 0.3
                  }
               normal {dents bump_size 0.8}
               finish {Shiny}
               }
            #local i=i+1;
            #end
            }
      #undef Seed
      #undef Splits
      #undef Rough
      translate 1*y
      }
   
   #end

#declare Terre=object{
   union{
      height_field{
         tga "terre1.tga"  
         smooth
         translate <-.5, -0.0, -.5>
         }
      cylinder {-y, 0.01*y, .5}
      }
   pigment {
      bozo turbulence 1 color_map{
         [0.00 Tan*.7]
         [1.00 rgb<1, .8, .6>*.8*.7]
         }
      scale .05
      }
   normal {crackle 1 bump_size 4 scale <1, 1, 1>*.1}
   finish {
      //phong .3
      //phong_size 1 
      metallic 
      //ambient 0
      }
   scale <60, 10, 60>
   clipped_by {cylinder {-10*y, 10*y, 28.01}}
   scale <30/28, 1, 30/28>
   }

#local T_paint=texture {
   pigment {Red}
   normal {bumps bump_size 1 turbulence 1 scale .1}
   finish {Glossy}
   }

#local T_pot=texture {
   pigment {Gray70}
   normal {bumps bump_size 2 turbulence 0.3 scale .3}
   finish {Dull}
   }

#local Paint1=object{
   difference{
      union{
         cone {0, 3, 10*y, 4}
         torus {4, .5 translate 10*y}
         }
      cone {.5*y, 2.5, 11*y, 3.5}
      }
   texture {
      material_map{
         png "paint_map.png"
         map_type 2 interpolate 2 once
         texture {T_paint}
         texture {T_paint}
         texture {T_pot}
         texture {T_pot}
         }
      rotate 220*y
      scale 12 translate -1*y
      }
   }

#declare PaintBrush=object#{
   union{
      cylinder {0, 5*y, .8}
      sphere {5*y, .8}
      }
      pigment {
         P_WoodGrain3A
         color_map { M_Orangewood }
         rotate z*5
         rotate 90*y
         }
   }

#declare Paint=union{
   object {Paint1}
   object {PaintBrush rotate -15*z translate <3, 10, 0>}
   }

#macro Rosier_plante()
   #declare Wiggle_Flag = on;
   #declare Branches_On_End_Flag = off;
   #declare TREE_RAND = seed(0);
   #declare Number_Of_Large_Branches = 5;
   #declare Number_Of_Medium_Branches = 5;
   #declare Number_Of_Small_Branches = 10;
   #declare Large_Branch_Minimum_Angle = 30;
   #declare Large_Branch_Maximum_Angle = 80;
   #declare Medium_Branch_Minimum_Angle = 60;
   #declare Medium_Branch_Maximum_Angle = 70;
   #declare Small_Branch_Minimum_Angle = 20;
   #declare Small_Branch_Maximum_Angle = 50;
   #declare Tree_Trunk_Size = 10;
   #declare Large_Branch_Size_Min = 2;
   #declare Large_Branch_Size_Max = 4;
   #declare Medium_Branch_Size_Min = 2;
   #declare Medium_Branch_Size_Max = 4;
   #declare Small_Branch_Size_Min = 2;
   #declare Small_Branch_Size_Max = 4;
   #declare TREE_MESH_SIZE = 300;
   #declare Bark_Texture = texture {
      pigment {
         bozo 
         turbulence 0.5
         color_map {
            [0 BakersChoc]
            [0.9 BakersChoc]
            [0.9 Tan]
            [1.0 Tan]
            }
         scale <1, 2, 1>*0.3
         } 
      normal {crackle bump_size 1 scale .1}
      finish {Dull ambient .3}
      }
   #declare Leaf_Texture = texture { pigment { LimeGreen *1.2 filter 0.3} }
   #declare Leaf_Type = 4;

   #include "ptd_tree.inc"
   object {Complete_Tree scale 3}
   #end

object{Bordure()}
object {Terre}
object {Paint rotate <-10, 0, -10> translate <-8, 3, 10>}
object {Rosier_plante() scale 1.5 translate <0, 15, 0>}//y=8 ok
