// Persistence of Vision Raytracer
// Soldiers


#macro leg(
        rad // curvature radius of the leg
        )
   #local leg_finish=finish {ambient 0.4}
   object{
      union{
         intersection{
            sphere {0, 1 scale <.2, 1, .2>}      
            box {<-1, 0, -1>, <1, 1, 1>}
            pigment {White}
            finish {leg_finish}
            }
         //cylinder {0, -2*y, .2}
         intersection {
            #if (rad > 0)
               torus {rad, .2 rotate 90*z}
               plane {z, 0 rotate  (90-180/pi*1/rad)*x}
               plane {z, 0 rotate -(90-180/pi*1/rad)*x}
               rotate 180-180/pi*1/rad*x
            #else
               torus {-rad, .2 rotate 90*z}
               plane {z, 0 rotate  (90-180/pi*1/rad)*x}
               plane {z, 0 rotate -(90-180/pi*1/rad)*x}
               rotate 180-180/pi*1/rad*x
            #end
            translate rad*z
            pigment {White}
            finish {leg_finish}
            }
         union{
            sphere {0, 1 scale <.3, .1, .3>}
            sphere {0, 1 scale <.5, .3, 1> translate <0, -.3, 0.5>}            
            translate -rad*z
            rotate 180-180/pi*2/rad*x
            translate rad*z
            pigment {Gray10}
            finish {
               phong 3 
               phong_size 10
               }
            }
         }
      }
#end


#macro arm(
  ang,  // curvature angle of the arm, abs() must be < pi/2.
  ang2, // angle vs. plane of the card
  flag  // is there a lance (1) or a paint brush (2) or a pot (3)?
)
#local arm_finish=finish {ambient 0.4}
#local arm_rad=1;
#local Z2_1 =julia_fractal {
  <-0.083,0.0,-0.83,-0.025>
  quaternion
  sqr
  max_iteration 8
  precision 15
  rotate 90*z
  scale <1, .6, 1>
}
#local Red_Rose=object {
  Z2_1 scale <.5, .5, .5>
  pigment {
  bozo color_map {
  [0.0 Red]
  [0.5 Red]
  [0.5 White]
  [1.0 White]
  }
  scale 0.4}
  finish {Dull ambient .3}
  rotate 90*y
}
#local T_paint=texture {
  pigment {Red}
  normal {bumps bump_size 1 turbulence 1 scale .1}
  finish {Glossy ambient 0.3}
}

#local T_pot=texture {
  pigment {Gray70}
  normal {bumps bump_size 1 turbulence 0.3 scale .3}
  finish {Dull}
}

#local Paint1=union{
  object{
    difference{
      union{
	cone {0, 3.8, 10*y, 4}
	torus {4, .5 translate 10*y}
      }
      cone {.5*y, 2.5, 11*y, 3.5}
    }
    texture {
      material_map{
	png "paint_map.png"
	map_type 2 interpolate 2 once
	texture {T_paint}
	texture {T_paint}
	texture {T_pot}
	texture {T_pot}
      }
      rotate 220*y
      scale 12 translate -1*y
    }
  }
  object{
    torus {4, .5 rotate 90*x scale <1, 1.8, 1> translate 11*y}
    texture {T_pot}
    //	scale 12 translate -1*y
  }
}
object{
  union{
    intersection{
      sphere {0, 1 scale <.5, .2, .2>}
      box {<-1, -1, -1>, <0, 1, 1>}
      pigment {White}
      finish {arm_finish}
    }
    intersection {
      #if (ang > 0)
	torus {arm_rad, .2 rotate 90*x}
	plane {x, 0 rotate ang*z}
	plane {-x, 0}
	translate arm_rad*y
      #else
	torus {arm_rad, .2 rotate 90*x}
	plane {x, 0 rotate  ang*z}
	plane {-x, 0}
	translate -arm_rad*y
      #end
      pigment {White}
      finish {arm_finish}
    }
    union{
      cylinder {
	0, (3.5-arm_rad*abs(ang*pi/180))*x, 0.2
	pigment {White}
	finish {arm_finish}
      }
      blob {
	threshold .7
	sphere { 0, 1, 2 scale <.1, .3, .3>}
	sphere { 0, 1, 2 scale <.6, .4, .3> translate <.4, 0, 0>}
	#if (flag = 2)
	sphere { 0, 1, -3 scale <.3, .3, .3> translate <.4, 0, -.3>}
	sphere { 0, 1, 1 scale <.2, .2, .2> rotate 45*z translate <.3, -.3, 0>}
	#else
	sphere { 0, 1, -3 scale <.3, .3, .3> translate <.4, 0, .3>}
	sphere { 0, 1, 1 scale <.2, .2, .2> rotate -45*z translate <.3, .3, 0>}
	#end
	pigment {Tan}
	finish {
	  phong 1 
	  phong_size 10
	}
	scale 1.5
	translate (3.5-arm_rad*abs(ang*pi/180))*x
      }
      #if (ang > 0)
	translate -arm_rad*y rotate ang*z translate arm_rad*y
      #else
	translate arm_rad*y rotate ang*z translate -arm_rad*y
      #end
    }
    #if (flag = 1) // Lance
      union{
	union {
	  cylinder {-7*y, 7*y, 0.15}
	  pigment {
	    P_WoodGrain3A
	    color_map { M_Wood7A }
	    rotate z*5
	    rotate 90*x
	  }
	  finish {arm_finish}
	  translate <((arm_rad)*abs(sin(ang*pi/180))+(3.5-arm_rad*abs(ang*pi/180))*cos(ang*pi/180)), 0, .1>
	}
	union {
	  cone {7*y, 0.18, 7.3*y, .1}
	  cone {7.3*y, 0.1, 7.5*y, .3}
	  cone {7.5*y, 0.3, 9*y, 0}
	  texture{T_Chrome_4A}
	  translate <((arm_rad)*abs(sin(ang*pi/180))+(3.5-arm_rad*abs(ang*pi/180))*cos(ang*pi/180)), 0, .1>
	}
      }
    #end
    #if(flag = 2) // Paint pot
      object {Paint1 scale <1.5, 1, 1.5>*1/10
	translate -4*y
	translate <((arm_rad)*abs(sin(ang*pi/180))+(3.5-arm_rad*abs(ang*pi/180))*cos(ang*pi/180)), -((arm_rad)*sin(ang*pi/180)-(3.5-arm_rad*abs(ang*pi/180))*sin(ang*pi/180)), -.1>
	//translate (3.5-arm_rad*abs(ang*pi/180))*x
	//#if (ang > 0)
	//  translate -arm_rad*y rotate ang*z translate arm_rad*y
	//#else
	//  translate arm_rad*y rotate ang*z translate -arm_rad*y
	//#end
      }
    #end
    #if(flag = 3) // Paint brush with rose!
      object {
	cylinder {0.5*y, 3*y, 0.07}
	pigment {
	  P_WoodGrain3A
	  color_map { M_Wood7A }
	  rotate z*5
	  rotate 90*x
	}
	finish {arm_finish}
	translate <((arm_rad)*abs(sin(ang*pi/180))+(3.5-arm_rad*abs(ang*pi/180))*cos(ang*pi/180)), -((arm_rad)*sin(ang*pi/180)-(3.5-arm_rad*abs(ang*pi/180))*cos(ang*pi/180)), 0>
      }
      object {
	sphere {0, 1 scale <.2, .5, .2> translate (3+.866*.5)*y}
	pigment{
	  radial color_map{
	    [0.0 Red]
	    [0.8 Red]
	    [0.8 Black]
	    [1 Black]
	  }
	  frequency 30
	}
	finish {ambient 0.3}
	translate <((arm_rad)*abs(sin(ang*pi/180))+(3.5-arm_rad*abs(ang*pi/180))*cos(ang*pi/180)), -((arm_rad)*sin(ang*pi/180)-(3.5-arm_rad*abs(ang*pi/180))*cos(ang*pi/180)), 0>
      }
      object {
	Red_Rose translate 4.5*y
	translate <((arm_rad)*abs(sin(ang*pi/180))+(3.5-arm_rad*abs(ang*pi/180))*cos(ang*pi/180)), -((arm_rad)*sin(ang*pi/180)-(3.5-arm_rad*abs(ang*pi/180))*cos(ang*pi/180)), .1>
      }
    #end
  }
  rotate -ang2*x
}
#end


#macro head(
        )
   #local head_finish=finish {ambient 0.4}
   object{
      union{
         intersection{
            sphere {0, 1 scale <.2, .5, .2>}      
            box {<-1, -1, -1>, <1, 0, 1>}
            pigment {White}
            finish {head_finish}
            }
         cylinder {0, 1*y, .2
            pigment {White}
            finish {head_finish}
            }
         union{  
            sphere {0, .7}
            pigment {
               image_map{
                  png "visage.png"
                  map_type 2 interpolate 2 once
                  }
               scale <1, 1.7, -1>
               translate -.7*y
               rotate 90*y
               }
            //scale <5, 2*rad*sin(4/rad), 1>/<5, 8, 1>
            //}
            finish {head_finish}
            scale 1.5
            translate 1.5*y
            }  
         union{  
            intersection{
               sphere {0, 1 scale <.75, 1, .75>}
               union {
                  box {<-1, 0, -1>, <1, .2, 1>}
                  box {<-.1, 0, -1>, <.1, 1, 1>}
                  box {<-1, 0, -.1>, <1, 1, .1>}
                  box {<-.08, -.3, 0>, <.08, 0, 1>}
                  }
               }
            sphere {z, .03 rotate <-5, 0, 0>   scale <.78, 1.03, .78>}
            sphere {z, .03 rotate <-30, 0, 0> scale <.78, 1.03, .78>}
            sphere {z, .03 rotate <-60, 0, 0> scale <.78, 1.03, .78>}
            sphere {z, .03 rotate <-90, 0, 0> scale <.78, 1.03, .78>}
            sphere {z, .03 rotate <-120, 0, 0> scale <.78, 1.03, .78>}
            sphere {z, .03 rotate <-150, 0, 0> scale <.78, 1.03, .78>}
            sphere {z, .03 rotate <-175, 0, 0> scale <.78, 1.03, .78>}
            sphere {-x, .03 rotate <0, 0,   -5> scale <.78, 1.03, .78>}
            sphere {-x, .03 rotate <0, 0,  -30> scale <.78, 1.03, .78>}
            sphere {-x, .03 rotate <0, 0,  -60> scale <.78, 1.03, .78>}
            sphere {-x, .03 rotate <0, 0, -120> scale <.78, 1.03, .78>}
            sphere {-x, .03 rotate <0, 0, -150> scale <.78, 1.03, .78>}
            sphere {-x, .03 rotate <0, 0, -175> scale <.78, 1.03, .78>}
            sphere {z, .03 rotate <-5, 30, 0>   scale <.78, 1.03, .78>}
            sphere {z, .03 rotate <-5, 60, 0>   scale <.78, 1.03, .78>}
            sphere {z, .03 rotate <-5, 120, 0>   scale <.78, 1.03, .78>}
            sphere {z, .03 rotate <-5, 150, 0>   scale <.78, 1.03, .78>}
            sphere {z, .03 rotate <-5, 210, 0>   scale <.78, 1.03, .78>}
            sphere {z, .03 rotate <-5, 240, 0>   scale <.78, 1.03, .78>}
            sphere {z, .03 rotate <-5, 300, 0>   scale <.78, 1.03, .78>}
            sphere {z, .03 rotate <-5, 330, 0>   scale <.78, 1.03, .78>}
            pigment {
               bozo 
               turbulence 1 
               color_map{
                  [0 Gray80]
                  [0.6 Gray80]
                  [0.6 rgb <.5, .4, .3>]
                  [1.0 rgb <.6, .5, .4>]
                  }
               scale .3
               }
            normal {
               bumps 
               turbulence 1 
               bump_size 1 
               scale .3
               }
            finish {
               Dull 
               metallic
               }
            rotate -20*x
            scale 1.5
            translate 1.5*y
            }  
         union{  
            intersection{
               sphere {0, 1 scale <.73, .98, .73>}
               box {<-1, 0, -1>, <1, 1, 1>}
               }
            pigment {
               rgb <.9, .8, .6>
               }
            normal {
               bozo
               slope_map {
                  [0.00 <1, 0>]
                  [0.40 <1, 0>]
                  [0.40 <1, -5>]
                  [0.50 <0, -5>]
                  [0.50 <0, 5>]
                  [0.60 <1, 5>]
                  [0.60 <1, 0>]
                  [1.00 <1, 0>]
                  }
               turbulence 1 
               scale .3
               }
            finish {
               phong 1 phong_size 30
               //metallic
               }
            rotate -20*x
            scale 1.5
            translate 1.5*y
            }  
         }
      }
#end

#macro soldat(
        rad,     // curvature radius of the card. must be > 8/pi # 2.55; 100 makes it nearly flat
        image    // number of the spades png image to map on the front side
        rad_legL,// curvature radius of the left leg
        rad_legR,// curvature radius of the right leg
        ang_Larm, ang_Larm2, // angles for the left arm
        ang_Rarm, ang_Rarm2, // angles for the right arm
        flag // options...
        )
#local epsilon=0.1/2; // half thickness of the card.
   union{
      object {
         difference {
            cylinder {-5/2*x, 5/2*x, rad+epsilon}
            cylinder {-6/2*x, 6/2*x, rad}
            plane {-z, 0 rotate  (90-180/pi*4/rad)*x}
            plane {-z, 0 rotate -(90-180/pi*4/rad)*x}
            }
         pigment {
            image_map{
               png "cardback.png"
               map_type 0 interpolate 2 //once
               }
            translate -.5
            scale <5, 2*rad*sin(4/rad), 1>/<5, 8, 1>
            }
         finish {ambient 0.4}
         }
      object {
         difference {
            cylinder {-5/2*x, 5/2*x, rad}
            cylinder {-6/2*x, 6/2*x, rad-epsilon}
            plane {-z, 0 rotate  (90-180/pi*4/rad)*x}
            plane {-z, 0 rotate -(90-180/pi*4/rad)*x}
            }
         texture{
            pigment {White}
            finish {ambient 0.4}
            }
         texture{
            pigment {
               image_map{
                  png concat(str(image, 1, 0), "spades.png")
                  map_type 0 interpolate 2 once
                  }
               translate -.5
               scale <5, 2*rad*sin(4/rad)*.9, 1>
               }
            finish {ambient 0.4}
            }
         }
      object {  //first leg
         leg(rad_legR)
         translate <-1.5, 0, -rad>
         rotate (-180/pi*4/rad)*x
         }
      object {  //second leg
         leg(rad_legL)
         translate <1.5, 0, -rad>
         rotate (-180/pi*4/rad)*x
         }
     object {  //left arm
       union{
       #if (flag = 1)
	 arm(ang_Larm, ang_Larm2, 1)
       #else
	 #if (flag = 3)
	   arm(ang_Larm, ang_Larm2, 3)
	 #else
	   arm(ang_Larm, ang_Larm2, 0)
	 #end
       #end
       }
       translate <2.5, 0, -rad>
       rotate (180/pi*3.8/rad)*x
     }
     object {  //right arm
       union{
       #if (flag = 2)
	 arm(ang_Rarm, ang_Rarm2, 1)
       #else
	 #if (flag = 3)
	   arm(ang_Rarm, ang_Rarm2, 2)
	 #else
	   arm(ang_Rarm, ang_Rarm2, 0)
	 #end
       #end
       }
       scale <-1, 1, 1>
       translate <-2.5, 0, -rad>
       rotate (180/pi*3.8/rad)*x
     }
     object { //head
       head()
       translate <0, 0, -rad>
       rotate (180/pi*4/rad)*x
     }
     translate rad*z
     scale 6
   }
#end
