//The Magic Forest  (c) 99 Ch. Gerber
//Scene description file for POV-Ray 3.1 Superpatch
//Dedicated to my wife

global_settings {assumed_gamma 2.6}

#include "pcm.mcr"
#include "colors.inc" 
#include "mytextures.inc"
#include "forestplants.inc"
  
//--- some object declarations ---
 
#declare Ground = height_field {
/*Create Ground.tga using the following GForge script
  set tile_mode on
  seed 1
  gforge 256 2.5
  pow 3
  norm 0 1*/
  #declare l=5;
  tga "ground.tga" smooth
  scale <l, 0.2, l>
}

#declare Stone = object {
  #declare IMPORT_SPATCH = 1;
  #include "stone.inc"
  scale <0.5, 0.25, 0.5>
  texture {
    bozo
    turbulence 0.3
    octaves 3
    lambda 4
    omega 0.7
    texture_map {
      [0.0 Moss scale 5]
      [0.4 Moss scale 5]
      [0.8 GrayStone scale 5]
      [1.0 GrayStone scale 5]
    }
    scale 0.2
  }    
}

#declare declare_only = true;
read_mesh ("cobold.pcm")

#declare Cobold = union {
/*This object has the following minimum and maximum values:
  xmin=-0.148796, xmax=0.148796
  ymin=-0.128745, ymax=0.128745
  zmin=-0.168189, zmax=0.168189*/
  object {Mesh[0] texture {Skin}}
  object {Mesh[1] texture {Hair}}
  translate 0.128745*y
}

//--- camera & scene lightening ---

#declare cam_loc = <0, 2, -4>;
#declare lookat = <0, 0, 0>;
#declare sky_vect = <0, 1, 0>;

camera {
  location cam_loc
  direction 1.3*z
  look_at lookat
}

light_source {  // the sun
  -100*z 
  color 1.4*<1.2, 1, 0.8>
  area_light <10, 0, 0>, <0, 10, 0>, 5, 5
  adaptive 1
  jitter 
  rotate <60, -45, 0>
}

plane { y, 20 hollow  // simulate roof of green leafs
  pigment {
    granite
    turbulence 1.0
    color_map {
      [0.00 color rgbf <0.9, 0.95, 0.9, 0.9>]
      [0.50 color rgbf <0.9, 0.95, 0.9, 0.9>]
      [0.60 color Clear]
      [1.00 color Clear]
    }
    scale 0.5
  }
}

//--- MAIN SCENE ---

//--- the forest ground ---
#declare i=0;
#declare j=0;
#declare m=5;
union {
  #while (j<m)
    #while (i<m+2)
      object {Ground translate <l*i, 0, l*j>}
      #declare i=i+1;
    #end
    #declare i=0;
    #declare j=j+1;
  #end
  translate <-l*(m+2)/2, 0, -l>
  texture {
    slope y
    texture_map {
      [0.000 Mud]
      [0.999 Mud]
      [1.000 Moss scale 2/3]
    }
  }  
  scale 1.5  
}  

//--- the trees ---
union {
  #declare S = seed (1999);
  object {Tree rotate -15*y scale 1.5 texture {TTree}}
  object {Mushroom1 rotate 360*y*rand(S) scale 0.18 translate <0.85, 0.5, 0> rotate  30*y}
  object {Mushroom1 rotate 360*y*rand(S) scale 0.25 translate <0.70, 0.7, 0> rotate  60*y}
  object {Mushroom1 rotate 360*y*rand(S) scale 0.12 translate <0.80, 0.4, 0> rotate 120*y}
  object {Mushroom1 rotate 360*y*rand(S) scale 0.25 translate <0.70, 1.0, 0> rotate -30*y}
  object {Mushroom1 rotate 360*y*rand(S) scale 0.15 translate <0.70, 1.0, 0> rotate  45*y}
  object {Mushroom1 rotate 360*y*rand(S) scale 0.22 translate <0.60, 1.3, 0> rotate 110*y}   
  translate <-1, 0, 0>
}

object {Tree rotate -120*y texture {TTree} translate <2, 0, 2>}     
object {Tree rotate 60*y scale 1.3 texture {TTree} translate <0, 0, 4>}     
object {Tree rotate -60*y scale 1.4 texture {TTree} translate <-4, 0, 5>}     
object {Tree rotate 180*y scale 1.7 texture {TTree} translate <3, 0, 6>}     

//--- the stones ---
object {Stone translate <0.3, 0, -1.1>}
object {Stone rotate -45*y translate <2, 0, 0.5>} 

//--- the fern ---
object {Fern translate <1, 0, -1>}
object {Fern scale 1.2 rotate 60*y translate <1.5, 0, -2>}
object {Fern rotate -120*y translate <0.5, 0, 2>}
object {Fern scale 1.1 rotate 180*y translate <1, 0, 0.5>}
object {Fern scale 1.2 translate <-3, 0, 2>}

//---  the leafs ---
object {LeafPlant scale 0.7 translate <-1, 0, -1.3>}
object {LeafPlant scale 0.9 rotate   60*y translate <-1.5, 0, -1.8>}
object {LeafPlant scale 0.8 rotate  180*y translate <-0.5, 0, -2.4>}
object {LeafPlant scale 0.7 rotate  -60*y translate <2, 0, 1>}
object {LeafPlant scale 0.9 rotate  120*y translate <3.5, 0, 4>}
object {LeafPlant scale 0.9 rotate -120*y translate <2, 0, 4.5>} 
object {LeafPlant scale 0.7 rotate   90*y translate <1.5, 0, 3.5>}
object {LeafPlant scale 0.8 rotate   45*y translate <3.2, 0, 2.5>}

//--- the grass ---
object {Grass scale <1, 2,   1> translate <1, 0, 6>}
object {Grass scale <1, 2.5, 1> translate <5, 0, 7>}
object {Grass scale <1, 2.5, 1> rotate  90*y translate <1.5, 0, 8>}
object {Grass scale <1, 2,   1> rotate -60*y translate <-0.5, 0, 1.5>}

//--- the mushrooms ---
object {Mushroom2 scale 0.14 rotate -90*y translate <1.7, 0, -0.5>}
object {Mushroom2 scale <0.08, 0.11, 0.08> rotate  120*y translate <0, 0, -2>}
object {Mushroom2 scale <0.12, 0.14, 0.12> rotate -120*y translate <0.5, 0, -1.8>}
object {Mushroom2 scale 0.10 rotate  60*y translate <0.7, 0, -2.2>}
object {Mushroom2 scale 0.11 rotate -45*y translate <-2, 0, -0.4>}

//--- cobold --- 
object {Cobold scale 2 translate <0.3, 0.23, -1.1>}

#declare light_rad = 4;
#declare light_loc = <0.4, 0.25, -1.3>;
#declare flare_size = 0.8;
#declare flare_brightness = 0.6*<0.9, 1, 0.9>;
#declare show_flare_source = no;
#include "sparkle3.flr"
#include "NKFlare.inc"
