#include "colors.inc"
#include "woods.inc"

#declare tWood =
texture
{       
    T_Wood13  
    scale 0.25
    translate <10, 0, 0>
    rotate <0, 90, 70>
    pigment
    {
       turbulence 1
    }   
}

#declare cPi =
3.141592653589793238462;

#declare cBridgeHook =
(cPi - 2 * asin(0.6)) / 16;

#declare oBoog =
difference
{
    union
    {
        cylinder
        {
            <0.1, 0, 0>,
            <-0.1, 0, 0>,
            1
        }
        box
        {
            <0.05, 0, 0>,
            <0.16, 2, 0.07>
            translate <0, 0, -0.75>
        }
        box
        {
            <0.05, 0, 0>,
            <0.16, 2, 0.07>
            translate <0, 0, -0.75 + 1 * 0.473333>
        }
        box
        {
            <0.05, 0, 0>,
            <0.16, 2, 0.07>
            translate <0, 0, -0.75 + 2 * 0.473333>
        }
        box
        {
            <0.05, 0, 0>,
            <0.16, 2, 0.07>
            translate <0, 0, -0.75 + 3 * 0.473333>
        }
    }
    difference
    {
        plane
        {
            <0, -1, 0>
            20
        }
        cylinder
        {
            <2, 0, 0>,
            <-2, 0, 0>,
            1.4
        }    
    }         
    
    cylinder
    {
        <1, 0, 0>,
        <-1, 0, 0>,
        0.9
    }
    plane
    {
        <0, 1, 0>,
        0.6
    }       
}          
                                 
#declare oBridgePlank =
box
{  
    <0.61, 0.45 * cBridgeHook, 1>,
    <-0.61, -0.45 * cBridgeHook, 1 + 0.05>
}                        

#declare oBridgeRail =
difference
{
    torus
    {
        1.4, 
        0.055
        rotate <0, 0, 90>
    }
    plane 
    {
        <0, 0, 1>,
        -0.9
    }
    plane 
    {
        <0, 0, -1>,
        -0.9
    }
    plane 
    {
        <0, 1, 0>,
        0
    }

}
                                 
#declare oBridge =
union
{
    object 
    {
        oBridgeRail 
        translate <-0.605, 0, 0>
    }
    
    object 
    {
        oBridgeRail 
        translate <0.605, 0, 0>
    }        
    
    object 
    {
        oBoog 
        translate <0.5, 0, 0> 
        rotate <0, 180, 0>
    }
    
    object 
    {
        oBoog 
        translate <0.5, 0, 0>
    }        

    #declare vCounter = 0;
    #while (vCounter < 16)
        object 
        {
            oBridgePlank 
            rotate <-(asin(0.6) + (vCounter + 0.5) * cBridgeHook) * 180 / cPi, 0, 0>
        }
        #declare vCounter = vCounter + 1;
    #end
}

#declare oBridge =
object 
{
    oBridge 
    translate <0, -0.6, 0>
    texture
    {
        tWood
    }
}             
/*
object
{
oBridge
}

light_source
{
    <2, 5, 0>
    color rgb<1,1,1>
}                   

camera
{
    direction <0, 0, 3>
    location <5, 2, 0>
    look_at <0, 0, 0>
}
*/