#include "metals.inc"

#declare tWhite = 
texture
{
	pigment
	{
		color rgb <1, 1, 1>
	}
}

#declare tBand = 
texture
{
	pigment
	{
		color rgb <0.325, 0.325, 0.325>
	}
}

#declare tLak = 
texture
{
	pigment
	{
		color rgb <1, 0, 0>
	}
	finish 
	{
    	ambient 0.25
    	brilliance 4
    	diffuse 0.5
    	metallic
    	specular 0.80
    	roughness 1/80
    	reflection 0.5
    }
}

#declare oCarBase =
prism { // TransSweep001
  linear_sweep
  cubic_spline
  -1.0,0.0
  35  // control points
  <-0.687326, -0.308257>,
  <-0.722512, -0.407218>,
  <-0.706123, -0.623514>,
  <-0.618678, -0.665039>,
  <-0.558433, -0.657443>,
  <-0.377193, -0.561901>,
  <-0.244263, -0.57034>,
  <-0.079432, -0.658273>,
  <0.430423, -0.662905>,
  <0.634659, -0.655687>,
  <0.809972, -0.557609>,
  <0.923148, -0.539038>,
  <1.132077, -0.658407>,
  <1.275502, -0.636901>,
  <1.415605, -0.565727>,
  <1.449206, -0.553723>,
  <1.452375, -0.521009>,
  <1.459849, -0.512703>,
  <1.459303, -0.430492>,
  <1.439884, -0.422551>,
  <1.102702, -0.27086>,
  <0.78483, -0.26701>,
  <0.52701, -0.297164>,
  <0.439566, -0.272226>,
  <0.135481, -0.057787>,
  <-0.240168, -0.072969>,
  <-0.373788, -0.162046>,
  <-0.453962, -0.258506>,
  <-0.508859, -0.275103>,
  <-0.587409, -0.27903>,
  <-0.641562, -0.282838>,
  <-0.620398, -0.282316>,
  <-0.687326, -0.308257>,
  <-0.722512, -0.407218>,
  <-0.706123, -0.623514>
  rotate <-90, 0, 0>
}
/*prism 
{
	linear_sweep
    cubic_spline
	-1,0.0
	35
	<-0.687326, -0.308257>,
	<-0.722512, -0.407218>,
	<-0.706123, -0.623514>,
	<-0.63827, -0.688549>,
	<-0.307655, -0.657443>,
	<-0.126415, -0.561901>,
	<0.026107, -0.550748>,
	<0.171345, -0.658273>,
	<0.430423, -0.662905>,
	<0.634659, -0.655687>,
	<0.809972, -0.557609>,
	<0.923148, -0.539038>,
	<1.132077, -0.658407>,
	<1.275502, -0.636901>,
	<1.415605, -0.565727>,
	<1.449206, -0.553723>,
	<1.452375, -0.521009>,
	<1.459849, -0.512703>,
	<1.459303, -0.430492>,
	<1.439884, -0.422551>,
	<1.102702, -0.27086>,
	<0.78483, -0.26701>,
	<0.52701, -0.297164>,
	<0.439566, -0.272226>,
	<0.135481, -0.057787>,
	<-0.240168, -0.072969>,
	<-0.373788, -0.162046>,
	<-0.453962, -0.258506>,
	<-0.508859, -0.275103>,
	<-0.587409, -0.27903>,
	<-0.641562, -0.282838>,
	<-0.620398, -0.282316>,
	<-0.687326, -0.308257>,
	<-0.722512, -0.407218>,
	<-0.706123, -0.623514>
	rotate <-90, 0, 0>
}
*/
#declare oKoplamp =
union
{
	sphere
	{
		<0, 0, 0>,
		0.09
		texture
		{
			pigment
			{
				color rgb 0.9*<1, 0.7, 0>
			}
		}
	}
	torus
	{
		0.1,
		0.01
		texture
		{
			T_Chrome_3E
		}
	}
	scale <1, 0.2, 1>
	rotate <0, 0, -24>
	translate <1.35, -0.37, 0>
}

#declare oZijruit =
difference
{
	sphere 
	{                   
		<0.2, -0.3, 0.5>,
		0.50001        
		scale <5, 1, 1>
		texture
		{
			pigment
			{
				image_map
				{
					tga "car_window.tga"
					map_type 0 
					interpolate 2
				}
				rotate <0, -90, 45>
				translate <0.35, 0, 0.05>
				scale <0.4, 0.4, 0.95>           
 			}
		}
	}
	plane
	{
		<0, 1, 0>, -0.23
	}
	plane
	{
		<0, 0, 1>, 0
	}
	plane
	{
		<0, 0, -1>, -0.12
	}
	plane
	{
		<-1, 0, -3>, -0.135
	}
	plane
	{
		<1, -0.75, 0>, -0.17
	}
}

#declare oVoorruit =
difference
{	
	object 
	{
		oCarBase
		translate <0, 0.001, 0>
		texture 
		{
			pigment
			{
				image_map
				{
					tga "car_window.tga"
					map_type 0 
					interpolate 2
				}
				rotate <0, -90, 45>
				translate <0.35, 0, 0.05>
				scale <0.4, 0.4, 0.95>           
			}
		}
	}
	
	plane
	{
		<1, 0, 0>, 0.12
	}
	plane
	{
		<-1, 0, 0>, -0.44
	}
	plane
	{
		<0.33, 0, 1>, 0.18
	}
	plane
	{
		<0.33, 0, -1>, -0.77
	}                        
	
	plane
	{
		<0, 1, 0>, -0.45
	}
}

#declare oWiel =
difference
{
	union
	{
		cylinder
		{
			<0,0,0>,
			<0,0,0.16>,
			0.18
			texture {tBand}
		}
		sphere
		{
			<0,0,0>,
			0.18
			scale <1, 1, 0.2>
			translate <0, 0, 0.16>
			texture {tBand}
		}
	}

	sphere
	{
		<0,0,0>,
		0.11
		scale <1, 1, 0.5>
		translate <0, 0, 0.18>
		texture 
		{
			pigment
			{
				color rgb <0.6,0.6,0.6>	
			}
		}
	}
}

#declare oCar =
union
{                   
	difference
	{
		object 
		{
			oCarBase
			texture {tLak}
		}

		difference
		{
			plane
			{
				<0,1,0>,
				20
			}
			
			sphere 
			{                   
				<0.2, -0.3, 0.5>,
				0.5        
				scale <5, 1, 1>
				texture {tLak}
			}
		}
	}                

	object {oVoorruit}
    
	object {oZijruit}

	object {oZijruit scale <1, 1, -1> translate <0, 0, 1>} 

	object {oKoplamp translate <0, 0, 1 -0.2>}

	object {oKoplamp translate <0, 0, 0.2>}
	
	object {oWiel translate <-0.3, -0.67, 0.67>}

	object {oWiel translate <0.9, -0.67, 0.75>}

	object {oWiel scale <1,1,-1> translate <-0.3, -0.67, 0.33>}

	object {oWiel scale <1,1,-1> translate <0.9, -0.67, 0.28>}
}                   

//x,y,z-assenstelsel
/*
#declare as =
cylinder 
{	
	<0,0,0>,
	<100,0,0>,
	0.01
	texture {tWhite}
}

object{as}
object{as rotate <0,-90,0>}
object{as rotate <0,0,90>}
*/       
           
#declare oCar =         
object{oCar translate <0, 0.85, 0>}
              
              
// what comes next is only for car_final
/*
object {oCar}

plane
{
	<0, 1, 0>, 
	0
	texture
	{
		pigment
		{
			color rgb <0.1, 0, 0.5>
		}
	}
}

light_source
{
	<3,10,13>
	color rgb 0.8*<1,1,1>
}                   

light_source
{
	<3,10,-3>
	color rgb 0.8*<1,1,1>
}                   

light_source
{
	<3,10,-6>
	color rgb 0.4*<1,1,1>
}                   

light_source
{
	<3,10,-6.3>
	color rgb 0.4*<1,1,1>
}                   

camera
{
	location <1.5,2.5,3>
	direction <0, 0, 1.7>
	look_at <0.3,0,0.5>
	rotate <0, 0, 0>
}
*/                           
/*                           
plane
{
	<1,0,0>,
	6
	texture{tWhite}
} 
*/