#include "colors.inc"
#include "woods.inc"
//#include "textures.inc"

#declare cPi = 3.141592653589793238462;

#declare pWhite = 
pigment
{
	color rgb <1, 1, 1>
}

#declare tWood = 
texture
{
	T_Wood23
/*	pigment
	{
		color rgb <1, 1, 1>
	}
*/
	rotate <0, 0, 0>
	translate <4, 0, 0>
}

#declare tWhite =
texture
{
	pigment
	{
		color rgb <1, 1, 1>
	}
}


#declare tWall =
texture
{
	pigment
	{
		image_map
		{
			tga "house5.tga"
			map_type 0 
			interpolate 2
		}
	}              
	finish
	{
		ambient 0.3
	}
	scale 3
}	

#declare tRoof =
texture
{
	pigment
	{
		image_map
		{
			tga "roof.tga"
			map_type 0 
			interpolate 2
		}
	turbulence 2          
	scale <.5,5,.5>
	rotate <90, 0,0>
	}              
	finish
	{
		ambient 0
	}
	normal
	{
		bozo .3
		turbulence 3          
		scale <0.25,5,6>
   	}
}	

#declare oFencePart =
union
{
	box 
	{
		<-0.075, 0, -0.075>, 
        <0.075, 1.2, 0.075>
		texture {tWood}
    }             
    
    box
    {
        <0, 1.1, 0.05>,
		<1.5, 1, -0.05> 
		texture {tWood}
	}
	
	#declare vRailCount = 1;
	#while (vRailCount < 10)
		cylinder
		#declare vXPosition = 0.075 + 0.135 * vRailCount;
		{
			<vXPosition, 0.45, 0>, 
        	<vXPosition, 1.1, 0>,
        	0.02
        	texture {tWood}
	    }
	    #declare vRailCount = vRailCount + 1;
	#end          
}                    

#declare oHalfFence =
union
{
	difference
	{
		box
		{
			<0, 0.45, 1.75 + 0.5>,
			<1.125 + 2 * 1.5 + 2 * sqrt(0.5 * pow(1.5, 2)) + 0.075, 0.15, -1.5 - 2 * sqrt(0.5 * pow(1.5, 2)) + 1.75 + 0.5>
			texture {tWood}
		}
		
		plane
		{
			<0, 0, 1>, 
			0
			rotate <0, -45, 0>
			translate <1.05 + 0.15 + 2 * 1.5, 0, -1.5 - 2 * sqrt(0.5 * pow(1.5, 2)) + 0.075 + 1.75 + 0.5>
			texture {tWood}
		}
    }

	box
	{
		<0, 0, -1.5 - 2 * sqrt(0.5 * pow(1.5, 2)) + 1.75 + 0.5>
		<1.05, 0.3, -1.5 - 2 * sqrt(0.5 * pow(1.5, 2)) + 1.75 + 0.5 - 0.25>
		texture {tWood}
	}
	
	box
	{
		<0, 0, -1.5 - 2 * sqrt(0.5 * pow(1.5, 2)) + 1.75 + 0.5 - 0.25>
		<1.05, 0.15, -1.5 - 2 * sqrt(0.5 * pow(1.5, 2)) + 1.75 + 0.5 - 0.45>
		texture {tWood}
	}

	object 
	{
		oFencePart 
		translate <1.125,0, -1.5 - 2 * sqrt(0.5 * pow(1.5, 2)) + 0.075 + 1.75 + 0.5>
	}

	object 
	{
		oFencePart 
		translate <1.125 + 1.5, 0, -1.5 - 2 * sqrt(0.5 * pow(1.5, 2)) + 0.075 + 1.75 + 0.5>
	}

	object 
	{
		oFencePart 
		rotate <0, -45, 0> 
		translate <1.125 + 2 * 1.5, 0, -1.5 - 2 * sqrt(0.5 * pow(1.5, 2)) + 0.075 + 1.75 + 0.5>
	}

	object 
	{
		oFencePart 
		rotate <0, -45, 0> 
		translate <1.125 + 2 * 1.5, 0, -1.5 - 2 * sqrt(0.5 * pow(1.5, 2)) + 0.075 + 1.75 + 0.5>
		translate <sqrt(0.5 * pow(1.5, 2)), 0, sqrt(0.5 * pow(1.5, 2))>
	}

	object 
	{
		oFencePart 
		rotate <0, -90, 0> 
		translate <1.125 + 2 * 1.5, 0, -1.5 - 2 * sqrt(0.5 * pow(1.5, 2)) + 0.075 + 1.75 + 0.5>
		translate 2 * <sqrt(0.5 * pow(1.5, 2)), 0, sqrt(0.5 * pow(1.5, 2))>
	}
}                                 

#declare oFence =
union
{
	object {oHalfFence scale <0.8, 1, 1>}
	object {oHalfFence scale <-0.8, 1, 1>}
}                

#declare oHalfKapel =
union
{
	box
	{
		<0, -0.1, 0>,
		<1.1, 1.2, sqrt(18) + 0.1 - 0.5>
	}
	
	sphere
    {
    	<1.3, 1.2, -0.1>,
    	0.05
    	texture {tRoof rotate <0, 90, 0>}
    }		
                       
	sphere
    {
    	<0, 2.5, -0.1>,
    	0.05
    	texture {tRoof rotate <0, 90, 0>}
    }		     
    
	cylinder
	{
    	<0, 2.5, -0.1>,
    	<0, 2.5, sqrt(18) + 0.1 - 0.5>,
    	0.05     
   	texture {tRoof rotate <0, 90, 0>}
	}    

	cylinder
	{
    	<0, 2.5, -0.1>,
    	<1.3, 1.2, -0.1>,
    	0.05     
    	texture {tRoof rotate <0, 90, 0>}
	}    

	cylinder
    {
    	<1.3, 1.2, -0.1>,
    	<1.3, 1.2, sqrt(18) + 0.1 - 0.5>,
    	0.05
    	texture {tRoof rotate <0, 90, 0>}
    }		     
    
    box
    {
    	<0, 0.05, -0.1>,
    	<sqrt(2 * pow(1.3, 2)), 0.05, sqrt(18) + 0.1 - 0.5>
		texture {tRoof rotate <0, 90, 0>}         
		rotate <0,0, -45>
		translate <0, 2.5, 0>
    }
    
    triangle
    {
    	<0, 1.2, 0>,             
    	<0, 2.5, 0>,
		<1.3, 1.2, 0>
    }
}

#declare oKapel =
union
{
	object {oHalfKapel}

	object {oHalfKapel scale <-1, 1, 1>}

    texture
	{
		pigment
		{
			image_map
			{
				tga "house4.tga"
 				map_type 0 
 				interpolate 2
			}                    
			scale <3.1,2.5,1>
			translate <-1.5, 0.1, 0>
		}
		finish
		{
			ambient 0.3
		}
	}	
}

#declare oKwartDak =
union
{
    cylinder
    {
    	<5.2, 2, -sqrt(18) - 0.1>,
    	<0, 2, -sqrt(18) - 0.1>,
    	0.05
    	texture {tRoof}
    }

    cylinder
    {
    	<5.2, 5, 0>,
    	<0, 5, 0>,
    	0.05
    	texture {tRoof}
    }

    cylinder
    {
    	<5.2, 5, 0>,
    	<5.2, 2, -sqrt(18) - 0.1>,
    	0.05
    	texture {tRoof}
    }

	triangle
	{
    	<5.1, 2, -sqrt(18) - 0.1>,
    	<5.1, 2, 0>,
    	<5.1, 5, 0>
    	texture {tWall rotate <0, 90, 0>}
	}

    box
    {
    	<0, 0.05, 0>,
    	<5.2, 0.05, sqrt(pow(sqrt(18) + 0.1, 2) + pow(3, 2))>
		texture {tRoof}         
		rotate <360 * atan2(3, sqrt(18) + 0.1) / (2 * cPi), 0, 0>
		translate <0, 5, 0>
    }                      
}
 
#declare oHalfDak =
union
{
	object 
	{
		oKwartDak
		translate <0, 0, sqrt(18) + 0.1 + 1.75>
	}
	object 
	{
		oKwartDak 
		scale <1, 1, -1>
	    translate <0, 0, sqrt(18) + 0.1 + 1.75>
	}
}
 
#declare oHalfHouse =
union
{              
	object
	{
		oKapel
		translate <2.25 + 1.1, 2.5, 2.25>
	}
	
	box
	{
		<0, -0.45, 0>,
		<2.25, 2, 2.25>
	}                   
	
	box
	{
		<0, -0.45, 2.25>,
		<5.1, 2, 2 * (sqrt(18) + 0.1 + 1.75) - 2.25>
	    texture
		{
			pigment
			{
				image_map
				{
  					tga "house2.tga"
  					map_type 0 
  					interpolate 2
				}                    
				scale 2
				translate <2.75, -0.3 ,0>
			}
			finish
			{
				ambient 0.3
			}
		}	
	}

	box
	{
		<5.1, -0.45, 2.25>,
		<5.11, 2, 2 * (sqrt(18) + 0.1 + 1.75) - 2.25>
		texture {tWall rotate <0,90,0>}
	}
    
    sphere
    {
    	<2.75, 2, -0.1>,
    	0.05
    	texture {tRoof rotate <0, 90, 0>}
    }
	
    sphere
    {
    	<0, 4.85, -0.1>,
    	0.05
    	texture {tRoof rotate <0, 90, 0>}
    }

    sphere
    {
    	<5.2, 2, 1.75>,
    	0.05
    	texture {tRoof rotate <0, 90, 0>}
    }

    sphere
    {
    	<5.2, 5, sqrt(18) + 0.1 + 1.75>,
    	0.05
    	texture {tRoof rotate <0, 90, 0>}
    }

    cylinder
    {
    	<0, 4.85, -0.1>,
    	<2.75, 2, -0.1>
    	0.05
    	texture {tRoof rotate <0, 90, 0>}
    }
    
    cylinder
    {
    	<0, 4.85, -0.1>,
    	<0, 4.85, sqrt(18) + 0.1 + 1.75>,
    	0.05
    	texture {tRoof rotate <0, 90, 0>}
    }

    cylinder
    {
    	<2.75, 2, -0.1>,
    	<2.75, 2, sqrt(18) + 0.1 + 1.75>,
    	0.05
    	texture {tRoof rotate <0, 90, 0>}
    }

    box
    {
    	<0, 0.05, -0.1>,
    	<sqrt(pow(2.85, 2) + pow(2.75, 2)), 0.05, sqrt(18) + 0.1 + 1.75>
		texture {tRoof rotate <0, 90, 0>}         
		rotate <0,0, 360 * -1 * atan2(2.85, 2.75) / (2 * cPi)>
		translate <0, 4.85, 0>
    }                      
    
    triangle
    {
    	<0, 2, 0>,
    	<2.75, 2, 0>,
    	<0, 4.85, 0>
    }

	object {oHalfDak}
}

#declare oHouse =
union
{
	object {oHalfHouse}            

	object {oHalfHouse scale <-1, 1, 1>}

    texture
	{
		pigment
		{
			image_map
			{
  				tga "house1.tga"
  				map_type 0 
  				interpolate 2
				once
			}          
			scale <5.5, 4.8, 1>
			translate <-2.68, 0 ,0>
		}
	}	
}                
                        
#declare oHalfSchuur =
union
{
	box
	{
		<-4.5 - 5.1, 0, 0>,
		<- 5.1, 2.1, 1.3>
	    texture
		{
			pigment
			{
				image_map
				{
  					tga "house3.tga"
  					map_type 0 
  					interpolate 2
					once
				}          
				scale <4.5, 2, 1>
				translate <-9.6, -0.2,0>
			}              
			finish
			{
				ambient 0.3
			}
		}	
	}

	box
	{
		<-4.5 - 5.1 - 0.01, 0, 0>,
		<-4.5 - 5.1, 2.1, 1.3>
		texture {tWall rotate <0, 90, 0>}
	}

	sphere
	{
		<-4.5 - 5.1 -0.1, 1.9, 1.7>,
		0.05
		texture {tRoof}
	}

	sphere
	{
		<-4.5 - 5.1 -0.1, 2.9, 0>,
		0.05
		texture {tRoof}
	}

	cylinder
	{
		<-4.5 - 5.1 -0.1, 1.9, 1.7>,
		<-4.5 - 5.1 -0.1, 2.9, 0>,
		0.05
		texture {tRoof}
	}

	cylinder
	{
		<-4.5 - 5.1 -0.1, 1.9, 1.7>,
		<-5.1 - 0.1, 1.9, 1.7>,
		0.05
		texture {tRoof}
	}

	cylinder
	{
		<-4.5 - 5.1 -0.1, 2.9, 0>,
		<-5.1 - 0.1, 2.9, 0>,
		0.05
		texture {tRoof}
	}
	
	triangle
	{
		<-4.5 - 5.1, 1.9, 1.7>,
		<-4.5 - 5.1, 2.9, 0>,
		<-4.5 - 5.1, 1.9, 0>
		texture {tWall rotate <0, 90, 0>}
	}

    box
    {
    	<-5.1, 0.05, 0>,
    	<-4.5 - 5.1 - 0.1, 0.05, sqrt(pow(1.7, 2) + pow(1, 2))>
		texture {tRoof}         
		rotate <360 * atan2(1, 1.7) / (2 * cPi), 0, 0>
		translate <0, 2.9, 0>
    }                      
}                        
                        
#declare oSchuur =
union
{
	object 
	{
		oHalfSchuur 
		translate<0, 0, 1.75 + 0.5 * sqrt(18)>
	}

	object 
	{
		oHalfSchuur 
		scale <1, 1, -1> 
		translate<0, 0, 1.75 + 0.5 * sqrt(18)>
	}
}                    
                   
#declare oHouseAndSchuur =
union
{
	object {oHouse translate <0, 0.45, 0>}
	
	object {oSchuur translate <0, 0, 3>}
	
	object {oFence}

    texture
	{
		pigment
		{
			color rgb <1, 1, 1>
        }
	}
}

//object {oHouseAndSchuur}

/*light_source
{
	<-20, 40, -30>
	color rgb 1.8*<1, 1, 1>
}


camera
{
	location <-5, 17.5, -25>
	direction <0, 0, 2.5>
	look_at <-2.5, 4, 0>
}
*/   