// Persistence of Vision Ray Tracer Scene Description File
// File: jbmirror.pov
// Vers: 3.1
// Desc: "Through the looking glass" fo irtc round on "Imaginary worlds"
// Date: 28.02.99
// Auth: Jerome M. BERGER
//

#version 3.1 ;

#include "colors.inc"
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "stones1.inc"
#include "woods.inc"
#include "metals.inc"
#include "golds.inc"

#declare fait_suie = 1 ;      // suie dans la chemine
#declare FastRounded = 0 ;    // bords arrondis?
#declare SimpleBricks = 0 ;   // faire les briques ou les simuler ?

#include "metrics.inc"
#include "rounded.inc"
#include "logs.inc"
#include "candle1.inc"
#include "candle2.inc"
#include "chimney.inc"
#include "buches.inc"
#include "bougeoir.inc"
#include "clock.inc"
#include "books.inc"
#include "table.inc"
#include "fenetre.inc"
#include "vase.inc"

global_settings
{
  assumed_gamma 2.2
  ambient_light 3
  max_trace_level 10
}

// ----------------------------------------
camera
{
  location  <2.0, 1.8, -3.0>*m
  look_at   <0.0, 1.15,  0.0>*m
  angle 40
}

sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color rgb <0.2, 0.2, 1>] [0.7 color rgb 1 ] [1.0 color rgb 1] }
  }
}

// ----------------------------------------
#declare WallColor = color rgb <255, 247, 183>/255 ;
#declare TWall = texture {
  pigment { color WallColor }
  normal { bumps 0.3 scale <1*mm, 1*m, 1*mm> }
}

#declare Room = union {
  object {
    Table
    translate <145, 0, -26>*cm
  }
  
  object {
    Table
    translate <-145, 0, -26>*cm
  }
  
  object {
    Table
    rotate 90*y
    translate <-274, 0, -300>*cm
  }
  
  object {
    Table
    rotate 90*y
    translate <-274, 0, -500>*cm
  }
  
  object { 
    Books
    rotate -10*y
    translate <115, 70, -30>*cm
  }

  light_source
  {
    0*x // light's position (translated below)
    color White/1.5  // light's color
    translate <0, 2.4, -5>*m
  }
  
  object {
    Clock
    rotate -90*y
    translate <-2.84, 0, -4>*m
  }

  object {
    Chimney
    translate z*10*cm
  }  
  
  object {
    Buches
  }
  
  object {
    Vase
    translate <35, 110, -15>*cm
  }
  
  object {
    Bougeoir
    translate 1.1*m*y-12*cm*z-30*cm*x
  }
  
  #declare i = 0 ;
  #while (i<5)
    object {
      Fenetre
      rotate -90*y
      translate <-3.2, 1.1, -1-2*i>*m
    }
    #declare i = i+1 ;
  #end
  
  union {
    difference { // murs
      box { <-3.4, -0.1, -10.5>*m, <3.4, 3, 0.001>*m }
      box { <-3, -0.2, -10>*m, <3, 3.1, 0.1>*m } // interieur
      
      #declare i = 0 ; // fenetres
      #while (i<5)
        box { <-3.6, 1.1, -1.5-2*i>*m, <-2.9, 2.3, -0.5-2*i>*m }
        #declare i = i+1 ;
      #end
      texture { TWall }
    }
    difference { // plinthes
      box { <-3.1, -0.1, -10.1>*m, <3.1, 0.09, 0.0001>*m }
      box { <-2.985, -0.2, -9.985>*m, <2.985, 0.1, -0.015>*m }
      box { <-50, -20, -2>*cm, <50, 10, 1>*cm }
      pigment { color White }
    }
  }
  
  box { // plafond
    <-3.5, 2.7, -10.5>*m, <3.5, 2.8, 0.05>*m
    pigment { color White }
  }
  
  box { // sol
    <-3.5, -0.05, -10.5>*m, <3.5, 0, 0.05>*m
    texture {
      material_map {
        png "sol.png"
        texture {
          pigment { color Black }
        }
        texture {
          T_Stone23
          scale <1, 378/656, 1>*0.1
        }
        texture {
          pigment { White_Marble }
          finish { phong 1 phong_size 90 }
          scale <1, 378/656, 1>*0.1
        }
        texture {
          T_Stone13
          scale <1, 378/656, 1>*0.1
        }
        texture {
          T_Stone18
          scale <1, 378/656, 1>*0.1
        }
        texture {
          T_Stone21
          scale <1, 378/656, 1>*0.1
        }
      }
      scale <1, 656/378, 1>
      rotate 90*x
      scale 50*cm
    }
  }
}

union {
  object { Room }
  object { 
    Candle1
    translate 1.1*m*y-12*cm*z-30*cm*x
  }
  
  clipped_by {
    union {
      plane { z, 0 }
      box { <-50, 0, -0.1>*cm, <70, 101, 60>*cm }
    }
  }
}

union {
  object { Room }
  object { 
    Candle2
    translate 1.1*m*y-12*cm*z-30*cm*x
  }

  clipped_by {
    difference {
      plane { z, 0 }
      box { <-70, -1, 1>*cm, <70, 105, -30>*cm }
    }                                         
  }

  matrix <1, 0, 0,
          0, 1, 0,
          0, 0,-1,
          0, 0, 0>
}    

difference { // mur du fond
  box { <-4, -0.1, -0.01>*m, <4, 2.6, 0.01>*m }
  box { <-50, 0, -55>*cm, <50, 109, 60>*cm }
  box { <-50, 113, -2>*cm, <50, 213, 2>*cm } // mirroir!
  texture { TWall } 
}

box { // verre du mirroir
  <-55, 112, -0.1>*cm, <55, 214, 0.1>*cm
  pigment { color rgbf <1, 1, 1, 0.95> }
}

union { // cadre du miroir
  cylinder { <-50, 113, 0>*cm, <-50, 213, 0>*cm, 2*cm }
  cylinder { <-50, 213, 0>*cm, <50, 213, 0>*cm, 2*cm }
  cylinder { <50, 213, 0>*cm, <50, 113, 0>*cm, 2*cm }
  cylinder { <50, 113, 0>*cm, <-50, 113, 0>*cm, 2*cm }
  
  sphere { <-50, 113, 0>*cm, 2*cm }
  sphere { <-50, 213, 0>*cm, 2*cm }
  sphere { <50, 213, 0>*cm, 2*cm }
  sphere { <50, 113, 0>*cm, 2*cm }

  texture {
    bozo
    texture_map {
      [  0.0 T_Wood10 scale 1/10 ]
      [ 0.01 T_Wood10 scale 1/10 ]
      [  0.1 T_Gold_3C           ]
      [  1.0 T_Gold_3C           ]
    }
    scale 10*cm
  }
}
