#local Cover = union {
  difference {
    box { <-12, 0, 0>*cm, <12, 4, 36>*cm }
    box { <-13, 0.2, -1>*cm, <13, 3.8, 37>*cm }
    
    bounded_by { box { <-12, 0, 0>*cm, <12, 4, 36>*cm } }
  }
  cylinder { <-12, 0.1, 36>*cm, <12, 0.1, 36>*cm, 0.1*cm }
  cylinder { <-12, 3.9, 36>*cm, <12, 3.9, 36>*cm, 0.1*cm }
  cylinder { <-12, 0.1, 0>*cm, <12, 0.1, 0>*cm, 0.1*cm }
  cylinder { <-12, 3.9, 0>*cm, <12, 3.9, 0>*cm, 0.1*cm }
  cylinder { <-12, 0.1, 0>*cm, <-12, 0.1, 36>*cm, 0.1*cm }
  cylinder { <-12, 3.9, 0>*cm, <-12, 3.9, 36>*cm, 0.1*cm }
  
  sphere { <-12, 0.1, 36>*cm, 0.1*cm }
  sphere { <-12, 0.1, 36>*cm, 0.1*cm }
  sphere { <-12, 3.9, 0>*cm, 0.1*cm }
  sphere { <-12, 3.9, 0>*cm, 0.1*cm }
  
  intersection {
    union {
      cylinder { <12, 2, 0>*cm, <12, 2, 36>*cm, 2*cm }
      torus { 2*cm, 1*mm rotate 90*x translate <12, 2, 36>*cm }
      torus { 2*cm, 1*mm rotate 90*x translate <12, 2, 0>*cm }
    }
    box { <12, 0, -0.1>*cm, <14, 4, 36.1>*cm }
    
    bounded_by { box { <12, 0, -0.1>*cm, <14, 4, 36.1>*cm } }
  }
}

#local Pages = box {
  <-11, 0.1, 0.2>*cm, <12, 3.9, 35.8>*cm
  pigment {
    gradient y
    sine_wave
    color_map {
      [0 color White ]
      [1 color Gray50]
    }
    scale 5*mm
  }
}

#declare Books = union {
  union {
    union {
      object {
        Cover
        
        pigment { 
          image_map { png "book.png" interpolate 2 } 
          scale <24, 36, 1>*cm 
          rotate 90*x 
          translate -12*x*cm
        }
      } 
      object { Pages }
    }
    
    union {
      object {
        Cover
        pigment { color Blue/2 }
      }
      object { Pages }
      translate <0, -4, -1>*cm
    }
    
    union {
      object {
        Cover
        pigment { color Green/2 }
      }
      object { Pages }
      translate <0, -8, 2>*cm
    }
    
    rotate -90*x
    rotate -90*z
    translate <-18, 14.5, -2>*cm
  }
              
  union {
    cylinder { <-5, 0, 6.5>*cm, <-5, 0, -6.5>*cm, 5*mm }
    cylinder { <-5, 0, -6.5>*cm, <-5, 10, -6.5>*cm, 5*mm }
    cylinder { <-5, 10, -6.5>*cm, <5, 10, -6.5>*cm, 5*mm }
    cylinder { <5, 10, -6.5>*cm, <5, 0, -6.5>*cm, 5*mm }
    cylinder { <5, 0, -6.5>*cm, <5, 0, 6.5>*cm, 5*mm }
    
    sphere { <-5, 0, -6.5>*cm, 5*mm }
    sphere { <-5, 10, -6.5>*cm, 5*mm }
    sphere { <5, 10, -6.5>*cm, 5*mm }
    sphere { <5, 0, -6.5>*cm, 5*mm }
    
    texture { Chrome_Texture }
  }
}