#include "flame.inc"

#declare Candle1 = union {
  difference {
    blob {
      threshold 0.5
      cylinder { <0, 0, 0>, <0, 20*cm, 0>, 1.81*cm, strength 5 } // main shaft
      sphere { <0, 20*cm, 0>, 1.81*cm, strength -10 }     // top
      
      sphere { 
        <1.5, 0, 0>*cm, 1*cm, strength -2 
        rotate 120*y 
        scale <1, 0.25, 1> 
        translate 19.1*cm*y 
      }
      cylinder { <1.5, 10, 0>*cm, <1.5, 19, 0>*cm, 3.8*mm, strength 1 rotate 120*y }
      sphere { <1.5, 0, 0>*cm, 4*mm, strength 1 scale <1, 2, 1> translate 10*cm*y rotate 120*y }
  
      cylinder { <1.5, 5, 0>*cm, <1.5, 19.3, 0>*cm, 5.54*mm, strength 1 }
      sphere { <1.5, 0, 0>*cm, 5*mm, strength 2 scale <1, 2, 1> translate 5*cm*y }
      cylinder { <1.8, 10, 0>*cm, <1.8, 19, 0>*cm, 5.54*mm, strength 1 }
      cylinder { <2.0, 12, 0>*cm, <2.05, 18.3, 0>*cm, 5.54*mm, strength 1 }
      cylinder { <2.2, 13, 0>*cm, <2.3, 17, 0>*cm, 5.54*mm, strength 1 }
  
    } 
    plane { y, 0.01*mm }    
    
    bounded_by { cylinder { <0, 0, 0>, <0, 20*cm, 0>, 2.6*cm } }
                                   
    pigment { color rgb <253, 251, 223>/255 }
  }
  difference {
    torus { 2*cm, 1*mm }
    plane { -z, 0 }
    plane { z, 0 rotate 45*y }
    
    bounded_by { box { <2.1/sqrt(2), -0.1, -2.1/sqrt(2)>*cm, <2.1, 0.1, 0>*cm } }
    
    pigment { color Black }
    no_shadow
    
    rotate 90*x
    translate 18.9*y*cm-2*cm*x
    rotate 60*y
  }
  object {
    Flame
    scale 4*cm
    translate 20*cm*y
  }
  light_source {
    20.5*cm*y
    color rgb <0.6, 0.5, 0.0>/4
    fade_distance 20*cm
    fade_power 2
  }
  
  rotate 10*y
}