#declare Candle2 = union {
  difference {
    blob {
      threshold 0.5
      cylinder { <0, 0, 0>, <0, 10*cm, 0>, 1.81*cm, strength 5 } // main shaft
      sphere { <0, 10*cm, 0>, 1.81*cm, strength -10 }     // top
      
      #local BS = seed(12345);
      #local i = 0;
      #while (i<25)
        sphere { 
          <sqrt(rand(BS))*2 , rand(BS)*1.5, 0>*cm, (1.5*rand(BS)+0.5)*cm, strength 2 
          rotate (-120+rand(BS)*360)*y
        }
        #local i=i+1;
      #end
      #local i = 0;
      #while (i<50)
        sphere { 
          <sqrt(rand(BS))*3 , rand(BS)/2, 0>*cm, (1.5*rand(BS)+0.5)*cm, strength 2 
          rotate (-120+rand(BS)*360)*y
        }
        #local i=i+1;
      #end
      #local i = 0;
      #while (i<25)
        sphere { 
          <sqrt(rand(BS))+0.5 , rand(BS)*1.5+1.7, 0>*cm, (1.5*rand(BS)+0.5)*cm, strength 2 
          rotate (-120+rand(BS)*360)*y
        }
        #local i=i+1;
      #end

      sphere { 
        <1.5, 0, 0>*cm, 1*cm, strength -2 
        rotate 120*y 
        scale <1, 0.25, 1> 
        translate 9.1*cm*y 
      }
      cylinder { <1.5, 0, 0>*cm, <1.5, 9, 0>*cm, 3.8*mm, strength 1 rotate 120*y }
  
      cylinder { <1.5, 0, 0>*cm, <1.5, 10, 0>*cm, 5.54*mm, strength 1 }
      cylinder { <1.7, 0, 0>*cm, <1.8, 10.2, 0>*cm, 5.54*mm, strength 1 }
      cylinder { <1.9, 0, 0>*cm, <2.05, 10, 0>*cm, 5.54*mm, strength 1 }
      cylinder { <2.1, 0, 0>*cm, <2.3, 9, 0>*cm, 5.54*mm, strength 1 }
  
    } 
    plane { y, 0.01*mm }     
    
    bounded_by { cylinder { <0, 0, 0>, <0, 10, 0>*cm, 4.5*cm } }
                                  
    pigment { color rgb <253, 251, 223>/255 }
  }
  difference {
    torus { 2*cm, 1*mm }
    plane { -z, 0 }
    plane { z, 0 rotate 45*y }
    
    bounded_by { box { <2.1/sqrt(2), -0.1, -2.1/sqrt(2)>*cm, <2.1, 0.1, 0>*cm } }
    
    pigment { color Black }
    rotate 90*x
    translate 8.9*y*cm-2*cm*x
    rotate 60*y
  }

  rotate 10*y
  //rotate -90*x
}