#ifndef (SimpleBricks)
  #declare SimpleBricks = 0 ;
#end

#declare BrickSize = <13.5, 5.5, 6.75>*cm ;
#declare Gap = 6*cm ;  
#declare MortarRecess = 0.1 ;
#declare BrickTexture = texture { pigment { color Firebrick } } 
#declare MortarTexture = texture { pigment { color Gray80 } }
#declare Rseed = seed(12) ;


#declare TSuie = texture {
  pigment {
    bozo
    pigment_map {
      [ 0.0 color rgbf <0.4, 0.4, 0.4, 1> ]
      [ 0.1 color rgbf <0.15, 0.15, 0.15, 1> ]
      [ 1.0 color rgbf <0.10, 0.10, 0.10, 1> ]
    }
  }
  finish { phong 0.25 } 
  normal { bumps 1 scale 0.2 } 
  //turbulence 1
  scale <0.13, 0.1, 0.1>
} 

#declare Chimney = union {
  union {
    RoundedBox (-70*cm, 1*m, -35*cm, 70*cm, 1.1*m, 40*cm, 0.5*cm)    // tablier
    difference {
      RoundedBox (-65*cm, -1*cm, -25*cm, -45*cm, 1.1*m, 40*cm, 0.5*cm) // bord gauche
      #declare i=0; // nervures du bord gauche
      #while (i<6)
        union {
          cylinder { <(-62.5+3*i)*cm, 10*cm, -25*cm>, <(-62.5+3*i)*cm, 90*cm, -25*cm>, 1*cm }
          sphere { <(-62.5+3*i)*cm, 10*cm, -25*cm>, 1*cm }
          sphere { <(-62.5+3*i)*cm, 90*cm, -25*cm>, 1*cm }
        }
        #declare i=i+1;
      #end  
      bounded_by { box { <-65, -1, -25>*cm, <-45, 110, 40>*cm } }
    }
    difference {
      RoundedBox ( 65*cm, -1*cm, -25*cm,  45*cm, 1.1*m, 40*cm, 0.5*cm) // bord droit
      #declare i=0; // nervures du bord droit
      #while (i<6)
        union {
          cylinder { <(62.5-3*i)*cm, 10*cm, -25*cm>, <(62.5-3*i)*cm, 90*cm, -25*cm>, 1*cm }
          sphere { <(62.5-3*i)*cm, 10*cm, -25*cm>, 1*cm }
          sphere { <(62.5-3*i)*cm, 90*cm, -25*cm>, 1*cm }
        }
        #declare i=i+1;
      #end
      bounded_by { box { <65, -1, -25>*cm, <45, 110, 40>*cm } }
    }
    pigment { White_Marble scale 0.5 }
    finish {
      phong 0.2
    }
  }
        
  // fond de la chemine
  #if (SimpleBricks)      
    box { 
      <-50*cm, 0*m, 40*cm> <50*cm, 1.05*m, 39*cm>
      pigment { brick color Gray80, color Firebrick scale 0.02 turbulence 0.05 translate 10*cm*z }
      normal { brick 0.6 scale 0.02 turbulence 0.05 translate 10*cm*z+1*cm*x+0.5*cm*y }
    }
  #else
    /*#declare X_Size = 105*cm ;
    #declare Z_Size = 16.8*cm ;
    #declare Height = 102*cm ;
    
    object {
      #include "bricks\BrickBoxMacro.inc"
      translate <-X_Size/2, 0, 39*cm>
    }*/
    union {
      box { <-50, 0, 39.6>*cm, <50, 105, 40>*cm texture { MortarTexture } }
      #local pair = 0 ;
      #local i = 0 ;
      #while (i<17)  
        union {   
          #if (pair)
            box { <-50, i*6, 39>*cm, <-43.25, i*6+5.5, 41>*cm texture { BrickTexture } }
            box { <43.25, i*6, 39>*cm, <50, i*6+5.5, 41>*cm texture { BrickTexture } }
          #end
          #local j = pair ;
          #while (j<13)
            box { 
              <-50+j*(6.75+(100-7*13.5)/(pair+6)), i*6, 39>*cm,
              <-36.5+j*(6.75+(100-7*13.5)/(pair+6)), i*6+5.5, 41>*cm 
              texture { BrickTexture }
            }
            #local j = j+2 ;
          #end 
          bounded_by { box { <-50, i*6, 39>*cm, <50, i*6+5.5, 41>*cm } }
        }
        #local pair = 1-pair ;
        #local i = i+1 ;
      #end
      bounded_by { box { <-50, 0, 39>*cm, <50, 101.5, 41>*cm } }
    }
  #end

  #if (fait_suie)
    box {
      <-50*cm, 0*m, 40*cm> <50*cm, 1.05*m, 39*cm-0.1*mm>
      texture { 
        cylindrical
        texture_map {
          [ 0.0 pigment { rgbf 1 } ]
          [ 1.0 TSuie ]
        }
        turbulence 0.1
        rotate 90*x
        scale <0.75, 1, 1>
      }
    }
  #end
  
  // sol du foyer
  #if (SimpleBricks)
    box { 
      <-50*cm, -1*cm, 40*cm> <50*cm, 5*cm, -20*cm>
      pigment { brick color Gray80, color Firebrick scale 0.021 turbulence 0.05 rotate 90*y }
      normal { brick 0.6 scale 0.021 turbulence 0.05 rotate 90*y translate <1, 0.6, 0.4>*cm }
    }              
  #else
    union {
      box { <-50, -1, 40>*cm, <50, 4.4, -19.4>*cm texture { MortarTexture } }
      #declare BrickSize = <6.75, 5, 13.5>*cm ;
      #local j = 0 ;
      #while (j<4)
        union {
          #local i = 0 ;
          #while (i<13)
            box { 
              <-50+i*(6.75+(100-6.75*13)/12), 0, -20+j*(13.5+(60-13.5*4)/3)>*cm, 
              <-50+i*(6.75+(100-6.75*13)/12), 0, -20+j*(13.5+(60-13.5*4)/3)>*cm + BrickSize
              texture { BrickTexture } 
            }
            #local i = i+1 ;
          #end
          bounded_by { 
            box { 
              <-50, -1, -20+j*(13.5+(60-13.5*4)/3)>*cm, 
              <50, 5, -6.5+j*(13.5+(60-13.5*4)/3)>*cm 
            }
          }
        }
        #local j = j+1 ;
      #end
      bounded_by { box { <-50, -1, -20>*cm, <50, 5, 40>*cm } }
    }  
  #end

  #if (fait_suie)
    box {
      <-50*cm, 4*cm, 40*cm> <50*cm, 5*cm+0.1*mm, -19.5*cm>
      texture { 
        cylindrical
        texture_map {
          [ 0.0 pigment { rgbf 1 } ]
          [ 1.0 TSuie ]
        }
        turbulence 0.1
        rotate 90*x
        scale <0.75, 1, 1>
      }
    }
  #end
}  

