#include "aiguille.inc"
#local S=seed(1975) ;
#local Bouton = union {
  cylinder { <0, 0, 1>*cm, <0, 0, -5>*cm, 1*cm }
  sphere { <0, 0, -5>*cm, 2*cm }
  texture { T_Wood29 scale 50*cm rotate 90*x translate 50*cm*x rotate (179+2*rand(S))*y }
}

#local Corps = union {
  difference {
    object {
      RoundedBox (-20*cm, 0, -15*cm, 20*cm, 2*m, 15*cm, 1*cm)
    }
    union {
      cylinder { <0, 0, -14*cm>, <0, 0, 14*cm>, 39*cm }
      cylinder { <0, 0, -18*cm>, <0, 0, -13*cm>, 30*cm }
      scale <1, 0.75, 1>
      translate 1*m*y
    }

    bounded_by { box { <-20, 0, -15>*cm, <20, 200, 15>*cm } }
    texture { T_Wood29 scale 50*cm rotate 90*x translate 50*cm*x rotate (179+2*rand(S))*y }
  }
  
  difference {
    union {
      cylinder { <0, 0, -15*cm>, <0, 0, 15*cm>, 40*cm }
      cylinder { <0, 0, -17*cm>, <0, 0, 0>, 35*cm }
    }
    cylinder { <0, 0, -14*cm>, <0, 0, 14*cm>, 39*cm }
    cylinder { <0, 0, -18*cm>, <0, 0, -13*cm>, 25*cm }
    
    bounded_by { cylinder { <0, 0, -17*cm>, <0, 0, 15*cm>, 40*cm } }
    scale <1, 0.75, 1>
    texture { T_Wood29 scale 50*cm rotate 90*x translate 50*cm*x rotate (179+2*rand(S))*y }
    translate 1*m*y
  }
  
  cylinder {
    <0, 0, -15.5>*cm, <0, 0, -15>*cm, 30*cm
    scale <1, 0.75, 1>
    translate 1*m*y
    texture { Glass3 }
  }
  
  object {
    Bouton
    translate <-30, 100, -17>*cm
  }
  
  difference {
    box { <-15, 125, -17>*cm, <15, 190, -14>*cm }
    cylinder { <0, 0, -18*cm>, <0, 0, -13*cm>, 40*cm scale <1, 0.75, 1> translate 1*m*y }
    
    bounded_by { box { <-15, 125, -17>*cm, <15, 190, -14>*cm } }
    texture { T_Wood29 scale 50*cm rotate 90*x translate 50*cm*x rotate (2*rand(S)-1)*y }
  }
  
  object {
    Bouton
    translate <-10, 160, -17>*cm
  }
  
  difference {
    box { <-15, 75, -17>*cm, <15, 10, -14>*cm }
    cylinder { <0, 0, -18*cm>, <0, 0, -13*cm>, 40*cm scale <1, 0.75, 1> translate 1*m*y }
    
    bounded_by { box { <-15, 75, -17>*cm, <15, 10, -14>*cm } }
    texture { T_Wood29 scale 50*cm rotate 90*x translate 50*cm*x rotate (2*rand(S)-1)*y }
  }  
  
  object {
    Bouton
    translate <-10, 40, -17>*cm
  }
  
  box {
    <-22, 0, -17>*cm, <22, 2, 15>*cm
    texture { T_Wood29 scale 50*cm rotate 90*x translate 50*cm*x rotate (179+2*rand(S))*y }
  }

  box {
    <-22, 198, -17>*cm, <22, 201, 15>*cm
    texture { T_Wood29 scale 50*cm rotate 90*x translate 50*cm*x rotate (179+2*rand(S))*y }
  }
  
  union {
    box {
      <-0.5, -10, -0.5>*cm, <0.5, -110, 0.5>*cm
      texture { T_Chrome_3A }
    }
    intersection {
      cylinder { <0, -110, 0>*cm, <0, -110, -1>*cm, 10*cm }
      sphere { <0, -110, 29>*cm, 30*cm }
      
      bounded_by { cylinder { <0, -110, 0>*cm, <0, -110, -1>*cm, 10*cm } }
      texture { Brass_Metal }
    }
    rotate -5*z
    translate 210*cm*y-10*cm*z
  }
}

#local Haut = union {
  box { 
    <-25, -22, -19>*cm, <25, -20, 15>*cm 
    texture { T_Wood29 scale 50*cm rotate 90*x translate 50*cm*x rotate (179+2*rand(S))*y }
  }
  difference {
    box { <-22, -21, -15>*cm, <22, 17, 15>*cm }
    box { <-18, -20.5, -16>*cm, <18, 18, 14>*cm }
    box { <-23, -17, -11>*cm, <-21, 13, 11>*cm }
    box { <23, -17, -11>*cm, <21, 13, 11>*cm }
    
    bounded_by { box { <-22, -21, -15>*cm, <22, 17, 15>*cm } }
    texture { T_Wood29 scale 50*cm rotate 90*x translate 50*cm*x rotate (179+2*rand(S))*y }
  }
  intersection {
    cylinder { <0, 0, -20>*cm, <0, 0, 16>*cm, 25*cm }
    cylinder { <-22, 0, 0>*cm, <22, 0, 0>*cm, 25*cm }
    box { <-22, 17, -17>*cm, <22, 25, 15>*cm }

    bounded_by { box { <-22, 17, -17>*cm, <22, 25, 15>*cm } }
    texture { T_Wood29 scale 50*cm rotate 90*x translate 50*cm*x rotate (179+2*rand(S))*y }
  }
  box { 
    <-25, 16, -19>*cm, <25, 18, 15>*cm 
    texture { T_Wood29 scale 50*cm rotate 90*x translate 50*cm*x rotate (179+2*rand(S))*y }
  }
  box {
    <-20, -21, -7>*cm, <20, 17, 0>*cm
    texture { pigment { color White } }
    texture {
      pigment {
        image_map {
          png "clock.png"
          once       
          //interpolate 2
        }
        scale 30*cm
        translate <-15, -18, 0>*cm
        rotate 180*y
      }
    }
  }
  
  object { // petite aiguille
    Aiguille
    scale 12/26*cm
    translate -1*cm*y
    pigment { color Black }
    translate -8*z*cm
    rotate 120*z
    translate -3*cm*y
  }
  
  object { // grande aiguille
    Aiguille
    scale <12/26, 16/26, 1>*cm
    translate -1*cm*y
    pigment { color Black }
    translate -9*z*cm
    rotate 10*z
    translate -3*cm*y
  }
  
  difference {
    box { <-20, -21, -10>*cm, <20, 17, -11>*cm }
    box { <-14, -16, -9>*cm, <14, 12, -12>*cm }
    
    bounded_by { box { <-20, -21, -10>*cm, <20, 17, -11>*cm } }
    texture { T_Wood29 scale 50*cm rotate 90*x translate 50*cm*x rotate (179+2*rand(S))*y }
  }
  
  object {
    Bouton
    translate <-16, -3, -11>*cm
  }
  
  box {
    <-15, -17, -10.1>*cm, <15, 13, -10.6>*cm
    texture { Glass3 }
  }
  
  bounded_by { box { <-25, -22, -19>*cm, <25, 25, 15>*cm } }
  
  translate 222*cm*y
}

#declare Clock = union {
  object { Corps }
  object { Haut }
}
