// ---------------------------------------
// main object declarations for Jellyworld

#declare Jelly_Mountain = merge {
cone {<0, 0, 0>, 4
      <0, 5, 0>, 1}
blob {
threshold 0.6

#declare Count = 0
#while (Count < 360)
sphere {<1.4, 4, 0>, 1, 1
       rotate <0, Count, 0>
}
sphere {<1.2, 4.5, 0>, 1, 1
       rotate <0, Count, 0>
}
sphere {<0.8, 5, 0>, 1, 1
       rotate <0, Count, 0>
}
#declare Count = Count + 45
#end

#declare Count = 0
#while (Count < 360)

#declare Count1 = 0
#while (Count1 < 2)
sphere {<2+Count1*0.3, 3.5, 0>, 1, 1
       rotate <0, Count, 0>
       translate <0, -Count1, 0>
}
#declare Count1 = Count1 + 0.5
#end

#declare Count=Count + 36
#end

#declare Count = 0
#while (Count < 360)

#declare Count1 = 0
#while (Count1 < 2)
sphere {<3+Count1*0.3, 1.5, 0>, 1, 1
       rotate <0, Count, 0>
       translate <0, -Count1, 0>
}
#declare Count1 = Count1 + 0.5
#end

#declare Count=Count + 20
#end

} // end blob
} // end of union

// ----------------------------
// trees

#declare Candy_Floss_Tree = union {

#declare Count = 0
#while (Count < 360)
sphere {<2.5, 0.4-rand(R1)*0.8, 0>, rand(R1)+0.5
        texture {Candy_Floss
                 rotate <rand(R1)*360, rand(R1)*360, rand(R1)*360>
        }
        rotate <0, Count, 0>
}
sphere {<1.9, 1.5-rand(R1)*0.2, 0>, rand(R1)+0.5
        texture {Candy_Floss
                 rotate <rand(R1)*360, rand(R1)*360, rand(R1)*360>
        }
        rotate <0, Count, 0>
}
sphere {<1.9, -1.5+rand(R1)*0.2, 0>, rand(R1)+0.5
        texture {Candy_Floss
                 rotate <rand(R1)*360, rand(R1)*360, rand(R1)*360>
        }
        rotate <0, Count, 0>
}
sphere {<1.5, 2.5-rand(R1)*0.2, 0>, rand(R1)+0.5
        texture {Candy_Floss
                 rotate <rand(R1)*360, rand(R1)*360, rand(R1)*360>
        }
        rotate <0, Count, 0>
}
sphere {<1.5, -2.5+rand(R1)*0.2, 0>, rand(R1)+0.5
        texture {Candy_Floss
                 rotate <rand(R1)*360, rand(R1)*360, rand(R1)*360>
        }
        rotate <0, Count, 0>
}
#declare Count = Count + 30
#end

cylinder {<0, 0, 0>, <0, -10, 0>, 0.2
pigment {color rgb <0.96, 0.96, 0.9>}
}
scale 0.5
} // end candy floss union

#declare Apple =
sor
{
    9,
    <0, 0>
    <0.5, 0>
    <0.8, 0.1>
    <1, 0.6>
    <1, 1.5>
    <0.5, 1.7>
    <0.5, 1.75>
    <0.7, 1.8>
    <0, 1.8>
}

#declare Toffee_Apple_Tree = union {
object {Apple
texture {
        pigment { bozo
                 color_map {
                 [0.0 color rgb <0.6, 0, 0>]
                 [1.0 color Green]}
                 scale 1
                 }
        finish {ambient 0.3}
        }
}
object {Apple
        scale <1.1, 1, 1.1>
texture {
        pigment { color rgbt <0.6, 0.2, 0.2, 0.3>}
        finish {Shiny}
        normal {crackle 0.3 scale 0.3}
        }
}
box {<-0.1, 0.5, -0.1>, <0.1, -5, 0.1>
     texture {Yellow_Pine}
}

} // end toffee apple tree union

// ---------------------------------------------
// diving board rails


#declare DB_rail =
union {
cylinder {<0, -1, 0>, <0, 0.5, 0>, 0.07
pigment {gradient <1, 1, 0>
         color_map {
         [0.0 color Red]
         [0.5 color Red]
         [0.5 color White]
         [1.0 color White]}
         scale 0.2
         }
}
torus {0.3, 0.07
       scale <1, 1, 1.5>
pigment {radial
         frequency 13
         color_map {
         [0.0 color Red]
         [0.5 color Red]
         [0.5 color White]
         [1.0 color White]}
         }
       rotate <90, 0, 0>
       clipped_by {plane {y, 0 inverse} }
       translate <-0.3, 0.5, 0>
}
} // end rail union


// ----------------------------------
// chocolate bits

#declare Choc_bit =
difference {
  box {<-0.5, 0,-0.5>, <0.5, 0.5, 0.5>}
  plane {y, 0.6 inverse
         rotate <40, 0, 0>}
  plane {y, 0.6 inverse
         rotate <-40, 0, 0>}
  plane {y, 0.5 inverse
         rotate <0, 0, -70>}
  plane {y, 0.5 inverse
         rotate <0, 0, 70>}
  cylinder {<-0.1, 0.51, -0.2>, <-0.1, 0.51, 0.2>, 0.05}
  cylinder {<-0.1, 0.51, 0>, <0.2, 0.51, 0.2>, 0.05}
  cylinder {<-0.1, 0.51, 0>, <0.2, 0.51, -0.2>, 0.05}

texture {Chocolate}
}

// make a tile of chocolate

#declare Choc_Chunk = union {
#declare Count = 0
#while (Count < 4)

#declare Count1 = 0
#while (Count1 < 4)
object {Choc_bit
        translate <Count+0.5, -0.4, Count1+0.5>}

#declare Count1 = Count1 + 1
#end

#declare Count=Count + 1
#end

} // end chocchunk


#declare Liq_Square =
superellipsoid {<0.1, 0.1>
                translate <0, 1, 0>
                scale 0.499
                pigment {gradient y
                        color_map {
                        [0.0 color Orange]
                        [0.33 color Orange]
                        [0.33 color Black]
                        [0.66 color Black]
                        [0.66 color White]
                        [1.0 color White] }
                        }
                 scale <0.6, 0.4, 0.6>
}

#declare Liq_Round = 
cylinder {<0, 0, -0.5>, <0, 0, 0.5>, 0.125
          pigment {
                   wood
                   color_map {
                   [0.0 color White]
                   [0.15 color White]
                   [0.15 color Black]
                   [1.0 color Black] }
                   }
          finish {ambient 0.2}
}                   

#declare Jelly_Baby =
blob {
     threshold 0.1
// legs
     cylinder {<0.05, 0, 0>, <0.05, 0.25, 0>, 0.1, 1}
     cylinder {<-0.05, 0, 0>, <-0.05, 0.25, 0>, 0.1, 1}
// arms
     cylinder {<0.15, 0.3, 0>, <0.15, 0.4, 0>, 0.1, 1}
     cylinder {<-0.15, 0.3, 0>, <-0.15, 0.4, 0>, 0.1, 1}
// body
     sphere {<0, 0.45, 0>, 0.1, 1
             scale <2.1, 1, 1> }
     sphere {<0, 0.2, 0>, 0.2, 1
             scale <1, 1.5, 0.8> }
// head
     sphere {<0, 0.6, 0>, 0.15, 1}
     sphere {<0, 0.58, -0.11>, 0.025, 1}

     sphere {<0.04, 0.61, -0.45>, 0.025, -1
             scale <1.1, 1, 0.25>}
     sphere {<-0.04, 0.61, -0.45>, 0.025, -1
             scale <1.1, 1, 0.25>}
     sphere {<0, 0.56, -0.45>, 0.025, -1
             scale <1.5, 1, 0.25>}

pigment {color rgb <0.7, 0.2, 0.2>}
}


#declare Lolly_Pop = union {

sphere {<0, 0, 0>, 0.25
        scale <1, 0.3, 1>
        pigment {color rgbf <1, 1, 0, 0.6>}
        finish {ambient 0.3}
}        
cylinder {<0, 0, 0>, <0, 0, -0.7>, 0.03
          pigment {color White}
          finish {ambient 0.3}
}          

} // end lolly pop

#declare Lolly_Umbrella = union {
#declare Count = 0
#while (Count < 5)
object {Lolly_Pop
        translate <0, 0, -0.4>
        rotate <0, 0, 10>
        rotate <-30, Count*72, 0>
}
object {Lolly_Pop
        rotate <180, 0, 0>
        translate <0, 0, -1>
        rotate <0, 0, 10>
        rotate <-30, 54 + Count*72, 0>
}
object {Lolly_Pop
        rotate <180, 0, 0>
        translate <0, 0, -1>
        rotate <0, 0, 10>
        rotate <-30, 18 + Count*72, 0>
}
#declare Count=Count + 1
#end
object {Liq_Round
        rotate <90, 0, 0>
        translate <0, -0.5, 0>
}

translate <0, 1, 0>        
} // end lolly umb        
