/*#include "colors.inc"

camera {
  location <1,3,-5>
  look_at <0,0,0>
}

light_source {<50,1000,-250> White}*/

#declare R2=seed(206)

#declare Card_Back=texture {
  //pigment {checker rgb <.25,.125,1>,<.375,.25,1> rotate y*45 scale <1,1,1.5>}
  pigment {checker rgb <.25,.125,1>,<.375,.25,1> rotate <45,90,0> translate y*.95}
  finish {
    specular .5
    roughness .005
    reflection .05
  }
  normal {
    leopard .1
    scale .1
  }
  scale .125
}

#declare Card_Layer=union {
  box {<-1.125,0,-1.75>,<1.125,.01,1.75>}
  box {<-1.25,0,-1.625>,<1.25,.01,1.625>}
  cylinder {<-1.125,0,-1.625>,<-1.125,.01,-1.625>,.125}
  cylinder {<-1.125,0,1.625>,<-1.125,.01,1.625>,.125}
  cylinder {<1.125,0,-1.625>,<1.125,.01,-1.625>,.125}
  cylinder {<1.125,0,1.625>,<1.125,.01,1.625>,.125}
}

#declare Card=difference {
  object {Card_Layer
    texture {
      pigment {White}
      /*normal {
        leopard .1
        scale .1
      }*/
      finish {
        specular .5
        roughness .005
        reflection .05
      }
      scale .125
    }
  }
  box {<-1.125,0,-1.625>,<1.125,1,1.625>
    translate y*.009999
    texture {Card_Back}
  }
  scale <1.5,1,2>
}

//object {Card texture {Card_Back}}

#declare Deck=union {
  #declare Count=0
  #while (Count<50)
    object {Card rotate y*Count*.2 translate <.3,.01*Count,rand(R2)*.002*Count-.001*Count>}
    #declare Count=Count+1
  #end
}

//object {Deck}
