//#include "colors.inc"
//#include "glass.inc"
#include "golds.inc"

//#declare View=2;
#declare Hour=1;
#declare Min=52;
#declare Sec=38;

/*camera {
  location <3/View,5/View,-3/View> // Normal
  //location <1.25,.25,0> // Dial
  //location <.0625,1.5,-.2> // Above
  look_at <0,0,0>
}*/

//light_source {<250,750,-150> White*.75}
//light_source {<-25,50,-750> White}

//background {SkyBlue}

//plane {y,0 pigment {checker White, Black turbulence .005}}

#declare BottomLip=union {
  cylinder {<0,0,0>,<0,1/16,0>,.75-1/16}
  torus {.75-1/16,1/16}
}

#declare MiddleLip=union {
  cone {<0,1/16,0>,.75,<0,1/8-.005,0>,.75+1/16}
  cylinder {<0,1/8-.005,0>,<0,1/8+.005,0>,.75+1/16}
  cone {<0,1/8+.005,0>,.75+1/16,<0,3/16,0>,.75}
}

#declare UpperLip=difference {
  torus {.75-3/16,1/8}
  torus {.75-3/16,1/8-.01}
  cylinder {<0,0,0>,<0,1/8,0>,.75-3/16}
}

#declare StemBox=difference {
  box {<.7,1/16+1/64,-1/8>,<.75+3/16,3/16-1/64,1/8>}
  cylinder {<.75+1/8,.125,0>,<.75+2/8,.125,0>,2.5/32}
}

#declare StemKnob=difference {
  union {
    #declare Count=0;
    #while (Count<6)
      box {<.75+9/64,-1/32,-3/64>,<.75+7/32,3/64,3/64>
        rotate x*Count*15
      }
      #declare Count=Count+1;
    #end
    translate y*.125
  }
  cylinder {<.75+1/8,.125,0>,<.75+3/8,.125,0>,3/64}
}

#declare StemPin=difference {
  cylinder {<.75+1/8,.125,0>,<.75+1/4,.125,0>,1/32}
  cylinder {<.75+1/8+1/64,.125,0>,<.75+1/2,.125,0>,1/64}
  box {<.75+1/8+1/64,-.0001-1/32,-1/128>,<.75+1/2,.0001+1/32,1/128>
    rotate x*15
    translate y*.125
  }
}

#declare DRing=union {
  sphere {<.75+5/32,.125,-1/8-1/64>,1/32}
  sphere {<.75+5/32,.125,1/8+1/64>,1/32}
  sphere {<.75+5/32,.125,-1/8-3/32>,1/32}
  sphere {<.75+5/32,.125,1/8+3/32>,1/32}
  cylinder {<.75+5/32,.125,-1/8-1/64>,<.75+5/32,.125,-1/8-3/32>,1/32}
  cylinder {<.75+5/32,.125,1/8+1/64>,<.75+5/32,.125,1/8+3/32>,1/32}
  cylinder {<.75+5/32,.125,-1/8-1/32>,<.75+7/32,.125,-1/8-3/32>,1/32}
  cylinder {<.75+5/32,.125,1/8+1/32>,<.75+7/32,.125,1/8+3/32>,1/32}
  sphere {<.75+7/32,.125,-1/8-3/32>,1/32}
  sphere {<.75+7/32,.125,1/8+3/32>,1/32}
  cylinder {<.75+7/32,.125,-1/8-3/32>,<.75+6/16,.125,0>,1/32}
  cylinder {<.75+7/32,.125,1/8+3/32>,<.75+6/16,.125,0>,1/32}
  sphere {<.75+6/16,.125,0>,1/32}
}

#declare HHand=union {
  prism {
    linear_sweep
    linear_spline
    0,1/512,5,
    <-1/64,0>,<1/64,0>,
    <1/128,3/8>,<-1/128,3/8>,
    <-1/64,0>
  }
  cylinder {<0,0,0>,<0,1/512,0>,3/64}
}

#declare MHand=union {
  prism {
    linear_sweep
    linear_spline
    0,1/512,5,
    <-1/64,0>,<1/64,0>,
    <1/128,9/16>,<-1/128,9/16>,
    <-1/64,0>
  }
  cylinder {<0,0,0>,<0,1/512,0>,1/32}
}

#declare SHand=union {
  prism {
    linear_sweep
    linear_spline
    0,1/512,5,
    <-1/128,-1/8>,<1/128,-1/8>,
    <1/256,9/16>,<-1/256,9/16>,
    <-1/128,-1/8>
  }
  cylinder {<0,0,0>,<0,1/512,0>,1/64}
}

#declare Hands=difference {
  union {
    object {HHand translate y*13/64 rotate y*((30*Hour)+(.5*Min))}
    object {MHand translate y*7/32 rotate y*6*Min}
    object {SHand translate y*15/64 rotate y*6*Sec}
    cylinder {<0,3/16,0>,<0,1/4,0>,1/128}
  }
  cylinder {<0,0,0>,<0,1,0>,1/256}
  texture {T13}
}

#declare Gold_Orange=rgb <1,.875,.575>;

#declare Marker=cylinder {<0,3/16,7/16>,<0,3/16,19/32>,1/128 texture {T13}}

#declare Face=union {
  disc {<0,3/16+.0001,0>,<0,1,0>,.75-1/16 pigment {Gold_Orange} finish {reflection .15} normal {bumps .4 scale <.004,.004,30>}}
  object {Marker translate x*-1/128}
  object {Marker translate x*1/128}
  object {Marker rotate y*30}
  object {Marker rotate y*60}
  cylinder {<33/64,3/16,0>,<19/32,3/16,0>,1/128 texture {T13}}
  object {Marker rotate y*120}
  object {Marker rotate y*150}
  object {Marker rotate y*180}
  object {Marker rotate y*210}
  object {Marker rotate y*240}
  object {Marker rotate y*270}
  object {Marker rotate y*300}
  object {Marker rotate y*330}
  #declare Count=0;
  #while (Count<60)
    cylinder {<0,3/16,37/64>,<0,3/16,19/32>,1/512 pigment {Black} rotate y*Count*6}
    #declare Count=Count+1;
  #end
  text {ttf "c:\windows\fonts\delp.ttf" "Chronograph",.1,0
    rotate x*90
    translate x*-3.5
    scale 1/19
    translate <0,3/16+.001,1/4>
    pigment {Black}
  }
}

#declare CaseBottom=union {
  object {BottomLip}
  object {MiddleLip}
  object {UpperLip translate y*3/16}
  object {StemBox}
  object {StemKnob}
  object {StemPin}
  object {DRing}
  texture {T13}
}

#declare Watch=union {
  object {CaseBottom}
  object {Face}
  object {Hands}
  cylinder {<0,5/16,0>,<0,5/16-.01>,.75-3/16 texture {T_Glass3}}
}

//object {Watch}
