//      With Infinite Thanks and Appreciation to all the beings who have
//      created and refined POV-Ray!  It is an incredible lightbrush for
//      artists of the imaginary.


#global_settings { assumed_gamma 2.2 }
#global_settings { number_of_waves 1 }

#include "shapes.inc"
#include "shapes2.inc"
#include "MikeRock.inc"
#include "shapesq.inc"
#include "golds.inc"
#include "SSDFoL.inc"

// Other files used for image maps: glxyblue.gif   trees.gif   lyrica.gif

camera {
  location <2, 12, -58>
  right <4/3, 0, 0>
  up <0, 1, 0>
  sky <0, 1, 0>
  angle 37
  look_at <0, 8, 0> }


//$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$ 


light_source { <-20, 34.2, -50> color rgb <1, 1, 1> }           // ALURA'S MOON
light_source { <37000, -72360, 903120> color rgb <0.8, 1, 1> }  // ALURA'S SUN 


#declare HEAVENS = sphere{ <0, -100000, 0> 1000000  hollow
        pigment { image_map { gif "GlxyBlue.gif"
                map_type 0 interpolate 4 }
        scale <740000, 740000, 1>
        translate <319000, -246000, 0> }
        finish { ambient 0.921 } }

#declare WEZAN = sphere { <0, 0, 0>, 21415      // Another moon
        translate <112011, 77913, 903453>
        texture { pigment { marble turbulence 0.9  color_map {
                [0.2 color rgb <0.0858, 0.248576, 0.42439>]
                [0.8 color rgb <0.0458, 0.13776, 0.21239>]  }
                rotate <0, 0, -68> scale 7370 }  } 
        texture { pigment { wrinkles color_map {
                [0.4 color rgb <0.089, 0.683, 0.962> transmit 0.2 ]
                [0.6 color rgb <0.071, 0.41233, 0.751> transmit 0.35 ] } scale 5400  } }
                finish { ambient 0.02} }                       

#declare ALURA = difference {                   // The planet
        sphere { <0, -100000, 0> 100000
                pigment { gradient x color_map {
                        [0.2  color rgb <0.1, 0.43, 0.8> ]
                        [0.5  color rgb <0.3, 0.43, 0.7>]
                        [0.80  color rgb <0.1, 0.43, 0.8>] } scale <11, 7, 9> turbulence 0.7 } 
                finish { ambient .13 diffuse .6 reflection 0.65 }
                normal { waves 0.92 scale <10, 10, 10> translate <-300, 0, 500>
                         frequency 1 turbulence <0.91, 0.71, 1.2> } }
        cylinder { <0, 1, 0>, <0, -11, 0>, 12 
                pigment { color rgb <0.439, 0.859, 0.576> } 
                finish { ambient 0.87 } } }
                
#declare BULB = union {                 // Lights for bridge to city
        sphere { <0, 0, 0>, 1
                pigment { color rgb <1, 0.9, 0.8> }
                finish { ambient 1 } }
        sphere { <0, 0, 0>, 3
                pigment { color rgbf <1, 0.99, 0.96, 0.8> }
                finish { ambient 0.37 reflection 0.99} }               
        sphere { <0, 0, 0>, 5
                pigment { color rgbt <1, 1, 0.98, 0.99> }
                finish { ambient 0.9 reflection 0.68 } } no_shadow }
               
#declare LAMPS = union {
        object { BULB translate <0, 6, -100> }
        object { BULB translate <0, 6, -100> rotate <0, -18, 0> }
        object { BULB translate <0, 6, -100> rotate <0, -36, 0> }
        object { BULB translate <0, 6, -100> rotate <0, -54, 0> }
        object { BULB translate <0, 6, -100> rotate <0, -72, 0> }
        object { BULB translate <0, 6, -100> rotate <0, -90, 0> }
        object { BULB translate <0, 6, -100> rotate <0, 18, 0> }
        object { BULB translate <0, 6, -100> rotate <0, 36, 0> }
        object { BULB translate <0, 6, -100> rotate <0, 54, 0> }
        object { BULB translate <0, 6, -100> rotate <0, 90, 0> } }
        
#declare SECTION = union {
        object { BULB translate <1867, 6, 0> }
        object { BULB translate <1867, 6, 0> rotate <0, -2.3, 0>}
        object { BULB translate <1867, 6, 0> rotate <0, -4.6, 0>}
        object { BULB translate <1867, 6, 0> rotate <0, -6.9, 0>}
        object { BULB translate <1867, 6, 0> rotate <0, -9.2, 0>}
        object { BULB translate <1867, 6, 0> rotate <0, -11.5, 0>}
        object { BULB translate <1867, 6, 0> rotate <0, -13.8, 0>}
        object { BULB translate <1867, 6, 0> rotate <0, -16.1, 0>} }
        
#declare BRIDGE = union {               // Lights going out to Diaspar
        object { SECTION }
        object { SECTION rotate <0, -18.4, 0> }
        object { SECTION rotate <0, -36.8, 0> } 
                translate <-1527, 0, 0> }        

#declare TRIANGLE = prism { linear_sweep 0, -0.01, 4
                <-0.107, -0.062>, <0, 0.124>, <0.107, -0.062>, <-0.107, -0.062> }

#declare GOLDSTAR = union {             // Star of Davids for portal 
        difference {
                object { TRIANGLE }
                object { TRIANGLE scale <0.92, 2, 0.92> translate <0, 0.005, 0> } }
        difference {
                object { TRIANGLE rotate < 0, 180, 0> }                       
                object { TRIANGLE scale <0.92, 2, 0.92> rotate < 0, 180, 0> translate <0, 0.005, 0> }
                } rotate <-90, 0, 0> 
        texture { T_Gold_1A } }         

#declare POD = union {                  // Craft hovering near dome of Diaspar
        sphere { <-4, 2, 0>, 2 }
        sphere { <4, 2, 0>, 2 }
        cylinder { <-4, 2, 0>, <4, 2, 0>, 2 }
        cylinder { <-4.2, 2, 0>, <-3.8, 2, 0>, 2.8 }
        cylinder { <4.2, 2, 0>, <3.8, 2, 0>, 2.8 } hollow
        translate <0, 0, 0>
                pigment { color rgbf <0.97, 0.732, 0.012, 0.837> }
                finish { diffuse 0.12 ambient 0.37 reflection 0.67 specular 0.3 roughness 0.002 } }

#declare WINDOW = difference {
        cylinder { <0, 0, -61.5>, <0, 0, 61.5>, 1.0
                scale <1, 5, 1> translate <0, -6, 0> }
        plane { y, -6 } }                               

#declare WINDOWS = union {              // Windows for distant city, Diaspar
        object { WINDOW }
        object { WINDOW rotate <0, 15, 0> }
        object { WINDOW rotate <0, 30, 0> }
        object { WINDOW rotate <0, 45, 0> }                                           
        object { WINDOW rotate <0, 60, 0> }
        object { WINDOW rotate <0, 75, 0> }
        object { WINDOW rotate <0, 90, 0> }
        object { WINDOW rotate <0, 105, 0> }
        object { WINDOW rotate <0, 120, 0> }
        object { WINDOW rotate <0, 135, 0> }
        object { WINDOW rotate <0, 150, 0> }
        object { WINDOW rotate <0, 165, 0> }
        object { WINDOW rotate <0, 180, 0> } }

#declare WINDOWS2 = object { WINDOWS
        pigment { color rgb <0.85, 0.85, 0.10> }
        finish { ambient 0.98 } }        

#declare DIASPAR = union {              // Put camera at <-290, 500, 1270> and look at 
        sphere { <0, 0, 0>, 47          // <0, -100000, 0> for bird's eye view of Diaspar.
                texture { hexagon       // Named after a city in an Arthur C. Clarke novel.
                texture { T_Gold_1A },
                texture { T_Gold_4B },
                texture { T_Brass_5D } } scale <1.3, 1, 1.3> }  //2b
        cylinder { <0, 0, 0>, <0, 3, 0>, 47.7
                texture { T_Brass_4D } scale <1.3, 1, 1.3> }
        object { WINDOWS }
        object { POD scale <2, 2, 2> rotate <0, 32, 0> translate <119.37, 17.91, -32.32> }
        object { LAMPS }
        object { LAMPS rotate <0, -180, 0> } 
        cylinder { <0, -6, 0>, <0, -12, 0>, 123 
                texture { PinkStone
                finish { ambient 0.56 } } }
        cylinder { <0, -5.9, 0>, <0, -6, 0>, 67 
                pigment { color rgb <1, 1, 1> } 
                finish { ambient 0.67 } }               
        sphere { <-40, 0, 0>, 7
                texture { T_Gold_2C } scale <1, 13, 1> }
        sphere { <0, 0, 0>, 14
                texture { T_Gold_4A } scale <1.3, 1, 1.3> translate <-67.6, 0, 0> }
        object { WINDOWS2 scale <0.296, 0.36, 0.296> translate <-67.6, -0.6, 0> }                
        sphere { <-97, 0, 28>, 11
                texture { T_Gold_2A } scale <1, 3.7, 1> }
        object { WINDOWS2 scale <0.18, 0.7, 0.18> translate <-97, 8, 28> }
        object { WINDOWS2 scale <0.17, 0.6, 0.17> translate <-97, 16, 28> }
        object { WINDOWS2 scale <0.15, 0.5, 0.15> translate <-97, 24, 28> }                       
        object { Icosahedron
                texture { T_Silver_2C } rotate <0, -23, 0> scale <17, 17, 17> translate <-74, 9, 13> }
                translate <0, 100000, 0> rotate <0.72, 0, 0.17> translate <0, -99993, 0> }
     
#declare TREE = box { <0, 0, 0>, <1, 1, 0.1> hollow
        pigment { image_map { gif "trees.gif" filter 1, 1.0 } }
        scale <25, 25, 0.001> translate <-27, 0, -35>
        finish { ambient 0.4 } }         

#declare LYRICA = union {
        polygon { 5, <0, 0> <0, 6.5> <2, 6.5> <2, 0> <0, 0>
                pigment { image_map { gif "lyrica.gif" once transmit 193, 1.0 }
                scale <1.8068, 6.5, 1> } 
                finish { ambient 0.4 } }
        object { BULB scale 0.087 translate <0.91, 4.46, 0.1>
        finish { ambient 1 } }  // <0.91, 4.12, 0.1>
        translate <-16, 0.16, -1.74>}
                
// Pool begins here                
    
#declare POOL = cylinder { <0, 0.4, 0>, <0, -11, 0>, 12 
                        pigment  { cylindrical color_map {
                                   [0.01  color rgbf <0.013, 0.22, 0.49, 0.28> ]
                                   [0.5  color rgbf <0.13, 0.74, 0.56, 0.48> ]
                                   [0.7  color rgbf <0.013, 0.82, 0.79, 0.78> ] } //0.43, 0.86, 0.749, 0.87> 
                                   scale <12, 1, 12> turbulence 0.243 } 
                        finish   { ambient 0.34 diffuse 0.13 reflection 0.532   // .14 .3 .32
                                   specular 0.43 roughness 0.0034 }
                        interior { ior 1.33 } 
                        normal   { ripples 0.0115 scale <1, 1, 1>  //0.15 scale <1.33, 1.75, 1.42>
                                   frequency 1.1 turbulence <0.031, 0.31, 0.31> } }  //frequency 3.71 turbulence <0.104, 0.104, 0.104>
                                   
#declare AETHER = texture {
        gradient y texture_map {
                [0.41 pigment { color  rgbf <0.013, 0.82, 0.79, 0.38> }       //Bottom 
                        finish { ambient 0.34 diffuse 0.13 reflection 0.532 specular 0.43 roughness 0.0034 } 
                        normal { ripples 0.92 scale <1, 1, 1> frequency 5 turbulence 1 } ]
                [0.87 pigment { color rgbf <0.913, 0.62, 0.089, 0.98> }
                        finish { reflection 0.658 specular 0.34 roughness 0.0002 }
                        normal { ripples 0.713 scale <1, 1, 1> frequency 5 turbulence 20 } ]
                [0.93 pigment { color rgbt <1, 1, 1, 1> }               //Top
                        finish { reflection 0 ambient 0 }  
                        normal { ripples 0.03 scale <1, 12, 1> frequency 5 turbulence <10, 100, 10> } ] } }

#declare ASCENDER = difference {
        merge {
                cylinder { <0, 6.1, 0>, <0, 1.5, 0>, 0.9 open }
                cylinder { <0, 1.75, 0>, <0, 0.4, 0>, 1.8 open } }
                torus { 1.8, 0.9 scale <1, 1.5, 1> translate <0, 1.75, 0> } no_shadow 
                        texture { AETHER scale <1, 5.71, 1> translate <0, 0.4, 0> }  }
                        
#declare EGG = 
        sphere { <0, 0, 0>, 0.899 no_shadow
                pigment { color rgbf <0.993, 0.768, 0.063, 0.887> }
                finish { ambient 0.7527 diffuse 0.33 reflection 0.78 specular 0.64 roughness 0.002 }
                interior { ior -3.33 }
                scale <1, 1.3, 1> translate <0, 6, 0> }

#declare YOLK = sphere { <0, 5.5, 0.4>, 0.2
        pigment { color rgb <0.8, 0.498, 0.196> } finish { ambient 0.3 reflection 0.97} }                                                            
                
#declare RIM = lathe { bezier_spline 16,
                        <12, 0.2> <12.5, 0.2> <13.5, 0.2> <14, 0.2>
                        <14, 0.2> <13.9, 0.7> <12.6, 0.4> <12.5, 0.8>
                        <12.5, 0.8> <12.3, 0.8> <12.2, 0.8> <12.0, 0.8>
                        <12.0, 0.8> <12.0, 0.6> <12.0, 0.5> <12.0, 0.2>
                texture { MilkyWay scale <0.3, 0.3, 0.3>}
                finish { ambient 0.2 } }                

#declare TRIM = difference {
        cylinder { <0, 0.81, 0>, <0, 0.7, 0>, 12.3 }
        cylinder { <0, 0.82, 0>, <0, 0.6, 0>, 12.2 }
                texture { T_Gold_1A } }
                
#declare FOUNTAIN = union {
        object { RIM }
        object { TRIM } }                

#declare STEPSTONES = union {
        cylinder { <0, 0.5, -9>, <0, -4, -9>, 0.8 }
        cylinder { <0, 0.5, -6.5>, <0, -4, -6.5>, 0.8 }                
        cylinder { <0, 0.5, -4>, <0, -4, -4>, 0.8 } 
        object { GOLDSTAR rotate <90, 0, 0> scale 5 translate <0, 0.501, -9> }
        object { GOLDSTAR rotate <90, 0, 0> scale 5 translate <0, 0.501, -6.5> }
        object { GOLDSTAR rotate <90, 0, 0> scale 5 translate <0, 0.501, -4> }
                texture { PinkStone }
                finish { ambient 0.23 } }

#declare STEPS = difference {
        union {
                cylinder { <0, 0.8, 0>, <0, 0, 0>, 13 }
                cylinder { <0, 0.6, 0>, <0, 0, 0>, 14 }                
                cylinder { <0, 0.4, 0>, <0, 0, 0>, 15 } }
        cylinder { <0, 1, 0>, <0, -1, 0>, 12 }
        plane { -x, 0 rotate <0, -7, 0> }
        plane { x, 0 rotate <0, 7, 0> } 
        texture { PinkStone scale 3.7 }
        finish { ambient 0.27 } }       
        
#declare RAIL1 = difference {
        object { RIM translate <0, -0.2, 12> scale <1.8, 3, 1.8> translate <0, 0.1, -12> }
        plane { -x, 0 rotate <0, -9, 0> }
        plane { x, 0 rotate <0, -7, 0> } 
        texture { PinkStone scale 3.7 }
        finish { ambient 0.2 } }

#declare RAIL2 = difference {
        object { RIM translate <0, -0.2, 12> scale <1.8, 3, 1.8> translate <0, 0.1, -12> }
        plane { x, 0 rotate <0, 9, 0> }
        plane { -x, 0 rotate <0, 7, 0> } 
        texture { PinkStone scale 3.7 }
        finish { ambient 0.2 } }       

#declare STILE = union {                // The stairs into the starpool
        object { STEPS }
        object { RAIL1 }
        object { RAIL2 }
        sphere { <0, 2.2, -12.4>, 0.3
                rotate <0, 8, 0>
                texture { Crystal }
                interior { ior 1.45 } }
        sphere { <0, 2.2, -12.4>, 0.3
                rotate <0, -8, 0>
                texture { Crystal } 
                interior { ior 1.45 } } }               
        
// Tiles begin here.

#declare RHOMB1 =
prism { linear_spline linear_sweep 0.2, -0.2, 5,
        <-14.109, -0.058>, <-9.534, -0.059>, <-7.25, -4.019>, <-11.206, -2.959>, <-14.109, -0.058>
        texture { GreenStone scale <2, 2, 2>
        finish { ambient 0.37 } } }

#declare RHOMB2 =
prism { linear_spline linear_sweep 0.2, -0.2, 5,
        <-11.236, -3.074>, <-7.280, -4.135>, <-11.238, -6.422>, <-15.201, -4.135>, <-11.236, -3.074>
        texture { BlueStone scale <2, 2, 2>
        finish { ambient 0.37 } } }

#declare RHOMB3 =
prism { linear_spline linear_sweep 0.2, -0.2, 5,
        <-15.263, -4.232>, <-11.301, -6.520>, <-11.303, -11.092>, <-14.200, -8.196>, <-15.263, -4.232>
        texture { GreenStone scale <2, 2, 2>
        finish { ambient 0.37 } } }               
        
#declare TRIROM = union {
        object { RHOMB1 }
        object { RHOMB2 }
        object { RHOMB3 } }

#declare RHOMB_PAIR = union {
        object { TRIROM }
        object { TRIROM rotate <180, 0, 0> } translate <22.5, 0, 0> }
        
#declare STAR_RIM = difference {
        union {
                object {RHOMB_PAIR }        
                object {RHOMB_PAIR rotate <0, 90, 0> }
                object {RHOMB_PAIR rotate <0, 180, 0> }
                object {RHOMB_PAIR rotate <0, 270, 0> } }
        cylinder { <0, 1, 0>, <0, -1, 0>, 9.99 } }

#declare STARPOINT = 
        prism { linear_sweep 0.2, -0.2, 5,
        <0.13, 0>, <2.9, -1.6>, <5.67, 0>, <2.9, 1.6>, <0.13, 0>
         texture { LavenderStone scale <3, 3, 3> } }
         
#declare STAR = union {
        object { STARPOINT } 
        object { STARPOINT rotate <0, 60, 0> } 
        object { STARPOINT rotate <0, 120, 0> } 
        object { STARPOINT rotate <0, 180, 0> } 
        object { STARPOINT rotate <0, 240, 0> } 
        object { STARPOINT rotate <0, 300, 0> } 
                translate <22.5, 0, 0> } 
#declare HEXB = 
        prism { linear_sweep 0.2, -0.2, 5,
        <3.00, -1.664>, <7.105, -4.036>, <9.395, -0.059>, <5.780, -0.061>, <3.00, -1.664>
        texture { GreenStone scale <1, 1, 1> } finish { ambient 0.4 } }
        
#declare HEXT = 
        prism { linear_sweep 0.2, -0.2, 5,
        <3.00, 1.664>, <7.105, 4.036>, <9.395, 0.059>, <5.780, 0.061>, <3.00, 1.664>
        texture { BlueStone scale <3, 3, 3> } }       

#declare HEXPAIR = union {
        object { HEXB }
        object { HEXT } }
        
#declare HEX = union {
        object { HEXPAIR }        
        object { HEXPAIR rotate <0, 60, 0> }
        object { HEXPAIR rotate <0, 120, 0> }
        object { HEXPAIR rotate <0, 180, 0> }
        object { HEXPAIR rotate <0, 240, 0> }
        object { HEXPAIR rotate <0, 300, 0> } 
                translate <22.5, 0, 0> }

#declare RHOMBA = prism { linear_sweep 0.2, -0.2, 5,
        <-7.148, -4.191>, <-4.814, -8.232>, <-5.641, -9.648>, <-11.121, -6.490>, <-7.148, -4.191>
                texture { PurpleStone scale <1, 1, 1> } 
                finish { ambient 0.1 } }
#declare RHOMBB = prism { linear_sweep 0.2, -0.2, 5,
        <-4.722, -8.288>, <-0.057, -8.288>, <-0.061, -12.877>, <-5.536, -9.710>, <-4.722, -8.288>
                texture { PurpleStone scale <1, 1, 1> } 
                finish { ambient 0.5 } }
#declare RHOMBC = prism { linear_sweep 0.2, -0.2, 5,
        <-5.594, -9.812>, <-0.114, -12.970>, <-4.087, -15.268>, <-6.418, -11.228>, <-5.594, -9.812>
                texture { PurpleStone scale <1, 1, 1> } 
                finish { ambient 0.1 } }       
#declare RHOMBD = prism { linear_sweep 0.2, -0.2, 5,
        <-11.176, -6.589>, <-5.700, -9.756>, <-6.515, -11.178>, <-11.180, -11.179>, <-11.176, -6.589>
                texture { PurpleStone scale <1, 1, 1> } 
                finish { ambient 0.5 } }

#declare QUADROM = union {
        object { RHOMBA }
        object { RHOMBB }
        object { RHOMBC }
        object { RHOMBD } translate <22.5, 0, 0> }

#declare STARHEX = union {
        object { STAR }
        object { HEX }
        object { QUADROM }
        object { SSD scale <1.37, 1.37, 1.37> rotate <0, 27, 0> translate <22.5, 3.37, 0> } }

#declare STARHEXES = union {
        object { STARHEX rotate <0, 0, 0> }
        object { STARHEX rotate <0, 60, 0> }
        object { STARHEX rotate <0, 120, 0> }
        object { STARHEX rotate <0, 180, 0> }
        object { STARHEX rotate <0, 240, 0> }
        object { STARHEX rotate <0, 300, 0> } }

#declare TILES = union {
        object { STAR_RIM }
        object { STARHEXES }
        scale <1.2, 1, 1.2> }

#declare FOIL = difference {
        cylinder { <0, 0.199, 0>, <0, 0, 0>, 32.5 }
        cylinder { <0, 1, 0>, <0, -1, 0>, 12.6 }
                texture { T_Gold_4A }
                finish { ambient 0.6 } }                        

#declare WALL = prism { linear_sweep 0.32, -2.2, 15,
        <-4.087, -15.267>, <-0.060, -12.938>, <-0.060, -8.166>, <4.715, -8.166>,
        <9.417, 0.000>, <4.715, 8.166>, <-0.048, 8.166>, <-0.048, 9.065>,
        <5.228, 9.065>, <10.470, 0.000>, <5.228, -9.065>, <0.836, -9.065>,
        <0.836, -13.453>, <-3.645, -16.044>, <-4.087, -15.267>
                texture { pigment {
                        crackle turbulence 0.25
                        color_map {
                                [0 rgb <0.9, 0.75, 0.75>]
                                [1 rgb <0.6, 0.6,  0.6 >] } scale 0.4 }
                        finish { ambient 0.25 } }
                        translate <22.5, 0, 0> scale <1.2, 1, 1.2> rotate <0, -60, 0> }

#declare EDGE = union {
        object { WALL }
        object { WALL rotate <0, -60, 0> }
        object { WALL rotate <0, -120, 0> } }

// Flames begin here        
 
#declare ATMOSFLAME = difference {
        object  { Lemniscate  no_shadow  }
        plane { x 0 }
        plane { x 0.992 inverse }       // To clip anomaly at tip of lemniscate.       
        pigment { color rgbf <0.03, 0.72, 0.87, 0.98> }
        finish { ambient 0.3 diffuse 0.34 reflection 0.78 specular 0.45 roughness 0.0035}
        rotate <0, 0, -90> scale <0.32, 1, 0.32>
        bounded_by { box { <-0.35, -1, -0.35>, <0.35, 0, 0.35> } } }

#declare BASE = difference {
        sphere { <0, 0, 0>, 0.75
                scale <0.26, 1, 0.26> translate <0, -1.6, 0> }
        sphere { <0, -0.85, 0>, 0.2 pigment { color rgb <0, 0, 1> } }
        cylinder { <0, 0, -0.23>, <0, -3, -0.23>, 0.072 }
        cylinder { <0, 0, -0.23>, <0, -3, -0.23>, 0.072 rotate <0, 60, 0> }
        cylinder { <0, 0, -0.23>, <0, -3, -0.23>, 0.072 rotate <0, 120, 0> }
        cylinder { <0, 0, -0.23>, <0, -3, -0.23>, 0.072 rotate <0, 180, 0> }
        cylinder { <0, 0, -0.23>, <0, -3, -0.23>, 0.072 rotate <0, 240, 0> }
        cylinder { <0, 0, -0.23>, <0, -3, -0.23>, 0.072 rotate <0, 300, 0> }
        cylinder { <0, 0, 0>, <0, -2, 0>, 0.037 pigment { color rgb <0, 0, 1> } }
        cylinder { <0, -1.06, 0>, <0, -1.08, 0>, 0.7 } 
        texture { LavenderStone } }
       
#declare COLUMN = intersection {
        cylinder { <0, -1.9, 0>, <0, -4, 0>, 0.35 }
        cone { <0, -1.4, 0>, 0 <0, -2.1, 0>, 0.46 }
        texture { MilkyWay scale <0.3, 0.3, 0.3> } }

#declare FLAME = union {
        object { ATMOSFLAME }
        object { ATMOSFLAME scale <0.68, 0.6, 0.68> translate <0, -0.36, 0> 
                pigment { color rgb <0, 0.1, 1> } 
                finish { ambient 0.978 } }
        object { BASE }
        object { COLUMN }
        cylinder { <0, -1.88, 0>, <0, -4, 0>, 0.27 
        texture { T_Gold_1B scale <0.3, 0.3, 0.3> } }
        translate <0, 2, 0> scale <1.8, 1.6, 1.8> translate <0, 0.8, 12.25>}

#declare FLAMES = union {
        object { FLAME }
        object { FLAME rotate <0, 51.42857, 0> }
        object { FLAME rotate <0, 102.85714, 0> } 
        object { FLAME rotate <0, 154.28571, 0> }
        object { FLAME rotate <0, 205.71428, 0> } 
        object { FLAME rotate <0, 257.14285, 0> }
        object { FLAME rotate <0, 308.57142, 0> } }

// Portal begins here               
                 
#declare FRAMEOUT = merge {
        box { <-4.1, 0, 0>, <4.1, 14.1, 0.1> }
        cylinder { <0, 14.1, 0>, <0, 14.1, 0.1>, 4.1 }
        cylinder { <0, 17.4, 0>, <0, 17.4, 0.1>, 3.0 } }
        
#declare FRAMEIN = merge {
        box { <-3.8, -0.01, -1>, <3.8, 14.1, 1> }
        cylinder { <0, 14.1, -1>, <0, 14.1, 1>, 3.8 }
        cylinder { <0, 17.4, -1>, <0, 17.4, 1>, 2.7 } } 
       
#declare LINTELOUT = merge {
        box { <-2.9, -0.02, 0>, <2.9, 12.72, 0.1> }
        intersection {
                cylinder { <3.5, 12.72, 0>, <3.5, 12.72, 0.1>, 6.4 }
                cylinder { <-3.5, 12.72, 0>, <-3.5, 12.72, 0.101>, 6.4 } } }
        
#declare LINTELIN = merge {
        box { <-2.7, -0.03, -0.01>, <2.7, 12.72, 0.11> }
        intersection {
                cylinder { <3.5, 12.72, -0.01>, <3.5, 12.72, 0.11>, 6.2 }
                cylinder { <-3.5, 12.72, -0.011>, <-3.5, 12.72, 0.111>, 6.2 } } }

#declare VESOUT = intersection {
        cylinder { <2.2, 20.2, 0>, <2.2, 20.2, 0.1>, 3.2 }
        cylinder { <-2.2, 20.2, -1>, <-2.2, 20.2, 1>, 3.2 } }
        
#declare VESIN = intersection {
        cylinder { <2.2, 20.2, -1>, <2.2, 20.2, 1>, 3.0 }
        cylinder { <-2.2, 20.2, -2>, <-2.2, 20.2, 2>, 3.0 } }                       
        
#declare VESICA = difference {
        object { VESOUT }
        object { VESIN } 
                scale <1, 1, 1> 
                texture { T_Gold_4A }
                finish { ambient 0.12 diffuse 0.34 reflection 0.74 } }

#declare ROUND1 = difference {
        cylinder { <0, 18, 0>, <0, 18, 0.1>, 1.22 }
        cylinder { <0, 18, -1>, <0, 18, 1>, 1.15 }
        object { LINTELIN }
        scale <1, 1, 1> 
                pigment { color rgb <1.0, 0.43, 0.78> }
                finish { ambient 0.172 diffuse 0.34 reflection 0.74 } } 
             
#declare ROUND2 = difference {
        cylinder { <0, 18.54, 0>, <0, 18.54, 0.1>, 1.7 }
        cylinder { <0, 18.54, -1>, <0, 18.54, 1>, 1.6 }
        object { LINTELIN }
        scale <1, 1, 1> 
                pigment { color rgb <1.0, 0.43, 0.78> }
                finish { ambient 0.172 diffuse 0.34 reflection 0.74 } }  

#declare ROUND3 = difference {
        cylinder { <0, 17.4, 0>, <0, 17.4, 0.1>, 2.8 }
        cylinder { <0, 17.4, -1>, <0, 17.4, 1>, 2.7 }
        object { LINTELIN }
        scale <1, 1, 1> 
                pigment { color rgb <1.0, 0.43, 0.78> }
                finish { ambient 0.172 diffuse 0.34 reflection 0.74 } }

#declare ROUND4 = difference {
        cylinder { <0, 14.1, 0>, <0, 14.1, 0.1>, 3.9 }
        cylinder { <0, 14.1, -1>, <0, 14.1, 1>, 3.8 }
        box { <-4.1, 0, -1>, <4.1, 14.1, 1> }
                scale <1, 1, 1> 
                pigment { color rgb <1.0, 0.43, 0.78> }
                finish { ambient 0.172 diffuse 0.34 reflection 0.74 } }                
        
#declare LINTEL = difference {          // Inside frame of portal
        object { LINTELOUT }
        object { LINTELIN }
                scale <1, 1, 1> 
                pigment { color rgb <1.0, 0.43, 0.78> }
                finish { ambient 0.172 diffuse 0.34 reflection 0.74 } }
        
#declare FRAME = difference {           // Outside frame of portal
        object { FRAMEOUT }
        object { FRAMEIN }
                scale <1, 1, 1> 
        pigment { color rgb <1.0, 0.43, 0.78> }
        finish { ambient 0.172 diffuse 0.34 reflection 0.74 } }

#declare PORTAL = merge {               // Doorway to other worlds and times
        object { FRAME }
        object { LINTEL }
        object { VESICA }
        object { ROUND1 }
        object { ROUND2 }
        object { ROUND3 }
        object { ROUND4 } 
        no_shadow scale <0.92, 0.92, 0.92> }
        
#declare PANES = intersection {         // Stained-glass-like panes in portal
        difference {
                object { FRAMEIN }
                object { LINTELOUT }
                object { VESOUT } }       
        box { <-4.1, 0, 0.03>, <4.1, 22, 0.07> } 
        pigment { wood color_map {
                [0.05 color rgb <0.91764, 0.67843, 0.91764> ]
                [0.13 color rgb <1.0, 0.43, 0.78> ]
                [0.5 color rgb <0.99, 0.97, 0> ]
                [0.9 color rgb <0.98, 0.52, 0> ] } scale <37.168, 37.168, 1> translate <0, 18.584, 0> } 
        finish { diffuse 0.3 reflection 0.314 ambient 0.48 } 
        normal { bumps 5 rotate <25, 0, 0>  scale <0.1, 0.01, 0.1> }
        no_shadow scale <0.92, 0.92, 0.92> }

#declare VES = intersection {           // Seed shape at top of portal
        object { VESIN }
        box { <-2, 16, 0.03>, <2, 23, 0.07> } 
        pigment { wood color_map {
                [0.02 color rgb <1, 1, 1> ]
                [0.68 color rgb <0.852, 0.853, 0.10> ]
                [0.98 color rgb <0.99, 0.42, 0.01> ] }
                scale <1.84, 3.98, 1> translate <0, 20.2, 0> }
        finish { diffuse 0.3 reflection 0.14 ambient 0.58 }
        no_shadow scale <0.92, 0.92, 0.92> }

#declare PENTASTAR = prism { 0, -0.01, 11,  // A five-pointed star
        <0, 0.142>, <0.037, 0.032>, <0.137, 0.032>, <0.057, -0.025>,
        <0.088, -0.123>, <0.0, -0.066>, <-0.088, -0.123>, <-0.057, -0.025>,
        <-0.137, 0.032>, <-0.037, 0.032>, <0, 0.142>
                texture { T_Gold_1A } scale <0.86, 0.86, 0.86> rotate <-90, 0, 0> }

#declare STARROUND = union {            // Decorative stars around top of portal
        object { PENTASTAR translate <0, 2.622, 0> rotate <0, 0, 0> }
        object { PENTASTAR translate <0, 2.622, 0> rotate <0, 0, 11> } 
        object { PENTASTAR translate <0, 2.622, 0> rotate <0, 0, 22> }
        object { PENTASTAR translate <0, 2.622, 0> rotate <0, 0, 33> }
        object { PENTASTAR translate <0, 2.622, 0> rotate <0, 0, 44> }
        object { PENTASTAR translate <0, 2.622, 0> rotate <0, 0, 55> }
        object { PENTASTAR translate <0, 2.622, 0> rotate <0, 0, 66> }
        object { PENTASTAR translate <0, 2.622, 0> rotate <0, 0, 77> }
        object { PENTASTAR translate <0, 2.622, 0> rotate <0, 0, 88> }
        object { PENTASTAR translate <0, 2.622, 0> rotate <0, 0, -11> } 
        object { PENTASTAR translate <0, 2.622, 0> rotate <0, 0, -22> }
        object { PENTASTAR translate <0, 2.622, 0> rotate <0, 0, -33> }
        object { PENTASTAR translate <0, 2.622, 0> rotate <0, 0, -44> }
        object { PENTASTAR translate <0, 2.622, 0> rotate <0, 0, -55> }
        object { PENTASTAR translate <0, 2.622, 0> rotate <0, 0, -66> }
        object { PENTASTAR translate <0, 2.622, 0> rotate <0, 0, -77> }
        object { PENTASTAR translate <0, 2.622, 0> rotate <0, 0, -88> }
        translate <0, 16.008, -0.001> }        
                
#declare OTHERWORLD = difference {              // The space inside the portal
        object { LINTELIN no_shadow
                scale <0.92, 0.92, 0.92>
                pigment { wood color_map 
                      { [0.035 color rgb <1, 1, 1> transmit 0.6]
                        [0.4 color rgb <1, 1, 0> transmit 0.80]
                        [0.9 color rgb <0.98, 0.48, 0> transmit 0.93] } scale <13.3, 17.3, 13.3> translate <0, 6, 0> } // 11, 14.3, 11
                finish { ambient 1 } }
        cylinder { <0, 0.401, 0>, <0, -1, 0>, 1.8 }                
        object { ASCENDER }
        object { EGG } }                           

// Render here $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

object { HEAVENS }      // The night sky of a planet of a star in the Whirlpool Galaxy
object { WEZAN }        // The moon in the heavens
object { ALURA }        // The planet where the Starpool is
object { DIASPAR }      // The small city in the distance
object { BRIDGE }       // Row of lights leading to the city
object { TREE }         // Tree
object { LYRICA }       // Girl holding the globe of light
object { FOUNTAIN }     // Rim of the Starpool
object { TILES }        // Pattern of flagstones on the ground
object { FOIL }         // Gold trim between the flagstones
object { EDGE }         // Low wall at the edge of the flagstones
object { POOL }         // Spatiotemporal liquid in the Starpool         
object { ASCENDER }     // Rising column of liquid     
object { EGG }          // Capsule being teleported to another galaxy
object { YOLK }         // Being within the capsule
object { STILE }        // Steps leading into the pool
object { STEPSTONES }   // Steppingstones to the portal
object { FLAMES }       // Five Blue temporal field generators on edges of Starpool
object { PORTAL }       // Gateway arch to other spacetime coordinates
object { PANES }        // Decorative glass panes in the portal
object { VES }          // Seed shape at top of portal
object { STARROUND }    // Decorative gold star shapes set in top of portal
object { OTHERWORLD }   // Energy field from another galaxy, surrounding the egg

