// TERMINAL.POV      28/1/99 ( POVRAY 3.01 includes HALO )    I & E MacKay

#include "colors.inc"

background { color rgb < 0.4, 0.4, 0.8 > }  

light_source { < -35, 12, -20 > color rgb < 0.6, 0.4, 0 > }  // sky light (1)
light_source { < -13, 4.1, -10 > color White }         // Lounge light   (2)

light_source { < -10, 3, 17 > color Red              // back fill   (3)
                spotlight point_at < -10, 2, 10 > 
                tightness 0
                radius 40
                falloff 60
                }                              

light_source { < -10, 3, 17 > color Red              // back fill   (3A)
                spotlight point_at < -5, 1, 20 > 
                tightness 0
                radius 40
                falloff 60
                }                              
light_source { < 13, 3.45, -45 > 
                color rgb < 0.13, 0.1, 0.2 >            // front fill   (3B)
                spotlight point_at < 14, 0, -42.5 > 
                tightness 0
                radius 40
                falloff 80
                }                              
                

light_source { < 11, 0.72, -24.75 > color rgb < 1, 1, 0.2 > // truck left (4)
                spotlight point_at < 9.8, -3, -31 > 
                tightness 0
                radius 30
                falloff 50
                }                              
light_source { < 10.2, 0.72, -24.5 > color rgb < 1, 1, 0.2 > // truck right(5)
                spotlight point_at < 8.8, -3, -30.8 > 
                tightness 0
                radius 30
                falloff 50
                }                              
#declare Haze =                                  // around Headlights 
sphere { 0, 1                                     // HALO
         pigment { rgbt < 1, 1, 1, 1 > }
         halo {
              emitting
              spherical_mapping
              linear
              color_map {
                        [ 0.0 color rgbt < 1, 1, 1, 1 > ]
                        [ 1.0 color rgbt < 1, 1, 0, 0 > ]
                        }
              samples 10
              scale 0.5
               }
               hollow  
        }
object { Haze translate < 10.2, 0.72, -24.5 > }
object { Haze translate < 11, 0.72, -24.75 > }    
                
light_source { < -4.5, 6.6, -17 > color White            // spot   (6)
                looks_like {
                sphere { < 0, 0, 0 >,0.05
                         pigment { color rgb < 0.2, 1, 1 > }
                         finish { ambient 0.5  diffuse 0 }        
                       }  
                        }
                spotlight point_at < -8, 0, -15 > 
                tightness 0
                radius 50
                falloff 90
                }                              
light_source { < 18, 4, -40 > color Gray30            // spot   (7)
                spotlight point_at < 12, 0, -20 >  //19
                tightness 0
                radius 4
                falloff 10
                }                              
                
// CAMERA           
camera {
        location < 15, 0.5, -45 >
                 //  < 30, 15, -10 >
        look_at < -6, 8, 0 >
                //  < -10, 4, -10 >
        angle 50
        }

// SKY

sphere { < 0, 0, 0 >,1                 // SKY
           pigment {
                   gradient y
                   color_map {
                            [ 0.0 color rgb < 0.2, 0.02, 0.02 > ]
                            [ 0.25 color rgb < 0.5, 0.1, 0.4 > ]
                            [ 1.0 color rgb < 0.6, 0.2, 0.6 > ]
                             }
                    }
           finish { ambient 0.1 }
           scale 1000
           hollow
      }
#declare Clowd =
            union {
plane { y, 20.01           // TOP of CLOUD

           pigment { 
                   wrinkles   
                   color_map {
                              [ 0.0 color Clear ]  
                              [ 0.35 color Clear ]  
                              [ 0.65 color rgbt < 0.8, 0.4, 0.4, 0.5 > ]  
                              [ 0.7 color rgbt < 0.8, 0.4, 0.4, 0.5 > ]
                              [ 1.0 color Clear ] 
                              }
                    scale  20
                      }
           finish { ambient 0.5 }
           
           hollow
      }
plane { y, 20           // CLOUD  BODY

           pigment { 
                   wrinkles   
                   color_map {
                              [ 0.0 color Clear ]   
                              [ 0.35 color Clear ]  
                              [ 0.65color rgbt < 0.8, 0.4, 0.4, 0.5 > ]  
                              [ 0.7 color rgbt < 0.8, 0.4, 0.4, 0.5 > ]
                              [ 1.0 color Clear ] 
                              }
                    scale 20 
                    }
           finish { ambient 0.2 }
           
           hollow
      }
                   }
object { Clowd  rotate 15*y }

                           // ********

plane { y, 0  
        pigment {                     // PAVEMENT
                  bozo
                  turbulence 0.8
                  color_map {
                            [ 0.0 color Gray75 ]
                            [ 0.3 color Gray95 ]
                            [ 0.6 color Gray75 ]
                            [ 1.0 color Gray95 ]
                            }
                  scale 2
                }
        normal { bumps scale 0.0025 }
        finish { ambient 0.1 }
        rotate 45*y
        hollow
      }
plane { y, 0.001                            // wet surface
        clipped_by {
                   cylinder { < 35, -1, 0 >,< 35, 1, 0 >,43 }
                   }
        pigment { color rgbt < 1, 1, 1, 0.95 > } 
        normal { bumps 0.3 scale 0.5 }
        finish { reflection 0.5 }
        hollow
      }
                      // TERMINAL BUILDING
#declare Facd =                               // PUBLIC LOUNGE
           union {
              plane { x, -0.05  
                 pigment { color rgbt < 0.8, 0.8, 1, 0.6 > }
                 finish { ambient 0.2 
                          reflection 0.3
                          phong 1 }
                 clipped_by {
                   box { < -1, 4, -2.3 >,< 0, 6, 2.3 > }
                            }
                    }
               cylinder { < -0.05, 4, -2.3 >,< -0.05, 6, -2.3 >,0.05 }
               cylinder { < -0.05, 4, -2.3 >,< -0.05, 4, 2.3 >,0.05 }  
               cylinder { < -0.05, 6, -2.3 >,< -0.05, 6, 2.3 >,0.05 }  
                    pigment { color Gray60 }
                    finish { ambient 0.2 }
                    translate -45*x
                    hollow
                  }
#declare Lounge =
              union {
                     object { Facd }
                     object { Facd rotate 6*y }
                     object { Facd rotate 12*y } 
                     object { Facd rotate 18*y } 
                     object { Facd rotate 24*y } 
                     object { Facd rotate 30*y } 
                     object { Facd rotate 36*y } 
                     object { Facd rotate 42*y } 
                     object { Facd rotate 48*y } 
                     object { Facd rotate 54*y } 
                     object { Facd rotate -6*y }
                     object { Facd rotate -12*y } 
                     object { Facd rotate -18*y } 
                     object { Facd rotate -24*y } 
                     object { Facd rotate -30*y } 
                     object { Facd rotate -36*y } 
                     object { Facd rotate -42*y } 
                     object { Facd rotate -48*y } 
                     object { Facd rotate -54*y } 

                    }
#declare Raft =                                             // Rafter
              torus { 3, 0.075  rotate 90*x 
                     scale < 1, 0.25, 1 >
                     clipped_by {
                               box { < -0.5, 0, -0.1 >,< -3.1, 1, 0.1 > }
                                }
                    translate < -42, 6, 0 >
                    pigment { color Gray60 }
                    finish { ambient 0.2 }
                    }
            
#declare Term =
         union {
object { Lounge }                                        // LOUNGE
difference {                                             // PUBLIC DECK
            cylinder { < 0, 3.5, 0 >,< 0, 4, 0 >,120 }
            cylinder { < 0, 3, 0 >,< 0, 4.5, 0 >,45 } 
                 pigment { color White }
                 finish { ambient 0.1 }
           }
difference {                                             // CEILING
            cylinder { < 0, 6, 0 >,< 0, 6.01, 0 >,120 }
            cylinder { < 0, 5.9, 0 >,< 0, 6.1, 0 >,45 } 
                 pigment { color White }
                 finish { ambient 0.6 }
           }

difference {                                             // WALL
            cylinder { < 0, 0, 0 >,< 0, 4, 0 >,120 }
            cylinder { < 0, -0.1, 0 >,< 0, 4.1, 0 >,55 } 
                 pigment { color White }
                 finish { ambient 0.1 }
                 hollow
           }

difference {                                            // ROOF
           torus { 47, 5  scale < 1, 0.4, 1 >  }
           torus { 42, 3  scale < 1, 0.25, 1 >  }
              clipped_by {
                          box { < -60, 0, -60 >,< 60, 4, 60 > }
                          }
                 translate  6*y
                 pigment { color rgb < 0.8, 0.6, 0.2 > }
                 finish { ambient 0.2 }
           }
object { Raft }
object { Raft rotate 10*y }
object { Raft rotate 20*y }  
object { Raft rotate 30*y }  
object { Raft rotate 40*y }
object { Raft rotate 50*y }  
object { Raft rotate 60*y }  
object { Raft rotate -10*y }
object { Raft rotate -20*y }  
object { Raft rotate -30*y }  
object { Raft rotate -40*y }
object { Raft rotate -50*y }  
object { Raft rotate -60*y }    

     }         
                   // POSTS
#declare Grvs =
             union {
                    torus { 0.2, 0.01 }
                    torus { 0.2, 0.01 translate 0.5*y }
                    torus { 0.2, 0.01 translate 1*y }
                    torus { 0.2, 0.01 translate 1.5*y }
                    torus { 0.2, 0.01 translate 2*y }
                    torus { 0.2, 0.01 translate 2.5*y }
                    torus { 0.2, 0.01 translate 3*y }
                         pigment { color White }
                         finish { ambient 0.1 }
                      }
#declare Capit =                                   // capital on posts
              difference {
                        cylinder { < 0, 0, 0 >,< 0, 0.6, 0 >,0.8 }
                        torus { 0.8, 0.6  }
                           pigment { color White }
                           finish { ambient 0.1 }
                        }
#declare Sup =                                               
       union {
              difference { 
                          cylinder { < 0, 0, 0 >,< 0, 6, 0 >,0.2 }
                          object { Grvs } 
                            pigment { color White }
                            finish { ambient 0.1 }
                         }
              object { Capit translate 2.9*y }
              object { Capit translate 5.4*y }   
                    translate -47*x
              }
#declare Piers =
             union {
                   object { Sup }
                   object { Sup rotate -8*y }
                   object { Sup rotate -16*y } 
                   object { Sup rotate -24*y } 
                   object { Sup rotate -32*y } 
                   object { Sup rotate -40*y } 
                   object { Sup rotate -48*y }
                   object { Sup rotate -56*y } 
                   object { Sup rotate -64*y } 
                   object { Sup rotate -72*y } 
                   object { Sup rotate -80*y } 
                   object { Sup rotate 8*y }
                   object { Sup rotate 16*y } 
                   object { Sup rotate 24*y } 
                   object { Sup rotate 32*y } 
                   object { Sup rotate 40*y } 
                   object { Sup rotate 48*y }
                   object { Sup rotate 56*y } 
                   object { Sup rotate 64*y } 
                   object { Sup rotate 72*y } 
                   object { Sup rotate 80*y }   
                   }
object { Piers rotate -1*y translate 35*x }
object { Term translate 35*x }
//MEN 
                   
#declare Aman =
         union {
                sphere { < 0, 0, 0 >,2        // hat
                          scale < 1.25, 1.8, 1.5 >
                          clipped_by {
                                   box { < -4, 1, -4 >,< 4, 4, 4 > }
                                     }
                          rotate 10*z
                          translate < 0, 35, -2 > 
                           pigment { color Red }
                           finish { ambient 0.2 }
                        }  
                sphere { < 0, 0, 0 >,1.7        // head
                        scale < 1.25, 1.8, 1.5 > 
                        translate < 0, 35, -2 > 
                        pigment { color White }
                        finish { ambient 0.3 }
                        }
                cone { < 0, 35, -1 >,1,< 0, 28, 0 >,2    // neck
                        scale < 1, 1, 0.75 > 
                     }
                sphere { < 0, 0, 0 >,1.5        // shoulder
                          scale < 1.1, 2.5, 1 >
                          rotate 48*z
                          translate < 3, 31, 0 >
                       }
                sphere { < 0, 0, 0 >,1.5        // shoulder
                          scale < 1.1, 2.5, 1 >
                          rotate -48*z
                          translate < -3, 31, 0 >
                       }
                sphere { < 0, 0, 0 >,5        // chest
                          scale < 1, 0.5, 0.2 >  
                          translate < 0, 30, -1.5 >
                       }

                 cone { < 4.6, 30, 0 >,1.5,< 3, 23, 2 >,0.75 }    // arm
                 cone { < -4.6, 30, 0 >,1.5,< -3, 23, 2 >,0.75 }   // arm

                 cone { < 0, 23, 0 >,3.1,< 0, 30, 0 >,3  // upper torso
                          scale < 1.1, 1, 0.5 >
                      }
                 cone { < 0, 17.5, 0 >,3.9,< 0, 23, 0 >,3.1  // lower torso
                          scale < 1.1, 1, 0.5 >
                          pigment { color rgb < 0.8, 0.6, 0.4 > }
                          finish { ambient 0.2 }
                      }

                 cone { < 1.7, 19, 0 >,2.2,< 2.6, 9, 0 >,1.3     // thigh
                          pigment { color rgb < 0.8, 0.6, 0.4 > }
                          finish { ambient 0.2 }
                      }
                 cone { < -1.7, 19, 0 >,2.2,< -2.6, 9, 0 >,1.3    // thigh
                          pigment { color rgb < 0.8, 0.6, 0.4 > }
                          finish { ambient 0.2 }
                      }

                 cone { < -2.6, 10, 0 >,1.3,< -3.2, 1, 0 >,1     // calf
                          pigment { color rgb < 0.8, 0.6, 0.4 > }
                          finish { ambient 0.2 }
                      }
                 cone { < 2.6, 10, 0 >,1.3,< 3.2, 1, 0 >,1    // calf
                          pigment { color rgb < 0.8, 0.6, 0.4 > }
                          finish { ambient 0.2 }
                      }
                 cone { < -3.2, 0.8, 1 >,1,< -3.6, 0.4, -7 >,0.54  // foot
                       pigment { color Black }
                       finish { ambient 0.2 }
                      }
                 cone { < 3.2, 0.8, 1 >,1,< 3.6, 0.4, -7 >,0.54    // foot
                       pigment { color Black }
                       finish { ambient 0.2 }
                      }  
                       pigment { color Red }
                       finish { ambient 0.2 }
                       scale 0.03
          }
#declare Bman =
         union {
                sphere { < 0, 0, 0 >,2        // hat
                          scale < 1.25, 1.8, 1.5 >
                          clipped_by {
                                   box { < -4, 1, -4 >,< 4, 4, 4 > }
                                     }
                          rotate 10*z
                          translate < 0, 35, -2 > 
                           pigment { color Blue }
                           finish { ambient 0.2 }
                        }
                sphere { < 0, 0, 0 >,1.7        // head
                        scale < 1.25, 1.8, 1.5 > 
                        translate < 0, 35, -2 > 
                        pigment { color White }
                        finish { ambient 0.3 }
                        }

                cone { < 0, 35, -1 >,1,< 0, 28, 0 >,2    // neck
                        scale < 1, 1, 0.75 > 
                     }
                sphere { < 0, 0, 0 >,1.5        // shoulder
                          scale < 1.1, 2.5, 1 >
                          rotate 48*z
                          translate < 3, 31, 0 >
                       }
                sphere { < 0, 0, 0 >,1.5        // shoulder
                          scale < 1.1, 2.5, 1 >
                          rotate -48*z
                          translate < -3, 31, 0 >
                       }
                sphere { < 0, 0, 0 >,5        // chest
                          scale < 1, 0.5, 0.2 >  
                          translate < 0, 30, -1.5 >
                       }

                 cone { < 4.6, 30, 0 >,1.5,< 3, 23, 2 >,0.75 }    // arm

                 cone { < -4.6, 30, 0 >,1.5,< -8, 26, 0 >,1.05 }   // arm
                 cone { < -8, 26, 0 >,1.5,< -4, 22, 0 >,0.75 }   // arm  

                 cone { < 0, 23, 0 >,3.1,< 0, 30, 0 >,3  // upper torso
                          scale < 1.1, 1, 0.5 >
                      }
                 cone { < 0, 17.5, 0 >,3.9,< 0, 23, 0 >,3.1  // lower torso
                          scale < 1.1, 1, 0.5 >
                          pigment { color rgb < 0.8, 0.6, 1 > }
                          finish { ambient 0.2 }
                      }

                 cone { < 1.7, 19, 0 >,2.2,< 2.6, 9, 0 >,1.3     // thigh
                          pigment { color rgb < 0.8, 0.6, 1 > }
                          finish { ambient 0.2 }
                      }
                 cone { < -1.7, 19, 0 >,2.2,< -2.6, 9, 0 >,1.3    // thigh
                          pigment { color rgb < 0.8, 0.6, 1 > }
                          finish { ambient 0.2 }
                      }

                 cone { < -2.6, 10, 0 >,1.3,< -3.2, 1, 0 >,1     // calf
                          pigment { color rgb < 0.8, 0.6, 1 > }
                          finish { ambient 0.2 }
                      }
                 cone { < 2.6, 10, 0 >,1.3,< 3.2, 1, 0 >,1    // calf
                          pigment { color rgb < 0.8, 0.6, 1 > }
                          finish { ambient 0.2 }
                      }
                 cone { < -3.2, 0.8, 1 >,1,< -3.6, 0.4, -7 >,0.54  // foot
                       pigment { color Black }
                       finish { ambient 0.2 }
                      }
                 cone { < 3.2, 0.8, 1 >,1,< 3.6, 0.4, -7 >,0.54    // foot
                       pigment { color Black }
                       finish { ambient 0.2 }
                      }  
                       pigment { color rgb < 0.4, 0.6, 0 > }
                       finish { ambient 0.2 }
                       scale 0.03
          }

object { Bman rotate -30*y translate < -7.65, 3.8,  -15 > }
object { Bman rotate -20*y translate < -8, 3.8,  -14 > }  
object { Bman rotate 30*y translate < -11, 3.8,  -5 > }
object { Bman scale < 2, 1, 2 > rotate -90*y translate < -10, 3.8,  -6 > }  
object { Bman scale < 2, 1.2, 1.5 > rotate 60*y translate < -11, 3.8,  -7 > }
object { Bman rotate 90*y translate < -10, 3.8,  -3.4 > }  



                   
#declare Cman =
         union {
                sphere { < 0, 0, 0 >,2        // hat
                          scale < 1.25, 1.8, 1.5 >
                          clipped_by {
                                   box { < -4, 1, -4 >,< 4, 4, 4 > }
                                     }
                          rotate 10*z
                          translate < 0, 35, -2 > 
                           pigment { color Yellow }
                           finish { ambient 0.4 }
                        }
                sphere { < 0, 0, 0 >,1.7        // head
                        scale < 1.25, 1.8, 1.5 > 
                        translate < 0, 35, -2 > 
                        pigment { color White }
                        finish { ambient 0.3 }
                        }
                cone { < 0, 35, -1 >,1,< 0, 28, 0 >,2    // neck
                        scale < 1, 1, 0.75 > 
                     }
                sphere { < 0, 0, 0 >,1.5        // shoulder
                          scale < 1.1, 2.5, 1 >
                          rotate 48*z
                          translate < 3, 31, 0 >
                       }
                sphere { < 0, 0, 0 >,1.5        // shoulder
                          scale < 1.1, 2.5, 1 >
                          rotate -48*z
                          translate < -3, 31, 0 >
                       }
                sphere { < 0, 0, 0 >,5        // chest
                          scale < 1, 0.5, 0.2 >  
                          translate < 0, 30, -1.5 >
                          pigment { color Yellow }
                          finish { ambient 0.4 }

                       }

                 cone { < 4.6, 30, 0 >,1.5,< 3, 23, 2 >,0.75 }    // arm
                 cone { < -4.6, 30, 0 >,1.5,< -15, 27, 2 >,0.75 }   // arm

                 cone { < 0, 23, 0 >,3.1,< 0, 30, 0 >,3  // upper torso
                          scale < 1.1, 1, 0.5 >
                          pigment { color Yellow }
                          finish { ambient 0.4 }
                      }
                 cone { < 0, 17.5, 0 >,3.9,< 0, 23, 0 >,3.1  // lower torso
                          scale < 1.1, 1, 0.5 >
                          pigment { color rgb < 0.8, 0.6, 1 > }
                          finish { ambient 0.2 }
                      }

                 cone { < 1.7, 19, 0 >,2.2,< 4.6, 9, 0 >,1.3     // thigh
                          pigment { color rgb < 0.8, 0.6, 1 > }
                          finish { ambient 0.2 }
                      }
                 cone { < -1.7, 19, 0 >,2.2,< -2.6, 9, 0 >,1.3    // thigh
                          pigment { color rgb < 0.8, 0.6, 1 > }
                          finish { ambient 0.2 }
                      }

                 cone { < -2.6, 10, 0 >,1.3,< -3.2, 1, 0 >,1     // calf
                          pigment { color rgb < 0.8, 0.6, 1 > }
                          finish { ambient 0.2 }
                      }
                 cone { < 4.6, 10, 0 >,1.3,< 7, 1, 0 >,1    // calf
                          pigment { color rgb < 0.8, 0.6, 1 > }
                          finish { ambient 0.2 }
                      }
                 cone { < -3.2, 0.8, 1 >,1,< -3.6, 0.4, -7 >,0.54  // foot
                       pigment { color Black }
                       finish { ambient 0.2 }
                      }
                 cone { < 7, 0.8, 1 >,1,< 7, 0.4, -7 >,0.54    // foot
                       pigment { color Black }
                       finish { ambient 0.2 }
                      }  
                       pigment { color Red }
                       finish { ambient 0.2 }
                       scale 0.03
          }
object { Cman translate < -9.2, 0, -9.8 > }
object { Bman translate < -8.2, 0, -9.8 > }  

#declare Driv =                  // DRIVER
          union {
              sphere { < 0, 0, 0 >,0.055                      // hat
                        clipped_by {
                              box { < -0.1, 0, -0.1 >,< 0.1, 0.1, 0.1 > }
                                   }
                         rotate 10*z
                         translate 0.34*y 
                         pigment { color Yellow }
                         finish { ambient 0.2 }
                       }
              disc { < 0, 0, 0 >,< 0, 1, 0 >,0.07 
                         rotate 10*z
                         translate 0.34*y 
                         pigment { color Yellow }
                         finish { ambient 0.2 }
                       }

              sphere { < 0, 0, 0 >,0.05 
                         scale < 0.7, 1, 0.8 >
                         rotate 15*z
                         translate 0.34*y
                       }
              sphere { < 0, 0, 0 >,0.05                           // face
                         scale < 0.7, 1, 0.8 >
                         rotate 15*z
                         translate < 0, 0.32, -0.015 >
                         pigment { color White }
                         finish { ambient 0.2 }
                       }

              sphere { < 0, 0, 0 >,0.05                        // torso
                         scale < 3.1, 3.1, 0.8 >
                         rotate < -5, 45, 15 >
                         translate < 0.04, 0.16, 0.05 >
                       }
              cone { < -0.01, 0.26, 0.01 >,0.02,< -0.055, 0.2, 0 >,0.0175 } 
              cone { < -0.055, 0.2, 0 >,0.0175,< -0.1, 0.125, -0.1 >,0.012 }
                     pigment { color rgb < 0.15, 0.15, 1 > }
                     finish { ambient 0.2 }
                 }
// GROUND MAN
#declare Fore =                  // GROUND MAN
          union {
              sphere { < 0, 0, 0 >,0.075               // helmet
                        clipped_by {
                              box { < -0.1, 0, -0.1 >,< 0.1, 0.1, 0.1 > }
                                   }
                         rotate 15*x
                         translate 0.81*y 
                         pigment { color Yellow }
                         finish { ambient 0.6 }
                       }
              disc { < 0, 0, 0 >,< 0, 1, 0 >,0.1 
                         rotate 15*x
                         translate 0.8*y 
                         pigment { color Yellow }
                         finish { ambient 0.5 }
                       }

              sphere { < 0, 0, 0 >,0.07                 // head
                         scale < 0.7, 1, 0.8 >
                         rotate 15*x
                         translate 0.8*y
                       }
              sphere { < 0, 0, 0 >,0.07                  // face
                         scale < 0.7, 1, 0.8 >
                         rotate 15*x
                         translate < 0, 0.78, -0.015 >
                         pigment { color White }
                         finish { ambient 0.2 }
                       }

              sphere { < 0, 0, 0 >,0.125                  // torso
                         scale < 0.75, 1.2, 0.25 >
                         rotate 5*x
                         translate 0.6*y
                         pigment { color Yellow }
                         finish { ambient 0.5 }
                       }
              sphere { < 0, 0, 0 >,0.09                  // hips
                         scale < 1, 1, 0.75 > 
                         translate 0.45*y
                       }                    
              cylinder { < -0.015, 0.71, 0 >,< 0.01, 0.71, 0 >,0.025 }      
              
           cone { < -0.01, 0.71, 0 >,0.03,< -0.2, 0.78, -0.01 >,0.02 } 
           cone {< -0.2, 0.78, -0.01 >,0.018,< -0.2, 0.9, -0.1 >,0.012 }
                                                               // r arm

           cone { < 0.01, 0.71, 0 >,0.03,< 0.2, 0.55, -0.01 >,0.02 } 
           cone {< 0.2, 0.55, -0.01 >,0.018,< 0.2, 0.4, -0.1 >,0.012 } 
                                                              // l arm
                   
           cone { < -0.03, 0.45, 0 >,0.07,< -0.025, 0.22, -0.01 >,0.03 } 
           cone { < -0.025, 0.22, -0.01 >,0.035,< -0.05, 0.15, -0.005 >,0.035 }
           cone { < -0.025, 0.22, -0.01 >,0.03,< -0.05, 0, -0.005 >,0.02 
                       pigment { color Black }
                       finish { ambient 0.2 }
                    }
                                                              // r leg

           cone { < 0.03, 0.45, 0 >,0.07,< 0.15, 0.22, -0.01 >,0.03 } 
           cone {< 0.15, 0.22, -0.01 >,0.035,< 0.175, 0.15, -0.01 >,0.035 }
           cone {< 0.15, 0.22, -0.01 >,0.03,< 0.2, 0, -0.01 >,0.02  
                       pigment { color Black }
                       finish { ambient 0.2 }
                    }                                         // l leg    
                                                                 
           cone { < -0.05, 0.01, 0.01 >,0.02,< -0.06, 0.01, -0.08 >,0.013 
                     pigment { color Black }
                     finish { ambient 0.2 }                     // r foot
                   } 
           cone { < 0.2, 0.01, 0 >,0.02,< 0.2, 0.01, -0.08 >,0.013 
                     pigment { color Black }
                     finish { ambient 0.2 }                     // l foot
                   }
                                                                
                     pigment { color Blue }
                     finish { ambient 0.3 }                  
                   }
                       

// TRUCK
#declare Barr =
           union {
                 box { < -0.751, -0.25, -0.04 >,< -0.5, -0.05, 0.04 > }
                 box { < -0.751, 0.05, -0.04 >,< -0.5, 0.25, 0.04 > } 
                       pigment { color Gray40 }
                       finish { ambient 0.2 }
                  }
#declare Tred =
              union {
                    object { Barr }
                    object { Barr rotate 10*y }
                    object { Barr rotate 20*y }   
                    object { Barr rotate 30*y }   
                    object { Barr rotate 40*y }   
                    object { Barr rotate 50*y }
                    object { Barr rotate 60*y }   
                    object { Barr rotate 70*y }   
                    object { Barr rotate 80*y }   
                    object { Barr rotate 90*y }
                    object { Barr rotate 100*y }
                    object { Barr rotate 110*y }
                    object { Barr rotate 120*y }   
                    object { Barr rotate 130*y }   
                    object { Barr rotate 140*y }   
                    object { Barr rotate 150*y }
                    object { Barr rotate 160*y }   
                    object { Barr rotate 170*y }   
                    object { Barr rotate 180*y } 
                    object { Barr rotate -10*y }
                    object { Barr rotate -20*y }   
                    object { Barr rotate -30*y }   
                    object { Barr rotate -40*y }   
                    object { Barr rotate -50*y }
                    object { Barr rotate -60*y }   
                    object { Barr rotate -70*y }   
                    object { Barr rotate -80*y }   
                    object { Barr rotate -90*y }
                    object { Barr rotate -100*y }
                    object { Barr rotate -110*y }
                    object { Barr rotate -120*y }   
                    object { Barr rotate -130*y }   
                    object { Barr rotate -140*y }   
                    object { Barr rotate -150*y }
                    object { Barr rotate -160*y }   
                    object { Barr rotate -170*y }   

                    }
                          

#declare Weel =                            // WHEEL
          union { 
                object { Tred }
                torus { 0.5, 0.25  
                       scale < 1, 1.5, 1 >
                       pigment { color Gray30 }
                       finish { ambient 0.2 }
                       }
                sphere { < 0, 0, 0 >,0.6
                         scale < 1, 0.5, 1 >
                         pigment { color Red }
                         finish { ambient 0.2 }
                       }
               rotate 90*z
               translate 0.74*y
               }
#declare Hedlt =                                          // HEADLIGHT
            difference {
                    sphere { < 0, 0, 0 >,0.21  scale < 1, 1, 1.5 >
                               clipped_by {
                                          box { < -1, -1, 0 >,< 1, 1, 1 > }
                                          }
                               pigment { color Red }
                               finish { ambient 0.2 
                                            phong 1 }
                            }
                     sphere { < 0, 0, 0 >,0.2  
                                pigment { color rgb < 0.7, 0.7, 0.4 > }
                                finish { ambient 1 }
                            }    
                        }    
#declare Gas =                                      // GAS CYLINDERS
            union {
                   torus { 0.5, 0.05
                           rotate 90*x
                           clipped_by {
                                     box { < -1, 0, -1 >,< 1, 1, 1 > }
                                      }
                           translate < 0.5, 3.5, 0 >
                          }
                   cylinder { < 0, 2.5, 0 >,< 0, 2.8, 0 >,0.51 
                               pigment { color rgb < 0.8, 0.5, 0.2 > }
                               finish { ambient 0.2 }
                            }
                   cylinder { < 1, 3.5, 0 >,< 1, 3.6, 0 >,0.15 } 
                   cylinder { < 1, 0.75, 0 >,< 1, 3.5, 0 >,0.05 }  
                   cylinder { < 0, 0.75, 0 >,< 0, 3, 0 >,0.5 }
                   sphere { < 0, 3, 0 >,0.5 }
                       pigment { color Green }
                       finish { ambient 0.2
                                phong 1
                              }
                  }
#declare HG =                                      // SIDE CYLINDERS
           union {
                   cylinder { < 0, 1.9, -1 >,< 0, 1.9, 1 >,0.26 
                              pigment { color Red }
                            }
                   cylinder { < 0, 1.9, -2 >,< 0, 1.9, 2 >,0.25 }
                   sphere { < 0, 1.9, -2 >,0.25 }
                   sphere { < 0, 1.9, 2 >,0.25 }
                       pigment { color rgb < 0.2, 0.6, 1 > }
                       finish { ambient 0.2
                                phong 1
                              }
                  }
#declare Grill =                                       // GRILL
               union {
                     torus { 0.16, 0.02 
                             pigment { color Red }
                             finish { ambient 0.2 }
                            }
                     torus { 0.11, 0.015 }
                     torus { 0.06, 0.015 }
                     sphere { < 0, 0, 0 >,0.015  }
                              pigment { color rgb < 0.8, 0.8, 1 > }
                              finish { ambient 0.2
                                       phong 1 }
                     rotate 90*x
                     scale < 1.85, 3, 6 >
                       }

#declare Ring =                                          // ENGINE PARTS
          union {
             torus { 1.6, 0.02 
                      pigment { color rgb < 0.6, 0.7, 0.3 > } 
                      finish { ambient 0.2 
                               phong 1 }
                   }
             torus { 1.6, 0.02   translate 0.05*y
                      pigment { color rgb < 0.6, 0.7, 0.3 > } 
                      finish { ambient 0.2 
                               phong 1 }
                   }

             torus { 1.5, 0.1  }
                     scale < 1, 2.5, 0.5 >
                     rotate 90*x
                     translate 1.4*y
                     pigment { color Gray75 }
                     finish { ambient 0.2 }
                     }
                
#declare Mote =                                           // ENGINE
             union {
                    object { Ring }
                    object { Ring translate -0.5*z }
                    object { Ring translate -1*z }  
                    object { Ring translate -1.5*z }  
                    sphere { < 0, 0, 0 >,1.5
                             scale < 1, 0.5, 0.3 >
                             translate < 0, 1.4, -1.5 >
                             pigment { color Gray25 }
                             finish { ambient 0.2 }
                           }
                   }
#declare Load =
            union {
                   object { Gas translate < 1, 0, 0.5 > }
                   object { Gas translate < 1, 0, -0.5 > }
                   object { Gas translate < 1, 0, 1.5 > }
                   object { Gas translate < 1, 0, -1.5 > }
                  
                   object { Gas rotate 180*y translate < -1, 0, 0.5 > }
                   object { Gas rotate 180*y translate < -1, 0, -0.5 > }
                   object { Gas rotate 180*y translate < -1, 0, 1.5 > }
                   object { Gas rotate 180*y translate < -1, 0, -1.5 > }
                
                  }
#declare Lbar =
              union {
                    sphere { < 0, 0, 0 >,0.05   scale < 2, 1, 1 >
                            translate -1.5*x
                            pigment { color rgb < 0, 0.6, 0.4 > }
                            finish { ambient 1 }
                           }
                    sphere { < 0, 0, 0 >,0.05    scale < 2, 1, 1 > 
                            translate -1*x 
                            pigment { color rgb < 1, 1, 0.1 > }
                            finish { ambient 1 }
                           }

                    sphere { < 0, 0, 0 >,0.05   scale < 2, 1, 1 > 
                            translate -0.5*x 
                            pigment { color rgb < 0.2, 0.2, 1 > }
                            finish { ambient 1 }
                           }
                    sphere { < 0, 0, 0 >,0.05    scale < 2, 1, 1 > 
                            translate 0.5*x 
                            pigment { color rgb < 1, 1, 0.1 > }
                            finish { ambient 1 }
                           }
                    sphere { < 0, 0, 0 >,0.05   scale < 2, 1, 1 > 
                            translate 1*x 
                            pigment { color rgb < 0.2, 0.2, 1 > }
                            finish { ambient 1 }
                           }

                    sphere { < 0, 0, 0 >,0.05    scale < 2, 1, 1 > 
                            translate 1.5*x 
                            pigment { color rgb < 1, 0.2, 0 > }
                            finish { ambient 1 }
                           }
                     }
#declare Warn =
           union {
              box { < -2.5, -0.25, -0.001 >,< 2.5, 0.25, 0.001 >
                    pigment { checker color Yellow color Gray20 
                              scale 0.25 }
                    finish { ambient 0.2 }
                  }
              sphere { < -2.75, 0, 0 >,0.1
                       pigment { color rgbt < 1, 1, 0, 0.5 > }
                       finish { ambient 1 }
                     }
              sphere { < 2.75, 0, 0 >,0.1
                       pigment { color rgbt < 1, 1, 0, 0.5 > }
                       finish { ambient 1 }
                     }
                 }

#declare Truck =                                         // VEHICLE
            union {
                    superellipsoid { < 0.1, 0.1 >             // TRAY
                                   scale < 3, 0.5, 2.5 >
                                   translate < 0, 1.2, 0 >
                                   pigment { color Red }
                                   finish { ambient 0.2 }
                                   }
                    object { HG translate 2.5*x }
                    object { HG translate -2.5*x }
                    object { Warn translate < 0, 1.2, 2.5 > }
                    object { Warn translate < 0, 1.2, -2.5 > }
                    object { Lbar translate < 0, 2.8, -5.5 > }  // LIGHTS
                    sphere { < 0, 0, 0 >,0.1            // SIDELIGHT
                               translate < 2, 1.9, -5.7 >
                               pigment { color rgbt < 1, 1, 0, 0.5 > }
                               finish { ambient 1 }
                           }
                    sphere { < 2.75, 0, 0 >,0.1            // SIDELIGHT
                               translate < -2, 1.9, -5.7 >
                               pigment { color rgbt < 1, 1, 0, 0.5 > }
                               finish { ambient 1 }
                           }


                    difference {
                            superellipsoid { < 0.1, 0.1 >        // CABIN
                                   scale < 2, 0.5, 0.5 >
                                   translate < 0, 2.2, -5.5 >
                                   pigment { color Red }
                                   finish { ambient 0.2 }
                                           }
                            union {
                               box { < -2.1, 0.35, 0.3 >,< 2.1, -0.1, -1 > }
                               box { < -1.2, 0.35, 0.6 >,< 1.2, -0.1, -1 > }
                                   translate < 0, 2.2, -5.5 > 
                                   pigment { color White }
                                   finish { ambient 0.4 }
                                  }
                               }
                     object { Warn scale < 0.5, 0.25, 1 >         
                              translate < 0, 1.95, -6 > 
                            }
                     object { Driv  scale 1.6
                              translate < -1.5, 1.9, -5.5 > }  // DRIVER
                     box { < -2, 0.35 0.4 >,< 2, -0.1, -0.5 >    // GLASS
                                   translate < 0, 2.2, -5.5 > 
                                   pigment { color rgbt < 0.8, 0.8, 1, 0.8 > }
                                   finish { ambient 0.2 
                                            phong 1 }
                                }

                    cylinder { < 0, 0.5, 0 >,< 0, 1.6, 0 >,2.5     // CHASSIS
                                scale < 0.5, 1, 1 >
                                translate -3.75*z
                                   pigment { color Red }
                                   finish { ambient 0.2 }
                             }
                    object { Grill translate < 0, 1.1, -6.25 > }
                    cone { < 0, 0.95, -5.5 >,0.5,< 1.6, 0.75, -6 >,0.05
                                   pigment { color Red }
                                   finish { ambient 0.2 }
                         }
                    cone { < 0, 0.95, -5.5 >,0.5,< -1.6, 0.75, -6 >,0.05
                                   pigment { color Red }
                                   finish { ambient 0.2 }
                         }
                    object { Hedlt translate < 0.55, 0.8, -6.4 > }
                    object { Hedlt translate < -0.55, 0.8, -6.4 > }   
                    
                    object { Weel translate < 2.5, 0, 0.8 > }
                    object { Weel translate < 2.5, 0, -0.8 > } 
                    object { Weel translate < -2.5, 0, 0.8 > } 
                    object { Weel translate < -2.5, 0, -0.8 > } 
                    object { Weel rotate -40*y translate < 1.6, 0, -6 > } 
                    object { Weel rotate -40*y translate < -1.6, 0, -6 > } 
                    object { Load }
                    object { Mote translate -3*z }
                    object { Fore rotate 180*y translate < -3.1, 0, -6 > } 
                    }


object { Truck scale 0.9 rotate 14*y translate < 12, 0, -19 > }

object { Truck scale 0.9 rotate 67*y translate < -9.15, 0, -17 > }   

#declare Qart =                                      // bale section
         superellipsoid { < 0.3, 0.3 >
                     texture {  
                         pigment { color rgb < 0.9, 0.8, 0.6 > }
                                           //< 0.8, 0.7, 0.5 > }
                         normal { dents scale 0.2 }
                         finish { ambient 0.2 }
                              }   
                      texture {
                         pigment {   
                                  image_map {
                                             gif "bag7.gif"  map_type 1
                                             filter all 0.35
                                             }
                                   rotate 30*x
                                   scale 1.5
                                 }
                               }
                       }
#declare Bale =
              union {
                  object { Qart translate < 1.1, 1, 1.1 > }
                  object { Qart rotate 90*y translate < 1.1, 3.2, 1.1 > }
                  object { Qart rotate 180*y translate < 1.1, 1, -1.1 > }
                  object { Qart rotate 180*x translate < 1.1, 3.2, -1.1 > }
                  object { Qart translate < -1.1, 1, 1.1 > }
                  object { Qart translate < -1.1, 3.2, 1.1 > }
                  object { Qart rotate 180*z translate < -1.1, 1, -1.1 > }
                  object { Qart translate < -1.1, 3.2, -1.1 > }
                     box { < -1.8, 2, -1.8 >,< 1.8, 2.2, 1.8 > }   
                     box { < -1.8, 0.1, -0.05 >,< 1.8, 4, 0.1 > }    
                     box { < -0.1, 0.1, -1.8 >,< 0.1, 4, 1.8 > }   
                          pigment { color Gray50 }
                          finish { ambient 0.2
                                   phong 1 }
                     }
object { Bale scale 0.1 rotate 42*y translate < 12.7, 0, -42.7 > }   
object { Bale scale 0.1 rotate 10*y translate < 12.8, 0, -42.3 > }                 
object { Bale scale 0.1 rotate 45*y translate < 12.3, 0, -42.5 > }  
object { Bale scale 0.1 rotate 75*y translate < 12.5, 0.4, -42.7 > }  
object { Bale scale 0.07  rotate -25*y translate < 14.8, 0, -42.5 > }  
                                                                     
// SAUCER  ( on the ground )
#declare Uc =                                // UNDERCART
             union {
                    sphere { < 0, 0, 0 >,1.4
                            scale < 1, 0.25, 1 >
                            translate  6*x
                           }
                    cylinder { < 6, 0.4, -0.5 >,< 6, 0.4, 0.5 >,0.2 }
                    cylinder { < 0, 3, 0 >,< 6, 0.4, 0 >,0.1 
                              pigment { color White } 
                              finish { ambient 0.2 
                                       phong 1 }
                             }
                     pigment { color rgb < 0.8, 0.4, 0.3 > }
                     finish  { ambient 0.3
                               diffuse 0.4
                               specular 1
                             }

                   }
#declare Vent =
              superellipsoid { < 0.3, 0.3 >
                               scale < 1, 0.25, 1 >
                               translate < -1, -0.25, 0 >
                               rotate 18*z
                     pigment { color rgb < 0.8, 0.4, 0.3 > }
                     finish  { ambient 0.3
                               diffuse 0.4
                               specular 1
                             }
                             }  

#declare Lid =                                                // CANOPY
             sphere { < 0, 0, 0 >,6.25    scale < 1, 0.25, 1 >
                     clipped_by {
                                  box { < -7, 0, -7 >,< 7, 3.5, 7 > }
                                }
                     translate 5*y
                     pigment { color rgb < 0.8, 0.4, 0.3 > }
                     finish  { ambient 0.3
                               diffuse 0.4
                               specular 1
                             }
                   }
#declare Bsaucer = 
               union {
lathe {
       cubic_spline
       31, 
       < -1, 0.5 >,< 0, 0.5 >,< 4.8, 1.4 >,< 5, 1.5 >,< 7, 1.4 >,
       < 9, 1.3 >,< 10, 1.2 >,< 11, 1.1 >,< 11.8, 0.9 >,< 12, 1 >, 
       < 11.5, 1.45 >,< 11, 1.8 >,< 10.5, 2.02 >,< 10, 2.25 >,< 9.5, 2.4 >,
       < 9, 2.5 >,< 8.85, 2.7 >,< 8.7, 2.8 >,< 8.5, 2.85 >,
       < 8, 3.25 >,< 7.7, 3.3 >,< 7.5, 3.4 >,< 7.2, 3.65 >,< 7.1, 3.8 >,
       < 7, 3.9 >,< 6.9, 3.95 >,< 6.8, 4 >,< 5, 4 >,< 2, 4 >,< 0, 4 >,
       < -1, 4 >
        
               pigment { color rgb < 0.8, 0.4, 0.3 > }
               finish { ambient 0.3
                        diffuse 0.4
                        specular 1
                      }
      }
object { Lid }
cone { < 0, 4, 0 >,6.8,< 0, 5, 0 >,6.25                      // WINDOWS
            pigment { color rgbt < 0.8, 0.8, 1.0, 0.6 > }
            finish { phong 1 }
     }

cylinder { < 0, 4, 0 >,< 0, 5.25, 0 >,4               // INTERIOR
            pigment { color rgb < 0.8, 0.8, 1.0 > }
            finish { ambient 0.32 }
         }
object { Aman translate < -1.08, 3.8, -6 > }
object { Bman translate < -1.9, 3.8, -5.6 > } 

#declare Int =
cylinder { < 0, 4, 0 >,< 0, 5.25, 0 >,5.5               // INTERIOR
             scale < 1, 1, 0.2 >
            pigment { color rgb < 0.8, 0.8, 1.0 > }
            finish { ambient 0.4 }
         }
object { Int }
object { Int rotate 30*y }
object { Int rotate 60*y } 
object { Int rotate 90*y } 
object { Int rotate 120*y } 

object { Vent translate < -9.5, 2.4, 0 > rotate -5*y } 
object { Vent translate < -9.5, 2.4, 0 > rotate -25*y } 
object { Vent translate < -9.5, 2.4, 0 > rotate -45*y }
object { Vent translate < -9.5, 2.4, 0 > rotate -65*y }  
object { Vent translate < -9.5, 2.4, 0 > rotate -85*y }  
object { Vent translate < -9.5, 2.4, 0 > rotate -105*y }  
object { Vent translate < -9.5, 2.4, 0 > rotate -125*y }  
object { Vent translate < -9.5, 2.4, 0 > rotate -145*y }
object { Vent translate < -9.5, 2.4, 0 > rotate -165*y }  
object { Vent translate < -9.5, 2.4, 0 > rotate 25*y } 
object { Vent translate < -9.5, 2.4, 0 > rotate 45*y }
object { Vent translate < -9.5, 2.4, 0 > rotate 65*y }  
object { Vent translate < -9.5, 2.4, 0 > rotate 85*y }  
object { Vent translate < -9.5, 2.4, 0 > rotate 105*y }  
object { Vent translate < -9.5, 2.4, 0 > rotate 125*y }  
object { Vent translate < -9.5, 2.4, 0 > rotate 145*y }
object { Vent translate < -9.5, 2.4, 0 > rotate 165*y }  
object { Uc rotate 30*y }
object { Uc rotate 120*y } 
object { Uc rotate -60*y } 
object { Uc rotate -150*y } 
                }
object { Bsaucer }        
               
// SAUCER    ( in the air )
#declare Und =
             sphere { < 0, 0, 0 >,0.1    scale < 3, 1, 3 >
                     rotate 20*z
                     translate < 1, 0.15, 0 >
                     pigment { color rgb < 0.8, 0.4, 0.4 > }
                     finish { ambient 0.2 
                              reflection 0.1 }
                     }
#declare Saucer = 
               union {
lathe {
       cubic_spline
       23, 
       < -0.2, 0.2 >,< 0, 0 >,< 0.2, 0.02 >,< 0.5, 0.1 >,< 0.6, 0.05 >,
       < 0.7, 0 >,< 0.85, 0.05 >,< 1.1, 0.16 >,< 1.35, 0.2 >,< 1.6, 0.16 >,
       < 1.95, 0.05 >,< 2, 0.1 >,< 1.9, 0.2 >,< 1.7, 0.3 >,< 1.5, 0.35 >,
       < 1.21, 0.5 >,< 1.06, 0.52 >,< 0.92, 0.6 >,< 0.88, 0.75 >,< 0.5, 0.96 >,
       < 0.2, 1 >,< 0, 1 >,< -0.2, 1 >
        
               pigment { color rgb < 0.8, 0.4, 0.3 > }
               finish { ambient 0.3
                        diffuse 0.4
                        specular 1
                        reflection 0.2 }
      }
torus { 0.88, 0.06   scale < 1, 0.5, 1 >    
        translate 0.75*y
        pigment { color Gray85 }
        finish { ambient 0.2
                 reflection 0.2 }
       }
torus { 1.1, 0.2    scale < 1, 0.3, 1 >   
        translate 0.4*y
        pigment { color Gray85 }
        finish { ambient 0.2
                 reflection 0.2 }
       }
cone { < 0, 0.75, 0 >,0.93 < 0, 0.47, 0 >,1.2
        pigment { color rgb < 0.5, 0.5, 0.7 > }
        finish { ambient 0.2
                 reflection 0.1 
                 phong 1 }
     }
sphere { < 0, 0, 0 >,0.1     scale < 1, 1.25, 1 >
        translate 1*y
        pigment { color Yellow }
        finish { ambient 1  }
     }
object { Und }
object { Und rotate 60*y }
object { Und rotate 120*y }   
object { Und rotate 180*y }   
object { Und rotate 240*y } 
object { Und rotate 300*y }     
         }
              
object { Saucer   rotate < -2, 0, -6 >          
              translate < -10, 25, 30 > }  
object { Saucer   rotate < -2, 0, -10 >          
              translate < 8, 22, 16 > }  
              
       //  DRAGON

#declare Kol =                                                // TEXTURE
             texture {
                       pigment { 
                          granite
                          color_map {
                                [ 0.0 color rgb < 0.5, 0.4, 0.1 > ]
                                [ 0.3 color rgb < 0.8, 0.7, 0.1 > ] 
                                [ 0.6 color rgb < 0.5, 0.4, 0.1 > ] 
                                [ 1.0 color rgb < 0.1, 0.4, 0.1 > ] 
                                    }
                              scale 0.1
                                 }
                       normal { wrinkles  scale 0.01 }
                       finish { ambient 0.2 }
                     }
#declare Thon =
              union {                                         // BACK FIN
                     cylinder { < 0, 0.045, 0 >,< 0, 0.076, -0.025 >,0.005 }
                     sphere { < 0, 0.076, -0.025 >,0.005 }
                       texture { Kol }
                    }
#declare Skal =                                              // SCALE
              sphere { < 0, 0, 0 >,0.015
                       scale < 1, 0.15, 3 >
                       rotate 11*x
                       translate < 0, 0.06, 0 >
                       texture { Kol }
                      }
#declare Bskal =                                              // SCALE
              sphere { < 0, 0, 0 >,0.015
                       scale < 1, 0.15, 3 >
                       rotate -5*x
                       translate < 0, 0.095, 0 >
                       texture { Kol }
                      }

#declare Skin =                                             // SKIN
              union {
                     object { Skal rotate 15*z }
                     object { Skal rotate 45*z } 
                     object { Skal rotate 75*z } 
                     object { Skal rotate 105*z } 
                     object { Skal rotate -15*z }
                     object { Skal rotate -45*z } 
                     object { Skal rotate -75*z } 
                     object { Skal rotate -105*z } 
                     object { Skal rotate 30*z translate -0.035*z }
                     object { Skal rotate 60*z translate -0.035*z } 
                     object { Skal rotate 90*z translate -0.035*z } 
                     object { Skal rotate 120*z translate -0.035*z } 
                     object { Skal rotate -30*z translate -0.035*z }
                     object { Skal rotate -60*z translate -0.035*z } 
                     object { Skal rotate -90*z translate -0.035*z } 
                     object { Skal rotate -120*z translate -0.035*z } 
                     }
#declare Bskin =                                             // SKIN
              union {
                     object { Bskal rotate 15*z }
                     object { Bskal rotate 45*z } 
                     object { Bskal rotate 75*z } 
                     object { Bskal rotate 105*z } 
                     object { Bskal rotate -15*z }
                     object { Bskal rotate -45*z } 
                     object { Bskal rotate -75*z } 
                     object { Bskal rotate -105*z } 
                     object { Bskal rotate 30*z translate -0.035*z }
                     object { Bskal rotate 60*z translate -0.035*z } 
                     object { Bskal rotate 90*z translate -0.035*z } 
                     object { Bskal rotate 120*z translate -0.035*z } 
                     object { Bskal rotate -30*z translate -0.035*z }
                     object { Bskal rotate -60*z translate -0.035*z } 
                     object { Bskal rotate -90*z translate -0.035*z } 
                     object { Bskal rotate -120*z translate -0.035*z } 
                     }

#declare Bskin =
           object { Skin scale 1.5 }

#declare Fseg =                                    // FRONT SEGMENT
          union {        
                cone { < 0, 0, -0.08 >,0.065,< 0, 0, 0.07 >,0.05 }  
                object { Thon scale < 1, 1, 2 > translate 0.03*z }
                object { Thon scale < 1, 1, 2 > translate -0.03*z } 
                object { Skin }
                scale < 0.65, 1.5, 1 >
                  texture { Kol }  
                }
#declare Mseg =                                    // MIDDLE SEGMENT
          union {
                cylinder { < 0, 0, -0.075 >,< 0, 0, 0.065 >,0.1 }  
                object { Thon scale  < 1, 1.25, 1.5 >
                          translate < 0, 0.025, 0.03 > }
                object { Thon scale  < 1, 1.25, 1.5 > 
                          translate < 0, 0.025, -0.03 > } 
                object { Bskin scale 1.05 }
                scale < 0.65, 1.5, 1 >
                  texture { Kol }  
                }

#declare Bseg =                                    // BACK SEGMENT
          union {
                cone { < 0, 0, 0.075 >,0.1,< 0, 0, -0.07 >,0.086 }  
                object { Thon translate < 0, 0.036, 0.03 > }
                object { Thon translate < 0, 0.025, -0.03 > } 
                object { Bskin }
                scale < 0.65, 1.5, 1 >
                  texture { Kol }  
                }
#declare Core =
    union {   
         
         object { Fseg  rotate 45*y translate < 0.15, 0, 0.45 > }    //1
         object { Fseg scale < 1.2, 1.2, 1 >                          //2
                      rotate < 15, 30, 0 >
                      translate < 0.07, 0.02, 0.35 > }
         object { Fseg scale < 1.41, 1.41, 1 >                        //3
                      rotate < 20, 20, 0 >
                      translate < 0.03, 0.045, 0.25 > }
         object { Fseg scale < 1.62, 1.62, 1 >                        //4
                      rotate < 15, 5, 0 >
                      translate < 0.009, 0.08, 0.15 > }
         object { Mseg                                               //5
                      rotate < 5, 0, 0 >
                      translate < 0, 0.095, 0.05 > }
         object { Mseg                                               //6
                      rotate < -5, 0, 0 >
                      translate < 0, 0.095, -0.05 > }
         object { Bseg                                              //7
                      rotate < -25, 5, 0 >
                      translate < -0.005, 0.07, -0.15 > }
         object { Bseg scale < 0.86, 0.86, 1 >                      //8
                      rotate < -22, 10, 0 >
                      translate < -0.01, 0.03, -0.25 > }
         object { Bseg scale < 0.72, 0.72, 1 >                       //9
                      rotate < -20, 15, 0 >
                      translate < -0.03, -0.015, -0.35 > }
         object { Bseg  scale < 0.58, 0.58, 1 >                      //10
                      rotate < -18, 25, 0 >
                      translate < -0.07, -0.04, -0.45 > }
         object { Bseg scale < 0.44, 0.44, 1 >                       //11
                      rotate < -15, 35, 0 >
                      translate < -0.13, -0.07, -0.55 > }
         object { Bseg  scale < 0.3, 0.3, 1 >                       //12
                      rotate < -10, 45, 0 >
                      translate < -0.21, -0.09, -0.66 > }
                    }        

#declare Pad =
             sphere { < 0, 0, 0 >,0.1
                       scale < 0.6, 0.5, 1 >
                       rotate 10*x
                       translate < 0, 0.05 , 0 >
                       texture { Kol }
                    }
#declare Claw =
          torus { 0.1, 0.02    
                  rotate 90*z
                  scale < 0.5, 0.75, 1 >
                        clipped_by {
                            box { < -0.1, 0, -0.1 >,< 0.1, 0.1, 0.15 > }
                                   }
                  translate < 0, 0, 0.1 >
                       texture { Kol }
                }
#declare Paw =
          union {
                 object { Pad }
                 object { Claw   }
                 object { Claw  rotate -30*y  }
                 object { Claw  rotate 30*y  } 
                 object { Claw  rotate 60*y  } 
                 object { Claw  scale < 1, 1, 0.5 > rotate -100*y  } 
                 translate < 0, 0, 0.1 >
                     scale 0.75
                 }
#declare Lpaw =
          union {
                 object { Pad }
                 object { Claw   }
                 object { Claw  rotate 30*y  }
                 object { Claw  rotate -30*y  } 
                 object { Claw  rotate -60*y  } 
                 object { Claw  rotate 100*y  } 
                 translate < 0, 0, 0.1 >
                      scale 0.75
                 }

                              
#declare Uleg =                    // upper leg
          union {
             cone { < 0, 0, 0 >,0.1,< 0.3, 0, 0 >,0.045 }
             sphere { < 0.3, 0, 0 >,0.045 }  
             sphere { < 0, 0, 0 >,0.075
                      scale < 3, 1, 1 >
                      translate 0.15*x
                    }
                      texture { Kol }
                }
#declare Lleg =                    // lower leg
          union {
             cone { < 0, 0, 0 >,0.045,< 0.3, 0, 0 >,0.03 }
             sphere { < 0.3, 0, 0 >,0.03 }  
             sphere { < 0, 0, 0 >,0.04
                      scale < 3, 1, 1 >
                      translate 0.15*x
                    }
                      rotate 90*y
                      texture { Kol }
                }
#declare Toe =
           union {
                 sphere { < 0, 0, 0 >,0.027 }
                 sphere { < 0, 0, 0 >,0.027 
                           scale < 1, 1, 2 > translate 0.05*z } 
                 sphere { < 0, 0, 0.1 >,0.027 } 
                 cone { < 0, 0, 0.1 >,0.02,< 0, -0.02, 0.15 >,0.005 }
                 translate 0.02*y
                 texture { Kol }  
                 }
#declare Bfoot =                                    // back foot
            union {
                  object { Toe scale < 1, 1, 1.25 > }
                  object { Toe rotate 20*y translate 0.03*x }
                  object { Toe rotate -20*y translate -0.03*x }   
                   }

#declare Rfl =                                // right front leg
             union {
                   object { Uleg scale < 0.75, 0.5, 0.5 > 
                            rotate < 0, 30, -15 >
                            translate < 0.08, 0, 0.35 > }
                   object { Lleg  scale < 0.5, 0.5, 0.8 >
                             rotate < -155, 30, 0 >
                             translate < 0.29, -0.06, 0.225> } 
                   object { Paw rotate 20*y translate < 0.4, -0.2, 0.405 > }  
                   }          
#declare Lfl =                   // left front leg     
           union {
                   object { Uleg scale < 0.75, 0.5, 0.5 > 
                               rotate < 0, 240, 15 >
                               translate < 0, 0, 0.35 > }
                   object { Lleg scale < 0.5, 0.5, 0.8 >
                             rotate < -25, -145, 0 >
                             translate < -0.12, -0.03, 0.58 > } 
                   object { Lpaw rotate -15*y translate < 0.03, -0.2, 0.75 > }  
                   }          
#declare Rbl =                                // right back leg
             union {
                object { Uleg  rotate < 0, -45, 30 >
                              translate < -0.04, 0.05, -0.1 > }
                object { Lleg 
                   rotate < -60, -10, 0 >
                             translate < 0.155, 0.18, 0.13 > } 
                object { Lleg  scale 0.6
                      rotate < -135, 5, 0 >                         //foot
                             translate < 0.19, -0.07, -0.02 > } 
                object { Lleg  scale 0.6  
                      rotate < -135, 20, 0 >                         //foot
                             translate < 0.19, -0.07, -0.02 > } 
                object { Lleg  scale 0.6  
                      rotate < -135, 35, 0 >                         //foot
                             translate < 0.19, -0.07, -0.02 > } 
                object { Bfoot rotate 20*y translate < 0.2, -0.2, 0.08 > }  
                   }          
#declare Lbl =                          //   left back leg
             union {
                   object { Uleg rotate < 0, 195, -15 >
                   translate < 0.03, 0.05, -0.1 > }
                   object { Lleg  
                   rotate < -50, 15, 0 >
                             translate < -0.28, 0.13, -0.015 > } 
                   object { Lleg  scale 0.6                     // foot
                   rotate < -160, 10, 0 >
                             translate < -0.34, -0.1, -0.2 > } 
                   object { Lleg  scale 0.6                     // foot
                   rotate < -160, 20, 0 >
                             translate < -0.34, -0.1, -0.2 > } 
                   object { Lleg  scale 0.6                     // foot
                   rotate < -160, 30, 0 >
                             translate < -0.34, -0.1, -0.2 > }   
                   object { Bfoot rotate < 30, 20, 0 > 
                                translate < -0.35, -0.1, 0 > }
                     
                   }          
#declare Eye =                   
           union {
             sphere { < 0, 0, 0 >,0.025  
                     scale < 1, 1, 0.85 >
                     pigment { color Yellow }
                     finish { ambient 0.4 }
                     }
             sphere { < 0, 0, 0 >,0.026  
                     scale < 1, 1, 0.85 >
                     pigment { color Black }
                     finish { ambient 0 
                              diffuse 0 }
                         clipped_by {
                              cylinder { < 0, 0, -0.1 >,< 0, 0, 0.1 >,0.015 }
                                    }
                     }
                     rotate -10*y 
                 }
#declare Jaws =                   
             union {
              difference {                                    // skull
                           sphere { < 0, 0, 0 >,0.1
                                     scale < 1, 0.3, 0.3 > 
                                  }
                            cylinder { < 0, 0, -0.1 >,< 0, 0, 0.1 >,0.1
                                        scale < 1, 0.3, 1 >
                                        translate < 0.1, -0.035, 0 >
                                        pigment { color Red }
                                        finish { ambient 0.2 }
                                      }
                         }
              difference {                              // bottom jaw
                           sphere { < 0, 0, 0 >,0.1
                                     scale < 1, 0.3, 0.35 > 
                                  }
                            cylinder { < -0.03, 0, 0 >,< 0.2, 0, 0 >,0.1
                                        scale < 1, 0.3, 0.4 >
                                        rotate 10*z
                                        translate 0.013*y
                                        pigment { color Red }
                                        finish { ambient 0.2 }
                                      }
                           rotate -5*z
                           translate   -0.03*y
                         }

              sphere { < 0, 0, 0 >,0.1                         // brow
                        scale < 1, 0.2, 0.43 > 
                        rotate -8*z
                        translate < -0.025, 0.03, 0 >
                     }
              object { Eye translate < -0.025, 0.015, -0.025 > }
              object { Eye translate < -0.025, 0.015, 0.025 > }



              cone { < -0.11, 0, 0 >,0.11,< 0, 0, 0 >,0.08     // neck
                       scale < 1, 0.55, 0.3 >
                   }
                        texture { Kol }
                   }
#declare Dragon =
        union {
         object { Core scale < 2, 1.5, 1.5 > }
         object { Jaws scale 1.7 rotate -35*y 
                   translate   < 0.548, 0, 0.86 > } //< 0.34, 0, 0.625 > }
         object { Rfl  }
         object { Lfl  } 
         object { Rbl translate 0.1*x }
         object { Lbl } 
                translate 0.2*y
              }




object { Dragon scale 0.5 rotate 5*y translate < 13.2, 0, -42.4 > }
object { Dragon scale 0.3 rotate -110*y translate < 14.7, 0, -42.15 > } 

                  // END
 


