// Statue Components

#declare StatueHead=union{
  difference{
    union{
      sphere{<0,.2,0> .8}                                                         // skull
      sphere{<0,-.35,0> .65 scale<1,1,.8>}                                        // chin
      cone{<0,.45,-.041>0 <0,-.35,-.18>.19 scale<.65,1,1.2> translate<0,0,-.45>}  // nose
      cylinder{<0,0,.2> <0,-1.4,.25> .35}                                                                                           // neck
     }
    sphere{<0,0,0> .4 scale<1,.15,1> translate<0,-.55,-.4> scale<1,1,.8>}       // mouth
    sphere{<0,0,0> .164  scale<1.3,1,1> translate<.27,0,-.76>}                  // eye sockets
    sphere{<0,0,0> .164 scale<1.3,1,1> translate<-.27,0,-.76>}
   }
  sphere{<.2,0,-.635> .112 }                                                    // eyes
  sphere{<.2,0,-.6> .092  scale<1,1,1.1>}
  sphere{<-.2,0,-.635> .112 }
  sphere{<-.2,0,-.6> .092 scale <1,1,1.1>}
  scale .3/2
  translate<0,1.8-.15,.02>
 }
 
 #declare StatueHair=difference
 {
  sphere{<0,.2,0> .82}
  sphere{<0,-.2,-.2> .82}
//  normal{bozo .1 scale<.035,.35,.035> turbulence .05}
//  normal{bozo .15 scale<.35,.35,.35> turbulence .01}
  scale .3/2
  translate<0,1.8-.15,.02>
 }
 
 #declare StatueShieldRim=difference{
     intersection{
        cylinder{<0,0,0><0,1,0>.355 }
        box{<.2,.02,-.36><.35,.98,.36> }
    } // intersection
    box{<.19,.06,-.26><.35,.47,.26> }
    box{<.19,.53,-.26><.35,.94,.26> }
    #declare Count=.90
    #while (Count>=.10)
        cylinder{<.19,Count,0><.36,Count,0> .035 }
        #declare Count=Count-.1
    #end
}

#declare StatueShield=union{
     difference{
        union{
             cylinder{<0,0,0><0,1,0> .35  }
             object{StatueShieldRim}
       }
       cylinder{<0,-.1,0><0,1.1,0> .33  }
       box{<-.36,-.1,-.36><.20,1.1,.36> }
     }
    sphere{<.35,.5,0> .075 }                            // shield boss
    cylinder{<.35,.5,0> <.37,.5,0> .077 }
}

#declare StatueArmor=union{
  union{
   cone{<0,.7,0> .35 <0,.25,0> .27 scale <1,1,1.15> } // armor
   cylinder{<0,.28,0><0,.32,0> .29 scale <1,1,1.15> }  // belt
   object{BeltTassles translate<0,.28,-.29>}
   box{<-0.045,.27,-.35><0.045,.33,-.29> }  // buckle
   difference{
     intersection{
         union{
            cylinder{<.1,0,0><.25,0,0> .35 scale<1,.35,1> translate<0,.67,0> }        // shoulder straps
            cylinder{<-.1,0,0><-.25,0,0>.35 scale <1,.35,1> translate<0,.67,0> }

            cylinder{<-.19,-.02,-.36><-.19,-.02,.36>.03 translate<0,.7,0> }
            sphere{<-.19,-.02,-.36> .015 translate<0,.7,0> }
            sphere{<-.19,-.02,.36> .015 translate<0,.7,0> }

            cylinder{<.19,-.02,-.36><.19,-.02,.36>.03 translate<0,.7,0> }
            sphere{<.19,-.02,-.36> .015 translate<0,.7,0> }
            sphere{<.19,-.02,.36> .015 translate<0,.7,0> }
         }
         box{<-.35,.66,-.38><.35,1.06,.38> }
     } // intersection
     cylinder{<-.26,0,0><.26,0,0> .33  scale<1,.35,1> translate<0,.67,0> }
   } // difference
   difference{
     intersection{
         union{
            cylinder{<.2,0,0><.45,0,0> .37 scale<1,.35,1> translate<0,.67,0> }        // shoulder purloins?
            cylinder{<-.2,0,0><-.45,0,0>.37 scale <1,.35,1> translate<0,.67,0> }
         }
         box{<-.55,.72,-.36><.55,1.06,.36> }
     } // intersection
     cylinder{<-.55,0,0><.55,0,0> .35  scale<1,.35,1> translate<0,.67,0> }
   }

  scale<.6,1,.4>
  translate<0,.7,.05>
  }
//  object{ShortSword rotate<0,0,0> rotate<-35,0,0> translate<-.19,.90,.075>}
} // Armor

#declare StatueBody=union
 {
  sphere{<0,0,0> .35 scale<1,.25,1>}
  sphere{<0,0,0> .35 scale<1,.25,1> translate<0,.7,0>}
  cone{<0,.7,0> .35 <0,.3,0> .28}
  cone{<0,-.1,0>,.36 <0,.3,0>.28}
  cone{<0,-.2,0>,.36 <0,.3,0>.28 }
  sphere{<0,0,0> .45 scale<1.23,.21,.6> translate<0,.7,0>}
  scale<.6,1,.4>
  translate<0,.7,.05>
 }
 
 #declare StatueLegs=union
 {
  cone{<-.09,.8,.05>.095 <-.11,.4,0> .058 }
  cone{<-.11,.4,.01>.053 <-.11,.05,.05> .05 }
  sphere{<-.11,.4,0>, .059 }

  cone{<.09,.8,.05>.095 <.11,.4,0> .058 }
  cone{<.11,.4,.01>.053 <.11,.05,.05> .05 }
  sphere{<.11,.4,0>, .059 }

  sphere{<-.11,.05,-.01> .08 scale<1,.6,1.6> }    // Feet
  sphere{<.11,.05,-.01> .08 scale<1,.6,1.6> }
 }

 #declare StatueSpear_Arm=union{
  cone{<0,0,0> .063 <0,(1.4-.85)/2,-0.2> .054   }                    // upper arm
  cone{<0,-.03,.03> .075 <0,(1.4-1.25),-0.1> .068 }                                     // shirt sleeve
  cone{<0,(1.4-.85)/2,-0.2>.06  <0,(1.4-.85),.01>.049  }       // lower arm
  sphere{<0,(1.4-.85)/2,-0.2>.065   }                                        // elbow
  sphere{<0,1.4-.85+.02,.01> .065  }                                                         // hand
//  rotate<-90,0,0> translate<-.26,1.4,.06>  // spin and move the whole arm
}
#declare StatueShield_Arm=union{
  cone{<.26,0,.06>.065 <.26,-.35,.05> .056}            // shield arm
  cone{<.26,.01,.06>.07 <.26,-.15,.05> .066}            // shirt sleeve
  sphere{<.26,-.35,.06> .056}
  cone{<.26,-.35,.06>.056 <.26,-.34,-.3> .049}  // lower arm
  sphere{<.26,-.34,-.31> .065 }                 // hand
}

#declare Statue=union{
  object{Roman_Helmet}
  object{StatueHead}
  object{StatueHair}
  object{StatueBody}
  object{StatueShield_Arm rotate<0,20,0> rotate<0,0,0> translate<0,1.4,0>}                // left arm
//  object{StatueShield rotate<90,0,0> rotate<0,0,80> translate<.1,1,-.73>}  
  object{StatueShield rotate<0,35,0> translate<.1,.05,-.040>}
  object{StatueSpear_Arm  rotate<-80,0,0> translate<-.26,1.4,0>}
//  object{StatueShield_Arm}
  object{StatueArmor}
  object{StatueLegs}
  texture{T_Stone8}
}
