// Persistence of Vision Ray Tracer Scene Description File
// File: abomb.pov
// Vers: 3.1
// Desc: For the IRTC 
// Date: 4/29/99
// Auth: Bob Franke
//

#version 3.1;
#include "colors.inc"

global_settings{
  assumed_gamma 2.2 
}

// ----------------------------------------
camera
{
  location  <0.0,6000, -20000>
  direction 1.5*z
  right     4/3*x
  look_at   <0.0, 6100,  0.0>
} 

 
light_source{
  <0,8000,-4000> color rgb<2,.5,0>/12
  rotate<0,-45,0>
  fade_distance 20000
  fade_power 2
}   

light_source{
  <0,8000,-4000> color rgb<2,.5,0>/12 
  rotate<0,45,0>
  fade_distance 20000
  fade_power 2
}   

light_source{
  <0,8000,-4000> color rgb<2,.5,0>/12
  rotate<0,-45-180,0>
  fade_distance 20000
  fade_power 2
}   

light_source{
  <0,8000,-4000> color rgb<2,.5,0>/12 
  rotate<0,45+180,0>
  fade_distance 20000
  fade_power 2
}   
   

#declare containerTexture =
#ifdef (testing)
	texture {
		pigment { color rgbf<1.3,1.3,1.3,.9> }
		finish { ambient .1 diffuse 0.7 }
	} 
#else
	texture {
		pigment { color rgbf<1,1,1,1> }
		finish { ambient .1 diffuse 0.7 }
	} 
#end 
 
	    
#declare fireBallInt2 =
	interior {
		media {
			emission .0015*.5
	    density { 
        spherical 							
				color_map{
					[0.00 color rgb<0.00,0.00,0.00> ]
					[0.15 color rgb<0.00,0.00,0.00> ]  
					[0.20 color rgb<1,1,.2>]  
					
					[0.25 color rgb<2,.2,0>*.75 ]    
					[0.35 color rgb<2,.2,0>*.75 ]    
					    
					[0.5 color rgb<1,1,.2> ]   
					    
					[0.75 color rgb<2.5,.1,0> ]   
					[0.85 color rgb<2.5,.1,0> ]    

					[1.0 color rgb<1,1,.2>*10 ] 
				}       
    	turbulence .7
			omega 1 
			scale .7
	    }
		}
	}		
	

#declare BigGlowInt =
	interior {
		media {
			emission .0000625*.85/1.5
	    density {  
	      spherical 				
				color_map{
					[0.00 color rgb<0.00,0.00,0.00> ] 
					[1 color rgb<1,.2,0> ] 
				}
	    }
		}
	}	
	

#declare GroundDustInt = 
	interior {
		media {
			scattering { 3, <.01,.01,.01,>/2 extinction 1.0 } 
	    density { spherical
				color_map{
					[0.0 color rgb <0.0,0.0,0.0> ] 
					[0.4 color rgb <0,0,0> ] 
					[1.0 color rgb <1,1,1> ] 
				}
			turbulence .35
			omega .9 
    	}
		}
	}
	   

#declare SmokeInt =
	interior {
		media {
			scattering { 1, <.01,.01,.01,>*1 extinction 1.0 } 
			density { spherical
				color_map{
					[0.0 color rgb <0.0,0.0,0.0> ]
					[0.4 color rgb <0,0,0> ] 
					[1.0 color rgb <1,1,1> ]
				}
			turbulence .85
			omega 0.7
    	}
		}
	}
#declare SmokeInt2 = 
	interior {
		media {
			scattering { 1, <.01,.01,.01,>/2 extinction 1.0 } 
			density { spherical
				color_map{
					[0.0 color rgb <0.0,0.0,0.0> ] 
					[0.4 color rgb <0,0,0>*2 ] 
					[1.0 color rgb <1,1,1>*4 ] 
				}
			turbulence .85
			omega 0.7
    	}
		}
	}
	

#declare SmokeInt3 = 
	interior {
		media {
			scattering { 3, <.01,.01,.01,>*2 extinction 1.0 } 
			density { spherical
				color_map{
					[0.0 color rgb <0.0,0.0,0.0> ]
					[0.4 color rgb <0,0,0> ] 
					[1.0 color rgb <1,1,1>*.8 ] 
				}
			turbulence 1.25
			omega .75 
    	}
		}
	}


#declare columnDustInt =
	interior {
		media {
			scattering { 1, <.01,.01,.01,>*.5 extinction 1.0 } 
	    density {   
	      cylindrical
				color_map{
					[0.0 color rgb <0.0,0.0,0.0> ]
					[0.4 color rgb <0,0,0> ] 
					[1.0 color rgb <1,1,1>*1.5 ]  
				}
			turbulence <1,1,1>
			omega .75 
      scale 625*1.5		
    	}
		}
	}
	
	
#declare columnMaterial =
	material {
		texture {containerTexture  }
		#ifndef (testing) interior {columnDustInt} #end
	} 	
			
#declare smokeMaterial =
	material {
		texture {containerTexture  }
		#ifndef (testing) interior {SmokeInt} #end
	}		
	   
#declare bigGlowMaterial = 
	material {
		texture {containerTexture  }
		#ifndef (testing) interior {BigGlowInt} #end
	}	
       
#declare fireBallMaterial =
	material {
		texture {containerTexture  }
		#ifndef (testing) interior {fireBallInt2} #end
	}
        
        
#declare groundMaterial = 
	material {
		texture {containerTexture  }
		#ifndef (testing) interior {GroundDustInt} #end
	}        
        
#declare groundMaterial2 = 
	material {
		texture {containerTexture  }
		#ifndef (testing) interior {SmokeInt2} #end
	}  
	
#declare groundMaterial3 = 
	material {
		texture {containerTexture  }
		#ifndef (testing) interior {SmokeInt3} #end
	}        
        
        
 #declare Rx = seed(64);
 #declare Ry = seed(765);
 #declare Rz = seed(64028);
   
#macro addFireBall (xx,yy,zz,rot )                       
object{  
  sphere { <0,0,0>,1 
    hollow 
    material { fireBallMaterial } 
    scale 1200   
    rotate<rand(Rx)*360,rand(Ry)*360,rand(Rz)*360> 
    translate<xx,yy,zz>      
    rotate<0,rot,0>
  } 
}
#end


#macro addSmoke (xx,yy,zz )                       
object{  
  sphere { <0,0,0>,.75 
    hollow 
    material {groundMaterial2}
    scale 1000   
    rotate<rand(Rx)*360,rand(Ry)*360,rand(Rz)*360> 
    translate<xx,yy,zz>
  } 
}
#end

#macro addGndSmoke (xx,yy,zz,rot )                       
object{  
  sphere { <0,0,0>,1 
    hollow 
    material { groundMaterial } 
    scale 1000   
    rotate<rand(Rx)*360,rand(Ry)*360,rand(Rz)*360> 
    translate<xx,yy,zz>      
    rotate<0,rot,0>
  } 
}
#end

#macro addGndSmoke2 (xx,yy,zz,rot )                       
object{  
  sphere { <0,0,0>,1 
    hollow 
    material { groundMaterial2 } 
    scale 1000   
    rotate<rand(Rx)*360,rand(Ry)*360,rand(Rz)*360> 
    translate<xx,yy,zz>      
    rotate<0,rot,0>
  } 
}
#end   



#macro addGndSmoke3 (xx,yy,zz,rot )                       
object{  
  sphere { <0,0,0>,1.25 
    hollow 
    material { groundMaterial3 } 
    scale 1000   
    rotate<rand(Rx)*360,rand(Ry)*360,rand(Rz)*360> 
    translate<xx,yy,zz>      
    rotate<0,rot,0>
  } 
}
#end 

#declare column=
object{  
  cylinder{<0,1000,0>,<0,6500,0>,1000}
  hollow 
  material{columnMaterial translate<0,-2300,0>}   
}
                  
  

union{
  addFireBall (500,9900,0,0 ) 
  addFireBall (900,10300,-200,0 ) 
  
  addFireBall (0,9500,0,0 )  
  addFireBall (900,9500,0,0 )  
  addFireBall (-900,9500,0,0 )  
  addFireBall (1700,9300,0,0 )  
  addFireBall (-1800,9600,0,0 )  
  addFireBall (2500,9000,0,0 )  
  addFireBall (-2700,9100,0,0 )  
  addFireBall (2700,8300,0,0 )  
  addFireBall (-2900,8300,0,0 )  
  
  
  addFireBall (0,8500,0,0 ) 
  addFireBall (-800,8500,-200,0 ) 
  addFireBall (800,8500,-300,0 ) 
  addFireBall (-1600,8500,100,0 ) 
  addFireBall (1600,8500,-100,0 ) 
  
  addFireBall (-2600,7500,0,0 ) 
  addFireBall (2600,7500,0,0 ) 
  addFireBall (-2300,6500,0,0 ) 
  addFireBall (2300,6500,0,0 ) 
  
  addFireBall (-1700,7700,200,0 ) 
  addFireBall (1700,7700,100,0 ) 
  
  addFireBall (800,7000,0,0 )  
  addFireBall (-850,7000,0,0 )
  scale .9 
  translate<0,1000,0>
} 
            
                            
#declare yrot=0;
#while (yrot < 360)               
  addGndSmoke2 (0,3100,-4500 ,yrot)
   #declare yrot = yrot + 8;
#end



#declare bigGlow=
object{ 
sphere{<0,0,0>,1 }
  hollow 
  material{bigGlowMaterial} 
  scale 9500
  translate <0,8500,0>         
}

     
#declare Rx = seed(534);
#declare Ry = seed(56875);
#declare Rz = seed(884557);


union{            
  addGndSmoke3 (0,3100,0,0)     
  addGndSmoke3 (0,4300,0,0)   
  addGndSmoke3 (0,5500,0,0)   
  addGndSmoke3 (0,6700,0,0)   
  no_shadow
} 


object{bigGlow scale 1.375} 

#declare Map =
  box{<0.0,0.0,-0.00001>,<1.0,1.0,0.0>
	  texture {
      pigment {image_map{ gif "adam_eve.gif"
                          filter all 1           
                         }
              }
     }  
   }

object{Map scale .75 translate<-.35,5999.58,-19999> no_shadow }

height_field{
  tga              
  "trinity.tga"  
  translate<-.5,0,-.5>  
  rotate<-1.5,-90,0>
  scale<250000,100000*3.5,250000>  
  translate<-7000,-4800,-50000> 
  rotate<0,-125,0>  
  pigment{White*.75}
}     


text{
  ttf             
  "c:\windows\system\arial.ttf",  
  "Original sin begot ultimate sin... July 16, 1945",
  .02,              // the extrusion depth
  0               // inter-character spacing
  scale 350*.9
  translate <-8500,12200,0>
  pigment{White*3}  
  no_shadow
}
            