#version 3.1;

#include "colors.inc"

global_settings
{
  assumed_gamma 2.2
}

// ----------------------------------------
camera
{
  location  <0.0, 0.5, -5.0>
  direction 1.5*z
  right     4/3*x
  look_at   <0.0, -0.25,  0.0>
}

sky_sphere
{
  pigment{White}

}

light_source
{
  0*x // light's position (translated below)
  color red 2.0  green 2.0  blue 2.0  // light's color
  translate <-2, 10, -30>
}

// ----------------------------------------


#declare apple=
union{
  lathe {
//    linear_spline // linear_spline | quadratic_spline | cubic_spline
//     quadratic_spline                                                 
     cubic_spline
     20, // number of points
    <55-55,16>
    <63-55,15>
    <72-55,12>
    <77-55,11>
    <84-55,13>
    <90-55,17>
    <98-55,27>
    <102-55,36>
    <104-55,47>
    <105-55,58>
    <101-55,69>
    <99-55,77>
    <96-55,87>
    <95-55,95>
    <91-55,105>
    <88-55,113>
    <80-55,119>
    <71-55,122>
    <63-55,121>
    <55-55,121>    
  }
  object{
    torus{50,3 rotate<90,0,0> }
    clipped_by{plane{x,0}}
    clipped_by{plane{y,15 }}
    rotate<0,0,-15> 
    translate<45,30,0>
  }      
}  




#include "eve.inc" 
union{
  object{eve scale 9 rotate<0,90,0>} 
  object{apple scale <.0028*1.15,.0028,.0028>  rotate<180,0,0>  
         translate<-.1,.51,.2> translate<.67,.53,0> 
         pigment{White*.75}
         finish{ambient 0.7 diffuse 0.2}
       } 
  rotate<0,-5,0>    
  translate<-.7,-.6,0>
}  

#include "adam.inc"
object{adam scale 10 rotate<0,-90,0> translate<.40,-.5,0>}  

