//Bleriot.pov   march / april 1999        Ian and Ethel MacKay

#include "colors.inc"     

background { color rgb < 0.2, 0.2, 1 > } 
camera {
        location < -12, 39, -16 >
        look_at < -8.5, 41, 4 >
        angle 28
        }

light_source { < -1000, 1000, -1000 > color White }    // SUN

plane { y, -10                                     // SEA
      pigment { color rgb < 0.35, 0.35, 0.5 > }
      normal { wrinkles scale 5 }
      finish { ambient 0.3
               reflection 0.2
               phong 1 
             }       
     }
plane { y, -9.99                                 // SEA FOAM
      pigment { 
               bozo
               turbulence 1
               color_map {
                         [ 0.0  color rgb < 0.8, 0.8, 1 > ]
                         [ 0.05  color rgb < 0.8, 0.8, 1 > ]
                         [ 0.1 color Clear ]
                         [ 1.0 color Clear ]
                          } 
               scale 5
              }            
     finish { ambient 0.25 }         
     }
plane { y, 60                                // CLOUD
      pigment { 
               wrinkles
               turbulence 0.2
               color_map {
                         [ 0.0 color Clear ] 
                         [ 0.4  color rgb < 0.8, 0.8, 1 > ]
                         [ 0.45  color rgb < 0.8, 0.8, 1 > ]
                         [ 0.5  color rgb < 0.8, 0.8, 1 > ]  
                         [ 0.6 color Clear ]
                         [ 1.0 color Clear ] 
                          } 
               scale < 40, 1, 60 >
              }            
     finish { ambient 0.35 }         
     clipped_by {
               box { < -500, 10, -200 >,< 500, 100, 800 > }
                }
                translate 20*z 
     }


sphere { < 0, 0, 0 >,1                    // SKY
         pigment {
                  gradient y
                  color_map {
                            [ 0.0 color rgb < 0.25, 0.2, 0.3 > ]
                            [ 0.05 color Gray20 ]   
                            [ 0.4 color rgb < 0.65, 0.5, 1 > ]
                            [ 1.0 color rgb < 0.9, 0.9, 1.0 > ] 
                            }
                   }
         finish { ambient 0.8 }
         scale 10000   
      }

// BLERIOT'S XI monoplane

// FLYING SURFACES

#declare Rib =         // Wing Rib ( chord 6.3  )
           union {
                 torus { 2.25, 0.05
                       rotate 90*x
                       scale < 1, 0.65, 1 >
                       clipped_by {
                                     box { < -3, 0.5, -1 >,< 0, 2, 1 > }
                                  }
                       }
                 torus { 6, 0.05
                       rotate 90*x
                       scale < 1, 0.58, 1 >
                       translate -2.015*y
                       clipped_by {
                                     box { < 0, 0.5, -1 >,< 6, 2, 1 > }
                                  }  
                       }
                     pigment { color Tan }
                     finish { ambient 0.2 }
                 }
#declare Fabric =
             texture {
                     pigment { color rgbt < 1, 0.8, 0.3, 0.02 > }
                     finish { ambient 0.25 }
                     }
#declare Lefttip = 
          union {  
triangle { < -2.1, 0, 0 >,< -1.8, 0.45, 0 >,< -1.5, 0, -2 > }     
triangle { < -1.8, 0.45, 0 >,< -1.5, 0.65, 0 >,< -1.5, 0, -2 > }   
triangle { < -1.5, 0.65, 0 >,< -1.5, 0, -2 >,< -1, 0.85, 0 > }  
triangle { < -1.5, 0, -2 >,< -1, 0.85, 0 >,< -1, 0, -2.72 > } 
triangle { < -0.5, 0.94, 0 >,< -1, 0.85, 0 >,< -1, 0, -2.72 > }    
triangle { < -0.5, 0.94, 0 >,< -0.5, 0, -3.06 >,< -1, 0, -2.72 > }  
triangle { < -0.5, 0.94, 0 >,< -0.5, 0, -3.06 >,< 0, 0.97, 0 > }  
triangle { < 0, 0, -3.2 >,< -0.5, 0, -3.06 >,< 0, 0.97, 0 > }  
triangle { < 1, 0.93, 0 >,< 0, 0, -3.24 >,< 0, 0.97, 0 > }    
triangle { < 1, 0.93, 0 >,< 0, 0, -3.24 >,< 1, 0, -3.04 > }   
triangle { < 1, 0.93, 0 >,< 2, 0.77, 0 >,< 1, 0, -3.04 > } 
triangle { < 2, 0, -2.5 >,< 2, 0.77, 0 >,< 1, 0, -3.04 > }   
triangle { < 3, 0.5, 0 >,< 2, 0.77, 0 >,< 2, 0, -2.5 > }   
triangle { < 3, 0.5, 0 >,< 2, 0, -2.55 >,< 3, 0, -1.63 > }  
triangle { < 3, 0.5, 0 >,< 4.1, 0, 0 >,< 3, 0, -1.63 > }  

object { Rib 
            translate -0.5*y
            rotate -90*x
            scale < 1, 1, 3.3 >
       }
       texture { Fabric } 
     }



#declare Righttip = 
          union {  
triangle { < -2.1, 0, 0 >,< -1.8, 0.45, 0 >,< -1.5, 0, 2 > }     
triangle { < -1.8, 0.45, 0 >,< -1.5, 0.65, 0 >,< -1.5, 0, 2 > }    
triangle { < -1.5, 0.65, 0 >,< -1.5, 0, 2 >,< -1, 0.85, 0 > } 
triangle { < -1.5, 0, 2 >,< -1, 0.85, 0 >,< -1, 0, 2.72 > }  
triangle { < -0.5, 0.94, 0 >,< -1, 0.85, 0 >,< -1, 0, 2.72 > }    
triangle { < -0.5, 0.94, 0 >,< -0.5, 0, 3.06 >,< -1, 0, 2.72 > }  
triangle { < -0.5, 0.94, 0 >,< -0.5, 0, 3.06 >,< 0, 0.97, 0 > }  
triangle { < 0, 0, 3.25 >,< -0.5, 0, 3.11 >,< 0, 0.97, 0 > }  
triangle { < 1, 0.93, 0 >,< 0, 0, 3.25 >,< 0, 0.97, 0 > }   
triangle { < 1, 0.93, 0 >,< 0, 0, 3.25 >,< 1, 0, 3.04 > }  
triangle { < 1, 0.93, 0 >,< 2, 0.77, 0 >,< 1, 0, 3.04 > } 
triangle { < 2, 0, 2.55 >,< 2, 0.77, 0 >,< 1, 0, 3.04 > }   
triangle { < 3, 0.5, 0 >,< 2, 0.77, 0 >,< 2, 0, 2.5 > }   
triangle { < 3, 0.5, 0 >,< 2, 0, 2.55 >,< 3, 0, 1.63 > }  
triangle { < 3, 0.5, 0 >,< 4.1, 0, 0 >,< 3, 0, 1.63 > }  

object { Rib 
            translate -0.5*y
            rotate 90*x
            scale < 1, 1, 3.3 >
       }
       texture { Fabric } 
     }

#declare Skin =         // Wing Fabric  Main Wing
           union {
                 cylinder { < 0, 0.05, 0 >,< 0, 0.05, 9 >,2.25 open
                       scale < 1, 0.65, 1 >
                       clipped_by {
                                     box { < -3, 0.5, -1 >,< 0, 2, 10 > }
                                  }
                       }
                 cylinder { < 0, 0.05, 0 >,< 0, 0.05, 9 >,6   open   
                       scale < 1, 0.58, 1 >
                       translate -2.015*y
                       clipped_by {
                                     box { < 0, 0.5, -1 >,< 6, 2, 10 > }
                                  }  
                       }
                     texture { Fabric }
                 }
#declare Spot =
              sphere { < 0, 0, 0 >,0.1
                        scale < 1, 0.15, 1 >
                     pigment { color Red }
                     }
#declare Top =           // Main section of wing
             union {
                     object { Skin }
                     object { Rib } 
                     object { Rib translate 1*z } 
                     object { Rib translate 2*z } 
                     object { Rib translate 3*z } 
                     object { Rib translate 4*z } 
                     object { Rib translate 5*z } 
                     object { Rib translate 6*z } 
                     object { Rib translate 7*z } 
                     object { Rib translate 8*z } 
                     object { Rib translate 9*z } 
                    
                     cylinder { < -2.1, 0.5, 0 >,< -2.1, 0.5, 9 >,0.05 
                                pigment { color Tan }
                                finish { ambient 0.2 }
                               }
                     cylinder { < 4.2, 0.5, 0 >,< 4.2, 0.5, 9 >,0.05 
                                pigment { color Tan }
                                finish { ambient 0.2 }
                               }
                     }
#declare Rwing =
          union {
                 object { Top }
                 object { Righttip rotate -5*x translate < 0, 0.5, 9 > }
                 object { Spot translate < -1, 1.32, 5 > }  
                 object { Spot translate < -1, 1.32, 9 > }  
                 object { Spot translate < 2, 1.28, 5 > }  
                 object { Spot translate < 2, 1.28, 9 > }  
                }
#declare Lwing =
          union {
                 object { Top }
                 object { Lefttip rotate 5*x translate < 0, 0.5, 0 > } 
                 object { Spot translate < -1, 1.32, 0 > }  
                 object { Spot translate < -1, 1.32, 4 > }  
                 object { Spot translate < 2, 1.28, 0 > }  
                 object { Spot translate < 2, 1.28, 4 > }  
                }


#declare Stab =           // tailplane
         union {
                object { Rwing translate -1.25*z }
                object { Lwing translate -9*z }
                    scale < 0.45, 0.2, 0.45 >
                }
      
#declare Stays =
           union {
cylinder { < 16.5, 1.1, -0.1 >,< 16.5, -0.38, -3.2 >,0.03 }    // stab stays
cylinder { < 16.5, 1.1, -0.1 >,< 18, -0.54, -3.2 >,0.03 }
cylinder { < 16.5, 1.1, 0.1 >,< 16.5, -0.38, 3.2 >,0.03 }    // stab stays
cylinder { < 16.5, 1.1, 0.1 >,< 18, -0.54, 3.2 >,0.03 }  
                   pigment { color Tan }
                   finish { ambient 0.2 }
                 }


//FUSELAGE

#declare Long =             // longeron
             box { < -3.3, -0.04, -0.04 >,< 4.8, 0.04, 0.04 >
                   pigment { color Tan }
                   finish { ambient 0.2 }
                 }

#declare Tlong =             // longeron - tail section
             box { < 0, -0.04, -0.04 >,< 14.2, 0.04, 0.04 >
                   pigment { color Tan }
                   finish { ambient 0.2 }
                 }

#declare Cross =             // fuselage framing  - vert
             box { < -0.04, 0, -0.04 >,< 0.04, 1, 0.04 >
                   pigment { color Tan }
                   finish { ambient 0.2 }
                 }
#declare Across =             // fuselage framing    - horos
             box { < -0.04, -0.04, -0.5 >,< 0.04, 0.04, 0.5 >
                   pigment { color Tan }
                   finish { ambient 0.2 }
                 }



// Fabric
#declare Cover =
     union {
triangle { < -1, 1.66, 1.25 >,< -1, -1, 1.25 >,< 4.8, -1, 1.25 >
          texture { Fabric }
          texture {
                  pigment { 
                        gradient y
                        turbulence 0.3
                               color_map {
                                  [ 0.0 color rgbt < 0.3, 0.3, 0.3, 0.86 > ]      
                                  [ 0.1 color  rgbt < 0.3, 0.3, 0.3, 0.86 > ]
                                  [ 0.2 color Clear ]
                                  [ 0.7 color Clear ]
                                  [ 0.75 color  rgbt < 0.3, 0.3, 0.3, 0.86 > ]      
                                  [ 0.8 color  rgbt < 0.3, 0.3, 0.3, 0.86 > ]
                                  [ 0.85 color Clear ]
                                  [ 1.0 color Clear ]
                                           }
                             translate 0.5*y
                           }
                   finish { ambient 0.2 }
                   }

         }
triangle { < -1, 1.66, 1.25 >,< 4.8, -1, 1.25 >,< 4.8, 1.66, 1.25 >
          texture { Fabric }
         }
triangle { < -1, 1.66, -1.25 >,< -1, -1, -1.25 >,< 4.8, -1, -1.25 >
          texture { Fabric }
          texture {
                  pigment { 
                        gradient y
                        turbulence 0.3
                               color_map {
                                  [ 0.0 color rgbt < 0.3, 0.3, 0.3, 0.86 > ]      
                                  [ 0.1 color  rgbt < 0.3, 0.3, 0.3, 0.86 > ]
                                  [ 0.2 color Clear ]
                                  [ 0.7 color Clear ]
                                  [ 0.75 color  rgbt < 0.3, 0.3, 0.3, 0.86 > ]      
                                  [ 0.8 color  rgbt < 0.3, 0.3, 0.3, 0.86 > ]
                                  [ 0.85 color Clear ]
                                  [ 1.0 color Clear ]
                                           }
                           }
                   finish { ambient 0.2 }
                   }

         }
triangle { < -1, 1.66, -1.25 >,< 4.8, -1, -1.25 >,< 4.8, 1.66, -1.25 >
          texture { Fabric }
         }
triangle { < -2, -1, 1.25 >,< -2, -1, -1.25 >,< 4.8, -1, 1.25 >
          texture { Fabric }
         }
triangle { < -2, -1, -1.25 >,< 4.8, -1, -1.25 >,< 4.8, -1, 1.25 >
          texture { Fabric }       
         }
         }
#declare Frame =       // frame holding landing wires
          union {
                 cylinder { < -1, 1.66, -1.25 >,< -1, 3.66, 0 >,0.03 }
                 cylinder { < -1, 1.66, 1.25 >,< -1, 3.66, 0 >,0.03 }  
                 cylinder { < 2, 1.66, -1.25 >,< 2, 3.66, 0 >,0.03 }  
                 cylinder { < 2, 1.66, 1.25 >,< 2, 3.66, 0 >,0.03 }  
                 cylinder { < -1, 3.66, 0 >,< 2, 3.66, 0 >,0.03 }  
           pigment { color Tan }
           finish { ambient 0.2 }
                }
#declare Landwir =             // landing wires
             union {
                   cylinder { < -1, 3.66, 0 >,< -0.7, 1.67, 6.25 >,0.008 }
                   cylinder { < -1, 3.66, 0 >,< -0.7, 1.8, 10.25 >,0.008 }
                   cylinder { < -1, 3.66, 0 >,< -0.7, 1.67, -6.25 >,0.008 } 
                   cylinder { < -1, 3.66, 0 >,< -0.7, 1.8, -10.25 >,0.008 } 
                   cylinder { < 2, 3.66, 0 >,< 2.3, 1.07, 6.25 >,0.008 }
                   cylinder { < 2, 3.66, 0 >,< 2.3, 1.17, 10.25 >,0.008 }
                   cylinder { < 2, 3.66, 0 >,< 2.3, 1.07, -6.25 >,0.008 } 
                   cylinder { < 2, 3.66, 0 >,< 2.3, 1.17, -10.25 >,0.008 } 

                   pigment { color Gray75 }
                   finish { ambient 0.2
                            phong 1
                          }
                   }
#declare Flywir =             // flying wires
             union {
                   cylinder { < 2, -3, 0 >,< -0.7, 1.67, 6.25 >,0.008 }
                   cylinder { < 2, -3, 0 >,< -0.7, 1.8, 10.25 >,0.008 }
                   cylinder { < 2, -3, 0 >,< -0.7, 1.67, -6.25 >,0.008 } 
                   cylinder { < 2, -3, 0 >,< -0.7, 1.8, -10.25 >,0.008 } 
                   cylinder { < 2, -3, 0 >,< 2.3, 1.07, 6.25 >,0.008 }
                   cylinder { < 2, -3, 0 >,< 2.3, 1.17, 10.25 >,0.008 }
                   cylinder { < 2, -3, 0 >,< 2.3, 1.07, -6.25 >,0.008 } 
                   cylinder { < 2, -3, 0 >,< 2.3, 1.17, -10.25 >,0.008 } 

                   pigment { color Gray75 }
                   finish { ambient 0.2
                            phong 1
                          }
                   }


#declare Bframe =       // frame holding flying wires
          union {
                 cylinder { < 1, -1, -1.25 >,< 2, -3, 0 >,0.03 }
                 cylinder { < 1, -1, 1.25 >,< 2, -3, 0 >,0.03 }  
                 cylinder { < 3, -1, -1.25 >,< 2, -3, 0 >,0.03 }  
                 cylinder { < 3, -1, 1.25 >,< 2, -3, 0 >,0.03 }  
                  
           pigment { color Tan }
           finish { ambient 0.2 }
                }


#declare Fuzz =
      union {

object { Cross  scale < 1, 2.7, 1 > translate < -1, -1, 1.21 > }     
object { Cross  scale < 1, 2.7, 1 > translate < -1, -1, -1.21 > }
object { Across  scale < 1, 1, 2.5 > translate < -1, 1.66, 0 > }    
object { Across  scale < 1, 1, 2.5 > translate < -1, -0.96, 0 > }


object { Cross  scale < 1, 2.7, 1 > translate < 1, -1, 1.21 > }      
object { Cross  scale < 1, 2.7, 1 > translate < 1, -1, -1.21 > }
object { Across  scale < 1, 1, 2.5 > translate < 1, 1.66, 0 > }     
object { Across  scale < 1, 1, 2.5 > translate < 1, -0.96, 0 > }


object { Cross  scale < 1, 2.7, 1 > translate < 2, -1, 1.21 > }     
object { Cross  scale < 1, 2.7, 1 > translate < 2, -1, -1.21 > }
object { Across  scale < 1, 1, 2.5 > translate < 2, 1.66, 0 > }      
object { Across  scale < 1, 1, 2.5 > translate < 2, -0.96, 0 > }


object { Cross  scale < 1, 2.7, 1 > translate < 3, -1, 1.21 > }    
object { Cross  scale < 1, 2.7, 1 > translate < 3, -1, -1.21 > }

object { Cross  scale < 1, 2.7, 1 > translate < 4.8, -1, 1.21 > }   
object { Cross  scale < 1, 2.7, 1 > translate < 4.8, -1, -1.21 > }
object { Across  scale < 1, 1, 2.5 > translate < 4.8, 1.66, 0 > }    
object { Across  scale < 1, 1, 2.5 > translate < 4.8, -0.96, 0 > }


object { Cross  scale < 1, 2.4, 1 > translate < 7.3, -0.8, 1 > }    
object { Cross  scale < 1, 2.4, 1 > translate < 7.3, -0.8, -1 > }
object { Across  scale < 1, 1, 2 > translate < 7.3, 1.55, 0 > }     
object { Across  scale < 1, 1, 2 > translate < 7.3, -0.86, 0 > }

// FABRIC

triangle { < 4.8, 1.66, 1.25 >,< 4.8, -1, 1.25 >,< 10, 1.5, 0.82 >      
          texture { Fabric }
         }
triangle { < 4.8, -1, 1.25 >,< 10, -0.7, 0.82 >,< 10, 1.5, 0.82 >        
          texture { Fabric }
         }
triangle { < 4.8, 1.66, -1.25 >,< 4.8, -1, -1.25 >,< 10, 1.5, -0.82 >    
          texture { Fabric }
         }
triangle { < 4.8, -1, -1.25 >,< 10, -0.7, -0.82 >,< 10, 1.5, -0.82 >    
          texture { Fabric }
         }
triangle { < 4.8, -1, 1.25 >,< 4.8, -1, -1.25 >,< 10, -0.7, 0.82 >   
          texture { Fabric }
         }
triangle { < 4.8, -1, -1.25 >,< 10, -0.7, 0.82 >,< 10, -0.7, -0.82 >   
          texture { Fabric }
         }

object { Cross  scale < 1, 2.1, 1 > translate < 10, -0.7, 0.78 > }    
object { Cross  scale < 1, 2.1, 1 > translate < 10, -0.7, -0.78 > }
object { Across  scale < 1, 1, 1.56 > translate < 10, 1.4, 0 > }   
object { Across  scale < 1, 1, 1.56 > translate < 10, -0.7, 0 > }


object { Cross  scale < 1, 1.9, 1 > translate < 12.5, -0.6, 0.53 > }   
object { Cross  scale < 1, 1.9, 1 > translate < 12.5, -0.6, -0.53 > }
object { Across  scale < 1, 1, 1.1 > translate < 12.5, 1.3, 0 > }   
object { Across  scale < 1, 1, 1.1 > translate < 12.5, -0.5, 0 > }


object { Cross  scale < 1, 1.7, 1 > translate < 14.5, -0.45, 0.35 > }     
object { Cross  scale < 1, 1.7, 1 > translate < 14.5, -0.45, -0.35 > }
object { Across  scale < 1, 1, 0.8 > translate < 14.5, 1.2, 0 > }     
object { Across  scale < 1, 1, 0.8 > translate < 14.5, -0.4, 0 > }     


object { Cross  scale < 1, 1.5, 1 > translate < 16.5, -0.35, 0.1 > }    
object { Cross  scale < 1, 1.5, 1 > translate < 16.5, -0.35, -0.1 > }
object { Across  scale < 1, 1, 0.53 > translate < 16.5, 1.1, 0 > }    
object { Across  scale < 1, 1, 0.53 > translate < 16.5, -0.3, 0 > }
          }
#declare Tailwir =
        union {
             cylinder { < 19, -0.2, 0 >,< 19, 1, 0 >,0.06 }
             cylinder { < 10, 1.4, 0.78 >,< 12.5, -0.5, 0.53 >,0.008 }
             cylinder { < 10, -0.7, 0.78 >,< 12.5, 1.3, 0.53 >,0.008 }
             cylinder { < 10, 1.4, -0.78 >,< 12.5, -0.5, 0.53 >,0.008 }
             cylinder { < 10, -0.7, -0.78 >,< 12.5, 1.3, 0.53 >,0.008 }

             cylinder { < 12.5, -0.5, 0.53 >,< 14.5, 1.2, 0.35 >,0.008 }
             cylinder { < 12.5, 1.3, 0.53 >,< 14.5, -0.4, 0.35 >,0.008 } 
             cylinder { < 12.5, -0.5, -0.53 >,< 14.5, 1.2, -0.35 >,0.008 } 
             cylinder { < 12.5, 1.3, -0.53 >,< 14.5, -0.4, -0.35 >,0.008 } 

             cylinder { < 14.5, 1.2, 0.35 >,< 16.5, -0.3, 0.1 >,0.008 } 
             cylinder { < 14.5, -0.4, 0.35 >,< 16.5, 1.1, 0.1 >,0.008 }
             cylinder { < 14.5, 1.2, -0.35 >,< 16.5, -0.3, -0.1 >,0.008 }
             cylinder { < 14.5, -0.4, -0.35 >,< 16.5, 1.1, -0.1 >,0.008 }

             cylinder { < 16.5, -0.3, 0.1 >,< 19, 1, 0 >,0.008 }  
             cylinder { < 16.5, 1.1, 0.1 >,< 19, -0.2, 0 >,0.008 }  
             cylinder { < 16.5, -0.3, -0.1 >,< 19, 1, 0 >,0.008 }  
             cylinder { < 16.5, 1.1, -0.1 >,< 19, -0.2, 0 >,0.008 }  
                   pigment { color Gray75 }
                   finish { ambient 0.2
                            phong 1
                          }
                   }
             
#declare Collar =                          // around cockpit
             torus { 1.2, 0.1
                     scale < 1.15, 1, 1 >
                     translate < 3.4, 1.66, 0 >
                     pigment { color rgb < 0.8, 0.8, 0.4 > }
                     finish { ambient 0.2 }
                   }


#declare Fin =                           // tailfin
            union {
                  box { < 0, 0, -0.04 >,< 1.5, 1, 0.04 > }
                  box { < 0, 1, -0.04 >,< 2, 2, 0.04 > } 
                  box { < 0, 2, -0.04 >,< 1.5, 3, 0.04 > } 
                  box { < 0, 0, -0.04 >,< 1, 0.5, 0.04 > 
                        rotate 50*z 
                        translate < -0.58, 1.38, 0 > 
                       }
                  cylinder { < 0, 0, -0.04 >,< 0, 0, 0.04 >,0.5
                            scale < 1, 2, 1 >
                            translate < 1.5, 1, 0 >
                           }
                  cylinder { < 0, 0, -0.04 >,< 0, 0, 0.04 >,0.5
                            scale < 1, 2, 1 >
                            translate < 1.5, 2, 0 >
                           }
                  cylinder { < 0, 0, -0.04 >,< 0, 0, 0.04 >,0.5    
                            scale < 1, 1.8, 1 >
                            translate < 0, 2.1, 0 >
                           }
                  cylinder { < 0, 0, -0.04 >,< 0, 0, 0.04 >,0.5 
                            clipped_by {
                                        box { < -1, 0, -1 >,< 1, 1, 1 > }
                                       }
                            translate < -0.6, 1.4, 0 >
                           }
                  object { Cross scale < 1, 3, 1 >  }
                  object { Cross scale < 1, 3, 1 >  translate 1.5*x } 
                  object { Cross scale < 1, 1.5, 1 >
                                 rotate -90*z
                         }
                  object { Cross scale < 1, 2, 1 >
                                 rotate -90*z
                                 translate 1*y
                         }
                  object { Cross scale < 1, 2.5, 1 >
                                 rotate -90*z
                                 translate < -0.5, 2, 0 >
                         }

                  object { Cross scale < 1, 1.5, 1 >
                                 rotate -90*z
                                 translate 2.96*y
                         }
                  texture { Fabric }
              }


#declare Tank =                               // fuel tank
         union {
                cylinder { < 5, 0.5, 0 >,< 11, 0.5, 0 >,0.5 }
                cone { < 5, 0.5, 0 >,0.5, < 4, 0.5, 0 >,0.0 }
                cone { < 11, 0.5, 0 >,0.5, < 12, 0.5, 0 >,0.0 }   
                   pigment { color Gray80 }
                   finish { ambient 0.3 
                            reflection 0.2
                            phong 1
                            phong_size 75
                          }
               }


// Wheel

#declare Rspokes =
            union {
                   cylinder { < -0.19, 0.25, 0 >,< -0.19, 0, 1 >,0.01 }
                   cylinder { < 0.19, 0.25, 0 >,< 0.19, 0, 1 >,0.01 } 
                       pigment { color Gray85 }
                       finish { ambient 0.2 }
                      }
#declare Lspokes =
            union {
                   cylinder { < -0.19, -0.25, 0 >,< -0.19, 0, 1 >,0.01 }
                   cylinder { < 0.19, -0.25, 0 >,< 0.19, 0, 1 >,0.01 } 
                       pigment { color Gray85 }
                       finish { ambient 0.2 }
                      }

#declare Rnet =
             union {
                   object { Rspokes }
                   object { Rspokes rotate 45*y }
                   object { Rspokes rotate 90*y }  
                   object { Rspokes rotate 135*y }
                   object { Rspokes rotate 180*y }  
                   object { Rspokes rotate -45*y }
                   object { Rspokes rotate -90*y }  
                   object { Rspokes rotate -135*y }
                   object { Rspokes rotate -180*y }
                   }
#declare Lnet =
             union {
                   object { Lspokes rotate 22.5*y}
                   object { Lspokes rotate 67.5*y }
                   object { Lspokes rotate 112.5*y }  
                   object { Lspokes rotate 157.5*y }
                   object { Lspokes rotate 202.5*y }  
                   object { Lspokes rotate -67.5*y }
                   object { Lspokes rotate -112.5*y }  
                   object { Lspokes rotate -157.5*y }
                   object { Lspokes rotate -202.5*y }
                   }
#declare Net =
            union {
                  object { Rnet }
                  object { Lnet }
                  }
#declare Wheel =         
           union {
                torus { 1.12, 0.1                      // tyre
                       pigment { color Gray35 }
                       finish { ambient 0.2 }
                      }
                torus { 1.02, 0.075                     // rim
                       pigment { color Gray85 }
                       finish { ambient 0.2 }
                      }
                cylinder { < 0, -0.25, 0 >,< 0, 0.25, 0 >,0.12 }  // hub
                cylinder { < 0, -0.25, 0 >,< 0, -0.24, 0 >,0.2 }  // hub  
                cylinder { < 0, 0.25, 0 >,< 0, 0.24, 0 >,0.2 }  // hub  
                object { Net }
                       pigment { color Gray85 }
                       finish { ambient 0.2 }  
                       rotate 90*x
                  }

#declare Fork =                           // wheel forks
              union {
                    torus { 0.25, 0.04
                        clipped_by {
                              box { < 0, -0.1, -0.3 >,< 0.3, 0.1, 0.3 > }
                                   }
                        translate 1.12*x
                           }
                   cylinder { < 0, 0, -0.25 >,< 1.12, 0, -0.25 >,0.04 }
                    cylinder { < 0, 0, 0.25 >,< 1.12, 0, 0.25 >,0.04 }
                    pigment { Gray85 }
                    finish { ambient 0.2 }
                  }
#declare Afork =
          union {
             object { Fork }
             cylinder { < 1.37, 0, 0 >,< 4, 0, 0 >,0.04 }  
                    pigment { Gray85 }
                    finish { ambient 0.2 }
               }
#declare Runnr =
            union {
                 cylinder { < 0, 0, 0 >,< 0, 0.1, 0 >,0.16  }     
                 cylinder { < -0.15, -0.05, 0 >,< -0.15, 0.1, 0 >,0.05 }      
                 cylinder { < 0.15, -0.05, 0 >,< 0.15, 0.1, 0 >,0.05   }   
                 cylinder { < 0.175, 0.05, 0.1 >,< 0.175, 0.05, -0.1 >,0.05 }    
                       pigment { color Gray65 }
                       finish { ambient 0.2 }
                      }

#declare Wassmb =
union {                   // main wheel assemblies
object { Afork  rotate 110*z  translate < -1.25, -3.6, -2.5 > }    // l main
object { Wheel translate < -1.25, -3.6, -2.5 > }     // l main
object { Afork  rotate 110*z translate < -1.25, -3.6, 2.5 > }      // r main
object { Wheel translate < -1.25, -3.6, 2.5 > }      // r main
cylinder { < -1.25, -3.6, 2.5 >,< -1.25, -3.6, -2.5 >,0.03   // axle 
                       pigment { color Gray35 }
                       finish { ambient 0.2 }
                      }  
cylinder { < -2.8, -3, -1.12 >,< -0.2, 1.8, -10.25 >,0.005                       
            pigment { color Gray75 }
            finish { ambient 0.2 
                     phong 1 
                   }
         }
cylinder { < -2.8, -3, -1.12 >,< -0.2, 1.8, -6.25 >,0.005                       
            pigment { color Gray75 }
            finish { ambient 0.2 
                     phong 1 
                   }   
         }
cylinder { < -2.8, -3, 1.12 >,< -0.2, 1.8, 10.25 >,0.005                       
            pigment { color Gray75 }
            finish { ambient 0.2 
                     phong 1 
                   }
         }
cylinder { < -2.8, -3, 1.12 >,< -0.2, 1.8, 6.25 >,0.005                       
            pigment { color Gray75 }
            finish { ambient 0.2 
                     phong 1 
                   }
         }      

object { Fork rotate 165*z translate < -1.25, -3.6, -2.5 > }  // main
object { Fork rotate 165*z translate < -1.25, -3.6, 2.5 > }   // main
object { Cross  scale < 3.2, 4.66, 1 > translate < -2.8, -3, 1.21 > } //u/c 
object { Cross  scale < 3.2, 4.66, 1 > translate < -2.8, -3, -1.21 > } //u/c
object { Across  scale < 3.2, 1, 5.5 > translate < -2.8, 1.66, 0 > }  // u/c   
object { Across  scale < 3.2, 1, 5.5 > translate < -2.8, -3, 0 > } // u/c

cylinder { < -2.8, 1.66, 2.5 >,< -2.8, -3.5, 2.5 >,0.065      // spring-       
                       pigment { color Gray85 }               // -guide
                       finish { ambient 0.2 }
                      }

cylinder { < -2.8, 1.66, -2.5 >,< -2.8, -3.5, -2.5 >,0.065      // spring-   
                       pigment { color Gray85 }                 // -guide
                       finish { ambient 0.2 }
                      }
cylinder { < -2.65, 0, -2.5 >,< -2.65, -3, -2.5 >,0.03      // bungee      
                       pigment { color Gray45 }
                       finish { ambient 0.2 }
                      }

cylinder { < -2.95, 0, -2.5 >,< -2.95, -3, -2.5 >,0.03      // bungee  
                       pigment { color Gray45 }
                       finish { ambient 0.2 }
                      }
cylinder { < -2.65, 0, 2.5 >,< -2.65, -3, 2.5 >,0.03      // bungee      
                       pigment { color Gray45 }
                       finish { ambient 0.2 }
                      }

cylinder { < -2.95, 0, 2.5 >,< -2.95, -3, 2.5 >,0.03      // bungee  
                       pigment { color Gray45 }
                       finish { ambient 0.2 }
                      }

object { Runnr translate < -2.8, 0, 2.5 > }
object { Runnr translate < -2.8, 0, -2.5 > }  
object { Runnr translate < -2.8, -3.15, 2.5 > }  
object { Runnr translate < -2.8, -3.15, -2.5 > }  
cylinder { < -2.8, 1.4, -2.5 >,< -2.8, 1.6, -2.5 >,0.17      // spring r  
                       pigment { color Gray45 }
                       finish { ambient 0.2 }
                      }
cylinder { < -2.8, 1.4, 2.5 >,< -2.8, 1.6, 2.5 >,0.17      // spring r  
                       pigment { color Gray45 }
                       finish { ambient 0.2 }
                      }

cylinder { < -2.8, -3, 1.12 >,< -0.5, -1, 1.12 >,0.05      // stay  
                       pigment { color Gray35 }
                       finish { ambient 0.2 }
                      }
cylinder { < -2.8, -3, -1.12 >,< -0.5, -1, -1.12 >,0.05      // stay  
                       pigment { color Gray35 }
                       finish { ambient 0.2 }
                      }
          }


// tailwheel assembly
#declare Twass =
     union {
object { Afork  scale < 0.65, 1, 1 > rotate 60*z translate < 13.3, -2.4, 0> }    // tail
object { Fork  scale < 0.8, 1, 1 > rotate 140*z translate < 13.3, -2.4, 0> }  // tail  
object { Afork scale < 0.75, 1, 1 > rotate 105*z translate < 13.3, -2.4, 0> }  // tail  
object { Wheel scale 0.7 translate < 13.3, -2.4, 0 > }   // tail
cylinder { < 12.5, -1.7, 0 >,< 12.5, 1.3, 0 >,0.075  }    // spring
cylinder { < 12.5, -1.7, 0 >,< 10, -0.7, 0.78 >,0.045 }      // stay
cylinder { < 12.5, -1.7, 0 >,< 10, -0.7, -0.78 >,0.045  }     // stay
                       pigment { color Gray35 }
                       finish { ambient 0.2 }
            }


// ENGINE

#declare Crank =              // crankcase
        union {
               cylinder { < -2.7, 0, 0 >,< -1.8, 0, 0 >,0.5
                                texture {
                                   pigment { color Gray85 }
                                   finish { ambient 0.2 }
                                        }
                                texture {
                                   pigment { 
                                           gradient y
                                           turbulence 0.6
                                           color_map {
                                                [ 0.0 color Gray55 ]      
                                                [ 0.1 color Gray55 ]
                                                [ 0.4 color Clear ]
                                                [ 0.6 color Clear ]
                                                [ 0.7 color Gray55 ]      
                                                [ 0.8 color Gray55 ]
                                                [ 0.9 color Clear ]
                                                [ 1.0 color Clear ]
                                                     }
                                           }
                                  finish { ambient 0.2 }
                                       }
                         }
               cone { < -2.7, 0, 0 >,0.23,< -4, 0, 0 >,0.12
                          pigment { color Gray85 }
                          finish { ambient 0.2 }
                         }
               cylinder { < -3.5, 0, 0 >,< -3.95, 0, 0 >,0.3  // prop hub
                          pigment { color Tan }
                          finish { ambient 0.2 }
                        }
               cone { < 0, 0, 0 >,3.5,< 0, 0.45, 0 >,0.5      // prop
                       pigment { 
                          radial
                          color_map {
                                    [ 0.0 color Clear ]
                                    [ 0.2 color Clear ]
                                    [ 0.25 color rgbt < 0.8, 0.6, 0.4, 0.5 > ]
                                    [ 0.3 color Clear ]
                                    [ 0.7 color Clear ]
                                    [ 0.75 color rgbt < 0.8, 0.6, 0.4, 0.5 > ]
                                    [ 0.8 color Clear ]
                                    [ 1.0 color Clear ]
                                    }
                                }    
                           finish { ambient 0.2
                                   phong 1 
                                 }
                          rotate < 0, -45, 90 >
                          translate  -3.5*x
                      }
               box { < -1.8, 0.4, 1.21 >,< -1.7, 0.2, -1.21 >
                          pigment { color Tan }
                          finish { ambient 0.2 }
                        }
               box { < -1.8, -0.4, 1.21 >,< -1.7, -0.2, -1.21 >
                          pigment { color Tan }
                          finish { ambient 0.2 }
                        }  
               }    
                        
#declare Coolfin =
           sphere { < 0, 0, 0 >,0.4
                     scale < 1, 0.17, 1 >  
                     pigment { color Gray10 }
                     finish { ambient 0.2 }
                 }
#declare Coolset =
             union {
                   object { Coolfin translate 1*y }
                   object { Coolfin translate 1.1*y } 
                   object { Coolfin translate 1.2*y } 
                   object { Coolfin translate 1.3*y } 
                   object { Coolfin translate 1.4*y } 
                   object { Coolfin translate 1.5*y } 
                   }
#declare Exhaust =
             union {
                   torus { 0.25, 0.075
                          rotate 90*x
                          clipped_by {
                                  box { < -1, 0, -0.5 >,< 1, 1, 0.5 > }
                                     }
                         }
                    cylinder { < 0.25, 0, 0 >,< 0.25, -1.5, 0 >,0.05 }
                    translate < -1.65, 1.5, 0 >
                       pigment { color Gray85 }
                       finish { ambient 0.3
                                reflection 0.3
                                phong 1 
                               }
                   }
#declare Pot =                 // engine cylinder
             union {
                    cylinder { < -2.3, 0, 0 >,< -2.3, 1.5, 0 >,0.3
                                texture {
                                   pigment { color Gray85 }
                                   finish { ambient 0.2 }
                                        }
                                texture {
                                   pigment { 
                                           gradient y
                                           turbulence 0.6
                                           color_map {
                                                [ 0.0 color Gray55 ]      
                                                [ 0.15 color Gray55 ]
                                                [ 0.4 color Clear ]
                                                [ 0.6 color Clear ]
                                                [ 0.7 color Gray55 ]      
                                                [ 0.8 color Gray55 ]
                                                [ 0.9 color Clear ]
                                                [ 1.0 color Clear ]
                                                     }
                                           }
                                  finish { ambient 0.2 }
                                       }
                          }
                    sphere { < 0, 0, 0 >,0.2
                              scale < 1, 0.5, 1 >
                              translate < -2.3, 1.5, 0 >
                                   pigment { color Gray35 }
                                   finish { ambient 0.2 }
                           }
                    cylinder { < -2.3, 1.6, 0 >,< -2.3, 1.8, 0 >,0.05
                                pigment { color White }
                                finish { ambient 0.2 }
                             }
                    object { Coolset translate -2.3*x }
                    cylinder { < -1.9, 1, 0 >,< -1.9, 1.5, 0 >,0.15
                                   pigment { color Gray85 }
                                   finish { ambient 0.2 }
                              }
                    object { Coolset scale < 0.6, 1, 0.6 >
                              translate -1.9*x
                              }
                    object { Exhaust }
                 }

#declare Engine =
            union {
                  object { Crank }
                  object { Pot }
                  object { Pot rotate 60*x }
                  object { Pot rotate -60*x }
                  cylinder { < -1.4, 0, 0 >,< -1, -1.5, 0 >,0.1
                                pigment { color Gray85 }
                                finish { ambient 0.3
                                         reflection 0.3
                                         phong 1 
                                       }
                             }

                  }
// PILOT
#declare Helmet =
             difference {    
                       sphere { < 0, 0, 0 >,0.55
                                 scale < 0.9, 1, 0.6 >
                               }
                       box { < -1, 0, -1 >,< 0, -1, 1 > }
                         pigment { color rgb < 0.4, 0.3, 0.2 > }
                         finish { ambient 0.2 }
                        }
#declare Goggle =
                union {
                      torus { 0.15, 0.02
                              scale < 1, 1.5, 1 >
                              pigment { color Gray25 }
                              finish { ambient 0.2 }
                            }
                       cylinder { < 0, -0.02, 0 >,< 0, 0.01, 0 >,0.15
                               pigment { color rgb < 0.8, 0.8, 0.9 > }
                               finish { ambient 0.2
                                         reflection 0.1
                                         phong 1 
                                       }
                                }
                         rotate 90*z
                         scale < 1, 1, 1.25 >
                         translate -0.5*x
                       }
#declare Hafmo =
            sphere { < 0, 0, 0 >,0.35
                     scale < 0.2, 0.2, 1 >
                     pigment { color Gray20 }
                     finish { ambient 0.2 }
                    }
#declare Mo =                // nose plus Mo
             union {
                   sphere { < 0, 0, 0 >,0.08
                             translate < -0.5, -0.25, 0 >
                                 pigment { color rgb < 1, 0.6, 0.5 > }
                                 finish { ambient 0.2 }
                          }
                   sphere { < 0, 0, 0 >,0.08
                             translate < -0.35, -0.25, -0.1 >
                                 pigment { color rgb < 1, 0.6, 0.5 > }
                                 finish { ambient 0.2 }
                          }
                   sphere { < 0, 0, 0 >,0.08
                             translate < -0.35, -0.25, 0.1 >
                                 pigment { color rgb < 1, 0.6, 0.5 > }
                                 finish { ambient 0.2 }
                          }


                   cone { < -0.35, -0.25, 0 >,0.18,< -0.4, 0, 0 >,0.05 
                                 scale < 1, 1, 0.6 >
                                 pigment { color rgb < 1, 0.6, 0.5 > }
                                 finish { ambient 0.2 }
                         }                                   // nose

                   object { Hafmo rotate < -40, 0, 20 > 
                            translate < -0.34, -0.35, -0.16 >
                          }
                   object { Hafmo rotate < 40, 0, 20 > 
                            translate < -0.34, -0.35, 0.16 >
                          }
                    }
#declare Head =
                union{
                       object { Helmet   scale < 1.25, 1.1, 1.5 >
                                 rotate -15*z    
                               }
                             sphere { < 0, 0, 0 >,0.48         // face
                                 pigment { color rgb < 1, 0.6, 0.5 > }
                                 finish { ambient 0.2 }
                                    }
                             object { Goggle  
                                      rotate 26*y
                                    }
                             object { Goggle  
                                      rotate -26*y
                                    }   
                             object { Mo }       
                             cylinder { < 0, -0.05, 0 >,< 0, 0.05, 0 >,0.49
                                       pigment { color Gray10 }
                                       finish { ambient 0.2 }
                                       }                  // goggle strap
                            }
                     
#declare Pilot =   
               union {
                       cylinder { < 0, 0, -0.6 >,< 0, 0, 0.6 >,1   // torso
                                  scale < 0.5, 1, 1 > 
                                 }
                       sphere { < 0, 0, 0 >,1                // l shoulder
                                scale < 0.5, 1, 0.4 >
                                translate -0.6*z
                              }
                       sphere { < 0, 0, 0 >,1
                                scale < 0.5, 1, 0.4 >        // r shoulder
                                translate 0.6*z
                              }
                       sphere { < 0, 0, 0 >,1                 // l arm
                                scale < 0.25, 1, 0.5 >
                                rotate -25*z
                                translate < -0.5, 0, -0.65 >
                              }
                       sphere { < 0, 0, 0 >,1                  // r arm
                                scale < 0.25, 1, 0.5 >
                                rotate -25*z
                                translate < -0.5, 0, 0.65 >
                              }

                       difference {                           // neck
                                  cylinder { < 0, 0, 0 >,< 0, 1.3, 0 >,0.3 }
                                  torus { 0.4, 0.2
                                           scale < 1, 1.5, 1 >
                                           translate 1*y
                                        }
                                  }
                       object { Head 
                                 scale < 0.8, 0.9, 0.8 >
                                 rotate < 0, -20, -20 >
                                 translate < -0.1, 1.48, 0 >
                              }
                      rotate 20*z
                      pigment { color rgb < 0.4, 0.3, 0.2 > }
                      finish { ambient 0.2 }
                        }
                    
#declare Bleriot =
           union {
                   object { Rwing rotate < -2, 0, -12 > translate 1.25*z }
                   object { Landwir }
                   object { Flywir }
                   object { Tailwir } 
                   object { Lwing  translate -10.25*z rotate < 2, 0, -12 > }     
                   object { Stab translate < 16.1, -0.64, 0 > }  
                   object { Stays }
                   object { Long translate < 0, 1.66, 1.21 > }
                   object { Long translate < 0, 1.66, -1.21 > }  
                   object { Long translate < 0, -1, 1.21 > }  
                   object { Long translate < 0, -1, -1.21 > }  
        object { Tlong rotate < 0, 5, -2.5 > translate < 4.8, 1.66, 1.21 > }
        object { Tlong rotate < 0, -5, -2.5 > translate < 4.8, 1.66, -1.21 > }  
        object { Tlong rotate < 0, 5, 3.5, > translate < 4.8, -1, 1.21 > }  
        object { Tlong rotate < 0, -5, 3.5 > translate < 4.8, -1, -1.21 > }  
        object { Cross  scale < 1, 2.7, 1 > translate < -2, -1, 1.21 > }     
        object { Cross  scale < 1, 2.7, 1 > translate < -2, -1, -1.21 > }
        object { Across  scale < 1, 1, 2.5 > translate < -2, 1.66, 0 > }     
        object { Across  scale < 1, 1, 2.5 > translate < -2, -0.96, 0 > }
                   object { Cover }
                   object { Frame }
                   object { Bframe }
                   object { Fuzz }
                   object { Collar }
                   object { Fin translate < 19, -0.35, 0 > } 
                   object { Tank }
                   object { Wassmb translate -0.5*x } 
                   object { Twass } 
                   object { Engine translate -0.25*x }  
                   object { Pilot translate < 3.65, 1.4, 0 > }  
                }
object { Bleriot scale 0.8 rotate < -9, -50, 2 > translate < -5, 44, 15 > }

light_source { < -100, 100, -90 > color Gray45 
                spotlight point_at < 3, 45, 0 > 
                tightness 0
                radius 50
                falloff 70
                }                             
light_source { < -100, 100, 700 > color Gray85 
                spotlight point_at < -100, 0, 700 > 
                tightness 0
                radius 50
                falloff 70
                }                             
light_source { < -100, 1000, 7000 > color Gray80 
                spotlight point_at < -100, 0, 7000 > 
                tightness 0
                radius 70
                falloff 85
                }                             
                
              // END  

