#declare flag_red = color rgb <.8,0,0>;
#declare flag_white = color rgb <.8,.8,.8>;
#declare flag_blue = color rgb <0,0,.8>;

#declare flag_normal = normal {
	wrinkles 2
	scale .05
	turbulence .25
}

#declare flag_dirt = texture {
	pigment {
		bozo
		turbulence .2
		color_map {
			[0.0	color Gray50 filter .5]
			[0.5	color White transmit 1]
			[1.0	color White transmit 1]
		}
	}
	scale .1
}

#declare conf_bar = texture {
	pigment {
		gradient x
		frequency 1
		color_map {
			[0.0	color flag_white]
			[0.08	color flag_white]
			[0.09	color White transmit 1]
			[1.0	color White transmit 1]
		}
	}
	finish {
		ambient .5
	}
}
#declare conf_blue = pigment {
	gradient x
	frequency 1
	color_map {
		[0.0	color flag_blue]
		[0.06	color flag_blue]
		[0.06	color White transmit 2]
		[1.0	color White transmit 2]
	}
}
#declare conf_stars = pigment {
	image_map {
		gif "constar.gif"
	}
	translate <-.5,0,0>
	scale <1,330/230,1>
	scale .1
	translate <0,-.2,0>
}
#declare conf_blue_bar = texture {
	pigment {
		average
		pigment_map {
			[1	conf_blue]
			[1	conf_stars]
		}
	}
	finish {
		ambient .5
	}
}

#declare bar_rotate = 45*sqrt(2); 
#declare flag= polygon {
	5
	<-.5,-.25>,<.5,-.25>,<.5,.25>,<-.5,.25>,<-.5,-.25>
}

#declare confederate_texture = texture {
	pigment { color flag_red }
	normal {
		flag_normal
	}
	finish {
		ambient .4
	}
}
texture { conf_bar
	rotate <0,0,bar_rotate>
	normal { flag_normal}
}
texture { conf_bar
	rotate <0,0,-bar_rotate>
	normal { flag_normal }
}
texture { conf_blue_bar
	rotate <0,0,bar_rotate>
	normal { flag_normal }
}
texture { conf_blue_bar
	rotate <0,0,-bar_rotate>
	normal { flag_normal }
}
texture { flag_dirt }


#macro make_flag(DX,DY,DZ,AX,AY,flag_pigment,damper,curve,start_phase,ripple_mult)

#local MXC = DX/AX;
#local MYC = DY/AY;
#local damper_X = damper.x;
#local damper_Y = damper.y;
#local curve_X = curve.x/MXC;
#local curve_Y = curve.y/MYC;
#local phase_X = radians(start_phase.x);
#local phase_Y = radians(start_phase.y);
#local ripple_X = ripple_mult.x;
#local ripple_Y = ripple_mult.y;
#local LX = array[MYC+1]
#local LY = array[MYC+1]
#local LZ = array[MYC+1]
#local YC=0;
#while (YC<=MYC)
	#local LX[YC]=0;
	#local LY[YC]=YC*AY;
	#local LZ[YC]=(damper_X*sin(phase_X)+damper_Y*sin(LY[YC]*ripple_Y+phase_Y))+curve_Y*YC;
	#local YC=YC+1;
#end

#local XC=0;
#local Y2_Off = 0;
#local X1_Off = 0;
union{
	#while (XC<MXC)
		#local YC = 0;
		#while (YC<MYC)
			//#declare Z=(DZ-(DX-X)/DX*DZ)*(sin(X*9-AO2)-0.2*sin(X*20));
			//#declare Y=(DY-(DX-X)/DX*DY)*(sin(X*5-AO1)-0.2*sin(X*10));
			#local X1=LX[YC]+AX;
			#local Y1=LY[YC];
			#local Z1=(damper_X*sin(X1*ripple_X+phase_X)+damper_Y*sin(Y1*ripple_Y+phase_Y))+curve_Y*YC+curve_X*XC;
			
			#local X2=X1;
			#local Y2=Y1+AY;
			#local Z2=(damper_X*sin(X2*ripple_X+phase_X)+damper_Y*sin(Y2*ripple_Y+phase_Y))+curve_Y*(YC+1)+curve_X*(XC+1);
			
			#if (YC = 0)
				//#local Y1_Off = abs(Z1)*(.2/(.2+AY*20));
			#end
			#if (YC = MYC-1)
				#local Y2_Off = abs(Z1)*(.2/(.2+AY*5))-Y2_Off;
				#local Y2 = Y2 - Y2_Off;
			#end
			
			#if (XC = MXC-1)
				#local X1_Off = abs(Z1)*(.2/(.2+AX*5))-X1_Off;
				#local X1 = X1 - X1_Off;
			#end
			
			triangle{
				<LX[YC],LY[YC],LZ[YC]>,<X1,Y1,Z1>,<LX[YC+1],LY[YC+1],LZ[YC+1]>
				texture{flag_pigment translate 0*y*Y1}
			}
			triangle{
				<X1,Y1,Z1>,<X2,Y2,Z2>,<LX[YC+1],LY[YC+1],LZ[YC+1]> 
				texture{flag_pigment translate 0*y*Y2}
			}
			#local LX[YC]=X1;
			#local LY[YC]=Y1;
			#local LZ[YC]=Z1;
			
			#local YC=YC+1;
		#end
		#local XC=XC+1;
		#local LX[YC]=X2;
		#local LY[YC]=Y2;
		#local LZ[YC]=Z2;
	#end
  
}
#end

#declare blue_box = pigment {
	boxed
	color_map {
		[0.0	color White transmit 2]
		[0.1	color White transmit 2]
		[0.2	color Blue]
		[1.0	color Blue]
	}
}
#declare white_stars = pigment {
	image_map {
		gif "fedstar.gif"
	}
	scale .3
}

#declare federal_texture = texture {
	pigment {
		gradient y
		frequency 13
		color_map {
			[0.0	color flag_red]
			[0.41	color flag_red]
			[0.42	color Black]
			[0.50	color Black]
			[0.51	color flag_white]
			[0.90	color flag_white]
			[0.91	color Black]
			[0.99	color Black]
			[1.0	color flag_red]
		}
		translate <0,-.48,0>
	}
	finish {
		ambient .4
	}
}
texture {
	pigment {
		average
		pigment_map {
			[1	blue_box]
			[1	white_stars]
		}
		scale .3
		scale <7/13,7/13,1>
		translate <-4/13*2/.75,5/13,0>*.3
	}
	finish {
		ambient .4
	}
}
texture { flag_dirt }


#declare conf_flag_pigment = texture {
	confederate_texture
	translate <.45,.25,0>
	scale 2
	scale <.825,1,1>
}


#declare fed_flag_pigment = texture {
	federal_texture
	translate <.383, .25,0>
	scale 2
	scale <.825, 1, 1>
}
