// BW - Balloon
// History IRTC - 04.99
// Montgolfier brothers - June 1783

#include "colors.inc"
#include "textures.inc"
#include "woods.inc"
#include "skies.inc"

global_settings {assumed_gamma 2.2}

#declare HOF = on;	// use with 'square' image

// axis
#if(off)
	cylinder {<-2,0,0> <2,0,0> .01 pigment {Red}}
	cylinder {<0,2,0> <0,-2,0> .01 pigment {Red}}
	#if(on)
		#local XG = -2;
		#local XGI = .5;
		#while(XG < 2+XGI)
			cylinder {<XG,-.1,0> <XG,.1,0> .008 pigment {Red} finish {diffuse 1}}
			cylinder {<-.1,XG,0> <.1,XG,0> .008 pigment {Red} finish {diffuse 1}}
			#local XG = XG + XGI;
		#end
	#end
#end

// --------------- core br -------------------------------

#declare BRAD = 1;
#declare BLEN = 2;
#declare NRAD = .35;
#declare NLEN = .25;
#declare HRAD = .6;
#declare HCENT =BLEN+HRAD+(NLEN/2);
#declare ARAD = .25;
#declare ALEN = 1.85;

// body
#declare body = cylinder 
{
	<0,0,0> <0,BLEN,0> BRAD
	pigment
	{
		gradient x
		color_map
		{
			[0.0 	rgb <1,1,1>]
			[0.25 	rgb <1,1,1>]
			[0.25 	rgb <1,0,0>]
			[1.0 	rgb <1,0,0>]
		}
	}
	scale <1,1,.5>
}

// shoulders
#declare SHRAD = .35;
#declare sh_head_neck = union
{
	sphere {<-BRAD-.1,BLEN-.3,0> SHRAD pigment {Red} scale <1.2,1,1>}
	sphere {<BRAD+.1,BLEN-.3,0> SHRAD pigment {Red} scale <1.2,1,1>}

	sphere {<0,HCENT,0> HRAD pigment {Pink}} // head and neck
	cylinder {<0,BLEN,0> <0,BLEN+NLEN,0> NRAD pigment {White}}
}

#declare hat = union
{
	cylinder {<0,-.025,0> <0,.025,0> HRAD+(HRAD*.3)}
	cylinder {<0,.1,0> <0,.85,0> HRAD-.1}
	pigment {Black}
}

#declare br1 = union
{
	object {body}
	object {sh_head_neck}

	object {hat translate <0,HCENT+HRAD-(HRAD/3),0>}
	
	// pointing arm
	cylinder {<BRAD+SHRAD,BLEN-.3,0> <BRAD+SHRAD,BLEN-.3,-ALEN> ARAD pigment {Red}}
	cone {<BRAD+SHRAD,BLEN-.3,-ALEN> , .23 , <BRAD+SHRAD,BLEN-.3,-ALEN-.45> .1 pigment {Black}}

	// other arm
	cylinder {<-BRAD-SHRAD,BLEN-.3,0> <-BRAD-SHRAD,BLEN-.3-ALEN,0> ARAD pigment {Red}}
	cone {<-BRAD-SHRAD,BLEN-.3-ALEN,0> , ARAD , <-BRAD-SHRAD,BLEN-.3-ALEN-.45,0> .1 pigment {Black}}
}

#declare br2 = union
{
	object {body}
	object {sh_head_neck}

	object {hat translate <0,0,-ALEN-HRAD+.1-.45> rotate <50,0,0> translate <BRAD+SHRAD,BLEN-.3,0>}
	
	// pointing arm
	#local parm = union
	{
		cylinder {<BRAD+SHRAD,BLEN-.3,0> <BRAD+SHRAD,BLEN-.3,-ALEN> ARAD pigment {Red}}
		cone {<BRAD+SHRAD,BLEN-.3,-ALEN> , .23 , <BRAD+SHRAD,BLEN-.3,-ALEN-.45> .1 pigment {Black}}
	}
	object {parm translate <-BRAD-SHRAD,-BLEN+.3,0> rotate <50,0,0> translate <BRAD+SHRAD,BLEN-.3,0>}

	// other arm
	cylinder {<-BRAD-SHRAD,BLEN-.3,0> <-BRAD-SHRAD,BLEN-.3-ALEN,0> ARAD pigment {Red}}
	cone {<-BRAD-SHRAD,BLEN-.3-ALEN,0> , ARAD , <-BRAD-SHRAD,BLEN-.3-ALEN-.45,0> .1 pigment {Black}}
}

#declare balloon = union
{
	intersection
	{
		blob
		{
			threshold .65
			sphere { <0,0,0> ,.8,1}
			sphere { <0,-1,0> ,.775,1}
			scale <1,1,1>
		}

		box {<-1,-.5,-1> <1,1,1>}

		scale 2

		//pigment {White}
		pigment
		{
			image_map
			{
				gif "bmap1.gif"
			}
			scale <.3,.75,1> // bmap1
			translate <0,.3,0>
		}
		finish {diffuse 1 specular .2 roughness 0.05}
	}

	difference
	{
		cylinder {<0,-1,0> <0,-1.2,0> .425}
		cylinder {<0,-0.9,0> <0,-1.18,0> .4}
		translate <0,.1,0>
		pigment
		{
			image_map
			{
				gif "bbmap.gif"
			}
			scale <.3,.3,1>
			translate <0,-1.1,0>
		}
		finish {diffuse 1 specular .2 roughness 0.05}
	}

	object {br1 scale .065 rotate <0,85,0> rotate <0,0,5> translate <-.33,-1.0,0>}
	object {br2 scale .065 rotate <0,-85,0> rotate <0,0,-5> translate <.33,-1.0,0>}
}

// final scene
object {balloon scale 2.25 translate <0,.65,0>}

background {SkyBlue}

// light and camera

light_source {<-500,500,-1500> color White}

camera
{
	#if(HOF = on)
		right <1,0,0>
		up <0,1,0>
		location <0,0,-6.75>
	#else
		location <0,0,-5>
	#end
	look_at <0,0,0>
}

#if(on)
sky_sphere {S_Cloud1}
#end
