// BW - Flyer
// History IRTC - 04.99
// Wright brothers flyer - December 1903

#include "colors.inc"
#include "textures.inc"
#include "woods.inc"
#include "skies.inc"

#declare HOF = on;	// use with 'square' image

// axis
#if(off)
	cylinder {<-10,0,0> <10,0,0> .01 pigment {Red}}
	cylinder {<0,2,0> <0,-2,0> .01 pigment {Red}}
	#if(off)
		#local XG = -5;
		#local XGI = .25;
		#while(XG < 5+XGI)
			cylinder {<XG,-.25,0> <XG,.25,0> .01 pigment {Red} finish {diffuse 1}}
			cylinder {<-.1,XG,0> <.1,XG,0> .01 pigment {Red} finish {diffuse 1}}
			#local XG = XG + XGI;
		#end
	#end
#end

#declare wood_text = T_Wood2
//#declare wood_text = texture {pigment {White}};

#declare wing_shell = superellipsoid
{
	<1,.5>
	pigment {rgb <.8,.8,.5>}
	rotate <0,90,0>
	scale <10,.1,1>
	scale 1
}

#declare flap = intersection
{
	object {wing_shell}
	box {<-7,-.25,.4> <7,.25,1.4> pigment {Black}}
}

#declare wing = union
{
	difference
	{
		object {wing_shell}
		object {flap scale <1,1.01,1>}
		pigment {White}
	}
	object {flap pigment {rgb <.8,.8,.5>} rotate <15,0,0>}
}

#declare strut = cylinder {<0,-.5,0> <0,.5,0> .045 texture {wood_text}}

#declare sledge = union
{
	#local FLEN  = -5;

	box {<-.1,-.05,FLEN> <.1,.05,0>}

	difference
	{
		intersection
		{
			sphere {<0,1-.05,FLEN> 1}
			box {<-.1,-.05,FLEN+.1> <.1,1,FLEN-1.5>}
		}
		sphere {<0,1-.05,FLEN> 1-.1}
	}

	texture {wood_text}
}

#local propeller = union
{
	#local pbit = intersection
	{
		union
		{
			sphere {<0,0,0> .5}
			intersection
			{
				sphere {<0,0,0> .5 scale <1,5,1>}
				box {<-1,0,-1> <1,3,1>}
			}
		}
		box {<-1,-.6,-.05> <1,3,.05>}
	}

	object {pbit rotate <0,20,0> translate <0,-2.4,0>}
	object {pbit rotate <0,20,0> translate <0,-2.4,0> rotate <180,0,0>}
	pigment {Gray}
}

#declare flyer = union
{
	#local wing_components = union
	{
		object {wing scale <1,1,1.5> translate <0,1.5,0>}
		object {wing_shell scale <1,1,1.5> translate <0,-1.5,0>}
	
		#local XC = 7;
		#local XCR = 0;
		#local XPOS = -9;
		#while (XCR < XC)
			object {strut scale <1,3,1> translate <XPOS,0,-1>}
			object {strut scale <1,3,1> translate <XPOS,0,.75>}
			#local XPOS = XPOS + 3;
			#local XCR = XCR + 1;
		#end

		#macro x_line(xpos,zpos)
			cylinder {<xpos,1.5,zpos> <xpos+3,-1.5,zpos> .008 pigment {Black}}
			cylinder {<xpos,-1.5,zpos> <xpos+3,1.5,zpos> .008 pigment {Black}}
		#end

		// front
		x_line(-9,-1)
		x_line(-6,-1)
		x_line(3,-1)
		x_line(6,-1)

		// back
		x_line(-9,.75)
		x_line(-6,.75)
		x_line(3,.75)
		x_line(6,.75)

		object {strut scale <1,4,1> translate <1.5,-1,-1>}
		object {strut scale <1,4,1> translate <-1.5,-1,-1>}

		// enginey bit
		box {<-1.45,-1.4,-.5> <-.6,-.5,.65> pigment {Gray20}}
		cylinder {<-1.025,-0.95,.65> <-1.025,-0.95,.75> .4 pigment {Gray40}}
	}

	object {wing_components rotate <15,0,0>}


	#local wheel_rig = union
	{
		// axle
		cylinder {<-2.05,0,0> <2.05,0,0> .2 pigment {Black}}

		//wheels
		#local wheel = union
		{
			torus {.75,.1 rotate <0,0,90> pigment {Gray20}}
			cylinder {<-.05,0,0> <.05,0,0> .225 pigment {Silver}}
			#local SPKC = 12;
			#local SPKCR = 0;
			#while(SPKCR < SPKC)
				cylinder {<0,.75,0> <0,-.75,0> .02 pigment {Silver} rotate <SPKCR*(360/SPKC),0,0>}
				#local SPKCR = SPKCR + 1;
			#end
		}
		object {wheel translate <2.25,0,0>}
		object {wheel translate <-2.25,0,0>}
	}

	object {wheel_rig translate <0,-2.5,-.8>}

	object {sledge rotate <5,0,0> translate <1.5,-2.5-.2,0>}
	object {sledge rotate <5,0,0> translate <-1.5,-2.5-.2,0>}

	// front wing to slegde link
	cylinder {<1.5,-1.25,-1.4> <1.5,-2.3,-4.5> .045 texture {wood_text}}
	cylinder {<-1.5,-1.25,-1.4> <-1.5,-2.3,-4.5> .045 texture {wood_text}}

	// back structure
	#local back_structure = union
	{
		#local vbpx = <1,-2.65,9>;
		#local vbnx = <-1,-2.65,9>;
		#local vbpx = vrotate(vbpx,<0,-4,0>);
		#local vbnx = vrotate(vbnx,<0,4,0>);

		#local vtpx = <1,0.95,9>;
		#local vtnx = <-1,0.95,9>;
		#local vtpx = vrotate(vtpx,<0,-4,0>);
		#local vtnx = vrotate(vtnx,<0,4,0>);

		// bottom
		cylinder {<1.5,-2.5-.2,0> vbpx .045 texture {wood_text}}
		cylinder {<-1.5,-2.5-.2,0> vbnx .045 texture {wood_text}}

		// top
		#local vtpx2 = <1.5,1.4,.75>;
		#local vtpx2 = vrotate(vtpx2,<15,0,0>);
		#local vtnx2 = <-1.5,1.4,.75>;
		#local vtnx2 = vrotate(vtnx2,<15,0,0>);
		cylinder {vtpx2 vtpx .045 texture {wood_text}}
		cylinder {vtnx2 vtnx .045 texture {wood_text}}

		// v bars
		cylinder {vbpx vtpx .045 texture {wood_text}}
		cylinder {vbnx vtnx .045 texture {wood_text}}

		// h bars
		cylinder {vbpx,vbnx .045 texture {wood_text}}
		cylinder {vbpx,vbnx .045 texture {wood_text} translate <0,2.65+.95,0>}

		// vertical back wings
		box {<1-.025,-2.7,9> <1+.025,1.05,10> rotate <0,-4,0> pigment {rgb <.8,.8,.5>}}
		box {<-1-.025,-2.7,9> <-1+.025,1.05,10> rotate <0,4,0> pigment {rgb <.8,.8,.5>}}
	}
	object {back_structure}

	// support
	cylinder {<1.45,-2.65,.75> <1.45,-1.5,.75> .045 texture {wood_text}}
	cylinder {<-1.45,-2.65,.75> <-1.45,-1.5,.75> .045 texture {wood_text}}
	cylinder {<1.45,-2.65,.75> <-1.45,-1.5,.75> .008 pigment {Black}}
	cylinder {<-1.45,-2.65,.75> <1.45,-1.5,.75> .008 pigment {Black}}

	#macro gen_prop_chunk(PROPx)
		// ps strut
		object {strut scale <1,3,1> translate <PROPx,0,.75> rotate <15,0,0>}

		// prop shaft + cog
		cylinder {<PROPx,0,.75> <PROPx,0,4> .1 pigment {Black}}
		cylinder {<PROPx,0,.65> <PROPx,0,.75> .15 pigment {Black}}
		difference
		{
			cylinder {<PROPx,0,.65> <PROPx,0,.75> .5 pigment {Black}}
			cylinder {<PROPx,0,.649> <PROPx,0,.751> .4 pigment {Black}}
		}
		// spokes
		#local SPKC = 3;
		#local SPKCR = 0;
		#while(SPKCR < SPKC)
			cylinder {<0,-.45,.7> <0,.45,.7> .05 rotate <0,0,SPKCR*(360/SPKC)> translate <PROPx,0,0> pigment {Black}}
			#local SPKCR = SPKCR + 1;
		#end
		// ps links
		#local v1 = <PROPx,-1.5,.75>;
		#local v2 = <PROPx,1.5,.75>;
		#if(PROPx > 0)
			#local v3 = <1.5,-1.5,.75>;
		#else
			#local v3 = <-1.5,-1.5,.75>;
		#end
		#local v1 = vrotate(v1,<15,0,0>);
		#local v2 = vrotate(v2,<15,0,0>);
		#local v3 = vrotate(v3,<15,0,0>);
		cylinder {v1,<PROPx,0,4> .06 pigment {Black}}
		cylinder {v2,<PROPx,0,4> .06 pigment {Black}}
		cylinder {v3,<PROPx,0,4> .06 pigment {Black}}

		#if(PROPx > 0)
			object {propeller scale .8 rotate <0,0,-30> translate <PROPx,0,4>}
		#else
			object {propeller scale .8 rotate <0,0,10> translate <PROPx,0,4>}
		#end

		// quick rb bit
		difference
		{
			cylinder {<PROPx,0,.65> <PROPx,0,.75> .55}
			cylinder {<PROPx,0,.649> <PROPx,0,.751> .5}
			#if(PROPx > 0)
				plane {x,PROPx-.25}
			#else
				plane {-x,-PROPx-.25}
			#end
			pigment {Gray30}
		}
	#end

	gen_prop_chunk(2.5)
	gen_prop_chunk(-2.5)

	// rb's
	cylinder {<-1.025,-0.95+.4,.65> <2.5,-.5,.75> .045 pigment {Gray30}}
	cylinder {<-1.025,-0.95-.4,.65> <2.5,.5,.75> .045 pigment {Gray30}}

	cylinder {<-1.025,-0.95+.4,.65> <-2.5,-.5,.65> .045 pigment {Gray30}}
	cylinder {<-1.025,-0.95-.4,.65> <-2.15,.4,.65> .045 pigment {Gray30}}
}

#declare bird = union
{
	#local body = union
	{
		sphere {<0,0,0> .5 scale <3,.75,1>}
		intersection
		{
			sphere {<0,0,0> .5 scale <5,.75,1>}
			box {<-3,-1,-1> <0,1,1>}
		}
		rotate <0,-90,0>
	}

	#local wing = intersection
	{
		difference
		{
			sphere {<0,0,0> 1 scale <3,1,1>}
			sphere {<0,0,0> 1 scale <3,.95,1.1>}
		}
		box {<0,0,-1.1> <3.1,1.1,1.1>}
	}

	#local tail = union
	{
		#local tf = superellipsoid {<1,.5> scale <.25,.05,1> translate <0,0,-.8>}
		object {tf}
		object {tf rotate <0,15,0>}
		object {tf rotate <0,-15,0>}
		object {tf rotate <0,30,0>}
		object {tf rotate <0,-30,0>}
	}

	object {body}
	object {wing translate <.4,-.75,0>}
	object {wing rotate <0,180,0> translate <-.4,-.75,0>}
	object {tail translate <0,0,-2>}

	pigment {White}
	rotate <0,180,0>
}

// test objects
//object {bird scale 2}
//object {big_rb scale <3.5,2,2>}
//object {big_rb scale <3.5,2,2>}
//object {propeller scale 2 rotate <0,0,0>}
//object {wing_shell rotate <0,90,0>}
//object {flap rotate <90,0,0>}
//object {wing rotate <15,0,0> translate <0,1.5,0>}
//object {wing_shell rotate <15,0,0> translate <0,-1.5,0>}
//object {strut scale <1,3,1> translate <-9,0,0>}
//object {sledge}

// test flyers
//object {flyer rotate <0,30,0> rotate <0,0,0> translate <-2,0,0>} // final
//object {flyer rotate <0,90,0> rotate <90,0,0> translate <0,0,-10>} //underside
//object {flyer rotate <0,90,0> rotate <-90,0,0> translate <-0,0,-10>} //overside
//object {flyer rotate <0,-90,0> rotate <0,0,0> translate <.5,1,-13>} // engine

// the final scene
object {flyer rotate <0,30,0> rotate <0,0,0> translate <-2,0,0>}
object {bird rotate <0,0,-10> translate <-15,25,70>}
object {bird rotate <-5,0,-5> translate <-35,20,80>}

background {SkyBlue}

// light and camera

light_source {<-5,-2,-150> color White}
light_source {<-500,800,-1500> color White }

camera
{
	#if(HOF = on)
		right <1,0,0>
		up <0,1,0>
		location <0,0,-22>
	#else
		location <0,0,-18>
	#end
	look_at <0,0,0>
}

// ground
plane {y,-2.5-.75-.1 pigment {rgb <.75,.75,.25>} finish {ambient .4 diffuse .5 crand .05}}

#if(on)
sky_sphere {S_Cloud2}
#end
