// BW - Kite
// History IRTC - 04.99

#include "colors.inc"
#include "textures.inc"
#include "woods.inc"

global_settings {assumed_gamma 2.2}

#declare HOF = on;	// use with 'square' image

#macro Make_Streamer(InitialYScale)
#declare streamer = object
{
	union
	{
		#local CYLEN = .15;
		#local XSCALE = .75;
		#local YSCALE = InitialYScale;
		#local RADIUS = .5;
		#local XPOS = RADIUS*cos(radians(0));
		#local LAST_X = RADIUS*cos(radians(0));
		#local ANGLE = 0;
		#while(ANGLE < 360*3)
			#local X = RADIUS*cos(radians(ANGLE))*XSCALE;
			#local Y = RADIUS*sin(radians(ANGLE))*YSCALE;
			#local XPOS = XPOS-abs((LAST_X-X));
			cylinder {<XPOS,Y,-CYLEN> <XPOS,Y,CYLEN> .005}
			#local LAST_X = X;
			#local ANGLE = ANGLE + 1;
			#if((ANGLE = 360) | (ANGLE = (360*2)))
				#local XSCALE = XSCALE * 1;
				#local YSCALE = YSCALE * .5;
			#end
		#end
	}

	translate <-.75/2,0,0>

	pigment {radial frequency 5 rotate <90,0,0>} normal {wrinkles}
}
#end

#declare box_kite = union
{
	#local STICKRAD = .05;

	#local stick_support = union
	{
		#local stick_box = union
		{
			#local stick_side = union
			{
				cylinder{<-1,1,0> <1,1,0> STICKRAD}
				cylinder{<-1,1,0> <1,1,0> STICKRAD rotate <0,0,90>}
				cylinder{<-1,1,0> <1,1,0> STICKRAD rotate <0,0,180>}
				cylinder{<-1,1,0> <1,1,0> STICKRAD rotate <0,0,270>}
			}
		
			object {stick_side translate <0,0,-1>}
			object {stick_side translate <0,0,1>}
			cylinder {<-1,1,-1> <-1,1,1> STICKRAD}
			cylinder {<-1,1,-1> <-1,1,1> STICKRAD rotate <0,0,90>}
			cylinder {<-1,1,-1> <-1,1,1> STICKRAD rotate <0,0,180>}
			cylinder {<-1,1,-1> <-1,1,1> STICKRAD rotate <0,0,270>}
		}
		
		object {stick_box translate <-1.5,0,0>}
		object {stick_box translate <1.5,0,0>}
		//	object {stick_box scale <.5,.5,1>}
		
		// connectors
		cylinder {<-.5,.5,-1> <-.5,.5,1> STICKRAD}
		cylinder {<-.5,.5,-1> <-.5,.5,1> STICKRAD rotate <0,0,90>}
		cylinder {<-.5,.5,-1> <-.5,.5,1> STICKRAD rotate <0,0,180>}
		cylinder {<-.5,.5,-1> <-.5,.5,1> STICKRAD rotate <0,0,270>}
		
		cylinder {<-.5,.5,-1> <.5,.5,-1> STICKRAD}
		cylinder {<-.5,.5,-1> <.5,.5,-1> STICKRAD rotate <180,0,0>}
		cylinder {<-.5,-.5,-1> <.5,-.5,-1> STICKRAD}
		cylinder {<-.5,-.5,-1> <.5,-.5,-1> STICKRAD rotate <180,0,0>}
		
		texture {T_Wood10}
	}

	#local wrapper = difference
	{
		#local ssc = 1+(STICKRAD*2);
		superellipsoid {<.1 ,.1> scale <ssc+(STICKRAD*1),ssc,ssc>}
		superellipsoid {<.1 ,.1> scale <ssc+(STICKRAD*1),ssc,ssc> scale <2,.99,.99>}
	}

	object {stick_support}
	object {wrapper pigment {rgbt <1,.45,.8,.2>} normal {wrinkles} finish {ambient .6 diffuse .8} translate <-1.5,0,0>}
	object {wrapper pigment {rgbt <.2,.7,1,.2>} normal {wrinkles} finish {ambient .6 diffuse .8} translate <1.5,0,0>}
	Make_Streamer(1)
	object {streamer rotate <0,-90,0> translate <-1.5,1,-1>}
	Make_Streamer(.5)
	object {streamer rotate <0,-90,0> translate <1.5,1,-1>}
	Make_Streamer(.7)
	object {streamer rotate <180,0,0> scale <.75,1,1> rotate <0,-90,0> translate <1.5,-1,-1>}
	Make_Streamer(.75)
	object {streamer rotate <180,0,0> scale <.75,1,1> rotate <0,-90,0> translate <-1.5,-1,-1>}
}

#declare bird = union
{
	#local body = union
	{
		sphere {<0,0,0> .5 scale <3,.75,1>}
		intersection
		{
			sphere {<0,0,0> .5 scale <5,.75,1>}
			box {<-3,-1,-1> <0,1,1>}
		}
		rotate <0,-90,0>
	}

	#local wing = intersection
	{
		difference
		{
			sphere {<0,0,0> 1 scale <3,1,1>}
			sphere {<0,0,0> 1 scale <3,.95,1.1>}
		}
		box {<0,0,-1.1> <3.1,1.1,1.1>}
	}

	#local tail = union
	{
		#local tf = superellipsoid {<1,.5> scale <.25,.05,1> translate <0,0,-.8>}
		object {tf}
		object {tf rotate <0,15,0>}
		object {tf rotate <0,-15,0>}
		object {tf rotate <0,30,0>}
		object {tf rotate <0,-30,0>}
	}

	object {body}
	object {wing translate <.4,-.75,0>}
	object {wing rotate <0,180,0> translate <-.4,-.75,0>}
	object {tail translate <0,0,-2>}

	pigment {White}
	rotate <0,180,0>
}

object {box_kite scale 1.25 rotate <0,45,0> translate <0,10,0>}

// rope
cylinder {<-5,-1,-6> <0,10,0> .01 pigment {White}}

object {bird rotate <0,90,0> translate <35,110,60> finish {diffuse .6 ambient .35}}
object {bird translate <70,100,120>}
object {bird rotate <0,45,0> translate <50,90,120>}

background {SkyBlue}

// light and camera

light_source {<-500,800,-1500> color White}

camera
{
	#if(HOF = on)
		right <1,0,0>
		up <0,1,0>
		location <-0.5,-4.25,-15>
		look_at <1,8.5,0>
	#else
		location <0,0,-10>
		look_at <1,8.5,0>
	#end
}

// ground
//plane {y,0 pigment {rgb <1,1,.5>} finish {ambient .5 diffuse 1 crand .05}}

#if(on)
//  Darin Dugger's "Kite" clouds - from skies.inc
sky_sphere
{
    pigment {
        bozo
        turbulence 1.5
        octaves 10
        omega .5
        lambda 2.5
        color_map {
            [0.0, 0.5 color rgbf<.75, .75, .75, 0>
                      color rgbf<.9, .9, .9, .9> ]
            [0.5, 0.7 color rgbf<.9, .9, .9, .9>
                      color rgbf<1, 1, 1, 1> ]
            [0.7, 1.0 color rgbf<1, 1, 1, 1>
                      color rgbf<1, 1, 1, 1> ]
        }
    }
}
#end
