// BW - G.40 - "Squirt"
// History IRTC - 04.99
// British Jet - May 15th 1941

#include "colors.inc"
#include "skies.inc"

#declare HOF = on;	// use with 'square' image

// axis
#if(off)
	cylinder {<-10,0,0> <10,0,0> .01 pigment {Red}}
	cylinder {<0,10,0> <0,-10,0> .01 pigment {Red}}
	#if(off)
		#local XG = -10;
		#local XGI = .5;
		#while(XG < 10+XGI)
			cylinder {<XG,-1,0> <XG,1,0> .01 pigment {Red} finish {diffuse 1}}
			cylinder {<-1,XG,0> <1,XG,0> .01 pigment {Red} finish {diffuse 1}}
			#local XG = XG + XGI;
		#end
	#end
#end

#declare camf_text = texture
{
	pigment
	{
		gradient y
		color_map
		{
			[0.0	rgb <0,.4,0>]
			[0.5	rgb <0,.4,0>]
			[0.5	rgb <.6,.13,.13>]
			[1.0	rgb <.6,.13,.13>]
		}
		turbulence .25
		scale 2
		rotate <0,0,20>
	}
}

#declare body = union
{
	cylinder {<-.05,0,0> <.05,0,0> 1.1 texture {camf_text}}

	// front
	difference
	{
		intersection
		{
			lathe
			{
				cubic_spline
				4,
				<-1.1,0>,<0,4.5>,<1.1,0>,<0,-4.5>
				rotate <0,0,90>
			}
			box {<-3.7,-10,-10> <0,10,10>}
		}

		cone {<-4,0,0> , .475 , <-2,0,0> 0}
	}

	// rear
	#declare rshell = lathe
	{
		cubic_spline
		4,
		<-1.1,0>,<.25,8>,<1.1,0>,<0,-8>
		rotate <0,0,-90>
	}

	object {rshell texture {camf_text}}

	object
	{
		rshell scale 1.001
		pigment
		{
			image_map
			{
				gif "rp.gif"
				filter 14,1.0
				once
			}
			scale <2,1,1>
			translate <4,-.5,0>
		}
	}

	cone {<4,0,0> , .8 , <8.95,0,0>,.25}

	scale 1.2

	texture {camf_text}
}

#declare wing = intersection
{
	lathe
	{
		cubic_spline
		7
		<0,100>,
		<0,67>,<88,54>,
		<90,36>,<18,15>,<0,0>,
		<0,0>

		scale <1,1,2.5>
	}

	box {<0,0,-1> <120,120,1>}

	#declare WSCALE = .075;
	scale WSCALE
	translate <0,-46*WSCALE,0>
}

#declare cockpit = union
{
	// back
	intersection
	{
		sphere {<0,0,0> 1 scale <3.25,1,.75>}
		box {<0,-.5,-1> <5,1,1>}
		texture {camf_text}
	}

	// front
	#local SX_SCALE = 2;
	#local SY_SCALE = 1.25;
	#local SZ_SCALE = .75;
	#declare shell = intersection
	{
		difference
		{
			sphere {<0,0,0> 1 scale <SX_SCALE,SY_SCALE,SZ_SCALE>}
			sphere {<0,0,0> 1 scale <SX_SCALE-.025,SY_SCALE-.025,SZ_SCALE-.025>}
		}
		box {<-5,-.5,-1> <0,1,1>}
	}

	// glass
	object
	{
		shell
		pigment {rgbf <.9,.9,.9,.9>}
		finish {ambient 0 diffuse 0 reflection .25 specular 1 roughness .001} interior{ior 1.33}
	}

	intersection
	{
		object {shell}
		union
		{
			cylinder {<.05,0,0> <-.1,0,0> 4}
			cylinder {<-.75,0,0> <-.65,0,0> 4}

			cylinder {<0,0,-.45> <0,0,-.4> 5}
			cylinder {<0,0,.45> <0,0,.4> 5}
		}
		pigment {DarkGreen}
	}

	// back of cockpit
	cylinder {<.025,0,0> <-.025,0,0> 1 pigment {DarkGreen} scale <SX_SCALE,SY_SCALE-.025,SZ_SCALE>}

	// pilot
	sphere {<0,0,0> .35 pigment {Gray05} translate <-.5,.5,0>}
	sphere {<0,0,0> .5 scale <.8,1,1> pigment {Gray15} translate <-.5,-.1,0>}
}

#declare tail_fin = union
{

	intersection
	{
		lathe
		{
			cubic_spline
			7
			<0,26>,
			<0,26>,<23,17>,<26,9>,<18,4>,<0,0>,
			<0,-3>
	
			scale <1,1,2.5>
		}

		box {<-8,0,-1> <50,50,1>}

		rotate <0,0,90>
		translate <14,0,0>
	}

	cylinder {<0,0,0> <0,25,0> 1.025 pigment {Black}}

	scale .15*.6
}

#declare rwing = union
{
	intersection
	{
		lathe
		{
			cubic_spline
			6
			<0,22>,
			<1,21>,<38,14>,<34,0>,<1,0>,
			<0,0>
	
			scale <1,1,2.5>
		}
	
		box {<0,0,-1> <50,50,1>}
	}

	cylinder {<0,8,0> <40,8,0> 1.025 pigment {Black}}

	scale .085
}

#declare squirt = union
{
	object {body}
	object {wing rotate <0,-90,0> rotate <0,0,90> rotate <-3,0,0> translate <20*WSCALE,-.9,.81>}
	object {wing rotate <0,-90,0> rotate <0,0,90> rotate <180,0,0> rotate <3,0,0> translate <20*WSCALE,-.9,-.81>}
	object {cockpit translate <0,1.1,0>}
	object {tail_fin translate <8,.75,0>}
	object {rwing rotate <0,0,90> rotate <90,0,0> translate <10.25,0.2,0>}
	object {rwing rotate <0,0,90> rotate <270,0,0> translate <10.25,0.2,0>}
	texture {camf_text}
}

// test objects
//object {body scale 2}
//object {wing rotate <0,-90,0> rotate <0,0,90> rotate <-10,0,0>}
//object {tail_fin scale 1}
//object {rwing}
//object {squirt scale 1.5 rotate <0,0,0>}

// final scene
object {squirt scale 1.25 rotate <0,0,0> rotate <0,-80,50> rotate <0,-35,0> translate <0,0,0>} // final ??

background {SkyBlue}

// light and camera

light_source {<-5,-2,-150> color White}
light_source {<-500,800,-1500> color White }

camera
{
	#if(HOF = on)
		right <1,0,0>
		up <0,1,0>
		location <0,0,-26>
	#else
		location <0,0,-20>
	#end
	look_at <0,0,0>
}

#if(on)
	sky_sphere {S_Cloud3}

	// cloud base
	fog
	{
		distance 10
		color rgbf<1,1,1,1>
		fog_type 2
		fog_offset -6
		fog_alt 2
	}
#end
