// BW - Timeline
// History IRTC - 04.99

#include "colors.inc"
#include "textures.inc"
#include "skies.inc"
#include "stones.inc"

// axis
#if(off)
	cylinder {<-2,0,0> <2,0,0> .01 pigment {Red}}
	cylinder {<0,2,0> <0,-2,0> .01 pigment {Red}}
	#if(on)
		#local XG = -2;
		#local XGI = .5;
		#while(XG < 2+XGI)
			cylinder {<XG,-.1,0> <XG,.1,0> .008 pigment {Red} finish {diffuse 1}}
			cylinder {<-.1,XG,0> <.1,XG,0> .008 pigment {Red} finish {diffuse 1}}
			#local XG = XG + XGI;
		#end
	#end
#end


#local FaceText = texture
{
	//pigment {Black}
	pigment {color rgbt <0,0,0,.9>}    // .85
//	pigment {color rgbf <.9,.9,.9,.85>}
}

#macro WatchMaker(CaseTexture,SceneNum)
#declare PocketWatch = object
{
union
{
	difference
	{
		intersection
		{
			sphere {<0,-.05,0> 1 scale <1,.3,1>}
			plane {y,0.1}
			texture {CaseTexture}
		}

		// white face
		cylinder
		{
			<0,0,0> 
			<0,.5,0> .8
			pigment {White}
			finish {diffuse .8}
		}

		#if(on)	// groove
			torus
			{
				.94,.08
				texture {CaseTexture}
				translate <0,.155,0>
			}
		#end
	}

	// centre picture
	cylinder
	{
		<0,0,0> 
		<0,.0005,0> .8
		//pigment {White}
		pigment
		{
			image_map
			{
				#switch(SceneNum)
					#case (1)
						tga "kite.tga"
					#break
					#case (2)
						tga "balloon.tga"
					#break
					#case (3)
						tga "flyer.tga"
					#break
					#case (4)
						tga "squirt.tga"
					#break
				#end
				once
			}
			translate <-.5,-.5,0>
			scale .8/.5
			rotate <90,0,0>
		}
		finish {diffuse 1}
	}

	// glass front - sticks out by .2 apprx.
	sphere
	{
		<0,0,0> .8
		pigment {rgbf <1,1,1,.95>}
		scale <1,.3,1>
		translate <0,.075,0>
		finish {ambient 0 diffuse 0 specular 1 roughness .001 reflection .05}
		interior{ior 1.33}
	}

	#if(on)	// face stuff
	// hands
	cylinder {<0,0,0> <0,0.05,0>.07 texture {FaceText}}
	#local hand = object
	{
		prism
		{
			conic_sweep
			linear_spline
			0,0.62,5
			<-.02,0> <.02,0> <.02,-.01> <-.02,-.01> <-.02,0>
			texture {FaceText}
		}
	}

	#switch(SceneNum)
		#case (1)
			#local BigHandYRot = 195;
			#local LittleHandYRot = 75;
			#local TinyHandYRot = 5;
		#break
		#case (2)
			#local BigHandYRot = -45;
			#local LittleHandYRot = 140;
			#local TinyHandYRot = 95;
		#break
		#case (3)
			#local BigHandYRot = -12;
			#local LittleHandYRot = 55;
			#local TinyHandYRot = 185;
		#break
		#case (4)
			#local BigHandYRot = -100;
			#local LittleHandYRot = 100;
			#local TinyHandYRot = 275;
		#break
	#end

	object {hand scale <3,1,1> rotate <180,0,0> translate <0,0.62,0> rotate <90,0,0> rotate <0,BigHandYRot,0> translate <0,.01,0>}
	object {hand scale <2,.75,1> rotate <180,0,0> translate <0,0.62*.75,0> rotate <90,0,0> rotate <0,LittleHandYRot,0> translate <0,.01,0>}

	// digits
	#if(off)
		// simple
		#local C = 12;
		#local CR = 0;
		#while(CR < C)
			box {<-.02,0,.6> <.02,.01,.7> rotate <0,CR*(360/C),0> texture {FaceText}}
			#local CR = CR + 1;
		#end
	#else
		// hours
		#local C = 12;
		#local CR = 0;
		#while(CR < C)
			box {<-.02,0,.55> <.02,.01,.65> rotate <0,CR*(360/C),0> texture {FaceText}}
			#local CR = CR + 1;
		#end

		// minutes
		#local C = 60;
		#local CR = 0;
		#while(CR < C)
			box {<-.005,0,.7> <.005,.01,.725> rotate <0,CR*(360/C),0> texture {FaceText}}
			#local CR = CR + 1;
		#end

		cylinder {<0,0,0> <0,.01,0> .7 open texture {FaceText}}
		cylinder {<0,0,0> <0,.01,0> .725 open texture {FaceText}}
	#end

	// seconds
	#if(on)
		cylinder {<0,0,0> <0,.01,0> .2 open texture {FaceText} translate <0,0,-.32>}
		#local C = 60;
		#local CR = 0;
		#while(CR < C)
			#if(mod(CR,5) = 0)
				box {<-.001,0,.15> <.001,.0075,.2> rotate <0,CR*(360/C),0> translate <0,0,-.32> texture {FaceText}}
			#else
				box {<-.001,0,.175> <.001,.0075,.2> rotate <0,CR*(360/C),0> translate <0,0,-.32> texture {FaceText}}
			#end
			#local CR = CR + 1;
		#end

		object {hand scale <.5,.25,1> rotate <180,0,0> translate <0,0.62*.25,0> rotate <90,0,0> rotate <0,TinyHandYRot,0> translate <0,.01,-.32>}
		cylinder {<0,0,0> <0,.01,0> .015 texture {FaceText} translate <0,0,-.32>}
	#end
	#end // end of face stuff

	// chain point
	cylinder
	{
		<0,0,.85>
		<0,0,1.1> .095
		texture {CaseTexture}
		scale <1.25,1,1>
	}

	sphere
	{
		<0,0,1.2> .16 //0,0,1.225,.15
		texture {CaseTexture}
	}

	torus
	{
		.25,.05
		texture {CaseTexture}
		translate <0,0,1.2+.25> //0,0,1.225+.25
	}

	rotate <-90,0,0>
}
}
#end

// single tester
//WatchMaker(T_Stone16,3)
//object {PocketWatch scale .85 rotate <0,0,0> translate <0,0,0>}

// final scene
WatchMaker(T_Stone18,1)
object {PocketWatch scale .85 rotate <0,0,0> translate <-1.5,.25,0>}
WatchMaker(T_Stone16,2)
object {PocketWatch scale .85 rotate <0,0,0> translate <-.65,-.9,-.1>}
WatchMaker(T_Stone19,3)
object {PocketWatch scale .85 rotate <0,0,0> translate <0.35,.2,-.2>}
WatchMaker(T_Stone21,4)
object {PocketWatch scale .85 rotate <0,0,0> translate <1.35,-.8,-.3>}


// time tunnel
#declare time_tunnel = cylinder
{
	<0,0,-5>
	<0,0,5>
	1
	open
	texture {T_Cloud2 scale .25}
}

//object {time_tunnel scale <100,100,800>}
object {time_tunnel scale <1000,1000,8000>} // final

// background light and camera

background {DarkSlateBlue}

light_source {<-500,800,-1500> color White}// shadowless}

camera
{
	location <0,0,-3.65>
	look_at <0,0,0>
}
