// dmhinden.pov
// IRTC entry Mar-Apr 1999 "History"

// development toggles
#declare Paper = 1;
#declare Mast = 1;
#declare Zepp = 1;
#declare FastZepp = 0;
#declare Flames = 1;
#declare FastGround = 0;
#declare OtherMast = 1;
#declare Water = 1;

#if (Mast | OtherMast | Zepp)
#include "girder.inc"
#end
#include "zeppelin.inc"
#include "person.inc"

global_settings {
    max_trace_level 20
}

// constants
// all lengths are in metres
#declare Ground = 0;
#declare MBasePad = 1.0;
// heights for mooring mast
#declare MyA = Ground + 2.0;
#declare MyB = MyA + 4.2;
#declare MyAB = 0.6 * MyA + 0.4 * MyB;
#declare MyC = MyB + 2.55;
#declare MyD = MyC + 3.0;
#declare MyE = MyD + 2.1;
#declare MyF = MyE + 2.5;
#declare MyG = MyF + 2.5;
// widths for mooring mast
#declare MxD = 0;
#declare MxE = MxD + 0.75;
#declare MxF = MxE + 2.5;
#declare MxG = MxF + MBasePad;
#declare MxA = - MxG;
#declare MxB = - MxF;
#declare MxC = - MxE;
// lengths for mooring mast
#declare MzA = 0;
#declare MzB = MzA + MBasePad;
#declare MzC = MzB + 2.25;
#declare MzZ = MzC + 1.0;
#declare MzD = MzC + 3.0;
    // MzE is defined from other parameters by similar triangles
#declare MzE = MzB + (MzD - MzC) * (MxF - MxD) / (MxE - MxD);
#declare MzF = MzE + MBasePad;
// widths of girders
#declare VGW = 0.2;
#declare GW = 0.1;
#declare SW = 0.05;
// numbers of struts
#declare NumDiagStruts = 5;
// platform atop mooring mast
#declare PlatformThickness = 0.1;
#declare PlatformRadius = 0.8;
// distances between zeppelin and mooring mast
#declare ZeppZ = -56;
#declare ZeppX = -190;
#declare ZeppAltitude = 72;
#declare ZeppYaw = radians(23);  // degrees tail is away from mast
#declare ZeppPitch = radians(10); // degrees
#declare TransX = ZeppX - ZeppLength * sin(ZeppYaw) * cos(ZeppPitch);
#declare TransY = ZeppAltitude;
#declare TransZ = ZeppLength * cos(ZeppYaw) * cos(ZeppPitch) + ZeppZ;

// camera definitions - Camera1 is the main camera
#declare Camera1X = 45;
#declare Camera1Y = 2.2;
#declare Camera1Z = -15.5;
#declare Camera1Look = 19;
#declare Camera1 = camera {
    location <Camera1X, Camera1Y, Camera1Z>
    sky <0,1,0.05>
    look_at  <0, Camera1Look, 0>
}

#declare CameraMast1 = camera {
    location <21, 3, -6>
    look_at  <0, 9, 0>
}

#declare CameraMast2 = camera {
    location <0, 20, 6>
    look_at  <0, 0, 6>
    orthographic
}

camera { Camera1 }

// fill lights
light_source { <10, 10, -2> colour rgb<0.7,0.7,0.7>
    shadowless
}  
//light_source { <20, 20, -20> colour rgb<2,2,2>}  

#if (Paper)
difference {
    box { <0,0,0> <1,1,0.001> }
    box { <0.145,0.09,-0.001> <0.85,0.815,0.002> }
    texture {
        pigment { image_map { png "nyt2.png"  } }
        normal { wrinkles 1
            scale 0.02
        }
        finish { ambient 0.3 diffuse 0.8 }
    }
    scale <4,3,1>
    rotate <-19,0,0>
    rotate <0,180+degrees(atan2(Camera1X, Camera1Z)),0>
    translate <41.4,1.7,-16.4>
}
// light on the paper
light_source { <45,2,-17>
    colour rgb <2,2,2>
    spotlight
    point_at <42,2,-16.5>
    radius 50
}
#end // #if (Paper)

#if (Mast) // this is a long if statement...

// Mooring Mast base
union {
    prism { 0.3, 0.6, 4
        <MxA, MzA>, <MxD, MzF>, <MxG, MzA>, <MxA, MzA>
    }
    prism { 1.7, MyA, 4
        <MxA, MzA>, <MxD, MzF>, <MxG, MzA>, <MxA, MzA>
    }
    prism { 0.6, 1.7, 4
        <MxA+0.3, MzA+0.3>, <MxD, MzF-0.4>, <MxG-0.3, MzA+0.3>, <MxA+0.3, MzA+0.3>
    }
    texture {
        pigment { rgb <0.6,0.6,0.6> }
    }
}

// Mooring Mast
union {
    // main vertical struts
    Girder(MxC, MyA, MzC, MxC, MyD, MzC, VGW)
    Girder(MxE, MyA, MzC, MxE, MyD, MzC, VGW)
    Girder(MxD, MyA, MzD, MxD, MyD, MzD, VGW)
    Girder(MxC, MyD, MzC, MxC, MyE, MzC, GW)
    Girder(MxE, MyD, MzC, MxE, MyE, MzC, GW)
    Girder(MxD, MyD, MzD, MxD, MyE, MzD, GW)
    // cross struts from height AB to height B
    Girder(MxC, MyAB, MzC, MxE, MyB, MzC, SW)
    Girder(MxD, MyAB, MzD, MxE, MyB, MzC, SW)
    Girder(MxC, MyAB, MzC, MxD, MyB, MzD, SW)
    Girder(MxC, MyB, MzC, MxE, MyAB, MzC, SW)
    Girder(MxD, MyB, MzD, MxE, MyAB, MzC, SW)
    Girder(MxC, MyB, MzC, MxD, MyAB, MzD, SW)
    // horizontal bracing at height B
    Girder(MxC, MyB, MzC, MxE, MyB, MzC, GW)
    Girder(MxD, MyB, MzD, MxE, MyB, MzC, GW)
    Girder(MxC, MyB, MzC, MxD, MyB, MzD, GW)
    // cross struts from height B to height C
    Girder(MxC, MyB, MzC, MxE, MyC, MzC, SW)
    Girder(MxD, MyB, MzD, MxE, MyC, MzC, SW)
    Girder(MxC, MyB, MzC, MxD, MyC, MzD, SW)
    Girder(MxC, MyC, MzC, MxE, MyB, MzC, SW)
    Girder(MxD, MyC, MzD, MxE, MyB, MzC, SW)
    Girder(MxC, MyC, MzC, MxD, MyB, MzD, SW)
    // horizontal bracing at height C
    Girder(MxC, MyC, MzC, MxE, MyC, MzC, GW)
    Girder(MxD, MyC, MzD, MxE, MyC, MzC, GW)
    Girder(MxC, MyC, MzC, MxD, MyC, MzD, GW)
    // cross struts from height C to height D
    Girder(MxC, MyC, MzC, MxE, MyD, MzC, SW)
    Girder(MxD, MyC, MzD, MxE, MyD, MzC, SW)
    Girder(MxC, MyC, MzC, MxD, MyD, MzD, SW)
    Girder(MxC, MyD, MzC, MxE, MyC, MzC, SW)
    Girder(MxD, MyD, MzD, MxE, MyC, MzC, SW)
    Girder(MxC, MyD, MzC, MxD, MyC, MzD, SW)
    // horizontal bracing at height D
    Girder(MxC, MyD, MzC, MxE, MyD, MzC, GW)
    Girder(MxD, MyD, MzD, MxE, MyD, MzC, GW)
    Girder(MxC, MyD, MzC, MxD, MyD, MzD, GW)
    // cross struts from height D to height E
    Girder(MxC, MyD, MzC, MxE, MyE, MzC, SW)
    Girder(MxD, MyD, MzD, MxE, MyE, MzC, SW)
    Girder(MxC, MyD, MzC, MxD, MyE, MzD, SW)
    Girder(MxC, MyE, MzC, MxE, MyD, MzC, SW)
    Girder(MxD, MyE, MzD, MxE, MyD, MzC, SW)
    Girder(MxC, MyE, MzC, MxD, MyD, MzD, SW)
    // horizontal bracing at height E
    Girder(MxC, MyE, MzC, MxE, MyE, MzC, GW)
    Girder(MxD, MyE, MzD, MxE, MyE, MzC, GW)
    Girder(MxC, MyE, MzC, MxD, MyE, MzD, GW)
    // cross struts from height E to height F
    // these do no go all the way out because the vertical girders
    // are pyramiding in to a point - calculate appropriate ratios
    #declare R1 = (MyF - MyE) / (MyG - MyE);
    #declare R2 = 1 - R1;
    Girder(MxC, MyE, MzC, MxE*R1 + MxD*R2, MyF, MzC*R1 + MzZ*R2, SW)
    Girder(MxD, MyE, MzD, MxE*R1 + MxD*R2, MyF, MzC*R1 + MzZ*R2, SW)
    Girder(MxC, MyE, MzC, MxD, MyF, MzD*R1 + MzZ*R2, SW)
    Girder(MxC*R1 + MxD*R2, MyF, MzC*R1 + MzZ*R2, MxE, MyE, MzC, SW)
    Girder(MxD, MyF, MzD*R1 + MzZ*R2, MxE, MyE, MzC, SW)
    Girder(MxC*R1 + MxD*R2, MyF, MzC*R1 + MzZ*R2, MxD, MyE, MzD, SW)
    // pyramidal top girders
    Girder(MxC, MyE, MzC, MxD, MyG, MzZ, GW)
    Girder(MxE, MyE, MzC, MxD, MyG, MzZ, GW)
    Girder(MxD, MyE, MzD, MxD, MyG, MzZ, GW)
    // diagonal bracing struts, far left
    Girder(MxB, MyA, MzB, MxC, MyD, MzC, GW)
    Girder(MxB, MyA, MzB, MxE, MyD, MzC, GW)
    Girder(MxB, MyA, MzB, MxD, MyD, MzD, GW)
    // diagonal bracing struts, near left
    Girder(MxF, MyA, MzB, MxC, MyD, MzC, GW)
    Girder(MxF, MyA, MzB, MxE, MyD, MzC, GW)
    Girder(MxF, MyA, MzB, MxD, MyD, MzD, GW)
    // diagonal bracing struts, right
    Girder(MxD, MyA, MzE, MxC, MyD, MzC, GW)
    Girder(MxD, MyA, MzE, MxE, MyD, MzC, GW)
    Girder(MxD, MyA, MzE, MxD, MyD, MzD, GW)
    // minor struts in diagonal bracing
    #declare N = NumDiagStruts + 1;
    #declare i = 1;
    #while (i < N)
        #declare Sx1 = MxB + i * (MxC - MxB) / N;
        #declare Sx2 = MxB + i * (MxD - MxB) / N;
        #declare Sx3 = MxB + i * (MxE - MxB) / N;
        #declare Sx4 = MxF + i * (MxC - MxF) / N;
        #declare Sx5 = MxF + i * (MxD - MxF) / N;
        #declare Sx6 = MxF + i * (MxE - MxF) / N;
        #declare Sx7 = MxD + i * (MxC - MxD) / N;
        #declare Sx8 = MxD + i * (MxE - MxD) / N;
        #declare Sy  = MyA + i * (MyD - MyA) / N;
        #declare Sz1 = MzB + i * (MzC - MzB) / N;
        #declare Sz2 = MzB + i * (MzD - MzB) / N;
        #declare Sz3 = MzE + i * (MzC - MzE) / N;
        #declare Sz4 = MzE + i * (MzD - MzE) / N;
        // horizontal struts
        Girder(Sx1, Sy, Sz1, Sx2, Sy, Sz2, SW)
        Girder(Sx1, Sy, Sz1, Sx3, Sy, Sz1, SW)
        Girder(Sx6, Sy, Sz1, Sx5, Sy, Sz2, SW)
        Girder(Sx6, Sy, Sz1, Sx4, Sy, Sz1, SW)
        Girder(MxD, Sy, Sz4, Sx7, Sy, Sz3, SW)
        Girder(MxD, Sy, Sz4, Sx8, Sy, Sz3, SW)
        // increment loop variable and calculate next rung of strut
        // coordinates to do vertical struts
        #declare i = i + 1;
        #declare NSx1 = MxB + i * (MxC - MxB) / N;
        #declare NSx2 = MxB + i * (MxD - MxB) / N;
        #declare NSx3 = MxB + i * (MxE - MxB) / N;
        #declare NSx4 = MxF + i * (MxC - MxF) / N;
        #declare NSx5 = MxF + i * (MxD - MxF) / N;
        #declare NSx6 = MxF + i * (MxE - MxF) / N;
        #declare NSx7 = MxD + i * (MxC - MxD) / N;
        #declare NSx8 = MxD + i * (MxE - MxD) / N;
        #declare NSy  = MyA + i * (MyD - MyA) / N;
        #declare NSz1 = MzB + i * (MzC - MzB) / N;
        #declare NSz2 = MzB + i * (MzD - MzB) / N;
        #declare NSz3 = MzE + i * (MzC - MzE) / N;
        #declare NSz4 = MzE + i * (MzD - MzE) / N;
        // near-vertical struts
        Girder(NSx1, NSy, NSz1, Sx2, Sy, Sz2, SW)
        Girder(NSx1, NSy, NSz1, Sx3, Sy, Sz1, SW)
        Girder(NSx6, NSy, NSz1, Sx5, Sy, Sz2, SW)
        Girder(NSx6, NSy, NSz1, Sx4, Sy, Sz1, SW)
        Girder(MxD, NSy, NSz4, Sx7, Sy, Sz3, SW)
        Girder(MxD, NSy, NSz4, Sx8, Sy, Sz3, SW)
    #end
    texture {
        pigment { gradient y
            colour_map {
                [0.0 rgb <1,0,0>]
                [0.4 rgb <1,0,0>]
                [0.4 rgb <1,1,1>]
                [1.0 rgb <1,1,1>]
            }
            scale ((MyD - MyA) / 2)
            translate <0,MyA,0>
        }
    }
}

// platform at top of mast
cylinder { <MxD, MyG, MzZ>, <MxD, MyG + PlatformThickness, MzZ>, PlatformRadius
    texture {
        pigment { rgb <1,1,1> }
    }
}
// person standing atop mooring mast
Person(MxD + PlatformRadius/2, MyG + PlatformThickness, MzZ, 0)
Person(MxD, MyG + PlatformThickness, MzZ - PlatformRadius/2, 90)

#end // #if (Mast)

#if (OtherMast)
#declare OMx = 13;
#declare OMz = 13;
#declare OMy = 18;
#declare OMf = 0.66;
#declare OMxf = OMx * (1 - OMf);
#declare OMzf = OMz * (1 - OMf);
#declare OMyf = OMy * OMf;
union {
    // main legs
    Girder(OMx,Ground,OMz,0,OMy,0,GW)
    Girder(-OMx,Ground,OMz,0,OMy,0,GW)
    Girder(OMx,Ground,-OMz,0,OMy,0,GW)
    Girder(-OMx,Ground,-OMz,0,OMy,0,GW)
    // support struts to other legs
    Girder(OMx,Ground,OMz,OMxf,OMyf,-OMzf,GW)
    Girder(OMx,Ground,OMz,-OMxf,OMyf,OMzf,GW)
    Girder(-OMx,Ground,OMz,-OMxf,OMyf,-OMzf,GW)
    Girder(-OMx,Ground,OMz,OMxf,OMyf,OMzf,GW)
    Girder(OMx,Ground,-OMz,-OMxf,OMyf,-OMzf,GW)
    Girder(OMx,Ground,-OMz,OMxf,OMyf,OMzf,GW)
    Girder(-OMx,Ground,-OMz,OMxf,OMyf,-OMzf,GW)
    Girder(-OMx,Ground,-OMz,-OMxf,OMyf,OMzf,GW)
    // horizontal struts
    Girder(OMx,OMyf,OMz,OMxf,OMyf,-OMzf,VGW)
    Girder(-OMx,OMyf,-OMz,OMxf,OMyf,-OMzf,VGW)
    Girder(-OMx,OMyf,-OMz,-OMxf,OMyf,OMzf,VGW)
    Girder(OMx,OMyf,OMz,-OMxf,OMyf,OMzf,VGW)
    // vertical spike
    Girder(0,OMy,0,0,OMy+2,0,VGW)
    texture {
        pigment { gradient y
            colour_map {
                [0.0 rgb <1,0,0>]
                [0.4 rgb <1,0,0>]
                [0.4 rgb <1,1,1>]
                [1.0 rgb <1,1,1>]
            }
            scale ((MyD - MyA) / 2)
            translate <0,MyA,0>
        }
    }
    rotate <0,30,0>
    translate <-300,0,-30>
}
#end // #if (OtherMast)

// shed near mast
#declare ShedX = 7;
#declare ShedWidth = 2;
#declare ShedZ = 3.5;
#declare ShedLength = 5;
#declare ShedHeight = 2.5;
#declare ShedRoofAngle = 20;
#declare ShedGable = 0.2;
difference {
    box { <ShedX, -0.1, ShedZ> <ShedX+ShedWidth, ShedHeight+2, ShedZ+ShedLength> }
    box { <-5,0,-5> <5,5,5>
        rotate <0,0,-ShedRoofAngle>
        translate <ShedX+ShedWidth/2, ShedHeight, ShedZ+ShedLength/2>
    }
    texture {
        pigment { gradient y
            colour_map {
                [0.0 rgb <0,0,0>]
                [0.1 rgb <0,0,0>]
                [0.1 rgb <1,1,1>]
                [1.0 rgb <1,1,1>]
            }
            scale 0.1
        }
    }
}
box { <-(ShedWidth/2 + ShedGable)/cos(radians(ShedRoofAngle)), 0, -(ShedLength/2 + ShedGable)>
      <(ShedWidth/2 + ShedGable)/cos(radians(ShedRoofAngle)), 0.2, (ShedLength/2 + ShedGable)>
    texture {
        pigment { rgb <0.7,0.2,0.2> }
    }
    rotate <0,0,-ShedRoofAngle>
    translate <ShedX+ShedWidth/2, ShedHeight, ShedZ+ShedLength/2>
}
// end of shed

// fuel tanks near mast
union {
    #declare xi = -3;
    #while (xi < 4)
        #declare zi = -1.1;
        #while (zi < 2)
            superellipsoid { <1,0.3>
                translate <xi,0,zi>
            }
            #declare zi = zi + 2.2;
        #end
        #declare xi = xi + 2;
    #end
    texture {
        pigment { gradient z
            colour_map {
                [0.0 rgb <1,0,0>]
                [0.1 rgb <0.8,0.8,0.8>]
                [0.9 rgb <0.8,0.8,0.8>]
                [1.0 rgb <1,0,0>]
            }
            scale 0.55
        }
        finish {
            reflection 0.2
        }
    }
    rotate <0,-15,0>
    translate <0,1,0>
    scale <0.5,0.5,1>
    translate <MxG,0,-MzD>
}
// end fuel tanks

// trucks
Truck(0,0,-20,-120)
// end trucks

// trees in the distance
#declare RAND2 = seed(2);
#declare TZ = -120;
#while (TZ < 120)
    Tree(-350,0,TZ,3 + 3 * rand(RAND2))
    #declare TZ = TZ + 3;
#end
// end trees

// people everywhere!
#declare RAND1 = seed(6456);
#declare People = 0;
#while (People < 20)
    Person(-20 + 30*rand(RAND1), 0, -30 + 30*rand(RAND1), 180*rand(RAND1))
    #declare People = People + 1;
#end
#declare People = 0;
#while (People < 50)
    Person(-160 + 50*rand(RAND1), 0, -10 + 50*rand(RAND1), 180*rand(RAND1))
    #declare People = People + 1;
#end
#declare People = 0;
#while (People < 50)
    Person(-160 + 50*rand(RAND1), 0, -10 + 30*rand(RAND1), 180*rand(RAND1))
    #declare People = People + 1;
#end
#declare People = 0;
#while (People < 30)
    Person(-90 + 50*rand(RAND1), 0, 0 + 20*rand(RAND1), 180*rand(RAND1))
    #declare People = People + 1;
#end
// end people

#if (Zepp)
// Zeppelin textures
#declare T_ZeppSkin = texture {
    pigment { rgb <0.6,0.6,0.63> }
    normal { radial 1
        frequency NumRibs
        slope_map {
            [0.0 <1,-1>]
            [0.5 <0,0>]
            [1.0 <1,1>]
        }
    }
}
#declare T_ZeppBurning = texture {
    pigment { crackle
        colour_map {
            [0.0 rgbt <0.45,0.45,0.5,0.3>]
            [0.1 rgbt <0.3,0.3,0.3,0.3>]
            [0.2 rgbt <1,0.4,0.0,0.3>]
            [0.4 rgbt <1,0.5,0.1,0.3>]
            [0.6 rgbt <1,0.6,0.3,0.3>]
            [0.8 rgbt <1,0.8,0.4,0.3>]
            [1.0 rgbt <1,1.0,0.6,0.3>]
        }
        turbulence 0.2
        omega 0.5
        scale 6
    }
    normal { quilted 0.5
        scale 7
    }
    finish {
        ambient 0.5
    }
}
#declare T_ZeppBurnt = texture {
    pigment { rgbt <1,1,1,1> }
}

// the Zeppelin itself
union {
    // gasbag
    object {
        Zeppelin
        texture {
            #if (FastZepp)
            T_ZeppSkin
            #else
            material_map { gif "zeppmap.gif"
                map_type 2
                texture { T_ZeppSkin }
                texture { T_ZeppBurning scale <1,1/ZeppLength,1> }
                texture { T_ZeppBurnt }
            }
            scale <1,ZeppLength,1>
            rotate <0,-90,0>
            #end // #if (FastZepp)
        }
    }
    // gondola
    superellipsoid { <1,0.25>
        texture { gradient z
            texture_map {
                [0.0 pigment { rgb <0.0,0.0,0.1> } finish { reflection 0.5 } ]
                [0.4 pigment { rgb <0.0,0.0,0.1> } finish { reflection 0.5 } ]
                [0.4 pigment { rgb <0.7,0.7,0.7> }]
                [1.0 pigment { rgb <0.7,0.7,0.7> }]
            }
            scale 2
        }
        scale <1,4.3,3>
        translate <0,190,-19>
    }
    // forward engine car
    object { EngineCar
        rotate <90,0,0>
        translate <2,150,-24>
    }
    // stern engine car
    object { EngineCar
        rotate <100,0,0>
        translate <2,80,-22>
    }
    // stern girder superstructure
    #if (!FastZepp)
    object {
        ZeppGirders
        texture {
            pigment { rgb <0.3,0.3,0.3> }
        }
    }
    #end // #if (!FastZepp)
    // mooring cable
    #declare TorSize = 300;
    intersection {
        torus { TorSize, 0.2 }
        box { <0,-5,-250> <305,5,0> }
        texture {
            pigment { rgb <0.5,0.4,0.1> }
        }
        rotate <0,0,90>
        translate <0,-TorSize,0>
        rotate <-45,0,0>
        translate <0,ZeppLength+1,0>
    }
    // the logo
    box { <0,0,0> <1,1,0.001>
        texture {
            pigment { image_map { gif "hindlogo.gif"  transmit 0, 1 } }
            finish { ambient 0.3 diffuse 0.2 }
        }
        scale <3.89,1,1>
        scale 4
        rotate <0,0,-90>
        rotate <0,-55,0>
        translate <25,208,-20>
    }
    // transform into position
    rotate <degrees(ZeppPitch) - 90, 0, 0>
    rotate <0, -degrees(ZeppYaw), 0>
    translate <TransX, TransY, TransZ>
}
#end // #if (Zepp)

#if (Flames)
// define a fireball object
#macro Fireball(Size, Density)
sphere { <0,0,0> 1
    hollow
    texture {
        pigment { bozo
            colour_map {
                [0.0 rgbt <0,0,0,1>]
                [1.0 rgbt <0,0,0,0.5>]
            }
            turbulence 0.5
            scale 0.1
        }
    }
    interior {
        media {
            emission rgb <1,0.6,0.2> * Density / Size
            scattering {1, rgb <0.5,0.5,0.5> * Density / Size }
            density { spherical
                colour_map{
                    [0.0 rgb <0,0,0>]
                    [0.4 rgb <0.8,0.3,0>]
                    [0.7 rgb <0.8,0.8,0.4>]
                    [1.0 rgb <1,1,0.9>]
                }
                turbulence 0.7
                lambda 2.5
                omega 0.7
            }
        }
    }
    scale Size
}
#end // #macro Fireball()
// define a smokeball object
#macro Smokeball(Size, Density)
sphere { <0,0,0> 1
    hollow
    texture {
        pigment { bozo
            colour_map {
                [0.0 rgbt <0,0,0,1>]
                [1.0 rgbt <0,0,0,0.5>]
            }
            turbulence 0.5
            scale 0.1
        }
    }
    interior {
        media {
            absorption rgb <0.6,0.6,0.6> * Density / Size
            scattering {1, rgb <0.5,0.5,0.5> * Density / Size }
            density { spherical
                colour_map{
                    [0.0 rgb <0,0,0>]
                    [0.4 rgb <0.2,0.1,0>]
                    [0.7 rgb <0.3,0.3,0.2>]
                    [1.0 rgb <0.5,0.5,0.45>]
                }
                turbulence 0.7
                lambda 2.5
                omega 0.7
            }
        }
    }
    scale Size
}
#end // #macro Smokeball()

// define an explosion light source that looks like a fireball
#macro Explosion(Size,Density,TX,TY,TZ,RX,RY,RZ)
light_source { <0,0,0>
    rgb Density*<1.5,1,0.2>
    looks_like { Fireball(Size,Density)
        rotate <RX,RY,RZ> // rotation to randomise appearance of turbulence
    }
    translate <TX,TY,TZ>
}
#end // #macro Explosion()
// define a ball of smoke
#macro Smoke(Size,Density,TX,TY,TZ,RX,RY,RZ)
object {
    Smokeball(Size,Density)
    rotate <RX,RY,RZ>
    translate <TX,TY,TZ>
}
#end // #macro Smoke()

// right above tail
Explosion(20, 1.0, TransX,    TransY + 60,  TransZ,    0, 0, 0)
Explosion(50, 1.0, TransX,    TransY + 140, TransZ,    100, 0, 100)
Explosion(25, 1.0, TransX,    TransY + 20,  TransZ,    -70, -50, 100)
Explosion(60, 0.3, TransX-40, TransY + 80,  TransZ-20, 50, 180, -140)
Smoke(    25, 1.0, TransX+20, TransY + 100, TransZ+20, -70, 0, -20)
// astern of tail
Explosion(18, 0.3, TransX,    TransY + 40,  TransZ+30, 0, -50, 150)
Explosion(40, 1.0, TransX,    TransY + 160, TransZ+70, 0, -50, 150)
// towards nose and camera
Explosion(30, 0.6, TransX+50, TransY + 130, TransZ-60, 200, 100, 0)
Explosion(35, 0.6, TransX+50, TransY + 160, TransZ-45, 120, -30, 40)
Explosion(20, 1.0, TransX+50, TransY + 20,  TransZ-60, 0, 100, -100)
Explosion(20, 1.0, TransX+50, TransY + 70,  TransZ-60, 30, -140, -50)
Explosion(10, 0.5, TransX+30, TransY + 55,  TransZ-50, -130, 120, 10)
Explosion(10, 1.0, TransX+30, TransY + 50,  TransZ-85, -70, 0, 110)
#else // #if (Flames)
    // light to mimic explosion
    light_source { <TransX+20, TransY + 80, TransZ> rgb <3,1.5,0> }
#end // #if (Flames)

#if (Water)
// define a splash of water object
#macro Splash(Density)
sphere { <0,0,0> 1
    hollow
    texture {
        pigment { rgbt <1,1,1,1> }
    }
    interior {
        media {
            emission <0.5,0.5,0.7> * Density
            absorption <1,1,0.9> * Density
            scattering {1, rgb <0.1,0.2,0.2> * Density }
            density { spherical
                colour_map{
                    [0.0 rgb <0.9,0.9,1>]
                    [1.0 rgb <1,1,1>]
                }
                turbulence 0.7
                lambda 2.0
                omega 0.7
            }
            density { spherical
                turbulence 1
                lambda 2.7
                rotate <30,60,70>
            }
            // leopard scaled small to simulate water droplets
            density { leopard
                scale 0.01
                rotate <10,5,10>
            }
        }
    }
}
#end // #macro Splash()
// central splash under forward ballast dump
object { Splash(1)
    scale <7,4,7>
    translate <-180,1,0>
}
// to stern
object { Splash(1)
    scale <10,6,10>
    translate <-180,1,10>
}
// to bow
object { Splash(1)
    scale <10,4,10>
    translate <-180,1,-10>
}
// central splash under stern ballast dump
object { Splash(1)
    scale <9,5,9>
    translate <-180,1,25>
}
// to stern
object { Splash(1)
    scale <13,7,13>
    translate <-180,1,40>
}
// define a cone of water spray
#macro Ballast(Density)
cone { <0,0,0>, 1, <0,1,0> 0
    hollow
    texture {
        pigment { rgbt <1,1,1,1> }
    }
    interior {
        media {
            emission <0.5,0.5,0.7> * Density
            absorption <1,1,0.9> * Density
            scattering {1, rgb <0.1,0.2,0.2> * Density }
            density { cylindrical
                colour_map{
                    [0.0 rgb <0.9,0.9,1>]
                    [1.0 rgb <1,1,1>]
                }
                turbulence 0.7
                lambda 2.0
                omega 0.7
            }
            density { cylindrical }
            density { leopard
                scale 0.05
                rotate <10,5,10>
            }
        }
    }
}
#end // #macro Ballast()
// forward ballast drop
object { Ballast(1.5)
    scale <3,75,3>
    rotate <-5,0,0>
    translate <-180,0,3>
}
// stern ballast drop
object { Ballast(1.5)
    scale <3,70,3>
    rotate <-4,0,0>
    translate <-185,0,25>
}
#end // #if (Water)

// overcast sky
sky_sphere {
    pigment { gradient y
        colour_map {
            [0.0 rgb <0.6,0.6,0.65>]
            [0.5 rgb <0.5,0.5,0.65>]
            [1.0 rgb <0.2,0.15,0.1>]
        }
        scale 2
        translate -1
    }
    pigment { bozo
        colour_map {
            [0.0 rgbt <0,0,0,0.5>]
            [1.0 rgbt <0,0,0,1>]
        }
        scale 0.2
        turbulence 0.3 // was 0.2
    }
    pigment { bozo
        colour_map {
            [0.0 rgbt <0,0,0,0.8>]
            [1.0 rgbt <0,0,0,1>]
        }
        scale 0.07
        turbulence 0.5
    }
}

// the ground
#if (FastGround)
plane { y, Ground
    texture {
        pigment {rgb <0.1,0.6,0>}
    }
}
#else // (!FastGround)

#declare T_Ground = texture {
    pigment { crackle
        colour_map {
            [0.0 rgb <0.1,0.3,0.1>]
            [1.0 rgb <0.3,0.2,0.1>]
        }
        turbulence 0.5
        omega 0.7
    }
    normal { bumps 0.1
        turbulence 0.4
        scale 0.03
    }
    finish {
        ambient 0.02
        diffuse 0.3
    }
}
#declare T_Puddles = texture {
    pigment { rgb <0,0,0.2> }
    normal { ripples 1.2
    }
    finish {
        reflection 0.4
    }
}

plane { y, Ground
    texture { bozo
        texture_map {
            [0.0 T_Ground]
            [0.6 T_Ground]
            [0.65 T_Puddles]
            [1.0 T_Puddles]
        }
        turbulence 0.1
        scale 15
        translate <0,0,20>
    }
}
#end // #if (FastGround)
