// girder.inc
// Defines a Girder() macro to place girders

// Girder(x1,y1,z1,x2,y2,z2,SemiWidth)
// Parameters:
// x1,y1,z1  - coordinates of centre of one end of girder
// x2,y2,z2  - coordinates of centre of other end of girder
// SemiWidth - half thickness of girder

#macro Girder(x1,y1,z1,x2,y2,z2,SemiWidth)
#if (x1 > x2)
    #local xLen = x1 - x2;
    #local yLen = y1 - y2;
    #local zLen = z1 - z2;
#else
    #local xLen = x2 - x1;
    #local yLen = y2 - y1;
    #local zLen = z2 - z1;
#end
#local Length = sqrt(xLen * xLen + yLen * yLen + zLen * zLen);
#local Projection = sqrt(xLen * xLen + zLen * zLen); // projected length on x-z plane
box { <-SemiWidth,0,-SemiWidth> <SemiWidth,Length,SemiWidth>
    #if (Projection != 0 | yLen != 0)
        rotate <0,0,-degrees(atan2(Projection,yLen))>
    #end
    #if (xLen != 0 | zLen != 0)
        rotate <0,-degrees(atan2(zLen,xLen)),0>
    #end
    #if (x1 > x2)
        translate <x2,y2,z2>
    #else
        translate <x1,y1,z1>
    #end
}
#end // macro Girder()
