// person.inc
// Defines a Person() macro

#declare RANDP = seed(183);
#macro Person(X, Y, Z, R)
union {
    // legs
    cylinder { <0.125,0,0>, <0.125,0.8,0> 0.075 }
    cylinder { <-0.125,0,0>, <-0.125,0.8,0> 0.075 }
    // torso
    superellipsoid { <0.2,0.2>
        scale <0.2,0.375,0.075>
        translate <0,1.175,0>
    }
    // arms
    cylinder { <0.25,0.8,0>, <0.25,1.5,0> 0.05 }
    cylinder { <-0.25,0.8,0>, <-0.25,1.5,0> 0.05 }
    // head
    sphere { <0,0,0> 1
        scale <0.1,0.13,0.11>
        translate <0,1.675,0>
    }
    texture {
        pigment { rgb <rand(RANDP)/2,rand(RANDP)/2,rand(RANDP)/2> }
    }
    rotate <0,R,0>
    translate <X,Y,Z>
}
#end

#macro Truck(X, Y, Z, R)
// chassis
union {
    superellipsoid { <0.2,0.2>
        translate <0,1.3,0>
    }
    difference {
        superellipsoid { <0.3,0.3> }
        box { <-3,-0.7,-0.7> <3,0.7,0.7> }
        box { <-0.7,-0.7,-3> <0.7,0.7,3> }
        scale <1,0.85,1>
        translate <1,1.15,0>
    }
    superellipsoid { <0.2,0.2>
        scale <2,0.5,1.1>
        translate <1,0.8,0>
    }
    texture {
        pigment { rgb <0.6,0.6,0.7> }
        finish {
            reflection 0.1
        }
    }
    rotate <0,R,0>
    translate <X,Y,Z>
}
// tyres
union {
    superellipsoid { <1,0.3>
        scale <0.3,0.3,0.1>
        translate <-0.5,0.3,0.9>
    }
    superellipsoid { <1,0.3>
        scale <0.3,0.3,0.1>
        translate <-0.5,0.3,-0.9>
    }
    superellipsoid { <1,0.3>
        scale <0.3,0.3,0.1>
        translate <2.5,0.3,0.9>
    }
    superellipsoid { <1,0.3>
        scale <0.3,0.3,0.1>
        translate <2.5,0.3,-0.9>
    }
    texture {
        pigment { rgb <0,0,0> }
    }
    rotate <0,R,0>
    translate <X,Y,Z>
}
#end

#macro Tree(X,Y,Z,H)
sphere { <0,0,0> 1
    scale <H/4,H/2,H/4>
    texture {
        pigment { bozo
            colour_map {
                [0.0 rgb <0.1,0.5,0.1>]
                [0.5 rgb <0.2,0.6,0.2>]
                [0.6 rgbt <1,1,1,1>]
                [1.0 rgbt <1,1,1,1>]
            }
            turbulence 0.3
            scale 0.3
        }
    }
    translate <X,Y+H/2,Z>
}
#end
