

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}


global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera Camera01
  location  <      2.976,      -8.434,      -0.004>
  direction <        0.0,         0.0,      2.4880> 
  sky       <    0.00000,     0.00000,     1.00000> 
  up        <        0.0,         0.0,         1.0> 
  right     <    1.33333,         0.0,         0.0> 
  look_at   <      0.000,       0.000,       1.000>
}



light_source {   // Light001
  <1.188, 4.176, 2.873>
  color rgb <1.000, 1.000, 1.000>
}

light_source { // Arealight001
  <2.450, -11.528, 5.433>
  color rgb <1.000, 1.000, 1.000>
  area_light <2.000, 0.000, 0.000>, <0.000, 1.414, -1.414>, 3, 3
  adaptive 1
  jitter
}





#include "dshist.inc"






prism { // TransSweep011
  linear_sweep
  linear_spline
  -1.0,0.0
  18  // control points
  <-1.0, -1.0>,
  <-0.7, -0.91453>,
  <-0.445, -0.700855>,
  <-0.156, -1.0>,
  <0.10615, -0.85755>,
  <0.203365, -0.57265>,
  <0.73701, -0.672365>,
  <0.81262, -1.019231>,
  <1.0, -1.0>,
  <1.128205, -0.06151>,
  <0.65812, 0.414245>,
  <0.729345, 1.11396>,
  <0.39849, 1.14245>,
  <-0.471225, 1.22792>,
  <-1.0, 1.0>,
  <-0.814815, 0.16>,
  <-1.08547, -0.42849>,
  <-1.0, -1.0>
  rotate -x*90
  material {
    SandstP_2
  }
  scale 0.1
  rotate <90.0, 0.0, -45.0>
  translate  <1.356062, -4.142463, 0.344456>
}


plane { // Plane002
  z,0
  material {
    DryGrass
  }
  translate  -0.317674*z
}


cylinder { // Cylndr012
  <0,0,1>, <0,0,0>, 1 
  material {
    SandstP_1
  }
  scale <0.05, 0.05, 0.25>
  translate  <1.226913, -4.132761, 0.0>
}


box { // Cube032
  <-1, -1, -1>, <1, 1, 1>
  material {
    SandstP_2
  }
  scale <0.05, 0.8, 0.2>
  rotate 50.0*z
  translate  <1.671041, -4.570731, -0.151187>
}


plane { // Plane001
  z,0
  material {
    Carribean_Cloud_Sky
  }
  translate  <-0.264576, 0.0, 4.082036>
}


#declare sky_vect = <0.00000, 0.00000, 1.00000>;
#declare cam_loc = <2.976, -8.434, -0.004>;  // using camera 'Camera01'
#declare lookat = <0.000, 0.000, 1.000>;
#declare light_loc = <1.18765, 4.17579, 2.87254>;  // using light source 'Light001'

#declare flare_size = 1.000;
#declare bright_background = 0;
#declare flare_brightness = 1.000;
#include "NKFlare\35mm.flr"
#include "NKFlare\nkflare.inc"




box { // Cube031
  <-1, -1, -1>, <1, 1, 1>
  material {
    Glass
  }
  scale <0.2, 0.2, 0.3>
  rotate 40.0*z
  translate  <-1.107816, -1.513775, 0.268914>
}


box { // Cube018
  <-1, -1, -1>, <1, 1, 1>
  material {
    AberGranitePR
  }
  scale <0.1, 0.6, 0.6>
  rotate 40.0*z
  translate  <0.307243, -1.222303, 0.430956>
}


#declare Group005 = union {
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.05, 0.05>
    translate  <3.606625, -3.658226, -0.120845>
  }
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.06, 0.01>
    translate  <3.606385, -3.671463, -0.062478>
  }
  translate  <-0.0, 0.145607, 0.124957>
}
#declare Group006 = union {
  box { // Cube008
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.05, 0.05>
    translate  <3.606625, -3.658226, -0.120845>
  }
  box { // Cube009
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.06, 0.01>
    translate  <3.606385, -3.671463, -0.062478>
  }
  translate  <-0.0, 0.145607, 0.124957>
}
#declare Group007 = union {
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.05, 0.05>
    translate  <3.606625, -3.658226, -0.120845>
  }
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.06, 0.01>
    translate  <3.606385, -3.671463, -0.062478>
  }
  object { Group006 }
  translate  <-0.037796, 0.321777, 0.249914>
}
#declare Group008 = union {
  box { // Cube012
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.05, 0.05>
    translate  <3.606625, -3.658226, -0.120845>
  }
  box { // Cube013
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.06, 0.01>
    translate  <3.606385, -3.671463, -0.062478>
  }
  translate  <-0.0, 0.145607, 0.124957>
}
#declare Group009 = union {
  box { // Cube016
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.05, 0.05>
    translate  <3.606625, -3.658226, -0.120845>
  }
  box { // Cube017
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.06, 0.01>
    translate  <3.606385, -3.671463, -0.062478>
  }
  translate  <-0.0, 0.145607, 0.124957>
}
#declare Group010 = union {
  box { // Cube014
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.05, 0.05>
    translate  <3.606625, -3.658226, -0.120845>
  }
  box { // Cube015
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.06, 0.01>
    translate  <3.606385, -3.671463, -0.062478>
  }
  object { Group009 }
  translate  <-0.037796, 0.321777, 0.249914>
}
#declare Group011 = union {
  box { // Cube010
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.05, 0.05>
    translate  <3.606625, -3.658226, -0.120845>
  }
  box { // Cube011
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.06, 0.01>
    translate  <3.606385, -3.671463, -0.062478>
  }
  object { Group008 }
  object { Group010 }
  translate  <-0.084381, 0.645103, 0.506182>
}
#declare TransSweep002 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  6  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <1.0, 1.0>,
  <0.937322, 1.0>,
  <-1.0, -1.0>
  rotate -x*90
  material {
    SandstP_2
  }
  scale <0.5, 0.6, 0.5>
  rotate <-180.0, 90.0, 0.0>
  translate  <1.976034, -3.11693, 0.321329>
}
union { // Group004
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.05, 0.05>
    translate  <3.606625, -3.658226, -0.120845>
  }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.06, 0.01>
    translate  <3.606385, -3.671463, -0.062478>
  }
  object { Group005 }
  object { Group007 }
  object { Group011 }
  object { TransSweep002 }
  material {
    SandstP_2
  }
  rotate 20.0*z
  translate  <-1.39383, -0.192242, 0.0>
}


#declare Group001 = union {
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    scale <2.05, 2.05, 0.17>
    translate  <-0.024593, 0.594208, 2.089662>
  }
  cone { // Cone001
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale 2.0
    translate  <0.0, 0.592196, 0.05434>
  }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    translate  <-0.044332, 0.616631, 0.0>
  }
  material {
    SandstP_1
  }
  scale 0.05
  translate  <2.30963, -4.599545, 0.975175>
}
#declare Group002 = union {
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    scale <2.05, 2.05, 0.17>
    translate  <-0.024593, 0.594208, 2.089662>
  }
  cone { // Cone002
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale 2.0
    translate  <0.0, 0.592196, 0.05434>
  }
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    translate  <-0.044332, 0.616631, 0.0>
  }
  material {
    SandstP_1
  }
  scale 0.05
  translate  <2.516472, -4.599545, 0.975175>
}
#declare TransSweep001 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  26  // control points
  <-1.0, -1.0>,
  <-0.80948, -1.0>,
  <-0.376795, -0.843305>,
  <-0.028775, -0.91453>,
  <0.357435, -0.82906>,
  <0.747165, -1.0>,
  <0.91453, -1.0>,
  <0.9, -0.716752>,
  <0.63604, -0.491311>,
  <0.65812, -0.196581>,
  <0.430199, 0.05698>,
  <0.648148, 0.186752>,
  <0.595442, 0.430484>,
  <0.899715, 0.615556>,
  <1.0, 1.0>,
  <0.816125, 1.042735>,
  <0.04302, 1.042735>,
  <-0.48641, 0.928775>,
  <-0.80442, 1.014245>,
  <-1.0, 1.0>,
  <-1.0, 0.828205>,
  <-1.08547, 0.176225>,
  <-0.94302, -0.09916>,
  <-0.85755, -0.58995>,
  <-1.0, -0.850225>,
  <-1.0, -1.0>
  rotate -x*90
  material {
    SandstP_2
  }
  scale <0.1, 0.15, 0.1>
  rotate <-90.0, 90.0, 0.0>
  translate  <2.442759, -4.625311, 1.182563>
}
union { // Group003
  object { Group001 }
  object { Group002 }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    material {
      SandstP_1
    }
    scale <0.05, 0.05, 1.0>
    rotate -2.02*y
    translate  <2.549141, -4.591015, -0.014423>
  }
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    material {
      SandstP_2
    }
    scale <1.0, 0.2, 1.0>
    translate  <3.202371, -4.515934, -1.017207>
  }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    material {
      SandstP_1
    }
    scale <0.05, 0.05, 1.0>
    rotate -2.02*y
    translate  <2.340672, -4.591015, -0.014423>
  }
  object { TransSweep001 }
}




#declare TransSweep003 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  6  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <0.0, 1.25641>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate -x*90
  material {
    AberGranitePR
  }
  scale <1.0, 1.0, 0.1>
  rotate 90.0*x
  translate  <1.118268, -1.209413, -0.046254>
}
#declare TransSweep004 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-1.05698, 0.923077>,
  <-0.0, 1.200855>,
  <1.05698, 0.923077>,
  <1.05698, 0.957265>,
  <0.0, 1.25641>,
  <-1.05698, 0.957265>,
  <-1.05698, 0.923077>
  rotate -x*90
  material {
    BROWN_BRICK
  }
  rotate 90.0*x
  translate  <1.118843, -0.372366, 0.0>
}
union { // Group012
  object { TransSweep003 }
  object { TransSweep004 }
  scale <0.5, 1.5, 0.6>
  rotate 40.0*z
  translate  <-0.589617, -0.403422, 0.462541>
}


#declare TransSweep005 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.007123, -0.0>,
  <0.615385, 1.0>,
  <-0.501425, 1.0>,
  <-0.992877, -0.02849>,
  <-1.0, -1.0>
  rotate -x*90
  material {
    SandstP_2
  }
  scale <2.428571, 2.0, 2.285714>
  rotate 90.0*x
  translate  <-0.091127, 1.122345, -4.346928>
}
#declare Group014 = union {
  box { // Cube019
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 1.0>
    rotate <-0.0, -0.0, 45.0>
    translate  <-1.733769, 1.476576, -0.716938>
  }
  box { // Cube026
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 1.0>
    rotate <0.0, -0.0, -45.0>
    translate  <-1.735633, -1.828141, -0.693811>
  }
  box { // Cube025
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 1.0>
    rotate <-0.0, -0.0, -0.0>
    translate  <-0.012391, -2.540048, -0.718565>
  }
  box { // Cube024
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 1.0>
    rotate <-0.0, -0.0, 45.0>
    translate  <1.687515, -1.802455, -0.672311>
  }
  box { // Cube023
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 1.0>
    rotate <0.0, 0.0, -90.0>
    translate  <2.25002, -0.11494, -0.714037>
  }
  box { // Cube022
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 1.0>
    rotate <0.0, 0.0, -90.0>
    translate  <-2.390646, -0.210939, -0.670684>
  }
  box { // Cube021
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 1.0>
    rotate <0.0, -0.0, -45.0>
    translate  <1.546889, 1.617202, -0.716938>
  }
  box { // Cube020
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 1.0>
    rotate <-0.0, -0.0, -0.0>
    translate  <-0.024059, 2.109394, -0.670684>
  }
  material {
    Cork
  }
  scale <0.7, 0.7, 0.6>
  translate  <0.178026, 0.022571, 0.462541>
}
union { // Group013
  cylinder { // Cylndr007
    <0,0,1>, <0,0,0>, 1 
    material {
      SandstP_2
    }
    scale <1.428571, 1.428571, 2.5>
    translate  <0.067409, -0.100447, -2.312704>
  }
  cone { // Cone003
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      SandstP_2
    }
    scale <1.428571, 1.428571, 5.0>
    rotate <180.0, 0.0, 180.0>
    translate  <0.055092, -0.01372, 5.151154>
  }
  object { TransSweep005 }
  object { Group014 }
  cylinder { // Cylndr009
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum
    }
    scale <0.049579, 0.05, 0.840402>
    rotate <-0.0, 6.704426, 40.0>
    translate  <1.479518, -0.270727, -1.387622>
  }
  cylinder { // Cylndr008
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum
    }
    scale <0.049579, 0.05, 0.840402>
    rotate <0.0, -6.704426, 40.0>
    translate  <-1.36879, -0.540344, -1.464713>
  }
  scale <0.2, 0.2, 0.3>
  rotate -40.0*z
  translate  <-0.687131, -0.380919, 1.87329>
}


#declare TransSweep006 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  25  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <0.885837, 0.786325>,
  <0.746305, 1.0>,
  <0.605665, 0.814815>,
  <0.512478, 0.916667>,
  <0.436233, 1.0>,
  <0.407224, 0.839031>,
  <0.276801, 0.80057>,
  <0.168595, 0.900285>,
  <0.060389, 1.0>,
  <0.077197, 0.850427>,
  <-0.105425, 0.814815>,
  <-0.212716, 0.916667>,
  <-0.3005, 1.0>,
  <-0.327564, 0.850427>,
  <-0.487265, 0.85755>,
  <-0.585806, 0.94302>,
  <-0.6515, 1.0>,
  <-0.648524, 0.878917>,
  <-0.77151, 0.85755>,
  <-0.9, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate -x*90
  material {
    AberGranitePR
  }
  scale <3.3, 0.45, 0.03>
  rotate 90.0*x
  translate  <0.090447, -0.337154, 4.386689>
}
#declare TransSweep007 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  25  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <0.885837, 0.786325>,
  <0.746305, 1.0>,
  <0.605665, 0.814815>,
  <0.512478, 0.916667>,
  <0.436233, 1.0>,
  <0.407224, 0.839031>,
  <0.276801, 0.80057>,
  <0.168595, 0.900285>,
  <0.060389, 1.0>,
  <0.077197, 0.850427>,
  <-0.105425, 0.814815>,
  <-0.212716, 0.916667>,
  <-0.3005, 1.0>,
  <-0.327564, 0.850427>,
  <-0.487265, 0.85755>,
  <-0.585806, 0.94302>,
  <-0.6515, 1.0>,
  <-0.648524, 0.878917>,
  <-0.77151, 0.85755>,
  <-0.9, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate -x*90
  material {
    AberGranitePR
  }
  scale <2.0, 0.45, 0.03>
  rotate <90.0, 0.0, -90.0>
  translate  <-3.18476, 1.637604, 4.386689>
}
#declare TransSweep008 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  25  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <0.885837, 0.786325>,
  <0.746305, 1.0>,
  <0.605665, 0.814815>,
  <0.512478, 0.916667>,
  <0.436233, 1.0>,
  <0.407224, 0.839031>,
  <0.276801, 0.80057>,
  <0.168595, 0.900285>,
  <0.060389, 1.0>,
  <0.077197, 0.850427>,
  <-0.105425, 0.814815>,
  <-0.212716, 0.916667>,
  <-0.3005, 1.0>,
  <-0.327564, 0.850427>,
  <-0.487265, 0.85755>,
  <-0.585806, 0.94302>,
  <-0.6515, 1.0>,
  <-0.648524, 0.878917>,
  <-0.77151, 0.85755>,
  <-0.9, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate -x*90
  material {
    AberGranitePR
  }
  scale <3.3, 0.45, 0.03>
  rotate 90.0*x
  translate  <0.138612, 3.564196, 4.386689>
}
#declare TransSweep009 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  25  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <0.885837, 0.786325>,
  <0.746305, 1.0>,
  <0.605665, 0.814815>,
  <0.512478, 0.916667>,
  <0.436233, 1.0>,
  <0.407224, 0.839031>,
  <0.276801, 0.80057>,
  <0.168595, 0.900285>,
  <0.060389, 1.0>,
  <0.077197, 0.850427>,
  <-0.105425, 0.814815>,
  <-0.212716, 0.916667>,
  <-0.3005, 1.0>,
  <-0.327564, 0.850427>,
  <-0.487265, 0.85755>,
  <-0.585806, 0.94302>,
  <-0.6515, 1.0>,
  <-0.648524, 0.878917>,
  <-0.77151, 0.85755>,
  <-0.9, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate -x*90
  material {
    AberGranitePR
  }
  scale <2.0, 0.45, 0.03>
  rotate <90.0, 0.0, -90.0>
  translate  <3.413819, 1.685768, 4.386689>
}
#declare Group015 = union {
  object { TransSweep006 }
  object { TransSweep007 }
  object { TransSweep008 }
  object { TransSweep009 }
  cylinder { // Cylndr010
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum
    }
    scale <0.03, 0.03, 1.0>
    rotate <-0.0, -20.0, -20.0>
    translate  <-2.849087, 0.0, 2.984758>
  }
  cylinder { // Cylndr011
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum
    }
    scale <0.03, 0.03, 1.0>
    rotate <-0.0, 20.0, 20.0>
    translate  <3.075205, 0.0, 2.939534>
  }
}
#declare TransSweep010 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  6  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 0.6>,
  <-1.022792, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate -x*90
  material {
    SandstP
  }
  scale <1.0, 2.3, 6.0>
  rotate <90.0, 0.0, -90.0>
  translate  <3.128204, 1.04691, 1.926157>
}
#declare Group016 = union {
  box { // Cube028
    <-1, -1, -1>, <1, 1, 1>
    material {
      Material1
    }
    scale <3.1, 0.03, 1.2>
    rotate -65.0*x
    translate  <0.135671, 1.011304, 3.775537>
  }
  object { TransSweep010 }
  scale <1.0, 1.5, 1.7>
  translate  <-0.045224, 0.0, 0.316565>
}
#declare Windowframe2 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  13  // control points
  <-0.173789, -0.102564>,
  <-0.17698, -1.0>,
  <0.1, -1.0>,
  <0.102564, -0.116809>,
  <1.0, -0.12>,
  <1.0, 0.142735>,
  <0.088319, 0.131054>,
  <0.096, 1.0>,
  <-0.18698, 1.0>,
  <-0.173789, 0.116809>,
  <-1.0, 0.12>,
  <-1.0, -0.1>,
  <-0.173789, -0.102564>
  rotate -x*90
  material {
    Yellow_Pine
  }
  scale <0.55, 0.9, 1.0>
  rotate 90.0*x
  translate  <-1.65582, 0.0, 0.878598>
}
#declare Doorframe = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  10  // control points
  <-1.0, -1.0>,
  <-0.8, -1.0>,
  <-0.794695, 0.809117>,
  <0.814975, 0.809117>,
  <0.82, -1.0>,
  <1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate -x*90
  material {
    Black_Vein_Granit
  }
  scale <1.0, 1.5, 1.0>
  rotate 90.0*x
  translate  <0.071178, 0.0, 1.141979>
}
#declare Window1 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  14  // control points
  <-1.0, -1.0>,
  <0.011966, -1.0>,
  <0.009898, -0.767094>,
  <-0.793765, -0.762927>,
  <-0.794695, 0.666667>,
  <0.814975, 0.666667>,
  <0.819163, -0.762821>,
  <-0.012076, -0.761681>,
  <-0.006211, -1.0>,
  <1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate -x*90
  material {
    SandstP
  }
  scale <0.7, 1.3, 1.0>
  rotate 90.0*x
  translate  <-1.670537, 0.0, 0.951687>
}
#declare Window3 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  14  // control points
  <-1.0, -1.0>,
  <0.011966, -1.0>,
  <0.009898, -0.767094>,
  <-0.793765, -0.762927>,
  <-0.794695, 0.666667>,
  <0.814975, 0.666667>,
  <0.819163, -0.762821>,
  <-0.012076, -0.761681>,
  <-0.006211, -1.0>,
  <1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate -x*90
  material {
    SandstP
  }
  scale <0.7, 1.3, 1.0>
  rotate 90.0*x
  translate  <1.810063, 0.0, 0.951687>
}
union { // Group017
  object { Group015 }
  box { // Cube027
    <-1, -1, -1>, <1, 1, 1>
    material {
      Yellow_Pine_1
    }
    scale <0.7, 0.1, 1.3>
    translate  <0.090447, -0.963296, 0.994919>
  }
  object { Group016 }
  box { // Cube029
    <-1, -1, -1>, <1, 1, 1>
    material {
      SandstP
    }
    scale <0.7, 0.5, 0.2>
    translate  <-1.662023, -0.507593, 2.433041>
  }
  object { Windowframe2 }
  object { Doorframe }
  object { Window1 }
  object { Window3 }
  box { // Cube030
    <-1, -1, -1>, <1, 1, 1>
    material {
      SandstP
    }
    scale <0.7, 0.5, 0.2>
    translate  <1.824781, -0.507593, 2.433041>
  }
  scale <0.4, 0.4, 0.3>
  rotate 40.0*z
  translate  <-1.500632, -2.072162, 0.0>
}


cylinder { // Cylndr013
  <0,0,1>, <0,0,0>, 1 
  material {
    SandstP_1
  }
  scale <0.05, 0.05, 0.25>
  translate  <1.452924, -4.229622, 0.0>
}


