// Mountains

global_settings {
  ambient_light rgb <0.1,0.1,0.1>*2
  max_trace_level 100
  }

camera {
  location <0,500,-2500>
  look_at <0,800,0>
  //focal_point <0,800,2500>
  //blur_samples 10
  //aperture 0.05 
  angle 50
  }

#include "d:\plant.inc"

union {
object { plant
  scale 0.1/2
  translate <-0.9,499.3,-2497.5>
  }
object { plant
  rotate <0,180,0>
  scale 0.08/2
  translate <-0.4,499.26,-2497>
  }
object { plant
  rotate <0,90,0>
  scale 0.07/2
  translate <0.1,499.33,-2498>
  }
object { plant
  rotate <0,270,0>
  scale 0.08/2
  translate <1,499.27,-2497>
  }
translate <0,-0.15,-0.3>
}
     
// Sun
light_source {
  <0,100000,0>
  color rgb <1.2,1.2,0.9>*2.5
  //area_light <1000, 0, 0>, <0, 0, 1000>, 3, 3
  //adaptive 1
  //jitter
  rotate <75,25,0>
  media_interaction on
  }


// Skylight
light_source {
  <0,10000,0>
  color rgb <0.8,0.8,1>/3
  shadowless
  media_interaction off
  }



//Additional Light Sources
light_source {
  <0,500,-2000>
  color rgb <0.6,0.6,0.6>/2
  shadowless
  media_interaction off
  }




sphere {
  <0,0,0>,0.99
  pigment {
    gradient y
    color_map {
      [0.0 color rgb <1,1,1>]
      [0.4 color rgb <1,0.8,0.3>]
      [0.5 color rgb <0.9,0.7,0.2>]
      [0.6 color rgb <0.7,0.6,0.4>]
      [0.8 color rgb <0.5,0.4,0.6>]
      [1.0 color rgb <0.3,0.3,0.4>]
      }
    scale 2
    translate <0,-1,0>
    }
  finish {
    diffuse 1
    ambient 1
    brilliance 5
    }
  scale 110000
  rotate <0,0,15>
  hollow
  }


/*
box {
  <0,0,0><1,1,1>
  pigment {
    image_map { gif "d:\dino1.gif" map_type 0 interpolate 1 }
*/    

plane {
  y,600/4+5
  pigment {
    color rgb <0.2,0.5,0.7>
    }
  finish {
    ambient 0.1
    diffuse 0.5
    reflection 0.5
    specular 1 roughness 0.1
    }
  normal {
    bumps
    turbulence 1
    }
  clipped_by {
    plane {
      z,4000
      }
    }
  }



height_field {
  gif "e:\terrain\dino2.ghf" smooth
  //scale <8000,600,8000>
  //translate <-4000,0,-4000>
  pigment {
    image_map { tga "d:\image1.tga" map_type 0 interpolate 2}
    rotate <90,0,0>
    //scale <8000,600,8000>
    //translate <-4000,0,-4000>
    }
  finish {
    ambient 0.6
    diffuse 0.6
    }
  scale <8000,600,8000>
  translate <-4000,0,-4000>
  }





height_field {
  gif "e:\terrain\mount1.ghf" smooth
  pigment {
    gradient y
    turbulence 0
    color_map {
      [0.0 color rgb <0.5,0.4,0.3>]
      [0.3 color rgb <0.5,0.5,0.5>]
      [0.4 color rgb <1,1,1>]
      [0.5 color rgb <1,1,1>]
      [1.0 color rgb <1,1,1>]
      }
    translate <0,0,0>
    scale 2
    }
  finish {
    ambient 0.5
    diffuse 0.5
    specular 1 roughness 0.01
    }
  scale <15000,2000,15000>
  translate <-7500,0,7500>
  }




box {
  <-100000,2000,-100000><100000,2000.0001,100000>
  
  pigment {
    bozo
    turbulence 0.6
    octaves 8
    omega 0.7
    lambda 2
    color_map {
      [0.0 color rgbt <1,1,1,1>]
      [0.3 color rgbt <1,0.5,0.5,1>]
      [0.7 color rgbt <0.5,0.5,1,0.3>]
      [1.0 color rgbt <0.5,0.5,1,0>]
      }
    //translate <0.4,.1,-0.5>
    translate <-1.3,-0.5,-0.5>
    scale 2000
    warp {
      black_hole <-1000,2000,6000>,3000
      strength 3 falloff 3 inverse turbulence 1  
      }
    }
  
  
  finish {
    ambient 0.5
    diffuse 0.5
    }
  rotate <10,0,0>
  translate <0,2000,0>
  }



// Comet


#declare position=<-2000,2000,5000>



blob {
  threshold 0.600000
  component 1.000000, 1.065006, <-0.038835, 0.164265, 0.000000>
  component 1.000000, 0.454848, <0.378641, 0.429395, 0.000000>
  component 1.000000, 0.433219, <0.199029, -0.308357, 0.000000>
  component 1.000000, 0.462669, <-0.538835, -0.204611, 0.000000>
  component 1.000000, 0.335505, <-0.111650, -0.216138, 0.000000>
  component 1.000000, 0.218439, <-0.228155, 0.458213, 0.000000>
  component 1.000000, 0.371408, <0.017283, 0.628242, 0.000000>
  component 1.000000, 0.513667, <-0.063555, 0.000000, -0.323699>
  component 1.000000, 0.283936, <-0.444884, 0.000000, -0.335260>
  component 1.000000, 0.378006, <-0.283108, 0.000000, 0.358382>
  component 1.000000, 0.378006, <0.225331, 0.000000, 0.404624>
  component 1.000000, 0.339140, <-0.075110, 0.000000, 0.393064>
  component 1.000000, 0.416074, <0.329330, 0.000000, -0.277457>
  component 1.000000, 0.453575, <0.000000, 0.386167, -0.339905>
  component 1.000000, 0.500458, <0.000000, 0.466859, 0.409039>
  component 1.000000, 0.468899, <0.000000, 0.213256, 0.109461>
  component 1.000000, 0.349625, <-0.359223, 0.394813, 0.000000>
  component 1.000000, 0.276524, <-0.456311, 0.256484, 0.000000>
  component 1.000000, 0.310852, <-0.547305, 0.155620, 0.000000>
  component 1.000000, 0.121381, <-0.547305, 0.524496, 0.000000>
  component 1.000000, 0.196317, <-0.444884, 0.000000, 0.450867>
  component 1.000000, 0.240307, <-0.547305, 0.455331, 0.000000>
  component 1.000000, 0.218521, <-0.754705, 0.155620, 0.000000>
  texture {
    pigment { color rgb <0.5,0.3,0> }
    finish { ambient 0.1 diffuse 0.1 brilliance 1 specular 0.5 roughness 0.05 metallic}
    normal { bumps 1 turbulence 1 }
    }
  scale 650
  rotate <-30,0,0>
  translate position-<0,100,0>
  }

difference {
  union {  
    sphere {
      <0,0,0>,1
      clipped_by {
        plane { x,0 }
        }
      }
    sphere {
      <0,0,0>,1
      scale <40,1,1>
      clipped_by {
        plane { -x,0 }
        }
      }
    }
  cylinder {
    <0,0,0>,<40,0,0>,0.7
    }   
  scale 600    
    pigment {
    color rgbt <1,1,1,1>
    }
  finish {
    diffuse 0
    ambient 0
    }
  interior {
    media {
      emission rgb <0.3,0.1,0>/500
      density {
        wood
        rotate <90,90,0>
        turbulence 0.1
        scale <300000,3000,3000>
        color_map {
          [0.0 color rgb <1,1,1>]
          [0.1 color rgb <0,0,0>]
          [0.2 color rgb <.9,.8,.8>]
          [0.3 color rgb <0,0,0>]
          [0.4 color rgb <.8,.6,.4>]
          [0.5 color rgb <0,0,0>]
          [0.6 color rgb <.6,.4,.2>]
          [0.7 color rgb <0,0,0>]
          [0.8 color rgb <.3,.2,.1>]
          [0.9 color rgb <0,0,0>]
          [1.0 color rgb <0,0,0>]
          }
        }
      }
    }
  hollow
  rotate <0,0,30>
  rotate <0,-60,0>
  translate position  
  }

intersection {
  sphere {
    <0,0,0>,1
    }
  box {
    <-1,-1,-1><-0.3,1,1>
    }
  
  scale <800,600,600>    
  pigment {
    color rgbt <1,1,1,1>
    }
  finish {
    diffuse 0
    ambient 0
    }
  interior {
    media {
      emission rgb <1,0.6,0>/500
      density {
        bozo
        rotate <90,90,0>
        turbulence 1
        scale <500,500,500>
        color_map {
          [0.0 color rgb <1,1,1>]
          [0.9 color rgb <0,0,0>]
          [1.0 color rgb <0,0,0>]
          }
        }
      }
    }
  hollow
  rotate <0,0,30>
  rotate <0,-60,0>
  translate position  
  }
  
  
          
light_source {
  <-1200,0,0>
  color rgb <300,200,100>
  fade_power 3
  fade_distance 200
  shadowless
  rotate <0,0,30>
  rotate <0,-60,0>
  translate position
  media_interaction off
  }     





#declare SmokeInt = // lighter version
	interior {
		media {
			scattering { 1, <.002,.002,.002,> extinction 5.0 } // thicker fluffy grey
//			scattering { 1, <.001,.001,.001,> extinction 1.0 } // medium fluffy grey
//			scattering { 1, <.0001,.0001,.0001,> extinction 1.0 } // thin fluffy grey
	    density { spherical
				color_map{
					[0.0 color rgb <0.0,0.0,0.0> ] // outside is transparent
					[0.3 color rgb <0,0,0> ] // this prevents it from reaching the container
//					[1.0 color rgb <.15,.15,.15> ] // inside is almost transparent
					[1.0 color rgb <.95,.95,.95> ] // inside is almost opaque
				}
				scale .6
			turbulence .8
			omega 0.835 // default 0.5, higher = rougher
    	}
		}
	}

#declare SmokeSurfTex =
	texture {
		pigment { color rgbf<1,1,1,1> }
		finish { ambient .1 diffuse 0.7 }
	}
#declare SmokeMaterial =
	material {
		texture { SmokeSurfTex }
		interior { SmokeInt }
	}




sphere { <0,0,0>,1 hollow material { SmokeMaterial } 
  scale <-6000,300,300>
  translate <4000,500,0>
  rotate <0,0,0>
  rotate <0,0,30>
  rotate <0,-60,0>
  translate position
  }

sphere { <0,0,0>,1 hollow material { SmokeMaterial } 
  scale <-6000,300,300>
  translate <4000,500,0>
  rotate <90,0,0>
  rotate <0,0,30>
  rotate <0,-60,0>
  translate position
  }

sphere { <0,0,0>,1 hollow material { SmokeMaterial } 
  scale <-6000,300,300>
  translate <4000,500,0>
  rotate <180,0,0>
  rotate <0,0,30>
  rotate <0,-60,0>
  translate position
  }
  
sphere { <0,0,0>,1 hollow material { SmokeMaterial } 
  scale <-6000,300,300>
  translate <4000,500,0>
  rotate <270,0,0>
  rotate <0,0,30>
  rotate <0,-60,0>
  translate position
  }
  
    



//Raptors

#declare DinoTexture=texture {
  pigment {
    bozo 
    scale 0.25
    color_map {
      [0 color rgb <0.6,0.5,0.2>]
      [1 color rgb <0.2,0.1,0>]
      }
    }
  finish {
    ambient 0.1
    diffuse 1
    //specular 0.5 roughness 0.05 metallic
    }
  
  normal {
    bumps 0.5
    turbulence 0
    scale 0.01
    }
  }
    
#declare AugeTexture=texture {
  pigment {
    color rgb <0,0,0>
    }
  finish {
    ambient 0
    diffuse 0
    specular 1 roughness 0.1
    }
  }
  
#declare GaumenTexture=texture {
  pigment {
    color rgb <1,0.5,0.5>
    }
  finish {
    ambient .3
    diffuse .7
    }
  }

#declare ZahnfleischTexture=texture {
  pigment {
    color rgb <0.75,0.5,0.3>
    }
  finish {
    ambient .3
    diffuse .7
    }
  }
  
#declare ZaehneTexture=texture {
  pigment {
    color rgb <1,1,1>
    }
  finish {
    ambient 3
    diffuse 2
    specular 1 roughness 0.05
    }
  }

#declare Zaehne2Texture=texture {
  pigment {
    color rgb <.5,.5,.5>
    }
  finish {
    ambient 3
    diffuse 2
    specular 1 roughness 0.05
    }
  }
                               
#declare KrallenTexture=texture {
  pigment {
    color rgb <1,1,1>
    }
  finish {
    ambient 0.3
    diffuse 1
    specular 1 roughness 0.05
    }
  }
                               
union {    
  #include "d:\dinos.pov"
  rotate <10,0,0>
  translate <-0.1,498.7,-2498>
  }


