#declare Slab1 = difference {
  cylinder { -10*cm*z, 10*cm*z, 5*cm }
  cylinder { -11*cm*z, 11*cm*z, 4*cm }
  plane { y, 0 }
  bounded_by { box { <-5, 0, -10>*cm, <5, 5, 10>*cm } }
}

#declare Slab2 = difference {
  cylinder { -10*cm*z, 10*cm*z, 5*cm }
  cylinder { -11*cm*z, 11*cm*z, 4*cm }
  plane { -y, 0 }
  bounded_by { box { <-5, 0, -10>*cm, <5, -5, 10>*cm } }
}

#declare Row = union {
  #local i = 0 ;
  #while (i<23)
    object {
      Slab1
      translate (i-11)*18*cm*x
    }
    object {
      Slab2
      translate ((i-11)*18+9)*cm*x
    }
    #local i = i+1 ;
  #end
  // I know this line generates a lot of warnings, but the render
  // time goes from 58s to 9m31s (with only two roof patches in place)!!!
  bounded_by { box { <-203, -5, -10>*cm, <203, 5, 10>*cm } }
  
  rotate 3*x
}

#declare RoofPatch = union {
  #local i = 0 ;
  #while (i<23)
    object {
      Row
      translate (i-11)*19*cm*z
    }
    #local i = i+1 ;
  #end
  translate 4*cm*y
}

#declare Shutter = union {
  difference {
    box {
      <-0.45, -1.30, -0.02>*m, <0.45, 0, 0>*m
    }
    box { <-0.4, -1.25, -0.03>*m, <0.4, -0.05, -0.01>*m }
    box {
      <-7, -7, -3>*cm, <7, 7, 1>*cm
      rotate 45*z
      translate -40*cm*y
    }
    bounded_by { box { <-0.45, -1.30, -0.02>*m, <0.45, 0, 0>*m } }
    pigment {
      wood
      turbulence 0.04            // For best results,  keep this low!
      octaves 3
      scale <0.2, 0.2, 1>        // Scaled for a unit object
      color_map {
	[0.1 rgb <0.60, 0.30, 0.18>*1.4]
	[0.9 rgb <0.30, 0.15, 0.09>*1.4]
      }
      scale 50*cm
      rotate 90*x
      translate 4*m*x
    }
    normal {
      dents 0.9
      scale 3*cm
    }
  }
  cylinder {
    <0, 0, 0>, <0, 0, 50>*cm, 2*cm
    pigment { DMFDarkOak scale 50*cm }
    translate -1.2*m*y
  }
}

#declare House = union {
  union {
    union {
      difference {
	box { 
	  <-4, 0, -4>*m, <0, 5.4, 4>*m 
	}
	box { <-3.9, 2.5, -3.9>*m, <-0.1, 5, 3.9>*m finish { ambient 0.05 } } // inside
	box { <-2.4, 3.5, -4.1>*m, <-1.6, 4.75, 4.1>*m } // windows
	box { <-4.1, 3.5, -2.4>*m, <-3.8, 4.75, -1.6>*m }
	box { <-4.1, 3.5, 1.6>*m, <-3.8, 4.75, 2.4>*m }
	
	box { <-3.9, 0, -3.9>*m, <-0.1, 2.4, 3.9>*m finish { ambient 0.05 } } // inside
	box { <-2.4, 1, -4.1>*m, <-1.6, 2.25, 4.1>*m } // windows
	box { <-4.1, 1, -2.4>*m, <-3.8, 2.25, -1.6>*m }
	box { <-4.1, 0, 1.6>*m, <-3.8, 2.25, 2.4>*m } // door
		
	clipped_by {
	  plane {
	    y, 0
	    rotate 10*z
	    translate 5.05*m*y-2*m*x
	  }
	}
	bounded_by { box { <-4, 0, -4>*m, <0, 5.4, 4>*m } }
      }
      box { <-2.5, 3.3, -4.1>*m, <-1.5, 3.5, -3.9>*m } // window siles
      box { <-2.5, 3.3, 3.9>*m, <-1.5, 3.5, 4.1>*m }
      box { <-4.1, 3.3, -2.5>*m, <-3.9, 3.5, -1.5>*m }
      box { <-4.1, 3.3, 1.5>*m, <-3.9, 3.5, 2.5>*m }
      
      box { <-2.5, 0.8, -4.1>*m, <-1.5, 1, -3.9>*m }
      box { <-2.5, 0.8, 3.9>*m, <-1.5, 1, 4.1>*m }
      box { <-4.1, 0.8, -2.5>*m, <-3.9, 1, -1.5>*m }
    }
    union {
      difference {
	box {
	  <0, 0, 0>*m, <4, 7.9, 4>*m 
	}
	box { <0.1, 5, 0.1>*m, <3.9, 7.5, 3.9>*m finish { ambient 0.05 } }
	box { <1.6, 6, -0.1>*m, <2.4, 7.25, 4.1>*m }
	box { <-0.1, 6, 1.6>*m, <4.1, 7.25, 2.4>*m }
	
	box { <0.1, 2.5, 0.1>*m, <3.9, 4.9, 3.9>*m finish { ambient 0.05 } }
	box { <1.6, 3.5, -0.1>*m, <2.4, 4.75, 4.1>*m }
	box { <3.8, 3.5, 1.6>*m, <4.1, 4.75, 2.4>*m }

	box { <0.1, 0, 0.1>*m, <3.9, 2.49, 3.9>*m finish { ambient 0.05 } }
	box { <1.6, 1, 3.8>*m, <2.4, 2.25, 4.1>*m }
	box { <3.8, 1, 1.6>*m, <4.1, 2.25, 2.4>*m }
	clipped_by {
	  plane {
	    y, 0
	    rotate -10*z
	    translate 7.55*m*y+2*m*x
	  }
	}
	bounded_by { box { <0, 0, 0>*m, <4, 7.9, 4>*m } }
      }
      box { <1.5, 5.8, -0.1>*m, <2.5, 6, 0.1>*m }
      box { <1.5, 5.8, 3.9>*m, <2.5, 6, 4.1>*m }
      box { <-0.1, 5.8, 1.5>*m, <0.1, 6, 2.5>*m }
      box { <3.9, 5.8, 1.5>*m, <4.1, 6, 2.5>*m }
      
      box { <1.5, 3.3, -0.1>*m, <2.5, 3.5, 0.1>*m }
      box { <1.5, 3.3, 3.9>*m, <2.5, 3.5, 4.1>*m }
      box { <3.9, 3.3, 1.5>*m, <4.1, 3.5, 2.5>*m }

      box { <1.5, 0.8, 3.9>*m, <2.5, 1, 4.1>*m }
      box { <3.9, 0.8, 1.5>*m, <4.1, 1, 2.5>*m }
    }
    union {
      difference {
	box {
	  <0, 0, -4>*m, <4, 2.9, 0>*m 
	}
	box { <0.1, 0, -3.9>*m, <3.9, 2.5, -0.1>*m finish { ambient 0.05 } }
	box { <1.6, 1, -4.1>*m, <2.4, 2.25, -3.8>*m }
	box { <3.8, 1, -2.4>*m, <4.1, 2.25, -1.6>*m }
	clipped_by {
	  plane {
	    y, 0
	    rotate -10*x
	    translate 2.55*m*y-2*m*z
	  }
	}
	bounded_by { box { <0, 0, -4>*m, <4, 2.9, 0>*m } }
      }
      box { <1.5, 0.8, -4.1>*m, <2.5, 1, -3.9>*m }
      box { <3.9, 0.8, -2.5>*m, <4.1, 1, -1.5>*m }
    }
    texture {
      T_Stone7
      normal { dents scale 0.1 }
      finish { phong 0 specular 0 }
      pigment { color <1,0.9,.7> }
    }
  }
  union {
    object {
      RoofPatch
      rotate -10*x
      translate <2, 2.55, -2>*m
    }
    object {
      RoofPatch
      rotate -90*y
      rotate -10*z
      translate <2, 7.55, 2>*m
    }
    union {
      object {
	RoofPatch
	translate -202*cm*x
      }
      object {
	RoofPatch
	translate 202*cm*x
      }
      rotate 90*y
      rotate 10*z
      translate <-2, 5.05, 0>*m
    }
    texture {
      pigment { color Firebrick }
      normal { dents 1 scale 2*cm }
    }
  }
  box { // door
    <-3.95, 0, 1.5>*m, <-3.9, 2.3, 2.5>*m 
    pigment {
      DMFDarkOak
      scale 50*cm 
      rotate 90*x
      translate 4*m*x
    }
  }
  
  object {
    Shutter
    rotate 20*x
    translate 1.3*m*y
    translate <-2, 1, -4>*m
  }
  object {
    Shutter
    translate 1.3*m*y
    translate <-2, 3.5, -4>*m
  }
  object {
    Shutter
    rotate 20*x
    rotate 90*y
    translate 1.3*m*y
    translate <-4, 1, -2>*m
  }
  object {
    Shutter
    rotate 90*y
    translate 1.3*m*y
    translate <-4, 3.5, -2>*m
  }
  object {
    Shutter
    rotate 20*x
    rotate 90*y
    translate 1.3*m*y
    translate <-4, 3.5, 2>*m
  }
  object {
    Shutter
    rotate 20*x
    translate 1.3*m*y
    translate <2, 3.5, 0>*m
  }
  object {
    Shutter
    rotate 180*y
    translate 1.3*m*y
    translate <2, 1, 4>*m
  }
  object {
    Shutter
    rotate 20*x
    rotate 180*y
    translate 1.3*m*y
    translate <-2, 1, 4>*m
  }
  object {
    Shutter
    rotate 20*x
    rotate 180*y
    translate 1.3*m*y
    translate <2, 3.5, 4>*m
  }
  object {
    Shutter
    rotate 180*y
    translate 1.3*m*y
    translate <-2, 3.5, 4>*m
  }
}