// Persistence of Vision Ray Tracer Scene Description File
// File: pompei.pov
// Vers: 3.1
// Desc: "Les derniers jours de Pompei", IRTC march-april 1999
// Date: 8.3.99
// Auth: J. BERGER

#version 3.1 ;

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "metrics.inc"

#include "stones.inc"

// Speeding options
#declare FastRounded    = 0 ;
#declare DoRoad         = true ;
#declare DoTree         = true ;
#declare DoFountain     = true ;
#declare DoGrass        = true ;
#declare DoTemple       = true ;
#declare DoHouse        = true ;

#declare DoFlame        = true ;
#declare DoAsh          = true ;
#declare DoVolcanoLight = true ;
#declare DoLava         = true ;

#declare MediaSun       = false ;

// Testing options
#declare NoSun = false ; // true => high ambient light
#declare MapView = false ;

// Tree declarations
#if (DoTree)
  #include "txttree.inc"
  #declare txtTree = texture { txtTree_5 }
  #declare Leaf = object { #include "gtleaf3.inc" }
  // Tree goes from <-33.040,0.000,-19.426> to <18.634,42.111,25.889>
  // leaf size = 4.8
  #declare Tree = union {
    object {
      #include "gtfoliage3.inc"
      texture { txtLeaf_1 }
    }
    object {
      #include "gttree3.inc"
    }
    scale 5*m/42.111
  }
#end

#include "mur.inc"

#declare MortarTexture = texture {
  pigment { Gray }
  normal { dents scale 0.1 } 
  finish { crand 0.05 } scale 0.2 
}

#declare SidewalkStoneTexture = texture {
  T_Stone7
  normal { dents scale 0.1 }
  finish { phong 0 specular 0 }
}

#declare StoneWallRGBlow = color <0.7,0.5,0.35>;
#declare StoneWallRGBhigh = color <1,0.9,.7>;

global_settings
{
  assumed_gamma 2.2
  #if (NoSun)
    ambient_light 9
  #else
    ambient_light 2 //<3, 3, 3>
  #end
  max_trace_level 10
}

sky_sphere
{
  pigment
  {
  gradient y
  color_map { [0.0 color rgb 1] [0.7 color rgb <0.2, 0.2, 1> ] [1.0 color rgb <0.2, 0.2, 1>] }
  }
}
// Set a color of the background (sky)
//background { color White/5 }
#if (MapView)
  camera {
    location 50000*m*y+12*m*z
    look_at  13*m*z
  }
#else
  camera
  {
    location  <0.0 , 1.8 ,-6.2>*m
    look_at   <0.0 , 2.0 , 0.0>
    angle 60
  }
  /*light_source {
    <0.0, 1.8, -6.2>*m
    color White/8
    shadowless
    media_interaction off
  }*/
#end

#if (MapView)
  sphere {
    <0.0 , 1.8 ,-5.0>*m, 1*m
    pigment { color White }
  }
#end

// create a regular point light source
#if (!NoSun)
light_source // Sun
  {
    0*x // light's position (translated below)
    color <1, 1, 0.99>  // light's color
    //translate <-20, 40, -20>*10000*km
    translate <-20, 40, -5>*10000*km
    #if (!MediaSun)
      media_interaction off
    #end
  }
#end

#if (DoRoad)
  object { // Street
    stone_wall (0, 8, 200, 1, 3, 1, 3, <0.2, 0.2>, 0.09,
      SidewalkStoneTexture, StoneWallRGBlow, StoneWallRGBhigh, MortarTexture)
    scale <4, 100, 0.75>*m
    rotate 90*x
    translate -2*x*m-2.5*m*z+20*cm*y
    //bounded_by { box { <-2, 0.2, -2.5>*m, <2, -0.55, 97.5>*m } }
  }

  object { // Left sidewalk
    stone_wall (1, 3, 200, 1, 3, 1, 3, <0.2, 0.2>, 0.08,
      SidewalkStoneTexture, StoneWallRGBlow, StoneWallRGBhigh, MortarTexture)
    scale <1.5, 100, 0.75>*m
    rotate 90*x
    translate -3.5*x*m-2.5*m*z+30*cm*y
    //bounded_by { box { <-3.5, 0.3, -2.5>*m, <-2.0, -0.45, 97.5>*m } }
  }

  object { // Right sidewalk
    stone_wall (2, 3, 200, 1, 3, 1, 3, <0.2, 0.2>, 0.08,
      SidewalkStoneTexture, StoneWallRGBlow, StoneWallRGBhigh, MortarTexture)
    scale <1.5, 100, 0.75>*m
    rotate 90*x
    translate 2*x*m-2.5*m*z+30*cm*y
    //bounded_by { box { <3.5, 0.3, -2.5>*m, <2.0, -0.45, 97.5>*m } }
  }
#else
  box { // "Street"
    <-2, 0.2, -2.5>*m, <2, -0.55, 97.5>*m
    texture { SidewalkStoneTexture }
  }
  box { // "Left sidewalk"
    <-3.5, 0.3, -2.5>*m, <-2.0, -0.45, 97.5>*m
    texture { SidewalkStoneTexture }
  }
  box { // "Right sidewalk"
    <3.5, 0.3, -2.5>*m, <2.0, -0.45, 97.5>*m
    texture { SidewalkStoneTexture }
  }
#end
/*box { // "Houses"
  <3.5, 5, -2.5>*m, <2.0, -0.45, 97.5>*m
  texture { pigment { color White } }
  translate 1.5*m*x
}*/

plane {
  y, 0
  pigment { color Green/2 }
}

union { // volcano
  #if (DoLava)
    #include "lava.inc"
    object {
      Lava
    }
  #end
  /*cone {
    1270*m*y, 1*km,
    0*m*y, 7*km
    
    pigment { color White/10 }
  }*/
  sphere {
    0*m*y, 10.0099*km
    scale <1, 0.5, 1>
    pigment { color rgbf <1, 1, 1, 1> }
    hollow
    interior {
      #if (DoFlame)
	media { // flame
	  emission 100
	  absorption <0, 10, 1000>
	  intervals 50
	  samples 2, 80
	  variance 1/256
	  confidence 0.999
	  density {
	    density_file df3 "cone.df3"
	    color_map {
	      [ 0.00 color rgb <0.0, 0.0, 0.0> ]
	      [ 0.10 color rgb <1.0, 0.001, 0.001> ]
	      [ 0.50 color rgb <1.0, 0.001, 0.001> ]
	      [ 0.90 color rgb <1.0, 0.1, 0.001> ]
	      [ 1.00 color rgb <1.0, 1.0, 1.0> ]
	    }
	    turbulence 0.3
	    //lambda 30.0
	    octaves 4
	    
	    translate <-0.5, 0.0, -0.5>
	    scale <1, 3, 1>*km
	    translate 500*m*y
	    
	    translate -1270*m*y
	  }
	}
      #end
      #if (DoAsh)
	/*media { // ash cloud
	  scattering { 3, <0.8,0.8,0.8>/600 extinction 0.8 }
	  intervals 50
	  samples 2, 80
	  variance 1/256
	  confidence 0.999
	  density {
	    //spherical
	    onion
	    sine_wave
	    color_map {
	      [0.00 color rgb <2, 2, 2> ]
	      [0.01 color rgb <0, 0, 0> ]
	      [1.00 color rgb <0, 0, 0> ]
	    }
	    turbulence .6
	    omega 0.7
	  }
	  scale 2*km
	  scale <1, 0.5, 1>
	}*/
	media { // ash cloud
	  //scattering { 3, <0.8,0.8,0.8>/600 extinction 0.8 }
	  scattering { 3, <0.8,0.8,0.8>/400 extinction 1.0 }
	  intervals 25 // 50
	  samples 2, 160 // 2, 160
	  variance 1/512
	  confidence 0.9999
	  density {
	    //spherical
	    onion
	    sine_wave
	    color_map {
	      [0.00 color rgb <2, 2, 2>/2 ]
	      [0.04 color rgb <0, 0, 0> ]
	      [1.00 color rgb <0, 0, 0> ]
	    }
	    turbulence .6
	    omega 0.7
	    scale 2.5*km
	  }
	  //scale 2*km
	  scale <1, 0.5, 1>
	}
      #end
    }
    translate 1270*y*m
  }
  #if (DoAsh)
    difference {
      sphere { -197*m*z, 10*km }
      sphere { 0*km, 10.01*km }
      plane { -y,  2*1262*m }
      scale <1, 0.5, 1>
      pigment { rgbf 1 }
      hollow
      interior {
	media { // ash cloud
	  //absorption <0.8,0.8,0.8>/2
	  scattering { 3, <0.8,0.8,0.8>/2 }
	  intervals 33 //50
	  samples 3, 455 // 2, 160
	  variance 1/1024
	  confidence 0.99999
	  density {
	    bozo
	    color_map {
	      [0.000 color rgb 0.00]
	      [0.700 color rgb 0.00]
	      [0.850 color rgb 0.10]
	      [0.950 color rgb 0.30]
	      [0.990 color rgb 0.50]
	      //[0.999 color rgb 0.99]
	      [1.000 color rgb 1.00]
	    }
	    //turbulence 0.1
	    scale 5*m*<2, 0.2, 1>
	  }
	  density {
	    gradient y
	    color_map {
	      [0.00 color rgb 1.0]
	      [0.75 color rgb 1.0]
	      [1.00 color rgb 0.0]
	    }
	    scale 8*m*2
	    translate -1270*m*y*2
	  }
	  scale <1, 0.5, 1>
	}
      }
      translate 1270*y*m
    }
  #end
  
  #if (DoVolcanoLight)
    light_source {
      1280*m*y
      color <1, 0.5, 0>/4
      fade_distance 10*km
      fade_power 1
      media_attenuation on
    }
  #end
  
  translate <-4, 0, 9>*km
  //translate 9*km*z
}

#if (DoTree)
  object {
    Tree
    translate 6*m*x+5*m*z
  }
#end

#if (DoFountain)
  #declare Fountain = object { #include "fountain.inc" }
  object {
    Fountain
    translate <-6, 0.25, 5>*m
  }
  object {
    Fountain
    rotate 20*y
    translate <-6, 0.25, 11>*m
  }
  object {
    Fountain
    rotate 190*y
    translate <-11, 0.25, 11>*m
  }
  
#end

box {
  <-20, 0.25, 32>*m, <-3.5, 0, 0>*m
  texture {
    material_map {
      png "pattern.png"
      texture {
	pigment { Blood_Marble scale 20*cm }
	scale <1, 274/476, 1>/2
      }
      texture {
	pigment { Red_Marble scale 20*cm }
	scale <1, 274/476, 1>/2
      }
      texture {
	pigment { White_Marble scale 20*cm }
	scale <1, 274/476, 1>/2
      }
      texture {
	pigment { color Black }
      }
    }
    scale <1, 476/274, 1>*2
    rotate 90*x
  }
}

#if (DoGrass)
  #declare XStart    = -2*m ;
  #declare YStart    = -2*m ;
  #declare ZPos      = 0 ;
  #declare XEnd      = 2*m ;
  #declare YEnd      = 2*m ;
  #declare XStep     = 30*cm ;
  #declare XStepRand = 0.2 ;
  #declare YStep     = 30*cm ;
  #declare YStepRand = 0.2 ;
  #declare MeanBladeHeight = 15*cm ;
  #declare HeightVar = 0.5 ;
  #declare MeanBladeWidth = 5*mm ;
  #declare WidthVar  = 0.5 ;
  #declare MinAngle  = 2 ;
  #declare MaxAngle  = 5 ;
  #declare MinCurve  = 10 ;
  #declare MaxCurve  = 20 ;
  #declare MaxBladeSegs = 3 ;
  #declare MinBladeSegs = 2 ;
  #declare MaxBlades = 4 ;
  #declare MinBlades = 1 ;
  #declare NumTri    = 0 ;
  
  #declare R1 = seed (2174) ;
  
  #declare Grass_Text = texture {
    pigment { color rgb <0.509804, 0.784314, 0.0784314> }
    finish  { diffuse 1 phong 0.2 phong_size 80 }
  }
  #declare Patch1 = #include "Reed_Plugin.inc"
  #declare Grass_Text = texture {
    pigment { color rgb <0.196078, 0.54902, 0.196078> }
    finish  { diffuse 1 phong 0.2 phong_size 80 }
  }
  #declare Patch2 = #include "Reed_Plugin.inc"
  #declare Grass_Text = texture {
    pigment { color rgb <0.0588235, 0.313725, 0.0588235> }
    finish  { diffuse 1 phong 0.2 phong_size 80 }
  }
  #declare Patch3 = #include "Reed_Plugin.inc"
 
  #declare i = 0 ;
  #while (i<60)
    object {
      Patch1
      rotate -90*x
      rotate int(rand(R1)*4)*90
      translate <5.5-rand(R1), 0, 2+rand(R1)>*m
    }
    #declare i = i+1 ;
  #end
  #declare i = 0 ;
  #while (i<30)
    object {
      Patch2
      rotate -90*x
      rotate int(rand(R1)*4)*90
      translate <5.5-rand(R1), 0, 2+rand(R1)>*m
    }
    #declare i = i+1 ;
  #end
  #declare i = 0 ;
  #while (i<30)
    object {
      Patch3
      rotate -90*x
      rotate int(rand(R1)*4)*90
      translate <5.5-rand(R1), 0, 2+rand(R1)>*m
    }
    #declare i = i+1 ;
  #end

  #declare i = 0 ;
  #while (i<60)
    object {
      Patch1
      rotate -90*x
      rotate int(rand(R1)*4)*90
      translate <5.5-rand(R1), 0, 6+rand(R1)>*m
    }
    #declare i = i+1 ;
  #end
  #declare i = 0 ;
  #while (i<30)
    object {
      Patch2
      rotate -90*x
      rotate int(rand(R1)*4)*90
      translate <5.5-rand(R1), 0, 6+rand(R1)>*m
    }
    #declare i = i+1 ;
  #end
  #declare i = 0 ;
  #while (i<30)
    object {
      Patch3
      rotate -90*x
      rotate int(rand(R1)*4)*90
      translate <5.5-rand(R1), 0, 6+rand(R1)>*m
    }
    #declare i = i+1 ;
  #end

  #declare XStart    = -1*m ;
  #declare YStart    = -1*m ;
  #declare ZPos      = 0 ;
  #declare XEnd      = 1*m ;
  #declare YEnd      = 1*m ;
  #declare Grass_Text = texture {
    pigment { color rgb <0.509804, 0.784314, 0.0784314> }
    finish  { diffuse 1 phong 0.2 phong_size 80 }
  }
  #declare Patch1 = #include "Reed_Plugin.inc"
  #declare Grass_Text = texture {
    pigment { color rgb <0.196078, 0.54902, 0.196078> }
    finish  { diffuse 1 phong 0.2 phong_size 80 }
  }
  #declare Patch2 = #include "Reed_Plugin.inc"
  #declare Grass_Text = texture {
    pigment { color rgb <0.0588235, 0.313725, 0.0588235> }
    finish  { diffuse 1 phong 0.2 phong_size 80 }
  }
  #declare Patch3 = #include "Reed_Plugin.inc"

  #declare i = 0 ;
  #while (i<60)
    object {
      Patch1
      rotate -90*x
      rotate int(rand(R1)*4)*90
      translate <4.5-rand(R1), 0, 9+rand(R1)>*m
    }
    #declare i = i+1 ;
  #end
  #declare i = 0 ;
  #while (i<30)
    object {
      Patch2
      rotate -90*x
      rotate int(rand(R1)*4)*90
      translate <4.5-rand(R1), 0, 9+rand(R1)>*m
    }
    #declare i = i+1 ;
  #end
  #declare i = 0 ;
  #while (i<30)
    object {
      Patch3
      rotate -90*x
      rotate int(rand(R1)*4)*90
      translate <4.5-rand(R1), 0, 9+rand(R1)>*m
    }
    #declare i = i+1 ;
  #end

  #declare i = 0 ;
  #while (i<60)
    object {
      Patch1
      rotate -90*x
      rotate int(rand(R1)*4)*90
      translate <6.5-rand(R1), 0, 9+rand(R1)>*m
    }
    #declare i = i+1 ;
  #end
  #declare i = 0 ;
  #while (i<30)
    object {
      Patch2
      rotate -90*x
      rotate int(rand(R1)*4)*90
      translate <6.5-rand(R1), 0, 9+rand(R1)>*m
    }
    #declare i = i+1 ;
  #end
  #declare i = 0 ;
  #while (i<30)
    object {
      Patch3
      rotate -90*x
      rotate int(rand(R1)*4)*90
      translate <6.5-rand(R1), 0, 9+rand(R1)>*m
    }
    #declare i = i+1 ;
  #end

  #declare i = 0 ;
  #while (i<60)
    object {
      Patch1
      rotate -90*x
      rotate int(rand(R1)*4)*90
      translate <8.5-rand(R1), 0, 9+rand(R1)>*m
    }
    #declare i = i+1 ;
  #end
  #declare i = 0 ;
  #while (i<30)
    object {
      Patch2
      rotate -90*x
      rotate int(rand(R1)*4)*90
      translate <8.5-rand(R1), 0, 9+rand(R1)>*m
    }
    #declare i = i+1 ;
  #end
  #declare i = 0 ;
  #while (i<30)
    object {
      Patch3
      rotate -90*x
      rotate int(rand(R1)*4)*90
      translate <8.5-rand(R1), 0, 9+rand(R1)>*m
    }
    #declare i = i+1 ;
  #end

#end

#if (DoTemple)
  object {
    #include "temple.inc"
    translate <-8.5, 0.2, 25>
  }
#end

union {
  box { <-12, 0, 35>*m, <-3.5, 4.55, 100>*m }
  box { <-12.2, 4.5, 34.8>*m, <-3.3, 4.7, 100.2>*m }
  texture {
    T_Stone7
    normal { dents scale 0.1 }
    finish { phong 0 specular 0 }
    pigment { color <1,0.9,.7> }
  }
}

#if (DoHouse)
  #include "house.inc"
  object {
    House
    translate <7.5, 0, 14>*m
  }
  object {
    House
    rotate -90*y
    translate <7.5, 0, 26>*m
  }
  object {
    House
    rotate -90*y
    translate <-19, 0, 36>*m
  }
#end
