//  Persistance of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 2 lights, 22 materials and 2981 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.1 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//  Date : 04/30/1999    (30.04.1999)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 20
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.208,0.208,0.392> }

camera {  //  Camera StdCam
  location  <    -51.732,     -53.768,      15.063>
  direction <        0.0,         0.0,      1.8317> // Aperture is 0.53 degrees
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33333,         0.0,         0.0> // Aspect ratio
  look_at   <    -15.822,      -7.019,      26.535>
}

//
// *******  L I G H T S *******
//

light_source {   // Light001
  <131.265, 142.579, 143.183>
  color rgb <1.000, 0.843, 0.614>*1.2855
  media_interaction off
}

light_source {   // Light1
  <-1813.809, 7325.299, 3631.245>
  color rgb <1.000, 1.000, 1.000>
  media_interaction off
}


//
// ********  MATERIALS  *******
//

#include "lake.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare Ladeteil = union {
  superellipsoid { // SuperQ005
    <0.1, 0.2>
    material {
      black_shiny
    }
    scale <5.0, 10.0, 4.0>
    translate  <0.0, 4.4, 3.6>
  }
  superellipsoid { // SuperQ001
    <0.1, 0.2>
    material {
      black_shiny
    }
    scale <5.0, 10.0, 2.0>
    translate  <0.0, 4.3, -2.0>
  }
}
#declare Radkasten3 = difference {
  sphere { // Sphere029
    <0,0,0>,1
    material {
      black_shiny
    }
    scale <1.0, 3.0, 2.5>
  }
  box { // Cube217
    <-1, -1, -1>, <1, 1, 1>
    material {
      black_shiny
    }
    scale <1.3, 3.2, 2.4>
    translate  -2.8*z
  }
  cylinder { // Cylndr067
    <0,0,1>, <0,0,0>, 1 
    material {
      black_shiny
    }
    scale <2.0, 2.0, 3.0>
    rotate -90.0*y
    translate  <1.4, -0.1, -0.9>
  }
  scale <1.2, 1.0, 1.0>
}
#declare Rad3 = union {
  sphere { // Sphere030
    <0,0,0>,1
    material {
      Aluminum
    }
    scale <1.4, 1.4, 0.2>
  }
  torus { // Torus025
    1.55, 0.45  rotate -x*90
    material {
      black_dull
    }
    translate  -0.1*z
  }
  rotate -90.0*y
  translate  -0.1*x
}
#declare Radgruppe3 = union {
  object { Radkasten3 }
  object { Rad3 }
  scale 1.2
  translate  <5.2, 0.0, -3.4>
}
#declare Radkasten2 = difference {
  sphere { // Sphere031
    <0,0,0>,1
    material {
      black_shiny
    }
    scale <1.0, 3.0, 2.5>
  }
  box { // Cube218
    <-1, -1, -1>, <1, 1, 1>
    material {
      black_shiny
    }
    scale <1.3, 3.2, 2.4>
    translate  -2.8*z
  }
  cylinder { // Cylndr068
    <0,0,1>, <0,0,0>, 1 
    material {
      black_shiny
    }
    scale <2.0, 2.0, 3.0>
    rotate -90.0*y
    translate  <1.4, -0.1, -0.9>
  }
  scale <1.2, 1.0, 1.0>
}
#declare Rad2 = union {
  sphere { // Sphere032
    <0,0,0>,1
    material {
      Aluminum
    }
    scale <1.4, 1.4, 0.2>
  }
  torus { // Torus026
    1.55, 0.45  rotate -x*90
    material {
      black_dull
    }
    translate  -0.1*z
  }
  rotate -90.0*y
  translate  -0.1*x
}
#declare Radgruppe2 = union {
  object { Radkasten2 }
  object { Rad2 }
  scale 1.2
  translate  <3.9, 22.0, -3.4>
}
#declare Radkasten1 = difference {
  sphere { // Sphere033
    <0,0,0>,1
    material {
      black_shiny
    }
    scale <1.0, 3.0, 2.5>
  }
  box { // Cube219
    <-1, -1, -1>, <1, 1, 1>
    material {
      black_shiny
    }
    scale <1.3, 3.2, 2.4>
    translate  -2.8*z
  }
  cylinder { // Cylndr069
    <0,0,1>, <0,0,0>, 1 
    material {
      black_shiny
    }
    scale <2.0, 2.0, 3.0>
    rotate -90.0*y
    translate  <1.4, -0.1, -0.9>
  }
  scale <1.2, 1.0, 1.0>
}
#declare Rad1 = union {
  sphere { // Sphere034
    <0,0,0>,1
    material {
      Aluminum
    }
    scale <1.4, 1.4, 0.2>
  }
  torus { // Torus027
    1.55, 0.45  rotate -x*90
    material {
      black_dull
    }
    translate  -0.1*z
  }
  rotate -90.0*y
  translate  -0.1*x
}
#declare Radgruppe1 = union {
  object { Radkasten1 }
  object { Rad1 }
  scale 1.2
  translate  <-3.9, 22.0, -3.4>
}
#declare Fuehrerhausteil = union {
  superellipsoid { // SuperQ004
    <0.1, 0.2>
    material {
      black_shiny
    }
    scale <5.0, 3.0, 3.0>
    translate  <0.0, 15.4, 3.2>
  }
  superellipsoid { // SuperQ003
    <0.1, 0.2>
    material {
      black_shiny
    }
    scale <5.0, 3.0, 3.0>
    rotate 20.0*x
    translate  <0.0, 16.4, 2.5>
  }
  box { // Cube220
    <-1, -1, -1>, <1, 1, 1>
    material {
      black_shiny
    }
    scale <2.7, 3.0, 2.0>
    rotate 17.5*z
    translate  <1.1, 22.0, -1.5>
  }
  superellipsoid { // SuperQ002
    <0.1, 0.2>
    material {
      black_shiny
    }
    scale <5.0, 3.0, 3.0>
    translate  <0.0, 17.0, -1.0>
  }
  cone { // Cone003
    <0,0,0>, 0.6, <0,0,1>, 1.0
    material {
      black_shiny
    }
    scale <-4.8, -2.2, -8.0>
    rotate <90.0, 0.0, -180.0>
    translate  <0.0, 25.7, 0.6>
  }
  box { // Cube221
    <-1, -1, -1>, <1, 1, 1>
    material {
      black_shiny
    }
    scale <2.7, 3.0, 2.0>
    translate  <0.0, 22.7, -1.5>
  }
  box { // Cube222
    <-1, -1, -1>, <1, 1, 1>
    material {
      black_shiny
    }
    scale <2.7, 3.0, 2.0>
    rotate -17.5*z
    translate  <-1.1, 22.0, -1.5>
  }
}
#declare Fuehrerhaus = difference {
  object { Fuehrerhausteil }
  box { // Cube223
    <-1, -1, -1>, <1, 1, 1>
    material {
      black_shiny
    }
    scale <-3.9, -1.9, -1.5>
    rotate <155.0, 0.0, -180.0>
    translate  <0.0, 17.9, 3.8>
  }
  box { // Cube224
    <-1, -1, -1>, <1, 1, 1>
    material {
      black_shiny
    }
    scale <-6.9, -1.7, -1.5>
    rotate <-180.0, 0.0, -180.0>
    translate  <0.0, 16.3, 3.8>
  }
}
#declare Radkasten = difference {
  sphere { // Sphere035
    <0,0,0>,1
    material {
      black_shiny
    }
    scale <1.0, 3.0, 2.5>
  }
  box { // Cube225
    <-1, -1, -1>, <1, 1, 1>
    material {
      black_shiny
    }
    scale <1.3, 3.2, 2.4>
    translate  -2.8*z
  }
  cylinder { // Cylndr070
    <0,0,1>, <0,0,0>, 1 
    material {
      black_shiny
    }
    scale <2.0, 2.0, 3.0>
    rotate -90.0*y
    translate  <1.4, -0.1, -0.9>
  }
  scale <1.2, 1.0, 1.0>
}
#declare Rad = union {
  sphere { // Sphere036
    <0,0,0>,1
    material {
      Aluminum
    }
    scale <1.4, 1.4, 0.2>
  }
  torus { // Torus028
    1.55, 0.45  rotate -x*90
    material {
      black_dull
    }
    translate  -0.1*z
  }
  rotate -90.0*y
  translate  -0.1*x
}
#declare Radgruppe = union {
  object { Radkasten }
  object { Rad }
  scale 1.2
  translate  <-5.2, 0.0, -3.4>
}
#declare Transporter = union {
  object { Ladeteil }
  object { Radgruppe3 }
  object { Radgruppe2 }
  object { Radgruppe1 }
  object { Fuehrerhaus }
  object { Radgruppe }
  scale 0.3
  rotate -51.606873*z
  translate  <-49.082249, -5.789962, 13.568194>
}


#declare GitterMoben = union {
  box { // Cube013
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 0.25, 0.25>
    rotate <-0.0, -48.40556, -0.0>
    translate  <4.730449, 0.0, 24.259266>
  }
  box { // Cube012
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 0.25, 0.25>
    rotate <-0.0, 48.40556, -0.0>
    translate  <7.310694, 0.0, 24.129633>
  }
  box { // Cube010
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <0.4, 0.4, 7.0>
    rotate 14.864727*y
    translate  <2.795265, 0.0, 26.276734>
  }
  box { // Cube011
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.25, 0.25>
    translate  <6.020571, 0.0, 32.385796>
  }
  box { // Cube009
    <-1, -1, -1>, <1, 1, 1>
    scale <5.5, 0.25, 0.25>
    translate  <6.020571, 0.0, 19.484572>
  }
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <0.4, 0.4, 7.0>
    rotate -16.795506*y
    translate  <9.460898, 0.0, 26.147101>
  }
  material {
    Streaky_Steel_Metal
  }
  rotate -10.0*x
  translate  <-0.111932, -2.297352, -2.530724>
}
#declare GitterMunten = union {
  box { // Cube016
    <-1, -1, -1>, <1, 1, 1>
    scale <7.6, 0.25, 0.25>
    rotate 30.0*y
    translate  <6.235592, 0.0, -14.017469>
  }
  box { // Cube015
    <-1, -1, -1>, <1, 1, 1>
    scale <7.5, 0.25, 0.25>
    rotate 35.0*y
    translate  <6.450612, 0.0, -1.846693>
  }
  box { // Cube014
    <-1, -1, -1>, <1, 1, 1>
    scale <7.0, 0.25, 0.25>
    rotate 35.0*y
    translate  <6.235592, 0.0, 10.754123>
  }
  box { // Cube008
    <-1, -1, -1>, <1, 1, 1>
    scale <7.0, 0.25, 0.25>
    rotate -35.0*y
    translate  <6.020571, 0.0, 10.324082>
  }
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    scale <7.5, 0.25, 0.25>
    rotate -35.0*y
    translate  <6.020571, 0.0, -2.061714>
  }
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    scale <7.6, 0.25, 0.25>
    rotate -30.0*y
    translate  <6.020571, 0.0, -14.017469>
  }
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    scale <6.5, 0.25, 0.25>
    translate  <6.235592, 0.0, -8.12653>
  }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 0.25, 0.25>
    translate  <6.235592, 0.0, 4.085388>
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <0.7, 0.7, 18.0>
    rotate -2.40592*y
    translate  <12.256163, 0.0, -2.0>
  }
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <0.7, 0.7, 18.0>
    rotate 2.596029*y
    translate  -2.0*z
  }
  material {
    Streaky_Steel_Metal
  }
  scale <1.0, 1.0, 1.05>
  rotate -2.606666*x
  translate  <0.0, 0.645061, 0.21502>
}
#declare Group002 = union {
  cylinder { // Cylndr012
    <0,0,1>, <0,0,0>, 1 
    material {
      Streaky_Steel_Metal
    }
    scale <0.3, 0.3, 35.0>
    rotate <145.177109, 47.012909, -148.159332>
    translate  <-1.05035, 1.892023, 4.496006>
  }
  cylinder { // Cylndr013
    <0,0,1>, <0,0,0>, 1 
    material {
      Streaky_Steel_Metal
    }
    scale <0.3, 0.3, 30.0>
    rotate <146.315353, 23.946198, -148.712982>
    translate  <6.281249, 10.715072, 7.574448>
  }
  cylinder { // Cylndr014
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 12.0>
    rotate <155.290482, 0.713857, -123.581253>
    translate  <6.395879, 11.091242, 7.19027>
  }
  cylinder { // Cylndr015
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 3.0>
    rotate <107.895638, -63.944798, -53.02306>
    translate  <6.553148, 25.68971, -9.921665>
  }
  cylinder { // Cylndr016
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 7.0>
    rotate <155.051926, 7.707894, -126.823105>
    translate  <6.395879, 20.107884, -3.555345>
  }
  cylinder { // Cylndr017
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 7.0>
    rotate <74.437958, 64.285194, 129.570663>
    translate  <2.385519, 14.342339, -3.973201>
  }
  rotate <-23.43911, -37.207352, 61.653297>
  translate  <15.780398, 1.677306, 1.838158>
}
#declare Verstrebung = union {
  cylinder { // Cylndr007
    <0,0,1>, <0,0,0>, 1 
    material {
      Streaky_Steel_Metal
    }
    scale <0.3, 0.3, 35.0>
    rotate <145.177109, 47.012909, -148.159332>
    translate  <-1.05035, 1.892023, 4.496006>
  }
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    material {
      Streaky_Steel_Metal
    }
    scale <0.5, 0.5, 30.0>
    rotate <146.315353, 23.946198, -148.712982>
    translate  <6.281249, 10.715072, 7.574448>
  }
  cylinder { // Cylndr011
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 12.0>
    rotate <155.290482, 0.713857, -123.581253>
    translate  <6.395879, 11.091242, 7.19027>
  }
  cylinder { // Cylndr010
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 3.0>
    rotate <107.895638, -63.944798, -53.02306>
    translate  <6.553148, 25.68971, -9.921665>
  }
  cylinder { // Cylndr009
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 7.0>
    rotate <155.051926, 7.707894, -126.823105>
    translate  <6.395879, 20.107884, -3.555345>
  }
  cylinder { // Cylndr008
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 7.0>
    rotate <74.437958, 64.285194, 129.570663>
    translate  <2.385519, 14.342339, -3.973201>
  }
  object { Group002 }
  box { // Cube020
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <0.3, 0.3, 4.0>
    rotate <-70.905296, 13.802184, 34.745026>
    translate  <8.014764, 12.285538, 0.05041>
  }
  box { // Cube018
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <0.4, 0.4, 5.5>
    rotate <52.134972, -59.575367, -117.98645>
    translate  <8.581512, 6.315266, 5.270818>
  }
  box { // Cube017
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <0.4, 0.4, 5.5>
    rotate <-75.382599, 29.649307, -30.502134>
    translate  <2.626968, 6.59747, 5.743122>
  }
  box { // Cube019
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <0.3, 0.3, 4.0>
    rotate <-75.864029, 30.423695, -34.194572>
    translate  <3.64531, 12.751855, 0.625075>
  }
  material {
    Streaky_Steel_Metal
  }
  rotate <-7.358429, -4.152115, 5.953172>
  translate  <1.51664, -1.464665, 2.657736>
}




//
// ********  OBJECTS  *******
//



union { // Kamera
  cylinder { // Cylndr1087
    <0,0,1>, <0,0,0>, 1 
    material {
      black_shiny
    }
    scale <0.5, 0.5, 1.0>
    rotate -90.0*y
    translate  <3.118469, -1.336487, 0.0>
  }
  box { // Cube238
    <-1, -1, -1>, <1, 1, 1>
    material {
      black_shiny
    }
    scale <1.389809, 0.888626, 1.0>
    translate  <0.779617, -1.392174, 0.0>
  }
  cylinder { // Cylndr1086
    <0,0,1>, <0,0,0>, 1 
    material {
      black_shiny
    }
    scale 0.9
    rotate -3.910955*z
    translate  <1.415009, 0.0, -0.503728>
  }
  cylinder { // Cylndr1085
    <0,0,1>, <0,0,0>, 1 
    material {
      black_shiny
    }
    scale 0.9
    rotate -3.910955*z
    translate  <-0.010951, 0.0, -0.503728>
  }
  cylinder { // Cylndr1089
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <0.3, 0.3, 4.0>
    rotate <90.0, 0.0, 18.979401>
    translate  <0.929545, -1.958684, 0.0>
  }
  cylinder { // Cylndr1088
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <0.3, 0.3, 4.0>
    rotate <90.0, 0.0, -20.331207>
    translate  <0.298782, -1.991882, 0.0>
  }
  scale 0.25
  rotate <90.0, -0.0, -12.510517>
  translate  <-4.718949, 27.636511, 18.326758>
}


#declare Wald3 = union {
  sphere { // Sphere161
    <0,0,0>,1
    material {
      Laub
    }
    scale 7.0
    translate  <-50.69723, 375.724504, 17.617496>
  }
  sphere { // Sphere162
    <0,0,0>,1
    material {
      Laub
    }
    scale 7.0
    translate  <78.139084, 368.780682, 17.617496>
  }
  sphere { // Sphere163
    <0,0,0>,1
    material {
      Laub
    }
    scale 10.0
    translate  <63.926907, 365.804758, 18.563265>
  }
  sphere { // Sphere164
    <0,0,0>,1
    material {
      Laub
    }
    scale 11.0
    translate  <55.870729, 378.700427, 21.400572>
  }
  sphere { // Sphere165
    <0,0,0>,1
    material {
      Laub
    }
    scale 13.0
    translate  <38.460101, 373.740554, 18.563265>
  }
  sphere { // Sphere166
    <0,0,0>,1
    material {
      Laub
    }
    scale 7.0
    translate  <26.436025, 360.844885, 17.617496>
  }
  sphere { // Sphere167
    <0,0,0>,1
    material {
      Laub
    }
    scale 9.0
    translate  <12.900884, 367.788707, 18.563265>
  }
  sphere { // Sphere168
    <0,0,0>,1
    material {
      Laub
    }
    scale 10.0
    translate  <1.822576, 378.700427, 15.725959>
  }
  sphere { // Sphere169
    <0,0,0>,1
    material {
      Laub
    }
    scale 12.0
    translate  <-16.153348, 367.788707, 18.563265>
  }
  sphere { // Sphere170
    <0,0,0>,1
    material {
      Laub
    }
    scale 15.0
    translate  <-35.121246, 379.692402, 21.400572>
  }
  sphere { // Sphere171
    <0,0,0>,1
    material {
      Laub
    }
    scale 5.0
    translate  <-47.572001, 367.788707, 14.307306>
  }
  sphere { // Sphere172
    <0,0,0>,1
    material {
      Laub
    }
    scale 8.0
    translate  <-60.634257, 373.740554, 18.090381>
  }
  sphere { // Sphere173
    <0,0,0>,1
    material {
      Laub
    }
    scale 10.0
    translate  <-75.161373, 382.668326, 19.509034>
  }
  rotate -54.661816*z
  translate  <434.931195, 329.376872, -4.548564>
}
#declare Wald2 = union {
  sphere { // Sphere148
    <0,0,0>,1
    material {
      Laub
    }
    scale 7.0
    translate  <-50.69723, 375.724504, 17.617496>
  }
  sphere { // Sphere149
    <0,0,0>,1
    material {
      Laub
    }
    scale 7.0
    translate  <78.139084, 368.780682, 17.617496>
  }
  sphere { // Sphere150
    <0,0,0>,1
    material {
      Laub
    }
    scale 10.0
    translate  <63.926907, 365.804758, 18.563265>
  }
  sphere { // Sphere151
    <0,0,0>,1
    material {
      Laub
    }
    scale 11.0
    translate  <55.870729, 378.700427, 21.400572>
  }
  sphere { // Sphere152
    <0,0,0>,1
    material {
      Laub
    }
    scale 13.0
    rotate -90.0*z
    translate  <38.460101, 373.740554, 18.563265>
  }
  sphere { // Sphere153
    <0,0,0>,1
    material {
      Laub
    }
    scale 7.0
    translate  <26.436025, 360.844885, 17.617496>
  }
  sphere { // Sphere154
    <0,0,0>,1
    material {
      Laub
    }
    scale 9.0
    translate  <12.900884, 367.788707, 18.563265>
  }
  sphere { // Sphere155
    <0,0,0>,1
    material {
      Laub
    }
    scale 10.0
    rotate -30.0*z
    translate  <1.822576, 378.700427, 15.725959>
  }
  sphere { // Sphere156
    <0,0,0>,1
    material {
      Laub
    }
    scale 12.0
    translate  <-16.153348, 367.788707, 18.563265>
  }
  sphere { // Sphere157
    <0,0,0>,1
    material {
      Laub
    }
    scale 15.0
    translate  <-35.121246, 379.692402, 21.400572>
  }
  sphere { // Sphere158
    <0,0,0>,1
    material {
      Laub
    }
    scale 5.0
    translate  <-47.572001, 367.788707, 14.307306>
  }
  sphere { // Sphere159
    <0,0,0>,1
    material {
      Laub
    }
    scale 8.0
    translate  <-60.634257, 373.740554, 18.090381>
  }
  sphere { // Sphere160
    <0,0,0>,1
    material {
      Laub
    }
    scale 10.0
    translate  <-75.161373, 382.668326, 19.509034>
  }
  rotate 144.720886*z
  translate  <658.999172, 868.781607, -4.548564>
}
#declare Wald1 = union {
  sphere { // Sphere135
    <0,0,0>,1
    material {
      Laub
    }
    scale 7.0
    translate  <-50.69723, 375.724504, 17.617496>
  }
  sphere { // Sphere136
    <0,0,0>,1
    material {
      Laub
    }
    scale 7.0
    translate  <78.139084, 368.780682, 17.617496>
  }
  sphere { // Sphere137
    <0,0,0>,1
    material {
      Laub
    }
    scale 10.0
    translate  <63.926907, 365.804758, 18.563265>
  }
  sphere { // Sphere138
    <0,0,0>,1
    material {
      Laub
    }
    scale 11.0
    translate  <55.870729, 378.700427, 21.400572>
  }
  sphere { // Sphere139
    <0,0,0>,1
    material {
      Laub
    }
    scale 13.0
    translate  <38.460101, 373.740554, 18.563265>
  }
  sphere { // Sphere140
    <0,0,0>,1
    material {
      Laub
    }
    scale 7.0
    translate  <26.436025, 360.844885, 17.617496>
  }
  sphere { // Sphere141
    <0,0,0>,1
    material {
      Laub
    }
    scale 9.0
    rotate -150.0*z
    translate  <12.900884, 367.788707, 18.563265>
  }
  sphere { // Sphere142
    <0,0,0>,1
    material {
      Laub
    }
    scale 10.0
    translate  <1.822576, 378.700427, 15.725959>
  }
  sphere { // Sphere143
    <0,0,0>,1
    material {
      Laub
    }
    scale 12.0
    rotate -60.0*z
    translate  <-16.153348, 367.788707, 18.563265>
  }
  sphere { // Sphere144
    <0,0,0>,1
    material {
      Laub
    }
    scale 15.0
    translate  <-35.121246, 379.692402, 21.400572>
  }
  sphere { // Sphere145
    <0,0,0>,1
    material {
      Laub
    }
    scale 5.0
    translate  <-47.572001, 367.788707, 14.307306>
  }
  sphere { // Sphere146
    <0,0,0>,1
    material {
      Laub
    }
    scale 8.0
    translate  <-60.634257, 373.740554, 18.090381>
  }
  sphere { // Sphere147
    <0,0,0>,1
    material {
      Laub
    }
    scale 10.0
    translate  <-75.161373, 382.668326, 19.509034>
  }
  rotate -14.532239*z
  translate  <385.862634, 571.899247, -2.274282>
}
#declare Wald = union {
  sphere { // Sphere134
    <0,0,0>,1
    material {
      Laub
    }
    scale 7.0
    translate  <-50.69723, 375.724504, 17.617496>
  }
  sphere { // Sphere133
    <0,0,0>,1
    material {
      Laub
    }
    scale 7.0
    translate  <78.139084, 368.780682, 17.617496>
  }
  sphere { // Sphere132
    <0,0,0>,1
    material {
      Laub
    }
    scale 10.0
    translate  <63.926907, 365.804758, 18.563265>
  }
  sphere { // Sphere131
    <0,0,0>,1
    material {
      Laub
    }
    scale 11.0
    translate  <55.870729, 378.700427, 21.400572>
  }
  sphere { // Sphere130
    <0,0,0>,1
    material {
      Laub
    }
    scale 13.0
    translate  <38.460101, 373.740554, 18.563265>
  }
  sphere { // Sphere129
    <0,0,0>,1
    material {
      Laub
    }
    scale 7.0
    translate  <26.436025, 360.844885, 17.617496>
  }
  sphere { // Sphere128
    <0,0,0>,1
    material {
      Laub
    }
    scale 9.0
    translate  <12.900884, 367.788707, 18.563265>
  }
  sphere { // Sphere127
    <0,0,0>,1
    material {
      Laub
    }
    scale 10.0
    translate  <1.822576, 378.700427, 15.725959>
  }
  sphere { // Sphere126
    <0,0,0>,1
    material {
      Laub
    }
    scale 12.0
    translate  <-16.153348, 367.788707, 18.563265>
  }
  sphere { // Sphere125
    <0,0,0>,1
    material {
      Laub
    }
    scale 15.0
    translate  <-35.121246, 379.692402, 21.400572>
  }
  sphere { // Sphere124
    <0,0,0>,1
    material {
      Laub
    }
    scale 5.0
    translate  <-47.572001, 367.788707, 14.307306>
  }
  sphere { // Sphere123
    <0,0,0>,1
    material {
      Laub
    }
    scale 8.0
    translate  <-60.634257, 373.740554, 18.090381>
  }
  sphere { // Sphere122
    <0,0,0>,1
    material {
      Laub
    }
    scale 10.0
    translate  <-75.161373, 382.668326, 19.509034>
  }
  translate  <398.161667, 758.901397, -2.274282>
}
union { // Waldgruppe
  object { Wald3 }
  object { Wald2 }
  object { Wald1 }
  object { Wald }
}


#declare Unterarm128 = union {
  sphere { // Sphere1179
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr969
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere1180
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-0.151317, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm128 = union {
  cylinder { // Cylndr968
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere1178
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm128 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-71.43721, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm129 = union {
  sphere { // Sphere1182
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr971
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere1183
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <6.507195, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm129 = union {
  cylinder { // Cylndr970
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere1181
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm129 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <71.509941, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf64 = union {
  sphere { // Sphere1184
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr972
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere1185
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper64 = union {
  cylinder { // Cylndr967
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere1177
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm128 }
  object { Oberarm129 }
  object { Kopf64 }
  translate  <0.0, 0.1, -1.1>
  rotate <-4.748751, -0.0, -0.0>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh128 = union {
  cylinder { // Cylndr975
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr976
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere1188
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere1189
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel128 = union {
  cylinder { // Cylndr974
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere1187
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh128 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-37.412239, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein128 = union {
  cylinder { // Cylndr973
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere1186
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel128 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <20.20797, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh129 = union {
  cylinder { // Cylndr979
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr980
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere1192
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere1193
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel129 = union {
  cylinder { // Cylndr978
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere1191
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh129 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-1.935709, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein129 = union {
  cylinder { // Cylndr977
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere1190
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel129 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-1.708184, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperE12 = union {
  object { Oberkoeper64 }
  object { Bein128 }
  object { Bein129 }
  scale 0.2
  rotate -26.878849*z
  translate  <-25.860623, 0.741893, 13.607341>
}
#declare Unterarm130 = union {
  sphere { // Sphere1196
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr983
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere1197
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-9.979704, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm130 = union {
  cylinder { // Cylndr982
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere1195
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm130 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-145.970245, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm131 = union {
  sphere { // Sphere1199
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr985
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere1200
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-11.290077, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm131 = union {
  cylinder { // Cylndr984
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere1198
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm131 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <5.021692, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf65 = union {
  sphere { // Sphere1201
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr986
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere1202
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper65 = union {
  cylinder { // Cylndr981
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere1194
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm130 }
  object { Oberarm131 }
  object { Kopf65 }
  translate  <0.0, 0.1, -1.1>
  rotate <-4.748751, -0.0, -0.0>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh130 = union {
  cylinder { // Cylndr989
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr990
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere1205
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere1206
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel130 = union {
  cylinder { // Cylndr988
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere1204
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh130 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <0.429508, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein130 = union {
  cylinder { // Cylndr987
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere1203
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel130 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-2.229014, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh131 = union {
  cylinder { // Cylndr993
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr994
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere1209
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere1210
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel131 = union {
  cylinder { // Cylndr992
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere1208
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh131 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-1.935709, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein131 = union {
  cylinder { // Cylndr991
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere1207
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel131 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-1.708184, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperD13 = union {
  object { Oberkoeper65 }
  object { Bein130 }
  object { Bein131 }
  scale 0.2
  translate  <-26.581837, 2.456124, 13.607341>
}
#declare Unterarm132 = union {
  sphere { // Sphere1213
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr997
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere1214
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-31.349314, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm132 = union {
  cylinder { // Cylndr996
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere1212
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm132 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-57.024162, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm133 = union {
  sphere { // Sphere1216
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr999
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere1217
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-11.290077, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm133 = union {
  cylinder { // Cylndr998
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere1215
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm133 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <5.021692, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf66 = union {
  sphere { // Sphere1218
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr1000
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere1219
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper66 = union {
  cylinder { // Cylndr995
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere1211
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm132 }
  object { Oberarm133 }
  object { Kopf66 }
  translate  <0.0, 0.1, -1.1>
  rotate <-4.748751, -0.0, -0.0>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh132 = union {
  cylinder { // Cylndr1003
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr1004
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere1222
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere1223
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel132 = union {
  cylinder { // Cylndr1002
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere1221
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh132 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <0.429508, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein132 = union {
  cylinder { // Cylndr1001
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere1220
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel132 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-2.229014, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh133 = union {
  cylinder { // Cylndr1007
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr1008
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere1226
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere1227
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel133 = union {
  cylinder { // Cylndr1006
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere1225
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh133 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-41.291786, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein133 = union {
  cylinder { // Cylndr1005
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere1224
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel133 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <26.502007, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperC13 = union {
  object { Oberkoeper66 }
  object { Bein132 }
  object { Bein133 }
  scale 0.2
  rotate -14.898658*z
  translate  <-23.322106, 0.44842, 13.607341>
}
#declare Unterarm134 = union {
  sphere { // Sphere1230
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr1011
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere1231
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <11.332053, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm134 = union {
  cylinder { // Cylndr1010
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere1229
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm134 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-183.932617, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm135 = union {
  sphere { // Sphere1233
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr1013
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere1234
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-11.800155, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm135 = union {
  cylinder { // Cylndr1012
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere1232
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm135 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-42.57547, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf67 = union {
  sphere { // Sphere1235
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr1014
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere1236
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper67 = union {
  cylinder { // Cylndr1009
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere1228
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm134 }
  object { Oberarm135 }
  object { Kopf67 }
  translate  <0.0, 0.1, -1.1>
  rotate <-17.359118, 8.438898, -0.934104>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh134 = union {
  cylinder { // Cylndr1017
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr1018
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere1239
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere1240
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <68.052254, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel134 = union {
  cylinder { // Cylndr1016
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere1238
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh134 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-77.489845, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein134 = union {
  cylinder { // Cylndr1015
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere1237
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel134 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <46.488861, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh135 = union {
  cylinder { // Cylndr1021
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr1022
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere1243
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere1244
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel135 = union {
  cylinder { // Cylndr1020
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere1242
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh135 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-32.66293, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein135 = union {
  cylinder { // Cylndr1019
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere1241
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel135 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-24.897869, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperB12 = union {
  object { Oberkoeper67 }
  object { Bein134 }
  object { Bein135 }
  scale 0.2
  rotate -55.801628*z
  translate  <-24.463197, -1.400308, 13.620281>
}
#declare Unterarm136 = union {
  sphere { // Sphere1247
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr1025
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere1248
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-15.42235, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm136 = union {
  cylinder { // Cylndr1024
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere1246
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm136 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-191.69194, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm137 = union {
  sphere { // Sphere1250
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr1027
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere1251
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-36.483002, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm137 = union {
  cylinder { // Cylndr1026
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere1249
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm137 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-0.38599, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf68 = union {
  sphere { // Sphere1252
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr1028
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere1253
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper68 = union {
  cylinder { // Cylndr1023
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere1245
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm136 }
  object { Oberarm137 }
  object { Kopf68 }
  translate  <0.0, 0.1, -1.1>
  rotate <-4.748751, -0.0, -0.0>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh136 = union {
  cylinder { // Cylndr1031
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr1032
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere1256
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere1257
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel136 = union {
  cylinder { // Cylndr1030
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere1255
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh136 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <0.429508, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein136 = union {
  cylinder { // Cylndr1029
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere1254
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel136 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-2.229014, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh137 = union {
  cylinder { // Cylndr1035
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr1036
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere1260
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere1261
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel137 = union {
  cylinder { // Cylndr1034
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere1259
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh137 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-1.935709, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein137 = union {
  cylinder { // Cylndr1033
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere1258
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel137 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-1.708184, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperA14 = union {
  object { Oberkoeper68 }
  object { Bein136 }
  object { Bein137 }
  scale 0.2
  rotate -20.46339*z
  translate  <-23.991554, 3.289003, 13.607341>
}
#declare Personen8 = union {
  object { KoeperE12 }
  object { KoeperD13 }
  object { KoeperC13 }
  object { KoeperB12 }
  object { KoeperA14 }
  rotate 77.320732*z
  translate  <9.556712, 57.635271, 0.0>
}
#declare Unterarm126 = union {
  sphere { // Sphere1162
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr955
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere1163
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-59.364819, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm126 = union {
  cylinder { // Cylndr954
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere1161
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm126 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-103.369308, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm127 = union {
  sphere { // Sphere1165
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr957
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere1166
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-11.290077, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm127 = union {
  cylinder { // Cylndr956
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere1164
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm127 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <5.021692, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf63 = union {
  sphere { // Sphere1167
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr958
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere1168
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper63 = union {
  cylinder { // Cylndr953
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere1160
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm126 }
  object { Oberarm127 }
  object { Kopf63 }
  translate  <0.0, 0.1, -1.1>
  rotate <4.254684, -9.297903, -0.733642>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh126 = union {
  cylinder { // Cylndr961
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr962
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere1171
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere1172
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel126 = union {
  cylinder { // Cylndr960
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere1170
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh126 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <0.429508, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein126 = union {
  cylinder { // Cylndr959
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere1169
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel126 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-2.229014, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh127 = union {
  cylinder { // Cylndr965
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr966
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere1175
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere1176
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel127 = union {
  cylinder { // Cylndr964
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere1174
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh127 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-41.291786, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein127 = union {
  cylinder { // Cylndr963
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere1173
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel127 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <26.502007, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperC12 = union {
  object { Oberkoeper63 }
  object { Bein126 }
  object { Bein127 }
  scale 0.2
  rotate <-11.774699, 12.050888, 45.045357>
  translate  <0.383816, -3.219947, 32.773588>
}
#declare Unterarm116 = union {
  sphere { // Sphere1077
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr885
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere1078
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-0.151317, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm116 = union {
  cylinder { // Cylndr884
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere1076
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm116 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-71.43721, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm117 = union {
  sphere { // Sphere1080
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr887
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere1081
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-9.964989, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm117 = union {
  cylinder { // Cylndr886
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere1079
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm117 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <39.794205, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf58 = union {
  sphere { // Sphere1082
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr888
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere1083
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper58 = union {
  cylinder { // Cylndr883
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere1075
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm116 }
  object { Oberarm117 }
  object { Kopf58 }
  translate  <0.0, 0.1, -1.1>
  rotate <-4.748751, -0.0, -0.0>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh116 = union {
  cylinder { // Cylndr891
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr892
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere1086
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere1087
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel116 = union {
  cylinder { // Cylndr890
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere1085
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh116 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-37.412239, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein116 = union {
  cylinder { // Cylndr889
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere1084
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel116 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <20.20797, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh117 = union {
  cylinder { // Cylndr895
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr896
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere1090
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere1091
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel117 = union {
  cylinder { // Cylndr894
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere1089
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh117 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-1.935709, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein117 = union {
  cylinder { // Cylndr893
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere1088
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel117 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-1.708184, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperE11 = union {
  object { Oberkoeper58 }
  object { Bein116 }
  object { Bein117 }
  scale 0.2
  rotate -89.223816*z
  translate  <-25.860623, 0.741893, 13.607341>
}
#declare Unterarm118 = union {
  sphere { // Sphere1094
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr899
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere1095
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-9.979704, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm118 = union {
  cylinder { // Cylndr898
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere1093
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm118 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-145.970245, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm119 = union {
  sphere { // Sphere1097
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr901
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere1098
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-11.290077, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm119 = union {
  cylinder { // Cylndr900
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere1096
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm119 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <5.021692, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf59 = union {
  sphere { // Sphere1099
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr902
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere1100
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper59 = union {
  cylinder { // Cylndr897
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere1092
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm118 }
  object { Oberarm119 }
  object { Kopf59 }
  translate  <0.0, 0.1, -1.1>
  rotate <-4.748751, -0.0, -0.0>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh118 = union {
  cylinder { // Cylndr905
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr906
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere1103
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere1104
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel118 = union {
  cylinder { // Cylndr904
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere1102
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh118 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <0.429508, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein118 = union {
  cylinder { // Cylndr903
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere1101
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel118 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-2.229014, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh119 = union {
  cylinder { // Cylndr909
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr910
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere1107
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere1108
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel119 = union {
  cylinder { // Cylndr908
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere1106
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh119 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-1.935709, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein119 = union {
  cylinder { // Cylndr907
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere1105
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel119 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-1.708184, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperD12 = union {
  object { Oberkoeper59 }
  object { Bein118 }
  object { Bein119 }
  scale 0.2
  rotate -68.432495*z
  translate  <-26.581837, 2.456124, 13.607341>
}
#declare Unterarm120 = union {
  sphere { // Sphere1111
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr913
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere1112
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-31.349314, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm120 = union {
  cylinder { // Cylndr912
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere1110
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm120 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-57.024162, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm121 = union {
  sphere { // Sphere1114
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr915
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere1115
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-11.290077, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm121 = union {
  cylinder { // Cylndr914
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere1113
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm121 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <5.021692, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf60 = union {
  sphere { // Sphere1116
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr916
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere1117
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper60 = union {
  cylinder { // Cylndr911
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere1109
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm120 }
  object { Oberarm121 }
  object { Kopf60 }
  translate  <0.0, 0.1, -1.1>
  rotate <-4.748751, -0.0, -0.0>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh120 = union {
  cylinder { // Cylndr919
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr920
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere1120
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere1121
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel120 = union {
  cylinder { // Cylndr918
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere1119
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh120 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <0.429508, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein120 = union {
  cylinder { // Cylndr917
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere1118
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel120 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-2.229014, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh121 = union {
  cylinder { // Cylndr923
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr924
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere1124
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere1125
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel121 = union {
  cylinder { // Cylndr922
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere1123
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh121 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-41.291786, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein121 = union {
  cylinder { // Cylndr921
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere1122
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel121 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <26.502007, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperC11 = union {
  object { Oberkoeper60 }
  object { Bein120 }
  object { Bein121 }
  scale 0.2
  rotate -118.851936*z
  translate  <-23.322106, 0.44842, 13.607341>
}
#declare Unterarm122 = union {
  sphere { // Sphere1128
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr927
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere1129
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <11.332053, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm122 = union {
  cylinder { // Cylndr926
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere1127
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm122 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-183.932617, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm123 = union {
  sphere { // Sphere1131
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr929
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere1132
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-11.800155, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm123 = union {
  cylinder { // Cylndr928
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere1130
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm123 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-42.57547, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf61 = union {
  sphere { // Sphere1133
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr930
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere1134
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper61 = union {
  cylinder { // Cylndr925
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere1126
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm122 }
  object { Oberarm123 }
  object { Kopf61 }
  translate  <0.0, 0.1, -1.1>
  rotate <-17.359118, 8.438898, -0.934104>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh122 = union {
  cylinder { // Cylndr933
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr934
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere1137
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere1138
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <68.052254, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel122 = union {
  cylinder { // Cylndr932
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere1136
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh122 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-77.489845, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein122 = union {
  cylinder { // Cylndr931
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere1135
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel122 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <46.488861, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh123 = union {
  cylinder { // Cylndr937
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr938
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere1141
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere1142
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel123 = union {
  cylinder { // Cylndr936
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere1140
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh123 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-32.66293, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein123 = union {
  cylinder { // Cylndr935
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere1139
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel123 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-24.897869, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperB11 = union {
  object { Oberkoeper61 }
  object { Bein122 }
  object { Bein123 }
  scale 0.2
  rotate -55.801628*z
  translate  <-24.463197, -1.400308, 13.620281>
}
#declare Unterarm124 = union {
  sphere { // Sphere1145
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr941
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere1146
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-15.42235, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm124 = union {
  cylinder { // Cylndr940
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere1144
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm124 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-191.69194, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm125 = union {
  sphere { // Sphere1148
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr943
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere1149
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-36.483002, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm125 = union {
  cylinder { // Cylndr942
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere1147
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm125 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-0.38599, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf62 = union {
  sphere { // Sphere1150
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr944
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere1151
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper62 = union {
  cylinder { // Cylndr939
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere1143
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm124 }
  object { Oberarm125 }
  object { Kopf62 }
  translate  <0.0, 0.1, -1.1>
  rotate <-4.748751, -0.0, -0.0>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh124 = union {
  cylinder { // Cylndr947
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr948
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere1154
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere1155
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel124 = union {
  cylinder { // Cylndr946
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere1153
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh124 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <0.429508, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein124 = union {
  cylinder { // Cylndr945
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere1152
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel124 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-2.229014, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh125 = union {
  cylinder { // Cylndr951
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr952
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere1158
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere1159
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel125 = union {
  cylinder { // Cylndr950
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere1157
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh125 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-1.935709, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein125 = union {
  cylinder { // Cylndr949
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere1156
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel125 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-1.708184, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperA13 = union {
  object { Oberkoeper62 }
  object { Bein124 }
  object { Bein125 }
  scale 0.2
  rotate -118.231796*z
  translate  <-23.991554, 3.289003, 13.607341>
}
#declare Personen7 = union {
  object { KoeperE11 }
  object { KoeperD12 }
  object { KoeperC11 }
  object { KoeperB11 }
  object { KoeperA13 }
  rotate 77.320732*z
  translate  <-15.682992, 1.549619, 0.0>
}
#declare Unterarm106 = union {
  sphere { // Sphere992
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr815
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere993
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-0.151317, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm106 = union {
  cylinder { // Cylndr814
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere991
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm106 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-71.43721, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm107 = union {
  sphere { // Sphere995
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr817
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere996
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <6.507195, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm107 = union {
  cylinder { // Cylndr816
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere994
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm107 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <71.509941, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf53 = union {
  sphere { // Sphere997
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr818
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere998
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper53 = union {
  cylinder { // Cylndr813
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere990
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm106 }
  object { Oberarm107 }
  object { Kopf53 }
  translate  <0.0, 0.1, -1.1>
  rotate <-4.748751, -0.0, -0.0>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh106 = union {
  cylinder { // Cylndr821
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr822
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere1001
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere1002
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel106 = union {
  cylinder { // Cylndr820
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere1000
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh106 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-37.412239, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein106 = union {
  cylinder { // Cylndr819
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere999
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel106 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <20.20797, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh107 = union {
  cylinder { // Cylndr825
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr826
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere1005
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere1006
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel107 = union {
  cylinder { // Cylndr824
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere1004
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh107 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-1.935709, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein107 = union {
  cylinder { // Cylndr823
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere1003
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel107 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-1.708184, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperE10 = union {
  object { Oberkoeper53 }
  object { Bein106 }
  object { Bein107 }
  scale 0.2
  rotate -26.878849*z
  translate  <-25.860623, 0.741893, 13.607341>
}
#declare Unterarm108 = union {
  sphere { // Sphere1009
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr829
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere1010
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-9.979704, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm108 = union {
  cylinder { // Cylndr828
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere1008
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm108 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-145.970245, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm109 = union {
  sphere { // Sphere1012
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr831
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere1013
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-11.290077, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm109 = union {
  cylinder { // Cylndr830
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere1011
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm109 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <5.021692, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf54 = union {
  sphere { // Sphere1014
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr832
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere1015
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper54 = union {
  cylinder { // Cylndr827
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere1007
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm108 }
  object { Oberarm109 }
  object { Kopf54 }
  translate  <0.0, 0.1, -1.1>
  rotate <-4.748751, -0.0, -0.0>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh108 = union {
  cylinder { // Cylndr835
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr836
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere1018
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere1019
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel108 = union {
  cylinder { // Cylndr834
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere1017
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh108 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <0.429508, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein108 = union {
  cylinder { // Cylndr833
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere1016
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel108 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-2.229014, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh109 = union {
  cylinder { // Cylndr839
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr840
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere1022
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere1023
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel109 = union {
  cylinder { // Cylndr838
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere1021
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh109 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-1.935709, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein109 = union {
  cylinder { // Cylndr837
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere1020
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel109 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-1.708184, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperD11 = union {
  object { Oberkoeper54 }
  object { Bein108 }
  object { Bein109 }
  scale 0.2
  translate  <-26.581837, 2.456124, 13.607341>
}
#declare Unterarm110 = union {
  sphere { // Sphere1026
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr843
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere1027
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-31.349314, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm110 = union {
  cylinder { // Cylndr842
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere1025
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm110 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-57.024162, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm111 = union {
  sphere { // Sphere1029
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr845
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere1030
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-11.290077, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm111 = union {
  cylinder { // Cylndr844
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere1028
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm111 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <5.021692, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf55 = union {
  sphere { // Sphere1031
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr846
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere1032
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper55 = union {
  cylinder { // Cylndr841
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere1024
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm110 }
  object { Oberarm111 }
  object { Kopf55 }
  translate  <0.0, 0.1, -1.1>
  rotate <-4.748751, -0.0, -0.0>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh110 = union {
  cylinder { // Cylndr849
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr850
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere1035
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere1036
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel110 = union {
  cylinder { // Cylndr848
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere1034
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh110 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <0.429508, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein110 = union {
  cylinder { // Cylndr847
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere1033
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel110 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-2.229014, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh111 = union {
  cylinder { // Cylndr853
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr854
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere1039
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere1040
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel111 = union {
  cylinder { // Cylndr852
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere1038
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh111 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-41.291786, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein111 = union {
  cylinder { // Cylndr851
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere1037
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel111 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <26.502007, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperC10 = union {
  object { Oberkoeper55 }
  object { Bein110 }
  object { Bein111 }
  scale 0.2
  rotate -14.898658*z
  translate  <-23.322106, 0.44842, 13.607341>
}
#declare Unterarm112 = union {
  sphere { // Sphere1043
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr857
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere1044
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <11.332053, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm112 = union {
  cylinder { // Cylndr856
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere1042
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm112 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-183.932617, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm113 = union {
  sphere { // Sphere1046
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr859
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere1047
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-11.800155, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm113 = union {
  cylinder { // Cylndr858
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere1045
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm113 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-42.57547, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf56 = union {
  sphere { // Sphere1048
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr860
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere1049
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper56 = union {
  cylinder { // Cylndr855
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere1041
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm112 }
  object { Oberarm113 }
  object { Kopf56 }
  translate  <0.0, 0.1, -1.1>
  rotate <-17.359118, 8.438898, -0.934104>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh112 = union {
  cylinder { // Cylndr863
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr864
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere1052
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere1053
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <68.052254, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel112 = union {
  cylinder { // Cylndr862
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere1051
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh112 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-77.489845, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein112 = union {
  cylinder { // Cylndr861
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere1050
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel112 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <46.488861, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh113 = union {
  cylinder { // Cylndr867
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr868
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere1056
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere1057
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel113 = union {
  cylinder { // Cylndr866
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere1055
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh113 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-32.66293, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein113 = union {
  cylinder { // Cylndr865
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere1054
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel113 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-24.897869, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperB10 = union {
  object { Oberkoeper56 }
  object { Bein112 }
  object { Bein113 }
  scale 0.2
  rotate -55.801628*z
  translate  <-24.463197, -1.400308, 13.620281>
}
#declare Unterarm114 = union {
  sphere { // Sphere1060
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr871
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere1061
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-15.42235, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm114 = union {
  cylinder { // Cylndr870
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere1059
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm114 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-191.69194, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm115 = union {
  sphere { // Sphere1063
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr873
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere1064
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-36.483002, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm115 = union {
  cylinder { // Cylndr872
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere1062
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm115 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-0.38599, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf57 = union {
  sphere { // Sphere1065
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr874
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere1066
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper57 = union {
  cylinder { // Cylndr869
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere1058
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm114 }
  object { Oberarm115 }
  object { Kopf57 }
  translate  <0.0, 0.1, -1.1>
  rotate <-4.748751, -0.0, -0.0>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh114 = union {
  cylinder { // Cylndr877
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr878
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere1069
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere1070
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel114 = union {
  cylinder { // Cylndr876
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere1068
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh114 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <0.429508, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein114 = union {
  cylinder { // Cylndr875
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere1067
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel114 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-2.229014, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh115 = union {
  cylinder { // Cylndr881
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr882
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere1073
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere1074
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel115 = union {
  cylinder { // Cylndr880
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere1072
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh115 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-1.935709, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein115 = union {
  cylinder { // Cylndr879
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere1071
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel115 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-1.708184, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperA12 = union {
  object { Oberkoeper57 }
  object { Bein114 }
  object { Bein115 }
  scale 0.2
  rotate -20.46339*z
  translate  <-23.991554, 3.289003, 13.607341>
}
#declare Personen6 = union {
  object { KoeperE10 }
  object { KoeperD11 }
  object { KoeperC10 }
  object { KoeperB10 }
  object { KoeperA12 }
  rotate 77.320732*z
  translate  <10.858666, 50.553412, 0.0>
}
#declare Unterarm96 = union {
  sphere { // Sphere907
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr745
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere908
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-0.151317, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm96 = union {
  cylinder { // Cylndr744
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere906
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm96 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-71.43721, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm97 = union {
  sphere { // Sphere910
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr747
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere911
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <6.507195, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm97 = union {
  cylinder { // Cylndr746
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere909
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm97 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <71.509941, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf48 = union {
  sphere { // Sphere912
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr748
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere913
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper48 = union {
  cylinder { // Cylndr743
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere905
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm96 }
  object { Oberarm97 }
  object { Kopf48 }
  translate  <0.0, 0.1, -1.1>
  rotate <-4.748751, -0.0, -0.0>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh96 = union {
  cylinder { // Cylndr751
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr752
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere916
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere917
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel96 = union {
  cylinder { // Cylndr750
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere915
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh96 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-37.412239, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein96 = union {
  cylinder { // Cylndr749
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere914
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel96 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <20.20797, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh97 = union {
  cylinder { // Cylndr755
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr756
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere920
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere921
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel97 = union {
  cylinder { // Cylndr754
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere919
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh97 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-1.935709, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein97 = union {
  cylinder { // Cylndr753
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere918
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel97 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-1.708184, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperE9 = union {
  object { Oberkoeper48 }
  object { Bein96 }
  object { Bein97 }
  scale 0.2
  rotate -26.878849*z
  translate  <-25.860623, 0.741893, 13.607341>
}
#declare Unterarm98 = union {
  sphere { // Sphere924
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr759
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere925
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-9.979704, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm98 = union {
  cylinder { // Cylndr758
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere923
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm98 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-145.970245, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm99 = union {
  sphere { // Sphere927
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr761
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere928
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-11.290077, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm99 = union {
  cylinder { // Cylndr760
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere926
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm99 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <5.021692, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf49 = union {
  sphere { // Sphere929
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr762
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere930
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper49 = union {
  cylinder { // Cylndr757
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere922
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm98 }
  object { Oberarm99 }
  object { Kopf49 }
  translate  <0.0, 0.1, -1.1>
  rotate <-4.748751, -0.0, -0.0>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh98 = union {
  cylinder { // Cylndr765
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr766
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere933
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere934
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel98 = union {
  cylinder { // Cylndr764
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere932
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh98 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <0.429508, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein98 = union {
  cylinder { // Cylndr763
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere931
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel98 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-2.229014, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh99 = union {
  cylinder { // Cylndr769
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr770
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere937
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere938
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel99 = union {
  cylinder { // Cylndr768
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere936
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh99 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-1.935709, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein99 = union {
  cylinder { // Cylndr767
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere935
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel99 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-1.708184, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperD10 = union {
  object { Oberkoeper49 }
  object { Bein98 }
  object { Bein99 }
  scale 0.2
  translate  <-26.581837, 2.456124, 13.607341>
}
#declare Unterarm100 = union {
  sphere { // Sphere941
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr773
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere942
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-31.349314, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm100 = union {
  cylinder { // Cylndr772
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere940
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm100 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-57.024162, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm101 = union {
  sphere { // Sphere944
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr775
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere945
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-11.290077, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm101 = union {
  cylinder { // Cylndr774
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere943
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm101 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <5.021692, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf50 = union {
  sphere { // Sphere946
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr776
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere947
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper50 = union {
  cylinder { // Cylndr771
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere939
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm100 }
  object { Oberarm101 }
  object { Kopf50 }
  translate  <0.0, 0.1, -1.1>
  rotate <-4.748751, -0.0, -0.0>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh100 = union {
  cylinder { // Cylndr779
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr780
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere950
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere951
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel100 = union {
  cylinder { // Cylndr778
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere949
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh100 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <0.429508, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein100 = union {
  cylinder { // Cylndr777
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere948
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel100 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-2.229014, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh101 = union {
  cylinder { // Cylndr783
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr784
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere954
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere955
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel101 = union {
  cylinder { // Cylndr782
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere953
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh101 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-41.291786, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein101 = union {
  cylinder { // Cylndr781
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere952
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel101 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <26.502007, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperC9 = union {
  object { Oberkoeper50 }
  object { Bein100 }
  object { Bein101 }
  scale 0.2
  rotate -14.898658*z
  translate  <-23.322106, 0.44842, 13.607341>
}
#declare Unterarm102 = union {
  sphere { // Sphere958
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr787
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere959
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <11.332053, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm102 = union {
  cylinder { // Cylndr786
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere957
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm102 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-183.932617, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm103 = union {
  sphere { // Sphere961
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr789
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere962
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-11.800155, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm103 = union {
  cylinder { // Cylndr788
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere960
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm103 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-42.57547, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf51 = union {
  sphere { // Sphere963
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr790
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere964
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper51 = union {
  cylinder { // Cylndr785
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere956
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm102 }
  object { Oberarm103 }
  object { Kopf51 }
  translate  <0.0, 0.1, -1.1>
  rotate <-17.359118, 8.438898, -0.934104>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh102 = union {
  cylinder { // Cylndr793
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr794
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere967
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere968
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <68.052254, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel102 = union {
  cylinder { // Cylndr792
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere966
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh102 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-14.303981, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein102 = union {
  cylinder { // Cylndr791
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere965
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel102 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-5.656135, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh103 = union {
  cylinder { // Cylndr797
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr798
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere971
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere972
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel103 = union {
  cylinder { // Cylndr796
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere970
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh103 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-60.254429, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein103 = union {
  cylinder { // Cylndr795
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere969
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel103 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <47.859928, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperB9 = union {
  object { Oberkoeper51 }
  object { Bein102 }
  object { Bein103 }
  scale 0.2
  rotate -55.801628*z
  translate  <-21.851894, 6.214438, 13.620281>
}
#declare Unterarm104 = union {
  sphere { // Sphere975
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr801
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere976
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-15.42235, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm104 = union {
  cylinder { // Cylndr800
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere974
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm104 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-191.69194, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm105 = union {
  sphere { // Sphere978
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr803
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere979
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-36.483002, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm105 = union {
  cylinder { // Cylndr802
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere977
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm105 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-0.38599, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf52 = union {
  sphere { // Sphere980
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr804
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere981
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper52 = union {
  cylinder { // Cylndr799
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere973
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm104 }
  object { Oberarm105 }
  object { Kopf52 }
  translate  <0.0, 0.1, -1.1>
  rotate <-4.748751, -0.0, -0.0>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh104 = union {
  cylinder { // Cylndr807
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr808
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere984
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere985
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel104 = union {
  cylinder { // Cylndr806
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere983
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh104 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <0.429508, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein104 = union {
  cylinder { // Cylndr805
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere982
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel104 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-2.229014, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh105 = union {
  cylinder { // Cylndr811
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr812
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere988
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere989
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel105 = union {
  cylinder { // Cylndr810
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere987
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh105 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-1.935709, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein105 = union {
  cylinder { // Cylndr809
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere986
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel105 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-1.708184, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperA11 = union {
  object { Oberkoeper52 }
  object { Bein104 }
  object { Bein105 }
  scale 0.2
  rotate -20.46339*z
  translate  <-23.991554, 3.289003, 13.607341>
}
#declare Personen5 = union {
  object { KoeperE9 }
  object { KoeperD10 }
  object { KoeperC9 }
  object { KoeperB9 }
  object { KoeperA11 }
  rotate 77.320732*z
  translate  <-7.376812, -3.563554, 0.0>
}
#declare Unterarm86 = union {
  sphere { // Sphere822
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr675
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere823
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-0.151317, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm86 = union {
  cylinder { // Cylndr674
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere821
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm86 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-71.43721, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm87 = union {
  sphere { // Sphere825
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr677
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere826
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <6.507195, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm87 = union {
  cylinder { // Cylndr676
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere824
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm87 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <71.509941, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf43 = union {
  sphere { // Sphere827
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr678
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere828
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper43 = union {
  cylinder { // Cylndr673
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere820
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm86 }
  object { Oberarm87 }
  object { Kopf43 }
  translate  <0.0, 0.1, -1.1>
  rotate <-4.748751, -0.0, -0.0>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh86 = union {
  cylinder { // Cylndr681
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr682
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere831
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere832
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel86 = union {
  cylinder { // Cylndr680
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere830
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh86 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-37.412239, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein86 = union {
  cylinder { // Cylndr679
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere829
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel86 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <20.20797, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh87 = union {
  cylinder { // Cylndr685
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr686
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere835
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere836
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel87 = union {
  cylinder { // Cylndr684
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere834
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh87 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-1.935709, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein87 = union {
  cylinder { // Cylndr683
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere833
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel87 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-1.708184, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperE8 = union {
  object { Oberkoeper43 }
  object { Bein86 }
  object { Bein87 }
  scale 0.2
  rotate -26.878849*z
  translate  <-25.860623, 0.741893, 13.607341>
}
#declare Unterarm88 = union {
  sphere { // Sphere839
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr689
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere840
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-9.979704, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm88 = union {
  cylinder { // Cylndr688
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere838
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm88 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-145.970245, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm89 = union {
  sphere { // Sphere842
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr691
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere843
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-11.290077, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm89 = union {
  cylinder { // Cylndr690
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere841
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm89 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <5.021692, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf44 = union {
  sphere { // Sphere844
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr692
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere845
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper44 = union {
  cylinder { // Cylndr687
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere837
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm88 }
  object { Oberarm89 }
  object { Kopf44 }
  translate  <0.0, 0.1, -1.1>
  rotate <-4.748751, -0.0, -0.0>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh88 = union {
  cylinder { // Cylndr695
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr696
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere848
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere849
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel88 = union {
  cylinder { // Cylndr694
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere847
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh88 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <0.429508, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein88 = union {
  cylinder { // Cylndr693
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere846
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel88 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-2.229014, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh89 = union {
  cylinder { // Cylndr699
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr700
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere852
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere853
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel89 = union {
  cylinder { // Cylndr698
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere851
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh89 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-1.935709, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein89 = union {
  cylinder { // Cylndr697
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere850
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel89 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-1.708184, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperD9 = union {
  object { Oberkoeper44 }
  object { Bein88 }
  object { Bein89 }
  scale 0.2
  translate  <-26.581837, 2.456124, 13.607341>
}
#declare Unterarm90 = union {
  sphere { // Sphere856
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr703
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere857
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-31.349314, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm90 = union {
  cylinder { // Cylndr702
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere855
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm90 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-57.024162, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm91 = union {
  sphere { // Sphere859
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr705
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere860
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-11.290077, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm91 = union {
  cylinder { // Cylndr704
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere858
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm91 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <5.021692, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf45 = union {
  sphere { // Sphere861
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr706
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere862
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper45 = union {
  cylinder { // Cylndr701
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere854
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm90 }
  object { Oberarm91 }
  object { Kopf45 }
  translate  <0.0, 0.1, -1.1>
  rotate <-4.748751, -0.0, -0.0>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh90 = union {
  cylinder { // Cylndr709
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr710
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere865
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere866
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel90 = union {
  cylinder { // Cylndr708
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere864
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh90 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <0.429508, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein90 = union {
  cylinder { // Cylndr707
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere863
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel90 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-2.229014, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh91 = union {
  cylinder { // Cylndr713
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr714
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere869
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere870
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel91 = union {
  cylinder { // Cylndr712
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere868
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh91 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-41.291786, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein91 = union {
  cylinder { // Cylndr711
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere867
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel91 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <26.502007, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperC8 = union {
  object { Oberkoeper45 }
  object { Bein90 }
  object { Bein91 }
  scale 0.2
  rotate -14.898658*z
  translate  <-23.322106, 0.44842, 13.607341>
}
#declare Unterarm92 = union {
  sphere { // Sphere873
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr717
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere874
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <11.332053, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm92 = union {
  cylinder { // Cylndr716
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere872
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm92 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-183.932617, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm93 = union {
  sphere { // Sphere876
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr719
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere877
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-11.800155, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm93 = union {
  cylinder { // Cylndr718
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere875
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm93 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-42.57547, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf46 = union {
  sphere { // Sphere878
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr720
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere879
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper46 = union {
  cylinder { // Cylndr715
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere871
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm92 }
  object { Oberarm93 }
  object { Kopf46 }
  translate  <0.0, 0.1, -1.1>
  rotate <-17.359118, 8.438898, -0.934104>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh92 = union {
  cylinder { // Cylndr723
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr724
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere882
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere883
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <68.052254, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel92 = union {
  cylinder { // Cylndr722
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere881
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh92 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-77.489845, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein92 = union {
  cylinder { // Cylndr721
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere880
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel92 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <46.488861, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh93 = union {
  cylinder { // Cylndr727
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr728
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere886
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere887
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel93 = union {
  cylinder { // Cylndr726
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere885
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh93 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-32.66293, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein93 = union {
  cylinder { // Cylndr725
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere884
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel93 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-24.897869, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperB8 = union {
  object { Oberkoeper46 }
  object { Bein92 }
  object { Bein93 }
  scale 0.2
  rotate -55.801628*z
  translate  <-24.463197, -1.400308, 13.620281>
}
#declare Unterarm94 = union {
  sphere { // Sphere890
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr731
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere891
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-15.42235, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm94 = union {
  cylinder { // Cylndr730
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere889
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm94 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-191.69194, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm95 = union {
  sphere { // Sphere893
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr733
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere894
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-36.483002, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm95 = union {
  cylinder { // Cylndr732
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere892
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm95 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-0.38599, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf47 = union {
  sphere { // Sphere895
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr734
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere896
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper47 = union {
  cylinder { // Cylndr729
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere888
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm94 }
  object { Oberarm95 }
  object { Kopf47 }
  translate  <0.0, 0.1, -1.1>
  rotate <-4.748751, -0.0, -0.0>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh94 = union {
  cylinder { // Cylndr737
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr738
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere899
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere900
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel94 = union {
  cylinder { // Cylndr736
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere898
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh94 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <0.429508, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein94 = union {
  cylinder { // Cylndr735
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere897
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel94 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-2.229014, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh95 = union {
  cylinder { // Cylndr741
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr742
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere903
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere904
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel95 = union {
  cylinder { // Cylndr740
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere902
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh95 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-1.935709, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein95 = union {
  cylinder { // Cylndr739
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere901
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel95 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-1.708184, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperA10 = union {
  object { Oberkoeper47 }
  object { Bein94 }
  object { Bein95 }
  scale 0.2
  rotate -20.46339*z
  translate  <-23.991554, 3.289003, 13.607341>
}
#declare Personen4 = union {
  object { KoeperE8 }
  object { KoeperD9 }
  object { KoeperC8 }
  object { KoeperB8 }
  object { KoeperA10 }
  rotate 77.320732*z
  translate  <-10.303232, 37.576318, 0.0>
}
#declare Unterarm76 = union {
  sphere { // Sphere737
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr605
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere738
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-0.151317, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm76 = union {
  cylinder { // Cylndr604
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere736
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm76 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-71.43721, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm77 = union {
  sphere { // Sphere740
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr607
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere741
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <6.507195, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm77 = union {
  cylinder { // Cylndr606
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere739
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm77 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <71.509941, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf38 = union {
  sphere { // Sphere742
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr608
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere743
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper38 = union {
  cylinder { // Cylndr603
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere735
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm76 }
  object { Oberarm77 }
  object { Kopf38 }
  translate  <0.0, 0.1, -1.1>
  rotate <-4.748751, -0.0, -0.0>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh76 = union {
  cylinder { // Cylndr611
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr612
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere746
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere747
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel76 = union {
  cylinder { // Cylndr610
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere745
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh76 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-37.412239, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein76 = union {
  cylinder { // Cylndr609
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere744
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel76 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <20.20797, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh77 = union {
  cylinder { // Cylndr615
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr616
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere750
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere751
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel77 = union {
  cylinder { // Cylndr614
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere749
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh77 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-1.935709, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein77 = union {
  cylinder { // Cylndr613
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere748
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel77 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-1.708184, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperE7 = union {
  object { Oberkoeper38 }
  object { Bein76 }
  object { Bein77 }
  scale 0.2
  rotate -26.878849*z
  translate  <-25.860623, 0.741893, 13.607341>
}
#declare Unterarm78 = union {
  sphere { // Sphere754
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr619
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere755
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-9.979704, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm78 = union {
  cylinder { // Cylndr618
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere753
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm78 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-145.970245, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm79 = union {
  sphere { // Sphere757
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr621
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere758
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-11.290077, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm79 = union {
  cylinder { // Cylndr620
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere756
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm79 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <5.021692, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf39 = union {
  sphere { // Sphere759
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr622
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere760
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper39 = union {
  cylinder { // Cylndr617
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere752
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm78 }
  object { Oberarm79 }
  object { Kopf39 }
  translate  <0.0, 0.1, -1.1>
  rotate <-4.748751, -0.0, -0.0>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh78 = union {
  cylinder { // Cylndr625
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr626
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere763
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere764
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel78 = union {
  cylinder { // Cylndr624
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere762
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh78 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <0.429508, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein78 = union {
  cylinder { // Cylndr623
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere761
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel78 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-2.229014, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh79 = union {
  cylinder { // Cylndr629
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr630
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere767
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere768
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel79 = union {
  cylinder { // Cylndr628
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere766
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh79 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-1.935709, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein79 = union {
  cylinder { // Cylndr627
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere765
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel79 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-1.708184, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperD8 = union {
  object { Oberkoeper39 }
  object { Bein78 }
  object { Bein79 }
  scale 0.2
  translate  <-26.581837, 2.456124, 13.607341>
}
#declare Unterarm80 = union {
  sphere { // Sphere771
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr633
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere772
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-31.349314, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm80 = union {
  cylinder { // Cylndr632
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere770
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm80 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-57.024162, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm81 = union {
  sphere { // Sphere774
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr635
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere775
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-11.290077, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm81 = union {
  cylinder { // Cylndr634
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere773
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm81 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <5.021692, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf40 = union {
  sphere { // Sphere776
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr636
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere777
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper40 = union {
  cylinder { // Cylndr631
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere769
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm80 }
  object { Oberarm81 }
  object { Kopf40 }
  translate  <0.0, 0.1, -1.1>
  rotate <-4.748751, -0.0, -0.0>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh80 = union {
  cylinder { // Cylndr639
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr640
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere780
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere781
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel80 = union {
  cylinder { // Cylndr638
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere779
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh80 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <0.429508, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein80 = union {
  cylinder { // Cylndr637
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere778
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel80 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-2.229014, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh81 = union {
  cylinder { // Cylndr643
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr644
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere784
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere785
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel81 = union {
  cylinder { // Cylndr642
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere783
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh81 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-41.291786, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein81 = union {
  cylinder { // Cylndr641
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere782
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel81 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <26.502007, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperC7 = union {
  object { Oberkoeper40 }
  object { Bein80 }
  object { Bein81 }
  scale 0.2
  rotate -14.898658*z
  translate  <-23.322106, 0.44842, 13.607341>
}
#declare Unterarm82 = union {
  sphere { // Sphere788
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr647
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere789
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <11.332053, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm82 = union {
  cylinder { // Cylndr646
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere787
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm82 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-183.932617, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm83 = union {
  sphere { // Sphere791
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr649
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere792
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-11.800155, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm83 = union {
  cylinder { // Cylndr648
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere790
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm83 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-42.57547, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf41 = union {
  sphere { // Sphere793
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr650
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere794
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper41 = union {
  cylinder { // Cylndr645
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere786
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm82 }
  object { Oberarm83 }
  object { Kopf41 }
  translate  <0.0, 0.1, -1.1>
  rotate <-17.359118, 8.438898, -0.934104>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh82 = union {
  cylinder { // Cylndr653
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr654
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere797
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere798
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <68.052254, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel82 = union {
  cylinder { // Cylndr652
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere796
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh82 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-77.489845, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein82 = union {
  cylinder { // Cylndr651
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere795
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel82 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <46.488861, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh83 = union {
  cylinder { // Cylndr657
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr658
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere801
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere802
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel83 = union {
  cylinder { // Cylndr656
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere800
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh83 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-32.66293, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein83 = union {
  cylinder { // Cylndr655
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere799
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel83 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-24.897869, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperB7 = union {
  object { Oberkoeper41 }
  object { Bein82 }
  object { Bein83 }
  scale 0.2
  rotate -55.801628*z
  translate  <-24.463197, -1.400308, 13.620281>
}
#declare Unterarm84 = union {
  sphere { // Sphere805
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr661
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere806
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-15.42235, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm84 = union {
  cylinder { // Cylndr660
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere804
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm84 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-191.69194, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm85 = union {
  sphere { // Sphere808
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr663
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere809
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-36.483002, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm85 = union {
  cylinder { // Cylndr662
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere807
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm85 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-0.38599, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf42 = union {
  sphere { // Sphere810
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr664
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere811
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper42 = union {
  cylinder { // Cylndr659
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere803
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm84 }
  object { Oberarm85 }
  object { Kopf42 }
  translate  <0.0, 0.1, -1.1>
  rotate <-4.748751, -0.0, -0.0>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh84 = union {
  cylinder { // Cylndr667
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr668
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere814
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere815
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel84 = union {
  cylinder { // Cylndr666
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere813
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh84 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <0.429508, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein84 = union {
  cylinder { // Cylndr665
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere812
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel84 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-2.229014, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh85 = union {
  cylinder { // Cylndr671
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr672
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere818
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere819
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel85 = union {
  cylinder { // Cylndr670
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere817
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh85 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-1.935709, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein85 = union {
  cylinder { // Cylndr669
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere816
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel85 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-1.708184, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperA9 = union {
  object { Oberkoeper42 }
  object { Bein84 }
  object { Bein85 }
  scale 0.2
  rotate -20.46339*z
  translate  <-23.991554, 3.289003, 13.607341>
}
#declare Personen3 = union {
  object { KoeperE7 }
  object { KoeperD8 }
  object { KoeperC7 }
  object { KoeperB7 }
  object { KoeperA9 }
  rotate 77.320732*z
  translate  <17.122783, 53.856473, 0.0>
}
#declare Unterarm66 = union {
  sphere { // Sphere652
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr535
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere653
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-0.151317, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm66 = union {
  cylinder { // Cylndr534
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere651
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm66 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-71.43721, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm67 = union {
  sphere { // Sphere655
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr537
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere656
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <6.507195, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm67 = union {
  cylinder { // Cylndr536
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere654
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm67 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <71.509941, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf33 = union {
  sphere { // Sphere657
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr538
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere658
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper33 = union {
  cylinder { // Cylndr533
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere650
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm66 }
  object { Oberarm67 }
  object { Kopf33 }
  translate  <0.0, 0.1, -1.1>
  rotate <-4.748751, -0.0, -0.0>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh66 = union {
  cylinder { // Cylndr541
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr542
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere661
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere662
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel66 = union {
  cylinder { // Cylndr540
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere660
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh66 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-37.412239, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein66 = union {
  cylinder { // Cylndr539
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere659
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel66 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <20.20797, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh67 = union {
  cylinder { // Cylndr545
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr546
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere665
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere666
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel67 = union {
  cylinder { // Cylndr544
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere664
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh67 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-1.935709, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein67 = union {
  cylinder { // Cylndr543
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere663
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel67 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-1.708184, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperE6 = union {
  object { Oberkoeper33 }
  object { Bein66 }
  object { Bein67 }
  scale 0.2
  rotate -26.878849*z
  translate  <-25.860623, 0.741893, 13.607341>
}
#declare Unterarm68 = union {
  sphere { // Sphere669
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr549
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere670
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-9.979704, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm68 = union {
  cylinder { // Cylndr548
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere668
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm68 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-145.970245, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm69 = union {
  sphere { // Sphere672
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr551
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere673
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-11.290077, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm69 = union {
  cylinder { // Cylndr550
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere671
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm69 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <5.021692, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf34 = union {
  sphere { // Sphere674
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr552
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere675
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper34 = union {
  cylinder { // Cylndr547
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere667
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm68 }
  object { Oberarm69 }
  object { Kopf34 }
  translate  <0.0, 0.1, -1.1>
  rotate <-4.748751, -0.0, -0.0>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh68 = union {
  cylinder { // Cylndr555
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr556
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere678
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere679
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel68 = union {
  cylinder { // Cylndr554
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere677
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh68 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <0.429508, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein68 = union {
  cylinder { // Cylndr553
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere676
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel68 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-2.229014, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh69 = union {
  cylinder { // Cylndr559
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr560
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere682
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere683
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel69 = union {
  cylinder { // Cylndr558
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere681
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh69 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-1.935709, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein69 = union {
  cylinder { // Cylndr557
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere680
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel69 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-1.708184, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperD7 = union {
  object { Oberkoeper34 }
  object { Bein68 }
  object { Bein69 }
  scale 0.2
  translate  <-26.581837, 2.456124, 13.607341>
}
#declare Unterarm70 = union {
  sphere { // Sphere686
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr563
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere687
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-31.349314, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm70 = union {
  cylinder { // Cylndr562
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere685
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm70 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-57.024162, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm71 = union {
  sphere { // Sphere689
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr565
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere690
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-11.290077, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm71 = union {
  cylinder { // Cylndr564
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere688
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm71 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <5.021692, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf35 = union {
  sphere { // Sphere691
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr566
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere692
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper35 = union {
  cylinder { // Cylndr561
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere684
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm70 }
  object { Oberarm71 }
  object { Kopf35 }
  translate  <0.0, 0.1, -1.1>
  rotate <-4.748751, -0.0, -0.0>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh70 = union {
  cylinder { // Cylndr569
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr570
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere695
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere696
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel70 = union {
  cylinder { // Cylndr568
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere694
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh70 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <0.429508, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein70 = union {
  cylinder { // Cylndr567
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere693
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel70 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-2.229014, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh71 = union {
  cylinder { // Cylndr573
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr574
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere699
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere700
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel71 = union {
  cylinder { // Cylndr572
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere698
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh71 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-41.291786, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein71 = union {
  cylinder { // Cylndr571
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere697
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel71 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <26.502007, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperC6 = union {
  object { Oberkoeper35 }
  object { Bein70 }
  object { Bein71 }
  scale 0.2
  rotate -14.898658*z
  translate  <-23.322106, 0.44842, 13.607341>
}
#declare Unterarm72 = union {
  sphere { // Sphere703
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr577
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere704
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <11.332053, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm72 = union {
  cylinder { // Cylndr576
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere702
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm72 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-183.932617, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm73 = union {
  sphere { // Sphere706
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr579
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere707
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-11.800155, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm73 = union {
  cylinder { // Cylndr578
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere705
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm73 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-42.57547, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf36 = union {
  sphere { // Sphere708
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr580
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere709
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper36 = union {
  cylinder { // Cylndr575
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere701
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm72 }
  object { Oberarm73 }
  object { Kopf36 }
  translate  <0.0, 0.1, -1.1>
  rotate <-17.359118, 8.438898, -0.934104>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh72 = union {
  cylinder { // Cylndr583
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr584
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere712
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere713
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <68.052254, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel72 = union {
  cylinder { // Cylndr582
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere711
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh72 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-77.489845, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein72 = union {
  cylinder { // Cylndr581
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere710
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel72 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <46.488861, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh73 = union {
  cylinder { // Cylndr587
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr588
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere716
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere717
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel73 = union {
  cylinder { // Cylndr586
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere715
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh73 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-32.66293, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein73 = union {
  cylinder { // Cylndr585
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere714
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel73 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-24.897869, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperB6 = union {
  object { Oberkoeper36 }
  object { Bein72 }
  object { Bein73 }
  scale 0.2
  rotate -55.801628*z
  translate  <-24.463197, -1.400308, 13.620281>
}
#declare Unterarm74 = union {
  sphere { // Sphere720
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr591
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere721
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-15.42235, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm74 = union {
  cylinder { // Cylndr590
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere719
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm74 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-191.69194, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm75 = union {
  sphere { // Sphere723
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr593
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere724
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-36.483002, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm75 = union {
  cylinder { // Cylndr592
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere722
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm75 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-0.38599, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf37 = union {
  sphere { // Sphere725
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr594
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere726
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper37 = union {
  cylinder { // Cylndr589
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere718
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm74 }
  object { Oberarm75 }
  object { Kopf37 }
  translate  <0.0, 0.1, -1.1>
  rotate <-4.748751, -0.0, -0.0>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh74 = union {
  cylinder { // Cylndr597
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr598
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere729
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere730
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel74 = union {
  cylinder { // Cylndr596
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere728
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh74 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <0.429508, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein74 = union {
  cylinder { // Cylndr595
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere727
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel74 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-2.229014, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh75 = union {
  cylinder { // Cylndr601
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr602
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere733
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere734
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel75 = union {
  cylinder { // Cylndr600
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere732
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh75 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-1.935709, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein75 = union {
  cylinder { // Cylndr599
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere731
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel75 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-1.708184, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperA8 = union {
  object { Oberkoeper37 }
  object { Bein74 }
  object { Bein75 }
  scale 0.2
  rotate -20.46339*z
  translate  <-23.991554, 3.289003, 13.607341>
}
#declare Personen2 = union {
  object { KoeperE6 }
  object { KoeperD7 }
  object { KoeperC6 }
  object { KoeperB6 }
  object { KoeperA8 }
  rotate 101.778595*z
  translate  <-29.948857, 35.629338, 0.0>
}
#declare Unterarm56 = union {
  sphere { // Sphere567
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr465
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere568
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-0.151317, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm56 = union {
  cylinder { // Cylndr464
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere566
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm56 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-71.43721, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm57 = union {
  sphere { // Sphere570
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr467
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere571
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <6.507195, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm57 = union {
  cylinder { // Cylndr466
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere569
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm57 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <71.509941, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf28 = union {
  sphere { // Sphere572
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr468
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere573
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper28 = union {
  cylinder { // Cylndr463
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere565
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm56 }
  object { Oberarm57 }
  object { Kopf28 }
  translate  <0.0, 0.1, -1.1>
  rotate <-4.748751, -0.0, -0.0>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh56 = union {
  cylinder { // Cylndr471
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr472
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere576
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere577
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel56 = union {
  cylinder { // Cylndr470
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere575
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh56 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-37.412239, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein56 = union {
  cylinder { // Cylndr469
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere574
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel56 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <20.20797, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh57 = union {
  cylinder { // Cylndr475
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr476
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere580
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere581
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel57 = union {
  cylinder { // Cylndr474
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere579
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh57 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-1.935709, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein57 = union {
  cylinder { // Cylndr473
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere578
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel57 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-1.708184, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperE5 = union {
  object { Oberkoeper28 }
  object { Bein56 }
  object { Bein57 }
  scale 0.2
  rotate -26.878849*z
  translate  <-25.860623, 0.741893, 13.607341>
}
#declare Unterarm58 = union {
  sphere { // Sphere584
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr479
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere585
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-9.979704, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm58 = union {
  cylinder { // Cylndr478
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere583
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm58 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-145.970245, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm59 = union {
  sphere { // Sphere587
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr481
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere588
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-11.290077, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm59 = union {
  cylinder { // Cylndr480
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere586
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm59 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <5.021692, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf29 = union {
  sphere { // Sphere589
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr482
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere590
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper29 = union {
  cylinder { // Cylndr477
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere582
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm58 }
  object { Oberarm59 }
  object { Kopf29 }
  translate  <0.0, 0.1, -1.1>
  rotate <-4.748751, -0.0, -0.0>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh58 = union {
  cylinder { // Cylndr485
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr486
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere593
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere594
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel58 = union {
  cylinder { // Cylndr484
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere592
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh58 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <0.429508, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein58 = union {
  cylinder { // Cylndr483
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere591
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel58 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-2.229014, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh59 = union {
  cylinder { // Cylndr489
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr490
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere597
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere598
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel59 = union {
  cylinder { // Cylndr488
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere596
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh59 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-1.935709, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein59 = union {
  cylinder { // Cylndr487
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere595
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel59 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-1.708184, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperD6 = union {
  object { Oberkoeper29 }
  object { Bein58 }
  object { Bein59 }
  scale 0.2
  translate  <-26.581837, 2.456124, 13.607341>
}
#declare Unterarm60 = union {
  sphere { // Sphere601
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr493
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere602
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-31.349314, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm60 = union {
  cylinder { // Cylndr492
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere600
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm60 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-57.024162, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm61 = union {
  sphere { // Sphere604
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr495
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere605
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-11.290077, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm61 = union {
  cylinder { // Cylndr494
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere603
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm61 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <5.021692, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf30 = union {
  sphere { // Sphere606
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr496
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere607
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper30 = union {
  cylinder { // Cylndr491
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere599
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm60 }
  object { Oberarm61 }
  object { Kopf30 }
  translate  <0.0, 0.1, -1.1>
  rotate <-4.748751, -0.0, -0.0>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh60 = union {
  cylinder { // Cylndr499
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr500
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere610
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere611
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel60 = union {
  cylinder { // Cylndr498
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere609
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh60 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <0.429508, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein60 = union {
  cylinder { // Cylndr497
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere608
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel60 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-2.229014, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh61 = union {
  cylinder { // Cylndr503
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr504
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere614
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere615
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel61 = union {
  cylinder { // Cylndr502
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere613
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh61 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-41.291786, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein61 = union {
  cylinder { // Cylndr501
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere612
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel61 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <26.502007, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperC5 = union {
  object { Oberkoeper30 }
  object { Bein60 }
  object { Bein61 }
  scale 0.2
  rotate -14.898658*z
  translate  <-23.322106, 0.44842, 13.607341>
}
#declare Unterarm62 = union {
  sphere { // Sphere618
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr507
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere619
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <11.332053, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm62 = union {
  cylinder { // Cylndr506
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere617
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm62 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-183.932617, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm63 = union {
  sphere { // Sphere621
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr509
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere622
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-11.800155, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm63 = union {
  cylinder { // Cylndr508
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere620
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm63 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-42.57547, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf31 = union {
  sphere { // Sphere623
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr510
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere624
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper31 = union {
  cylinder { // Cylndr505
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere616
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm62 }
  object { Oberarm63 }
  object { Kopf31 }
  translate  <0.0, 0.1, -1.1>
  rotate <-17.359118, 8.438898, -0.934104>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh62 = union {
  cylinder { // Cylndr513
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr514
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere627
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere628
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <68.052254, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel62 = union {
  cylinder { // Cylndr512
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere626
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh62 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-77.489845, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein62 = union {
  cylinder { // Cylndr511
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere625
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel62 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <46.488861, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh63 = union {
  cylinder { // Cylndr517
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr518
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere631
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere632
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel63 = union {
  cylinder { // Cylndr516
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere630
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh63 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-32.66293, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein63 = union {
  cylinder { // Cylndr515
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere629
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel63 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-24.897869, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperB5 = union {
  object { Oberkoeper31 }
  object { Bein62 }
  object { Bein63 }
  scale 0.2
  rotate -55.801628*z
  translate  <-24.463197, -1.400308, 13.620281>
}
#declare Unterarm64 = union {
  sphere { // Sphere635
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr521
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere636
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-15.42235, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm64 = union {
  cylinder { // Cylndr520
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere634
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm64 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-191.69194, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm65 = union {
  sphere { // Sphere638
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr523
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere639
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-36.483002, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm65 = union {
  cylinder { // Cylndr522
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere637
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm65 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-0.38599, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf32 = union {
  sphere { // Sphere640
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr524
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere641
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper32 = union {
  cylinder { // Cylndr519
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere633
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm64 }
  object { Oberarm65 }
  object { Kopf32 }
  translate  <0.0, 0.1, -1.1>
  rotate <-4.748751, -0.0, -0.0>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh64 = union {
  cylinder { // Cylndr527
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr528
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere644
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere645
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel64 = union {
  cylinder { // Cylndr526
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere643
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh64 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <0.429508, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein64 = union {
  cylinder { // Cylndr525
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere642
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel64 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-2.229014, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh65 = union {
  cylinder { // Cylndr531
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr532
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere648
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere649
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel65 = union {
  cylinder { // Cylndr530
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere647
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh65 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-1.935709, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein65 = union {
  cylinder { // Cylndr529
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere646
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel65 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-1.708184, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperA7 = union {
  object { Oberkoeper32 }
  object { Bein64 }
  object { Bein65 }
  scale 0.2
  rotate -20.46339*z
  translate  <-23.991554, 3.289003, 13.607341>
}
#declare Personen1 = union {
  object { KoeperE5 }
  object { KoeperD6 }
  object { KoeperC5 }
  object { KoeperB5 }
  object { KoeperA7 }
  translate  <24.422592, 16.891815, 0.0>
}
#declare Unterarm46 = union {
  sphere { // Sphere482
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr395
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere483
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-0.151317, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm46 = union {
  cylinder { // Cylndr394
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere481
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm46 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-71.43721, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm47 = union {
  sphere { // Sphere485
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr397
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere486
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <6.507195, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm47 = union {
  cylinder { // Cylndr396
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere484
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm47 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <71.509941, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf23 = union {
  sphere { // Sphere487
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr398
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere488
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper23 = union {
  cylinder { // Cylndr393
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere480
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm46 }
  object { Oberarm47 }
  object { Kopf23 }
  translate  <0.0, 0.1, -1.1>
  rotate <-4.748751, -0.0, -0.0>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh46 = union {
  cylinder { // Cylndr401
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr402
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere491
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere492
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel46 = union {
  cylinder { // Cylndr400
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere490
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh46 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-37.412239, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein46 = union {
  cylinder { // Cylndr399
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere489
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel46 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <20.20797, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh47 = union {
  cylinder { // Cylndr405
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr406
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere495
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere496
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel47 = union {
  cylinder { // Cylndr404
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere494
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh47 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-1.935709, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein47 = union {
  cylinder { // Cylndr403
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere493
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel47 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-1.708184, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperE3 = union {
  object { Oberkoeper23 }
  object { Bein46 }
  object { Bein47 }
  scale 0.2
  rotate -26.878849*z
  translate  <-25.860623, 0.741893, 13.607341>
}
#declare Unterarm40 = union {
  sphere { // Sphere431
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr353
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere432
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-9.979704, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm40 = union {
  cylinder { // Cylndr352
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere430
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm40 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-145.970245, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm41 = union {
  sphere { // Sphere434
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr355
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere435
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-11.290077, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm41 = union {
  cylinder { // Cylndr354
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere433
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm41 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <5.021692, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf20 = union {
  sphere { // Sphere436
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr356
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere437
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper20 = union {
  cylinder { // Cylndr351
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere429
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm40 }
  object { Oberarm41 }
  object { Kopf20 }
  translate  <0.0, 0.1, -1.1>
  rotate <-4.748751, -0.0, -0.0>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh40 = union {
  cylinder { // Cylndr359
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr360
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere440
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere441
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel40 = union {
  cylinder { // Cylndr358
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere439
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh40 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <0.429508, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein40 = union {
  cylinder { // Cylndr357
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere438
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel40 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-2.229014, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh41 = union {
  cylinder { // Cylndr363
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr364
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere444
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere445
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel41 = union {
  cylinder { // Cylndr362
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere443
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh41 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-1.935709, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein41 = union {
  cylinder { // Cylndr361
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere442
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel41 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-1.708184, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperD4 = union {
  object { Oberkoeper20 }
  object { Bein40 }
  object { Bein41 }
  scale 0.2
  translate  <-26.581837, 2.456124, 13.607341>
}
#declare Unterarm30 = union {
  sphere { // Sphere346
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr283
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere347
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-31.349314, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm30 = union {
  cylinder { // Cylndr282
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere345
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm30 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-57.024162, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm31 = union {
  sphere { // Sphere349
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr285
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere350
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-11.290077, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm31 = union {
  cylinder { // Cylndr284
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere348
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm31 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <5.021692, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf15 = union {
  sphere { // Sphere351
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr286
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere352
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper15 = union {
  cylinder { // Cylndr281
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere344
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm30 }
  object { Oberarm31 }
  object { Kopf15 }
  translate  <0.0, 0.1, -1.1>
  rotate <-4.748751, -0.0, -0.0>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh30 = union {
  cylinder { // Cylndr289
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr290
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere355
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere356
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel30 = union {
  cylinder { // Cylndr288
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere354
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh30 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <0.429508, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein30 = union {
  cylinder { // Cylndr287
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere353
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel30 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-2.229014, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh31 = union {
  cylinder { // Cylndr293
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr294
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere359
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere360
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel31 = union {
  cylinder { // Cylndr292
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere358
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh31 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-41.291786, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein31 = union {
  cylinder { // Cylndr291
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere357
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel31 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <26.502007, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperC3 = union {
  object { Oberkoeper15 }
  object { Bein30 }
  object { Bein31 }
  scale 0.2
  rotate -14.898658*z
  translate  <-23.322106, 0.44842, 13.607341>
}
#declare Unterarm24 = union {
  sphere { // Sphere295
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr241
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere296
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <11.332053, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm24 = union {
  cylinder { // Cylndr240
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere294
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm24 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-183.932617, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm25 = union {
  sphere { // Sphere298
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr243
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere299
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-11.800155, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm25 = union {
  cylinder { // Cylndr242
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere297
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm25 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-42.57547, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf12 = union {
  sphere { // Sphere300
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr244
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere301
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper12 = union {
  cylinder { // Cylndr239
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere293
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm24 }
  object { Oberarm25 }
  object { Kopf12 }
  translate  <0.0, 0.1, -1.1>
  rotate <-17.359118, 8.438898, -0.934104>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh24 = union {
  cylinder { // Cylndr247
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr248
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere304
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere305
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <68.052254, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel24 = union {
  cylinder { // Cylndr246
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere303
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh24 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-77.489845, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein24 = union {
  cylinder { // Cylndr245
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere302
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel24 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <46.488861, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh25 = union {
  cylinder { // Cylndr251
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr252
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere308
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere309
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel25 = union {
  cylinder { // Cylndr250
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere307
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh25 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-32.66293, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein25 = union {
  cylinder { // Cylndr249
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere306
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel25 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-24.897869, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperB4 = union {
  object { Oberkoeper12 }
  object { Bein24 }
  object { Bein25 }
  scale 0.2
  rotate -55.801628*z
  translate  <-16.978063, -13.87553, 13.620281>
}
#declare Unterarm16 = union {
  sphere { // Sphere227
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr185
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere228
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-15.42235, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm16 = union {
  cylinder { // Cylndr184
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere226
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm16 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-191.69194, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm17 = union {
  sphere { // Sphere230
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr187
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere231
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-36.483002, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm17 = union {
  cylinder { // Cylndr186
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere229
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm17 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-0.38599, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf8 = union {
  sphere { // Sphere232
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr188
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere233
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper8 = union {
  cylinder { // Cylndr183
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere225
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm16 }
  object { Oberarm17 }
  object { Kopf8 }
  translate  <0.0, 0.1, -1.1>
  rotate <-4.748751, -0.0, -0.0>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh16 = union {
  cylinder { // Cylndr191
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr192
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere236
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere237
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel16 = union {
  cylinder { // Cylndr190
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere235
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh16 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <0.429508, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein16 = union {
  cylinder { // Cylndr189
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere234
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel16 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-2.229014, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh17 = union {
  cylinder { // Cylndr195
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr196
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere240
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere241
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel17 = union {
  cylinder { // Cylndr194
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere239
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh17 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-1.935709, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein17 = union {
  cylinder { // Cylndr193
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere238
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel17 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-1.708184, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperA4 = union {
  object { Oberkoeper8 }
  object { Bein16 }
  object { Bein17 }
  scale 0.2
  rotate -20.46339*z
  translate  <-12.902467, -14.176308, 13.607341>
}
#declare Personen = union {
  object { KoeperE3 }
  object { KoeperD4 }
  object { KoeperC3 }
  object { KoeperB4 }
  object { KoeperA4 }
  translate  -0.831682*x
}
#declare Unterarm54 = union {
  sphere { // Sphere550
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr451
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere551
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-9.979704, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm54 = union {
  cylinder { // Cylndr450
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere549
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm54 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-145.970245, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm55 = union {
  sphere { // Sphere553
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr453
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere554
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-11.290077, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm55 = union {
  cylinder { // Cylndr452
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere552
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm55 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <5.021692, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf27 = union {
  sphere { // Sphere555
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr454
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere556
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper27 = union {
  cylinder { // Cylndr449
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere548
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm54 }
  object { Oberarm55 }
  object { Kopf27 }
  translate  <0.0, 0.1, -1.1>
  rotate <-4.748751, 0.0, -71.13092>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh54 = union {
  cylinder { // Cylndr457
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr458
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere559
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere560
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel54 = union {
  cylinder { // Cylndr456
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere558
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh54 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <0.429508, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein54 = union {
  cylinder { // Cylndr455
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere557
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel54 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-2.229014, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh55 = union {
  cylinder { // Cylndr461
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr462
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere563
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere564
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel55 = union {
  cylinder { // Cylndr460
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere562
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh55 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-1.935709, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein55 = union {
  cylinder { // Cylndr459
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere561
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel55 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-1.708184, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperD5 = union {
  object { Oberkoeper27 }
  object { Bein54 }
  object { Bein55 }
  scale 0.2
  translate  <-5.992569, 27.085145, 17.602189>
}
#declare Unterarm52 = union {
  sphere { // Sphere533
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr437
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere534
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-46.677689, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm52 = union {
  cylinder { // Cylndr436
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere532
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm52 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-66.904411, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm53 = union {
  sphere { // Sphere536
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr439
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere537
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-36.483002, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm53 = union {
  cylinder { // Cylndr438
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere535
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm53 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-0.38599, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf26 = union {
  sphere { // Sphere538
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr440
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere539
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper26 = union {
  cylinder { // Cylndr435
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere531
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm52 }
  object { Oberarm53 }
  object { Kopf26 }
  translate  <0.0, 0.1, -1.1>
  rotate <-4.748751, -0.0, -0.0>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh52 = union {
  cylinder { // Cylndr443
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr444
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere542
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere543
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel52 = union {
  cylinder { // Cylndr442
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere541
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh52 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <0.429508, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein52 = union {
  cylinder { // Cylndr441
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere540
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel52 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-2.229014, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh53 = union {
  cylinder { // Cylndr447
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr448
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere546
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere547
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel53 = union {
  cylinder { // Cylndr446
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere545
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh53 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-1.935709, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein53 = union {
  cylinder { // Cylndr445
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere544
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel53 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-1.708184, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperA6 = union {
  object { Oberkoeper26 }
  object { Bein52 }
  object { Bein53 }
  scale 0.2
  rotate -51.068703*z
  translate  <-20.652274, 24.654061, 17.576607>
}
#declare Unterarm50 = union {
  sphere { // Sphere516
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr423
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere517
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-15.42235, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm50 = union {
  cylinder { // Cylndr422
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere515
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm50 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-191.69194, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm51 = union {
  sphere { // Sphere519
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr425
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere520
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-36.483002, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm51 = union {
  cylinder { // Cylndr424
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere518
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm51 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-0.38599, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf25 = union {
  sphere { // Sphere521
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr426
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere522
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper25 = union {
  cylinder { // Cylndr421
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere514
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm50 }
  object { Oberarm51 }
  object { Kopf25 }
  translate  <0.0, 0.1, -1.1>
  rotate <-4.748751, -0.0, -0.0>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh50 = union {
  cylinder { // Cylndr429
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr430
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere525
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere526
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel50 = union {
  cylinder { // Cylndr428
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere524
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh50 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <0.429508, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein50 = union {
  cylinder { // Cylndr427
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere523
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel50 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-2.229014, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh51 = union {
  cylinder { // Cylndr433
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr434
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere529
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere530
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel51 = union {
  cylinder { // Cylndr432
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere528
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh51 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-1.935709, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein51 = union {
  cylinder { // Cylndr431
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere527
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel51 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-1.708184, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperA5 = union {
  object { Oberkoeper25 }
  object { Bein50 }
  object { Bein51 }
  scale 0.2
  rotate -87.275787*z
  translate  <-21.585198, 25.545863, 17.590106>
}
#declare Unterarm48 = union {
  sphere { // Sphere499
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr409
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere500
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-0.151317, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm48 = union {
  cylinder { // Cylndr408
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere498
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm48 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-71.43721, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm49 = union {
  sphere { // Sphere502
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr411
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere503
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <6.507195, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm49 = union {
  cylinder { // Cylndr410
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere501
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm49 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <71.509941, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf24 = union {
  sphere { // Sphere504
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr412
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere505
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper24 = union {
  cylinder { // Cylndr407
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere497
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm48 }
  object { Oberarm49 }
  object { Kopf24 }
  translate  <0.0, 0.1, -1.1>
  rotate <-4.748751, -0.0, -0.0>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh48 = union {
  cylinder { // Cylndr415
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr416
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere508
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere509
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel48 = union {
  cylinder { // Cylndr414
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere507
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh48 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-37.412239, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein48 = union {
  cylinder { // Cylndr413
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere506
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel48 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <20.20797, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh49 = union {
  cylinder { // Cylndr419
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr420
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere512
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere513
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel49 = union {
  cylinder { // Cylndr418
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere511
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh49 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-1.935709, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein49 = union {
  cylinder { // Cylndr417
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere510
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel49 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-1.708184, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperE4 = union {
  object { Oberkoeper24 }
  object { Bein48 }
  object { Bein49 }
  scale 0.2
  translate  <-28.589356, -1.829215, 13.607341>
}
#declare Unterarm42 = union {
  sphere { // Sphere448
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr367
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere449
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-0.151317, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm42 = union {
  cylinder { // Cylndr366
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere447
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm42 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-71.43721, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm43 = union {
  sphere { // Sphere451
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr369
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere452
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <6.507195, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm43 = union {
  cylinder { // Cylndr368
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere450
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm43 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <71.509941, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf21 = union {
  sphere { // Sphere453
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr370
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere454
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper21 = union {
  cylinder { // Cylndr365
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere446
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm42 }
  object { Oberarm43 }
  object { Kopf21 }
  translate  <0.0, 0.1, -1.1>
  rotate <-4.748751, -0.0, -0.0>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh42 = union {
  cylinder { // Cylndr373
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr374
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere457
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere458
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel42 = union {
  cylinder { // Cylndr372
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere456
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh42 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-37.412239, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein42 = union {
  cylinder { // Cylndr371
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere455
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel42 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <20.20797, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh43 = union {
  cylinder { // Cylndr377
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr378
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere461
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere462
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel43 = union {
  cylinder { // Cylndr376
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere460
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh43 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-1.935709, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein43 = union {
  cylinder { // Cylndr375
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere459
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel43 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-1.708184, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperE1 = union {
  object { Oberkoeper21 }
  object { Bein42 }
  object { Bein43 }
  scale 0.2
  rotate -52.947964*z
  translate  <-30.80637, 3.204495, 13.607341>
}
#declare Unterarm44 = union {
  sphere { // Sphere465
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr381
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere466
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-0.151317, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm44 = union {
  cylinder { // Cylndr380
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere464
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm44 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-71.43721, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm45 = union {
  sphere { // Sphere468
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr383
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere469
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <6.507195, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm45 = union {
  cylinder { // Cylndr382
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere467
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm45 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <71.509941, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf22 = union {
  sphere { // Sphere470
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr384
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere471
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper22 = union {
  cylinder { // Cylndr379
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere463
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm44 }
  object { Oberarm45 }
  object { Kopf22 }
  translate  <0.0, 0.1, -1.1>
  rotate <-4.748751, -0.0, -0.0>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh44 = union {
  cylinder { // Cylndr387
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr388
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere474
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere475
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel44 = union {
  cylinder { // Cylndr386
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere473
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh44 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-37.412239, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein44 = union {
  cylinder { // Cylndr385
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere472
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel44 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <20.20797, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh45 = union {
  cylinder { // Cylndr391
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr392
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere478
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere479
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel45 = union {
  cylinder { // Cylndr390
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere477
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh45 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-1.935709, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein45 = union {
  cylinder { // Cylndr389
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere476
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel45 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-1.708184, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperE2 = union {
  object { Oberkoeper22 }
  object { Bein44 }
  object { Bein45 }
  scale 0.2
  translate  <-19.664153, -7.090211, 13.607341>
}
#declare Unterarm38 = union {
  sphere { // Sphere414
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr339
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere415
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-9.979704, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm38 = union {
  cylinder { // Cylndr338
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere413
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm38 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-145.970245, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm39 = union {
  sphere { // Sphere417
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr341
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere418
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-11.290077, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm39 = union {
  cylinder { // Cylndr340
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere416
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm39 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <5.021692, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf19 = union {
  sphere { // Sphere419
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr342
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere420
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper19 = union {
  cylinder { // Cylndr337
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere412
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm38 }
  object { Oberarm39 }
  object { Kopf19 }
  translate  <0.0, 0.1, -1.1>
  rotate <-4.748751, -0.0, -0.0>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh38 = union {
  cylinder { // Cylndr345
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr346
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere423
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere424
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel38 = union {
  cylinder { // Cylndr344
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere422
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh38 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <0.429508, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein38 = union {
  cylinder { // Cylndr343
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere421
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel38 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-2.229014, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh39 = union {
  cylinder { // Cylndr349
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr350
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere427
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere428
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel39 = union {
  cylinder { // Cylndr348
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere426
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh39 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-1.935709, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein39 = union {
  cylinder { // Cylndr347
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere425
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel39 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-1.708184, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperD3 = union {
  object { Oberkoeper19 }
  object { Bein38 }
  object { Bein39 }
  scale 0.2
  rotate <0.0, -0.0, -27.506067>
  translate  <-9.036407, -0.174373, 13.607341>
}
#declare Unterarm36 = union {
  sphere { // Sphere397
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr325
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere398
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-9.979704, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm36 = union {
  cylinder { // Cylndr324
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere396
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm36 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-145.970245, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm37 = union {
  sphere { // Sphere400
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr327
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere401
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-11.290077, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm37 = union {
  cylinder { // Cylndr326
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere399
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm37 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <5.021692, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf18 = union {
  sphere { // Sphere402
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr328
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere403
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper18 = union {
  cylinder { // Cylndr323
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere395
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm36 }
  object { Oberarm37 }
  object { Kopf18 }
  translate  <0.0, 0.1, -1.1>
  rotate <-4.748751, -0.0, -0.0>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh36 = union {
  cylinder { // Cylndr331
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr332
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere406
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere407
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel36 = union {
  cylinder { // Cylndr330
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere405
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh36 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <0.429508, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein36 = union {
  cylinder { // Cylndr329
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere404
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel36 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-2.229014, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh37 = union {
  cylinder { // Cylndr335
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr336
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere410
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere411
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel37 = union {
  cylinder { // Cylndr334
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere409
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh37 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-1.935709, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein37 = union {
  cylinder { // Cylndr333
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere408
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel37 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-1.708184, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperD2 = union {
  object { Oberkoeper18 }
  object { Bein36 }
  object { Bein37 }
  scale 0.2
  translate  <-12.612652, -4.065867, 13.607341>
}
#declare Unterarm34 = union {
  sphere { // Sphere380
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr311
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere381
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-9.979704, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm34 = union {
  cylinder { // Cylndr310
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere379
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm34 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-145.970245, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm35 = union {
  sphere { // Sphere383
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr313
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere384
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-11.290077, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm35 = union {
  cylinder { // Cylndr312
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere382
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm35 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <5.021692, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf17 = union {
  sphere { // Sphere385
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr314
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere386
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper17 = union {
  cylinder { // Cylndr309
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere378
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm34 }
  object { Oberarm35 }
  object { Kopf17 }
  translate  <0.0, 0.1, -1.1>
  rotate <-4.748751, -0.0, -0.0>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh34 = union {
  cylinder { // Cylndr317
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr318
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere389
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere390
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel34 = union {
  cylinder { // Cylndr316
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere388
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh34 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <0.429508, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein34 = union {
  cylinder { // Cylndr315
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere387
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel34 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-2.229014, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh35 = union {
  cylinder { // Cylndr321
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr322
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere393
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere394
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel35 = union {
  cylinder { // Cylndr320
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere392
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh35 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-1.935709, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein35 = union {
  cylinder { // Cylndr319
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere391
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel35 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-1.708184, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperD1 = union {
  object { Oberkoeper17 }
  object { Bein34 }
  object { Bein35 }
  scale 0.2
  translate  <-22.966747, 2.918726, 13.607341>
}
#declare Unterarm32 = union {
  sphere { // Sphere363
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr297
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere364
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-31.349314, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm32 = union {
  cylinder { // Cylndr296
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere362
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm32 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-57.024162, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm33 = union {
  sphere { // Sphere366
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr299
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere367
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-11.290077, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm33 = union {
  cylinder { // Cylndr298
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere365
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm33 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <5.021692, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf16 = union {
  sphere { // Sphere368
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr300
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere369
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper16 = union {
  cylinder { // Cylndr295
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere361
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm32 }
  object { Oberarm33 }
  object { Kopf16 }
  translate  <0.0, 0.1, -1.1>
  rotate <-4.748751, -0.0, -0.0>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh32 = union {
  cylinder { // Cylndr303
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr304
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere372
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere373
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel32 = union {
  cylinder { // Cylndr302
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere371
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh32 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <0.429508, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein32 = union {
  cylinder { // Cylndr301
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere370
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel32 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-2.229014, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh33 = union {
  cylinder { // Cylndr307
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr308
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere376
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere377
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel33 = union {
  cylinder { // Cylndr306
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere375
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh33 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-41.291786, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein33 = union {
  cylinder { // Cylndr305
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere374
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel33 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <26.502007, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperC4 = union {
  object { Oberkoeper16 }
  object { Bein32 }
  object { Bein33 }
  scale 0.2
  rotate -83.765724*z
  translate  <-28.431962, -10.178291, 13.607341>
}
#declare Unterarm28 = union {
  sphere { // Sphere329
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr269
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere330
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-31.349314, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm28 = union {
  cylinder { // Cylndr268
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere328
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm28 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-57.024162, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm29 = union {
  sphere { // Sphere332
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr271
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere333
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-11.290077, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm29 = union {
  cylinder { // Cylndr270
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere331
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm29 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <5.021692, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf14 = union {
  sphere { // Sphere334
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr272
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere335
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper14 = union {
  cylinder { // Cylndr267
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere327
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm28 }
  object { Oberarm29 }
  object { Kopf14 }
  translate  <0.0, 0.1, -1.1>
  rotate <-4.748751, -0.0, -0.0>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh28 = union {
  cylinder { // Cylndr275
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr276
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere338
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere339
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel28 = union {
  cylinder { // Cylndr274
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere337
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh28 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <0.429508, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein28 = union {
  cylinder { // Cylndr273
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere336
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel28 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-2.229014, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh29 = union {
  cylinder { // Cylndr279
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr280
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere342
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere343
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel29 = union {
  cylinder { // Cylndr278
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere341
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh29 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-41.291786, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein29 = union {
  cylinder { // Cylndr277
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere340
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel29 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <26.502007, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperC2 = union {
  object { Oberkoeper14 }
  object { Bein28 }
  object { Bein29 }
  scale 0.2
  rotate -38.098454*z
  translate  <-17.440885, 2.861904, 13.607341>
}
#declare Unterarm26 = union {
  sphere { // Sphere312
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr255
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere313
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-31.349314, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm26 = union {
  cylinder { // Cylndr254
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere311
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm26 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-57.024162, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm27 = union {
  sphere { // Sphere315
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr257
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere316
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-11.290077, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm27 = union {
  cylinder { // Cylndr256
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere314
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm27 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <5.021692, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf13 = union {
  sphere { // Sphere317
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr258
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere318
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper13 = union {
  cylinder { // Cylndr253
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere310
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm26 }
  object { Oberarm27 }
  object { Kopf13 }
  translate  <0.0, 0.1, -1.1>
  rotate <-4.748751, -0.0, -0.0>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh26 = union {
  cylinder { // Cylndr261
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr262
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere321
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere322
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel26 = union {
  cylinder { // Cylndr260
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere320
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh26 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <0.429508, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein26 = union {
  cylinder { // Cylndr259
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere319
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel26 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-2.229014, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh27 = union {
  cylinder { // Cylndr265
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr266
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere325
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere326
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel27 = union {
  cylinder { // Cylndr264
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere324
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh27 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-41.291786, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein27 = union {
  cylinder { // Cylndr263
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere323
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel27 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <26.502007, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperC1 = union {
  object { Oberkoeper13 }
  object { Bein26 }
  object { Bein27 }
  scale 0.2
  rotate -83.765724*z
  translate  <-20.859505, 1.965275, 13.607341>
}
#declare Unterarm22 = union {
  sphere { // Sphere278
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr227
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere279
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <11.332053, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm22 = union {
  cylinder { // Cylndr226
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere277
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm22 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-183.932617, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm23 = union {
  sphere { // Sphere281
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr229
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere282
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-11.800155, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm23 = union {
  cylinder { // Cylndr228
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere280
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm23 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-42.57547, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf11 = union {
  sphere { // Sphere283
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr230
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere284
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper11 = union {
  cylinder { // Cylndr225
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere276
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm22 }
  object { Oberarm23 }
  object { Kopf11 }
  translate  <0.0, 0.1, -1.1>
  rotate <-17.359118, 8.438898, -0.934104>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh22 = union {
  cylinder { // Cylndr233
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr234
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere287
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere288
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <68.052254, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel22 = union {
  cylinder { // Cylndr232
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere286
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh22 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-77.489845, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein22 = union {
  cylinder { // Cylndr231
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere285
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel22 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <46.488861, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh23 = union {
  cylinder { // Cylndr237
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr238
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere291
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere292
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel23 = union {
  cylinder { // Cylndr236
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere290
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh23 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-32.66293, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein23 = union {
  cylinder { // Cylndr235
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere289
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel23 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-24.897869, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperB3 = union {
  object { Oberkoeper11 }
  object { Bein22 }
  object { Bein23 }
  scale 0.2
  rotate -55.801628*z
  translate  <-17.717068, 0.202162, 13.620281>
}
#declare Unterarm20 = union {
  sphere { // Sphere261
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr213
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere262
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <11.332053, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm20 = union {
  cylinder { // Cylndr212
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere260
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm20 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-183.932617, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm21 = union {
  sphere { // Sphere264
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr215
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere265
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-11.800155, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm21 = union {
  cylinder { // Cylndr214
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere263
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm21 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-42.57547, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf10 = union {
  sphere { // Sphere266
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr216
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere267
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper10 = union {
  cylinder { // Cylndr211
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere259
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm20 }
  object { Oberarm21 }
  object { Kopf10 }
  translate  <0.0, 0.1, -1.1>
  rotate <-17.359118, 8.438898, -0.934104>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh20 = union {
  cylinder { // Cylndr219
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr220
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere270
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere271
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <68.052254, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel20 = union {
  cylinder { // Cylndr218
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere269
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh20 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-77.489845, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein20 = union {
  cylinder { // Cylndr217
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere268
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel20 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <46.488861, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh21 = union {
  cylinder { // Cylndr223
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr224
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere274
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere275
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel21 = union {
  cylinder { // Cylndr222
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere273
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh21 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-32.66293, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein21 = union {
  cylinder { // Cylndr221
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere272
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel21 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-24.897869, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperB2 = union {
  object { Oberkoeper10 }
  object { Bein20 }
  object { Bein21 }
  scale 0.2
  rotate -41.167385*z
  translate  <-23.34243, -12.043426, 13.620281>
}
#declare Unterarm18 = union {
  sphere { // Sphere244
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr199
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere245
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <11.332053, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm18 = union {
  cylinder { // Cylndr198
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere243
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm18 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-183.932617, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm19 = union {
  sphere { // Sphere247
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr201
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere248
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-11.800155, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm19 = union {
  cylinder { // Cylndr200
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere246
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm19 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-42.57547, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf9 = union {
  sphere { // Sphere249
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr202
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere250
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper9 = union {
  cylinder { // Cylndr197
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere242
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm18 }
  object { Oberarm19 }
  object { Kopf9 }
  translate  <0.0, 0.1, -1.1>
  rotate <-17.359118, 8.438898, -0.934104>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh18 = union {
  cylinder { // Cylndr205
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr206
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere253
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere254
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <68.052254, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel18 = union {
  cylinder { // Cylndr204
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere252
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh18 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-77.489845, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein18 = union {
  cylinder { // Cylndr203
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere251
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel18 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <46.488861, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh19 = union {
  cylinder { // Cylndr209
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr210
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere257
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere258
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel19 = union {
  cylinder { // Cylndr208
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere256
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh19 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-32.66293, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein19 = union {
  cylinder { // Cylndr207
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere255
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel19 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-24.897869, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperB1 = union {
  object { Oberkoeper9 }
  object { Bein18 }
  object { Bein19 }
  scale 0.2
  rotate -30.555103*z
  translate  <-32.932261, -8.368947, 13.512918>
}
#declare Unterarm14 = union {
  sphere { // Sphere210
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr171
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere211
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-15.42235, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm14 = union {
  cylinder { // Cylndr170
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere209
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm14 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-191.69194, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm15 = union {
  sphere { // Sphere213
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr173
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere214
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-36.483002, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm15 = union {
  cylinder { // Cylndr172
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere212
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm15 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-0.38599, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf7 = union {
  sphere { // Sphere215
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr174
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere216
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper7 = union {
  cylinder { // Cylndr169
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere208
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm14 }
  object { Oberarm15 }
  object { Kopf7 }
  translate  <0.0, 0.1, -1.1>
  rotate <-4.748751, -0.0, -0.0>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh14 = union {
  cylinder { // Cylndr177
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr178
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere219
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere220
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel14 = union {
  cylinder { // Cylndr176
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere218
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh14 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <0.429508, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein14 = union {
  cylinder { // Cylndr175
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere217
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel14 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-2.229014, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh15 = union {
  cylinder { // Cylndr181
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr182
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere223
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere224
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel15 = union {
  cylinder { // Cylndr180
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere222
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh15 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-1.935709, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein15 = union {
  cylinder { // Cylndr179
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere221
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel15 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-1.708184, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperA3 = union {
  object { Oberkoeper7 }
  object { Bein14 }
  object { Bein15 }
  scale 0.2
  rotate -20.46339*z
  translate  <-11.402247, -2.631978, 13.607341>
}
#declare Unterarm10 = union {
  sphere { // Sphere176
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr143
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere177
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-15.42235, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm10 = union {
  cylinder { // Cylndr142
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere175
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm10 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-191.69194, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm11 = union {
  sphere { // Sphere179
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr145
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere180
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-36.483002, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm11 = union {
  cylinder { // Cylndr144
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere178
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm11 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-0.38599, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf5 = union {
  sphere { // Sphere181
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr146
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere182
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper5 = union {
  cylinder { // Cylndr141
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere174
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm10 }
  object { Oberarm11 }
  object { Kopf5 }
  translate  <0.0, 0.1, -1.1>
  rotate <-4.748751, -0.0, -0.0>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh10 = union {
  cylinder { // Cylndr149
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr150
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere185
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere186
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel10 = union {
  cylinder { // Cylndr148
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere184
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh10 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <0.429508, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein10 = union {
  cylinder { // Cylndr147
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere183
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel10 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-2.229014, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh11 = union {
  cylinder { // Cylndr153
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr154
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere189
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere190
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel11 = union {
  cylinder { // Cylndr152
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere188
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh11 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-1.935709, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein11 = union {
  cylinder { // Cylndr151
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere187
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel11 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-1.708184, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperA1 = union {
  object { Oberkoeper5 }
  object { Bein10 }
  object { Bein11 }
  scale 0.2
  rotate -20.46339*z
  translate  <-17.684999, -2.370841, 13.607341>
}
#declare Unterarm8 = union {
  sphere { // Sphere107
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr129
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere108
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-0.151317, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm8 = union {
  cylinder { // Cylndr128
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere106
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm8 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-71.43721, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm9 = union {
  sphere { // Sphere110
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr131
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere111
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <6.507195, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm9 = union {
  cylinder { // Cylndr130
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere109
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm9 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <71.509941, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf4 = union {
  sphere { // Sphere112
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr132
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere113
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper4 = union {
  cylinder { // Cylndr127
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere105
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm8 }
  object { Oberarm9 }
  object { Kopf4 }
  translate  <0.0, 0.1, -1.1>
  rotate <-4.748751, -0.0, -0.0>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh8 = union {
  cylinder { // Cylndr135
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr136
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere116
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere117
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel8 = union {
  cylinder { // Cylndr134
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere115
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh8 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-37.412239, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein8 = union {
  cylinder { // Cylndr133
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere114
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel8 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <20.20797, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh9 = union {
  cylinder { // Cylndr139
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr140
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere120
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere121
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel9 = union {
  cylinder { // Cylndr138
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere119
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh9 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-1.935709, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein9 = union {
  cylinder { // Cylndr137
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere118
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel9 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-1.708184, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperE = union {
  object { Oberkoeper4 }
  object { Bein8 }
  object { Bein9 }
  scale 0.2
  translate  <-20.821976, -28.457798, 13.607341>
}
#declare Unterarm6 = union {
  sphere { // Sphere090
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr115
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere091
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-9.979704, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm6 = union {
  cylinder { // Cylndr114
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere089
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm6 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-145.970245, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm7 = union {
  sphere { // Sphere093
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr117
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere094
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-11.290077, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm7 = union {
  cylinder { // Cylndr116
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere092
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm7 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <5.021692, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf3 = union {
  sphere { // Sphere095
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr118
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere096
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper3 = union {
  cylinder { // Cylndr113
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere088
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm6 }
  object { Oberarm7 }
  object { Kopf3 }
  translate  <0.0, 0.1, -1.1>
  rotate <-4.748751, -0.0, -0.0>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh6 = union {
  cylinder { // Cylndr121
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr122
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere099
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere100
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel6 = union {
  cylinder { // Cylndr120
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere098
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh6 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <0.429508, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein6 = union {
  cylinder { // Cylndr119
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere097
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel6 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-2.229014, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh7 = union {
  cylinder { // Cylndr125
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr126
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere103
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere104
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel7 = union {
  cylinder { // Cylndr124
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere102
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh7 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-1.935709, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein7 = union {
  cylinder { // Cylndr123
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere101
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel7 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-1.708184, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperD = union {
  object { Oberkoeper3 }
  object { Bein6 }
  object { Bein7 }
  scale 0.2
  translate  <-25.43962, -17.208084, 13.607341>
}
#declare Unterarm4 = union {
  sphere { // Sphere073
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr101
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere074
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-31.349314, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm4 = union {
  cylinder { // Cylndr100
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere072
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm4 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-57.024162, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm5 = union {
  sphere { // Sphere076
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr103
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere077
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-11.290077, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm5 = union {
  cylinder { // Cylndr102
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere075
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm5 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <5.021692, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf2 = union {
  sphere { // Sphere078
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr104
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere079
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper2 = union {
  cylinder { // Cylndr099
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere071
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm4 }
  object { Oberarm5 }
  object { Kopf2 }
  translate  <0.0, 0.1, -1.1>
  rotate <-4.748751, -0.0, -0.0>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh4 = union {
  cylinder { // Cylndr107
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr108
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere082
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere083
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel4 = union {
  cylinder { // Cylndr106
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere081
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh4 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <0.429508, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein4 = union {
  cylinder { // Cylndr105
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere080
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel4 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-2.229014, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh5 = union {
  cylinder { // Cylndr111
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr112
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere086
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere087
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel5 = union {
  cylinder { // Cylndr110
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere085
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh5 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-41.291786, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein5 = union {
  cylinder { // Cylndr109
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere084
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel5 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <26.502007, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperC = union {
  object { Oberkoeper2 }
  object { Bein4 }
  object { Bein5 }
  scale 0.2
  rotate -83.765724*z
  translate  <-14.505409, -3.344838, 13.607341>
}
#declare Unterarm2 = union {
  sphere { // Sphere056
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr087
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere057
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <11.332053, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm2 = union {
  cylinder { // Cylndr086
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere055
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm2 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-183.932617, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm3 = union {
  sphere { // Sphere059
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr089
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere060
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-11.800155, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm3 = union {
  cylinder { // Cylndr088
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere058
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm3 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-42.57547, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf1 = union {
  sphere { // Sphere061
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr090
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere062
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper1 = union {
  cylinder { // Cylndr085
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere054
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm2 }
  object { Oberarm3 }
  object { Kopf1 }
  translate  <0.0, 0.1, -1.1>
  rotate <-17.359118, 8.438898, -0.934104>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh2 = union {
  cylinder { // Cylndr093
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr094
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere065
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere066
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <68.052254, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel2 = union {
  cylinder { // Cylndr092
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere064
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh2 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-77.489845, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein2 = union {
  cylinder { // Cylndr091
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere063
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel2 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <46.488861, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh3 = union {
  cylinder { // Cylndr097
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr098
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere069
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere070
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel3 = union {
  cylinder { // Cylndr096
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere068
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh3 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-32.66293, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein3 = union {
  cylinder { // Cylndr095
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere067
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel3 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-24.897869, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperB = union {
  object { Oberkoeper1 }
  object { Bein2 }
  object { Bein3 }
  scale 0.2
  rotate -55.801628*z
  translate  <-31.767843, -16.989173, 13.524848>
}
#declare Unterarm = union {
  sphere { // Sphere039
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr073
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere040
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-15.42235, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm = union {
  cylinder { // Cylndr072
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere038
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-191.69194, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm1 = union {
  sphere { // Sphere042
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr075
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere043
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-36.483002, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm1 = union {
  cylinder { // Cylndr074
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere041
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm1 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-0.38599, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf = union {
  sphere { // Sphere044
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr076
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere045
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.5, 0.626881, 0.533513>
    rotate <27.032583, 0.0, -0.0>
    translate  <0.0, 1.474339, 5.272086>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-10.204259, -0.0, -0.0>
  translate  <0.0, -0.025349, 3.930553>
}
#declare Oberkoeper = union {
  cylinder { // Cylndr071
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere037
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm }
  object { Oberarm1 }
  object { Kopf }
  translate  <0.0, 0.1, -1.1>
  rotate <-4.748751, -0.0, -0.0>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh = union {
  cylinder { // Cylndr079
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr080
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere048
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere049
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel = union {
  cylinder { // Cylndr078
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere047
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <0.429508, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein = union {
  cylinder { // Cylndr077
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere046
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-2.229014, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh1 = union {
  cylinder { // Cylndr083
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr084
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere052
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere053
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel1 = union {
  cylinder { // Cylndr082
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere051
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh1 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-1.935709, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein1 = union {
  cylinder { // Cylndr081
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere050
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel1 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-1.708184, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare KoeperA = union {
  object { Oberkoeper }
  object { Bein }
  object { Bein1 }
  scale 0.2
  rotate -20.46339*z
  translate  <-29.068575, -6.205836, 13.607341>
}
union { // Personengruppe
  object { Personen8 }
  object { KoeperC12 }
  object { Personen7 }
  object { Personen6 }
  object { Personen5 }
  object { Personen4 }
  object { Personen3 }
  object { Personen2 }
  object { Personen1 }
  object { Personen }
  object { KoeperD5 }
  object { KoeperA6 }
  object { KoeperA5 }
  object { KoeperE4 }
  object { KoeperE1 }
  object { KoeperE2 }
  object { KoeperD3 }
  object { KoeperD2 }
  object { KoeperD1 }
  object { KoeperC4 }
  object { KoeperC2 }
  object { KoeperC1 }
  object { KoeperB3 }
  object { KoeperB2 }
  object { KoeperB1 }
  object { KoeperA3 }
  object { KoeperA1 }
  object { KoeperE }
  object { KoeperD }
  object { KoeperC }
  object { KoeperB }
  object { KoeperA }
}


union { // Transportergruppe
  object { Transporter }
  object { // Transporter4->Transporter
    Transporter
    rotate 119.556114*z
    translate  <-32.968673, 66.537778, 1.133316>
  }
  object { // Transporter3->Transporter
    Transporter
    rotate 65.434647*z
    translate  <-6.153836, 86.405962, 0.0>
  }
  object { // Transporter2->Transporter
    Transporter
    rotate 55.816479*z
    translate  <67.038999, 51.854663, 0.214933>
  }
  object { // Transporter1->Transporter
    Transporter
    rotate <0.0, 0.0, -38.178242>
    translate  <19.831988, -0.741411, 1.133316>
  }
}


#declare Schiene2 = union {
  box { // Cube114
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    translate  <2.290081, 58.560634, -0.5>
  }
  box { // Cube115
    <-1, -1, -1>, <1, 1, 1>
    material {
      Soft_Silver
    }
    scale <0.2, 60.0, 0.5>
    translate  5.0*x
  }
  box { // Cube116
    <-1, -1, -1>, <1, 1, 1>
    material {
      Soft_Silver
    }
    scale <0.2, 60.0, 0.5>
    translate  -0.5*x
  }
  box { // Cube117
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, -57.439366, -0.5>
  }
  box { // Cube118
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, 54.560634, -0.5>
  }
  box { // Cube119
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, 50.560634, -0.5>
  }
  box { // Cube120
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, 46.560634, -0.5>
  }
  box { // Cube121
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, 42.560634, -0.5>
  }
  box { // Cube122
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, 38.560634, -0.5>
  }
  box { // Cube123
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, 34.560634, -0.5>
  }
  box { // Cube124
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, 30.560634, -0.5>
  }
  box { // Cube125
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, 26.560634, -0.5>
  }
  box { // Cube126
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, 22.560634, -0.5>
  }
  box { // Cube127
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, 18.560634, -0.5>
  }
  box { // Cube128
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, 14.560634, -0.5>
  }
  box { // Cube129
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, 10.560634, -0.5>
  }
  box { // Cube130
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, 6.560634, -0.5>
  }
  box { // Cube131
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, 2.560634, -0.5>
  }
  box { // Cube132
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, -1.439366, -0.5>
  }
  box { // Cube133
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, -5.439366, -0.5>
  }
  box { // Cube134
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, -13.439366, -0.5>
  }
  box { // Cube135
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, -17.439366, -0.5>
  }
  box { // Cube136
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, -21.439366, -0.5>
  }
  box { // Cube137
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, -9.439366, -0.5>
  }
  box { // Cube138
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, -25.439366, -0.5>
  }
  box { // Cube139
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, -29.439366, -0.5>
  }
  box { // Cube140
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, -33.439366, -0.5>
  }
  box { // Cube141
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, -37.439366, -0.5>
  }
  box { // Cube142
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, -41.439366, -0.5>
  }
  box { // Cube143
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, -45.439366, -0.5>
  }
  box { // Cube144
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, -49.439366, -0.5>
  }
  box { // Cube145
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, -53.439366, -0.5>
  }
  scale <1.0, 1.0, 0.5>
  rotate <-0.0, 0.0, -29.265371>
  translate  <23.053504, -7.781494, -20.5>
}
#declare Schiene3 = union {
  box { // Cube146
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    translate  <2.290081, 58.560634, -0.5>
  }
  box { // Cube147
    <-1, -1, -1>, <1, 1, 1>
    material {
      Soft_Silver
    }
    scale <0.2, 60.0, 0.5>
    translate  5.0*x
  }
  box { // Cube148
    <-1, -1, -1>, <1, 1, 1>
    material {
      Soft_Silver
    }
    scale <0.2, 60.0, 0.5>
    translate  -0.5*x
  }
  box { // Cube149
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, -57.439366, -0.5>
  }
  box { // Cube150
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, 54.560634, -0.5>
  }
  box { // Cube151
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, 50.560634, -0.5>
  }
  box { // Cube152
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, 46.560634, -0.5>
  }
  box { // Cube153
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, 42.560634, -0.5>
  }
  box { // Cube154
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, 38.560634, -0.5>
  }
  box { // Cube155
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, 34.560634, -0.5>
  }
  box { // Cube156
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, 30.560634, -0.5>
  }
  box { // Cube157
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, 26.560634, -0.5>
  }
  box { // Cube158
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, 22.560634, -0.5>
  }
  box { // Cube159
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, 18.560634, -0.5>
  }
  box { // Cube160
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, 14.560634, -0.5>
  }
  box { // Cube161
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, 10.560634, -0.5>
  }
  box { // Cube162
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, 6.560634, -0.5>
  }
  box { // Cube163
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, 2.560634, -0.5>
  }
  box { // Cube164
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, -1.439366, -0.5>
  }
  box { // Cube165
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, -5.439366, -0.5>
  }
  box { // Cube166
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, -13.439366, -0.5>
  }
  box { // Cube167
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, -17.439366, -0.5>
  }
  box { // Cube168
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, -21.439366, -0.5>
  }
  box { // Cube169
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, -9.439366, -0.5>
  }
  box { // Cube170
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, -25.439366, -0.5>
  }
  box { // Cube171
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, -29.439366, -0.5>
  }
  box { // Cube172
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, -33.439366, -0.5>
  }
  box { // Cube173
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, -37.439366, -0.5>
  }
  box { // Cube174
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, -41.439366, -0.5>
  }
  box { // Cube175
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, -45.439366, -0.5>
  }
  box { // Cube176
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, -49.439366, -0.5>
  }
  box { // Cube177
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, -53.439366, -0.5>
  }
  scale <1.0, 1.0, 0.5>
  rotate <-0.0, 0.0, -29.265371>
  translate  <-26.895755, 17.833511, -20.5>
}
#declare Standscheibe1 = union {
  cylinder { // Cylndr031
    <0,0,1>, <0,0,0>, 1 
    material {
      Beton
    }
    scale <80.0, 80.0, 1.0>
    translate  -23.0*z
  }
  cylinder { // Cylndr032
    <0,0,1>, <0,0,0>, 1 
    material {
      Beton
    }
    scale <75.0, 75.0, 1.0>
    translate  -22.0*z
  }
  object { Schiene2 }
  object { Schiene3 }
}
#declare Group003 = union {
  cylinder { // Cylndr039
    <0,0,1>, <0,0,0>, 1 
    material {
      Streaky_Steel_Metal
    }
    scale <0.3, 0.3, 35.0>
    rotate <145.177109, 47.012909, -148.159332>
    translate  <-1.05035, 1.892023, 4.496006>
  }
  cylinder { // Cylndr040
    <0,0,1>, <0,0,0>, 1 
    material {
      Streaky_Steel_Metal
    }
    scale <0.3, 0.3, 30.0>
    rotate <146.315353, 23.946198, -148.712982>
    translate  <6.281249, 10.715072, 7.574448>
  }
  cylinder { // Cylndr041
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 12.0>
    rotate <155.290482, 0.713857, -123.581253>
    translate  <6.395879, 11.091242, 7.19027>
  }
  cylinder { // Cylndr042
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 3.0>
    rotate <107.895638, -63.944798, -53.02306>
    translate  <6.553148, 25.68971, -9.921665>
  }
  cylinder { // Cylndr043
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 7.0>
    rotate <155.051926, 7.707894, -126.823105>
    translate  <6.395879, 20.107884, -3.555345>
  }
  cylinder { // Cylndr044
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 7.0>
    rotate <74.437958, 64.285194, 129.570663>
    translate  <2.385519, 14.342339, -3.973201>
  }
  rotate <-23.43911, -37.207352, 61.653297>
  translate  <15.780398, 1.677306, 1.838158>
}
#declare Verstrebung3 = union {
  cylinder { // Cylndr033
    <0,0,1>, <0,0,0>, 1 
    material {
      Streaky_Steel_Metal
    }
    scale <0.3, 0.3, 35.0>
    rotate <145.177109, 47.012909, -148.159332>
    translate  <-1.05035, 1.892023, 4.496006>
  }
  cylinder { // Cylndr034
    <0,0,1>, <0,0,0>, 1 
    material {
      Streaky_Steel_Metal
    }
    scale <0.5, 0.5, 30.0>
    rotate <146.315353, 23.946198, -148.712982>
    translate  <6.281249, 10.715072, 7.574448>
  }
  cylinder { // Cylndr035
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 12.0>
    rotate <155.290482, 0.713857, -123.581253>
    translate  <6.395879, 11.091242, 7.19027>
  }
  cylinder { // Cylndr036
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 3.0>
    rotate <107.895638, -63.944798, -53.02306>
    translate  <6.553148, 25.68971, -9.921665>
  }
  cylinder { // Cylndr037
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 7.0>
    rotate <155.051926, 7.707894, -126.823105>
    translate  <6.395879, 20.107884, -3.555345>
  }
  cylinder { // Cylndr038
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 7.0>
    rotate <74.437958, 64.285194, 129.570663>
    translate  <2.385519, 14.342339, -3.973201>
  }
  object { Group003 }
  box { // Cube178
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <0.3, 0.3, 4.0>
    rotate <-70.905296, 13.802184, 34.745026>
    translate  <8.014764, 12.285538, 0.05041>
  }
  box { // Cube179
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <0.4, 0.4, 5.5>
    rotate <52.134972, -59.575367, -117.98645>
    translate  <8.581512, 6.315266, 5.270818>
  }
  box { // Cube180
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <0.4, 0.4, 5.5>
    rotate <-75.382599, 29.649307, -30.502134>
    translate  <2.626968, 6.59747, 5.743122>
  }
  box { // Cube181
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <0.3, 0.3, 4.0>
    rotate <-75.864029, 30.423695, -34.194572>
    translate  <3.64531, 12.751855, 0.625075>
  }
  material {
    Streaky_Steel_Metal
  }
  rotate <-7.358429, -4.152115, 5.953172>
  translate  <1.51664, -1.464665, 2.657736>
}
#declare GitterMoben5 = union {
  box { // Cube182
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 0.25, 0.25>
    rotate <-0.0, -48.40556, -0.0>
    translate  <4.730449, 0.0, 24.259266>
  }
  box { // Cube183
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 0.25, 0.25>
    rotate <-0.0, 48.40556, -0.0>
    translate  <7.310694, 0.0, 24.129633>
  }
  box { // Cube184
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <0.4, 0.4, 7.0>
    rotate 14.864727*y
    translate  <2.795265, 0.0, 26.276734>
  }
  box { // Cube185
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.25, 0.25>
    translate  <6.020571, 0.0, 32.385796>
  }
  box { // Cube186
    <-1, -1, -1>, <1, 1, 1>
    scale <5.5, 0.25, 0.25>
    translate  <6.020571, 0.0, 19.484572>
  }
  box { // Cube187
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <0.4, 0.4, 7.0>
    rotate -16.795506*y
    translate  <9.460898, 0.0, 26.147101>
  }
  material {
    Streaky_Steel_Metal
  }
  rotate -10.0*x
  translate  <-0.111932, -2.297352, -2.530724>
}
#declare GitterMunten5 = union {
  box { // Cube188
    <-1, -1, -1>, <1, 1, 1>
    scale <7.6, 0.25, 0.25>
    rotate 30.0*y
    translate  <6.235592, 0.0, -14.017469>
  }
  box { // Cube189
    <-1, -1, -1>, <1, 1, 1>
    scale <7.5, 0.25, 0.25>
    rotate 35.0*y
    translate  <6.450612, 0.0, -1.846693>
  }
  box { // Cube190
    <-1, -1, -1>, <1, 1, 1>
    scale <7.0, 0.25, 0.25>
    rotate 35.0*y
    translate  <6.235592, 0.0, 10.754123>
  }
  box { // Cube191
    <-1, -1, -1>, <1, 1, 1>
    scale <7.0, 0.25, 0.25>
    rotate -35.0*y
    translate  <6.020571, 0.0, 10.324082>
  }
  box { // Cube192
    <-1, -1, -1>, <1, 1, 1>
    scale <7.5, 0.25, 0.25>
    rotate -35.0*y
    translate  <6.020571, 0.0, -2.061714>
  }
  box { // Cube193
    <-1, -1, -1>, <1, 1, 1>
    scale <7.6, 0.25, 0.25>
    rotate -30.0*y
    translate  <6.020571, 0.0, -14.017469>
  }
  box { // Cube194
    <-1, -1, -1>, <1, 1, 1>
    scale <6.5, 0.25, 0.25>
    translate  <6.235592, 0.0, -8.12653>
  }
  box { // Cube195
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 0.25, 0.25>
    translate  <6.235592, 0.0, 4.085388>
  }
  box { // Cube196
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <0.7, 0.7, 18.0>
    rotate -2.40592*y
    translate  <12.256163, 0.0, -2.0>
  }
  box { // Cube197
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <0.7, 0.7, 18.0>
    rotate 2.596029*y
    translate  -2.0*z
  }
  material {
    Streaky_Steel_Metal
  }
  rotate -2.606666*x
  translate  <0.0, 0.645061, 0.21502>
}
#declare Grundgeruet1 = union {
  cylinder { // Cylndr045
    <0,0,1>, <0,0,0>, 1 
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 3.5, 0.5>
    translate  <6.34859, 4.617157, 16.160048>
  }
  object { // GitterMoben3->Gitter-oben
    GitterMoben
    rotate <-0.0, 0.0, -120.0>
    translate  <5.207997, 11.704854, 0.0>
  }
  object { // GitterMoben4->Gitter-oben
    GitterMoben
    rotate <-0.0, -0.0, 120.0>
    translate  <13.088618, 1.440425, 0.0>
  }
  object { // GitterMunten3->Gitter-unten
    GitterMunten
    rotate -120.0*z
    translate  <5.59053, 11.611102, 0.0>
  }
  object { // GitterMunten4->Gitter-unten
    GitterMunten
    rotate 120.0*z
    translate  <12.804333, 1.028498, 0.0>
  }
  object { GitterMoben5 }
  object { GitterMunten5 }
  cylinder { // Cylndr046
    <0,0,1>, <0,0,0>, 1 
    material {
      Streaky_Steel_Metal
    }
    scale <1.0, 1.0, 10.0>
    translate  <6.156209, 4.968241, 27.030268>
  }
  cylinder { // Cylndr047
    <0,0,1>, <0,0,0>, 1 
    material {
      Streaky_Steel_Metal
    }
    scale <3.0, 3.0, 0.625>
    translate  <5.989884, 5.053965, 31.587279>
  }
  cylinder { // Cylndr058
    <0,0,1>, <0,0,0>, 1 
    material {
      Streaky_Steel_Metal
    }
    scale <0.5, 0.5, 6.25>
    translate  <6.142743, 4.939909, 33.693097>
  }
  cylinder { // Cylndr059
    <0,0,1>, <0,0,0>, 1 
    material {
      Streaky_Steel_Metal
    }
    scale <2.0, 2.0, 0.625>
    translate  <5.989884, 5.053965, 34.629017>
  }
  scale <1.0, 1.0, 0.8>
}
#declare TransSweep003 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  4  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <-0.014085, 0.577465>,
  <-1.0, -1.0>
  rotate -x*90
  material {
    Streaky_Steel_Metal
  }
  scale <27.910595, 29.923252, 0.5>
  rotate <-0.0, -0.0, 0.00663>
  translate  <6.437351, 17.728222, -19.0>
}
#declare TransSweep004 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  4  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <-0.014085, 0.577465>,
  <-1.0, -1.0>
  rotate -x*90
  material {
    Streaky_Steel_Metal
  }
  scale <27.43615, 29.429661, 0.5>
  rotate -0.228788*z
  translate  <6.437351, 17.486165, -14.630005>
}
#declare Plattform1 = union {
  box { // Cube198
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <4.0, 0.5, 2.5>
    translate  <-14.039256, -10.65047, -16.701874>
  }
  box { // Cube199
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <4.0, 0.5, 2.5>
    rotate 29.397549*z
    translate  <21.694393, -2.753319, -17.035175>
  }
  box { // Cube200
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <4.0, 0.5, 2.5>
    rotate 29.397549*z
    translate  <17.210281, 5.107474, -17.0>
  }
  box { // Cube201
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <4.0, 0.5, 2.5>
    rotate 29.397549*z
    translate  <13.452337, 12.0, -17.0>
  }
  box { // Cube202
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <4.0, 0.5, 2.5>
    rotate 29.397549*z
    translate  <9.936449, 17.924302, -17.0>
  }
  box { // Cube203
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <4.0, 0.5, 2.5>
    rotate 90.467621*z
    translate  <19.261684, -6.638323, -17.0>
  }
  box { // Cube204
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <4.0, 0.5, 2.5>
    rotate 90.467621*z
    translate  <11.388786, -6.765425, -17.0>
  }
  box { // Cube205
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <4.0, 0.5, 2.5>
    rotate 90.467621*z
    translate  <2.305607, -6.892526, -17.0>
  }
  box { // Cube206
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <4.0, 0.5, 2.5>
    rotate 90.467621*z
    translate  <-6.051404, -6.777572, -17.0>
  }
  box { // Cube207
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <4.0, 0.5, 2.5>
    rotate 150.684311*z
    translate  <-0.726168, 12.586919, -17.0>
  }
  box { // Cube208
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <4.0, 0.5, 2.5>
    rotate 150.684311*z
    translate  <2.904674, 18.880379, -16.701874>
  }
  box { // Cube209
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <4.0, 0.5, 2.5>
    rotate 150.684311*z
    translate  <-5.325235, 4.357011, -16.701874>
  }
  box { // Cube210
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <4.0, 0.5, 2.5>
    rotate 150.684311*z
    translate  <-9.198133, -1.936449, -16.701874>
  }
  box { // Cube211
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <4.0, 0.5, 2.5>
    rotate -120.958321*z
    translate  <-15.975705, -7.261684, -16.701874>
  }
  box { // Cube212
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <4.0, 0.5, 2.5>
    rotate -120.958321*z
    translate  <4.357011, 27.110288, -16.701874>
  }
  box { // Cube213
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <4.0, 0.5, 2.5>
    rotate -59.701202*z
    translate  <8.471965, 27.110288, -16.701874>
  }
  box { // Cube214
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <4.0, 0.5, 2.5>
    rotate -55.687119*z
    translate  <28.562625, -7.019628, -17.0>
  }
  box { // Cube215
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <4.0, 0.5, 2.5>
    translate  <26.868232, -10.408414, -16.701874>
  }
  object { TransSweep003 }
  object { TransSweep004 }
}
#declare Fuss3 = union {
  sphere { // Sphere023
    <0,0,0>,1
    material {
      Streaky_Steel_Metal
    }
    scale <-4.872898, -1.484112, -2.616863>
    rotate 33.87645*z
    translate  <-19.122435, -13.071032, 0.0>
  }
  sphere { // Sphere024
    <0,0,0>,1
    material {
      Streaky_Steel_Metal
    }
    scale <-4.872898, -1.484112, -2.616863>
    rotate 32.099854*z
    translate  <-21.785053, -9.924302, 0.0>
  }
  translate  <1.452337, 0.968225, -20.0>
}
#declare Fuss4 = union {
  sphere { // Sphere025
    <0,0,0>,1
    material {
      Streaky_Steel_Metal
    }
    scale <-4.872898, -1.484112, -2.616863>
    rotate 33.87645*z
    translate  <-19.122435, -13.071032, 0.0>
  }
  sphere { // Sphere026
    <0,0,0>,1
    material {
      Streaky_Steel_Metal
    }
    scale <-4.872898, -1.484112, -2.616863>
    rotate 32.099854*z
    translate  <-21.785053, -9.924302, 0.0>
  }
  rotate 119.284828*z
  translate  <11.376639, 1.694393, -20.0>
}
#declare Fuss5 = union {
  sphere { // Sphere027
    <0,0,0>,1
    material {
      Streaky_Steel_Metal
    }
    scale <-4.872898, -1.484112, -2.616863>
    rotate 33.87645*z
    translate  <-19.122435, -13.071032, 0.0>
  }
  sphere { // Sphere028
    <0,0,0>,1
    material {
      Streaky_Steel_Metal
    }
    scale <-4.872898, -1.484112, -2.616863>
    rotate 32.099854*z
    translate  <-21.785053, -9.924302, 0.0>
  }
  rotate -123.399246*z
  translate  <4.599067, 8.229909, -20.0>
}
#declare Ankermast1 = union {
  cylinder { // Cylndr055
    <0,0,1>, <0,0,0>, 1 
    material {
      Streaky_Steel_Metal
    }
    scale <0.3, 0.3, 25.0>
    rotate -90.0*y
    translate  <18.637345, -3.638377, -8.251922>
  }
  cylinder { // Cylndr056
    <0,0,1>, <0,0,0>, 1 
    material {
      Streaky_Steel_Metal
    }
    scale <0.3, 0.3, 28.0>
    rotate <118.0, -90.0, -180.0>
    translate  <19.451008, -4.064428, -8.251922>
  }
  cylinder { // Cylndr057
    <0,0,1>, <0,0,0>, 1 
    material {
      Streaky_Steel_Metal
    }
    scale <0.3, 0.3, 27.0>
    rotate <62.0, -90.0, -180.0>
    translate  <-6.739349, -3.716725, -8.251922>
  }
  object { Verstrebung3 }
  object { Grundgeruet1 }
  cylinder { // Cylndr060
    <0,0,1>, <0,0,0>, 1 
    material {
      Streaky_Steel_Metal
    }
    scale <0.25, 0.25, 37.5>
    translate  <6.361213, 7.75294, -18.75989>
  }
  cylinder { // Cylndr061
    <0,0,1>, <0,0,0>, 1 
    material {
      Streaky_Steel_Metal
    }
    scale <0.25, 0.25, 37.5>
    translate  <4.529955, 5.247007, -18.75989>
  }
  cylinder { // Cylndr062
    <0,0,1>, <0,0,0>, 1 
    material {
      Streaky_Steel_Metal
    }
    scale <0.25, 0.25, 37.5>
    translate  <7.517798, 5.439772, -18.75989>
  }
  cylinder { // Cylndr063
    <0,0,1>, <0,0,0>, 1 
    material {
      Streaky_Steel_Metal
    }
    scale <0.25, 0.25, 37.5>
    translate  <6.168449, 2.933839, -18.75989>
  }
  cylinder { // Cylndr064
    <0,0,1>, <0,0,0>, 1 
    material {
      Streaky_Steel_Metal
    }
    scale <0.7, 0.7, 6.0>
    translate  <5.967502, 1.54, 20.790007>
  }
  cylinder { // Cylndr065
    <0,0,1>, <0,0,0>, 1 
    material {
      Streaky_Steel_Metal
    }
    scale <0.7, 0.7, 6.0>
    translate  <9.240003, 6.160002, 20.790007>
  }
  object { // Verstrebung4->Verstrebung
    Verstrebung
    rotate <-0.0, 0.0, 120.0>
    translate  <13.090004, 0.77, 0.0>
  }
  object { // Verstrebung5->Verstrebung
    Verstrebung
    rotate <-0.0, 0.0, -120.282425>
    translate  <5.775002, 11.165004, 0.0>
  }
  cone { // Cone002
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      Streaky_Steel_Metal
    }
    scale <1.5, 1.5, 2.25>
    rotate <180.0, 0.0, -0.0>
    translate  <6.110753, 4.902812, 33.0>
  }
  object { Plattform1 }
  object { Fuss3 }
  object { Fuss4 }
  object { Fuss5 }
  box { // Cube216
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <-4.632113, -4.336968, -2.616863>
    rotate -27.342386*z
    translate  <-1.936449, 6.414519, -13.434502>
  }
  scale <1.0, 1.0, 0.6>
  translate  <-5.724204, -5.724204, -5.669046>
}
union { // Basis2
  object { Standscheibe1 }
  object { Ankermast1 }
  scale 0.5
  translate  <71.866445, 212.985322, 23.450766>
}


#declare Schiene1 = union {
  box { // Cube072
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    translate  <2.290081, 58.560634, -0.5>
  }
  box { // Cube073
    <-1, -1, -1>, <1, 1, 1>
    material {
      Soft_Silver
    }
    scale <0.2, 60.0, 0.5>
    translate  5.0*x
  }
  box { // Cube074
    <-1, -1, -1>, <1, 1, 1>
    material {
      Soft_Silver
    }
    scale <0.2, 60.0, 0.5>
    translate  -0.5*x
  }
  box { // Cube075
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, -57.439366, -0.5>
  }
  box { // Cube076
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, 54.560634, -0.5>
  }
  box { // Cube077
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, 50.560634, -0.5>
  }
  box { // Cube078
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, 46.560634, -0.5>
  }
  box { // Cube079
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, 42.560634, -0.5>
  }
  box { // Cube080
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, 38.560634, -0.5>
  }
  box { // Cube081
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, 34.560634, -0.5>
  }
  box { // Cube082
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, 30.560634, -0.5>
  }
  box { // Cube083
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, 26.560634, -0.5>
  }
  box { // Cube084
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, 22.560634, -0.5>
  }
  box { // Cube085
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, 18.560634, -0.5>
  }
  box { // Cube086
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, 14.560634, -0.5>
  }
  box { // Cube087
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, 10.560634, -0.5>
  }
  box { // Cube088
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, 6.560634, -0.5>
  }
  box { // Cube089
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, 2.560634, -0.5>
  }
  box { // Cube090
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, -1.439366, -0.5>
  }
  box { // Cube091
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, -5.439366, -0.5>
  }
  box { // Cube092
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, -13.439366, -0.5>
  }
  box { // Cube093
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, -17.439366, -0.5>
  }
  box { // Cube094
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, -21.439366, -0.5>
  }
  box { // Cube095
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, -9.439366, -0.5>
  }
  box { // Cube096
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, -25.439366, -0.5>
  }
  box { // Cube097
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, -29.439366, -0.5>
  }
  box { // Cube098
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, -33.439366, -0.5>
  }
  box { // Cube099
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, -37.439366, -0.5>
  }
  box { // Cube100
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, -41.439366, -0.5>
  }
  box { // Cube101
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, -45.439366, -0.5>
  }
  box { // Cube102
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, -49.439366, -0.5>
  }
  box { // Cube103
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, -53.439366, -0.5>
  }
  scale <0.8, 1.0, 0.5>
  rotate <-0.0, 0.0, -29.265371>
  translate  <23.053504, -7.781494, -20.5>
}
#declare Schiene = union {
  box { // Cube042
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    translate  <2.290081, 58.560634, -0.5>
  }
  box { // Cube041
    <-1, -1, -1>, <1, 1, 1>
    material {
      Soft_Silver
    }
    scale <0.2, 60.0, 0.5>
    translate  5.0*x
  }
  box { // Cube040
    <-1, -1, -1>, <1, 1, 1>
    material {
      Soft_Silver
    }
    scale <0.2, 60.0, 0.5>
    translate  -0.5*x
  }
  box { // Cube071
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, -57.439366, -0.5>
  }
  box { // Cube043
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, 54.560634, -0.5>
  }
  box { // Cube044
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, 50.560634, -0.5>
  }
  box { // Cube045
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, 46.560634, -0.5>
  }
  box { // Cube046
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, 42.560634, -0.5>
  }
  box { // Cube047
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, 38.560634, -0.5>
  }
  box { // Cube048
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, 34.560634, -0.5>
  }
  box { // Cube049
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, 30.560634, -0.5>
  }
  box { // Cube050
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, 26.560634, -0.5>
  }
  box { // Cube051
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, 22.560634, -0.5>
  }
  box { // Cube052
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, 18.560634, -0.5>
  }
  box { // Cube053
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, 14.560634, -0.5>
  }
  box { // Cube054
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, 10.560634, -0.5>
  }
  box { // Cube055
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, 6.560634, -0.5>
  }
  box { // Cube056
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, 2.560634, -0.5>
  }
  box { // Cube057
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, -1.439366, -0.5>
  }
  box { // Cube058
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, -5.439366, -0.5>
  }
  box { // Cube060
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, -13.439366, -0.5>
  }
  box { // Cube061
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, -17.439366, -0.5>
  }
  box { // Cube062
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, -21.439366, -0.5>
  }
  box { // Cube059
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, -9.439366, -0.5>
  }
  box { // Cube063
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, -25.439366, -0.5>
  }
  box { // Cube064
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, -29.439366, -0.5>
  }
  box { // Cube065
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, -33.439366, -0.5>
  }
  box { // Cube066
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, -37.439366, -0.5>
  }
  box { // Cube067
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, -41.439366, -0.5>
  }
  box { // Cube068
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, -45.439366, -0.5>
  }
  box { // Cube069
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, -49.439366, -0.5>
  }
  box { // Cube070
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 0.5, 0.5>
    rotate 0.0*x
    translate  <2.290081, -53.439366, -0.5>
  }
  scale <0.8, 1.0, 0.2>
  rotate <-0.0, 0.0, -29.265371>
  translate  <-20.39134, 17.936462, -20.85>
}
#declare Standscheibe = union {
  cylinder { // Cylndr019
    <0,0,1>, <0,0,0>, 1 
    material {
      Beton
    }
    scale <80.0, 80.0, 1.0>
    translate  -23.0*z
  }
  cylinder { // Cylndr018
    <0,0,1>, <0,0,0>, 1 
    material {
      Beton
    }
    scale <75.0, 75.0, 1.0>
    translate  -22.0*z
  }
  object { Schiene1 }
  object { Schiene }
}
#declare Grundgeruet = union {
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    material {
      Streaky_Steel_Metal
    }
    scale <3.5, 3.5, 0.5>
    translate  <6.34859, 4.617157, 16.160048>
  }
  object { // GitterMoben2->Gitter-oben
    GitterMoben
    rotate <-0.0, 0.0, -120.0>
    translate  <5.207997, 11.704854, 0.0>
  }
  object { // GitterMoben1->Gitter-oben
    GitterMoben
    rotate <-0.0, -0.0, 120.0>
    translate  <13.088618, 1.440425, 0.0>
  }
  object { // GitterMunten2->Gitter-unten
    GitterMunten
    rotate -120.0*z
    translate  <5.59053, 11.611102, 0.0>
  }
  object { // GitterMunten1->Gitter-unten
    GitterMunten
    rotate 120.0*z
    translate  <12.804333, 1.028498, 0.0>
  }
  object { GitterMoben }
  object { GitterMunten }
  scale <1.0, 1.0, 0.8>
}
#declare TransSweep002 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  4  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <-0.014085, 0.577465>,
  <-1.0, -1.0>
  rotate -x*90
  material {
    Streaky_Steel_Metal
  }
  scale <27.910595, 29.923252, 0.5>
  rotate <-0.0, -0.0, 0.00663>
  translate  <6.437351, 17.728222, -19.0>
}
#declare TransSweep001 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  4  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <-0.014085, 0.577465>,
  <-1.0, -1.0>
  rotate -x*90
  material {
    Streaky_Steel_Metal
  }
  scale <27.43615, 29.429661, 0.5>
  rotate -0.228788*z
  translate  <6.437351, 17.486165, -14.630005>
}
#declare Plattform = union {
  box { // Cube021
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <4.0, 0.5, 2.5>
    translate  <-14.039256, -10.65047, -16.701874>
  }
  box { // Cube038
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <4.0, 0.5, 2.5>
    rotate 29.397549*z
    translate  <21.694393, -2.753319, -17.035175>
  }
  box { // Cube037
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <4.0, 0.5, 2.5>
    rotate 29.397549*z
    translate  <17.210281, 5.107474, -17.0>
  }
  box { // Cube036
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <4.0, 0.5, 2.5>
    rotate 29.397549*z
    translate  <13.452337, 12.0, -17.0>
  }
  box { // Cube035
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <4.0, 0.5, 2.5>
    rotate 29.397549*z
    translate  <9.936449, 17.924302, -17.0>
  }
  box { // Cube034
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <4.0, 0.5, 2.5>
    rotate 90.467621*z
    translate  <19.261684, -6.638323, -17.0>
  }
  box { // Cube033
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <4.0, 0.5, 2.5>
    rotate 90.467621*z
    translate  <11.388786, -6.765425, -17.0>
  }
  box { // Cube032
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <4.0, 0.5, 2.5>
    rotate 90.467621*z
    translate  <2.305607, -6.892526, -17.0>
  }
  box { // Cube031
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <4.0, 0.5, 2.5>
    rotate 90.467621*z
    translate  <-6.051404, -6.777572, -17.0>
  }
  box { // Cube030
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <4.0, 0.5, 2.5>
    rotate 150.684311*z
    translate  <-0.726168, 12.586919, -17.0>
  }
  box { // Cube029
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <4.0, 0.5, 2.5>
    rotate 150.684311*z
    translate  <2.904674, 18.880379, -16.701874>
  }
  box { // Cube028
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <4.0, 0.5, 2.5>
    rotate 150.684311*z
    translate  <-5.325235, 4.357011, -16.701874>
  }
  box { // Cube027
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <4.0, 0.5, 2.5>
    rotate 150.684311*z
    translate  <-9.198133, -1.936449, -16.701874>
  }
  box { // Cube026
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <4.0, 0.5, 2.5>
    rotate -120.958321*z
    translate  <-15.975705, -7.261684, -16.701874>
  }
  box { // Cube025
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <4.0, 0.5, 2.5>
    rotate -120.958321*z
    translate  <4.357011, 27.110288, -16.701874>
  }
  box { // Cube024
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <4.0, 0.5, 2.5>
    rotate -59.701202*z
    translate  <8.471965, 27.110288, -16.701874>
  }
  box { // Cube023
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <4.0, 0.5, 2.5>
    rotate -55.687119*z
    translate  <28.562625, -7.019628, -17.0>
  }
  box { // Cube022
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <4.0, 0.5, 2.5>
    translate  <26.868232, -10.408414, -16.701874>
  }
  object { TransSweep002 }
  object { TransSweep001 }
}
#declare Fuss = union {
  sphere { // Sphere002
    <0,0,0>,1
    material {
      Streaky_Steel_Metal
    }
    scale <-4.872898, -1.484112, -2.616863>
    rotate 33.87645*z
    translate  <-19.122435, -13.071032, 0.0>
  }
  sphere { // Sphere001
    <0,0,0>,1
    material {
      Streaky_Steel_Metal
    }
    scale <-4.872898, -1.484112, -2.616863>
    rotate 32.099854*z
    translate  <-21.785053, -9.924302, 0.0>
  }
  translate  <1.452337, 0.968225, -20.0>
}
#declare Fuss1 = union {
  sphere { // Sphere003
    <0,0,0>,1
    material {
      Streaky_Steel_Metal
    }
    scale <-4.872898, -1.484112, -2.616863>
    rotate 33.87645*z
    translate  <-19.122435, -13.071032, 0.0>
  }
  sphere { // Sphere004
    <0,0,0>,1
    material {
      Streaky_Steel_Metal
    }
    scale <-4.872898, -1.484112, -2.616863>
    rotate 32.099854*z
    translate  <-21.785053, -9.924302, 0.0>
  }
  rotate 119.284828*z
  translate  <11.376639, 1.694393, -20.0>
}
#declare Fuss2 = union {
  sphere { // Sphere005
    <0,0,0>,1
    material {
      Streaky_Steel_Metal
    }
    scale <-4.872898, -1.484112, -2.616863>
    rotate 33.87645*z
    translate  <-19.122435, -13.071032, 0.0>
  }
  sphere { // Sphere006
    <0,0,0>,1
    material {
      Streaky_Steel_Metal
    }
    scale <-4.872898, -1.484112, -2.616863>
    rotate 32.099854*z
    translate  <-21.785053, -9.924302, 0.0>
  }
  rotate -123.399246*z
  translate  <4.599067, 8.229909, -20.0>
}
#declare Spitze = union {
  cylinder { // Cylndr024
    <0,0,1>, <0,0,0>, 1 
    material {
      Streaky_Steel_Metal
    }
    scale <0.7, 0.7, 6.0>
    translate  <7.789339, 5.204364, 20.790007>
  }
  cylinder { // Cylndr023
    <0,0,1>, <0,0,0>, 1 
    material {
      Streaky_Steel_Metal
    }
    scale <0.7, 0.7, 6.0>
    translate  <5.417857, 3.547466, 20.790007>
  }
  cone { // Cone001
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      Streaky_Steel_Metal
    }
    scale <1.5, 1.5, 2.25>
    rotate <180.0, 0.0, -0.0>
    translate  <6.032024, 5.117104, 33.0>
  }
  cylinder { // Cylndr022
    <0,0,1>, <0,0,0>, 1 
    material {
      Streaky_Steel_Metal
    }
    scale <0.7, 0.7, 6.0>
    translate  <5.075339, 6.598042, 20.790007>
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    material {
      Streaky_Steel_Metal
    }
    scale <1.0, 1.0, 8.0>
    translate  <6.045513, 5.078937, 21.624215>
  }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    material {
      Streaky_Steel_Metal
    }
    scale <3.0, 3.0, 0.5>
    translate  <6.10058, 5.16466, 25.269823>
  }
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    material {
      Streaky_Steel_Metal
    }
    scale <0.5, 0.5, 5.0>
    translate  <6.032047, 5.050604, 26.954478>
  }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    material {
      Streaky_Steel_Metal
    }
    scale <2.0, 2.0, 0.5>
    translate  <5.989884, 5.053965, 27.703214>
  }
  scale 0.8
  rotate <-0.0, -0.0, -33.107094>
  translate  <-0.078431, 3.622457, 6.337383>
}
#declare Ankermast = union {
  cylinder { // Cylndr048
    <0,0,1>, <0,0,0>, 1 
    material {
      Streaky_Steel_Metal
    }
    scale <0.3, 0.3, 25.0>
    rotate -90.0*y
    translate  <18.637345, -3.638377, -8.251922>
  }
  cylinder { // Cylndr049
    <0,0,1>, <0,0,0>, 1 
    material {
      Streaky_Steel_Metal
    }
    scale <0.3, 0.3, 28.0>
    rotate <118.0, -90.0, -180.0>
    translate  <19.451008, -4.064428, -8.251922>
  }
  cylinder { // Cylndr050
    <0,0,1>, <0,0,0>, 1 
    material {
      Streaky_Steel_Metal
    }
    scale <0.3, 0.3, 27.0>
    rotate <62.0, -90.0, -180.0>
    translate  <-6.739349, -3.716725, -8.251922>
  }
  object { Verstrebung }
  object { Grundgeruet }
  cylinder { // Cylndr051
    <0,0,1>, <0,0,0>, 1 
    material {
      Streaky_Steel_Metal
    }
    scale <0.25, 0.25, 37.5>
    translate  <6.361213, 7.75294, -18.75989>
  }
  cylinder { // Cylndr054
    <0,0,1>, <0,0,0>, 1 
    material {
      Streaky_Steel_Metal
    }
    scale <0.25, 0.25, 37.5>
    translate  <4.529955, 5.247007, -18.75989>
  }
  cylinder { // Cylndr053
    <0,0,1>, <0,0,0>, 1 
    material {
      Streaky_Steel_Metal
    }
    scale <0.25, 0.25, 37.5>
    translate  <7.517798, 5.439772, -18.75989>
  }
  cylinder { // Cylndr052
    <0,0,1>, <0,0,0>, 1 
    material {
      Streaky_Steel_Metal
    }
    scale <0.25, 0.25, 37.5>
    translate  <6.168449, 2.933839, -18.75989>
  }
  object { // Verstrebung2->Verstrebung
    Verstrebung
    rotate <-0.0, 0.0, 120.0>
    translate  <13.090004, 0.77, 0.0>
  }
  object { // Verstrebung1->Verstrebung
    Verstrebung
    rotate <-0.0, 0.0, -120.282425>
    translate  <5.775002, 11.165004, 0.0>
  }
  object { Plattform }
  object { Fuss }
  object { Fuss1 }
  object { Fuss2 }
  box { // Cube039
    <-1, -1, -1>, <1, 1, 1>
    material {
      Streaky_Steel_Metal
    }
    scale <-4.632113, -4.336968, -2.616863>
    rotate -27.342386*z
    translate  <-1.936449, 6.414519, -13.434502>
  }
  object { Spitze }
  scale 0.8
  translate  <-5.724204, -6.125828, -4.166286>
}
#declare CSG001 = difference {
  box { // Cube104
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wellblech
    }
    scale <2.5, 5.0, 4.0>
    translate  4.029878*z
  }
  box { // Cube105
    <-1, -1, -1>, <1, 1, 1>
    material {
      black_dull
    }
    scale <3.769413, 6.580826, 2.536421>
    rotate 16.047951*y
    translate  <0.307284, 0.0, 9.52581>
  }
}
#declare CSG003 = difference {
  box { // Cube107
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wellblech
    }
  }
  box { // Cube108
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wellblech
    }
    scale <2.0, 0.8, 0.8>
  }
}
#declare Fenster1 = union {
  object { CSG003 }
  box { // Cube109
    <-1, -1, -1>, <1, 1, 1>
    material {
      black_shiny
    }
    scale 0.9
    translate  0.01*x
  }
  scale <1.0, 1.2, 1.0>
  translate  <1.700021, -1.4, 4.2>
}
#declare CSG002 = difference {
  box { // Cube110
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wellblech
    }
  }
  box { // Cube111
    <-1, -1, -1>, <1, 1, 1>
    material {
      Wellblech
    }
    scale <2.0, 0.8, 0.8>
  }
}
#declare Fenster = union {
  object { CSG002 }
  box { // Cube112
    <-1, -1, -1>, <1, 1, 1>
    material {
      black_shiny
    }
    scale 0.9
    translate  0.01*x
  }
  scale <1.0, 1.2, 1.0>
  translate  <1.700021, 1.4, 4.2>
}
#declare Huette = union {
  object { CSG001 }
  box { // Cube106
    <-1, -1, -1>, <1, 1, 1>
    material {
      black_shiny
    }
    scale <3.07417, 5.5, 0.1>
    rotate <-180.0, -15.829873, -180.0>
    translate  6.913894*z
  }
  object { Fenster1 }
  object { Fenster }
  rotate -120.788391*z
  translate  <-22.912294, -38.348134, -21.980589>
}
#declare Gasflasche7 = union {
  sphere { // Sphere015
    <0,0,0>,1
    material {
      Aluminum
    }
  }
  torus { // Torus022
    2.025, 0.125  rotate -x*90
    sturm
    material {
      Aluminum
    }
    scale <0.5, 0.5, 1.0>
    translate  1.5*z
  }
  torus { // Torus023
    2.025, 0.125  rotate -x*90
    sturm
    material {
      Aluminum
    }
    scale <0.5, 0.5, 1.0>
    translate  3.0*z
  }
  torus { // Torus024
    2.025, 0.125  rotate -x*90
    sturm
    material {
      Aluminum
    }
    scale <0.5, 0.5, 1.0>
  }
  cylinder { // Cylndr020
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum
    }
    scale <1.0, 1.0, 3.0>
  }
  sphere { // Sphere016
    <0,0,0>,1
    material {
      Aluminum
    }
    translate  3.0*z
  }
  rotate -90.0*y
  translate  5.0*x
}
#declare Gasflasche6 = union {
  sphere { // Sphere013
    <0,0,0>,1
    material {
      Aluminum
    }
  }
  torus { // Torus019
    2.025, 0.125  rotate -x*90
    sturm
    material {
      Aluminum
    }
    scale <0.5, 0.5, 1.0>
    translate  1.5*z
  }
  torus { // Torus020
    2.025, 0.125  rotate -x*90
    sturm
    material {
      Aluminum
    }
    scale <0.5, 0.5, 1.0>
    translate  3.0*z
  }
  torus { // Torus021
    2.025, 0.125  rotate -x*90
    sturm
    material {
      Aluminum
    }
    scale <0.5, 0.5, 1.0>
  }
  cylinder { // Cylndr021
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum
    }
    scale <1.0, 1.0, 3.0>
  }
  sphere { // Sphere014
    <0,0,0>,1
    material {
      Aluminum
    }
    translate  3.0*z
  }
  rotate -90.0*y
  translate  <5.0, 2.0, 0.0>
}
#declare Gasflasche5 = union {
  sphere { // Sphere011
    <0,0,0>,1
    material {
      Aluminum
    }
  }
  torus { // Torus016
    2.025, 0.125  rotate -x*90
    sturm
    material {
      Aluminum
    }
    scale <0.5, 0.5, 1.0>
    translate  1.5*z
  }
  torus { // Torus017
    2.025, 0.125  rotate -x*90
    sturm
    material {
      Aluminum
    }
    scale <0.5, 0.5, 1.0>
    translate  3.0*z
  }
  torus { // Torus018
    2.025, 0.125  rotate -x*90
    sturm
    material {
      Aluminum
    }
    scale <0.5, 0.5, 1.0>
  }
  cylinder { // Cylndr025
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum
    }
    scale <1.0, 1.0, 3.0>
  }
  sphere { // Sphere012
    <0,0,0>,1
    material {
      Aluminum
    }
    translate  3.0*z
  }
  rotate -90.0*y
  translate  <5.0, 4.0, 0.0>
}
#declare Gasflasche4 = union {
  sphere { // Sphere009
    <0,0,0>,1
    material {
      Aluminum
    }
  }
  torus { // Torus013
    2.025, 0.125  rotate -x*90
    sturm
    material {
      Aluminum
    }
    scale <0.5, 0.5, 1.0>
    translate  1.5*z
  }
  torus { // Torus014
    2.025, 0.125  rotate -x*90
    sturm
    material {
      Aluminum
    }
    scale <0.5, 0.5, 1.0>
    translate  3.0*z
  }
  torus { // Torus015
    2.025, 0.125  rotate -x*90
    sturm
    material {
      Aluminum
    }
    scale <0.5, 0.5, 1.0>
  }
  cylinder { // Cylndr026
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum
    }
    scale <1.0, 1.0, 3.0>
  }
  sphere { // Sphere010
    <0,0,0>,1
    material {
      Aluminum
    }
    translate  3.0*z
  }
  rotate -90.0*y
  translate  <5.0, 6.0, 0.0>
}
#declare Gasflasche3 = union {
  sphere { // Sphere007
    <0,0,0>,1
    material {
      Aluminum
    }
  }
  torus { // Torus010
    2.025, 0.125  rotate -x*90
    sturm
    material {
      Aluminum
    }
    scale <0.5, 0.5, 1.0>
    translate  1.5*z
  }
  torus { // Torus011
    2.025, 0.125  rotate -x*90
    sturm
    material {
      Aluminum
    }
    scale <0.5, 0.5, 1.0>
    translate  3.0*z
  }
  torus { // Torus012
    2.025, 0.125  rotate -x*90
    sturm
    material {
      Aluminum
    }
    scale <0.5, 0.5, 1.0>
  }
  cylinder { // Cylndr027
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum
    }
    scale <1.0, 1.0, 3.0>
  }
  sphere { // Sphere008
    <0,0,0>,1
    material {
      Aluminum
    }
    translate  3.0*z
  }
  rotate -90.0*y
  translate  6.0*y
}
#declare Gasflasche2 = union {
  sphere { // Sphere017
    <0,0,0>,1
    material {
      Aluminum
    }
  }
  torus { // Torus007
    2.025, 0.125  rotate -x*90
    sturm
    material {
      Aluminum
    }
    scale <0.5, 0.5, 1.0>
    translate  1.5*z
  }
  torus { // Torus008
    2.025, 0.125  rotate -x*90
    sturm
    material {
      Aluminum
    }
    scale <0.5, 0.5, 1.0>
    translate  3.0*z
  }
  torus { // Torus009
    2.025, 0.125  rotate -x*90
    sturm
    material {
      Aluminum
    }
    scale <0.5, 0.5, 1.0>
  }
  cylinder { // Cylndr028
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum
    }
    scale <1.0, 1.0, 3.0>
  }
  sphere { // Sphere018
    <0,0,0>,1
    material {
      Aluminum
    }
    translate  3.0*z
  }
  rotate -90.0*y
  translate  4.0*y
}
#declare Gasflasche1 = union {
  sphere { // Sphere019
    <0,0,0>,1
    material {
      Aluminum
    }
  }
  torus { // Torus004
    2.025, 0.125  rotate -x*90
    sturm
    material {
      Aluminum
    }
    scale <0.5, 0.5, 1.0>
    translate  1.5*z
  }
  torus { // Torus005
    2.025, 0.125  rotate -x*90
    sturm
    material {
      Aluminum
    }
    scale <0.5, 0.5, 1.0>
    translate  3.0*z
  }
  torus { // Torus006
    2.025, 0.125  rotate -x*90
    sturm
    material {
      Aluminum
    }
    scale <0.5, 0.5, 1.0>
  }
  cylinder { // Cylndr029
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum
    }
    scale <1.0, 1.0, 3.0>
  }
  sphere { // Sphere020
    <0,0,0>,1
    material {
      Aluminum
    }
    translate  3.0*z
  }
  rotate -90.0*y
  translate  2.0*y
}
#declare Gasflasche = union {
  sphere { // Sphere021
    <0,0,0>,1
    material {
      Aluminum
    }
  }
  torus { // Torus003
    2.025, 0.125  rotate -x*90
    sturm
    material {
      Aluminum
    }
    scale <0.5, 0.5, 1.0>
    translate  1.5*z
  }
  torus { // Torus002
    2.025, 0.125  rotate -x*90
    sturm
    material {
      Aluminum
    }
    scale <0.5, 0.5, 1.0>
    translate  3.0*z
  }
  torus { // Torus001
    2.025, 0.125  rotate -x*90
    sturm
    material {
      Aluminum
    }
    scale <0.5, 0.5, 1.0>
  }
  cylinder { // Cylndr030
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum
    }
    scale <1.0, 1.0, 3.0>
  }
  sphere { // Sphere022
    <0,0,0>,1
    material {
      Aluminum
    }
    translate  3.0*z
  }
  rotate -90.0*y
}
#declare Gastank = union {
  box { // Cube113
    <-1, -1, -1>, <1, 1, 1>
    material {
      black_dull
    }
    scale <4.857336, 4.062053, 0.5>
    translate  <0.82071, 3.036626, -1.477277>
  }
  object { Gasflasche7 }
  object { Gasflasche6 }
  object { Gasflasche5 }
  object { Gasflasche4 }
  object { Gasflasche3 }
  object { Gasflasche2 }
  object { Gasflasche1 }
  object { Gasflasche }
  scale 1.4
  rotate 30.264984*z
  translate  <-45.595622, -10.374605, -18.910689>
}
union { // Basis1
  plane { // Boden
    z,0
    material {
      DryGrass
    }
    hollow
    scale 5.0
    translate  <0.0, 1.70266, -22.756535>
  }
  object { Standscheibe }
  object { Ankermast }
  object { Huette }
  object { Gastank }
  scale 0.5
  translate  <0.0, -1.234251, 23.450766>
}


sphere { // Sky
  <0,0,0>,1
  material {
    Dark_Cloud
  }
  hollow
  scale 10000.0
  rotate 60.0*z
}




#declare Radhalterung = union {
  cylinder { // Cylndr066
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.0, 8.0>
    rotate <-45.0, -90.0, 0.0>
  }
  sphere { // Sphere1263
    <0,0,0>,1
    scale <1.0, 1.0, 1.5>
  }
  cylinder { // Cylndr1037
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum_1
    }
    scale <1.0, 1.5, 4.0>
    rotate -90.0*x
  }
  cylinder { // Cylndr1038
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum_1
    }
    scale <3.5, 1.5, 1.0>
    rotate -90.0*x
    translate  <-2.0, 3.0, 0.0>
  }
  material {
    Aluminum_1
  }
  scale <1.0, 0.8, 1.0>
  translate  0.3*x
}
#declare Rad4 = union {
  sphere { // Sphere1264
    <0,0,0>,1
    material {
      Aluminum_1
    }
    scale <1.3, 1.3, 0.5>
  }
  torus { // Torus029
    1.5, 0.5  rotate -x*90
    material {
      Black
    }
  }
  translate  <0.5, -0.2, 0.0>
}
#declare Bugrad = union {
  object { Radhalterung }
  object { Rad4 }
  scale <0.0375, 0.15, 0.15>
  rotate <90.0, 0.0, 90.0>
  translate  <0.0, 0.2125, -1.25>
}
#declare Gondel = union {
  sphere { // Sphere1262
    <0,0,0>,1
    material {
      Aluminum_1
    }
    scale <0.9, 0.9, 0.1>
    translate  -0.7*z
  }
  cone { // Cone004
    <0,0,0>, 0.9, <0,0,1>, 1.0
    material {
      Aluminum_1
    }
    scale <1.0, 1.0, 0.7>
    translate  -0.7*z
  }
  cone { // Cone005
    <0,0,0>, 1.0, <0,0,1>, 1.1
    material {
      Fenster_Gondel
    }
  }
  object { Bugrad }
  scale <2.0, 8.0, 2.0>
  translate  <-0.0, -71.2, -20.9>
}
#declare Fensterleiste = union {
  box { // Cube226
    <-1, -1, -1>, <1, 1, 1>
    material {
      Fenster_flach
    }
    scale <1.0, 10.0, 1.0>
    rotate -90.0*x
    translate  <0.0, 1.0, 10.0>
  }
  sphere { // Sphere1265
    <0,0,0>,1
    material {
      Aluminum_1
    }
    translate  20.0*z
  }
  sphere { // Sphere1266
    <0,0,0>,1
    material {
      Aluminum_1
    }
  }
  cylinder { // Cylndr1039
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum_1
    }
    scale <1.0, 1.0, 20.0>
  }
  scale <0.5, 1.0, 1.0>
  rotate <90.0, 35.84082, -1.0>
  translate  <14.4, -34.6, -15.1>
}
#declare Fensterleiste1 = union {
  box { // Cube227
    <-1, -1, -1>, <1, 1, 1>
    material {
      Fenster_flach
    }
    scale <1.0, 10.0, 1.0>
    rotate -90.0*x
    translate  <0.0, 1.0, 10.0>
  }
  sphere { // Sphere1267
    <0,0,0>,1
    material {
      Aluminum_1
    }
    translate  20.0*z
  }
  sphere { // Sphere1268
    <0,0,0>,1
    material {
      Aluminum_1
    }
  }
  cylinder { // Cylndr1040
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum_1
    }
    scale <1.0, 1.0, 20.0>
  }
  scale <0.5, 1.0, 1.0>
  rotate <90.0, -35.84082, 1.0>
  translate  <-14.45, -34.6, -15.1>
}
#declare Propeller = union {
  cylinder { // Cylndr1041
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum_1
    }
    scale <0.2, 1.7, 0.1>
    rotate <-0.0, -72.427841, 90.0>
    translate  <-1.725561, -3.019733, -0.485314>
  }
  cylinder { // Cylndr1042
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum_1
    }
    scale <0.2, 1.7, 0.1>
    rotate <-90.0, 0.0, -18.551716>
    translate  <0.0, -3.12758, 1.213285>
  }
  cylinder { // Cylndr1043
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum_1
    }
    scale <0.2, 1.7, 0.1>
    rotate <-0.0, -72.223213, -90.0>
    translate  <1.725561, -3.12758, -0.485314>
  }
  cylinder { // Cylndr1044
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum_1
    }
    scale <0.2, 1.7, 0.1>
    rotate <-90.0, -0.0, 17.268534>
    translate  <0.0, -3.12758, -2.156952>
  }
  sphere { // Sphere1269
    <0,0,0>,1
    material {
      Black
    }
    scale <0.2, 1.0, 0.2>
    translate  <0.0, -2.830999, -0.458352>
  }
  rotate 33.030155*y
  translate  <0.242657, -0.273658, -0.0892>
}
#declare CSG004 = difference {
  superellipsoid { // SuperQ006
    <0.5, 1.0>
    material {
      Aluminum_1
    }
    scale <1.250157, 2.8, 1.443888>
  }
  cylinder { // Cylndr1045
    <0,0,1>, <0,0,0>, 1 
    material {
      Black
    }
    scale <2.0, 2.0, 4.0>
    rotate -90.0*y
    translate  <1.833409, -2.8548, 1.743099>
  }
  box { // Cube228
    <-1, -1, -1>, <1, 1, 1>
    material {
      Black
    }
    scale <0.649495, 1.296581, 0.191143>
    translate  <0.0, 1.887333, 0.286247>
  }
  box { // Cube229
    <-1, -1, -1>, <1, 1, 1>
    material {
      Black
    }
    scale <0.649495, 1.296581, 0.191143>
    translate  <0.0, 1.868685, -0.186714>
  }
}
#declare Gondelhalterung = union {
  cylinder { // Cylndr1046
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum_1
    }
    scale <0.1, 0.1, 5.0>
    rotate <40.627251, -54.975811, 1.093951>
    translate  <-0.701009, -0.916705, 0.674047>
  }
  cylinder { // Cylndr1047
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum_1
    }
    scale <0.1, 0.1, 5.0>
    rotate <-38.092602, -54.895451, -1.231788>
    translate  <-0.701009, -3.154542, 0.701009>
  }
  cylinder { // Cylndr1048
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum_1
    }
    scale <0.1, 0.1, 5.0>
    rotate <15.91715, -54.941654, 0.492449>
    translate  <-0.701009, -3.154542, 0.701009>
  }
  cylinder { // Cylndr1049
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum_1
    }
    scale <0.159937, 0.1, 10.293396>
    rotate <0.0, -90.0, 0.0>
    translate  <-0.754933, -3.154542, -0.512276>
  }
  cylinder { // Cylndr1050
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum_1
    }
    scale <0.1, 0.1, 5.0>
    rotate <-13.370225, -54.930058, -0.415227>
    translate  <-0.701009, -0.916705, 0.674047>
  }
  cylinder { // Cylndr1051
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum_1
    }
    scale <-0.139748, 0.1, 10.113585>
    rotate <0.0, -90.0, 0.0>
    translate  <-0.701009, -0.916705, -0.512276>
  }
  translate  <0.0, 2.507457, -0.053924>
}
#declare Motorgondel = union {
  object { Propeller }
  cone { // Cone006
    <0,0,0>, 0.2, <0,0,1>, 1.0
    material {
      Aluminum_1
    }
    scale <0.8, 0.8, 1.989062>
    rotate -89.153397*x
    translate  <0.0, -3.048714, -0.485314>
  }
  object { CSG004 }
  object { Gondelhalterung }
  rotate <-0.0, -0.0, 180.0>
  translate  <-19.525354, -11.780093, -15.848759>
}
#declare Propeller3 = union {
  cylinder { // Cylndr1052
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum_1
    }
    scale <0.2, 1.7, 0.1>
    rotate <-0.0, -72.427841, 90.0>
    translate  <-1.725561, -3.019733, -0.485314>
  }
  cylinder { // Cylndr1053
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum_1
    }
    scale <0.2, 1.7, 0.1>
    rotate <-90.0, 0.0, -18.551716>
    translate  <0.0, -3.12758, 1.213285>
  }
  cylinder { // Cylndr1054
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum_1
    }
    scale <0.2, 1.7, 0.1>
    rotate <-0.0, -72.223213, -90.0>
    translate  <1.725561, -3.12758, -0.485314>
  }
  cylinder { // Cylndr1055
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum_1
    }
    scale <0.2, 1.7, 0.1>
    rotate <-90.0, -0.0, 17.268534>
    translate  <0.0, -3.12758, -2.156952>
  }
  sphere { // Sphere1270
    <0,0,0>,1
    material {
      Black
    }
    scale <0.2, 1.0, 0.2>
    translate  <0.0, -2.830999, -0.458352>
  }
  rotate 33.030155*y
  translate  <0.242657, -0.273658, -0.0892>
}
#declare CSG005 = difference {
  superellipsoid { // SuperQ007
    <0.5, 1.0>
    material {
      Aluminum_1
    }
    scale <1.250157, 2.8, 1.443888>
  }
  cylinder { // Cylndr1056
    <0,0,1>, <0,0,0>, 1 
    material {
      Black
    }
    scale <2.0, 2.0, 4.0>
    rotate -90.0*y
    translate  <1.833409, -2.8548, 1.743099>
  }
  box { // Cube230
    <-1, -1, -1>, <1, 1, 1>
    material {
      Black
    }
    scale <0.649495, 1.296581, 0.191143>
    translate  <0.0, 1.887333, 0.286247>
  }
  box { // Cube231
    <-1, -1, -1>, <1, 1, 1>
    material {
      Black
    }
    scale <0.649495, 1.296581, 0.191143>
    translate  <0.0, 1.868685, -0.186714>
  }
}
#declare Gondelhalterung3 = union {
  cylinder { // Cylndr1057
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum_1
    }
    scale <0.1, 0.1, 5.0>
    rotate <40.627251, -54.975811, 1.093951>
    translate  <-0.701009, -0.916705, 0.674047>
  }
  cylinder { // Cylndr1058
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum_1
    }
    scale <0.1, 0.1, 5.0>
    rotate <-38.092602, -54.895451, -1.231788>
    translate  <-0.701009, -3.154542, 0.701009>
  }
  cylinder { // Cylndr1059
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum_1
    }
    scale <0.1, 0.1, 5.0>
    rotate <15.91715, -54.941654, 0.492449>
    translate  <-0.701009, -3.154542, 0.701009>
  }
  cylinder { // Cylndr1060
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum_1
    }
    scale <0.159937, 0.1, 10.293396>
    rotate <0.0, -90.0, 0.0>
    translate  <-0.754933, -3.154542, -0.512276>
  }
  cylinder { // Cylndr1061
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum_1
    }
    scale <0.1, 0.1, 5.0>
    rotate <-13.370225, -54.930058, -0.415227>
    translate  <-0.701009, -0.916705, 0.674047>
  }
  cylinder { // Cylndr1062
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum_1
    }
    scale <-0.139748, 0.1, 10.113585>
    rotate <0.0, -90.0, 0.0>
    translate  <-0.701009, -0.916705, -0.512276>
  }
  rotate -180.0*z
  translate  <-0.0, -1.583971, -0.053924>
}
#declare Motorgondel3 = union {
  object { Propeller3 }
  cone { // Cone007
    <0,0,0>, 0.2, <0,0,1>, 1.0
    material {
      Aluminum_1
    }
    scale <0.8, 0.8, 1.989062>
    rotate -89.153397*x
    translate  <0.0, -3.048714, -0.485314>
  }
  object { CSG005 }
  object { Gondelhalterung3 }
  rotate <-0.0, -0.0, -180.0>
  translate  <19.52535, -11.780093, -15.848759>
}
//
// Include file contains 'Huele1'
//
#include "lake.in1"
#declare Huele1 = object {
  Huele1_Raw
  material {
    Aluminum_1
  }
  rotate -90.0*x
}
#declare segment1 = union {
  cone { // Haltepunkt
    <0,0,0>, 0.2, <0,0,1>, 1.0
    material {
      Aluminum_1
    }
    scale <2.0, 1.5, 3.0>
    rotate -90.0*x
    translate  -121.848692*y
  }
  object { Gondel }
  object { Fensterleiste }
  object { Fensterleiste1 }
  object { Motorgondel }
  object { Motorgondel3 }
  object { Huele1 }
  hollow
}
//
// Include file contains 'Huele2'
//
#include "lake.in2"
#declare Huele2 = object {
  Huele2_Raw
  material {
    Aluminium_zerlegt_1
  }
  rotate -90.0*x
}
#declare segment2 = union {
  object { Huele2 }
  rotate 0.0*x
  translate  <0.0, -3.866693, -0.0>
  hollow
  rotate -5.192295*x
}
//
// Include file contains 'Huele3'
//
#include "lake.in3"
#declare Huele3 = object {
  Huele3_Raw
  material {
    Aluminium_zerlegt_2
  }
  rotate -90.0*x
}
#declare Propeller2 = union {
  cylinder { // Cylndr1063
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum_1
    }
    scale <0.2, 1.7, 0.1>
    rotate <-0.0, -72.427841, 90.0>
    translate  <-1.725561, -3.019733, -0.485314>
  }
  cylinder { // Cylndr1064
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum_1
    }
    scale <0.2, 1.7, 0.1>
    rotate <-90.0, 0.0, -18.551716>
    translate  <0.0, -3.12758, 1.213285>
  }
  cylinder { // Cylndr1065
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum_1
    }
    scale <0.2, 1.7, 0.1>
    rotate <-0.0, -72.223213, -90.0>
    translate  <1.725561, -3.12758, -0.485314>
  }
  cylinder { // Cylndr1066
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum_1
    }
    scale <0.2, 1.7, 0.1>
    rotate <-90.0, -0.0, 17.268534>
    translate  <0.0, -3.12758, -2.156952>
  }
  sphere { // Sphere1271
    <0,0,0>,1
    material {
      Black
    }
    scale <0.2, 1.0, 0.2>
    translate  <0.0, -2.830999, -0.458352>
  }
  rotate 33.030155*y
  translate  <0.242657, -0.273658, -0.0892>
}
#declare CSG006 = difference {
  superellipsoid { // SuperQ008
    <0.5, 1.0>
    material {
      Aluminum_1
    }
    scale <1.250157, 2.8, 1.443888>
  }
  cylinder { // Cylndr1067
    <0,0,1>, <0,0,0>, 1 
    material {
      Black
    }
    scale <2.0, 2.0, 4.0>
    rotate -90.0*y
    translate  <1.833409, -2.8548, 1.743099>
  }
  box { // Cube232
    <-1, -1, -1>, <1, 1, 1>
    material {
      Black
    }
    scale <0.649495, 1.296581, 0.191143>
    translate  <0.0, 1.887333, 0.286247>
  }
  box { // Cube233
    <-1, -1, -1>, <1, 1, 1>
    material {
      Black
    }
    scale <0.649495, 1.296581, 0.191143>
    translate  <0.0, 1.868685, -0.186714>
  }
}
#declare Gondelhalterung2 = union {
  cylinder { // Cylndr1068
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum_1
    }
    scale <0.1, 0.1, 5.0>
    rotate <40.627251, -54.975811, 1.093951>
    translate  <-0.701009, -0.916705, 0.674047>
  }
  cylinder { // Cylndr1069
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum_1
    }
    scale <0.1, 0.1, 5.0>
    rotate <-38.092602, -54.895451, -1.231788>
    translate  <-0.701009, -3.154542, 0.701009>
  }
  cylinder { // Cylndr1070
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum_1
    }
    scale <0.1, 0.1, 5.0>
    rotate <15.91715, -54.941654, 0.492449>
    translate  <-0.701009, -3.154542, 0.701009>
  }
  cylinder { // Cylndr1071
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum_1
    }
    scale <0.159937, 0.1, 10.293396>
    rotate <0.0, -90.0, 0.0>
    translate  <-0.754933, -3.154542, -0.512276>
  }
  cylinder { // Cylndr1072
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum_1
    }
    scale <0.1, 0.1, 5.0>
    rotate <-13.370225, -54.930058, -0.415227>
    translate  <-0.701009, -0.916705, 0.674047>
  }
  cylinder { // Cylndr1073
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum_1
    }
    scale <-0.139748, 0.1, 10.113585>
    rotate <0.0, -90.0, 0.0>
    translate  <-0.701009, -0.916705, -0.512276>
  }
  rotate <-0.0, 26.681854, 180.0>
  translate  <-0.058753, -1.548247, -0.053924>
}
#declare Motorgondel2 = union {
  object { Propeller2 }
  cone { // Cone008
    <0,0,0>, 0.2, <0,0,1>, 1.0
    material {
      Aluminum_1
    }
    scale <0.8, 0.8, 1.989062>
    rotate -89.153397*x
    translate  <0.0, -3.048714, -0.485314>
  }
  object { CSG006 }
  object { Gondelhalterung2 }
  rotate <-0.0, -0.0, -180.0>
  translate  <15.68851, 39.152645, -18.670832>
}
#declare Propeller1 = union {
  cylinder { // Cylndr1074
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum_1
    }
    scale <0.2, 1.7, 0.1>
    rotate <-0.0, -72.427841, 90.0>
    translate  <-1.725561, -3.019733, -0.485314>
  }
  cylinder { // Cylndr1075
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum_1
    }
    scale <0.2, 1.7, 0.1>
    rotate <-90.0, 0.0, -18.551716>
    translate  <0.0, -3.12758, 1.213285>
  }
  cylinder { // Cylndr1076
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum_1
    }
    scale <0.2, 1.7, 0.1>
    rotate <-0.0, -72.223213, -90.0>
    translate  <1.725561, -3.12758, -0.485314>
  }
  cylinder { // Cylndr1077
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum_1
    }
    scale <0.2, 1.7, 0.1>
    rotate <-90.0, -0.0, 17.268534>
    translate  <0.0, -3.12758, -2.156952>
  }
  sphere { // Sphere1272
    <0,0,0>,1
    material {
      Black
    }
    scale <0.2, 1.0, 0.2>
    translate  <0.0, -2.830999, -0.458352>
  }
  rotate 33.030155*y
  translate  <0.242657, -0.273658, -0.0892>
}
#declare CSG007 = difference {
  superellipsoid { // SuperQ009
    <0.5, 1.0>
    material {
      Aluminum_1
    }
    scale <1.250157, 2.8, 1.443888>
  }
  cylinder { // Cylndr1078
    <0,0,1>, <0,0,0>, 1 
    material {
      Black
    }
    scale <2.0, 2.0, 4.0>
    rotate -90.0*y
    translate  <1.833409, -2.8548, 1.743099>
  }
  box { // Cube234
    <-1, -1, -1>, <1, 1, 1>
    material {
      Black
    }
    scale <0.649495, 1.296581, 0.191143>
    translate  <0.0, 1.887333, 0.286247>
  }
  box { // Cube235
    <-1, -1, -1>, <1, 1, 1>
    material {
      Black
    }
    scale <0.649495, 1.296581, 0.191143>
    translate  <0.0, 1.868685, -0.186714>
  }
}
#declare Gondelhalterung1 = union {
  cylinder { // Cylndr1079
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum_1
    }
    scale <0.1, 0.1, 5.0>
    rotate <40.627251, -54.975811, 1.093951>
    translate  <-0.701009, -0.916705, 0.674047>
  }
  cylinder { // Cylndr1080
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum_1
    }
    scale <0.1, 0.1, 5.0>
    rotate <-38.092602, -54.895451, -1.231788>
    translate  <-0.701009, -3.154542, 0.701009>
  }
  cylinder { // Cylndr1081
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum_1
    }
    scale <0.1, 0.1, 5.0>
    rotate <15.91715, -54.941654, 0.492449>
    translate  <-0.701009, -3.154542, 0.701009>
  }
  cylinder { // Cylndr1082
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum_1
    }
    scale <0.159937, 0.1, 10.293396>
    rotate <0.0, -90.0, 0.0>
    translate  <-0.754933, -3.154542, -0.512276>
  }
  cylinder { // Cylndr1083
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum_1
    }
    scale <0.1, 0.1, 5.0>
    rotate <-13.370225, -54.930058, -0.415227>
    translate  <-0.701009, -0.916705, 0.674047>
  }
  cylinder { // Cylndr1084
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum_1
    }
    scale <-0.139748, 0.1, 10.113585>
    rotate <0.0, -90.0, 0.0>
    translate  <-0.701009, -0.916705, -0.512276>
  }
  rotate <-0.0, 26.681854, -0.0>
  translate  <0.0, 2.507457, -0.053924>
}
#declare Motorgondel1 = union {
  object { Propeller1 }
  cone { // Cone009
    <0,0,0>, 0.2, <0,0,1>, 1.0
    material {
      Aluminum_1
    }
    scale <0.8, 0.8, 1.989062>
    rotate -89.153397*x
    translate  <0.0, -3.048714, -0.485314>
  }
  object { CSG007 }
  object { Gondelhalterung1 }
  rotate <-0.0, -0.0, 180.0>
  translate  <-15.68851, 39.152645, -18.750783>
}
#declare segment3 = union {
  object { Huele3 }
  object { Motorgondel2 }
  object { Motorgondel1 }
  rotate -0.0*x
  translate  <0.0, -37.37803, 0.0>
  hollow
  rotate 14.633763*x
  translate  <0.73652, 32.521682, -1.995435>
}
#declare BezPtch007 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <10.456579, 0.000001, 0.021850>, <10.456579, 0.578881, 0.021850>, <14.670573, 0.578881, 1.369082>, <14.670573, 0.000000, 1.369082>, 
      <10.794848, 0.000001, 2.192251>, <10.794848, 0.551410, 2.192251>, <14.625084, 0.551410, 1.989963>, <14.625084, 0.000000, 1.989963>, 
      <11.218570, 0.000001, 4.334925>, <11.218570, 0.520339, 4.334925>, <14.690249, 0.520339, 4.091891>, <14.690249, 0.000000, 4.091891>, 
      <11.579906, 0.000001, 6.778972>, <11.579906, 0.460227, 6.778972>, <14.726527, 0.460227, 5.931575>, <14.726527, 0.000000, 5.931575>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <14.670573, 0.000000, 1.369082>, <14.670573, -0.578881, 1.369082>, <10.456579, -0.578879, 0.021850>, <10.456579, 0.000001, 0.021850>, 
      <14.625084, 0.000000, 1.989963>, <14.625084, -0.551410, 1.989963>, <10.794848, -0.551409, 2.192251>, <10.794848, 0.000001, 2.192251>, 
      <14.690249, 0.000000, 4.091891>, <14.690249, -0.520339, 4.091891>, <11.218570, -0.520338, 4.334925>, <11.218570, 0.000001, 4.334925>, 
      <14.726527, 0.000000, 5.931575>, <14.726527, -0.460227, 5.931575>, <11.579906, -0.460226, 6.778972>, <11.579906, 0.000001, 6.778972>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <11.579906, 0.000001, 6.778972>, <11.579906, 0.460227, 6.778972>, <14.726527, 0.460227, 5.931575>, <14.726527, 0.000000, 5.931575>, 
      <11.941242, 0.000000, 9.223018>, <11.941242, 0.400116, 9.223018>, <14.762804, 0.400116, 7.771260>, <14.762804, 0.000000, 7.771260>, 
      <12.213249, 0.000000, 10.596011>, <12.213249, 0.293358, 10.596011>, <14.736322, 0.293358, 9.834944>, <14.736322, 0.000000, 9.834944>, 
      <13.753985, 0.000000, 10.785448>, <13.753985, 0.008205, 10.785448>, <14.852738, 0.008205, 10.939629>, <14.852738, 0.000000, 10.939629>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <14.726527, 0.000000, 5.931575>, <14.726527, -0.460227, 5.931575>, <11.579906, -0.460226, 6.778972>, <11.579906, 0.000001, 6.778972>, 
      <14.762804, 0.000000, 7.771260>, <14.762804, -0.400116, 7.771260>, <11.941242, -0.400115, 9.223018>, <11.941242, 0.000000, 9.223018>, 
      <14.736322, 0.000000, 9.834944>, <14.736322, -0.293358, 9.834944>, <12.213249, -0.293358, 10.596011>, <12.213249, 0.000000, 10.596011>, 
      <14.852738, 0.000000, 10.939629>, <14.852738, -0.008205, 10.939629>, <13.753985, -0.008205, 10.785448>, <13.753985, 0.000000, 10.785448>
    }
  }
  material {
    Aluminium_zerlegt_1
  }
  scale <1.291634, 1.2, 1.26>
  rotate -90.0*z
  translate  <0.0, 116.108498, 10.261413>
}
#declare BezPtch008 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-14.193223, 0.000002, 0.000000>, <-14.193223, 1.392883, 0.000000>, <14.312589, 1.392883, 0.009473>, <14.312589, 0.000000, 0.009473>, 
      <-13.779807, 0.000002, 2.195775>, <-13.779807, 1.326785, 2.195775>, <14.292843, 1.326785, 1.957937>, <14.292843, 0.000000, 1.957937>, 
      <-13.366392, 0.000002, 4.374885>, <-13.366392, 1.252022, 4.374885>, <14.284428, 1.252022, 4.060859>, <14.284428, 0.000000, 4.060859>, 
      <-12.126145, 0.000001, 5.918090>, <-12.126145, 1.107384, 5.918090>, <14.256319, 1.107384, 5.900686>, <14.256319, 0.000000, 5.900686>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <14.312589, 0.000000, 0.009473>, <14.312589, -1.392883, 0.009473>, <-14.193223, -1.392880, 0.000000>, <-14.193223, 0.000002, 0.000000>, 
      <14.292843, 0.000000, 1.957937>, <14.292843, -1.326784, 1.957937>, <-13.779807, -1.326781, 2.195775>, <-13.779807, 0.000002, 2.195775>, 
      <14.284428, 0.000000, 4.060859>, <14.284428, -1.252022, 4.060859>, <-13.366392, -1.252019, 4.374885>, <-13.366392, 0.000002, 4.374885>, 
      <14.256319, 0.000000, 5.900686>, <14.256319, -1.107383, 5.900686>, <-12.126145, -1.107381, 5.918090>, <-12.126145, 0.000001, 5.918090>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-12.126145, 0.000001, 5.918090>, <-12.126145, 1.107384, 5.918090>, <14.256319, 1.107384, 5.900686>, <14.256319, 0.000000, 5.900686>, 
      <-10.885898, 0.000001, 7.461295>, <-10.885898, 0.962745, 7.461295>, <14.228209, 0.962745, 7.740513>, <14.228209, 0.000000, 7.740513>, 
      <-7.082474, 0.000001, 10.711561>, <-7.082474, 0.705869, 10.711561>, <14.211641, 0.705869, 9.957012>, <14.211641, 0.000000, 9.957012>, 
      <5.765680, 0.000000, 11.271416>, <5.765680, 0.019743, 11.271416>, <14.122654, 0.019743, 11.573273>, <14.122654, 0.000000, 11.573273>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <14.256319, 0.000000, 5.900686>, <14.256319, -1.107383, 5.900686>, <-12.126145, -1.107381, 5.918090>, <-12.126145, 0.000001, 5.918090>, 
      <14.228209, 0.000000, 7.740513>, <14.228209, -0.962745, 7.740513>, <-10.885898, -0.962743, 7.461295>, <-10.885898, 0.000001, 7.461295>, 
      <14.211641, 0.000000, 9.957012>, <14.211641, -0.705869, 9.957012>, <-7.082474, -0.705867, 10.711561>, <-7.082474, 0.000001, 10.711561>, 
      <14.122654, 0.000000, 11.573273>, <14.122654, -0.019743, 11.573273>, <5.765680, -0.019743, 11.271416>, <5.765680, 0.000000, 11.271416>
    }
  }
  material {
    Aluminium_zerlegt_2
  }
  scale 1.2
  rotate 90.0*z
  translate  <0.0, 79.908886, 10.149032>
}
#declare Fluegel3 = union {
  object { BezPtch007 }
  object { BezPtch008 }
  rotate 90.0*y
}
#declare BezPtch005 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <10.456579, 0.000001, 0.021850>, <10.456579, 0.578881, 0.021850>, <14.670573, 0.578881, 1.369082>, <14.670573, 0.000000, 1.369082>, 
      <10.794848, 0.000001, 2.192251>, <10.794848, 0.551410, 2.192251>, <14.625084, 0.551410, 1.989963>, <14.625084, 0.000000, 1.989963>, 
      <11.218570, 0.000001, 4.334925>, <11.218570, 0.520339, 4.334925>, <14.690249, 0.520339, 4.091891>, <14.690249, 0.000000, 4.091891>, 
      <11.579906, 0.000001, 6.778972>, <11.579906, 0.460227, 6.778972>, <14.726527, 0.460227, 5.931575>, <14.726527, 0.000000, 5.931575>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <14.670573, 0.000000, 1.369082>, <14.670573, -0.578881, 1.369082>, <10.456579, -0.578879, 0.021850>, <10.456579, 0.000001, 0.021850>, 
      <14.625084, 0.000000, 1.989963>, <14.625084, -0.551410, 1.989963>, <10.794848, -0.551409, 2.192251>, <10.794848, 0.000001, 2.192251>, 
      <14.690249, 0.000000, 4.091891>, <14.690249, -0.520339, 4.091891>, <11.218570, -0.520338, 4.334925>, <11.218570, 0.000001, 4.334925>, 
      <14.726527, 0.000000, 5.931575>, <14.726527, -0.460227, 5.931575>, <11.579906, -0.460226, 6.778972>, <11.579906, 0.000001, 6.778972>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <11.579906, 0.000001, 6.778972>, <11.579906, 0.460227, 6.778972>, <14.726527, 0.460227, 5.931575>, <14.726527, 0.000000, 5.931575>, 
      <11.941242, 0.000000, 9.223018>, <11.941242, 0.400116, 9.223018>, <14.762804, 0.400116, 7.771260>, <14.762804, 0.000000, 7.771260>, 
      <12.213249, 0.000000, 10.596011>, <12.213249, 0.293358, 10.596011>, <14.736322, 0.293358, 9.834944>, <14.736322, 0.000000, 9.834944>, 
      <13.753985, 0.000000, 10.785448>, <13.753985, 0.008205, 10.785448>, <14.852738, 0.008205, 10.939629>, <14.852738, 0.000000, 10.939629>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <14.726527, 0.000000, 5.931575>, <14.726527, -0.460227, 5.931575>, <11.579906, -0.460226, 6.778972>, <11.579906, 0.000001, 6.778972>, 
      <14.762804, 0.000000, 7.771260>, <14.762804, -0.400116, 7.771260>, <11.941242, -0.400115, 9.223018>, <11.941242, 0.000000, 9.223018>, 
      <14.736322, 0.000000, 9.834944>, <14.736322, -0.293358, 9.834944>, <12.213249, -0.293358, 10.596011>, <12.213249, 0.000000, 10.596011>, 
      <14.852738, 0.000000, 10.939629>, <14.852738, -0.008205, 10.939629>, <13.753985, -0.008205, 10.785448>, <13.753985, 0.000000, 10.785448>
    }
  }
  material {
    Aluminium_zerlegt_1
  }
  scale <1.291634, 1.2, 1.26>
  rotate -90.0*z
  translate  <0.0, 116.108498, 10.261413>
}
#declare BezPtch006 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-14.193223, 0.000002, 0.000000>, <-14.193223, 1.392883, 0.000000>, <14.312589, 1.392883, 0.009473>, <14.312589, 0.000000, 0.009473>, 
      <-13.779807, 0.000002, 2.195775>, <-13.779807, 1.326785, 2.195775>, <14.292843, 1.326785, 1.957937>, <14.292843, 0.000000, 1.957937>, 
      <-13.366392, 0.000002, 4.374885>, <-13.366392, 1.252022, 4.374885>, <14.284428, 1.252022, 4.060859>, <14.284428, 0.000000, 4.060859>, 
      <-12.126145, 0.000001, 5.918090>, <-12.126145, 1.107384, 5.918090>, <14.256319, 1.107384, 5.900686>, <14.256319, 0.000000, 5.900686>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <14.312589, 0.000000, 0.009473>, <14.312589, -1.392883, 0.009473>, <-14.193223, -1.392880, 0.000000>, <-14.193223, 0.000002, 0.000000>, 
      <14.292843, 0.000000, 1.957937>, <14.292843, -1.326784, 1.957937>, <-13.779807, -1.326781, 2.195775>, <-13.779807, 0.000002, 2.195775>, 
      <14.284428, 0.000000, 4.060859>, <14.284428, -1.252022, 4.060859>, <-13.366392, -1.252019, 4.374885>, <-13.366392, 0.000002, 4.374885>, 
      <14.256319, 0.000000, 5.900686>, <14.256319, -1.107383, 5.900686>, <-12.126145, -1.107381, 5.918090>, <-12.126145, 0.000001, 5.918090>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-12.126145, 0.000001, 5.918090>, <-12.126145, 1.107384, 5.918090>, <14.256319, 1.107384, 5.900686>, <14.256319, 0.000000, 5.900686>, 
      <-10.885898, 0.000001, 7.461295>, <-10.885898, 0.962745, 7.461295>, <14.228209, 0.962745, 7.740513>, <14.228209, 0.000000, 7.740513>, 
      <-7.082474, 0.000001, 10.711561>, <-7.082474, 0.705869, 10.711561>, <14.211641, 0.705869, 9.957012>, <14.211641, 0.000000, 9.957012>, 
      <5.765680, 0.000000, 11.271416>, <5.765680, 0.019743, 11.271416>, <14.122654, 0.019743, 11.573273>, <14.122654, 0.000000, 11.573273>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <14.256319, 0.000000, 5.900686>, <14.256319, -1.107383, 5.900686>, <-12.126145, -1.107381, 5.918090>, <-12.126145, 0.000001, 5.918090>, 
      <14.228209, 0.000000, 7.740513>, <14.228209, -0.962745, 7.740513>, <-10.885898, -0.962743, 7.461295>, <-10.885898, 0.000001, 7.461295>, 
      <14.211641, 0.000000, 9.957012>, <14.211641, -0.705869, 9.957012>, <-7.082474, -0.705867, 10.711561>, <-7.082474, 0.000001, 10.711561>, 
      <14.122654, 0.000000, 11.573273>, <14.122654, -0.019743, 11.573273>, <5.765680, -0.019743, 11.271416>, <5.765680, 0.000000, 11.271416>
    }
  }
  material {
    Aluminium_zerlegt_2
  }
  scale 1.2
  rotate 90.0*z
  translate  <0.0, 79.908886, 10.149032>
}
#declare Fluegel2 = union {
  object { BezPtch005 }
  object { BezPtch006 }
  rotate <180.0, 0.0, 180.0>
}
#declare BezPtch003 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <10.456579, 0.000001, 0.021850>, <10.456579, 0.578881, 0.021850>, <14.670573, 0.578881, 1.369082>, <14.670573, 0.000000, 1.369082>, 
      <10.794848, 0.000001, 2.192251>, <10.794848, 0.551410, 2.192251>, <14.625084, 0.551410, 1.989963>, <14.625084, 0.000000, 1.989963>, 
      <11.218570, 0.000001, 4.334925>, <11.218570, 0.520339, 4.334925>, <14.690249, 0.520339, 4.091891>, <14.690249, 0.000000, 4.091891>, 
      <11.579906, 0.000001, 6.778972>, <11.579906, 0.460227, 6.778972>, <14.726527, 0.460227, 5.931575>, <14.726527, 0.000000, 5.931575>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <14.670573, 0.000000, 1.369082>, <14.670573, -0.578881, 1.369082>, <10.456579, -0.578879, 0.021850>, <10.456579, 0.000001, 0.021850>, 
      <14.625084, 0.000000, 1.989963>, <14.625084, -0.551410, 1.989963>, <10.794848, -0.551409, 2.192251>, <10.794848, 0.000001, 2.192251>, 
      <14.690249, 0.000000, 4.091891>, <14.690249, -0.520339, 4.091891>, <11.218570, -0.520338, 4.334925>, <11.218570, 0.000001, 4.334925>, 
      <14.726527, 0.000000, 5.931575>, <14.726527, -0.460227, 5.931575>, <11.579906, -0.460226, 6.778972>, <11.579906, 0.000001, 6.778972>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <11.579906, 0.000001, 6.778972>, <11.579906, 0.460227, 6.778972>, <14.726527, 0.460227, 5.931575>, <14.726527, 0.000000, 5.931575>, 
      <11.941242, 0.000000, 9.223018>, <11.941242, 0.400116, 9.223018>, <14.762804, 0.400116, 7.771260>, <14.762804, 0.000000, 7.771260>, 
      <12.213249, 0.000000, 10.596011>, <12.213249, 0.293358, 10.596011>, <14.736322, 0.293358, 9.834944>, <14.736322, 0.000000, 9.834944>, 
      <13.753985, 0.000000, 10.785448>, <13.753985, 0.008205, 10.785448>, <14.852738, 0.008205, 10.939629>, <14.852738, 0.000000, 10.939629>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <14.726527, 0.000000, 5.931575>, <14.726527, -0.460227, 5.931575>, <11.579906, -0.460226, 6.778972>, <11.579906, 0.000001, 6.778972>, 
      <14.762804, 0.000000, 7.771260>, <14.762804, -0.400116, 7.771260>, <11.941242, -0.400115, 9.223018>, <11.941242, 0.000000, 9.223018>, 
      <14.736322, 0.000000, 9.834944>, <14.736322, -0.293358, 9.834944>, <12.213249, -0.293358, 10.596011>, <12.213249, 0.000000, 10.596011>, 
      <14.852738, 0.000000, 10.939629>, <14.852738, -0.008205, 10.939629>, <13.753985, -0.008205, 10.785448>, <13.753985, 0.000000, 10.785448>
    }
  }
  material {
    Aluminium_zerlegt_1
  }
  scale <1.291634, 1.2, 1.26>
  rotate -90.0*z
  translate  <0.0, 116.108498, 10.261413>
}
#declare BezPtch004 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-14.193223, 0.000002, 0.000000>, <-14.193223, 1.392883, 0.000000>, <14.312589, 1.392883, 0.009473>, <14.312589, 0.000000, 0.009473>, 
      <-13.779807, 0.000002, 2.195775>, <-13.779807, 1.326785, 2.195775>, <14.292843, 1.326785, 1.957937>, <14.292843, 0.000000, 1.957937>, 
      <-13.366392, 0.000002, 4.374885>, <-13.366392, 1.252022, 4.374885>, <14.284428, 1.252022, 4.060859>, <14.284428, 0.000000, 4.060859>, 
      <-12.126145, 0.000001, 5.918090>, <-12.126145, 1.107384, 5.918090>, <14.256319, 1.107384, 5.900686>, <14.256319, 0.000000, 5.900686>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <14.312589, 0.000000, 0.009473>, <14.312589, -1.392883, 0.009473>, <-14.193223, -1.392880, 0.000000>, <-14.193223, 0.000002, 0.000000>, 
      <14.292843, 0.000000, 1.957937>, <14.292843, -1.326784, 1.957937>, <-13.779807, -1.326781, 2.195775>, <-13.779807, 0.000002, 2.195775>, 
      <14.284428, 0.000000, 4.060859>, <14.284428, -1.252022, 4.060859>, <-13.366392, -1.252019, 4.374885>, <-13.366392, 0.000002, 4.374885>, 
      <14.256319, 0.000000, 5.900686>, <14.256319, -1.107383, 5.900686>, <-12.126145, -1.107381, 5.918090>, <-12.126145, 0.000001, 5.918090>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-12.126145, 0.000001, 5.918090>, <-12.126145, 1.107384, 5.918090>, <14.256319, 1.107384, 5.900686>, <14.256319, 0.000000, 5.900686>, 
      <-10.885898, 0.000001, 7.461295>, <-10.885898, 0.962745, 7.461295>, <14.228209, 0.962745, 7.740513>, <14.228209, 0.000000, 7.740513>, 
      <-7.082474, 0.000001, 10.711561>, <-7.082474, 0.705869, 10.711561>, <14.211641, 0.705869, 9.957012>, <14.211641, 0.000000, 9.957012>, 
      <5.765680, 0.000000, 11.271416>, <5.765680, 0.019743, 11.271416>, <14.122654, 0.019743, 11.573273>, <14.122654, 0.000000, 11.573273>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <14.256319, 0.000000, 5.900686>, <14.256319, -1.107383, 5.900686>, <-12.126145, -1.107381, 5.918090>, <-12.126145, 0.000001, 5.918090>, 
      <14.228209, 0.000000, 7.740513>, <14.228209, -0.962745, 7.740513>, <-10.885898, -0.962743, 7.461295>, <-10.885898, 0.000001, 7.461295>, 
      <14.211641, 0.000000, 9.957012>, <14.211641, -0.705869, 9.957012>, <-7.082474, -0.705867, 10.711561>, <-7.082474, 0.000001, 10.711561>, 
      <14.122654, 0.000000, 11.573273>, <14.122654, -0.019743, 11.573273>, <5.765680, -0.019743, 11.271416>, <5.765680, 0.000000, 11.271416>
    }
  }
  material {
    Aluminium_zerlegt_2
  }
  scale 1.2
  rotate 90.0*z
  translate  <0.0, 79.908886, 10.149032>
}
#declare Fluegel1 = union {
  object { BezPtch003 }
  object { BezPtch004 }
  rotate -90.0*y
}
#declare BezPtch002 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <10.456579, 0.000001, 0.021850>, <10.456579, 0.578881, 0.021850>, <14.670573, 0.578881, 1.369082>, <14.670573, 0.000000, 1.369082>, 
      <10.794848, 0.000001, 2.192251>, <10.794848, 0.551410, 2.192251>, <14.625084, 0.551410, 1.989963>, <14.625084, 0.000000, 1.989963>, 
      <11.218570, 0.000001, 4.334925>, <11.218570, 0.520339, 4.334925>, <14.690249, 0.520339, 4.091891>, <14.690249, 0.000000, 4.091891>, 
      <11.579906, 0.000001, 6.778972>, <11.579906, 0.460227, 6.778972>, <14.726527, 0.460227, 5.931575>, <14.726527, 0.000000, 5.931575>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <14.670573, 0.000000, 1.369082>, <14.670573, -0.578881, 1.369082>, <10.456579, -0.578879, 0.021850>, <10.456579, 0.000001, 0.021850>, 
      <14.625084, 0.000000, 1.989963>, <14.625084, -0.551410, 1.989963>, <10.794848, -0.551409, 2.192251>, <10.794848, 0.000001, 2.192251>, 
      <14.690249, 0.000000, 4.091891>, <14.690249, -0.520339, 4.091891>, <11.218570, -0.520338, 4.334925>, <11.218570, 0.000001, 4.334925>, 
      <14.726527, 0.000000, 5.931575>, <14.726527, -0.460227, 5.931575>, <11.579906, -0.460226, 6.778972>, <11.579906, 0.000001, 6.778972>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <11.579906, 0.000001, 6.778972>, <11.579906, 0.460227, 6.778972>, <14.726527, 0.460227, 5.931575>, <14.726527, 0.000000, 5.931575>, 
      <11.941242, 0.000000, 9.223018>, <11.941242, 0.400116, 9.223018>, <14.762804, 0.400116, 7.771260>, <14.762804, 0.000000, 7.771260>, 
      <12.213249, 0.000000, 10.596011>, <12.213249, 0.293358, 10.596011>, <14.736322, 0.293358, 9.834944>, <14.736322, 0.000000, 9.834944>, 
      <13.753985, 0.000000, 10.785448>, <13.753985, 0.008205, 10.785448>, <14.852738, 0.008205, 10.939629>, <14.852738, 0.000000, 10.939629>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <14.726527, 0.000000, 5.931575>, <14.726527, -0.460227, 5.931575>, <11.579906, -0.460226, 6.778972>, <11.579906, 0.000001, 6.778972>, 
      <14.762804, 0.000000, 7.771260>, <14.762804, -0.400116, 7.771260>, <11.941242, -0.400115, 9.223018>, <11.941242, 0.000000, 9.223018>, 
      <14.736322, 0.000000, 9.834944>, <14.736322, -0.293358, 9.834944>, <12.213249, -0.293358, 10.596011>, <12.213249, 0.000000, 10.596011>, 
      <14.852738, 0.000000, 10.939629>, <14.852738, -0.008205, 10.939629>, <13.753985, -0.008205, 10.785448>, <13.753985, 0.000000, 10.785448>
    }
  }
  material {
    Aluminium_zerlegt_1
  }
  scale <1.291634, 1.2, 1.26>
  rotate -90.0*z
  translate  <0.0, 116.108498, 10.261413>
}
#declare BezPtch001 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-14.193223, 0.000002, 0.000000>, <-14.193223, 1.392883, 0.000000>, <14.312589, 1.392883, 0.009473>, <14.312589, 0.000000, 0.009473>, 
      <-13.779807, 0.000002, 2.195775>, <-13.779807, 1.326785, 2.195775>, <14.292843, 1.326785, 1.957937>, <14.292843, 0.000000, 1.957937>, 
      <-13.366392, 0.000002, 4.374885>, <-13.366392, 1.252022, 4.374885>, <14.284428, 1.252022, 4.060859>, <14.284428, 0.000000, 4.060859>, 
      <-12.126145, 0.000001, 5.918090>, <-12.126145, 1.107384, 5.918090>, <14.256319, 1.107384, 5.900686>, <14.256319, 0.000000, 5.900686>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <14.312589, 0.000000, 0.009473>, <14.312589, -1.392883, 0.009473>, <-14.193223, -1.392880, 0.000000>, <-14.193223, 0.000002, 0.000000>, 
      <14.292843, 0.000000, 1.957937>, <14.292843, -1.326784, 1.957937>, <-13.779807, -1.326781, 2.195775>, <-13.779807, 0.000002, 2.195775>, 
      <14.284428, 0.000000, 4.060859>, <14.284428, -1.252022, 4.060859>, <-13.366392, -1.252019, 4.374885>, <-13.366392, 0.000002, 4.374885>, 
      <14.256319, 0.000000, 5.900686>, <14.256319, -1.107383, 5.900686>, <-12.126145, -1.107381, 5.918090>, <-12.126145, 0.000001, 5.918090>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-12.126145, 0.000001, 5.918090>, <-12.126145, 1.107384, 5.918090>, <14.256319, 1.107384, 5.900686>, <14.256319, 0.000000, 5.900686>, 
      <-10.885898, 0.000001, 7.461295>, <-10.885898, 0.962745, 7.461295>, <14.228209, 0.962745, 7.740513>, <14.228209, 0.000000, 7.740513>, 
      <-7.082474, 0.000001, 10.711561>, <-7.082474, 0.705869, 10.711561>, <14.211641, 0.705869, 9.957012>, <14.211641, 0.000000, 9.957012>, 
      <5.765680, 0.000000, 11.271416>, <5.765680, 0.019743, 11.271416>, <14.122654, 0.019743, 11.573273>, <14.122654, 0.000000, 11.573273>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <14.256319, 0.000000, 5.900686>, <14.256319, -1.107383, 5.900686>, <-12.126145, -1.107381, 5.918090>, <-12.126145, 0.000001, 5.918090>, 
      <14.228209, 0.000000, 7.740513>, <14.228209, -0.962745, 7.740513>, <-10.885898, -0.962743, 7.461295>, <-10.885898, 0.000001, 7.461295>, 
      <14.211641, 0.000000, 9.957012>, <14.211641, -0.705869, 9.957012>, <-7.082474, -0.705867, 10.711561>, <-7.082474, 0.000001, 10.711561>, 
      <14.122654, 0.000000, 11.573273>, <14.122654, -0.019743, 11.573273>, <5.765680, -0.019743, 11.271416>, <5.765680, 0.000000, 11.271416>
    }
  }
  material {
    Aluminium_zerlegt_2
  }
  scale 1.2
  rotate 90.0*z
  translate  <0.0, 79.908886, 10.149032>
}
#declare Fluegel0 = union {
  object { BezPtch002 }
  object { BezPtch001 }
}
//
// Include file contains 'Huele4'
//
#include "lake.in4"
#declare Huele4 = object {
  Huele4_Raw
  material {
    Aluminium_zerlegt_3
  }
  rotate -90.0*x
}
#declare segment4 = union {
  object { Fluegel3 }
  object { Fluegel2 }
  object { Fluegel1 }
  object { Fluegel0 }
  object { Huele4 }
  rotate 0.0*x
  translate  <0.0, -76.044957, 1.288898>
  hollow
  rotate <22.352522, -11.483888, -8.599574>
  translate  <0.766915, 68.43744, 8.43147>
}
#declare Leine1 = difference {
  torus { // Torus030
    1.599, 0.001  rotate -x*90
    material {
      Black
    }
    scale <100.0, 30.0, 1.0>
    rotate -90.0*y
  }
  box { // Cube236
    <-1, -1, -1>, <1, 1, 1>
    material {
      Black
    }
    scale 250.0
    translate  <-0.0, 225.924865, 7.259847>
  }
  rotate 35.807045*x
  translate  <-0.364732, -20.042772, -99.350995>
}
#declare Leine = difference {
  torus { // Torus031
    1.599, 0.001  rotate -x*90
    material {
      Black
    }
    scale <100.0, 30.0, 1.0>
    rotate -90.0*y
  }
  box { // Cube237
    <-1, -1, -1>, <1, 1, 1>
    material {
      Black
    }
    scale 250.0
    translate  <0.0, 251.851852, 10.641628>
  }
  rotate 70.728333*x
  translate  <-0.364732, 30.814244, -53.194081>
}
union { // LZ129
  object { segment1 }
  object { segment2 }
  object { segment3 }
  object { segment4 }
  object { Leine1 }
  object { Leine }
  rotate <-10.646307, 0.731285, -80.070015>
  translate  <163.341048, 193.957362, 81.640683>
}


#declare Explosionsbasis = union {
  sphere { // Sphere1273
    <0,0,0>,1
    material {
      Explosion_1
    }
    no_shadow
    hollow
    scale <-25.094627, -66.699715, -33.294956>
    rotate <21.675625, 0.0, -0.0>
    translate  <-1.983733, 62.277403, 20.065972>
  }
  sphere { // Sphere1274
    <0,0,0>,1
    material {
      Explosion_1
    }
    no_shadow
    hollow
    scale <-20.949615, -62.669643, -18.001892>
    rotate <-178.003311, -0.0, -180.0>
  }
  sphere { // Sphere1275
    <0,0,0>,1
    material {
      Explosion_1
    }
    scale <23.287235, 21.533012, 21.852245>
    rotate <2.835373, -9.300551, 79.937218>
    translate  <16.827709, -33.076918, 16.487355>
  }
  sphere { // Sphere1276
    <0,0,0>,1
    material {
      Explosion_1
    }
    no_shadow
    hollow
    scale <21.37079, 19.760933, 20.053894>
    rotate <2.835373, -9.300551, 79.937218>
    translate  <29.272366, -10.547682, -7.065579>
  }
  cylinder { // Cylndr1090
    <0,0,1>, <0,0,0>, 1 
    material {
      Rauch_1
    }
    no_shadow
    hollow
    scale <25.0, 25.0, 83.691833>
    rotate <2.803926, 3.70166, 80.576988>
    translate  <-3.910346, 26.561884, 4.032007>
  }
  sphere { // Sphere1278
    <0,0,0>,1
    material {
      Explosion_1
    }
    no_shadow
    hollow
    scale <16.089235, 14.877237, 15.097796>
    rotate <-6.076842, -13.567685, 161.876541>
    translate  <24.806434, -22.714618, 39.730267>
  }
  sphere { // Sphere1277
    <0,0,0>,1
    material {
      Explosion_1
    }
    no_shadow
    hollow
    scale <18.709679, 17.300282, 17.556763>
    rotate <-6.076842, -13.567685, 161.876541>
    translate  <18.925074, -14.361508, 23.222947>
  }
  sphere { // Sphere1279
    <0,0,0>,1
    material {
      Explosion_3
    }
    no_shadow
    hollow
    scale 16.693378
    rotate <2.835374, -9.300551, 79.937218>
    translate  <54.077738, 10.07935, 21.433441>
  }
  sphere { // Sphere1280
    <0,0,0>,1
    material {
      Explosion_3
    }
    no_shadow
    hollow
    scale 8.367584
    rotate <2.835374, -9.300551, 79.937218>
    translate  <50.551212, 7.333084, 17.878078>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <27.983361, 10.494188, 1.202115>
  no_shadow
  hollow
  rotate <-9.648932, -1.174748, -80.068741>
  translate  <126.320521, 204.297231, 68.297635>
}
#declare Explosionspilz = union {
  sphere { // Sphere1291
    <0,0,0>,1
    rotate -0.0*z
    translate  <0.0, 0.233933, 0.0>
    material {
      Explosion_1
    }
    hollow
    scale 18.0
    rotate -0.0*y
    translate  <-47.320035, 0.0, 0.0>
  }
  sphere { // Sphere1290
    <0,0,0>,1
    rotate -0.0*z
    translate  <0.0, 0.233933, 0.0>
    material {
      Explosion_1
    }
    hollow
    scale 15.560011
    rotate 30.0*y
    translate  <-40.980352, -23.660017, 0.0>
  }
  sphere { // Sphere1289
    <0,0,0>,1
    rotate -0.0*z
    translate  <0.0, 0.233933, 0.0>
    material {
      Explosion_1
    }
    hollow
    scale 17.0
    rotate 60.0*y
    translate  <-22.06298, -37.786277, -0.0>
  }
  sphere { // Sphere1288
    <0,0,0>,1
    rotate -0.0*z
    translate  <0.0, 0.233933, 0.0>
    material {
      Explosion_1
    }
    hollow
    scale 15.560011
    rotate 90.0*y
    translate  <-0.0, -47.320035, 0.0>
  }
  sphere { // Sphere1287
    <0,0,0>,1
    rotate -0.0*z
    translate  <0.0, 0.233933, 0.0>
    material {
      Explosion_1
    }
    hollow
    scale 15.560011
    rotate <180.0, 60.0, 180.0>
    translate  <15.011746, -40.980352, 3.706402>
  }
  sphere { // Sphere1286
    <0,0,0>,1
    rotate -0.0*z
    translate  <0.0, 0.233933, 0.0>
    material {
      Explosion_1
    }
    hollow
    scale 15.560011
    rotate <180.0, 30.0, 180.0>
    translate  <40.980352, -23.660017, 0.0>
  }
  sphere { // Sphere1285
    <0,0,0>,1
    rotate -0.0*z
    translate  <0.0, 0.233933, 0.0>
    material {
      Explosion_1
    }
    hollow
    scale 15.560011
    rotate <180.0, 0.0, 180.0>
    translate  <46.084568, -0.0, -4.941869>
  }
  sphere { // Sphere1284
    <0,0,0>,1
    rotate -0.0*z
    translate  <0.0, 0.233933, 0.0>
    material {
      Explosion_1
    }
    hollow
    scale 15.560011
    rotate <180.0, -30.0, 180.0>
    translate  <40.980352, 23.660017, 0.0>
  }
  sphere { // Sphere1283
    <0,0,0>,1
    rotate -0.0*z
    translate  <0.0, 0.233933, 0.0>
    material {
      Explosion_1
    }
    hollow
    scale 15.560011
    rotate <180.0, -60.0, 180.0>
    translate  <23.660017, 40.980352, 0.0>
  }
  sphere { // Sphere1282
    <0,0,0>,1
    rotate -0.0*z
    translate  <0.0, 0.233933, 0.0>
    material {
      Explosion_1
    }
    hollow
    scale 15.560011
    rotate -90.0*y
    translate  <0.0, 47.320035, 0.0>
  }
  sphere { // Sphere1281
    <0,0,0>,1
    rotate -0.0*z
    translate  <0.0, 0.233933, 0.0>
    material {
      Explosion_1
    }
    hollow
    scale 15.560011
    rotate -60.0*y
    translate  <-22.177457, 40.980352, 0.0>
  }
  sphere { // Sphere1292
    <0,0,0>,1
    rotate -0.0*z
    translate  <0.0, 0.233933, 0.0>
    material {
      Explosion_1
    }
    hollow
    scale 15.560011
    rotate -30.0*y
    translate  <-40.980352, 23.660017, 0.0>
  }
  sphere { // Sphere1293
    <0,0,0>,1
    rotate -0.0*z
    translate  <0.0, 0.233933, 0.0>
    material {
      Explosion_1
    }
    hollow
    scale 15.560011
    translate  <-47.320035, 0.0, 0.0>
  }
  sphere { // Sphere1294
    <0,0,0>,1
    material {
      Explosion_3
    }
    no_shadow
    hollow
    scale <63.203941, 51.383446, 15.881166>
    translate  <0.319689, 4.569518, 9.46328>
  }
  sphere { // Sphere1297
    <0,0,0>,1
    rotate -0.0*z
    translate  <0.0, 0.233933, 0.0>
    material {
      Explosion_1
    }
    no_shadow
    hollow
    scale 15.560011
    rotate -0.0*y
    translate  <-23.588907, -4.394353, -13.372959>
  }
  sphere { // Sphere1296
    <0,0,0>,1
    rotate -0.0*z
    translate  <0.0, 0.233933, 0.0>
    material {
      Explosion_1
    }
    no_shadow
    hollow
    scale 15.560011
    rotate -0.0*y
    translate  <-5.951916, -22.619244, -13.372959>
  }
  sphere { // Sphere1295
    <0,0,0>,1
    rotate -0.0*z
    translate  <0.0, 0.233933, 0.0>
    material {
      Explosion_1
    }
    no_shadow
    hollow
    scale 15.560011
    rotate -0.0*y
    translate  <17.564072, -13.800749, -13.372959>
  }
  sphere { // Sphere1298
    <0,0,0>,1
    rotate -0.0*z
    translate  <0.0, 0.233933, 0.0>
    material {
      Explosion_1
    }
    no_shadow
    hollow
    scale 15.560011
    rotate -0.0*y
    translate  <22.26727, 9.12734, -13.372959>
  }
  sphere { // Sphere1299
    <0,0,0>,1
    rotate -0.0*z
    translate  <0.0, 0.233933, 0.0>
    material {
      Explosion_1
    }
    no_shadow
    hollow
    scale 15.560011
    rotate -0.0*y
    translate  <3.468343, 25.576401, -13.372959>
  }
  sphere { // Sphere1300
    <0,0,0>,1
    rotate -0.0*z
    translate  <0.0, 0.233933, 0.0>
    material {
      Explosion_1
    }
    no_shadow
    hollow
    scale 15.560011
    rotate -0.0*y
    translate  <-21.205249, 20.876669, -13.372959>
  }
  scale <1.4, 1.4, 1.3>
  rotate <185.632431, -189.233109, 180.84938>
  translate  <183.078855, 182.000134, 157.15145>
}
#declare Feuerbogen21 = union {
  cylinder { // Cylndr1091
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -75.0*x
    translate  <0.425241, 20.966603, -88.607482>
  }
  sphere { // Sphere1301
    <0,0,0>,1
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale 5.0
    translate  <0.0, 12.279307, -88.411008>
  }
  cylinder { // Cylndr1092
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -60.0*x
    translate  <0.0, 43.306597, -79.920948>
  }
  cylinder { // Cylndr1093
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -45.0*x
    translate  <0.0, 62.516024, -65.989136>
  }
  cylinder { // Cylndr1094
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -30.0*x
    translate  <0.0, 77.465087, -47.560273>
  }
  cylinder { // Cylndr1095
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -15.0*x
    translate  <0.0, 87.135033, -25.890256>
  }
  cylinder { // Cylndr1096
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    translate  <0.0, 90.86687, -2.455861>
  }
  no_shadow
  hollow
  rotate 21.6742*z
  translate  <101.2435, -85.638191, -17.191029>
}
#declare Feuerbogen22 = union {
  cylinder { // Cylndr1097
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -75.0*x
    translate  <0.0, 21.145897, -88.40628>
  }
  sphere { // Sphere1302
    <0,0,0>,1
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale 5.0
    translate  <0.0, 12.279307, -88.411008>
  }
  cylinder { // Cylndr1098
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -60.0*x
    translate  <0.0, 43.306597, -79.920948>
  }
  cylinder { // Cylndr1099
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -45.0*x
    translate  <0.0, 62.516024, -65.989136>
  }
  cylinder { // Cylndr1100
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -30.0*x
    translate  <0.0, 77.465087, -47.560273>
  }
  cylinder { // Cylndr1101
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -15.0*x
    translate  <0.0, 87.135033, -25.890256>
  }
  cylinder { // Cylndr1102
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    translate  <0.0, 90.86687, -2.455861>
  }
  no_shadow
  hollow
  scale <1.0, 0.8, 1.0>
  rotate <-16.177456, 6.560779, 17.341682>
  translate  <74.007411, -71.470738, 3.196774>
}
#declare Feuerbogen23 = union {
  cylinder { // Cylndr1103
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -75.0*x
    translate  <0.0, 21.145897, -88.40628>
  }
  sphere { // Sphere1303
    <0,0,0>,1
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale 5.0
    translate  <0.0, 12.279307, -88.411008>
  }
  cylinder { // Cylndr1104
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -60.0*x
    translate  <0.0, 43.306597, -79.920948>
  }
  cylinder { // Cylndr1105
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -45.0*x
    translate  <0.0, 62.516024, -65.989136>
  }
  cylinder { // Cylndr1106
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -30.0*x
    translate  <0.0, 77.465087, -47.560273>
  }
  cylinder { // Cylndr1107
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -15.0*x
    translate  <0.0, 87.135033, -25.890256>
  }
  cylinder { // Cylndr1108
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    translate  <0.0, 90.86687, -2.455861>
  }
  no_shadow
  hollow
  rotate 10.287094*z
  translate  <54.773791, -90.86934, -17.191029>
}
#declare Feuerbogen24 = union {
  cylinder { // Cylndr1109
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -75.0*x
    translate  <0.0, 21.145897, -88.40628>
  }
  sphere { // Sphere1304
    <0,0,0>,1
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale 5.0
    translate  <0.0, 12.279307, -88.411008>
  }
  cylinder { // Cylndr1110
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -60.0*x
    translate  <0.0, 43.306597, -79.920948>
  }
  cylinder { // Cylndr1111
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -45.0*x
    translate  <0.0, 62.516024, -65.989136>
  }
  cylinder { // Cylndr1112
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -30.0*x
    translate  <0.0, 77.465087, -47.560273>
  }
  cylinder { // Cylndr1113
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -15.0*x
    translate  <0.0, 87.135033, -25.890256>
  }
  cylinder { // Cylndr1114
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    translate  <0.0, 90.86687, -2.455861>
  }
  no_shadow
  hollow
  scale <1.0, 0.9, 1.0>
  rotate <10.515208, -0.745804, 3.604543>
  translate  <32.462299, -77.130336, -31.235961>
}
#declare Feuerbogen25 = union {
  cylinder { // Cylndr1115
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -75.0*x
    translate  <0.0, 21.145897, -88.40628>
  }
  sphere { // Sphere1305
    <0,0,0>,1
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale 5.0
    translate  <0.0, 12.279307, -88.411008>
  }
  cylinder { // Cylndr1116
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -60.0*x
    translate  <0.0, 43.306597, -79.920948>
  }
  cylinder { // Cylndr1117
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -45.0*x
    translate  <0.0, 62.516024, -65.989136>
  }
  cylinder { // Cylndr1118
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -30.0*x
    translate  <0.0, 77.465087, -47.560273>
  }
  cylinder { // Cylndr1119
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -15.0*x
    translate  <0.0, 87.135033, -25.890256>
  }
  cylinder { // Cylndr1120
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    translate  <0.0, 90.86687, -2.455861>
  }
  no_shadow
  hollow
  scale <1.0, 1.2, 1.0>
  rotate -22.83012*x
  translate  <12.613104, -108.899519, 26.302951>
}
#declare Feuerbogen26 = union {
  cylinder { // Cylndr1121
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -75.0*x
    translate  <0.0, 21.145897, -88.40628>
  }
  sphere { // Sphere1306
    <0,0,0>,1
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale 5.0
    translate  <0.0, 12.279307, -88.411008>
  }
  cylinder { // Cylndr1122
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -60.0*x
    translate  <0.0, 43.306597, -79.920948>
  }
  cylinder { // Cylndr1123
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -45.0*x
    translate  <0.0, 62.516024, -65.989136>
  }
  cylinder { // Cylndr1124
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -30.0*x
    translate  <0.0, 77.465087, -47.560273>
  }
  cylinder { // Cylndr1125
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -15.0*x
    translate  <0.0, 87.135033, -25.890256>
  }
  cylinder { // Cylndr1126
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    translate  <0.0, 90.86687, -2.455861>
  }
  no_shadow
  hollow
  rotate <-2.028563, -0.133037, -3.750632>
  translate  <-7.851664, -93.30393, -12.207344>
}
#declare Feuerbogen27 = union {
  cylinder { // Cylndr1127
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -75.0*x
    translate  <0.0, 21.145897, -88.40628>
  }
  sphere { // Sphere1307
    <0,0,0>,1
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale 5.0
    translate  <0.0, 12.279307, -88.411008>
  }
  cylinder { // Cylndr1128
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -60.0*x
    translate  <0.0, 43.306597, -79.920948>
  }
  cylinder { // Cylndr1129
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -45.0*x
    translate  <0.0, 62.516024, -65.989136>
  }
  cylinder { // Cylndr1130
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -30.0*x
    translate  <0.0, 77.465087, -47.560273>
  }
  cylinder { // Cylndr1131
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -15.0*x
    translate  <0.0, 87.135033, -25.890256>
  }
  cylinder { // Cylndr1132
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    translate  <0.0, 90.86687, -2.455861>
  }
  no_shadow
  hollow
  scale <1.0, 0.8, 1.0>
  rotate -19.632423*z
  translate  <-37.550052, -68.706183, -17.191029>
}
#declare Feuerfontaee3 = union {
  object { Feuerbogen21 }
  object { Feuerbogen22 }
  object { Feuerbogen23 }
  object { Feuerbogen24 }
  object { Feuerbogen25 }
  object { Feuerbogen26 }
  object { Feuerbogen27 }
  material {
    Explosion_4
  }
  no_shadow
  hollow
  scale 0.25
  rotate <92.434021, -0.125458, 156.415878>
  translate  <199.254246, 173.227888, 107.05901>
}
#declare Feuerbogen28 = union {
  cylinder { // Cylndr1133
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -75.0*x
    translate  <0.425241, 20.966603, -88.607482>
  }
  sphere { // Sphere1308
    <0,0,0>,1
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale 5.0
    translate  <0.0, 12.279307, -88.411008>
  }
  cylinder { // Cylndr1134
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -60.0*x
    translate  <0.0, 43.306597, -79.920948>
  }
  cylinder { // Cylndr1135
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -45.0*x
    translate  <0.0, 62.516024, -65.989136>
  }
  cylinder { // Cylndr1136
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -30.0*x
    translate  <0.0, 77.465087, -47.560273>
  }
  cylinder { // Cylndr1137
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -15.0*x
    translate  <0.0, 87.135033, -25.890256>
  }
  cylinder { // Cylndr1138
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    translate  <0.0, 90.86687, -2.455861>
  }
  no_shadow
  hollow
  rotate 21.6742*z
  translate  <101.2435, -85.638191, -17.191029>
}
#declare Feuerbogen29 = union {
  cylinder { // Cylndr1139
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -75.0*x
    translate  <0.0, 21.145897, -88.40628>
  }
  sphere { // Sphere1309
    <0,0,0>,1
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale 5.0
    translate  <0.0, 12.279307, -88.411008>
  }
  cylinder { // Cylndr1140
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -60.0*x
    translate  <0.0, 43.306597, -79.920948>
  }
  cylinder { // Cylndr1141
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -45.0*x
    translate  <0.0, 62.516024, -65.989136>
  }
  cylinder { // Cylndr1142
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -30.0*x
    translate  <0.0, 77.465087, -47.560273>
  }
  cylinder { // Cylndr1143
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -15.0*x
    translate  <0.0, 87.135033, -25.890256>
  }
  cylinder { // Cylndr1144
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    translate  <0.0, 90.86687, -2.455861>
  }
  no_shadow
  hollow
  scale <1.0, 0.8, 1.0>
  rotate <-16.177456, 6.560779, 17.341682>
  translate  <74.007411, -71.470738, 3.196774>
}
#declare Feuerbogen30 = union {
  cylinder { // Cylndr1145
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -75.0*x
    translate  <0.0, 21.145897, -88.40628>
  }
  sphere { // Sphere1310
    <0,0,0>,1
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale 5.0
    translate  <0.0, 12.279307, -88.411008>
  }
  cylinder { // Cylndr1146
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -60.0*x
    translate  <0.0, 43.306597, -79.920948>
  }
  cylinder { // Cylndr1147
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -45.0*x
    translate  <0.0, 62.516024, -65.989136>
  }
  cylinder { // Cylndr1148
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -30.0*x
    translate  <0.0, 77.465087, -47.560273>
  }
  cylinder { // Cylndr1149
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -15.0*x
    translate  <0.0, 87.135033, -25.890256>
  }
  cylinder { // Cylndr1150
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    translate  <0.0, 90.86687, -2.455861>
  }
  no_shadow
  hollow
  rotate 10.287094*z
  translate  <54.773791, -90.86934, -17.191029>
}
#declare Feuerbogen31 = union {
  cylinder { // Cylndr1151
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -75.0*x
    translate  <0.0, 21.145897, -88.40628>
  }
  sphere { // Sphere1311
    <0,0,0>,1
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale 5.0
    translate  <0.0, 12.279307, -88.411008>
  }
  cylinder { // Cylndr1152
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -60.0*x
    translate  <0.0, 43.306597, -79.920948>
  }
  cylinder { // Cylndr1153
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -45.0*x
    translate  <0.0, 62.516024, -65.989136>
  }
  cylinder { // Cylndr1154
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -30.0*x
    translate  <0.0, 77.465087, -47.560273>
  }
  cylinder { // Cylndr1155
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -15.0*x
    translate  <0.0, 87.135033, -25.890256>
  }
  cylinder { // Cylndr1156
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    translate  <0.0, 90.86687, -2.455861>
  }
  no_shadow
  hollow
  scale <1.0, 0.9, 1.0>
  rotate <10.515208, -0.745804, 3.604543>
  translate  <32.462299, -77.130336, -31.235961>
}
#declare Feuerbogen32 = union {
  cylinder { // Cylndr1157
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -75.0*x
    translate  <0.0, 21.145897, -88.40628>
  }
  sphere { // Sphere1312
    <0,0,0>,1
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale 5.0
    translate  <0.0, 12.279307, -88.411008>
  }
  cylinder { // Cylndr1158
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -60.0*x
    translate  <0.0, 43.306597, -79.920948>
  }
  cylinder { // Cylndr1159
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -45.0*x
    translate  <0.0, 62.516024, -65.989136>
  }
  cylinder { // Cylndr1160
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -30.0*x
    translate  <0.0, 77.465087, -47.560273>
  }
  cylinder { // Cylndr1161
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -15.0*x
    translate  <0.0, 87.135033, -25.890256>
  }
  cylinder { // Cylndr1162
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    translate  <0.0, 90.86687, -2.455861>
  }
  no_shadow
  hollow
  scale <1.0, 1.2, 1.0>
  rotate -22.83012*x
  translate  <12.613104, -108.899519, 26.302951>
}
#declare Feuerbogen33 = union {
  cylinder { // Cylndr1163
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -75.0*x
    translate  <0.0, 21.145897, -88.40628>
  }
  sphere { // Sphere1313
    <0,0,0>,1
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale 5.0
    translate  <0.0, 12.279307, -88.411008>
  }
  cylinder { // Cylndr1164
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -60.0*x
    translate  <0.0, 43.306597, -79.920948>
  }
  cylinder { // Cylndr1165
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -45.0*x
    translate  <0.0, 62.516024, -65.989136>
  }
  cylinder { // Cylndr1166
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -30.0*x
    translate  <0.0, 77.465087, -47.560273>
  }
  cylinder { // Cylndr1167
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -15.0*x
    translate  <0.0, 87.135033, -25.890256>
  }
  cylinder { // Cylndr1168
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    translate  <0.0, 90.86687, -2.455861>
  }
  no_shadow
  hollow
  rotate <-2.028563, -0.133037, -3.750632>
  translate  <-7.851664, -93.30393, -12.207344>
}
#declare Feuerbogen34 = union {
  cylinder { // Cylndr1169
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -75.0*x
    translate  <0.0, 21.145897, -88.40628>
  }
  sphere { // Sphere1314
    <0,0,0>,1
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale 5.0
    translate  <0.0, 12.279307, -88.411008>
  }
  cylinder { // Cylndr1170
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -60.0*x
    translate  <0.0, 43.306597, -79.920948>
  }
  cylinder { // Cylndr1171
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -45.0*x
    translate  <0.0, 62.516024, -65.989136>
  }
  cylinder { // Cylndr1172
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -30.0*x
    translate  <0.0, 77.465087, -47.560273>
  }
  cylinder { // Cylndr1173
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -15.0*x
    translate  <0.0, 87.135033, -25.890256>
  }
  cylinder { // Cylndr1174
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    translate  <0.0, 90.86687, -2.455861>
  }
  no_shadow
  hollow
  scale <1.0, 0.8, 1.0>
  rotate -19.632423*z
  translate  <-37.550052, -68.706183, -17.191029>
}
#declare Feuerfontaee4 = union {
  object { Feuerbogen28 }
  object { Feuerbogen29 }
  object { Feuerbogen30 }
  object { Feuerbogen31 }
  object { Feuerbogen32 }
  object { Feuerbogen33 }
  object { Feuerbogen34 }
  material {
    Explosion_4
  }
  no_shadow
  hollow
  scale 0.25
  rotate <92.434021, -0.125458, 144.517258>
  translate  <184.233485, 171.954887, 95.950506>
}
#declare Feuerbogen7 = union {
  cylinder { // Cylndr1175
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -75.0*x
    translate  <0.425241, 20.966603, -88.607482>
  }
  sphere { // Sphere1315
    <0,0,0>,1
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale 5.0
    translate  <0.0, 12.279307, -88.411008>
  }
  cylinder { // Cylndr1176
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -60.0*x
    translate  <0.0, 43.306597, -79.920948>
  }
  cylinder { // Cylndr1177
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -45.0*x
    translate  <0.0, 62.516024, -65.989136>
  }
  cylinder { // Cylndr1178
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -30.0*x
    translate  <0.0, 77.465087, -47.560273>
  }
  cylinder { // Cylndr1179
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -15.0*x
    translate  <0.0, 87.135033, -25.890256>
  }
  cylinder { // Cylndr1180
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    translate  <0.0, 90.86687, -2.455861>
  }
  no_shadow
  hollow
  rotate 21.6742*z
  translate  <101.2435, -85.638191, -17.191029>
}
#declare Feuerbogen8 = union {
  cylinder { // Cylndr1181
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -75.0*x
    translate  <0.0, 21.145897, -88.40628>
  }
  sphere { // Sphere1316
    <0,0,0>,1
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale 5.0
    translate  <0.0, 12.279307, -88.411008>
  }
  cylinder { // Cylndr1182
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -60.0*x
    translate  <0.0, 43.306597, -79.920948>
  }
  cylinder { // Cylndr1183
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -45.0*x
    translate  <0.0, 62.516024, -65.989136>
  }
  cylinder { // Cylndr1184
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -30.0*x
    translate  <0.0, 77.465087, -47.560273>
  }
  cylinder { // Cylndr1185
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -15.0*x
    translate  <0.0, 87.135033, -25.890256>
  }
  cylinder { // Cylndr1186
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    translate  <0.0, 90.86687, -2.455861>
  }
  no_shadow
  hollow
  scale <1.0, 0.8, 1.0>
  rotate <-16.177456, 6.560779, 17.341682>
  translate  <74.007411, -71.470738, 3.196774>
}
#declare Feuerbogen9 = union {
  cylinder { // Cylndr1187
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -75.0*x
    translate  <0.0, 21.145897, -88.40628>
  }
  sphere { // Sphere1317
    <0,0,0>,1
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale 5.0
    translate  <0.0, 12.279307, -88.411008>
  }
  cylinder { // Cylndr1188
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -60.0*x
    translate  <0.0, 43.306597, -79.920948>
  }
  cylinder { // Cylndr1189
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -45.0*x
    translate  <0.0, 62.516024, -65.989136>
  }
  cylinder { // Cylndr1190
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -30.0*x
    translate  <0.0, 77.465087, -47.560273>
  }
  cylinder { // Cylndr1191
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -15.0*x
    translate  <0.0, 87.135033, -25.890256>
  }
  cylinder { // Cylndr1192
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    translate  <0.0, 90.86687, -2.455861>
  }
  no_shadow
  hollow
  rotate 10.287094*z
  translate  <54.773791, -90.86934, -17.191029>
}
#declare Feuerbogen10 = union {
  cylinder { // Cylndr1193
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -75.0*x
    translate  <0.0, 21.145897, -88.40628>
  }
  sphere { // Sphere1318
    <0,0,0>,1
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale 5.0
    translate  <0.0, 12.279307, -88.411008>
  }
  cylinder { // Cylndr1194
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -60.0*x
    translate  <0.0, 43.306597, -79.920948>
  }
  cylinder { // Cylndr1195
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -45.0*x
    translate  <0.0, 62.516024, -65.989136>
  }
  cylinder { // Cylndr1196
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -30.0*x
    translate  <0.0, 77.465087, -47.560273>
  }
  cylinder { // Cylndr1197
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -15.0*x
    translate  <0.0, 87.135033, -25.890256>
  }
  cylinder { // Cylndr1198
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    translate  <0.0, 90.86687, -2.455861>
  }
  no_shadow
  hollow
  scale <1.0, 0.9, 1.0>
  rotate <10.515208, -0.745804, 3.604543>
  translate  <32.462299, -77.130336, -31.235961>
}
#declare Feuerbogen11 = union {
  cylinder { // Cylndr1199
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -75.0*x
    translate  <0.0, 21.145897, -88.40628>
  }
  sphere { // Sphere1319
    <0,0,0>,1
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale 5.0
    translate  <0.0, 12.279307, -88.411008>
  }
  cylinder { // Cylndr1200
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -60.0*x
    translate  <0.0, 43.306597, -79.920948>
  }
  cylinder { // Cylndr1201
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -45.0*x
    translate  <0.0, 62.516024, -65.989136>
  }
  cylinder { // Cylndr1202
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -30.0*x
    translate  <0.0, 77.465087, -47.560273>
  }
  cylinder { // Cylndr1203
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -15.0*x
    translate  <0.0, 87.135033, -25.890256>
  }
  cylinder { // Cylndr1204
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    translate  <0.0, 90.86687, -2.455861>
  }
  no_shadow
  hollow
  scale <1.0, 1.2, 1.0>
  rotate -22.83012*x
  translate  <12.613104, -108.899519, 26.302951>
}
#declare Feuerbogen12 = union {
  cylinder { // Cylndr1205
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -75.0*x
    translate  <0.0, 21.145897, -88.40628>
  }
  sphere { // Sphere1320
    <0,0,0>,1
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale 5.0
    translate  <0.0, 12.279307, -88.411008>
  }
  cylinder { // Cylndr1206
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -60.0*x
    translate  <0.0, 43.306597, -79.920948>
  }
  cylinder { // Cylndr1207
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -45.0*x
    translate  <0.0, 62.516024, -65.989136>
  }
  cylinder { // Cylndr1208
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -30.0*x
    translate  <0.0, 77.465087, -47.560273>
  }
  cylinder { // Cylndr1209
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -15.0*x
    translate  <0.0, 87.135033, -25.890256>
  }
  cylinder { // Cylndr1210
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    translate  <0.0, 90.86687, -2.455861>
  }
  no_shadow
  hollow
  rotate <-2.028563, -0.133037, -3.750632>
  translate  <-7.851664, -93.30393, -12.207344>
}
#declare Feuerbogen13 = union {
  cylinder { // Cylndr1211
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -75.0*x
    translate  <0.0, 21.145897, -88.40628>
  }
  sphere { // Sphere1321
    <0,0,0>,1
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale 5.0
    translate  <0.0, 12.279307, -88.411008>
  }
  cylinder { // Cylndr1212
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -60.0*x
    translate  <0.0, 43.306597, -79.920948>
  }
  cylinder { // Cylndr1213
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -45.0*x
    translate  <0.0, 62.516024, -65.989136>
  }
  cylinder { // Cylndr1214
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -30.0*x
    translate  <0.0, 77.465087, -47.560273>
  }
  cylinder { // Cylndr1215
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -15.0*x
    translate  <0.0, 87.135033, -25.890256>
  }
  cylinder { // Cylndr1216
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    translate  <0.0, 90.86687, -2.455861>
  }
  no_shadow
  hollow
  scale <1.0, 0.8, 1.0>
  rotate -19.632423*z
  translate  <-37.550052, -68.706183, -17.191029>
}
#declare Feuerfontaee1 = union {
  object { Feuerbogen7 }
  object { Feuerbogen8 }
  object { Feuerbogen9 }
  object { Feuerbogen10 }
  object { Feuerbogen11 }
  object { Feuerbogen12 }
  object { Feuerbogen13 }
  material {
    Explosion_4
  }
  no_shadow
  hollow
  scale 0.25
  rotate <92.434021, -0.125458, 142.448242>
  translate  <202.549897, 197.014738, 120.389215>
}
#declare Feuerbogen6 = union {
  cylinder { // Cylndr1217
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -75.0*x
    translate  <0.425241, 20.966603, -88.607482>
  }
  sphere { // Sphere1322
    <0,0,0>,1
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale 5.0
    translate  <0.0, 12.279307, -88.411008>
  }
  cylinder { // Cylndr1218
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -60.0*x
    translate  <0.0, 43.306597, -79.920948>
  }
  cylinder { // Cylndr1219
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -45.0*x
    translate  <0.0, 62.516024, -65.989136>
  }
  cylinder { // Cylndr1220
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -30.0*x
    translate  <0.0, 77.465087, -47.560273>
  }
  cylinder { // Cylndr1221
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -15.0*x
    translate  <0.0, 87.135033, -25.890256>
  }
  cylinder { // Cylndr1222
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    translate  <0.0, 90.86687, -2.455861>
  }
  no_shadow
  hollow
  rotate 21.6742*z
  translate  <101.2435, -85.638191, -17.191029>
}
#declare Feuerbogen5 = union {
  cylinder { // Cylndr1223
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -75.0*x
    translate  <0.0, 21.145897, -88.40628>
  }
  sphere { // Sphere1323
    <0,0,0>,1
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale 5.0
    translate  <0.0, 12.279307, -88.411008>
  }
  cylinder { // Cylndr1224
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -60.0*x
    translate  <0.0, 43.306597, -79.920948>
  }
  cylinder { // Cylndr1225
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -45.0*x
    translate  <0.0, 62.516024, -65.989136>
  }
  cylinder { // Cylndr1226
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -30.0*x
    translate  <0.0, 77.465087, -47.560273>
  }
  cylinder { // Cylndr1227
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -15.0*x
    translate  <0.0, 87.135033, -25.890256>
  }
  cylinder { // Cylndr1228
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    translate  <0.0, 90.86687, -2.455861>
  }
  no_shadow
  hollow
  scale <1.0, 0.8, 1.0>
  rotate <-16.177456, 6.560779, 17.341682>
  translate  <74.007411, -71.470738, 3.196774>
}
#declare Feuerbogen4 = union {
  cylinder { // Cylndr1229
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -75.0*x
    translate  <0.0, 21.145897, -88.40628>
  }
  sphere { // Sphere1324
    <0,0,0>,1
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale 5.0
    translate  <0.0, 12.279307, -88.411008>
  }
  cylinder { // Cylndr1230
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -60.0*x
    translate  <0.0, 43.306597, -79.920948>
  }
  cylinder { // Cylndr1231
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -45.0*x
    translate  <0.0, 62.516024, -65.989136>
  }
  cylinder { // Cylndr1232
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -30.0*x
    translate  <0.0, 77.465087, -47.560273>
  }
  cylinder { // Cylndr1233
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -15.0*x
    translate  <0.0, 87.135033, -25.890256>
  }
  cylinder { // Cylndr1234
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    translate  <0.0, 90.86687, -2.455861>
  }
  no_shadow
  hollow
  rotate 10.287094*z
  translate  <54.773791, -90.86934, -17.191029>
}
#declare Feuerbogen3 = union {
  cylinder { // Cylndr1235
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -75.0*x
    translate  <0.0, 21.145897, -88.40628>
  }
  sphere { // Sphere1325
    <0,0,0>,1
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale 5.0
    translate  <0.0, 12.279307, -88.411008>
  }
  cylinder { // Cylndr1236
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -60.0*x
    translate  <0.0, 43.306597, -79.920948>
  }
  cylinder { // Cylndr1237
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -45.0*x
    translate  <0.0, 62.516024, -65.989136>
  }
  cylinder { // Cylndr1238
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -30.0*x
    translate  <0.0, 77.465087, -47.560273>
  }
  cylinder { // Cylndr1239
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -15.0*x
    translate  <0.0, 87.135033, -25.890256>
  }
  cylinder { // Cylndr1240
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    translate  <0.0, 90.86687, -2.455861>
  }
  no_shadow
  hollow
  scale <1.0, 0.9, 1.0>
  rotate <10.515208, -0.745804, 3.604543>
  translate  <32.462299, -77.130336, -31.235961>
}
#declare Feuerbogen2 = union {
  cylinder { // Cylndr1241
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -75.0*x
    translate  <0.0, 21.145897, -88.40628>
  }
  sphere { // Sphere1326
    <0,0,0>,1
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale 5.0
    translate  <0.0, 12.279307, -88.411008>
  }
  cylinder { // Cylndr1242
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -60.0*x
    translate  <0.0, 43.306597, -79.920948>
  }
  cylinder { // Cylndr1243
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -45.0*x
    translate  <0.0, 62.516024, -65.989136>
  }
  cylinder { // Cylndr1244
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -30.0*x
    translate  <0.0, 77.465087, -47.560273>
  }
  cylinder { // Cylndr1245
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -15.0*x
    translate  <0.0, 87.135033, -25.890256>
  }
  cylinder { // Cylndr1246
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    translate  <0.0, 90.86687, -2.455861>
  }
  no_shadow
  hollow
  scale <1.0, 1.2, 1.0>
  rotate -22.83012*x
  translate  <12.613104, -108.899519, 26.302951>
}
#declare Feuerbogen1 = union {
  cylinder { // Cylndr1247
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -75.0*x
    translate  <0.0, 21.145897, -88.40628>
  }
  sphere { // Sphere1327
    <0,0,0>,1
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale 5.0
    translate  <0.0, 12.279307, -88.411008>
  }
  cylinder { // Cylndr1248
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -60.0*x
    translate  <0.0, 43.306597, -79.920948>
  }
  cylinder { // Cylndr1249
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -45.0*x
    translate  <0.0, 62.516024, -65.989136>
  }
  cylinder { // Cylndr1250
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -30.0*x
    translate  <0.0, 77.465087, -47.560273>
  }
  cylinder { // Cylndr1251
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -15.0*x
    translate  <0.0, 87.135033, -25.890256>
  }
  cylinder { // Cylndr1252
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    translate  <0.0, 90.86687, -2.455861>
  }
  no_shadow
  hollow
  rotate <-2.028563, -0.133037, -3.750632>
  translate  <-7.851664, -93.30393, -12.207344>
}
#declare Feuerbogen = union {
  cylinder { // Cylndr1253
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -75.0*x
    translate  <0.0, 21.145897, -88.40628>
  }
  sphere { // Sphere1328
    <0,0,0>,1
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale 5.0
    translate  <0.0, 12.279307, -88.411008>
  }
  cylinder { // Cylndr1254
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -60.0*x
    translate  <0.0, 43.306597, -79.920948>
  }
  cylinder { // Cylndr1255
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -45.0*x
    translate  <0.0, 62.516024, -65.989136>
  }
  cylinder { // Cylndr1256
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -30.0*x
    translate  <0.0, 77.465087, -47.560273>
  }
  cylinder { // Cylndr1257
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -15.0*x
    translate  <0.0, 87.135033, -25.890256>
  }
  cylinder { // Cylndr1258
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    translate  <0.0, 90.86687, -2.455861>
  }
  no_shadow
  hollow
  scale <1.0, 0.8, 1.0>
  rotate -19.632423*z
  translate  <-37.550052, -68.706183, -17.191029>
}
#declare Feuerfontaee = union {
  object { Feuerbogen6 }
  object { Feuerbogen5 }
  object { Feuerbogen4 }
  object { Feuerbogen3 }
  object { Feuerbogen2 }
  object { Feuerbogen1 }
  object { Feuerbogen }
  material {
    Explosion_4
  }
  no_shadow
  hollow
  scale 0.25
  rotate <92.434021, -0.125458, 87.928558>
  translate  <149.818842, 196.762703, 149.271324>
}
#declare Rauchwolke = union {
  sphere { // Sphere1329
    <0,0,0>,1
    material {
      Rauch_1
    }
    no_shadow
    hollow
    scale 32.930355
    translate  <233.496964, 182.572409, 91.918772>
  }
  sphere { // Sphere1330
    <0,0,0>,1
    material {
      Rauch_1
    }
    no_shadow
    hollow
    scale 32.930355
    translate  <213.707564, 139.973928, 112.674624>
  }
  sphere { // Sphere1331
    <0,0,0>,1
    material {
      Rauch_1
    }
    no_shadow
    hollow
    scale 38.403275
    translate  <254.704425, 150.572269, 164.564254>
  }
  sphere { // Sphere1332
    <0,0,0>,1
    material {
      Rauch_1
    }
    no_shadow
    hollow
    scale <-66.195961, -38.533737, -19.755852>
    rotate <8.359089, -18.640619, 142.111496>
    translate  <253.384059, 201.057903, 186.760983>
  }
}
#declare Feuerbogen14 = union {
  cylinder { // Cylndr1259
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -75.0*x
    translate  <0.425241, 20.966603, -88.607482>
  }
  sphere { // Sphere1333
    <0,0,0>,1
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale 5.0
    translate  <0.0, 12.279307, -88.411008>
  }
  cylinder { // Cylndr1260
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -60.0*x
    translate  <0.0, 43.306597, -79.920948>
  }
  cylinder { // Cylndr1261
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -45.0*x
    translate  <0.0, 62.516024, -65.989136>
  }
  cylinder { // Cylndr1262
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -30.0*x
    translate  <0.0, 77.465087, -47.560273>
  }
  cylinder { // Cylndr1263
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -15.0*x
    translate  <0.0, 87.135033, -25.890256>
  }
  cylinder { // Cylndr1264
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    translate  <0.0, 90.86687, -2.455861>
  }
  no_shadow
  hollow
  rotate 21.6742*z
  translate  <101.2435, -85.638191, -17.191029>
}
#declare Feuerbogen15 = union {
  cylinder { // Cylndr1265
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -75.0*x
    translate  <0.0, 21.145897, -88.40628>
  }
  sphere { // Sphere1334
    <0,0,0>,1
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale 5.0
    translate  <0.0, 12.279307, -88.411008>
  }
  cylinder { // Cylndr1266
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -60.0*x
    translate  <0.0, 43.306597, -79.920948>
  }
  cylinder { // Cylndr1267
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -45.0*x
    translate  <0.0, 62.516024, -65.989136>
  }
  cylinder { // Cylndr1268
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -30.0*x
    translate  <0.0, 77.465087, -47.560273>
  }
  cylinder { // Cylndr1269
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -15.0*x
    translate  <0.0, 87.135033, -25.890256>
  }
  cylinder { // Cylndr1270
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    translate  <0.0, 90.86687, -2.455861>
  }
  no_shadow
  hollow
  scale <1.0, 0.8, 1.0>
  rotate <-16.177456, 6.560779, 17.341682>
  translate  <74.007411, -71.470738, 3.196774>
}
#declare Feuerbogen16 = union {
  cylinder { // Cylndr1271
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -75.0*x
    translate  <0.0, 21.145897, -88.40628>
  }
  sphere { // Sphere1335
    <0,0,0>,1
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale 5.0
    translate  <0.0, 12.279307, -88.411008>
  }
  cylinder { // Cylndr1272
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -60.0*x
    translate  <0.0, 43.306597, -79.920948>
  }
  cylinder { // Cylndr1273
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -45.0*x
    translate  <0.0, 62.516024, -65.989136>
  }
  cylinder { // Cylndr1274
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -30.0*x
    translate  <0.0, 77.465087, -47.560273>
  }
  cylinder { // Cylndr1275
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -15.0*x
    translate  <0.0, 87.135033, -25.890256>
  }
  cylinder { // Cylndr1276
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    translate  <0.0, 90.86687, -2.455861>
  }
  no_shadow
  hollow
  rotate 10.287094*z
  translate  <54.773791, -90.86934, -17.191029>
}
#declare Feuerbogen17 = union {
  cylinder { // Cylndr1277
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -75.0*x
    translate  <0.0, 21.145897, -88.40628>
  }
  sphere { // Sphere1336
    <0,0,0>,1
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale 5.0
    translate  <0.0, 12.279307, -88.411008>
  }
  cylinder { // Cylndr1278
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -60.0*x
    translate  <0.0, 43.306597, -79.920948>
  }
  cylinder { // Cylndr1279
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -45.0*x
    translate  <0.0, 62.516024, -65.989136>
  }
  cylinder { // Cylndr1280
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -30.0*x
    translate  <0.0, 77.465087, -47.560273>
  }
  cylinder { // Cylndr1281
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -15.0*x
    translate  <0.0, 87.135033, -25.890256>
  }
  cylinder { // Cylndr1282
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    translate  <0.0, 90.86687, -2.455861>
  }
  no_shadow
  hollow
  scale <1.0, 0.9, 1.0>
  rotate <10.515208, -0.745804, 3.604543>
  translate  <32.462299, -77.130336, -31.235961>
}
#declare Feuerbogen18 = union {
  cylinder { // Cylndr1283
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -75.0*x
    translate  <0.0, 21.145897, -88.40628>
  }
  sphere { // Sphere1337
    <0,0,0>,1
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale 5.0
    translate  <0.0, 12.279307, -88.411008>
  }
  cylinder { // Cylndr1284
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -60.0*x
    translate  <0.0, 43.306597, -79.920948>
  }
  cylinder { // Cylndr1285
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -45.0*x
    translate  <0.0, 62.516024, -65.989136>
  }
  cylinder { // Cylndr1286
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -30.0*x
    translate  <0.0, 77.465087, -47.560273>
  }
  cylinder { // Cylndr1287
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -15.0*x
    translate  <0.0, 87.135033, -25.890256>
  }
  cylinder { // Cylndr1288
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    translate  <0.0, 90.86687, -2.455861>
  }
  no_shadow
  hollow
  scale <1.0, 1.2, 1.0>
  rotate -22.83012*x
  translate  <12.613104, -108.899519, 26.302951>
}
#declare Feuerbogen19 = union {
  cylinder { // Cylndr1289
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -75.0*x
    translate  <0.0, 21.145897, -88.40628>
  }
  sphere { // Sphere1338
    <0,0,0>,1
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale 5.0
    translate  <0.0, 12.279307, -88.411008>
  }
  cylinder { // Cylndr1290
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -60.0*x
    translate  <0.0, 43.306597, -79.920948>
  }
  cylinder { // Cylndr1291
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -45.0*x
    translate  <0.0, 62.516024, -65.989136>
  }
  cylinder { // Cylndr1292
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -30.0*x
    translate  <0.0, 77.465087, -47.560273>
  }
  cylinder { // Cylndr1293
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -15.0*x
    translate  <0.0, 87.135033, -25.890256>
  }
  cylinder { // Cylndr1294
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    translate  <0.0, 90.86687, -2.455861>
  }
  no_shadow
  hollow
  rotate <-2.028563, -0.133037, -3.750632>
  translate  <-7.851664, -93.30393, -12.207344>
}
#declare Feuerbogen20 = union {
  cylinder { // Cylndr1295
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -75.0*x
    translate  <0.0, 21.145897, -88.40628>
  }
  sphere { // Sphere1339
    <0,0,0>,1
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale 5.0
    translate  <0.0, 12.279307, -88.411008>
  }
  cylinder { // Cylndr1296
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -60.0*x
    translate  <0.0, 43.306597, -79.920948>
  }
  cylinder { // Cylndr1297
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -45.0*x
    translate  <0.0, 62.516024, -65.989136>
  }
  cylinder { // Cylndr1298
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -30.0*x
    translate  <0.0, 77.465087, -47.560273>
  }
  cylinder { // Cylndr1299
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -15.0*x
    translate  <0.0, 87.135033, -25.890256>
  }
  cylinder { // Cylndr1300
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    translate  <0.0, 90.86687, -2.455861>
  }
  no_shadow
  hollow
  scale <1.0, 0.8, 1.0>
  rotate -19.632423*z
  translate  <-37.550052, -68.706183, -17.191029>
}
#declare Feuerfontaee2 = union {
  object { Feuerbogen14 }
  object { Feuerbogen15 }
  object { Feuerbogen16 }
  object { Feuerbogen17 }
  object { Feuerbogen18 }
  object { Feuerbogen19 }
  object { Feuerbogen20 }
  material {
    Explosion_4
  }
  no_shadow
  hollow
  scale 0.25
  rotate <92.434021, -0.125458, 175.407288>
  translate  <198.263136, 162.512555, 124.832616>
}
#declare Feuerbogen35 = union {
  cylinder { // Cylndr1301
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -75.0*x
    translate  <0.425241, 20.966603, -88.607482>
  }
  sphere { // Sphere1340
    <0,0,0>,1
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale 5.0
    translate  <0.0, 12.279307, -88.411008>
  }
  cylinder { // Cylndr1302
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -60.0*x
    translate  <0.0, 43.306597, -79.920948>
  }
  cylinder { // Cylndr1303
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -45.0*x
    translate  <0.0, 62.516024, -65.989136>
  }
  cylinder { // Cylndr1304
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -30.0*x
    translate  <0.0, 77.465087, -47.560273>
  }
  cylinder { // Cylndr1305
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -15.0*x
    translate  <0.0, 87.135033, -25.890256>
  }
  cylinder { // Cylndr1306
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    translate  <0.0, 90.86687, -2.455861>
  }
  no_shadow
  hollow
  rotate 21.6742*z
  translate  <101.2435, -85.638191, -17.191029>
}
#declare Feuerbogen36 = union {
  cylinder { // Cylndr1307
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -75.0*x
    translate  <0.0, 21.145897, -88.40628>
  }
  sphere { // Sphere1341
    <0,0,0>,1
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale 5.0
    translate  <0.0, 12.279307, -88.411008>
  }
  cylinder { // Cylndr1308
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -60.0*x
    translate  <0.0, 43.306597, -79.920948>
  }
  cylinder { // Cylndr1309
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -45.0*x
    translate  <0.0, 62.516024, -65.989136>
  }
  cylinder { // Cylndr1310
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -30.0*x
    translate  <0.0, 77.465087, -47.560273>
  }
  cylinder { // Cylndr1311
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -15.0*x
    translate  <0.0, 87.135033, -25.890256>
  }
  cylinder { // Cylndr1312
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    translate  <0.0, 90.86687, -2.455861>
  }
  no_shadow
  hollow
  scale <1.0, 0.8, 1.0>
  rotate <-16.177456, 6.560779, 17.341682>
  translate  <74.007411, -71.470738, 3.196774>
}
#declare Feuerbogen37 = union {
  cylinder { // Cylndr1313
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -75.0*x
    translate  <0.0, 21.145897, -88.40628>
  }
  sphere { // Sphere1342
    <0,0,0>,1
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale 5.0
    translate  <0.0, 12.279307, -88.411008>
  }
  cylinder { // Cylndr1314
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -60.0*x
    translate  <0.0, 43.306597, -79.920948>
  }
  cylinder { // Cylndr1315
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -45.0*x
    translate  <0.0, 62.516024, -65.989136>
  }
  cylinder { // Cylndr1316
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -30.0*x
    translate  <0.0, 77.465087, -47.560273>
  }
  cylinder { // Cylndr1317
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -15.0*x
    translate  <0.0, 87.135033, -25.890256>
  }
  cylinder { // Cylndr1318
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    translate  <0.0, 90.86687, -2.455861>
  }
  no_shadow
  hollow
  rotate 10.287094*z
  translate  <54.773791, -90.86934, -17.191029>
}
#declare Feuerbogen38 = union {
  cylinder { // Cylndr1319
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -75.0*x
    translate  <0.0, 21.145897, -88.40628>
  }
  sphere { // Sphere1343
    <0,0,0>,1
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale 5.0
    translate  <0.0, 12.279307, -88.411008>
  }
  cylinder { // Cylndr1320
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -60.0*x
    translate  <0.0, 43.306597, -79.920948>
  }
  cylinder { // Cylndr1321
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -45.0*x
    translate  <0.0, 62.516024, -65.989136>
  }
  cylinder { // Cylndr1322
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -30.0*x
    translate  <0.0, 77.465087, -47.560273>
  }
  cylinder { // Cylndr1323
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -15.0*x
    translate  <0.0, 87.135033, -25.890256>
  }
  cylinder { // Cylndr1324
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    translate  <0.0, 90.86687, -2.455861>
  }
  no_shadow
  hollow
  scale <1.0, 0.9, 1.0>
  rotate <10.515208, -0.745804, 3.604543>
  translate  <32.462299, -77.130336, -31.235961>
}
#declare Feuerbogen39 = union {
  cylinder { // Cylndr1325
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -75.0*x
    translate  <0.0, 21.145897, -88.40628>
  }
  sphere { // Sphere1344
    <0,0,0>,1
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale 5.0
    translate  <0.0, 12.279307, -88.411008>
  }
  cylinder { // Cylndr1326
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -60.0*x
    translate  <0.0, 43.306597, -79.920948>
  }
  cylinder { // Cylndr1327
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -45.0*x
    translate  <0.0, 62.516024, -65.989136>
  }
  cylinder { // Cylndr1328
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -30.0*x
    translate  <0.0, 77.465087, -47.560273>
  }
  cylinder { // Cylndr1329
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -15.0*x
    translate  <0.0, 87.135033, -25.890256>
  }
  cylinder { // Cylndr1330
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    translate  <0.0, 90.86687, -2.455861>
  }
  no_shadow
  hollow
  scale <1.0, 1.2, 1.0>
  rotate -22.83012*x
  translate  <12.613104, -108.899519, 26.302951>
}
#declare Feuerbogen40 = union {
  cylinder { // Cylndr1331
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -75.0*x
    translate  <0.0, 21.145897, -88.40628>
  }
  sphere { // Sphere1345
    <0,0,0>,1
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale 5.0
    translate  <0.0, 12.279307, -88.411008>
  }
  cylinder { // Cylndr1332
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -60.0*x
    translate  <0.0, 43.306597, -79.920948>
  }
  cylinder { // Cylndr1333
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -45.0*x
    translate  <0.0, 62.516024, -65.989136>
  }
  cylinder { // Cylndr1334
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -30.0*x
    translate  <0.0, 77.465087, -47.560273>
  }
  cylinder { // Cylndr1335
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -15.0*x
    translate  <0.0, 87.135033, -25.890256>
  }
  cylinder { // Cylndr1336
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    translate  <0.0, 90.86687, -2.455861>
  }
  no_shadow
  hollow
  rotate <-2.028563, -0.133037, -3.750632>
  translate  <-7.851664, -93.30393, -12.207344>
}
#declare Feuerbogen41 = union {
  cylinder { // Cylndr1337
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -75.0*x
    translate  <0.0, 21.145897, -88.40628>
  }
  sphere { // Sphere1346
    <0,0,0>,1
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale 5.0
    translate  <0.0, 12.279307, -88.411008>
  }
  cylinder { // Cylndr1338
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -60.0*x
    translate  <0.0, 43.306597, -79.920948>
  }
  cylinder { // Cylndr1339
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -45.0*x
    translate  <0.0, 62.516024, -65.989136>
  }
  cylinder { // Cylndr1340
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -30.0*x
    translate  <0.0, 77.465087, -47.560273>
  }
  cylinder { // Cylndr1341
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    rotate -15.0*x
    translate  <0.0, 87.135033, -25.890256>
  }
  cylinder { // Cylndr1342
    <0,0,1>, <0,0,0>, 1 
    material {
      Explosion_4
    }
    no_shadow
    hollow
    scale <2.0, 2.0, 20.0>
    translate  <0.0, 90.86687, -2.455861>
  }
  no_shadow
  hollow
  scale <1.0, 0.8, 1.0>
  rotate -19.632423*z
  translate  <-37.550052, -68.706183, -17.191029>
}
#declare Feuerfontaee5 = union {
  object { Feuerbogen35 }
  object { Feuerbogen36 }
  object { Feuerbogen37 }
  object { Feuerbogen38 }
  object { Feuerbogen39 }
  object { Feuerbogen40 }
  object { Feuerbogen41 }
  material {
    Explosion_4
  }
  no_shadow
  hollow
  scale 0.2
  rotate <76.408394, 2.11595, -172.22879>
  translate  <191.627305, 151.395418, 94.156715>
}
union { // Explosionswolke
  object { Explosionsbasis }
  object { Explosionspilz }
  object { Feuerfontaee3 }
  object { Feuerfontaee4 }
  object { Feuerfontaee1 }
  object { Feuerfontaee }
  object { Rauchwolke }
  object { Feuerfontaee2 }
  object { Feuerfontaee5 }
  translate  <25.804591, 15.769472, 12.902295>
}


