//  Persistance of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 3 lights, 5 materials and 10 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.1 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//  Date : 04/25/1999    (25.04.1999)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray V3.1 For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,0.666667,0.517647>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam
  location  <      2.969,       4.962,       0.445>
  direction <        0.0,         0.0,      1.8317> // Aperture is 0.53 degrees
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33333,         0.0,         0.0> // Aspect ratio
  look_at   <      0.906,      -1.330,       0.069>
}

//
// *******  L I G H T S *******
//

light_source {   // Light001
  <-0.759, -4.583, 155.498>
  color rgb <1.000, 0.750, 0.000>
}

light_source {   // Spotlight Spotlight001
  <-1.034, -4.408, 0.808>
  color rgb <1.000, 0.800, 0.000>
  spotlight
    point_at  <-0.422, -2.511, 0.649>
    falloff    15.000  // outer radius (in deg)
    radius     7.500  // inner radius
    tightness  0.000
}

light_source {   // Light1
  <-47.902, -160.967, 1.191>
  color rgb <1.000, 0.700, 0.000>
}


//
// ********  MATERIALS  *******
//

#include "piramidi.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare Fiume = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  27  // control points
  <4.959734, -46.217516>,
  <-5.220245, -11.776173>,
  <-3.7601, -6.972296>,
  <-2.712481, -5.118643>,
  <-2.332775, -2.683152>,
  <-1.477048, -1.505953>,
  <-0.233474, -1.423242>,
  <0.147825, 0.431595>,
  <1.607124, 1.615312>,
  <2.643408, 3.360617>,
  <0.698017, 5.650121>,
  <-1.986062, 9.991789>,
  <-1.58875, 10.756278>,
  <0.684555, 7.61101>,
  <1.706518, 5.746755>,
  <3.538206, 3.049481>,
  <2.323538, 1.068376>,
  <0.883098, 0.079635>,
  <0.901536, -1.254358>,
  <-1.606012, -3.267677>,
  <-2.841502, -7.200211>,
  <-4.288835, -10.573851>,
  <-2.860765, -15.930839>,
  <6.173868, -47.213785>,
  <4.959734, -46.217516>,
  <-5.220245, -11.776173>,
  <-3.7601, -6.972296>
  rotate -x*90
  material {
    Terra
  }
  scale <0.621507, 0.6, 0.15>
  rotate 4.704729*z
  translate  <2.19492, -0.743789, -0.011991>
}




//
// ********  OBJECTS  *******
//

#declare sky_vect = <0.00000, 0.00000, 1.00000>;
#declare cam_loc = <2.969, 4.962, 0.445>;  // using camera 'StdCam'
#declare lookat = <0.906, -1.330, 0.069>;
#declare light_loc = <-47.90174, -160.96715, 1.19054>;  // using light source 'Light1'

#declare flare_size = 0.800;
#declare bright_background = 0;
#declare flare_brightness = 1.000;
// Note: if the following two lines cause an error, make sure that
// you have the NKFlare\ subdirectory in the directory where you are
// exporting POV-files to.
#include "NKFlare\Sunset1.flr"
#include "NKFlare\nkflare.inc"


object { // Fiume2->Fiume
  Fiume
  material {
    Acqua
  }
  scale <1.0, 1.0, 0.65>
}






#declare terra_con_buco_fiume = difference {
  box { // Piano_Terreno
    <-1, -1, -1>, <1, 1, 1>
    material {
      Terra
    }
    scale <194.86731, 181.562698, 0.3>
    translate  -0.2*z
  }
  object { Fiume }
}
union { // Land
  object { terra_con_buco_fiume }
  material {
    Terra
  }
}


prism { // Piramide
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  material {
    Piramid
  }
  scale <0.904072, -0.980603, 1.404121>
  rotate <-180.0, 0.0, 0.0>
  translate  <0.618657, 0.02278, 1.404121>
}


prism { // Piramide_lontana
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  material {
    Piramide_lontan
  }
  scale <0.767594, 0.755552, 1.228361>
  rotate <-0.0, -180.0, 333.296356>
  translate  <2.388897, -3.74834, 1.242473>
}


sky_sphere { // sfera_cielo
      pigment
      {
         gradient z
         color_map
         {
            [ 0.0     rgbft <0.213333, 0.213333, 1.0, 0.0, 0.0> ]
            [ 0.694149  rgbft <0.213333, 0.213333, 1.0, 0.0, 0.0> ]
            [ 0.946809  rgbft <1.0, 0.22, 0.06, 0.0, 0.0> ]
            [ 0.998   rgbft <1.0, 0.666667, 0.0, 0.0, 0.0> ]
            [ 0.999   rgbft <0.906667, 0.834133, 0.0, 0.0, 0.0> ]
            [ 1.0     rgbft <0.906667, 0.834133, 0.0, 0.0, 0.0> ]
         }
      rotate    <-90.0, 0.0, -17.5>
      }   
      pigment
      {
         bozo
         color_map
         {
            [ 0.0     rgbft <0.0, 0.0, 1.0, 1.0, 1.0> ]
            [ 1.0     rgbft <1.0, 1.0, 1.0, 0.0, 0.0> ]
         }
         turbulence 1.0
         frequency 0.8
         triangle_wave
         scale  <1.0, 1.0, 0.1>
      }

}




