// Persistence of Vision Ray Tracer Scene Description File
// File: mg_tut.pov
// Vers: 3.1
// Desc: Carter before Tutankhamon/Carter ante Tutankhamon
// Date: April 21, 1999 /Abril 21, 1999 
// Auth: Marjorie Diez de Graterol
 
 
 // ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions


global_settings{assumed_gamma 2.0}

background { Black }


camera {
 
  location  <-3, 7.5,-15.5> 
  up        y                
  right     4/3*x  
  look_at   <2.0, 1, 5>   
  aperture 1.0
  focal_point <2.5, 3.5, 5>
}
 
 
  fog {
    fog_type 2 
    distance 20
    color CornflowerBlue
 turbulence 0.01
 turb_depth 0.2
 fog_offset 0.2
 fog_alt 0.2
  }


#include "mg_tut0.inc"
//doordecoration/cresta puerta 

object {cresta rotate 45*y scale <3,2,3> 
translate <18,8,10>
} 

//floor/suelo
object{muro scale <50,1,50> translate <-20,-3,30>}
#declare muro2=
object {muro scale <25,1,20> rotate <90,0,0> translate <0,0,0>}

//first plane wall/muro primer plano
object {muro2 
translate <-20,-3.5,1>}

object {muro2 rotate 45*y translate <9,-4,20>}

object {muro2 rotate 45*y translate <-23,-4,-6>} 

//Osiris front wall/Osiris muro primer plano

object{cubierta scale <5,6,5> translate <-8.5,-1.95,0.272>}
  
//Light_Sources/Luces

object{lamps}

//armoire armario
box{<-1,-1,-1><1,1,-0.5>scale <3,5,3> 
rotate 45*y
translate <5.5,0,5> 
texture {chains} 
}

//cylinder tut
cylinder
{
  -1*y,  1.5*y,  2.5
  // open
  scale <1,1.25,2>
  translate <-4,-3,-12.5>
  texture {cyl}
}

#include "beard.inc"

object{beard texture {Acuarius5} scale 2 
rotate 90*x 
translate <-4.225,-0.95,-4> } 


//anubis/ibidem

#include "mg_tut1.inc"
object {anubis rotate 45*y translate <11.9,4.75,3.9>} // <10,6,3.5>

//tutankhamon/ibidem

#include "mg_tut2.inc" 

object {tut scale 2 
rotate -10*z  
translate <-4.5,-0.75,-4> 
}

//anubis table/mesa anubis
#include "mg_tut3.inc"
object {porta  scale <3.8,3.5,4> rotate 45*y translate <11,-0.80,3.5>}

//coffin/sarcofago
 
#include "mg_tut4.inc"

object{coffin scale 2.1//<2.2,1.10,2.9> 
rotate -10*z 
translate <-4.25,1,-4>} 

//chests /baules
#include "mg_tut5.inc"
object{chest scale 3 rotate 43*y translate <19,-1.5,5>} 

object{chest scale 4.5 rotate 60*y translate <13,-0.5,11.6>} // 

#include "mg_tut6.inc" 
//front right/primer plano derecha
object{peroles1 scale <2,4,2> rotate 10*z translate <9,1,-6>}

// front/primer plano
object{peroles1 scale <2,4,2> rotate 10*z translate <-8,1,-2>}

//chest side/al lado del baul
object{peroles1 scale <2,4,2> rotate 10*z translate <12.5,-0.5,12.5>}
object{peroles1 scale <2,4,2> rotate 10*z translate <12.5,3,12.5>}

//needs povpeople.inc  
#include "carter.inc" 
object{ Person  scale <1,1.2,1> 
translate <-3,1,-15> } //0


//hat/sombrero
#include "hat.inc"
object {hat scale 2 rotate 5*z translate <-3,6.55,-15>} 

#include "finish.inc"

#declare puerta=
box{<-1,-1,-1><10,12,-0.95>
texture{
pigment{Gray30}
finish{Mirror 
} 
}}

object {puerta  rotate 45*y  translate <17,-3,12>} 








