// File mg_tut0.inc

//textura paredes tut
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions


#declare muro=

height_field
{
  tga               
  "wall4sol.tga"     
  smooth        
  texture  
   {   
      pigment
      {
         granite
         color_map
         {
            [ 0.0     rgbft <1.0, 1.0, 1.0, 1.0, 0.0> ]
            [ 0.72    rgbft <1.0, 1.0, 1.0, 1.0, 0.0> ]
            [ 0.72    rgbft <0.929412, 0.823529, 0.505882, 0.0, 0.0> ]
            [ 0.78777  rgbft <0.670588, 0.658824, 0.427451, 0.0, 0.0> ]
            [ 0.91    rgbft <0.796078, 0.627451, 0.572549, 0.0, 0.0> ]
            [ 0.91    rgbft <1.0, 1.0, 1.0, 1.0, 0.0> ]
            [ 1.0     rgbft <1.0, 1.0, 1.0, 1.0, 0.0> ]
         }
         scale  0.015
      }   
      finish
      {
         ambient 0.1
         diffuse 0.5
      }
   }
   texture  // muro1
   {   
      pigment
      {
         color rgb <1.0, 0.952941, 0.835294>
      }   
      normal
      {
         bumps , 0.58
         frequency 150
         phase 4//2
         scale  0.02
      }   
      finish
      {
         ambient 0.1
         diffuse 0.5         
      }
   }
rotate 180*x 
translate <0,0,0>
}

#declare pared1a=
texture{ 

pigment{
image_map
{
  tga "osiris.tga" 
  map_type 0 
  interpolate 2 
  once
} 
}

normal {bumps 0.8}
finish {ambient 0.6 diffuse 0.4}
scale 2
}


#declare cubierta=
box{<-1,-1,-0.05><3,2,0> hollow texture{pared1a} 

}

#declare pared_b= 
box {<-7,-1,-1><14,10,1> hollow}

#declare ed_b=
union{  object {pared_b translate 10*z }
        object {pared_b translate <-20,0,10>} 
     }

 //cresta puerta
 #declare modu=
union{
intersection{
sphere {<0,0.5,0>0.20 hollow} 
sphere {<0,0.5,0>0.20 hollow translate <0.10,0,0>}
translate <0,0,0>}

cylinder{0*y 0.70*y, 0.05 hollow translate <0.05,0.10,0>}
}

#declare cresta=
union{
object {modu translate -1*x }
object {modu translate -0.25*x }
object {modu translate -0.50*x }
object {modu translate -0.75*x }
object {modu translate 0*x }
object {modu translate 0.25*x }
object {modu translate 0.50*x }
object {modu translate 0.75*x }
object {modu translate 1*x }
texture{Gold_Nugget}}

//object{cresta }

#declare rj9= color red	0.909803922	green 0.501960784	blue 0.070588235;


#declare Oro=
texture{

pigment{ rj9
}
finish {
    ambient 0.1
    brilliance 6
    diffuse 0.9
    metallic
    specular 0.80
    roughness 1/120
    reflection 0.8
}
			
}
//Light Sources / Luces
#declare lamps=
union{

light_source//one/uno
{
  0*x                    
  color Gold+Brown
  spotlight               
  translate <0,25,-1> 
  point_at <0,0,0>      
  radius 10                
  tightness 20            
  falloff 100              
  media_attenuation on
}

light_source//two/dos
{
  0*x                     
  color Gold+Brown       
  spotlight               
  translate <-1,24,10> 
  point_at <0,0,0>      
  radius 100                
  tightness 20            
  falloff 360               
    media_attenuation on
}


light_source//three/tres
{
  0*x                     
  color CornflowerBlue       
  spotlight               
  translate <11,24,1.5> 
  point_at <13,2,1.5>      
  radius 100                
  tightness 20            
  falloff 360               
  media_attenuation on
}                                                                           


light_source//four/cuatro
{
  0*x                     
  color Gold+Brown
  spotlight               
  translate <-1,24,10> 
  point_at <15,-3,8>      
  radius 100                
  tightness 20            
  falloff 360               
  media_attenuation on
}

light_source//five/cinco
{
  0*x                     
  color Gold+CornflowerBlue
  spotlight               
  translate <12,24,4> 
  point_at <11.9,4.85,3.9>      
  radius 10                
  tightness 20            
  falloff 90               
    media_attenuation on
}

 
 light_source//six/seis
{
  0*x                     
  color Gray20
  spotlight               
  translate <14,0,-18.01> 
  point_at <-3,6.55,-15>      
  radius 30                
  tightness 60           
  falloff 220               
    media_attenuation on
}
 }

//otra

//from emetex.inc
#declare lapislazuli=color red 0.35294   green 0.596078  blue 0.603922   ;
#declare Acuarius5=
texture {
  pigment { 
  spiral1 12
    turbulence 0.5
    scale 6
    color_map { 
    [0.225 lapislazuli ] 
    [0.25 Gold filter 0.5]  
    [0.275 Clear]
    [0.725 Clear]
    [0.75 Gold filter 0.5] 
    [0.775 lapislazuli]
  }
    rotate <90,0,0>
    translate <0,1,0>
  } normal {ripples 0.5 turbulence 0.8 scale 0.5}
  
  finish{ambient 0.6 diffuse 0.4 phong 0.8 }
}

texture {
  pigment { 
  spiral1 12
    turbulence 0.5
    scale 6
    color_map { 
    [0.225 lapislazuli ] 
    [0.25 Gold filter 0.5]  
    [0.275 Clear]
    [0.725 Clear]
    [0.75 Gold filter 0.5]  
    [0.775 lapislazuli]
  }
    rotate <0,90,0>
    translate <0,0.50,0>
  }normal {ripples 0.5 turbulence 0.8 scale 0.5}
  
  finish{ambient 0.6 diffuse 0.4 phong 0.8 }
}


texture {
  pigment { 
  spiral1 12
     turbulence 0.5
    scale 6
    color_map { 
    [0.225 lapislazuli ]
    [0.25 Gold filter 0.5]  
    [0.275 Clear]
    [0.725 Clear]
    [0.75 Gold filter 0.5]  
    [0.775 lapislazuli]
  }
    rotate <0,0,90>
    }normal {wood 0.5 turbulence 0.8 scale 0.5}
  
  finish{ambient 0.6 diffuse 0.4 phong 0.8 } 
  
  
 }

#declare chains=
  texture {Oro}
texture {
  pigment { 
  spiral2 12
    turbulence 0.1
    frequency 7
    scale 3
    color_map { //softer edged color map
    [0.225 DarkTan ] //slightly green ???
    [0.25 VeryDarkBrown filter 0.5]  //added
    [0.275 Clear]
    [0.725 Clear]
    [0.75 VeryDarkBrown filter 0.5]  //added
    [0.775 DarkTan]
  }
    rotate <90,0,0>
    //translate <0,0.5,1>//rotate <90,0,0>
  } normal {wood 0.5 turbulence 0.8 scale 0.5}
  
  finish{ambient 0.6 diffuse 0.4 phong 0.8 }
}

texture {
  pigment { 
  spiral2 12
    turbulence 0.1
    frequency 7
    scale 3
    color_map { //softer edged color map
    [0.225 VeryDarkBrown] //slightly green ???
    [0.25 IndianRed filter 0.5]  //added
    [0.275 Clear]
    [0.725 Clear]
    [0.75 IndianRed filter 0.5]  //added
    [0.775 VeryDarkBrown]
  }
    rotate <0,45,0>
    //translate <0,1,0>//rotate <90,0,0>
  }normal {wood 0.5 turbulence 0.8 scale 0.5}
  
  finish{ambient 0.6 diffuse 0.4 phong 0.8 
  }
}


#declare cyl=
texture {
  pigment { 
  spiral2 12
    turbulence 0.8
    frequency 7
    color_map { 
    [0.225 rgbf <0.85, 0.85,0.10, 0.0>] 
    [0.25 rgbf <1.0, 1.0, 1.0, 0.5>]  
    [0.275 rgbf <1.0, 1.0, 1.0, 1.0>]
    [0.725 rgbf <1.0, 1.0, 1.0, 1.0>]
    [0.75 rgbf <1.0, 1.0, 1.0, 0.5>]  
    [0.775 rgbf <0.85, 0.85,0.10, 0.0>]
  }
    rotate <90,0,0>
  }
}


texture {
  pigment { 
  spiral2 12
    
    frequency 5
    color_map { 
    [0.225 rgbf <0.85, 0.85,0.10, 0.0>]
    [0.25 rgbf <1.0, 1.0, 1.0, 0.5>]  
    [0.275 rgbf <1.0, 1.0, 1.0, 1.0>]
    [0.725 rgbf <1.0, 1.0, 1.0, 1.0>]
    [0.75 rgbf <1.0, 1.0, 1.0, 0.5>]  
    [0.775 rgbf <0.85, 0.85,0.10, 0.0>]
  }
    rotate <0,90,0>} 
    
  finish {ambient 0.3 diffuse 0.2 specular 0.8 metallic}}



//Tela-cloth
 //from emetex.inc
/*For the last round -Imaginary Worlds- I asked Jaime Vives for a spiral staircase.

I did not use the one he helped me with, but I did noticed the way the transformed
the texture. I took those transformations and applied them to another
texture I was working with-ariadna- and which I used in the same round -mg_olymp-.
TELA (Fabric)is the result*/
#declare rr=seed(4637);
#declare tela=


texture {
  pigment {
    spiral1 12
    //turbulence 0.2
    frequency rand(rr)//50//20
    scale 6//esta escala es para el tejido scale 10
    color_map {
    [0.25 rgbf <1.0, 1.0, 1.0, 0.0>]
    [0.25 rgbf <1.0, 1.0, 1.0, 1.0>]
    [0.75 rgbf <1.0, 1.0, 1.0, 1.0>]
    [0.75 rgbf <1.0, 1.0, 1.0, 0.0>]
  }
    rotate 90*y
    translate rand(rr)
    
    //
  }
}
texture {
  pigment {
    spiral1 12 //spiral2
    //turbulence 0.2
    frequency rand(rr)//50//20
    scale 6//ibidem scale 10
    color_map {
    [0.25 rgbf <1.0, 1.0, 1.0, 0.0>]
    [0.25 rgbf <1.0, 1.0, 1.0, 1.0>]
    [0.75 rgbf <1.0, 1.0, 1.0, 1.0>]
    [0.75 rgbf <1.0, 1.0, 1.0, 0.0>]
  }
    
     rotate 90*x
   
   translate <-10+20*rand(rr),-10+20*rand(rr),-100+200*rand(rr)>
    //
  }
  
  normal {bumps 0.6}
  finish {crand 0.2}//ambient 0.2 diffuse 0.2}
}

//modified from povlab
#declare Jade_mod = texture {
  pigment {
    marble
    turbulence 2.3
    color_map {
      [0.0 0.8 color rgb <0, 0, 0>
      color rgb <0.0, 0.6, 0.6>]
      [0.8 0.9 color rgb <0.0, 0.6, 0.6>
      color rgb <0.6, 0.0, 0.0>]
      [0.9 1 color rgb <0.6, 0.0, 0.0>
      color rgb <0, 0, 0>]
    }
  }
  finish {
    ambient .5
    diffuse .5
    //reflection 0.1
    phong .7
    phong_size 80
    specular 0.2
    roughness 0.2
  }
}

// >>> Candelar_Texture (from File "povlab.inc") <<<
#declare Candelar_Texture = texture {
  pigment {
    color rgb < 1.000, 0.800, 0.460 >
  }
  finish {
    ambient < 0.110, 0.110, 0.110 >
    diffuse 0.43
    brilliance 2
    reflection < 0.300, 0.300, 0.300 >
    specular 0.2
    roughness 0.02
    phong 0.53
    phong_size 5
    metallic
  }
  normal {
    dents .9
    scale < 0.030, 0.030, 0.030 >
  }
}

// >>> Post_Tex (from File "povlab.inc") <<<
#declare Post_Tex = texture {
  pigment {
    color rgb < 0.900, 0.700, 0.350 >
  }
  finish {
    reflection < 0.600, 0.600, 0.600 >
    brilliance 2.5
    phong 0.80
    phong_size 15.00
    metallic
  }
}

// >>> Negativ4 (from File "povlab.inc") <<<
#declare Negativ4 = texture {
  pigment {
    bozo
    lambda -10
    turbulence < 1.000, 1.000, 1.000 >
    octaves 3
    color_map {
      [ 0.000 rgb < 0.000, 0.000, 0.000 > ]
      [ 0.100 rgb < 0.550, 0.090, 0.090 > ]
      [ 0.100 rgb < 0.550, 0.090, 0.090 > ]
      [ 0.900 rgb < 0.000, 0.000, 0.000 > ]
      [ 0.900 rgb < 0.000, 0.000, 0.000 > ]
      [ 1.000 rgb < 0.000, 0.000, 0.000 > ]
    }
  }
  finish {
    diffuse 1
    ambient < 0.000, 0.000, 0.000 >
  }
}

// >>> Anticyclone (from File "povlab.inc") <<<
#declare Anticyclone = texture {
  pigment {
    granite
    turbulence 0.7
    color_map {
      [0 0.22 color rgb <0.5945, 0.2855, 0.3515>
      color rgb <0.5945, 0.2855, 0.3515>]
      [0.22 0.72 color rgb <0.3285, 0.8692, 0.8863>
      color rgb <0.3917, 0.0324, 0.2404>]
      [0.72 1.001 color rgb <0.9442, 0.8700, 0.7092>
      color rgb <0.4873, 0.4105, 0.2861>]
    }
  }
  finish {
    phong 1.0 ambient 0.4
  }
  rotate <128 329 120>
  scale <3.6 3.6 1.9>
}

/*
Texture finished with the help of the povray newsgroup 
//from emetex.inc
*/
#declare ariadna = texture {
  pigment { 
  spiral2 12
    turbulence 0.8
    frequency 50
    scale 10
    color_map { //softer edged color map
    [0.225 rgbf <1.0, 1.1, 1.0, 0.0>] 
    [0.25 rgbf <1.0, 1.0, 1.0, 0.5>]  
    [0.275 rgbf <1.0, 1.0, 1.0, 1.0>]
    [0.725 rgbf <1.0, 1.0, 1.0, 1.0>]
    [0.75 rgbf <1.0, 1.0, 1.0, 0.5>]  
    [0.775 rgbf <1.0, 1.0, 1.0, 0.0>]
  }
    rotate <90,0,0>
  }
}
texture {
  pigment { 
  spiral2 12
    turbulence 0.8
    frequency 50
    scale 10
    color_map { //softer edged color map
    [0.225 rgbf <1.0, 1.0, 1.0, 0.0>]
    [0.25 rgbf <1.0, 1.0, 1.0, 0.5>]  
    [0.275 rgbf <1.0, 1.0, 1.0, 1.0>]
    [0.725 rgbf <1.0, 1.0, 1.0, 1.0>]
    [0.75 rgbf <1.0, 1.0, 1.0, 0.5>] 
    [0.775 rgbf <1.0, 1.0, 1.0, 0.0>]
  }
    rotate <0,90,0>}
  finish {Dull}}
