// Persistence of Vision Ray Tracer Scene			
// Pov-Ray for windows version 3.1e
//
// Fichier       : nwkarnac.pov, mtextures.inc,colones.inc,minarets.inc,montagnes.inc,cabine.inc
//              	 by  Martial Rameaux
// textures      : dune.pgn
// Date          : mars avril 99
//
// outils        : Gforge,Pal2PovColour,
//
// mile ;) -> M.R@lemel.fr
// 2h035'48"
//==========================================  
#version 3.1;
#include "colors.inc"
#include "textures.inc"
#include "mtexture.inc"

#include "consts.inc"
#declare Rad_Quality = 5;
#include "rad_def.inc"
global_settings 
{ assumed_gamma 1.0  
  max_trace_level 12 
  radiosity { distance_maximum 6 } // dpend de la scene 1/3 de la distance
}

//=========== Complexit Scene Scwichts'sss ====
 // mettre  zero pour rien voir  
#declare Minar=1;
#declare Coln =1;
#declare Lion =1;    
#declare Fogue=1; 
#declare Atmos=0;
#declare Phone=1;
//==========================================
#switch ( Coln )
        #case (1)
        #include "Colones.inc" 
       #end
       
#switch ( Minar )
#case (1)
        #include "minarets.inc"
      #end   

#switch (Lion )
        #case (1)
        #include "Lion.inc"
#end


//============ Camera ==============================
#declare CF=camera
{
  location  <0.0 , 2.0 ,-25.0>
  look_at   <0.0 , 5.0 , 20.0>
}  
#declare CH=camera {
                location <0,30,0>
                look_at <0,0,0>
}
#declare CP=camera
{
  location <0,1,-7.5> look_at <0,3,20> //angle 90
 // location <0,0.5,-0> look_at <0,3,20> angle 80

}

//========= CHOIX DE LA CAMERA =============
camera { CP }
//============= LUMIERES ===================

light_source { 0*x color rgb<0.9137,0.3372,0.1450>*1.8  translate < -80,40,-50> }
light_source { 0*x color rgb <1,1.0,0.9>*1.8 translate < 100,40,-40> shadowless }
//light_source { 0*x color rgb <1,0.9,0.9>*1.8 translate < -100,100,-40> media_attenuation on }

//=================MEDIA atmosphere ========      
#switch ( Atmos )
 #case (1)
media {
  intervals 5 //40
  scattering { 1, rgb 0.0000001}
  emission rgb 0.0000001      
  samples 1,10
    confidence 0.9999
  variance 1/128
  ratio 0.9
} 
#end

//============== BROUILLARD ================
 
#switch (Fogue)
#case (1)
//---------- en bas
fog { 
  distance 5 
  color rgbt<0.5411,0.2843,0.2666,0.2> 
  fog_type 2
  fog_offset 0.15
  fog_alt 0.3
  turbulence 0.2
  turb_depth 0.7
  octaves 10
  omega 0.8
  lambda 2.5
}


#end
//=========== SOL ET MONTS ================
#include "Montagne.inc"
object { Sol translate y*3 hollow}
object {Monts rotate x*-10  translate <-75,-15,30>  }

//============== CIEL ET NUAGES=============

#declare C_Vert = pigment {
  bozo
  turbulence 0.65
  octaves 6
  omega 0.7
  lambda 2.0
  color_map { [0.0, 0.1  color rgb<0.2588,0.3901,0.2431> color rgb<0.2901,0.6078,0.3019>] 
              [0.1, 0.3  color Clear color 0.7] 
              [0.5, 0.7  color rgb<0.2901,0.3078,0.3019> color Clear]
              [0.8, 1.001 color 0.8 color Clear] 
}
  scale <6, 2, 6>*0.2
  
}
//-------------------
#declare Dia=pow(10,6);
//------- Ciel 
sphere { 0,1 
 texture {pigment {  C_Vert scale 0.5 rotate <-30,0,0>}    normal { bozo 3 scale 0.5}  } // rgbf<0.3294,0.9803,0.8000,0.8>}}
 texture {pigment {  color rgbf<0.1098,0.8666,0.8176,0.88>}normal { bozo 5 scale 0.5}  } // rgbf<0.3294,0.9803,0.8000,0.8>}}
 texture {pigment {  C_Vert  scale 0.2 rotate <30,0,0>  }  normal { bozo 5 scale 0.5 }  } 
 rotate <0,0,70> //<0,45,-90>
 no_shadow
 scale    Dia scale <5,0.1,2>
hollow
 }

//=============DECLARATION PRINCIPAL DE LA COLONE DE MARBRE =======================
#switch (Coln)
#case (1)
#declare Hauteur_Colone=15;//>3
#declare Colone_radius=1.5;
//#declare Flute_radius=0.25;
//#declare Nombre_de_Flute=20;// 0 et 1 =pas de flute 

#include "mtexture.inc"
#declare Colone_Texture=T_marbrejauneb

#include "Colones.inc" // REQUIS ici
                
object {Colonne translate <-3,0,35> }
object {Colonne translate <-5,0,35> }

object {Colonne translate < 3,0,35> }
object {Colonne translate < 5,0,35> }

//---------------------------------
#declare Hauteur_Colone=10;//>3
#declare Colone_radius=1.0;
//#declare Flute_radius=0.;
#declare Nombre_de_Flute=0;// 0 et 1 =pas de flute 

#include "mtexture.inc"
#declare Colone_Texture=T_marbrejauneb

box { <-2,0,-Bord_Pied><2,1,Bord_Pied> texture {T_marbrejauneb}translate <0,14.,35> }

#include "Colones.inc" // REQUIS ici
                
object {Colonne translate <-2.6,0,30> }
object {Colonne translate < 2.6,0,30> }
#end

//============ MINARETS =============

#switch (Minar)
        #case (1)
#declare Nbre_de_Tours=4;
#declare Ecart=8;//11;//8;
#declare Allee=12;//12;
#declare compte=0;
#declare Cpt=compte;
//union {
#while (Cpt<=Nbre_de_Tours)
object { Minarets translate <-Allee+(Cpt),0,Cpt*Ecart>}
object { Minarets translate < Allee-(Cpt),0,Cpt*Ecart>}

#declare Cpt=Cpt+1;
#end
//}
#end

//============== LIONS ==================
#switch (Lion)
        #case (1)


object { Lion_droit  scale 0.5 translate <  3.2,0.0,20>} //au fond
object { Lion_gauche scale 0.5 translate <- 3.2,0.0,20>}

//object { Lion_droit  scale 0.5 translate <- 4.5,0.0,10>}  //devant   
object { Lion_gauche scale 0.5 translate <  4.5,0.0,10>}

// --- lion du fond-
#declare Tourne_Tete=0;
#include "Lion.inc"       
object { Lion_droit  scale 0.5 translate < 2.6,10.0,30>}//en haut 
object { Lion_gauche scale 0.5 translate <-2.6,10.0,30>} 

#end
//============ TELEPHONE ===================
       
#switch (Phone)
        #case (1)
        #include "cabine.inc"
        object { Telephone rotate y*15  scale <2.6,3,2.6> translate <-3,-0.2,2.2> }//rotate y*-20 
      //light_source { <0,1.5,0> color rgb 1  translate <-3,1.5,2.2>}
#end                
//================= CHATEAU DE SABLE =======
#declare Chateau_Texture=texture {
		pigment {
			granite 
				color_map {
					[ 0.0 color rgb<0.7921,0.6392,0.2745> ]
					[ 0.5 color rgb<0.8235,0.7098,0.3490> ]
					[ 1.0 color rgb<0.8705,0.5254,0.2117> ]//rgb<.42,.45,.12> ]
				}
				scale 5
			}
		normal { granite 0.1 scale 1}
		finish { ambient .3 diffuse .7 }
}

#declare HF_Translate = <-0.5, -0.5, -0.5>;
intersection {
cone { <0,0,0>0.3<0,0.5,0>0.20 }
//clipped_by { height_field { png "plasma2.png"  translate HF_Translate scale <6,2,6>} }
height_field { png "plasma2.png" smooth translate HF_Translate scale <6,4,6>}
texture {Chateau_Texture }
rotate y*-45
translate <0.5,-0.25,-2.8>
}
cone { <0,0,0>0.3<0,0.5,0>0.20 texture {Chateau_Texture } rotate z*-5 translate <0,-0.30,-2>}
cone { <0,0,0>0.3<0,0.5,0>0.20 texture {Chateau_Texture } translate <1,-0.25,-2.5>}

//=========== Bille========
#declare Interieur=interior  {ior 1.8705 caustics 1.0 fade_distance 10.0  fade_power 2.0  }
#declare Bille1_materiel=
  material   {   
      texture {      
         pigment  {
            agate
            agate_turb 1.0
            color_map
            {
               [ 0.0     rgbf <0.0, 0.958333, 0.0, 0.0> ]
               [ 1.0     rgbf <1.0, 1.0, 1.0, 0.9375> ]
            }
            scale  0.2
         }      
         finish   {  ambient 0.1 brilliance 1.278 reflection rgb <0.6354, 0.0, 0.3>   }
      }   
      interior  {Interieur }
   }
#declare Bille2_materiel = 
   material  {   
      texture  {      
         pigment   {
            agate
            agate_turb 1.0
            color_map
            {
               [ 0.0     rgbf <0.0, 0.677067, 0.0, 0.0> ]
               [ 1.0     rgbf <1.0, 1.0, 1.0, 0.9375> ]
            }
            scale  0.2
         }      
         finish {ambient 0.1 brilliance 1.278 reflection rgb <0.0, 0.2, 0.563>}
      }   
      interior {Interieur }
   }
#declare Bille3_materiel = 
   material   {   
      texture  {      
         pigment {
                    agate
                    agate_turb 1.0
                    color_map
                {
                       [ 0.0     rgbf <0.235, 0.356, 0.0, 0.0> ]
                       [ 1.0     rgbf <1.0, 1.0, 1.0, 0.9375> ]
                }
                scale  0.2
                }      
         finish    { ambient 0.1 brilliance 1.278 reflection rgb <0.01, 0.235, 0.0> }
      }   
      interior {Interieur }
   }
   
sphere { 0,0.035 material {Bille1_materiel} translate < 0.0,0.215,-4.8>}
sphere { 0,0.035 material {Bille2_materiel} translate <0.25,0.140,-4.2>}
sphere { 0,0.035 material {Bille3_materiel} translate < 0.25,0.21,-4.8>}
//================ FIN DE FICHIER ==========


