 tedbearm.inc:tedbearm.inc   :Hl     TEXTMPS           ul:                      j  // Persistence Of Vision INCLUDE file
// File:        tedbearm.inc
// Vers:        3.1 Mac PPC
// Desc:        A 4-inch high teddy bear (as a macro)
// Auth:        Peter Murray

#debug "\r  tedbearm.inc - Macro for a 4-inch teddy bear.\r"

// Measurements might already be defined.
#ifndef(in)
  #declare in = 1;
#end

// Define the default textures
#declare dNoseTx=
texture{
  pigment{rgb <0,0,0>}
}

#declare dMouthTx=
texture{
  pigment{rgb <0,0,0>}
}

#declare dEyeTx=
texture{
  pigment{rgb <0,0,0>}
}

#declare dFurTx=
texture{
  normal{
	ripples 2 turbulence 0.5 omega 1 lambda 4
	rotate <30,20,10>
  }
  pigment{
	granite
	colour_map{
	  [0.0 colour rgb <.65,.65,.25>]
	  [0.3 colour rgb <.75,.75,.25>]
	  [0.6 colour rgb <.75,.80,.25>]
	  [1.0 colour rgb <.75,.75,.25>]
	}
	scale .5
  }
}

#declare dContrastTx=
texture{
  pigment{rgb <0,0,0>}
}

/* Passed parameter values (mostly rotations):
   pWhere:     Location of final bear
   pRotn:      Its rotation about its own axis
   TeddHeadR:  Head rotation (about neck)
   TeddRarmR:  Right arm (about shoulder)
   TeddLarmR:  Left arm (ditto)
   TeddRlegR:  Right leg (about hip)
   TeddLlegR:  Left leg (ditto)
   pTextureA:  array of textures, or "" for defaults;
               Fur,Contrast,Eyes,Mouth,Nose.
*/
#macro TeddyBear(pWhere,pRotn,TeddHeadR,TeddRarmR,TeddLarmR,TeddRlegR,TeddLlegR,pTextureA)
  object{
    union{
      blob{// torso
        threshold .5
        #debug "\r  Fix those units.\r"
        component 2,0.375,< 0.5625,2.6875,0.000> //r shoulder
        component 2,0.375,< 0.000,2.875,0.000> //neck
        component 2,0.375,<-0.5625,2.6875,0.000> //l shoulder
        component 2.75,.5,< 0.375,2.625,0.000>  //r collar
        component 2.75,.5,< 0.000,2.625,0.000>  //c collar
        component 2.75,.5,<-0.375,2.625,0.000>  //l collar
        component 3,.5,< 0.250,2.250,0.000>  //r chest
        component 3,.5,<-0.250,2.250,0.000>  //l chest
        component 3,.5,< 0.375,1.875,0.000>  //r waist
        component 3,.5,< 0.000,1.875,0.000>  //upper tummy
        component 3,.5,< 0.000,1.875,0.125>
        component 3,.5,<-0.375,1.875,0.000>  //l waist
        component 3,.5,< 0.375,1.500,0.000>  //r upper hip
        component 3,.5,< 0.000,1.500,0.000>  //tummy
        component 4,.5,< 0.375,1.700,0.100>
        component 4,.5,< 0.000,1.700,0.200>
        component 4,.5,<-0.375,1.700,0.100>
        component 3,.5,<-0.375,1.500,0.000>  //l upper hip
        component 3,.5,< 0.000,1.250,0.000>  //groin
        component 2,0.625,< 0.375,1.5625,0.000> //r hip
        component 2,0.625,<-0.375,1.5625,0.000> //l hip
      }//-blob
      blob{// r leg
        threshold .5
        component 2,0.625,< 0, 0.000,0.000> //r hip
        component 2,0.625,< 0,-0.375,0.000>
        component 2,0.625,< 0,-0.875,0.000> //r foot
        rotate TeddRlegR
        translate <0.375,1.5625,0>
      }//-blob
      blob{// l leg
        threshold .5
        component 2,0.625,< 0, 0.000,0.000> //r hip
        component 2,0.625,< 0,-0.375,0.000>
        component 2,0.625,< 0,-0.875,0.000> //r foot
        rotate TeddLlegR
        translate <-0.375,1.5625,0>
      }//-blob
      blob{// r arm
        threshold .5
        component 2,0.375,< 0.000,0.000,0.000> //r shoulder
        component 2,0.375,< 0,-0.125,0.000>
        component 2,0.375,< 0.09375,-0.28125,0.000>
        component 2,0.375,< 0.1875,-0.4375,0.000>
        component 2,0.375,< 0.28125,-0.59375,0.000>
        component 2,0.375,< 0.375,-0.75,0.000>
        rotate TeddRarmR
        translate <0.5625,2.6875,0>
      }//-blob
      blob{// l arm
        threshold .5
        component 2,0.375,< 0.000,0.000,0.000> //l shoulder
        component 2,0.375,< 0,-0.125,0.000>
        component 2,0.375,<-0.09375,-0.28125,0.000>
        component 2,0.375,<-0.1875,-0.4375,0.000>
        component 2,0.375,<-0.28125,-0.59375,0.000>
        component 2,0.375,<-0.375,-0.75,0.000>
        rotate TeddLarmR
        translate <-0.5625,2.6875,0>
      }//-blob
      union{//head
        blob{
      	threshold .5
      	component 2,.375,< 0.000,0.000,0.000> //neck
      	component 2.75,.5,< 0.250,0.250,0.000> //r cheek
      	component 2.75,.5,< 0.000,0.250,0.000>
      	component 2.75,.5,<-0.250,0.250,0.000> //l cheek
      	component 2.75,.5,< 0.250,0.500,0.000>
      	component 2.75,.5,< 0.000,0.500,-0.10>
      	component 2.75,.5,< 0.000,0.500,0.200> //snout
      	component 2.75,.5,< 0.100,0.400,0.150>
      	component 2.75,.5,<-0.100,0.400,0.150>
      	component 2.75,.5,<-0.250,0.500,0.000>
      	component 2.75,.5,< 0.250,0.6875,0.000> //r temple
      	component 2.75,.5,< 0.000,0.750,0.000>
      	component 2.75,.5,<-0.250,0.6875,0.000> //l temple
      	component 2,.375,< 0.525,0.800,-0.1000> //r ear
      	component 2,.375,< 0.400,0.925,-0.1000>
      	component 2,.375,<-0.525,0.800,-0.1000> //l ear
      	component 2,.375,<-0.400,0.925,-0.1000>
        }//-blob
        sphere{//nose
      	  <0,0,0>,.25
      	  scale <1,.5,1>
      	  translate <0,0.525,.45>
          //#if (strlen(pTextureA[4])=0)
      	  //  texture{dNoseTx}
          //#else
	        texture{pTextureA[4]}
		  //#end
        }
        intersection{//r half of mouth
      	  torus{
      	    .25,.02
      	  }
      	  box{
      	    <0,-.1,0>,<-.25,.1,.25>
      	  }
      	  scale <1,1.5,1>
      	  rotate <130,0,0>
      	  translate <0.25,0.525,.45+.5-.25>
          //#if (strlen(pTextureA[3])=0)
      	  //  texture{dMouthTx}
          //#else
	        texture{pTextureA[3]}
		  //#end
        }
        intersection{//l half of mouth
      	  torus{
      	    .25,.02
      	  }
      	  box{
      	    <0,-.1,0>,<.25,.1,.25>
      	  }
      	  scale <1,1.5,1>
      	  rotate <130,0,0>
      	  translate <-0.25,0.525,.45+.5-.25>
          //#if (strlen(pTextureA[3])=0)
      	  //  texture{dMouthTx}
          //#else
	        texture{pTextureA[3]}
		  //#end
        }
        sphere{//r eye
      	  <.25,0.725,.4>,.1
          //#if (strlen(pTextureA[2])=0)
      	  //  texture{dEyeTx}
          //#else
	        texture{pTextureA[2]}
		  //#end
        }
        sphere{//l eye
      	  <-.25,0.725,.4>,.1
          //#if (strlen(pTextureA[2])=0)
      	  //  texture{dEyeTx}
          //#else
  	        texture{pTextureA[2]}
		  //#end
        }
        rotate TeddHeadR
        translate <0,2.875,0>
      }//-union - head
    }//-union
    //#if (strlen(pTextureA[0])=0)
	//  texture{dFurTx}
    //#else
	  texture{pTextureA[0]}
	//#end
	rotate pRotn
	translate pWhere
  }//-object teddybear
#end


#declare SamplerName=object{
  TeddyBear(
    <0,0,0>,<0,0,0>,
    <0,-30,0>,<-10,0,0>,<-70,0,0>,<-90,30,0>,<-90,-30,0>,
	array[5]{dFurTx,dContrastTx,dEyeTx,dMouthTx,dNoseTx}
  )
}
// Doesn't allow for pose:
#declare SamplerBBox=array[2]
  {<-2*in,0,-2*in>,<2*in,4*in,2*in>}
                                                                     e  Icon
           @         tedbearm.inc-20)BufferCreatureo TEXTMPS                      l    u  
   Include    C  [
fl     '   h @         [                       poser rib read.pl   TEXTMPS   h         <    (         x       x ttxt8BIM   	                           >                               ?  f$` 9  FhR     H 	Monaco 
 !0             
    < $@*  o  o  k      < $@  k                    eH    R MPSR  FPRF   *          ,          POV-Ray File Prefs           