/* Persistence of Vision Ray Tracer Scene Description File
   File: Pixels.pov
   Vers: 3.1a
   Desc: Pixels
   Date: March 1999
   Auth: Anto Matkovic 
   email: matkovic@geocities.com
   Webpage: http://www.geocities.com/SoHo/Studios/7415/ 
Note : If you like to render this file, render heightfields for 
sea and sand again on 600x600, no AA, as TGA. Adequate POV files ("a_pixg_hf_more.pov" and 
"a_pixg_hf_pijesak.pov") are included*/




global_settings {assumed_gamma 2.2}



 
#include "pixels_tex.inc"
#include "pixels_obj.inc"

background {color rgb <0.5, 0.5, 0.5>}

#declare mjesto_kamere = <10, 105, 33>; 
#declare mjesto_svijetla = <3000, 750, 2500>;



camera {  sky z*1 up z*1 right <4/3, 0.0, 0.0>location  mjesto_kamere  look_at   <2, 3, -3> angle 39
normal {onion  
normal_map {[0 quilted 0]
            [0.452 quilted 0]
            [0.75 quilted 0.1 scale <0.03, 0.04, 0.04>]
            [1 quilted 0.15 scale <0.03, 0.04, 0.04>]}}
        }

light_source {0*x colour rgb <1.9, 1.7, 1.6> area_light <50, 50, 50><-50, -50, -50>  3, 3  adaptive 0          
 jitter translate mjesto_svijetla }

light_source {0*x  color rgb 0.25  translate mjesto_kamere } 

light_source {0*x  color rgb <0.1, 0.4, 0.45> translate <-1100, 300, 300> shadowless}


fog { fog_type 1 distance 360  colour rgb <0.2, 0.25, 0.45>}

fog{fog_type 2 up z*1 distance 80 colour rgb <0.3,0.35,0.45> fog_offset -50 fog_alt 20 turbulence 0.8 turb_depth 10}

//mosaic
height_field {tga "a_pixels_hf.tga"  
water_level 0.05
rotate x*90 scale <50, 50, 3> translate <-25, 25, 0>  scale <-1, 1, 1>  
texture { mozaik_tex} rotate <-39, -5, 0> translate z*-8}

//amphora
object {amfora150399CSG scale <2.7, 2.7, 4> rotate <60,0,-22> translate <-23, 27, -15>texture {kamen_amph_190399}}
object {amfora150399 scale <3.6, 3.6, 6>rotate <70,-20,-136>translate <9, -64, -3>texture {kamen_amph_190399}
scale <-1, 1, 1>} 

object{a_mala_amph scale 15 rotate <10, 12, 70>translate<27,-14,-8>
texture{kamen_mala_amph_190399}}                           

object{stup180399 scale <2, 2, 1.32> rotate <23, -14, -12> translate<46,-23,-39> texture { kamen_stup }
scale <-1, 1, 1>}

object { kamen210399_1 scale <5, 3, 3> rotate z*180 translate <-48, -49, 1>   texture {pijesak}scale <-1, 1, 1>} 
object { kamen210399_1 scale <5, 7, 4> rotate z*270 translate <-42, -90, -10> texture {pijesak}}

object {a_vaza  translate z*-0.5 
scale 33 rotate <70, 33, 17> translate <22, 21, -9> } 

//sand
height_field {tga "a_pixg_hf_pijesak.tga"
 smooth
rotate x*90 texture {pijesak} scale <400, 400, 30> translate <-200, 70, -19> } 
//sea
height_field {tga "a_pixg_hf_more.tga"
smooth 
rotate x*90    scale <300, 500, 17> translate <-70, 250, 90> material {more}}


