// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3.1
// Desc: 
// Date: 
// Auth: Matthias M. Giwer

global_settings { assumed_gamma 2.2 
				max_trace_level 5 }

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

#include "STONES.INC"   // Binding include-file for STONES1 and STONES2
#include "STONES1.INC"  // Great stone-textures created by Mike Miller
#include "STONES2.INC"  // More, done by Dan Farmer and Paul Novak
#include "WOODS.INC"    // Great wooden textures created by Dan Farmer and Paul Novak

// ----------------------------------------

/* camera
{  
  location  <0,1900,0>// <2.5, 6, -5.0>
  direction 1.5*z 
  right     4/3*x
  look_at <-300.0, 0.0, 2000>
}*/

camera
{  
  location <-10, 6, -10.0> //10.5 
  direction 1.5*z 
  right     4/3*x
  look_at <-100.0, 0.0, 2000>
} 

light_source
{ 0*x  color rgb 1 
   translate <-1000, 700, 1500> 
} 
light_source
{ 0*x  color rgb .3 shadowless  
   translate <1000, 700, -1500> 
}

// ----------------------------------------

//groundbox 
#declare gcolor = <0.9,.8,.6>;

box {<-1,-1,-1> < 1,1,1> translate <0,-1,0> scale <10000,1,10000>
   translate <0,0,10030>
   pigment {color rgb gcolor } finish {ambient 0.9*gcolor}
   normal { 
      crackle 5 
      turbulence 1 octaves 2 omega 2 lambda 0
            frequency 5
            scale <50,1,25> 
      }
}

// make river

box {<-1,-1,-1> < 1,1,1> translate <0,-3,0> scale <10000,1,10000>
   translate <0,0,0>
   interior {ior 1.33 caustics 1} 
   pigment {color rgbft <.7,.7,1,.7,.3> } 
   finish {ambient 0.*<.7,.7,1> reflection .6*<.7,.7,1> }
   normal { 
      waves 5 
      turbulence 0 octaves 2 omega 2 lambda 0
            frequency 150
            scale <500,-1,25> 
      }
}

// make river bottom
box {<-1,-1,-1> < 1,1,1> translate <0,-6,0> scale <10000,1,10000>
   translate <0,0,0> 
   pigment {color rgb <.3,.7,.3> } finish {ambient 0.5}
   normal { 
      waves 5 
      turbulence 1 octaves 2 omega 2 lambda 0
            frequency 500
            scale <50,1,25> 
      }
}

// make riverbank
box {<-1,-1,-1> < 1,1,1> translate <0,-1.00001,0> scale <10000,1,10000>
   translate <0,0,10029.99999>
   pigment {color rgb gcolor } finish {ambient .5}
   normal { 
      crackle 5 
      turbulence 1 octaves 2 omega 2 lambda 0
            frequency 5
            scale <5,1,25> 
      }
}                


/*



*/

// make ramp

superellipsoid {<0.05,0.05> // left stone ramp
   texture {   
   pigment {color rgb<1,1,1>} 
   finish {ambient .7 }
   }
   normal {crackle -5
      turbulence 100 octaves 2 omega 2 lambda 0
            frequency 500
            scale <1,1,10>
      }

   scale<2.5,1.5,2>
   rotate <-25,0,0> 
   translate <0.5,-1.2,30.1> // left stone ramp
   }
superellipsoid {<0.05,0.05> // right stone ramp
   texture {   
   pigment {color rgb<1,1,1>} 
   finish {ambient .7 }
   }
   normal {crackle -5
      turbulence 100 octaves 2 omega 2 lambda 0
            frequency 500
            scale <1,1,10>
      }
   scale<2.5,1.5,2>
   rotate <-25,0,0>
   translate <5.7,-1.2,30.1> // right stone ramp
   }
// second set
superellipsoid {<0.05,0.05> // left stone ramp
   texture {   
   pigment {color rgb<1,1,1>} 
   finish {ambient .7 }
   }
   normal {crackle -5
      turbulence 100 octaves 2 omega 2 lambda 0
            frequency 500
            scale <1,1,10>
      }
   scale<2.5,1.5,2>
   rotate <-25,0,0> 
   translate <0.5,-2.7,26.1> // left stone ramp
   }
superellipsoid {<0.05,0.05> // right stone ramp
   texture {   
   pigment {color rgb<1,1,1>} 
   finish {ambient .7 }
   }
   normal {crackle -5
      turbulence 100 octaves 2 omega 2 lambda 0
            frequency 500
            scale <1,1,10>
      }
   scale<2.5,1.5,2>
   rotate <-25,0,0>
   translate <5.7,-2.7,26.1> // right stone ramp
   }
// third set
superellipsoid {<0.05,0.05> // left stone ramp
   texture {   
   pigment {color rgb<1,1,1>} 
   finish {ambient .7 }
   }
   normal {crackle -5
      turbulence 100 octaves 2 omega 2 lambda 0
            frequency 500
            scale <1,1,10>
      }
   scale<2.5,1.5,2>
   rotate <-25,0,0> 
   translate <0.5,-4.2,22.1> // left stone ramp
   }
superellipsoid {<0.05,0.05> // right stone ramp
   texture {   
   pigment {color rgb<1,1,1>} 
   finish {ambient .7 }
   }
   normal {crackle -5
      turbulence 100 octaves 2 omega 2 lambda 0
            frequency 500
            scale <1,1,10>
      }
   scale<2.5,1.5,2>
   rotate <-25,0,0>
   translate <5.7,-4.2,22.1> // right stone ramp
   }

superellipsoid {<0.075,0.075> // left stone
   texture {   
   pigment {color rgb<1,1,1>} 
   finish {ambient .7 }
   }
   normal {crackle -5
      turbulence 100 octaves 2 omega 2 lambda 0
            frequency 500
            scale <1,1,1>
      }
   scale<2.5,1.5,2> 
   translate <-4.5,-1,30>} // left stone

superellipsoid {<0.075,0.075> // left stone down1
   texture {   
   pigment {color rgb<1,1,1>} 
   finish {ambient .7 }
   }
   normal {crackle -5
      turbulence 100 octaves 2 omega 2 lambda 0
            frequency 500
            scale <1,1,1>
      }
   scale<2.5,1.5,2> 
   translate <0,-4,30>} // left stone down 1

superellipsoid {<0.075,0.075> // left stone
   texture {   
   pigment {color rgb<1,1,1>} 
   finish {ambient .7 }
   }
   normal {crackle -5
      turbulence 100 octaves 2 omega 2 lambda 0
            frequency 500
            scale <1,1,1>
      }
   scale<2.5,1.5,2> 
   translate <10.5,-1,30>} // left stone

superellipsoid {<0.075,0.075> // left stone down1
   texture {   
   pigment {color rgb<1,1,1>} 
   finish {ambient .7 }
   }
   normal {crackle -5
      turbulence 100 octaves 2 omega 2 lambda 0
            frequency 500
            scale <1,1,1>
      }
   scale<2.5,1.5,2> 
   translate <10.5,-4,30>} // left stone down 1
//break
superellipsoid {<0.075,0.075> // left stone
   texture {   
   pigment {color rgb<1,1,1>} 
   finish {ambient .7 }
   }
   normal {crackle -5
      turbulence 100 octaves 2 omega 2 lambda 0
            frequency 500
            scale <1,1,1>
      }
   scale<2.5,1.5,2> 
   translate <-4.5,-1,26>} // left stone

superellipsoid {<0.075,0.075> // left stone down1
   texture {   
   pigment {color rgb<1,1,1>} 
   finish {ambient .7 }
   }
   normal {crackle -5
      turbulence 100 octaves 2 omega 2 lambda 0
            frequency 500
            scale <1,1,1>
      }
   scale<2.5,1.5,2> 
   translate <0,-4,26>} // left stone down 1

superellipsoid {<0.075,0.075> // left stone
   texture {   
   pigment {color rgb<1,1,1>} 
   finish {ambient .7 }
   }
   normal {crackle -5
      turbulence 100 octaves 2 omega 2 lambda 0
            frequency 500
            scale <1,1,1>
      }
   scale<2.5,1.5,2> 
   translate <10.5,-1,26>} // left stone

superellipsoid {<0.075,0.075> // left stone down1
   texture {   
   pigment {color rgb<1,1,1>} 
   finish {ambient .7 }
   }
   normal {crackle -5
      turbulence 100 octaves 2 omega 2 lambda 0
            frequency 500
            scale <1,1,1>
      }
   scale<2.5,1.5,2> 
   translate <10.5,-4,26>} // left stone down 1

// moving box
#macro Make_Many1 (Stuff,How_Many,Axis)
  #local Count=0;
 #declare R1 = seed(6745);
  #while (Count<How_Many)
    object{Stuff  
      translate Count*z*40 + (rand(R1)-.5)*10*z +20*z
      }
    #local Count=Count+1;
  #end
#end

#declare wcolor = <1,.9,.8>;
#declare stone = union {
superellipsoid {<0.075,0.075> //
   rotate<0,0,90>
   texture {   
   pigment {color rgb<1,1,1>} 
   finish {ambient .7 }
   }
   normal {crackle -5
      turbulence 100 octaves 2 omega 2 lambda 0
            frequency 500
            scale <1,1,1>
      }
   scale<2.5,1.5,2> 
   translate <3,3.5,34>} // 
cylinder { -1*x 1*x 1 scale <3.5,.5,.5> rotate<0,0,0> translate <3,1.5,34> 
      pigment {color rgb wcolor } finish {ambient 0.9*wcolor}
   normal { 
      crackle 5 
      turbulence 1 octaves 2 omega 2 lambda 0
            frequency 5
            scale <50,1,25>}
}
cylinder { -1*x 1*x 1 scale <3.5,.5,.5> rotate<0,0,0> translate <3,1.5,36> 
      pigment {color rgb wcolor } finish {ambient 0.8*wcolor}
   normal { 
      crackle 5 
      turbulence 0 octaves 2 omega 2 lambda 0
            frequency 6
            scale <50,1,25>}
}
cylinder { -1*x 1*x 1 scale <3.5,.5,.5> rotate<0,0,0> translate <3,1.5,34> 
      pigment {color rgb wcolor } finish {ambient 0.85*wcolor}
   normal { 
      crackle 5 
      turbulence 1 octaves 2 omega 2 lambda 0
            frequency 7
            scale <50,1,25>}
}
cylinder { -1*x 1*x 1 scale <3.5,.5,.5> rotate<0,0,0> translate <3,1.5,38> 
      pigment {color rgb wcolor } finish {ambient 0.95*wcolor}
   normal { 
      crackle 5 
      turbulence 1 octaves 2 omega 2 lambda 0
            frequency 8
            scale <50,1,25>}
}
}               
//stone

union { Make_Many1 (stone,50,z)}


//make pavement 
#declare pavement = union { 

superellipsoid {<0.075,0.075> // left stone
   texture {   
   pigment {color rgb<1,1,1>} 
   finish {ambient .7 }
   }
   normal {crackle -5
      turbulence 100 octaves 2 omega 2 lambda 0
            frequency 500
            scale <1,1,1>
      }
   scale<2.5,1.5,2> 
   translate <0,-1,30>} // left stone

box {<-1,-1,-1> <1,1,1>                
   rotate <0,0,30>
   pigment {color rgb gcolor } finish {ambient 0.9*gcolor}
   normal { 
      crackle 5 
      turbulence 1 octaves 2 omega 2 lambda 0
            frequency 5
            scale <10.33,3.14159,5.32743>}   
   scale <1.1,1.1,2>//scale<2.5,1.5,2> 
   translate <-3,-1.1,30>}
box {<-1,-1,-1> <1,1,1>                
   rotate <0,0,30>
   pigment {color rgb gcolor } finish {ambient 0.9*gcolor}
   normal { 
      crackle 5 
      turbulence 1 octaves 2 omega 2 lambda 0
            frequency 5
            scale <10.33,3.14159,5.32743>}   
   scale <1.1,1.1,2>//scale<2.5,1.5,2> 
   translate <-3,-1.1,31>}

box {<-1,-1,-1> <1,1,1>                
   rotate <0,0,-30>
   pigment {color rgb gcolor } finish {ambient 0.9*gcolor}
   normal { 
      crackle 5 
      turbulence 1 octaves 2 omega 2 lambda 0
            frequency 5
            scale <11.33,4.14159,6.32743>}   
   scale <1.1,1.1,2>//scale<2.5,1.5,2> 
   translate <8,-1.1,30>}

box {<-1,-1,-1> <1,1,1>                
   rotate <0,0,-30>
   pigment {color rgb gcolor } finish {ambient 0.9*gcolor}
   normal { 
      crackle 5 
      turbulence 1 octaves 2 omega 2 lambda 0
            frequency 5
            scale <11.33,4.14159,6.32743>}   
   scale <1.1,1.1,2>//scale<2.5,1.5,2> 
   translate <8,-1.1,31>}

superellipsoid {<0.075,0.075> // right stone
   texture {   
   pigment {color rgb<1,1,1>} 
   finish {ambient .7 }
   }
   normal {crackle -5
      turbulence 100 octaves 2 omega 2 lambda 0
            frequency 500
            scale <1,1,1>
      }
   scale<2.5,1.5,2> 
   translate <5.2,-1,30> // right stone
}

}

#macro Make_Many (Stuff,How_Many,Axis)
  #local Count=1;
 #declare R3 = seed(2347); 
 #declare R2 = seed(9831);
 #declare R1 = seed(6745);
  #while (Count<How_Many)
    object{Stuff  
      translate Count*z*4.1 + (rand(R1)-.5)*.1*z
      translate x + (rand(R2)-.5)*.2*x 
      translate y + (rand(R3)-.5)*.1 -.5
      }
    #local Count=Count+1;
  #end
#end

union {
  Make_Many (pavement,350,z)  
  //translate <0,0,4.1>
}

// skyplane
//plane { y, 2000 pigment {color rgb <0.7,0.7,1>} finish {ambient .8*<.7,.7,1>}}//sky

//skybox   
box {<-1,-1,-1> <1,1,1> 
   scale <1000000,5000,1000000> 
   translate <0,20000,0>
   rotate <10,0,0>
   texture {pigment {color rgb <0.7,0.7,1>} 
   finish {ambient .99*<.7,.7,1>}} 
 }

/*
// mirage boxes
box {<-1,-1,-1> <1,1,1> 
   pigment {color rgbft<1,1,1,0,1>}
   finish{ }
   interior{ior 0.95} //97
   normal { 
      waves 1
      turbulence 2.0 octaves 2 omega 2 lambda 2
            frequency 20
            scale <1,1,1>
   }
   scale <5000,.1,5000>
   translate <0, 0, 2500+2700>
   }
*/  /*
box {<-1,-1,-1> <1,1,1> 
   pigment {color rgbft<1,1,1,0,1>}
   finish{ }
   interior{ior 0.975}//99
   normal { 
      waves 20
      turbulence 5.0 octaves 6 omega 6 lambda 6
            frequency 70
            scale <1,1,1>
   }
   scale <5000,.2,5000>
   translate <0, 0, 2500+2700>
   }
  */

#declare brcolor = <1,1,1>;
#declare bgrainpx1 = pigment { color brcolor }
#declare bfinish1 = finish {
   reflection 0.1* brcolor
   ambient 0.4*brcolor
   roughness 0.001
   phong 1
   }
#declare capcolor = <1,.6,.2>;

   /*bozo
   turbulence 0//0.1
   octaves 0//4
   lambda 0//3
   scale <10, .00002, 10> // 0.02
   rotate <0.0, 0.0, 0>
   } */


union {
     
difference {

superellipsoid { <2, 2> } 
box {<-1,-1,-1> <1,1,1> translate <0,-70/481,0>}
   texture
   {pigment {color capcolor}
   finish{
      reflection .7*capcolor
      ambient .7*capcolor
   }}
   
   rotate <0,0,0>
   scale <756/2,481,756/2>
   translate <500,0,4000> }
 
difference {

superellipsoid { <2, 2> scale 1.001 }
box {<-1,-1,-1> <1,1,1> translate <0,2-70/481,0>} 
   texture 
   {pigment {bgrainpx1} 
   finish{bfinish1}}
   rotate <0,0,0>
   scale <756/2,481,756/2>
   translate <500,0,4000> }
}       


#declare bgrainpx = pigment {
   granite
   turbulence .9//0.1
   octaves 4//4
   lambda 3//0//3
   scale <1, .0002, 1> // 0.02
   translate <0,-1,0>
   rotate <0.0, 0.0, 0>
   } // end pigment declare

#declare bfinish = finish {
   reflection 0.1* brcolor //0.0
   ambient 1*brcolor
   roughness 0//.01
   //crand .01
   } // end finish declare

union {

difference {
   
superellipsoid { <2, 2> }
box {<-1,-1,-1> <1,1,1> translate <0.0,1.3,0>}   
box {<-1,-1,-1> <1,1,1> translate <0.6,1.25,0>}
box {<-1,-1,-1> <1,1,1> translate <0.7,1.20,0>}
box {<-1,-1,-1> <1,1,1> translate <0.8,1.15,0>}
   texture
   {pigment {bgrainpx} 
   finish{bfinish}}
}

difference {
   
superellipsoid { <2, 2> }
box {<-1,-1,-1> <1,1,1> translate <0.0,1.15,0>}   
box {<-1,-1,-1> <1,1,1> translate <0.3,1.1,0>}
box {<-1,-1,-1> <1,1,1> translate <0.6,1.05,0>}
box {<-1,-1,-1> <1,1,1> translate <1.3,1.0,0>}
   texture
   {pigment {bgrainpx1} 
   finish{bfinish}}
   normal {crackle -0.05 }
   scale 1.0001
}
   rotate <0,0,0>
   scale <756/2,481,756/2>
   translate <-500,0,2000>
}


superellipsoid { <0.01,0.01> 
   texture {
      pigment { color rgb <1,1,1> }
      finish { reflection 0.* brcolor
         ambient 0.3*brcolor
         roughness 0.1
         phong 1}
      normal { granite 5
         turbulence 5 
         octaves 4
         lambda 3 }
   scale <1, .0002, 1> // 0.02
   translate <0,-1,0>
   rotate <0.0, 0.0, 0>
   }        
   //normal {crackle -0.05 }
   scale <250,250,30> 
   rotate <0,0,-8.5>
   rotate <0,45,0>
   translate <-225,-210,1700>
}

superellipsoid { <0.01,0.01> 
   texture {
      pigment { color rgb <1,1,1> }
      finish { reflection 0.* brcolor
         ambient 0.5*brcolor
         roughness 0.1
         phong 1}
      normal { granite 5
         turbulence 5 
         octaves 4
         lambda 3 }
   scale <1, .0002, 1> // 0.02
   translate <0,-1,0>
   rotate <0.0, 0.0, 0>
   }        
   //normal {crackle -0.05 }
   scale <250.00001,250,30> 
   rotate <0,0,-8.5>
   rotate <0,45,0>
   translate <-225,-210,1700>
}


