 
   
 //  FILE NAME: spirit.pov
 //    Main Scene File Copyright 1999 David C. Hamilton
 
 //  SUBJECT: The Spirit of St. Louis (1927) 
 
 //  FILE TYPE: .pov - POV-Ray Scene File 
 //    For use with the Persistence of Vision Ray-Tracer (Version 3.1)
 //    Persistence of Vision and POV-Ray are trademarks of the POV-Team
 
 //  CREDITS:
 
 //    All scene files and image maps created by David C. Hamilton
 
 //    Bi-cubic patches were generated using sPatch (see include file list below)
 //    sPatch is Copyright 1996-1997 by Mike Clifton
 
 /*  NOTES:  This file, and the accompanying 'include' files, are provided for study purposes and for
             personal non-commercial, non-distributed use only. Any other use requires the expressed
             written permission of the author. For this reason, this file, and some of the accompanying
             files, have been modified or substitution have been made, and some files have been omitted.
             As a result, the image produced by this scene file will not be identical to the original.
             These changes and omissions, however, should not materially affect the study value of this
             file. The changes have been noted where applicable. Portions of the file may need to be
             commented-out to accomodate omitted items.
             
             The author may be reached via email at: olm@sprynet.com
             
             This is a pretty straight forward POV-Ray scene file. There isn't anything really fancy
             going on here. The include files are just long lists of bicubic patch objects that define
             the basic shapes of the various aircraft parts.
 */ 
  
  
  global_settings { assumed_gamma 1.3 }
  
  
                   
 // *** POV-Ray STANDARD INCLUDE FILES ***

   #include "colors.inc"
   #include "textures.inc"
   #include "finish.inc"
   #include "metals.inc"
   
  // *** X-1 Model Include Files (bi-cubic patches) ***
  
   #include "wing.inc"
   #include "cowl.inc"
   #include "ring.inc"
   #include "spinner.inc"
   #include "cylinder.inc"   // Omitted
   #include "rudder.inc"
   #include "frame.inc"
   #include "fuselage.inc"
   #include "htail.inc"
   #include "fin.inc"
   #include "struts.inc"
   #include "gear_a.inc"   // Tires
   #include "gear_b.inc"   // Axles
   #include "caps.inc"
   #include "breath.inc"
   #include "wheelsskid.inc"
   #include "hangar.inc"
   #include "tower.inc"
   #include "goggles.inc"
   



   camera { 
    location <1,.5,-27>
    look_at <-.1,0,0>
    angle 25
   }

  light_source { <5,30, 5> color red .05 green .05 blue .05 }   // Top light
  light_source { <8,-5,20> color red .4  green .4  blue .4  }   // Gound light
  light_source { <-4,0, 5> color red .3  green .3  blue .3  }   // Light over hangar
   
  light_source {                // Points at cowling
         <3,-3,-3>
         color White*2
         cylinder
         radius 6
         falloff 3
         tightness 6
         point_at <-.7,.9,-2.0>
        }
         
  light_source {                 // Points at spinner
         <-1.3,1,-10>
         color rgb <.4,.4,.5>
         cylinder
         radius 6
         falloff 3
         tightness 6
         point_at <-1.3,1,-2.7>
        }
  
 
   #declare Engine_Cowl =
    object { Cowl
      texture { T_Chrome_3C }
      texture {
        pigment {
          image_map {
            gif "burl3.gif"
              map_type 0
              interpolate 2
               transmit 1, .55
               transmit 2, .90
               transmit 3, .80
               transmit 4, .70
             }              
            }
            scale <.8,.16,.8>
            translate <0,-.1,-2.25>
           }
      texture {
        pigment {
          image_map {
            gif "stlogo7l.gif"
              map_type 0
              interpolate 2
              once
              transmit 0, 1.0
             }
            }
            translate <-.5,-.5,0>
            scale <.75,.55,1>
            rotate y*-90
            translate <0,.09,-2.25>
           }
          }
   
   
   #declare Cowl_Ring =
    object { Ring
      texture { T_Chrome_3C }
      texture {
        pigment {
          image_map {
            gif "burl2.gif"
              map_type 2
              interpolate 2
               transmit 1, .55
               transmit 2, .90
               transmit 3, .80
               transmit 4, .70
             }              
            }
            scale <.05,.09,.05>
            rotate x*-90
            translate <0,-.12,-2.75>
           }
          }
 
   #declare Spinner =
    object { Spinnr
      texture { T_Chrome_3C }
      texture {
        pigment {
          image_map {
            gif "burl2.gif"
              map_type 2
              interpolate 2
               transmit 1, .55
               transmit 2, .90
               transmit 3, .80
               transmit 4, .70
             }              
            }
            scale <.05,.07,.05>
            rotate x*-90
            translate <0,-.12,-2.94>
           }
          }
         
      
   #declare Engine_Cylinder =
     object { Cylinder
         pigment { Gray30 }
         finish { Glossy }
        }
        
   #declare Carburator =
     object { Carb
        pigment { Gray30 }
       }
        
   #declare Engine =
     union {
       #local Count=0;
       #local Rotate=0;
       #while (Count < 9 )
         object { Engine_Cylinder  
           rotate z*Rotate
          }
       #local Count=Count+1;
       #local Rotate=Rotate+40;   // Rotate engine cylinder around center line
       #end
       object { Carburator }
      }
      
  
  
   #declare ClipperBox =        // Basic box for clipping operations
     box { <-1,-1,-1>, <1,1,1>
    } 
    
 
   #declare Rudder = 
    object { BasicRudder
      texture {
         pigment { Silver }
        }
       texture {
         pigment {
           image_map {
             gif "nx211sm.gif"    // Aircraft tail number left side
             map_type 0
             interpolate 2
             once
             transmit 0, 1.0
            }
           }
         translate <-.5,-.5,0>
         scale <.65,.6,1>
         rotate y*-90
         translate <0,.8,3.51>
        }
       texture {
         pigment {
           image_map {
             gif "ryannyp.gif"    // Ryan NYP
             map_type 0
             interpolate 2
             once
             transmit 0, 1.0
            }
           }
         translate <-.5,-.5,0>
         scale <.47,.49,1>
         rotate y*-90
         translate <0,.52,3.57>
        }
        texture {
         pigment {
           image_map {
             gif "mfgby.gif"    // Manufacturer name
             map_type 0
             interpolate 2
             once
             transmit 0, 1.0
            }
           }
         translate <-.5,-.5,0>
         scale <.3,.3,1>
         rotate y*-90
         translate <0,.25,3.57>
        }  
       }  

    
   #declare Wing =
     object { BasicWing
       texture {
         pigment { Silver }
        }
       texture {
         pigment {
          image_map {
            gif "nx211.gif"    // Aircraft number
              map_type 0
              interpolate 2
              once
              transmit 0, 1.0
             }
            }
         translate <-.5,-.5,0>
         scale <2.5,3.45,1>
         rotate y*180
         rotate x*-90
         translate <-4.4,0,-.9>
        }
       }
  
       
  #declare WindowClipper =
    object { ClipperBox
      scale <.2,.1468,.216>
      translate <.4,.3158,-.554>
     }
     
  #declare Fuselage =
    union {
      object { BasicFuselage
        clipped_by {
          object { WindowClipper
          inverse
         }
        }    
      pigment { Silver }
     }
    object { WindowFrame
      pigment { Gray70 }
     }
    object { BasicFuselage   // Fuselage liner
      clipped_by {
          object { WindowClipper
          inverse
         }
        }
      pigment { Black }
      scale .99
     }
    }
 
     
   #declare Prop =
     cylinder { <0,0,0,>, <0,0,.02>, 1
       pigment { color rgbt < .9,.9,1,.9 > }
       translate <0,0,-2.85>
      }
    
          
   union {
   
     object { Engine_Cowl }
   
     object { Cowl_Ring }
   
     object { Spinner }
   
     object { Engine }
   
     object { Prop }
   
     object { Wing }
   
     object { Fuselage }
   
     object { VerticalStabilizer pigment { Silver } }
   
     object { Rudder }
   
     object { Struts pigment { Silver } }
   
     object { GearA pigment { Gray15 } }
   
     object { GearB texture  { T_Chrome_5E } }
   
     object { Wheels_TailSkid pigment { Silver } }
   
     object { Breathers pigment { Gray 15 } }
   
     object { Caps pigment { Silver } }
   
     object { Goggles pigment { color rgb <.90,.91,.98> } finish { ambient .2 } }
   
     rotate y*25
     rotate x*-5
     rotate z*-7
     translate <0,1,0>
    }
 
  

   #declare SearchLight1 =
    union { 
      cone { <-1,0,0>, .45
             <1,0,0>, .55  // Outer cone
             open
             pigment { color rgbt <.55, .55, .87, .73> }
             finish { ambient .5 }
        scale <.4,80,.4>
        rotate z*-60
        rotate y*-45
        translate <-1,0,72>
       }
      cone { <-1,0,0>, .45
             <1,0,0>, .55  // Inner cone
             open
             pigment { color rgbt <2.6, 2.6, 3.8, .9> }
             finish { ambient .5 }
       scale <.2,80,.2>
       rotate z*-60
       rotate y*-45
       translate <-1,0,72>
       }
     }
     
   #declare SearchLight2 =
    union { 
      cone { <-1,0,0>, .45
             <1,0,0>, .55  // Outer cone
             open
             pigment { color rgbt <.55, .55, .87, .73> }
             finish { ambient .75 }
        scale <.3,70,.3>
        rotate z*-45
        rotate y*-45
        translate <-7,0,71>
       }
      cone { <-1,0,0>, .45
             <1,0,0>, .55  // Inner cone
             open
             pigment { color rgbt <2.6, 2.6, 3.8, .9> }
             finish { ambient .75 }
       scale <.15,70,.15>
       rotate z*-45
       rotate y*-45
       translate <-7,0,71>
       }
     }
     
   #declare SearchLight3 =
    union { 
      cone { <-1,0,0>, .45
             <1,0,0>, .55  // Outer cone
             open
             pigment { color rgbt <.55, .55, .87, .73> }
             finish { ambient .75 }
        scale <.4,60,.4>
        rotate z*55
        translate <0,0,70>
       }
      cone { <-1,0,0>, .45
             <1,0,0>, .55  // Inner cone
             open
             pigment { color rgbt <2.6, 2.6, 3.8, .9> }
             finish { ambient .75 }
       scale <.2,60,.2>
       rotate z*55
       translate <0,0,70>
       }
     }
       
    object { SearchLight1 }
    object { SearchLight2 }
    object { SearchLight3 }
  
    
    cylinder {              // "Searchlight"
      <-1,0,0>, <1,0,0>, 1
        pigment { Black }
        finish { ambient .7 }
        scale .52
        rotate z*-40
        translate <17,-12,70>
       }
    
  
   #declare FieldLights =
     union {
       #local Count=0;
       #local Z=0;
       #while (Count < 12 )
         object {
           sphere { <0,0,-Z>, .05
             pigment { color rgb <9,9,.8> }
             finish { ambient .9 }
            }
           }
       #local Count=Count+1;
       #local Z=Z+2;
       #end
      }
      
   object { FieldLights
     rotate y*-10
     translate <5,-5,25>
    }
  
  
  #declare EiffelTower =
    union {
      object { Tower
        pigment { Black }
        scale <1.5,1,1>
        translate <13,-26.45,250>
       }
      #local Count1=0;
      #local Y=19;
      #while (Count1 < 6 )
        object {
          sphere { <13,-Y,250>, .1
            pigment { White }
            finish { ambient .7 }
           }
          }
      #local Count1=Count1+1;
      #local Y=Y+1;
      #end
      
      #local Count2=0;
      #local X1=12.7;
      #local X2=13.3;
      #local Y=20;
      #while (Count2 < 5 )
        object {
          sphere { <X1,-Y,250>, .1
            pigment { White }
            finish { ambient .7 }
           }
          }
        object {
          sphere { <X2,-Y,250>, .1
            pigment { White }
            finish { ambient .7 }
           }
          }
      #local Count2=Count2+1;
      #local X1=X1-.015;
      #local X2=X2+.015;
      #local Y=Y+1;
      #end
      
      #local Count3=0;
      #local X3=12.3;
      #local X4=13.7;
      #local Y=25;
      #while (Count3 < 3 )
        object {
          sphere { <X3,-Y,250>, .1
            pigment { White }
            finish { ambient .7 }
           }
          }
        object {
          sphere { <X4,-Y,250>, .1
            pigment { White }
            finish { ambient .7 }
           }
          }
      #local Count3=Count3+1;
      #local X3=X3-.3;
      #local X4=X4+.3;
      #local Y=Y+.75;
      #end
     }
  
   object {
     box { <-150,-150,0>, <150,150,0.1>
        texture {
         pigment {
           image_map {
             gif "skyline.gif"    // Paris skyline
             map_type 0
             once
             transmit 0, 1.0
            }
           }
          }
          translate <-.5,-.5,0>
          scale <150,100,1>
         }
         translate <0,-20.5,245>
        }
        
 
   object { Hangar 
     scale <4,4,5>
     rotate y*12
     translate <-6.5,-4.5,5>
    }
   
         
   object { EiffelTower }
   
  
 
   box { <-100,.1,-100>, <100,0,100>  /// Ground
    pigment { Gray10 }
    translate <0,-12,0>
   } 
  
 
   sky_sphere {
     pigment {
       gradient y
        pigment_map {
          [ 0.000 color MidnightBlue * 1.9 ] 
          [ 0.008 color MidnightBlue * 1.4 ]
          [ 0.020 color MidnightBlue * 1.3 ]
          [ 0.030 color MidnightBlue * 1.2 ]
          [ 0.050 color MidnightBlue * 1.1 ]
          [ 0.070 color MidnightBlue       ]
          [ 0.100 color Gray10             ]
          [ 0.200 color Black              ]
         }
        }
       scale <1,1,1>
       rotate x*5.5
      }


 /*
  cylinder {                   // x axis
      <50,0,0>, <-50,0,0> .009
      pigment { Red }
     }
 
    cylinder {                   // y axis
      <0,50,0>, <0,-50,0> .009
      pigment { Green }
     }
  
    cylinder {                   // z axis
      <0,0,50>, <0,0,-50> .009
      pigment { Blue }
     }
 */
 